/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.DisplayFrame;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.IconAdder;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.display.ToolTip;
import jmri.jmrit.display.palette.ItemPalette;
import jmri.jmrit.display.palette.ItemPanel;
import jmri.jmrit.display.palette.TextItemPanel;
import jmri.util.PlaceWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionableJPanel
extends JPanel
implements Positionable,
MouseListener,
MouseMotionListener {
    protected Editor _editor = null;
    private String _id;
    private ToolTip _tooltip;
    protected boolean _showTooltip = true;
    protected boolean _editable = true;
    protected boolean _positionable = true;
    protected boolean _viewCoordinates = false;
    protected boolean _controlling = true;
    protected boolean _hidden = false;
    protected int _displayLevel;
    private double _scale = 1.0;
    JMenuItem lock = null;
    JCheckBoxMenuItem showTooltipItem = null;
    TextItemPanel _itemPanel;
    public DisplayFrame _paletteFrame;
    JFrame _iconEditorFrame;
    IconAdder _iconEditor;
    boolean active = true;
    PositionablePopupUtil _popupUtil;
    private static final Logger log = LoggerFactory.getLogger(PositionableJPanel.class);

    public PositionableJPanel(Editor editor) {
        this._editor = editor;
    }

    @Override
    public Positionable deepClone() {
        PositionableJPanel pos = new PositionableJPanel(this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(PositionableJPanel pos) {
        pos.setLocation(this.getX(), this.getY());
        pos._displayLevel = this._displayLevel;
        pos._controlling = this._controlling;
        pos._hidden = this._hidden;
        pos._positionable = this._positionable;
        pos._showTooltip = this._showTooltip;
        pos.setToolTip(this.getToolTip());
        pos._editable = this._editable;
        if (this.getPopupUtility() == null) {
            pos.setPopupUtility(null);
        } else {
            pos.setPopupUtility(this.getPopupUtility().clone(pos, pos.getTextComponent()));
        }
        pos.updateSize();
        return pos;
    }

    @Override
    public void setId(String id) throws Positionable.DuplicateIdException {
        if (Objects.equals(this._id, id)) {
            return;
        }
        this._editor.positionalIdChange(this, id);
        this._id = id;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void setPositionable(boolean enabled) {
        this._positionable = enabled;
    }

    @Override
    public boolean isPositionable() {
        return this._positionable;
    }

    @Override
    public void setEditable(boolean enabled) {
        this._editable = enabled;
    }

    @Override
    public boolean isEditable() {
        return this._editable;
    }

    @Override
    public void setViewCoordinates(boolean enabled) {
        this._viewCoordinates = enabled;
    }

    @Override
    public boolean getViewCoordinates() {
        return this._viewCoordinates;
    }

    @Override
    public void setControlling(boolean enabled) {
        this._controlling = enabled;
    }

    @Override
    public boolean isControlling() {
        return this._controlling;
    }

    @Override
    public void setHidden(boolean hide) {
        this._hidden = hide;
    }

    @Override
    public boolean isHidden() {
        return this._hidden;
    }

    @Override
    public void showHidden() {
        if (!this._hidden || this._editor.isEditable()) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }

    public void setLevel(int l) {
        this._displayLevel = l;
    }

    @Override
    public void setDisplayLevel(int l) {
        int oldDisplayLevel = this._displayLevel;
        this._displayLevel = l;
        if (oldDisplayLevel != l) {
            log.debug("Changing label display level from {} to {}", (Object)oldDisplayLevel, (Object)this._displayLevel);
            this._editor.displayLevelChange(this);
        }
    }

    @Override
    public int getDisplayLevel() {
        return this._displayLevel;
    }

    @Override
    public void setShowToolTip(boolean set) {
        this._showTooltip = set;
    }

    @Override
    public boolean showToolTip() {
        return this._showTooltip;
    }

    @Override
    public void setToolTip(ToolTip tip) {
        this._tooltip = tip;
    }

    @Override
    public ToolTip getToolTip() {
        return this._tooltip;
    }

    @Override
    public void setScale(double s) {
        this._scale = s;
    }

    @Override
    public double getScale() {
        return this._scale;
    }

    @Override
    public void rotate(int deg) {
    }

    @Override
    public int getDegrees() {
        return 0;
    }

    @Override
    public JComponent getTextComponent() {
        return this;
    }

    @Override
    public String getNameString() {
        return this.getName();
    }

    @Override
    public Editor getEditor() {
        return this._editor;
    }

    @Override
    public void setEditor(Editor ed) {
        this._editor = ed;
    }

    public boolean setEditTextItemMenu(JPopupMenu popup) {
        popup.add(new AbstractAction(Bundle.getMessage("SetTextSizeColor")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PositionableJPanel.this.editTextItem();
            }
        });
        return true;
    }

    protected void editTextItem() {
        this._paletteFrame = this.makePaletteFrame(Bundle.getMessage("SetTextSizeColor"));
        this._itemPanel = new TextItemPanel(this._paletteFrame, "Text");
        ActionListener updateAction = a -> this.updateTextItem();
        this._itemPanel.init(updateAction, this);
        this.initPaletteFrame(this._paletteFrame, this._itemPanel);
    }

    protected void updateTextItem() {
        PositionablePopupUtil util = this._itemPanel.getPositionablePopupUtil();
        this._itemPanel.setAttributes(this);
        if (this._editor._selectionGroup != null) {
            this._editor.setSelectionsAttributes(util, this);
        } else {
            this._editor.setAttributes(util, this);
        }
        this.finishItemUpdate(this._paletteFrame, this._itemPanel);
    }

    public DisplayFrame makePaletteFrame(String title) {
        ItemPalette.loadIcons();
        return new DisplayFrame(title, this._editor);
    }

    public void initPaletteFrame(DisplayFrame paletteFrame, @Nonnull ItemPanel itemPanel) {
        Dimension dim = itemPanel.getPreferredSize();
        JScrollPane sp = new JScrollPane(itemPanel);
        dim = new Dimension(dim.width + 25, dim.height + 25);
        sp.setPreferredSize(dim);
        paletteFrame.add(sp);
        paletteFrame.pack();
        InstanceManager.getDefault(PlaceWindow.class).nextTo(this._editor, this, paletteFrame);
        paletteFrame.setVisible(true);
    }

    public void finishItemUpdate(DisplayFrame paletteFrame, @Nonnull ItemPanel itemPanel) {
        itemPanel.closeDialogs();
        paletteFrame.dispose();
        this.invalidate();
    }

    @Override
    public void doMousePressed(MouseEvent event) {
    }

    @Override
    public void doMouseReleased(MouseEvent event) {
    }

    @Override
    public void doMouseClicked(MouseEvent event) {
    }

    @Override
    public void doMouseDragged(MouseEvent event) {
    }

    @Override
    public void doMouseMoved(MouseEvent event) {
    }

    @Override
    public void doMouseEntered(MouseEvent event) {
    }

    @Override
    public void doMouseExited(MouseEvent event) {
    }

    @Override
    public boolean storeItem() {
        return true;
    }

    @Override
    public boolean doViemMenu() {
        return true;
    }

    @Override
    public boolean setRotateOrthogonalMenu(JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean setRotateMenu(JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean setScaleMenu(JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean setDisableControlMenu(JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean setTextEditMenu(JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean setEditIconMenu(JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean setEditItemMenu(JPopupMenu popup) {
        return this.setEditIconMenu(popup);
    }

    protected void makeIconEditorFrame(Container pos, String name, boolean table, IconAdder editor) {
        this._iconEditor = editor != null ? editor : new IconAdder(name);
        this._iconEditorFrame = this._editor.makeAddIconFrame(name, false, table, this._iconEditor);
        this._iconEditorFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PositionableJPanel.this._iconEditorFrame.dispose();
                PositionableJPanel.this._iconEditorFrame = null;
            }
        });
        this._iconEditorFrame.setLocationRelativeTo(pos);
        this._iconEditorFrame.toFront();
        this._iconEditorFrame.setVisible(true);
    }

    void edit() {
    }

    @Override
    public void remove() {
        this._editor.removeFromContents(this);
        this.cleanup();
        this.active = false;
    }

    void cleanup() {
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this._editor.mousePressed(new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiersEx(), e.getX() + this.getX(), e.getY() + this.getY(), e.getClickCount(), e.isPopupTrigger()));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this._editor.mouseReleased(new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiersEx(), e.getX() + this.getX(), e.getY() + this.getY(), e.getClickCount(), e.isPopupTrigger()));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this._editor.mouseClicked(new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiersEx(), e.getX() + this.getX(), e.getY() + this.getY(), e.getClickCount(), e.isPopupTrigger()));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this._editor.mouseExited(new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiersEx(), e.getX() + this.getX(), e.getY() + this.getY(), e.getClickCount(), e.isPopupTrigger()));
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this._editor.mouseEntered(new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiersEx(), e.getX() + this.getX(), e.getY() + this.getY(), e.getClickCount(), e.isPopupTrigger()));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this._editor.mouseMoved(new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiersEx(), e.getX() + this.getX(), e.getY() + this.getY(), e.getClickCount(), e.isPopupTrigger()));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this._editor.mouseDragged(new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiersEx(), e.getX() + this.getX(), e.getY() + this.getY(), e.getClickCount(), e.isPopupTrigger()));
    }

    @Override
    public void setPopupUtility(PositionablePopupUtil tu) {
        this._popupUtil = tu;
    }

    @Override
    public PositionablePopupUtil getPopupUtility() {
        return this._popupUtil;
    }

    @Override
    public void updateSize() {
        this.invalidate();
        this.setSize(this.maxWidth(), this.maxHeight());
        if (log.isTraceEnabled()) {
            log.trace("updateSize: {}, text: w={} h={}", new Object[]{this._popupUtil.toString(), this.getFontMetrics(this._popupUtil.getFont()).stringWidth(this._popupUtil.getText()), this.getFontMetrics(this._popupUtil.getFont()).getHeight()});
        }
        this.validate();
        this.repaint();
    }

    @Override
    public int maxWidth() {
        int max = 0;
        if (this._popupUtil != null) {
            if (this._popupUtil.getFixedWidth() != 0) {
                max = this._popupUtil.getFixedWidth();
                if ((max += this._popupUtil.getMargin() * 2) < 5) {
                    this._popupUtil.setFixedWidth(5);
                    max = 5;
                }
            } else {
                max = this.getPreferredSize().width;
                if ((max += this._popupUtil.getMargin() * 2) < 5) {
                    max = 5;
                }
            }
        }
        log.debug("maxWidth= {} preferred width= {}", (Object)max, (Object)this.getPreferredSize().width);
        return max;
    }

    @Override
    public int maxHeight() {
        int max = 0;
        if (this._popupUtil != null) {
            if (this._popupUtil.getFixedHeight() != 0) {
                max = this._popupUtil.getFixedHeight();
                if ((max += this._popupUtil.getMargin() * 2) < 5) {
                    this._popupUtil.setFixedHeight(5);
                    max = 5;
                }
            } else {
                max = this.getPreferredSize().height;
                if (this._popupUtil != null) {
                    max += this._popupUtil.getMargin() * 2;
                }
                if (max < 5) {
                    max = 5;
                }
            }
        }
        log.debug("maxHeight= {} preferred width= {}", (Object)max, (Object)this.getPreferredSize().height);
        return max;
    }

    @Override
    public NamedBean getNamedBean() {
        return null;
    }
}

