/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import jmri.NamedBean;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.display.ToolTip;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionableJComponent
extends JComponent
implements Positionable {
    protected Editor _editor = null;
    private String _id;
    private ToolTip _tooltip;
    private boolean _showTooltip = true;
    private boolean _editable = true;
    private boolean _positionable = true;
    private boolean _viewCoordinates = false;
    private boolean _controlling = true;
    private boolean _hidden = false;
    private int _displayLevel;
    private double _scale;
    JMenuItem lock = null;
    JCheckBoxMenuItem showTooltipItem = null;
    boolean active = true;
    private static final Logger log = LoggerFactory.getLogger(PositionableJComponent.class);

    public PositionableJComponent(Editor editor) {
        this._editor = editor;
        this._scale = 1.0;
    }

    @Override
    public Positionable deepClone() {
        PositionableJComponent pos = new PositionableJComponent(this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(PositionableJComponent pos) {
        pos.setLocation(this.getX(), this.getY());
        pos.setDisplayLevel(this.getDisplayLevel());
        pos.setControlling(this.isControlling());
        pos.setHidden(this.isHidden());
        pos.setPositionable(this.isPositionable());
        pos.setShowToolTip(this.showToolTip());
        pos.setToolTip(this.getToolTip());
        pos.setEditable(this.isEditable());
        pos.updateSize();
        return pos;
    }

    @Override
    public void setId(String id) throws Positionable.DuplicateIdException {
        if (Objects.equals(this._id, id)) {
            return;
        }
        this._editor.positionalIdChange(this, id);
        this._id = id;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public JComponent getTextComponent() {
        return this;
    }

    public void displayState() {
    }

    @Override
    public void setPositionable(boolean enabled) {
        this._positionable = enabled;
    }

    @Override
    public boolean isPositionable() {
        return this._positionable;
    }

    @Override
    public void setEditable(boolean enabled) {
        this._editable = enabled;
        this.showHidden();
    }

    @Override
    public boolean isEditable() {
        return this._editable;
    }

    @Override
    public void setViewCoordinates(boolean enabled) {
        this._viewCoordinates = enabled;
    }

    @Override
    public boolean getViewCoordinates() {
        return this._viewCoordinates;
    }

    @Override
    public void setControlling(boolean enabled) {
        this._controlling = enabled;
    }

    @Override
    public boolean isControlling() {
        return this._controlling;
    }

    @Override
    public void setHidden(boolean hide) {
        this._hidden = hide;
    }

    @Override
    public boolean isHidden() {
        return this._hidden;
    }

    @Override
    public void showHidden() {
        if (!this._hidden || this._editor.isEditable()) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }

    public void setLevel(int l) {
        this._displayLevel = l;
    }

    @Override
    public void setDisplayLevel(int l) {
        int oldDisplayLevel = this._displayLevel;
        this._displayLevel = l;
        if (oldDisplayLevel != l) {
            log.debug("Changing label display level from {} to {}", (Object)oldDisplayLevel, (Object)this._displayLevel);
            this._editor.displayLevelChange(this);
        }
    }

    @Override
    public int getDisplayLevel() {
        return this._displayLevel;
    }

    @Override
    public void setShowToolTip(boolean set) {
        this._showTooltip = set;
    }

    @Override
    public boolean showToolTip() {
        return this._showTooltip;
    }

    @Override
    public void setToolTip(ToolTip tip) {
        this._tooltip = tip;
    }

    @Override
    public ToolTip getToolTip() {
        return this._tooltip;
    }

    @Override
    public void setScale(double s) {
        this._scale = s;
    }

    @Override
    public double getScale() {
        return this._scale;
    }

    @Override
    public void rotate(int deg) {
    }

    @Override
    public int getDegrees() {
        return 0;
    }

    @Override
    public String getNameString() {
        return this.getName();
    }

    @Override
    public Editor getEditor() {
        return this._editor;
    }

    @Override
    public void setEditor(Editor ed) {
        this._editor = ed;
    }

    @Override
    public void doMousePressed(MouseEvent event) {
    }

    @Override
    public void doMouseReleased(MouseEvent event) {
    }

    @Override
    public void doMouseClicked(MouseEvent event) {
    }

    @Override
    public void doMouseDragged(MouseEvent event) {
    }

    @Override
    public void doMouseMoved(MouseEvent event) {
    }

    @Override
    public void doMouseEntered(MouseEvent event) {
    }

    @Override
    public void doMouseExited(MouseEvent event) {
    }

    @Override
    public boolean storeItem() {
        return true;
    }

    @Override
    public boolean doViemMenu() {
        return true;
    }

    @Override
    public boolean setRotateOrthogonalMenu(JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean setRotateMenu(JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean setScaleMenu(JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean setDisableControlMenu(JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean setTextEditMenu(JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean setEditItemMenu(JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean setEditIconMenu(JPopupMenu popup) {
        return false;
    }

    @Override
    public PositionablePopupUtil getPopupUtility() {
        return null;
    }

    @Override
    public void setPopupUtility(PositionablePopupUtil tu) {
    }

    @Override
    public void updateSize() {
    }

    @Override
    public int maxWidth() {
        return this.getWidth();
    }

    @Override
    public int maxHeight() {
        return this.getHeight();
    }

    @Override
    public void remove() {
        this._editor.removeFromContents(this);
        this.cleanup();
        this.active = false;
    }

    void cleanup() {
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public NamedBean getNamedBean() {
        return null;
    }
}

