/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.SortedSet;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import jmri.InstanceManager;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.EditorActionFactory;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.PanelDeleteAction;
import jmri.jmrit.display.layoutEditor.LayoutEditor;

public class PanelMenu
extends JMenu {
    private JMenu panelsSubMenu = null;
    private JMenuItem noPanelsItem = null;
    private final PropertyChangeListener listener = this::updateMenu;

    public PanelMenu() {
        super.setText(Bundle.getMessage("MenuPanels"));
        JMenu newPanel = new JMenu(Bundle.getMessage("MenuItemNew"));
        StreamSupport.stream(ServiceLoader.load(EditorActionFactory.class).spliterator(), false).sorted(Comparator.comparing(EditorActionFactory::getTitle)).forEach(factory -> {
            JMenuItem jMenuItem = newPanel.add(factory.createAction());
        });
        super.add(newPanel);
        this.panelsSubMenu = new JMenu(Bundle.getMessage("MenuShowPanel"));
        this.noPanelsItem = new JMenuItem(Bundle.getMessage("MenuItemNoPanels"));
        this.noPanelsItem.setEnabled(false);
        this.panelsSubMenu.add(this.noPanelsItem);
        super.add(this.panelsSubMenu);
        super.add(new PanelDeleteAction(Bundle.getMessage("MenuItemDeletePanel")));
        InstanceManager.getDefault(EditorManager.class).addPropertyChangeListener(this.listener);
        this.updateMenu(null);
    }

    private void updateMenu(@CheckForNull PropertyChangeEvent evt) {
        SortedSet<Editor> editors = InstanceManager.getDefault(EditorManager.class).getAll();
        this.panelsSubMenu.removeAll();
        if (editors.isEmpty()) {
            this.panelsSubMenu.add(this.noPanelsItem);
            this.getItem(2).setEnabled(false);
        } else {
            this.getItem(2).setEnabled(true);
            editors.forEach(editor -> {
                JMenuItem menuItem = new JMenuItem(editor.getTitle());
                ActionListener action = event -> {
                    editor.getTargetFrame().setVisible(true);
                    editor.getTargetFrame().repaint();
                };
                menuItem.addActionListener(action);
                this.panelsSubMenu.add(menuItem);
            });
        }
    }

    @Deprecated
    public int getNumberOfPanels() {
        return InstanceManager.getDefault(EditorManager.class).getAll().size();
    }

    @Deprecated
    public void deletePanel(Editor panel) {
        this.updateMenu(null);
    }

    @Deprecated
    public void addEditorPanel(Editor panel) {
        this.updateMenu(null);
    }

    @Deprecated
    public void updateEditorPanel(Editor panel) {
        this.updateMenu(null);
    }

    @Deprecated
    public void renameEditorPanel(Editor panel) {
        this.updateMenu(null);
    }

    @Deprecated
    public boolean isPanelNameUsed(String name) {
        return InstanceManager.getDefault(EditorManager.class).contains(name);
    }

    @Deprecated
    public Editor getEditorByName(String name) {
        return InstanceManager.getDefault(EditorManager.class).get(name);
    }

    @Deprecated
    public ArrayList<Editor> getEditorPanelList() {
        return new ArrayList<Editor>(InstanceManager.getDefault(EditorManager.class).getAll());
    }

    @Deprecated
    public ArrayList<LayoutEditor> getLayoutEditorPanelList() {
        return new ArrayList<LayoutEditor>(InstanceManager.getDefault(EditorManager.class).getAll(LayoutEditor.class));
    }
}

