/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.SortedSet;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import jmri.InstanceManager;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.panelEditor.PanelEditor;
import jmri.jmrit.display.switchboardEditor.SwitchboardEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanelDeleteAction
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(PanelDeleteAction.class);

    public PanelDeleteAction(String name) {
        super(name);
    }

    public PanelDeleteAction() {
        super("Delete Panel ...");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SortedSet<Editor> editors = InstanceManager.getDefault(EditorManager.class).getAll();
        if (editors.isEmpty()) {
            log.warn("PanelDeleteAction::actionPerformed nothing to delete");
        } else {
            Editor selected;
            ArrayList panelNames = new ArrayList();
            editors.forEach(editor -> panelNames.add(editor.getTitle()));
            String panelName = (String)JOptionPane.showInputDialog(null, Bundle.getMessage("PanelDeleteMessage"), Bundle.getMessage("PanelDeleteTitle"), -1, null, panelNames.toArray(), null);
            if (panelName != null && !panelName.isEmpty() && (selected = InstanceManager.getDefault(EditorManager.class).get(panelName)) != null) {
                if (selected instanceof PanelEditor || selected instanceof SwitchboardEditor) {
                    selected.getTargetFrame().dispose();
                }
                selected.dispose();
            }
        }
    }
}

