/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableJPanel;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.picker.PickListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemorySpinnerIcon
extends PositionableJPanel
implements ChangeListener,
PropertyChangeListener {
    int _min = 0;
    int _max = 100;
    JSpinner spinner = new JSpinner(new SpinnerNumberModel(0, this._min, this._max, 1));
    private NamedBeanHandle<Memory> namedMemory;
    private static final Logger log = LoggerFactory.getLogger(MemorySpinnerIcon.class);

    public MemorySpinnerIcon(Editor editor) {
        super(editor);
        this.setDisplayLevel(4);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.spinner, new GridBagConstraints());
        this.spinner.addChangeListener(this);
        JFormattedTextField textBox = ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
        textBox.addMouseMotionListener(this);
        textBox.addMouseListener(this);
        this.setPopupUtility(new PositionablePopupUtil(this, textBox));
    }

    @Override
    public Positionable deepClone() {
        MemorySpinnerIcon pos = new MemorySpinnerIcon(this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(MemorySpinnerIcon pos) {
        pos.setMemory(this.namedMemory.getName());
        return super.finishClone(pos);
    }

    @Override
    public JComponent getTextComponent() {
        return ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
    }

    @Override
    public Dimension getSize() {
        if (log.isDebugEnabled()) {
            Dimension d = this.spinner.getSize();
            log.debug("spinner width= {}, height= {}", (Object)d.width, (Object)d.height);
            Rectangle rect = this.getBounds(null);
            log.debug("Bounds rect= ({},{}) width= {}, height= {}", new Object[]{rect.x, rect.y, rect.width, rect.height});
            d = super.getSize();
            log.debug("Panel width= {}, height= {}", (Object)d.width, (Object)d.height);
        }
        return super.getSize();
    }

    public void setMemory(String pName) {
        log.debug("setMemory for memory= {}", (Object)pName);
        if (InstanceManager.getNullableDefault(MemoryManager.class) != null) {
            try {
                Memory memory = InstanceManager.memoryManagerInstance().provideMemory(pName);
                this.setMemory(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, memory));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error("Memory '{}' not available, icon won't see changes", (Object)pName);
            }
        } else {
            log.error("No MemoryManager for this protocol, icon won't see changes");
        }
        this.updateSize();
    }

    public void setMemory(NamedBeanHandle<Memory> m) {
        if (this.namedMemory != null) {
            this.getMemory().removePropertyChangeListener(this);
        }
        this.namedMemory = m;
        if (this.namedMemory != null) {
            this.getMemory().addPropertyChangeListener(this, this.namedMemory.getName(), "Memory Spinner Icon");
            this.displayState();
            this.setName(this.namedMemory.getName());
        }
    }

    public NamedBeanHandle<Memory> getNamedMemory() {
        return this.namedMemory;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("value")) {
            this.displayState();
        }
    }

    public Memory getMemory() {
        if (this.namedMemory == null) {
            return null;
        }
        return this.namedMemory.getBean();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.spinnerUpdated();
    }

    @Override
    public String getNameString() {
        String name = this.namedMemory == null ? Bundle.getMessage("NotConnected") : this.getMemory().getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        return name;
    }

    @Override
    public boolean setEditIconMenu(JPopupMenu popup) {
        String txt = MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("BeanNameMemory"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemorySpinnerIcon.this.edit();
            }
        });
        return true;
    }

    @Override
    protected void edit() {
        this.makeIconEditorFrame(this, "Memory", true, null);
        this._iconEditor.setPickList(PickListModel.memoryPickModelInstance());
        ActionListener addIconAction = a -> this.editMemory();
        this._iconEditor.complete(addIconAction, false, true, true);
        this._iconEditor.setSelection(this.getMemory());
    }

    void editMemory() {
        this.setMemory(this._iconEditor.getTableSelection().getDisplayName());
        this.setSize(this.getPreferredSize().width, this.getPreferredSize().height);
        this._iconEditorFrame.dispose();
        this._iconEditorFrame = null;
        this._iconEditor = null;
        this.invalidate();
    }

    public void displayState() {
        log.debug("displayState");
        if (this.namedMemory == null) {
            return;
        }
        if (this.getMemory().getValue() == null) {
            return;
        }
        Integer num = null;
        if (this.getMemory().getValue().getClass() == String.class) {
            try {
                num = Integer.valueOf((String)this.getMemory().getValue());
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        } else if (this.getMemory().getValue().getClass() == Integer.class) {
            num = ((Number)this.getMemory().getValue()).intValue();
        } else if (this.getMemory().getValue().getClass() == Float.class) {
            num = Math.round(((Float)this.getMemory().getValue()).floatValue());
            log.debug("num= {}", (Object)num);
        } else {
            return;
        }
        int n = num;
        if (n > this._max) {
            num = this._max;
        } else if (n < this._min) {
            num = this._min;
        }
        this.spinner.setValue(num);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.spinnerUpdated();
        super.mouseExited(e);
    }

    protected void spinnerUpdated() {
        if (this.namedMemory == null) {
            return;
        }
        if (this.getMemory().getValue() == null) {
            this.getMemory().setValue(this.spinner.getValue());
            return;
        }
        if (this.getMemory().getValue().getClass() == String.class) {
            String newValue = "" + this.spinner.getValue();
            if (!this.getMemory().getValue().equals(newValue)) {
                this.getMemory().setValue(newValue);
            }
        } else {
            this.getMemory().setValue(this.spinner.getValue());
        }
    }

    public String getValue() {
        return "" + this.spinner.getValue();
    }

    @Override
    void cleanup() {
        if (this.namedMemory != null) {
            this.getMemory().removePropertyChangeListener(this);
        }
        if (this.spinner != null) {
            this.spinner.removeChangeListener(this);
            ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().removeMouseMotionListener(this);
            ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().removeMouseListener(this);
        }
        this.namedMemory = null;
    }
}

