/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import javax.annotation.Nonnull;
import javax.swing.JPopupMenu;
import jmri.JmriException;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.CoordinateEdit;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.LinkingObject;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.util.HelpUtil;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkingLabel
extends PositionableLabel
implements LinkingObject {
    String url;
    private static final Logger log = LoggerFactory.getLogger(LinkingLabel.class);

    public LinkingLabel(@Nonnull String s, @Nonnull Editor editor, @Nonnull String url) {
        super(s, editor);
        this.url = url;
        this.setPopupUtility(new PositionablePopupUtil(this, this));
    }

    public LinkingLabel(NamedIcon s, @Nonnull Editor editor, @Nonnull String url) {
        super(s, editor);
        this.url = url;
        this.setPopupUtility(new PositionablePopupUtil(this, this));
    }

    @Override
    public Positionable deepClone() {
        LinkingLabel pos;
        if (this._icon) {
            NamedIcon icon = new NamedIcon((NamedIcon)this.getIcon());
            pos = new LinkingLabel(icon, this._editor, this.url);
        } else {
            pos = new LinkingLabel(this._unRotatedText, this._editor, this.url);
        }
        return this.finishClone((PositionableLabel)pos);
    }

    protected Positionable finishClone(LinkingLabel pos) {
        return super.finishClone(pos);
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void setULRL(String u) {
        this.url = u;
    }

    @Override
    public boolean setLinkMenu(JPopupMenu popup) {
        popup.add(CoordinateEdit.getLinkEditAction(this, "EditLink"));
        return true;
    }

    @Override
    public void doMouseClicked(MouseEvent event) {
        log.debug("click to {}", (Object)this.url);
        try {
            if (this.url.startsWith("frame:")) {
                String frame = this.url.substring(6);
                JmriJFrame jframe = JmriJFrame.getFrame(frame);
                if (jframe != null) {
                    EventQueue.invokeLater(() -> {
                        if (jframe.getExtendedState() == 1) {
                            jframe.setExtendedState(0);
                        }
                        jframe.toFront();
                        jframe.repaint();
                    });
                } else {
                    log.error("Frame '{}' not found, cannot link to it.", (Object)frame);
                }
            } else if (this.url.length() > 0) {
                HelpUtil.openWebPage(this.url);
            }
        }
        catch (JmriException t) {
            log.error("Error handling link", (Throwable)t);
        }
        super.doMouseClicked(event);
    }
}

