/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jmri.InstanceManager;
import jmri.Light;
import jmri.LightManager;
import jmri.NamedBean;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.picker.PickListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightIcon
extends PositionableLabel
implements PropertyChangeListener {
    Light light = null;
    String offLName = "resources/icons/smallschematics/lights/cross-on.png";
    NamedIcon off = new NamedIcon(this.offLName, this.offLName);
    String onLName = "resources/icons/smallschematics/lights/cross-off.png";
    NamedIcon on = new NamedIcon(this.onLName, this.onLName);
    String inconsistentLName = "resources/icons/smallschematics/lights/cross-inconsistent.png";
    NamedIcon inconsistent = new NamedIcon(this.inconsistentLName, this.inconsistentLName);
    String unknownLName = "resources/icons/smallschematics/lights/cross-unknown.png";
    NamedIcon unknown = new NamedIcon(this.unknownLName, this.unknownLName);
    private static final Logger log = LoggerFactory.getLogger(LightIcon.class);

    public LightIcon(Editor editor) {
        super(new NamedIcon("resources/icons/smallschematics/lights/cross-on.png", "resources/icons/smallschematics/lights/cross-off.png"), editor);
        this._control = true;
        this.displayState(this.lightState());
        this.setPopupUtility(null);
    }

    @Override
    public Positionable deepClone() {
        LightIcon pos = new LightIcon(this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(LightIcon pos) {
        pos.setLight(this.getNameString());
        pos.setOffIcon(LightIcon.cloneIcon(this.getOffIcon(), pos));
        pos.setOnIcon(LightIcon.cloneIcon(this.getOnIcon(), pos));
        pos.setInconsistentIcon(LightIcon.cloneIcon(this.getInconsistentIcon(), pos));
        pos.setUnknownIcon(LightIcon.cloneIcon(this.getUnknownIcon(), pos));
        return super.finishClone(pos);
    }

    public void setLight(String pName) {
        if (InstanceManager.getNullableDefault(LightManager.class) != null) {
            this.light = InstanceManager.lightManagerInstance().provideLight(pName);
            this.setLight(this.light);
        } else {
            log.error("No LightManager for this protocol, icon won't see changes");
        }
    }

    public void setLight(Light to) {
        if (this.light != null) {
            this.light.removePropertyChangeListener(this);
        }
        this.light = to;
        if (this.light != null) {
            this.displayState(this.lightState());
            this.light.addPropertyChangeListener(this);
        }
    }

    public Light getLight() {
        return this.light;
    }

    public NamedIcon getOffIcon() {
        return this.off;
    }

    public void setOffIcon(NamedIcon i) {
        this.off = i;
        this.displayState(this.lightState());
    }

    public NamedIcon getOnIcon() {
        return this.on;
    }

    public void setOnIcon(NamedIcon i) {
        this.on = i;
        this.displayState(this.lightState());
    }

    public NamedIcon getInconsistentIcon() {
        return this.inconsistent;
    }

    public void setInconsistentIcon(NamedIcon i) {
        this.inconsistent = i;
        this.displayState(this.lightState());
    }

    public NamedIcon getUnknownIcon() {
        return this.unknown;
    }

    public void setUnknownIcon(NamedIcon i) {
        this.unknown = i;
        this.displayState(this.lightState());
    }

    @Override
    public int maxHeight() {
        return Math.max(Math.max(this.off != null ? this.off.getIconHeight() : 0, this.on != null ? this.on.getIconHeight() : 0), this.inconsistent != null ? this.inconsistent.getIconHeight() : 0);
    }

    @Override
    public int maxWidth() {
        return Math.max(Math.max(this.off != null ? this.off.getIconWidth() : 0, this.on != null ? this.on.getIconWidth() : 0), this.inconsistent != null ? this.inconsistent.getIconWidth() : 0);
    }

    int lightState() {
        if (this.light != null) {
            return this.light.getState();
        }
        return 8;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("property change: {} {} is now {}", new Object[]{this.getNameString(), e.getPropertyName(), e.getNewValue()});
        }
        if (e.getPropertyName().equals("KnownState")) {
            int now = (Integer)e.getNewValue();
            this.displayState(now);
        }
    }

    @Override
    public String getNameString() {
        String name = this.light == null ? Bundle.getMessage("NotConnected") : this.light.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        return name;
    }

    @Override
    protected void rotateOrthogonal() {
        this.off.setRotation(this.on.getRotation() + 1, this);
        this.on.setRotation(this.off.getRotation() + 1, this);
        this.unknown.setRotation(this.unknown.getRotation() + 1, this);
        this.inconsistent.setRotation(this.inconsistent.getRotation() + 1, this);
        this.displayState(this.lightState());
        this.repaint();
    }

    @Override
    public void setScale(double s) {
        this.off.scale(s, this);
        this.on.scale(s, this);
        this.unknown.scale(s, this);
        this.inconsistent.scale(s, this);
        this.displayState(this.lightState());
    }

    @Override
    public void rotate(int deg) {
        this.off.rotate(deg, this);
        this.on.rotate(deg, this);
        this.unknown.rotate(deg, this);
        this.inconsistent.rotate(deg, this);
        this.displayState(this.lightState());
    }

    @Override
    protected void edit() {
        this.makeIconEditorFrame(this, "Light", true, null);
        this._iconEditor.setPickList(PickListModel.lightPickModelInstance());
        this._iconEditor.setIcon(3, "StateOff", this.off);
        this._iconEditor.setIcon(2, "StateOn", this.on);
        this._iconEditor.setIcon(0, "BeanStateInconsistent", this.inconsistent);
        this._iconEditor.setIcon(1, "BeanStateUnknown", this.unknown);
        this._iconEditor.makeIconPanel(false);
        ActionListener addIconAction = a -> this.updateLight();
        this._iconEditor.complete(addIconAction, true, true, true);
        this._iconEditor.setSelection(this.light);
    }

    void updateLight() {
        this.setOffIcon(this._iconEditor.getIcon("StateOff"));
        this.setOnIcon(this._iconEditor.getIcon("StateOn"));
        this.setUnknownIcon(this._iconEditor.getIcon("BeanStateUnknown"));
        this.setInconsistentIcon(this._iconEditor.getIcon("BeanStateInconsistent"));
        this.setLight((Light)this._iconEditor.getTableSelection());
        this._iconEditorFrame.dispose();
        this._iconEditorFrame = null;
        this._iconEditor = null;
        this.invalidate();
    }

    void displayState(int state) {
        log.debug("{} displayState {}", (Object)this.getNameString(), (Object)state);
        this.updateSize();
        switch (state) {
            case 4: {
                if (this.isText()) {
                    super.setText(InstanceManager.turnoutManagerInstance().getClosedText());
                }
                if (!this.isIcon()) break;
                super.setIcon(this.off);
                break;
            }
            case 2: {
                if (this.isText()) {
                    super.setText(InstanceManager.turnoutManagerInstance().getThrownText());
                }
                if (!this.isIcon()) break;
                super.setIcon(this.on);
                break;
            }
            default: {
                if (this.isText()) {
                    super.setText(Bundle.getMessage("BeanStateInconsistent"));
                }
                if (!this.isIcon()) break;
                super.setIcon(this.inconsistent);
            }
        }
    }

    @Override
    public void doMouseClicked(MouseEvent e) {
        if (!this._editor.getFlag(2, this.isControlling())) {
            return;
        }
        if (e.isMetaDown() || e.isAltDown()) {
            return;
        }
        if (this.light == null) {
            log.error("No light connection, can't process click");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("doMouseClicked state= {}", (Object)this.light.getState());
        }
        if (this.light.getState() == 4) {
            this.light.setState(2);
        } else {
            this.light.setState(4);
        }
    }

    @Override
    public void dispose() {
        if (this.light != null) {
            this.light.removePropertyChangeListener(this);
        }
        this.light = null;
        this.off = null;
        this.on = null;
        this.inconsistent = null;
        this.unknown = null;
        super.dispose();
    }
}

