/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.Turnout;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.IndicatorTrack;
import jmri.jmrit.display.IndicatorTrackPaths;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.ToolTip;
import jmri.jmrit.display.TurnoutIcon;
import jmri.jmrit.display.palette.IndicatorTOItemPanel;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.picker.PickListModel;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndicatorTurnoutIcon
extends TurnoutIcon
implements IndicatorTrack {
    HashMap<String, HashMap<Integer, NamedIcon>> _iconMaps;
    private NamedBeanHandle<Sensor> namedOccSensor = null;
    private NamedBeanHandle<OBlock> namedOccBlock = null;
    private IndicatorTrackPaths _pathUtil;
    private IndicatorTOItemPanel _itemPanel;
    private String _status;
    private static final Logger log = LoggerFactory.getLogger(IndicatorTurnoutIcon.class);

    public IndicatorTurnoutIcon(Editor editor) {
        super(editor);
        log.debug("IndicatorTurnoutIcon ctor: isIcon()= {}, isText()= {}", (Object)this.isIcon(), (Object)this.isText());
        this._pathUtil = new IndicatorTrackPaths();
        this._status = "DontUseTrack";
        this._iconMaps = IndicatorTurnoutIcon.initMaps();
    }

    static HashMap<String, HashMap<Integer, NamedIcon>> initMaps() {
        HashMap<String, HashMap<Integer, NamedIcon>> iconMaps = new HashMap<String, HashMap<Integer, NamedIcon>>();
        iconMaps.put("ClearTrack", new HashMap());
        iconMaps.put("OccupiedTrack", new HashMap());
        iconMaps.put("PositionTrack", new HashMap());
        iconMaps.put("AllocatedTrack", new HashMap());
        iconMaps.put("DontUseTrack", new HashMap());
        iconMaps.put("ErrorTrack", new HashMap());
        return iconMaps;
    }

    HashMap<String, HashMap<Integer, NamedIcon>> cloneMaps(IndicatorTurnoutIcon pos) {
        HashMap<String, HashMap<Integer, NamedIcon>> iconMaps = IndicatorTurnoutIcon.initMaps();
        for (Map.Entry<String, HashMap<Integer, NamedIcon>> entry : this._iconMaps.entrySet()) {
            HashMap<Integer, NamedIcon> clone = iconMaps.get(entry.getKey());
            for (Map.Entry<Integer, NamedIcon> ent : entry.getValue().entrySet()) {
                clone.put(ent.getKey(), IndicatorTurnoutIcon.cloneIcon(ent.getValue(), pos));
            }
        }
        return iconMaps;
    }

    @Override
    public Positionable deepClone() {
        IndicatorTurnoutIcon pos = new IndicatorTurnoutIcon(this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(IndicatorTurnoutIcon pos) {
        pos.setOccBlockHandle(this.namedOccBlock);
        pos.setOccSensorHandle(this.namedOccSensor);
        pos._iconMaps = this.cloneMaps(pos);
        pos._pathUtil = this._pathUtil.deepClone();
        pos._iconFamily = this._iconFamily;
        return super.finishClone(pos);
    }

    public HashMap<String, HashMap<Integer, NamedIcon>> getIconMaps() {
        return new HashMap<String, HashMap<Integer, NamedIcon>>(this._iconMaps);
    }

    @Override
    public void setOccSensor(String pName) {
        if (pName == null || pName.trim().length() == 0) {
            this.setOccSensorHandle(null);
            return;
        }
        if (InstanceManager.getNullableDefault(SensorManager.class) != null) {
            try {
                Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(pName);
                this.setOccSensorHandle(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, sensor));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error("Occupancy Sensor '{}' not available, icon won't see changes", (Object)pName);
            }
        } else {
            log.error("No SensorManager for this protocol, block icons won't see changes");
        }
    }

    @Override
    public void setOccSensorHandle(NamedBeanHandle<Sensor> sen) {
        if (this.namedOccSensor != null) {
            this.getOccSensor().removePropertyChangeListener(this);
        }
        this.namedOccSensor = sen;
        if (this.namedOccSensor != null) {
            Sensor sensor = this.getOccSensor();
            sensor.addPropertyChangeListener(this, this.namedOccSensor.getName(), "Indicator Turnout Icon");
            this._status = this._pathUtil.getStatus(sensor.getKnownState());
            if (this._iconMaps != null) {
                this.displayState(this.turnoutState());
            }
        }
    }

    @Override
    public Sensor getOccSensor() {
        if (this.namedOccSensor == null) {
            return null;
        }
        return this.namedOccSensor.getBean();
    }

    @Override
    public NamedBeanHandle<Sensor> getNamedOccSensor() {
        return this.namedOccSensor;
    }

    @Override
    public void setOccBlock(String pName) {
        if (pName == null || pName.trim().length() == 0) {
            this.setOccBlockHandle(null);
            return;
        }
        OBlock block = InstanceManager.getDefault(OBlockManager.class).getOBlock(pName);
        if (block != null) {
            this.setOccBlockHandle(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, block));
        } else {
            log.error("Detection OBlock '{}' not available, icon won't see changes", (Object)pName);
        }
    }

    @Override
    public void setOccBlockHandle(NamedBeanHandle<OBlock> blockHandle) {
        if (this.namedOccBlock != null) {
            this.getOccBlock().removePropertyChangeListener(this);
        }
        this.namedOccBlock = blockHandle;
        if (this.namedOccBlock != null) {
            OBlock block = this.getOccBlock();
            block.addPropertyChangeListener(this, this.namedOccBlock.getName(), "Indicator Turnout Icon");
            this.setStatus(block, block.getState());
            if (this._iconMaps != null) {
                this.displayState(this.turnoutState());
            }
            this.setToolTip(new ToolTip(block.getDescription(), 0, 0));
        } else {
            this.setToolTip(new ToolTip(null, 0, 0));
        }
    }

    @Override
    public OBlock getOccBlock() {
        if (this.namedOccBlock == null) {
            return null;
        }
        return this.namedOccBlock.getBean();
    }

    @Override
    public NamedBeanHandle<OBlock> getNamedOccBlock() {
        return this.namedOccBlock;
    }

    @Override
    public void setShowTrain(boolean set) {
        this._pathUtil.setShowTrain(set);
    }

    @Override
    public boolean showTrain() {
        return this._pathUtil.showTrain();
    }

    @Override
    public ArrayList<String> getPaths() {
        return this._pathUtil.getPaths();
    }

    public void setPaths(ArrayList<String> paths) {
        this._pathUtil.setPaths(paths);
    }

    @Override
    public void addPath(String path) {
        this._pathUtil.addPath(path);
    }

    @Override
    public void removePath(String path) {
        this._pathUtil.removePath(path);
    }

    @Override
    public void setStatus(int state) {
        this._status = this._pathUtil.getStatus(state);
    }

    public void setIcon(String status, String stateName, NamedIcon icon) {
        if (log.isDebugEnabled()) {
            log.debug("setIcon for status \"{}\", stateName= \"{} icom= {}", new Object[]{status, stateName, icon.getURL()});
        }
        if (this._iconMaps == null) {
            this._iconMaps = IndicatorTurnoutIcon.initMaps();
        }
        this._iconMaps.get(status).put((Integer)this._name2stateMap.get(stateName), icon);
        this.setIcon(this._iconMaps.get("ClearTrack").get(this._name2stateMap.get("BeanStateInconsistent")));
    }

    public NamedIcon getIcon(String status, int state) {
        log.debug("getIcon: status= {}, state= {}", (Object)status, (Object)state);
        HashMap<Integer, NamedIcon> map = this._iconMaps.get(status);
        if (map == null) {
            return null;
        }
        return map.get(state);
    }

    public String getStateName(Integer state) {
        return (String)this._state2nameMap.get(state);
    }

    public String getStatus() {
        return this._status;
    }

    @Override
    public int maxHeight() {
        int max = 0;
        if (this._iconMaps != null) {
            for (HashMap<Integer, NamedIcon> integerNamedIconHashMap : this._iconMaps.values()) {
                for (NamedIcon namedIcon : integerNamedIconHashMap.values()) {
                    max = Math.max(namedIcon.getIconHeight(), max);
                }
            }
        }
        return max;
    }

    @Override
    public int maxWidth() {
        int max = 0;
        if (this._iconMaps != null) {
            for (HashMap<Integer, NamedIcon> integerNamedIconHashMap : this._iconMaps.values()) {
                for (NamedIcon namedIcon : integerNamedIconHashMap.values()) {
                    max = Math.max(namedIcon.getIconWidth(), max);
                }
            }
        }
        return max;
    }

    @Override
    protected void rotateOrthogonal() {
        if (this._iconMaps != null) {
            for (HashMap<Integer, NamedIcon> integerNamedIconHashMap : this._iconMaps.values()) {
                for (NamedIcon icon : integerNamedIconHashMap.values()) {
                    icon.setRotation(icon.getRotation() + 1, this);
                }
            }
        }
        this.displayState(this.turnoutState());
    }

    @Override
    public void setScale(double s) {
        this._scale = s;
        if (this._iconMaps != null) {
            for (HashMap<Integer, NamedIcon> integerNamedIconHashMap : this._iconMaps.values()) {
                for (NamedIcon namedIcon : integerNamedIconHashMap.values()) {
                    namedIcon.scale(s, this);
                }
            }
        }
        this.displayState(this.turnoutState());
    }

    @Override
    public void rotate(int deg) {
        if (this._iconMaps != null) {
            for (HashMap<Integer, NamedIcon> integerNamedIconHashMap : this._iconMaps.values()) {
                for (NamedIcon namedIcon : integerNamedIconHashMap.values()) {
                    namedIcon.rotate(deg, this);
                }
            }
        }
        this.setDegrees(deg % 360);
        this.displayState(this.turnoutState());
    }

    @Override
    public void displayState(int state) {
        NamedIcon icon;
        if (this.getNamedTurnout() == null) {
            log.debug("Display state {}, disconnected", (Object)state);
        } else if (this._status != null && this._iconMaps != null && (icon = this.getIcon(this._status, state)) != null) {
            super.setIcon(icon);
        }
        super.displayState(state);
        this.updateSize();
    }

    @Override
    public String getNameString() {
        String str = "";
        if (this.namedOccBlock != null) {
            str = " in " + this.namedOccBlock.getBean().getDisplayName();
        } else if (this.namedOccSensor != null) {
            str = " on " + this.namedOccSensor.getBean().getDisplayName();
        }
        return "ITrack " + super.getNameString() + str;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source;
        if (log.isDebugEnabled()) {
            log.debug("property change: {} property \"{}\"= {} from {}", new Object[]{this.getNameString(), evt.getPropertyName(), evt.getNewValue(), evt.getSource().getClass().getName()});
        }
        if ((source = evt.getSource()) instanceof Turnout) {
            super.propertyChange(evt);
        } else if (source instanceof OBlock) {
            String property = evt.getPropertyName();
            if ("state".equals(property) || "pathState".equals(property)) {
                int now = (Integer)evt.getNewValue();
                this.setStatus((OBlock)source, now);
            } else if ("pathName".equals(property)) {
                this._pathUtil.removePath((String)evt.getOldValue());
                this._pathUtil.addPath((String)evt.getNewValue());
            }
        } else if (source instanceof Sensor && evt.getPropertyName().equals("KnownState")) {
            int now = (Integer)evt.getNewValue();
            if (source.equals(this.getOccSensor())) {
                this._status = this._pathUtil.getStatus(now);
            }
        }
        this.displayState(this.turnoutState());
    }

    private void setStatus(OBlock block, int state) {
        this._status = this._pathUtil.getStatus(block, state);
        if ((state & 0x22) != 0) {
            ThreadingUtil.runOnLayoutEventually(() -> {
                this._pathUtil.setLocoIcon(block, this.getLocation(), this.getSize(), this._editor);
                this.repaint();
            });
        }
        if ((block.getState() & 0x40) != 0) {
            this.setControlling(false);
        } else {
            this.setControlling(true);
        }
    }

    @Override
    protected void editItem() {
        this._paletteFrame = this.makePaletteFrame(MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("IndicatorTO")));
        this._itemPanel = new IndicatorTOItemPanel(this._paletteFrame, "IndicatorTO", this._iconFamily, PickListModel.turnoutPickModelInstance());
        ActionListener updateAction = a -> this.updateItem();
        HashMap<String, HashMap<String, NamedIcon>> iconMaps = new HashMap<String, HashMap<String, NamedIcon>>();
        iconMaps.put("ClearTrack", new HashMap());
        iconMaps.put("OccupiedTrack", new HashMap());
        iconMaps.put("PositionTrack", new HashMap());
        iconMaps.put("AllocatedTrack", new HashMap());
        iconMaps.put("DontUseTrack", new HashMap());
        iconMaps.put("ErrorTrack", new HashMap());
        for (Map.Entry<String, HashMap<Integer, NamedIcon>> entry : this._iconMaps.entrySet()) {
            HashMap<String, NamedIcon> clone = iconMaps.get(entry.getKey());
            for (Map.Entry<Integer, NamedIcon> ent : entry.getValue().entrySet()) {
                NamedIcon oldIcon = ent.getValue();
                NamedIcon newIcon = IndicatorTurnoutIcon.cloneIcon(oldIcon, this);
                newIcon.rotate(0, this);
                newIcon.scale(1.0, this);
                newIcon.setRotation(4, this);
                clone.put((String)this._state2nameMap.get(ent.getKey()), newIcon);
            }
        }
        this._itemPanel.initUpdate(updateAction, iconMaps);
        if (this.namedOccSensor != null) {
            this._itemPanel.setOccDetector(this.namedOccSensor.getBean().getDisplayName());
        }
        if (this.namedOccBlock != null) {
            this._itemPanel.setOccDetector(this.namedOccBlock.getBean().getDisplayName());
        }
        this._itemPanel.setShowTrainName(this._pathUtil.showTrain());
        this._itemPanel.setPaths(this._pathUtil.getPaths());
        this._itemPanel.setSelection(this.getTurnout());
        this.initPaletteFrame(this._paletteFrame, this._itemPanel);
    }

    @Override
    void updateItem() {
        if (log.isDebugEnabled()) {
            log.debug("updateItem: {} family= {}", (Object)this.getNameString(), (Object)this._itemPanel.getFamilyName());
        }
        this.setTurnout(((Turnout)this._itemPanel.getTableSelection()).getSystemName());
        this.setOccSensor(this._itemPanel.getOccSensor());
        this.setOccBlock(this._itemPanel.getOccBlock());
        this._pathUtil.setShowTrain(this._itemPanel.getShowTrainName());
        this._iconFamily = this._itemPanel.getFamilyName();
        this._pathUtil.setPaths(this._itemPanel.getPaths());
        HashMap<String, HashMap<String, NamedIcon>> iconMap = this._itemPanel.getIconMaps();
        if (iconMap != null) {
            for (Map.Entry<String, HashMap<String, NamedIcon>> entry : iconMap.entrySet()) {
                String status = entry.getKey();
                HashMap<Integer, NamedIcon> oldMap = this._iconMaps.get(entry.getKey());
                for (Map.Entry<String, NamedIcon> ent : entry.getValue().entrySet()) {
                    if (log.isDebugEnabled()) {
                        log.debug("key= {}", (Object)ent.getKey());
                    }
                    NamedIcon newIcon = IndicatorTurnoutIcon.cloneIcon(ent.getValue(), this);
                    NamedIcon oldIcon = oldMap.get(this._name2stateMap.get(ent.getKey()));
                    newIcon.setLoad(oldIcon.getDegrees(), oldIcon.getScale(), this);
                    newIcon.setRotation(oldIcon.getRotation(), this);
                    this.setIcon(status, ent.getKey(), newIcon);
                }
            }
        }
        this.finishItemUpdate(this._paletteFrame, this._itemPanel);
        this.displayState(this.turnoutState());
    }

    @Override
    public void dispose() {
        if (this.namedOccSensor != null) {
            this.getOccSensor().removePropertyChangeListener(this);
        }
        if (this.namedOccBlock != null) {
            this.getOccBlock().removePropertyChangeListener(this);
        }
        this.namedOccSensor = null;
        super.dispose();
    }
}

