/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.util.ArrayList;
import jmri.InvokeOnLayoutThread;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.controlPanelEditor.shape.LocoLabel;
import jmri.jmrit.logix.OBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndicatorTrackPaths {
    protected ArrayList<String> _paths;
    private boolean _showTrain;
    private LocoLabel _loco = null;
    private static final Logger log = LoggerFactory.getLogger(IndicatorTrackPaths.class);

    protected IndicatorTrackPaths() {
    }

    protected IndicatorTrackPaths deepClone() {
        IndicatorTrackPaths p = new IndicatorTrackPaths();
        if (this._paths != null) {
            p._paths = new ArrayList();
            int i = 0;
            while (i < this._paths.size()) {
                p._paths.add(this._paths.get(i));
                ++i;
            }
        }
        p._showTrain = this._showTrain;
        return p;
    }

    protected ArrayList<String> getPaths() {
        return this._paths;
    }

    protected void setPaths(ArrayList<String> paths) {
        this._paths = paths;
    }

    protected void addPath(String path) {
        if (this._paths == null) {
            this._paths = new ArrayList();
        }
        if (path != null && path.length() > 0 && !this._paths.contains(path = path.trim())) {
            this._paths.add(path);
        }
        if (log.isDebugEnabled()) {
            log.debug("addPath \"{}\" #paths= {}", (Object)path, (Object)this._paths.size());
        }
    }

    protected void removePath(String path) {
        if (this._paths != null && path != null && path.length() > 0) {
            path = path.trim();
            this._paths.remove(path);
        }
    }

    protected void setShowTrain(boolean set) {
        this._showTrain = set;
    }

    protected boolean showTrain() {
        return this._showTrain;
    }

    protected synchronized String getStatus(OBlock block, int state) {
        String pathName = block.getAllocatedPathName();
        this.removeLocoIcon();
        String status = (state & 0x80) != 0 ? "ErrorTrack" : ((state & 0x40) != 0 ? "DontUseTrack" : ((state & 0x10) != 0 ? (this._paths != null && this._paths.contains(pathName) ? ((state & 0x20) != 0 ? "PositionTrack" : ((state & 2) != 0 ? "OccupiedTrack" : "AllocatedTrack")) : "ClearTrack") : ((state & 2) != 0 ? "OccupiedTrack" : "ClearTrack")));
        return status;
    }

    public void removeLocoIcon() {
        if (this._loco != null) {
            this._loco.remove();
            this._loco = null;
        }
    }

    @InvokeOnLayoutThread
    protected synchronized void setLocoIcon(OBlock block, Point pt, Dimension size, Editor ed) {
        if (!this._showTrain) {
            this.removeLocoIcon();
            return;
        }
        String trainName = (String)block.getValue();
        if (trainName == null) {
            this.removeLocoIcon();
            return;
        }
        if (this._loco != null || pt == null) {
            return;
        }
        trainName = trainName.trim();
        this._loco = new LocoLabel(ed);
        Font font = block.getMarkerFont();
        if (font == null) {
            font = ed.getFont();
        }
        int width = ed.getFontMetrics(font).stringWidth(trainName);
        int height = ed.getFontMetrics(ed.getFont()).getHeight();
        this._loco.setLineWidth(1);
        this._loco.setLineColor(Color.BLACK);
        this._loco.setFillColor(block.getMarkerBackground());
        this._loco.setBlock(block);
        this._loco.setWidth(width + height / 2);
        this._loco.setHeight(height + 2);
        this._loco.setCornerRadius(height);
        this._loco.setDisplayLevel(10);
        this._loco.updateSize();
        pt.x += (size.width - this._loco.maxWidth()) / 2;
        pt.y += (size.height - this._loco.maxHeight()) / 2;
        this._loco.setLocation(pt);
        try {
            ed.putItem(this._loco);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
    }

    protected String getStatus(int state) {
        String status;
        switch (state) {
            case 2: {
                status = "OccupiedTrack";
                break;
            }
            case 4: {
                status = "ClearTrack";
                break;
            }
            case 1: {
                status = "DontUseTrack";
                break;
            }
            default: {
                status = "ErrorTrack";
            }
        }
        return status;
    }
}

