/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;
import jmri.CatalogTree;
import jmri.CatalogTreeLeaf;
import jmri.CatalogTreeManager;
import jmri.CatalogTreeNode;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.SignalHead;
import jmri.jmrit.catalog.CatalogPanel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.picker.PickListModel;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconAdder
extends JPanel
implements ListSelectionListener {
    private int ROW_HEIGHT;
    HashMap<String, JToggleButton> _iconMap = new HashMap(10);
    ArrayList<String> _iconOrderList = new ArrayList();
    private JScrollPane _pickTablePane;
    private PickListModel _pickListModel;
    CatalogTreeNode _defaultIcons;
    JPanel _iconPanel;
    private JPanel _buttonPanel;
    private String _type;
    private boolean _userDefaults = false;
    protected JTextField _sysNameText;
    JTable _table;
    JButton _addButton;
    private JButton _addTableButton;
    private JButton _changeButton;
    private JButton _closeButton;
    private CatalogPanel _catalog;
    private JFrame _parent;
    private boolean _allowDeletes;
    boolean _update;
    static int STRUT_SIZE = 3;
    private static final Logger log = LoggerFactory.getLogger(IconAdder.class);

    public IconAdder() {
        this.setLayout(new BoxLayout(this, 1));
    }

    public IconAdder(boolean allowDeletes) {
        this();
        this._allowDeletes = allowDeletes;
    }

    public IconAdder(String type) {
        this();
        this._type = type;
        this.initDefaultIcons();
    }

    public void reset() {
        if (this._table != null) {
            this._table.clearSelection();
        }
        this.closeCatalog();
        if (this._defaultIcons != null) {
            this.makeIconPanel(true);
            log.debug("IconPanel ready");
        }
        this.revalidate();
    }

    public void initDefaultIcons() {
        CatalogTreeManager manager = InstanceManager.getDefault(CatalogTreeManager.class);
        CatalogTree tree = manager.getBySystemName("NXDI");
        if (tree != null) {
            CatalogTreeNode node = tree.getRoot();
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                CatalogTreeNode nChild = (CatalogTreeNode)e.nextElement();
                if (!this._type.equals(nChild.toString())) continue;
                this._defaultIcons = nChild;
                this._userDefaults = true;
                break;
            }
        }
        log.debug("initDefaultIcons: type= {}, defaultIcons= {}", (Object)this._type, (Object)this._defaultIcons);
    }

    private void createDefaultIconNodeFromMap() {
        log.debug("createDefaultIconNodeFromMap for node= {}, _iconOrderList.size()= {}", (Object)this._type, (Object)this._iconOrderList.size());
        this._defaultIcons = new CatalogTreeNode(this._type);
        for (Map.Entry<String, JToggleButton> entry : this._iconMap.entrySet()) {
            NamedIcon icon = (NamedIcon)entry.getValue().getIcon();
            this._defaultIcons.addLeaf(new CatalogTreeLeaf(entry.getKey(), icon.getURL(), this._iconOrderList.indexOf(entry.getKey())));
        }
    }

    public CatalogTreeNode getDefaultIconNode() {
        log.debug("getDefaultIconNode for node= {}", (Object)this._type);
        CatalogTreeNode defaultIcons = new CatalogTreeNode(this._type);
        ArrayList<CatalogTreeLeaf> leafList = this._defaultIcons.getLeaves();
        int i = 0;
        while (i < leafList.size()) {
            CatalogTreeLeaf leaf = leafList.get(i);
            defaultIcons.addLeaf(new CatalogTreeLeaf(leaf.getName(), leaf.getPath(), i));
            ++i;
        }
        return defaultIcons;
    }

    protected void makeIcons(CatalogTreeNode n) {
        if (log.isDebugEnabled()) {
            log.debug("makeIcons from node= {}, numChildren= {}, NumLeaves= {}", new Object[]{n.toString(), n.getChildCount(), n.getNumLeaves()});
        }
        this._iconMap = new HashMap(10);
        this._iconOrderList = new ArrayList();
        ArrayList<CatalogTreeLeaf> leafList = n.getLeaves();
        int k = leafList.size() - 1;
        int i = leafList.size() - 1;
        while (i >= 0) {
            CatalogTreeLeaf leaf = leafList.get(i);
            String name = leaf.getName();
            String path = leaf.getPath();
            switch (name) {
                case "BeanStateInconsistent": {
                    this.setIcon(0, name, new NamedIcon(path, path));
                    break;
                }
                case "BeanStateUnknown": {
                    this.setIcon(1, name, new NamedIcon(path, path));
                    break;
                }
                default: {
                    this.setIcon(k, name, new NamedIcon(path, path));
                    --k;
                }
            }
            --i;
        }
    }

    protected void setIcon(int order, String label, NamedIcon icon) {
        log.debug("setIcon at order= {}, key= {}", (Object)order, (Object)label);
        IconButton button = new IconButton(label, icon);
        if (icon == null || icon.getIconWidth() < 1 || icon.getIconHeight() < 1) {
            button.setText(Bundle.getMessage("invisibleIcon"));
            button.setForeground(Color.lightGray);
        } else {
            icon.reduceTo(100, 100, 0.02);
            button.setToolTipText(icon.getName());
        }
        if (this._allowDeletes) {
            String fileName = "resources/icons/misc/X-red.gif";
            button.setSelectedIcon(new NamedIcon(fileName, fileName));
        }
        if (icon != null) {
            icon.reduceTo(100, 100, 0.02);
        }
        this._iconMap.put(label, button);
        if (order > this._iconOrderList.size()) {
            int i = this._iconOrderList.size();
            while (i < order) {
                this._iconOrderList.add(i, "placeHolder");
                ++i;
            }
        } else if (order < this._iconOrderList.size()) {
            this._iconOrderList.remove(order);
        }
        this._iconOrderList.add(order, label);
    }

    public void setIcon(int order, String label, String name) {
        log.debug("setIcon: order= {}, label= {}, name= {}", new Object[]{order, label, name});
        this.setIcon(order, label, new NamedIcon(name, name));
    }

    public void setParent(JFrame parent) {
        this._parent = parent;
    }

    void pack() {
        this._parent.pack();
    }

    public int getNumIcons() {
        return this._iconMap.size();
    }

    public void makeIconPanel(boolean useDefaults) {
        if (useDefaults && this._userDefaults) {
            this.makeIcons(this._defaultIcons);
        }
        log.debug("makeIconPanel updating");
        this.clearIconPanel();
        this.doIconPanel();
    }

    private void clearIconPanel() {
        if (this._iconPanel != null) {
            this.remove(this._iconPanel);
        }
        this._iconPanel = new JPanel();
        this._iconPanel.setLayout(new GridLayout(0, 2));
    }

    protected void doIconPanel() {
        int i = this._iconOrderList.size() - 1;
        while (i >= 0) {
            log.debug("adding icon #{}", (Object)i);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            panel.add(Box.createHorizontalStrut(STRUT_SIZE));
            String key = this._iconOrderList.get(i);
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            String labelName = key;
            try {
                labelName = Bundle.getMessage(key);
            }
            catch (MissingResourceException missingResourceException) {
                log.warn("doIconPanel() property key {} missing", (Object)key);
            }
            JLabel name = new JLabel(labelName);
            name.setAlignmentX(0.5f);
            p.add(name);
            JToggleButton button = this._iconMap.get(key);
            button.setAlignmentX(0.5f);
            p.add(button);
            panel.add(p);
            this._iconPanel.add(panel);
            --i;
        }
        this.add((Component)this._iconPanel, 0);
    }

    public void setPickList(PickListModel tableModel) {
        this._pickListModel = tableModel;
        this._table = new JTable(tableModel);
        this._pickListModel.makeSorter(this._table);
        this._table.setRowSelectionAllowed(true);
        this._table.setSelectionMode(0);
        this.ROW_HEIGHT = this._table.getRowHeight();
        this._table.setPreferredScrollableViewportSize(new Dimension(200, 7 * this.ROW_HEIGHT));
        this._table.setDragEnabled(true);
        TableColumnModel columnModel = this._table.getColumnModel();
        TableColumn sNameColumnT = columnModel.getColumn(0);
        sNameColumnT.setResizable(true);
        sNameColumnT.setMinWidth(50);
        sNameColumnT.setMaxWidth(200);
        TableColumn uNameColumnT = columnModel.getColumn(1);
        uNameColumnT.setResizable(true);
        uNameColumnT.setMinWidth(100);
        uNameColumnT.setMaxWidth(300);
        this._pickTablePane = new JScrollPane(this._table);
        this.add(this._pickTablePane);
        this.add(Box.createVerticalStrut(STRUT_SIZE));
        this.pack();
    }

    public void setSelection(NamedBean bean) {
        int row = this._pickListModel.getIndexOf(bean);
        row = this._table.convertRowIndexToView(row);
        this._table.addRowSelectionInterval(row, row);
        this._pickTablePane.getVerticalScrollBar().setValue(row * this.ROW_HEIGHT);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this._table == null) {
            return;
        }
        int row = this._table.getSelectedRow();
        log.debug("Table valueChanged: row= {}", (Object)row);
        if (row >= 0) {
            this._addButton.setEnabled(true);
            this._addButton.setToolTipText(null);
            if (this._type != null && this._type.equals("SignalHead")) {
                this.makeIconMap((NamedBean)this._pickListModel.getBeanAt(row));
                this.clearIconPanel();
                this.doIconPanel();
            }
        } else {
            this._addButton.setEnabled(false);
            this._addButton.setToolTipText(Bundle.getMessage("ToolTipPickFromTable"));
        }
        this.validate();
    }

    private void makeIconMap(NamedBean bean) {
        if (bean != null && this._type != null && this._type.equals("SignalHead")) {
            this._iconMap = new HashMap(12);
            this._iconOrderList = new ArrayList();
            ArrayList<CatalogTreeLeaf> leafList = this._defaultIcons.getLeaves();
            int k = 0;
            String[] stateKeys = ((SignalHead)bean).getValidStateKeys();
            block0: for (CatalogTreeLeaf leaf : leafList) {
                String name = leaf.getName();
                log.debug("SignalHead Appearance leaf name= {}", (Object)name);
                String[] stringArray = stateKeys;
                int n = stateKeys.length;
                int n2 = 0;
                while (n2 < n) {
                    String state = stringArray[n2];
                    if (name.equals(state) || name.equals("SignalHeadStateDark") || name.equals("SignalHeadStateHeld")) {
                        String path = leaf.getPath();
                        this.setIcon(k++, name, new NamedIcon(path, path));
                        continue block0;
                    }
                    ++n2;
                }
            }
        } else {
            this.makeIcons(this._defaultIcons);
        }
        log.debug("makeIconMap: _iconMap.size()= {}", (Object)this._iconMap.size());
    }

    private void checkIconSizes() {
        if (!this._addButton.isEnabled()) {
            return;
        }
        Iterator<JToggleButton> iter = this._iconMap.values().iterator();
        int lastWidth = 0;
        int lastHeight = 0;
        boolean first = true;
        while (iter.hasNext()) {
            JToggleButton but = iter.next();
            if (first) {
                lastWidth = but.getIcon().getIconWidth();
                lastHeight = but.getIcon().getIconHeight();
                first = false;
                continue;
            }
            int nextWidth = but.getIcon().getIconWidth();
            int nextHeight = but.getIcon().getIconHeight();
            if (Math.abs(lastWidth - nextWidth) > 3 || Math.abs(lastHeight - nextHeight) > 3) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("IconSizeDiff"), Bundle.getMessage("WarningTitle"), 2);
                return;
            }
            lastWidth = nextWidth;
            lastHeight = nextHeight;
        }
        log.debug("Size: width= {}, height= {}", (Object)lastWidth, (Object)lastHeight);
    }

    public NamedBean getTableSelection() {
        if (InstanceManager.getDefault(CatalogTreeManager.class).isIndexChanged()) {
            this.checkIconSizes();
        }
        int row = this._table.getSelectedRow();
        if ((row = this._table.convertRowIndexToModel(row)) >= 0) {
            Object b = this._pickListModel.getBeanAt(row);
            this._table.clearSelection();
            this._addButton.setEnabled(false);
            this._addButton.setToolTipText(null);
            this.revalidate();
            if (b != null) {
                log.debug("getTableSelection: row = {}, bean = {}", (Object)row, (Object)b.getDisplayName());
            }
            return b;
        }
        log.debug("getTableSelection: row = 0");
        return null;
    }

    public NamedIcon getIcon(String key) {
        log.debug("getIcon for key= {}", (Object)key);
        return new NamedIcon((NamedIcon)this._iconMap.get(key).getIcon());
    }

    public Hashtable<String, NamedIcon> getIconMap() {
        log.debug("getIconMap: _allowDeletes= {}", (Object)this._allowDeletes);
        Hashtable<String, NamedIcon> iconMap = new Hashtable<String, NamedIcon>();
        for (Map.Entry<String, JToggleButton> entry : this._iconMap.entrySet()) {
            JToggleButton button = entry.getValue();
            log.debug("getIconMap: key= {}, button.isSelected()= {}", (Object)entry.getKey(), (Object)button.isSelected());
            if (this._allowDeletes && button.isSelected()) continue;
            iconMap.put(entry.getKey(), new NamedIcon((NamedIcon)button.getIcon()));
        }
        return iconMap;
    }

    public void complete(ActionListener addIconAction, boolean changeIcon, boolean addToTable, boolean update) {
        this._update = update;
        if (this._buttonPanel != null) {
            this.remove(this._buttonPanel);
        }
        this._buttonPanel = new JPanel();
        this._buttonPanel.setLayout(new BoxLayout(this._buttonPanel, 1));
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        if (addToTable) {
            this._sysNameText = new JTextField();
            this._sysNameText.setPreferredSize(new Dimension(150, this._sysNameText.getPreferredSize().height + 2));
            String tooltip = this._pickListModel.getManager().getEntryToolTip();
            if (tooltip != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("<br>");
                sb.append(this._pickListModel.getManager().getMemo().getUserName());
                sb.append(" ");
                sb.append(this._pickListModel.getManager().getBeanTypeHandled(true));
                sb.append(":<br>");
                sb.append(this._pickListModel.getManager().getEntryToolTip());
                tooltip = sb.toString();
            }
            this._sysNameText.setToolTipText(Bundle.getMessage("newBeanBySysNameTip", this._pickListModel.getManager().getBeanTypeHandled(false), this._pickListModel.getManager().getMemo().getUserName(), String.valueOf(InstanceManager.getDefault(InternalSystemConnectionMemo.class).getSystemPrefix()) + this._pickListModel.getManager().typeLetter(), tooltip == null ? "" : tooltip));
            this._addTableButton = new JButton(Bundle.getMessage("addToTable", this._pickListModel.getManager().getBeanTypeHandled()));
            this._addTableButton.addActionListener(a -> this.addToTable());
            this._addTableButton.setEnabled(false);
            this._addTableButton.setToolTipText(Bundle.getMessage("ToolTipWillActivate"));
            p.add(this._sysNameText);
            this._sysNameText.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent a) {
                    if (IconAdder.this._sysNameText.getText().length() > 0) {
                        IconAdder.this._addTableButton.setEnabled(true);
                        IconAdder.this._addTableButton.setToolTipText(null);
                        IconAdder.this._table.clearSelection();
                    }
                }
            });
            p.add(this._addTableButton);
            this._buttonPanel.add(p);
            p = new JPanel();
            p.setLayout(new FlowLayout());
        }
        this._addButton = update ? new JButton(Bundle.getMessage("ButtonUpdateIcon")) : new JButton(Bundle.getMessage("ButtonAddIcon"));
        this._addButton.addActionListener(addIconAction);
        this._addButton.setEnabled(true);
        if (changeIcon) {
            this._changeButton = new JButton(Bundle.getMessage("ButtonChangeIcon"));
            this._changeButton.addActionListener(a -> this.addCatalog());
            p.add(this._changeButton);
            this._closeButton = new JButton(Bundle.getMessage("ButtonCloseCatalog"));
            this._closeButton.addActionListener(a -> this.closeCatalog());
            this._closeButton.setVisible(false);
            p.add(this._closeButton);
        }
        this._buttonPanel.add(p);
        if (this._table != null) {
            this._addButton.setEnabled(false);
            this._addButton.setToolTipText(Bundle.getMessage("ToolTipPickFromTable"));
        }
        this.addAdditionalButtons(this._buttonPanel);
        p = new JPanel();
        p.add(this._addButton);
        this._buttonPanel.add(p);
        this._buttonPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        this._buttonPanel.add(new JSeparator());
        this.add(this._buttonPanel);
        if (changeIcon) {
            this._catalog = CatalogPanel.makeDefaultCatalog();
            this._catalog.setVisible(false);
            this._catalog.setToolTipText(Bundle.getMessage("ToolTipDragIcon"));
            this.add(this._catalog);
        }
        if (this._type != null) {
            this.createDefaultIconNodeFromMap();
        }
        if (this._table != null) {
            this._table.getSelectionModel().addListSelectionListener(this);
        }
        this.pack();
    }

    protected void addAdditionalButtons(JPanel p) {
    }

    public boolean addIconIsEnabled() {
        return this._addButton.isEnabled();
    }

    void addToTable() {
        String name = this._sysNameText.getText();
        if (name != null && name.length() > 0) {
            try {
                Object bean = this._pickListModel.addBean(name);
                if (bean != null) {
                    int setRow = this._pickListModel.getIndexOf(bean);
                    this._table.setRowSelectionInterval(setRow, setRow);
                    this._pickTablePane.getVerticalScrollBar().setValue(setRow * this.ROW_HEIGHT);
                }
            }
            catch (IllegalArgumentException ex) {
                JOptionPane.showMessageDialog(this.getParent(), ex.getLocalizedMessage(), Bundle.getMessage("WarningTitle"), 2);
            }
        }
        this._sysNameText.setText("");
        this._addTableButton.setEnabled(false);
        this._addTableButton.setToolTipText(Bundle.getMessage("ToolTipWillActivate"));
    }

    public void addCatalog() {
        log.debug("addCatalog() called");
        if (this._catalog == null) {
            this._catalog = CatalogPanel.makeDefaultCatalog();
            this._catalog.setToolTipText(Bundle.getMessage("ToolTipDragIcon"));
        }
        this._catalog.setVisible(true);
        if (this._changeButton != null) {
            this._changeButton.setVisible(false);
            this._closeButton.setVisible(true);
        }
        if (this._pickTablePane != null) {
            this._pickTablePane.setVisible(false);
        }
        this.pack();
    }

    void closeCatalog() {
        if (this._changeButton != null) {
            this._catalog.setVisible(false);
            this._changeButton.setVisible(true);
            this._closeButton.setVisible(false);
        }
        if (this._pickTablePane != null) {
            this._pickTablePane.setVisible(true);
        }
        this.pack();
    }

    public void addDirectoryToCatalog() {
        if (this._catalog == null) {
            this._catalog = CatalogPanel.makeDefaultCatalog();
        }
        if (this._changeButton != null) {
            this._changeButton.setVisible(false);
            this._closeButton.setVisible(true);
        }
        this.add(this._catalog);
        this.pack();
    }

    private void updateCatalogTree() {
        CatalogTreeManager manager = InstanceManager.getDefault(CatalogTreeManager.class);
        CatalogTree tree = manager.getBySystemName("NXDI");
        if (tree == null) {
            tree = manager.newCatalogTree("NXDI", "Default Icons");
        }
        CatalogTreeNode root = tree.getRoot();
        Enumeration<TreeNode> e = root.children();
        String name = this._defaultIcons.toString();
        while (e.hasMoreElements()) {
            CatalogTreeNode nChild = (CatalogTreeNode)e.nextElement();
            if (!name.equals(nChild.toString())) continue;
            log.debug("Remove node {}", (Object)nChild);
            root.remove(nChild);
            break;
        }
        root.add(this._defaultIcons);
        InstanceManager.getDefault(CatalogTreeManager.class).indexChanged(true);
    }

    public void dispose() {
        this.removeAll();
        this._iconMap = null;
        this._iconOrderList = null;
        this._catalog = null;
    }

    class DropButton
    extends JToggleButton
    implements DropTargetListener {
        DataFlavor dataFlavor;

        DropButton(Icon icon) {
            super(icon);
            try {
                this.dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=jmri.jmrit.catalog.NamedIcon");
            }
            catch (ClassNotFoundException cnfe) {
                log.error("Unable to create drag and drop target.", (Throwable)cnfe);
            }
            new DropTarget(this, 3, this);
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            try {
                Transferable tr = e.getTransferable();
                if (e.isDataFlavorSupported(this.dataFlavor)) {
                    NamedIcon newIcon = (NamedIcon)tr.getTransferData(this.dataFlavor);
                    if (newIcon != null) {
                        e.acceptDrop(3);
                        DropTarget target = (DropTarget)e.getSource();
                        IconButton iconButton = (IconButton)target.getComponent();
                        String key = iconButton.key;
                        JToggleButton button = IconAdder.this._iconMap.get(key);
                        NamedIcon oldIcon = (NamedIcon)button.getIcon();
                        button.setIcon(newIcon);
                        if (newIcon.getIconWidth() < 1 || newIcon.getIconHeight() < 1) {
                            button.setText(Bundle.getMessage("invisibleIcon"));
                            button.setForeground(Color.lightGray);
                        } else {
                            button.setText(null);
                        }
                        IconAdder.this._iconMap.put(key, button);
                        if (!IconAdder.this._update) {
                            IconAdder.this._defaultIcons.deleteLeaf(key, oldIcon.getURL());
                            IconAdder.this._defaultIcons.addLeaf(key, newIcon.getURL());
                            IconAdder.this.updateCatalogTree();
                        }
                        e.dropComplete(true);
                        log.debug("DropJLabel.drop COMPLETED for {}, {}", (Object)key, (Object)newIcon.getURL());
                    } else {
                        log.debug("DropJLabel.drop REJECTED!");
                        e.rejectDrop();
                    }
                }
            }
            catch (IOException iOException) {
                log.debug("DropPanel.drop REJECTED!");
                e.rejectDrop();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                log.debug("DropJLabel.drop REJECTED!");
                e.rejectDrop();
            }
        }
    }

    private class IconButton
    extends DropButton {
        String key;

        IconButton(String label, Icon icon) {
            super(icon);
            this.key = label;
        }
    }
}

