/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Frame;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.ShutDownManager;
import jmri.UserPreferencesManager;
import jmri.beans.Bean;
import jmri.configurexml.StoreXmlUserAction;
import jmri.implementation.AbstractShutDownTask;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;

public class EditorManager
extends Bean
implements PropertyChangeListener,
InstanceManagerAutoDefault {
    public static final String EDITORS = "editors";
    public static final String TITLE = "title";
    private final SortedSet<Editor> set = Collections.synchronizedSortedSet(new TreeSet<Editor>(Comparator.comparing(Frame::getTitle)));
    boolean panelSetChanged = false;
    public transient AbstractShutDownTask shutDownTask = null;

    public EditorManager() {
        super(false);
        this.setShutDownTask();
    }

    public void setChanged(boolean flag) {
        this.panelSetChanged = flag;
    }

    public String getClassDescription() {
        return Bundle.getMessage("TitlePanelDialogs");
    }

    public void setMessagePreferencesDetails() {
        InstanceManager.getDefault(UserPreferencesManager.class).setPreferenceItemDetails("jmri.jmrit.display.EditorManager", "skipHideDialog", Bundle.getMessage("PanelHideSkip"));
        InstanceManager.getDefault(UserPreferencesManager.class).setPreferenceItemDetails("jmri.jmrit.display.EditorManager", "skipDupLoadDialog", Bundle.getMessage("DuplicateLoadSkip"));
    }

    public void setShutDownTask() {
        this.shutDownTask = new AbstractShutDownTask("EditorManager"){

            @Override
            public Boolean call() {
                if (EditorManager.this.panelSetChanged) {
                    EditorManager.this.notifyStoreNeeded();
                }
                return Boolean.TRUE;
            }

            @Override
            public void run() {
            }
        };
        InstanceManager.getDefault(ShutDownManager.class).register(this.shutDownTask);
    }

    String getClassName() {
        return EditorManager.class.getName();
    }

    void notifyStoreNeeded() {
        JDialog dialog = new JDialog();
        dialog.setTitle(Bundle.getMessage("QuestionTitle"));
        dialog.setDefaultCloseOperation(2);
        JPanel container = new JPanel();
        container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        container.setLayout(new BoxLayout(container, 1));
        JLabel question = new JLabel(Bundle.getMessage("EditorManagerQuitNotification"));
        question.setAlignmentX(0.5f);
        container.add(question);
        JButton noButton = new JButton(Bundle.getMessage("ButtonNo"));
        JButton yesButton = new JButton(Bundle.getMessage("ButtonYes"));
        JPanel button = new JPanel();
        button.setAlignmentX(0.5f);
        button.add(noButton);
        button.add(yesButton);
        container.add(button);
        noButton.addActionListener(e -> dialog.dispose());
        yesButton.addActionListener(e -> {
            dialog.setVisible(false);
            new StoreXmlUserAction("").actionPerformed(null);
            dialog.dispose();
        });
        container.setAlignmentX(0.5f);
        container.setAlignmentY(0.5f);
        dialog.getContentPane().add(container);
        dialog.pack();
        dialog.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - dialog.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - dialog.getHeight() / 2);
        dialog.setModal(true);
        dialog.setVisible(true);
    }

    public void add(@Nonnull Editor editor) {
        boolean result = this.set.add(editor);
        if (result) {
            this.fireIndexedPropertyChange(EDITORS, this.set.size(), null, editor);
            editor.addPropertyChangeListener(TITLE, this);
        }
    }

    public boolean contains(@Nonnull Editor editor) {
        return this.set.contains(editor);
    }

    @Nonnull
    public SortedSet<Editor> getAll() {
        return new TreeSet<Editor>(this.set);
    }

    @Nonnull
    public <T extends Editor> SortedSet<T> getAll(@Nonnull Class<T> type) {
        return this.set.stream().filter(e -> type.isAssignableFrom(e.getClass())).map(type::cast).collect(Collectors.toCollection(() -> new TreeSet<Editor>(Comparator.comparing(Frame::getTitle))));
    }

    @CheckForNull
    public Editor get(@Nonnull String title) {
        return this.getAll().stream().filter(e -> e.getTitle().equals(title)).findFirst().orElse(null);
    }

    @CheckForNull
    public Editor getByName(@Nonnull String name) {
        return this.getAll().stream().filter(e -> e.getName().equals(name)).findFirst().orElse(null);
    }

    @CheckForNull
    public Editor getTargetFrame(@Nonnull String name) {
        Editor editor = this.get(name);
        if (editor != null) {
            return editor;
        }
        return this.getAll().stream().filter(e -> e.getTargetFrame().getTitle().equals(name)).findFirst().orElse(null);
    }

    @CheckForNull
    public <T extends Editor> T get(@Nonnull Class<T> type, @Nonnull String name) {
        return (T)((Editor)type.cast(this.set.stream().filter(e -> e.getClass().isAssignableFrom(type) && e.getTitle().equals(name)).findFirst().orElse(null)));
    }

    public void remove(@Nonnull Editor editor) {
        boolean result = this.set.remove(editor);
        if (result) {
            this.fireIndexedPropertyChange(EDITORS, this.set.size(), editor, null);
            editor.removePropertyChangeListener(TITLE, this);
            this.panelSetChanged = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Editor editor;
        if (evt.getSource() instanceof Editor && this.contains(editor = (Editor)evt.getSource()) && TITLE.equals(evt.getPropertyName())) {
            this.set.remove(editor);
            this.set.add(editor);
            this.firePropertyChange(evt);
        }
    }

    public boolean contains(String name) {
        return this.get(name) != null;
    }

    @Nonnull
    public List<Editor> getList() {
        return new ArrayList<Editor>(this.getAll());
    }

    @Nonnull
    public <T extends Editor> List<T> getList(@Nonnull Class<T> type) {
        return new ArrayList<T>(this.getAll(type));
    }

    @Deprecated
    public synchronized List<Editor> getEditorsList() {
        return new ArrayList<Editor>(this.getAll());
    }

    @Deprecated
    public <T extends Editor> List<T> getEditorsList(@Nonnull Class<T> type) {
        return new ArrayList<T>(this.getAll(type));
    }

    @Deprecated
    public Editor getEditor(String name) {
        return this.get(name);
    }

    @Deprecated
    public boolean addEditor(@Nonnull Editor editor) {
        return this.set.add(editor);
    }

    @Deprecated
    public boolean removeEditor(@Nonnull Editor editor) {
        return this.set.remove(editor);
    }
}

