/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.MemoryIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.picker.PickListModel;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleFrameManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockContentsIcon
extends MemoryIcon {
    private NamedIcon defaultIcon = null;
    HashMap<String, NamedIcon> map = null;
    private NamedBeanHandle<Block> namedBlock;
    private static final Logger log = LoggerFactory.getLogger(BlockContentsIcon.class);

    public BlockContentsIcon(String s, Editor editor) {
        super(s, editor);
        this.resetDefaultIcon();
        this._namedIcon = this.defaultIcon;
        this._popupUtil.setJustification(0);
        this.setTransferHandler(new MemoryIcon.TransferHandler(this));
    }

    public BlockContentsIcon(NamedIcon s, Editor editor) {
        super(s, editor);
        this.setDisplayLevel(4);
        this.defaultIcon = s;
        this._popupUtil.setJustification(0);
        log.debug("BlockContentsIcon ctor= {}", (Object)BlockContentsIcon.class.getName());
        this.setTransferHandler(new MemoryIcon.TransferHandler(this));
    }

    @Override
    @Nonnull
    public Positionable deepClone() {
        BlockContentsIcon pos = new BlockContentsIcon("", this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(BlockContentsIcon pos) {
        pos.setBlock(this.namedBlock);
        pos.setOriginalLocation(this.getOriginalX(), this.getOriginalY());
        if (this.map != null) {
            for (Map.Entry<String, NamedIcon> entry : this.map.entrySet()) {
                String url = entry.getValue().getName();
                pos.addKeyAndIcon(NamedIcon.getIconByName(url), entry.getKey());
            }
        }
        return super.finishClone(pos);
    }

    @Override
    public void resetDefaultIcon() {
        this.defaultIcon = new NamedIcon("resources/icons/misc/X-red.gif", "resources/icons/misc/X-red.gif");
    }

    public void setBlock(String pName) {
        if (InstanceManager.getNullableDefault(BlockManager.class) != null) {
            Block block = InstanceManager.getDefault(BlockManager.class).provideBlock(pName);
            this.setBlock(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, block));
        } else {
            log.error("No Block Manager for this protocol, icon won't see changes");
        }
        this.updateSize();
    }

    public void setBlock(NamedBeanHandle<Block> m) {
        if (this.namedBlock != null) {
            this.getBlock().removePropertyChangeListener(this);
        }
        this.namedBlock = m;
        if (this.namedBlock != null) {
            this.getBlock().addPropertyChangeListener(this, this.namedBlock.getName(), "Block Icon");
            this.displayState();
            this.setName(this.namedBlock.getName());
        }
    }

    public NamedBeanHandle<Block> getNamedBlock() {
        return this.namedBlock;
    }

    public Block getBlock() {
        if (this.namedBlock == null) {
            return null;
        }
        return this.namedBlock.getBean();
    }

    @Override
    public NamedBean getNamedBean() {
        return this.getBlock();
    }

    @Override
    public HashMap<String, NamedIcon> getMap() {
        return this.map;
    }

    @Override
    @Nonnull
    public String getNameString() {
        String name = this.namedBlock == null ? Bundle.getMessage("NotConnected") : this.getBlock().getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        return name;
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        if (this.isEditable() && this.selectable) {
            popup.add(new JSeparator());
            for (String key : this.map.keySet()) {
                popup.add(new AbstractAction(key){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String key = e.getActionCommand();
                        BlockContentsIcon.this.setValue(key);
                    }
                });
            }
            return true;
        }
        if (this.re != null) {
            popup.add(new AbstractAction("Open Throttle"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ThrottleFrame tf = InstanceManager.getDefault(ThrottleFrameManager.class).createThrottleFrame();
                    tf.toFront();
                    tf.getAddressPanel().setRosterEntry(BlockContentsIcon.this.re);
                }
            });
            final DispatcherFrame df = InstanceManager.getNullableDefault(DispatcherFrame.class);
            if (df != null) {
                final ActiveTrain at = df.getActiveTrainForRoster(this.re);
                if (at != null) {
                    popup.add(new AbstractAction(Bundle.getMessage("MenuTerminateTrain")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            df.terminateActiveTrain(at);
                        }
                    });
                    popup.add(new AbstractAction(Bundle.getMessage("MenuAllocateExtra")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            df.allocateExtraSection(e, at);
                        }
                    });
                    if (at.getStatus() == 64) {
                        popup.add(new AbstractAction("Restart"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                at.allocateAFresh();
                            }
                        });
                    }
                } else {
                    popup.add(new AbstractAction(Bundle.getMessage("MenuNewTrain")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (!df.getNewTrainActive()) {
                                df.getActiveTrainFrame().initiateTrain(e, BlockContentsIcon.this.re, BlockContentsIcon.this.getBlock());
                                df.setNewTrainActive(true);
                            } else {
                                df.getActiveTrainFrame().showActivateFrame(BlockContentsIcon.this.re);
                            }
                        }
                    });
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setTextEditMenu(JPopupMenu popup) {
        popup.add(new AbstractAction(Bundle.getMessage("EditBlockValue")){

            @Override
            public void actionPerformed(ActionEvent e) {
                BlockContentsIcon.this.editBlockValue();
            }
        });
        return true;
    }

    @Override
    public void displayState() {
        log.debug("displayState");
        if (this.namedBlock == null) {
            this.setIcon(this.defaultIcon);
            this.updateSize();
            return;
        }
        if (this.re != null) {
            InstanceManager.throttleManagerInstance().removeListener(this.re.getDccLocoAddress(), this);
            this.re = null;
        }
        Object key = this.getBlock().getValue();
        this.displayState(key);
    }

    @Override
    public boolean setEditIconMenu(JPopupMenu popup) {
        String txt = MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("BeanNameBlock"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                BlockContentsIcon.this.edit();
            }
        });
        return true;
    }

    @Override
    protected void edit() {
        this.makeIconEditorFrame(this, "Block", true, null);
        this._iconEditor.setPickList(PickListModel.blockPickModelInstance());
        ActionListener addIconAction = a -> this.editBlock();
        this._iconEditor.complete(addIconAction, false, true, true);
        this._iconEditor.setSelection(this.getBlock());
    }

    void editBlock() {
        this.setBlock(this._iconEditor.getTableSelection().getDisplayName());
        this.updateSize();
        this._iconEditorFrame.dispose();
        this._iconEditorFrame = null;
        this._iconEditor = null;
        this.invalidate();
    }

    @Override
    public void dispose() {
        if (this.getBlock() != null) {
            this.getBlock().removePropertyChangeListener(this);
        }
        this.namedBlock = null;
        if (this.re != null) {
            InstanceManager.throttleManagerInstance().removeListener(this.re.getDccLocoAddress(), this);
            this.re = null;
        }
        super.dispose();
    }

    @Override
    public void doMouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.editBlockValue();
        }
    }

    protected void editBlockValue() {
        JTextField newBlock = new JTextField(20);
        if (this.getBlock().getValue() != null) {
            newBlock.setText(this.getBlock().getValue().toString());
        }
        Object[] options = new Object[]{Bundle.getMessage("ButtonCancel"), Bundle.getMessage("ButtonOK"), newBlock};
        int retval = JOptionPane.showOptionDialog(this, Bundle.getMessage("EditCurrentBlockValue"), this.namedBlock.getName(), 0, 1, null, options, options[1]);
        if (retval != 1) {
            return;
        }
        this.setValue(newBlock.getText());
        this.updateSize();
    }

    @Override
    protected Object getValue() {
        if (this.getBlock() == null) {
            return null;
        }
        return this.getBlock().getValue();
    }

    @Override
    protected void setValue(Object val) {
        this.getBlock().setValue(val);
    }
}

