/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jmri.jmrit.XmlFile;
import jmri.jmrit.dispatcher.TrainInfo;
import jmri.util.FileUtil;
import jmri.util.XmlFilenameFilter;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainInfoFile
extends XmlFile {
    private String fileLocation = String.valueOf(FileUtil.getUserFilesPath()) + "dispatcher" + File.separator + "traininfo" + File.separator;
    private Document doc = null;
    private Element root = null;
    private static final Logger log = LoggerFactory.getLogger(TrainInfoFile.class);

    public void setFileLocation(String testLocation) {
        this.fileLocation = testLocation;
    }

    public TrainInfo readTrainInfo(String name) throws JDOMException, IOException {
        TrainInfo tInfo;
        block103: {
            Element traininfo;
            int version;
            block106: {
                block104: {
                    log.debug("entered readTrainInfo for {}", (Object)name);
                    tInfo = null;
                    version = 1;
                    if (!this.checkFile(String.valueOf(this.fileLocation) + name)) break block103;
                    tInfo = new TrainInfo();
                    this.root = this.rootFromName(String.valueOf(this.fileLocation) + name);
                    if (this.root == null || (traininfo = this.root.getChild("traininfo")) == null) break block103;
                    if (traininfo.getAttribute("version") != null) {
                        try {
                            version = traininfo.getAttribute("version").getIntValue();
                        }
                        catch (Exception exception) {
                            log.error("Traininfo file version number not an integer: assuming version 1");
                            version = 1;
                        }
                    } else {
                        version = 1;
                    }
                    if (traininfo.getAttribute("transitname") != null) {
                        tInfo.setTransitName(traininfo.getAttribute("transitname").getValue());
                    } else {
                        log.error("Transit name missing when reading TrainInfoFile {}", (Object)name);
                    }
                    if (traininfo.getAttribute("trainname") != null) {
                        tInfo.setTrainName(traininfo.getAttribute("trainname").getValue());
                    } else {
                        log.error("Train name missing when reading TrainInfoFile {}", (Object)name);
                    }
                    if (traininfo.getAttribute("dccaddress") != null) {
                        tInfo.setDccAddress(traininfo.getAttribute("dccaddress").getValue());
                    } else {
                        log.error("DCC Address missing when reading TrainInfoFile {}", (Object)name);
                    }
                    if (traininfo.getAttribute("trainintransit") != null) {
                        tInfo.setTrainInTransit(true);
                        if (traininfo.getAttribute("trainintransit").getValue().equals("no")) {
                            tInfo.setTrainInTransit(false);
                        }
                    } else {
                        log.error("Train in Transit check box missing  when reading TrainInfoFile {}", (Object)name);
                    }
                    if (traininfo.getAttribute("startblockname") != null) {
                        tInfo.setStartBlockName(traininfo.getAttribute("startblockname").getValue());
                    } else {
                        log.error("Start block name missing when reading TrainInfoFile {}", (Object)name);
                    }
                    if (traininfo.getAttribute("endblockname") != null) {
                        tInfo.setDestinationBlockName(traininfo.getAttribute("endblockname").getValue());
                    } else {
                        log.error("Destination block name missing when reading TrainInfoFile {}", (Object)name);
                    }
                    if (traininfo.getAttribute("trainfromroster") != null) {
                        tInfo.setTrainFromRoster(true);
                        if (traininfo.getAttribute("trainfromroster").getValue().equals("no")) {
                            tInfo.setTrainFromRoster(false);
                        }
                    }
                    if (traininfo.getAttribute("trainfromtrains") != null) {
                        tInfo.setTrainFromTrains(true);
                        if (traininfo.getAttribute("trainfromtrains").getValue().equals("no")) {
                            tInfo.setTrainFromTrains(false);
                        }
                    }
                    if (traininfo.getAttribute("trainfromuser") != null) {
                        tInfo.setTrainFromUser(true);
                        if (traininfo.getAttribute("trainfromuser").getValue().equals("no")) {
                            tInfo.setTrainFromUser(false);
                        }
                    }
                    if (traininfo.getAttribute("priority") != null) {
                        tInfo.setPriority(Integer.parseInt(traininfo.getAttribute("priority").getValue()));
                    } else {
                        log.error("Priority missing when reading TrainInfoFile {}", (Object)name);
                    }
                    if (traininfo.getAttribute("allocatealltheway") != null && traininfo.getAttribute("allocatealltheway").getValue().equals("yes")) {
                        tInfo.setAllocateAllTheWay(true);
                    }
                    if (traininfo.getAttribute("allocationmethod") != null) {
                        tInfo.setAllocationMethod(traininfo.getAttribute("allocationmethod").getIntValue());
                    }
                    if (traininfo.getAttribute("resetwhendone") == null) break block104;
                    if (traininfo.getAttribute("resetwhendone").getValue().equals("yes")) {
                        tInfo.setResetWhenDone(true);
                    }
                    if (traininfo.getAttribute("delayedrestart") == null) break block104;
                    switch (traininfo.getAttribute("delayedrestart").getValue()) {
                        case "no": {
                            tInfo.setDelayedRestart(0);
                            break;
                        }
                        case "sensor": {
                            tInfo.setDelayedRestart(2);
                            if (traininfo.getAttribute("delayedrestartsensor") != null) {
                                tInfo.setRestartSensorName(traininfo.getAttribute("delayedrestartsensor").getValue());
                            }
                            if (traininfo.getAttribute("resetrestartsensor") == null) break;
                            tInfo.setResetRestartSensor(traininfo.getAttribute("resetrestartsensor").getValue().equals("yes"));
                            break;
                        }
                        case "timed": {
                            tInfo.setDelayedRestart(1);
                            if (traininfo.getAttribute("delayedrestarttime") == null) break;
                            tInfo.setRestartDelayMin((int)traininfo.getAttribute("delayedrestarttime").getLongValue());
                            break;
                        }
                    }
                }
                if (traininfo.getAttribute("reverseatend") != null) {
                    tInfo.setReverseAtEnd(true);
                    if (traininfo.getAttribute("reverseatend").getValue().equals("no")) {
                        tInfo.setReverseAtEnd(false);
                    }
                }
                if (traininfo.getAttribute("delayedstart") == null) break block106;
                switch (traininfo.getAttribute("delayedstart").getValue()) {
                    case "no": {
                        tInfo.setDelayedStart(0);
                        break;
                    }
                    case "sensor": {
                        tInfo.setDelayedStart(2);
                        break;
                    }
                    default: {
                        tInfo.setDelayedStart(1);
                    }
                }
            }
            if (traininfo.getAttribute("departuretimehr") != null) {
                tInfo.setDepartureTimeHr(Integer.parseInt(traininfo.getAttribute("departuretimehr").getValue()));
            }
            if (traininfo.getAttribute("departuretimemin") != null) {
                tInfo.setDepartureTimeMin(Integer.parseInt(traininfo.getAttribute("departuretimemin").getValue()));
            }
            if (traininfo.getAttribute("delayedSensor") != null) {
                tInfo.setDelaySensorName(traininfo.getAttribute("delayedSensor").getValue());
            }
            if (traininfo.getAttribute("resetstartsensor") != null) {
                tInfo.setResetStartSensor(traininfo.getAttribute("resetstartsensor").getValue().equals("yes"));
            }
            if (traininfo.getAttribute("traintype") != null) {
                tInfo.setTrainType(traininfo.getAttribute("traintype").getValue());
            }
            if (traininfo.getAttribute("autorun") != null) {
                tInfo.setAutoRun(true);
                if (traininfo.getAttribute("autorun").getValue().equals("no")) {
                    tInfo.setAutoRun(false);
                }
            }
            if (traininfo.getAttribute("loadatstartup") != null) {
                tInfo.setLoadAtStartup(true);
                if (traininfo.getAttribute("loadatstartup").getValue().equals("no")) {
                    tInfo.setLoadAtStartup(false);
                }
            }
            if (traininfo.getAttribute("speedfactor") != null) {
                tInfo.setSpeedFactor(Float.parseFloat(traininfo.getAttribute("speedfactor").getValue()));
            }
            if (traininfo.getAttribute("maxspeed") != null) {
                tInfo.setMaxSpeed(Float.parseFloat(traininfo.getAttribute("maxspeed").getValue()));
            }
            if (traininfo.getAttribute("ramprate") != null) {
                tInfo.setRampRate(traininfo.getAttribute("ramprate").getValue());
            }
            if (traininfo.getAttribute("resistancewheels") != null) {
                tInfo.setResistanceWheels(true);
                if (traininfo.getAttribute("resistancewheels").getValue().equals("no")) {
                    tInfo.setResistanceWheels(false);
                }
            }
            if (traininfo.getAttribute("runinreverse") != null) {
                tInfo.setRunInReverse(true);
                if (traininfo.getAttribute("runinreverse").getValue().equals("no")) {
                    tInfo.setRunInReverse(false);
                }
            }
            if (traininfo.getAttribute("sounddecoder") != null) {
                tInfo.setSoundDecoder(true);
                if (traininfo.getAttribute("sounddecoder").getValue().equals("no")) {
                    tInfo.setSoundDecoder(false);
                }
            }
            if (traininfo.getAttribute("maxtrainlength") != null) {
                tInfo.setMaxTrainLength(Float.parseFloat(traininfo.getAttribute("maxtrainlength").getValue()));
            }
            if (traininfo.getAttribute("terminatewhendone") != null) {
                tInfo.setTerminateWhenDone(false);
                if (traininfo.getAttribute("terminatewhendone").getValue().equals("yes")) {
                    tInfo.setTerminateWhenDone(true);
                }
            }
            if (traininfo.getAttribute("usespeedprofile") != null) {
                tInfo.setUseSpeedProfile(false);
                if (traininfo.getAttribute("usespeedprofile").getValue().equals("yes")) {
                    tInfo.setUseSpeedProfile(true);
                }
            }
            if (traininfo.getAttribute("stopbyspeedprofile") != null) {
                tInfo.setStopBySpeedProfile(false);
                if (traininfo.getAttribute("stopbyspeedprofile").getValue().equals("yes")) {
                    tInfo.setStopBySpeedProfile(true);
                }
            }
            if (traininfo.getAttribute("stopbyspeedprofileadjust") != null) {
                tInfo.setStopBySpeedProfileAdjust(traininfo.getAttribute("stopbyspeedprofileadjust").getFloatValue());
            }
            if (version == 1) {
                tInfo.setStartBlockId(tInfo.getStartBlockName().split("-")[0]);
                tInfo.setStartBlockId(tInfo.getStartBlockId().split("\\(")[0]);
                String[] parseArray = tInfo.getStartBlockName().split("-");
                tInfo.setStartBlockSeq(-1);
                if (parseArray.length > 0) {
                    try {
                        tInfo.setStartBlockSeq(Integer.parseInt(parseArray[parseArray.length - 1]));
                    }
                    catch (Exception exception) {
                        log.error("Invalid StartBlockSequence{}", (Object)parseArray[parseArray.length - 1]);
                    }
                }
                tInfo.setDestinationBlockId(tInfo.getDestinationBlockName().split("-")[0]);
                tInfo.setDestinationBlockId(tInfo.getDestinationBlockId().split("\\(")[0]);
                parseArray = tInfo.getDestinationBlockName().split("-");
                tInfo.setDestinationBlockSeq(-1);
                if (parseArray.length > 0) {
                    try {
                        tInfo.setDestinationBlockSeq(Integer.parseInt(parseArray[parseArray.length - 1]));
                    }
                    catch (Exception exception) {
                        log.error("Invalid StartBlockSequence{}", (Object)parseArray[parseArray.length - 1]);
                    }
                }
                tInfo.setTransitId(tInfo.getTransitName().split("\\(")[0]);
                log.debug("v1: t = {}, bs = {}, be = {}", new Object[]{tInfo.getTransitName(), tInfo.getStartBlockName(), tInfo.getDestinationBlockName()});
            }
            if (version == 2 || version == 3) {
                if (traininfo.getAttribute("transitid") != null) {
                    tInfo.setTransitId(traininfo.getAttribute("transitid").getValue());
                } else {
                    log.error("Transit id missing when reading TrainInfoFile {}", (Object)name);
                }
                if (traininfo.getAttribute("startblockid") != null) {
                    tInfo.setStartBlockId(traininfo.getAttribute("startblockid").getValue());
                } else {
                    log.error("Start block Id missing when reading TrainInfoFile {}", (Object)name);
                }
                if (traininfo.getAttribute("endblockid") != null) {
                    tInfo.setDestinationBlockId(traininfo.getAttribute("endblockid").getValue());
                } else {
                    log.error("Destination block Id missing when reading TrainInfoFile {}", (Object)name);
                }
                if (traininfo.getAttribute("startblockseq") != null) {
                    try {
                        tInfo.setStartBlockSeq(traininfo.getAttribute("startblockseq").getIntValue());
                    }
                    catch (Exception exception) {
                        log.error("Start block sequence invalid when reading TrainInfoFile");
                    }
                } else {
                    log.error("Start block sequence missing when reading TrainInfoFile {}", (Object)name);
                }
                if (traininfo.getAttribute("endblockseq") != null) {
                    try {
                        tInfo.setDestinationBlockSeq(traininfo.getAttribute("endblockseq").getIntValue());
                    }
                    catch (Exception exception) {
                        log.error("Destination block sequence invalid when reading TrainInfoFile {}", (Object)name);
                    }
                } else {
                    log.error("Destination block sequence missing when reading TrainInfoFile {}", (Object)name);
                }
            }
            if (version == 1 || version == 2) {
                tInfo.setTransitName(this.convertName(tInfo.getTransitName()));
                tInfo.setStartBlockName(this.convertName(tInfo.getStartBlockName()));
                tInfo.setDestinationBlockName(this.convertName(tInfo.getDestinationBlockName()));
            }
        }
        return tInfo;
    }

    public String convertName(String name) {
        String newName = name;
        Pattern p = Pattern.compile(".+\\((.+)\\)(-\\d+)*");
        Matcher m = p.matcher(name);
        if (m.matches()) {
            log.debug("regex: name = '{}', group 1 = '{}', group 2 = '{}'", new Object[]{name, m.group(1), m.group(2)});
            if (m.group(1) != null) {
                newName = m.group(1).trim();
                if (m.group(2) != null) {
                    newName = String.valueOf(newName) + m.group(2).trim();
                }
            }
        }
        log.debug("convertName: old = '{}', new = '{}'", (Object)name, (Object)newName);
        return newName;
    }

    public void writeTrainInfo(TrainInfo tf, String name) throws IOException {
        log.debug("entered writeTrainInfo");
        this.root = new Element("traininfofile");
        this.doc = TrainInfoFile.newDocument(this.root, String.valueOf(this.dtdLocation) + "dispatcher-traininfo.dtd");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "text/xsl");
        m.put("href", "/xml/XSLT/dispatcher-traininfo.xsl");
        ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
        this.doc.addContent(0, (Content)p);
        Element traininfo = new Element("traininfo");
        traininfo.setAttribute("version", "3");
        traininfo.setAttribute("transitname", tf.getTransitName());
        traininfo.setAttribute("transitid", tf.getTransitId());
        traininfo.setAttribute("trainname", tf.getTrainName());
        traininfo.setAttribute("dccaddress", tf.getDccAddress());
        traininfo.setAttribute("trainintransit", tf.getTrainInTransit() ? "yes" : "no");
        traininfo.setAttribute("startblockname", tf.getStartBlockName());
        traininfo.setAttribute("startblockid", tf.getStartBlockId());
        traininfo.setAttribute("startblockseq", Integer.toString(tf.getStartBlockSeq()));
        traininfo.setAttribute("endblockname", tf.getDestinationBlockName());
        traininfo.setAttribute("endblockid", tf.getDestinationBlockId());
        traininfo.setAttribute("endblockseq", Integer.toString(tf.getDestinationBlockSeq()));
        traininfo.setAttribute("trainfromroster", tf.getTrainFromRoster() ? "yes" : "no");
        traininfo.setAttribute("trainfromtrains", tf.getTrainFromTrains() ? "yes" : "no");
        traininfo.setAttribute("trainfromuser", tf.getTrainFromUser() ? "yes" : "no");
        traininfo.setAttribute("priority", Integer.toString(tf.getPriority()));
        traininfo.setAttribute("resetwhendone", tf.getResetWhenDone() ? "yes" : "no");
        switch (tf.getDelayedRestart()) {
            case 2: {
                traininfo.setAttribute("delayedrestart", "sensor");
                traininfo.setAttribute("delayedrestartsensor", tf.getRestartSensorName());
                traininfo.setAttribute("resetrestartsensor", tf.getResetRestartSensor() ? "yes" : "no");
                break;
            }
            case 1: {
                traininfo.setAttribute("delayedrestart", "timed");
                traininfo.setAttribute("delayedrestarttime", Integer.toString(tf.getRestartDelayMin()));
                break;
            }
            default: {
                traininfo.setAttribute("delayedrestart", "no");
            }
        }
        traininfo.setAttribute("reverseatend", tf.getReverseAtEnd() ? "yes" : "no");
        if (tf.getDelayedStart() == 1) {
            traininfo.setAttribute("delayedstart", "timed");
        } else if (tf.getDelayedStart() == 2) {
            traininfo.setAttribute("delayedstart", "sensor");
            if (tf.getDelaySensorName() != null) {
                traininfo.setAttribute("delayedSensor", tf.getDelaySensorName());
                traininfo.setAttribute("resetstartsensor", tf.getResetStartSensor() ? "yes" : "no");
            }
        }
        traininfo.setAttribute("terminatewhendone", tf.getTerminateWhenDone() ? "yes" : "no");
        traininfo.setAttribute("departuretimehr", Integer.toString(tf.getDepartureTimeHr()));
        traininfo.setAttribute("departuretimemin", Integer.toString(tf.getDepartureTimeMin()));
        traininfo.setAttribute("traintype", tf.getTrainType());
        traininfo.setAttribute("autorun", tf.getAutoRun() ? "yes" : "no");
        traininfo.setAttribute("loadatstartup", tf.getLoadAtStartup() ? "yes" : "no");
        traininfo.setAttribute("allocatealltheway", tf.getAllocateAllTheWay() ? "yes" : "no");
        traininfo.setAttribute("allocationmethod", Integer.toString(tf.getAllocationMethod()));
        traininfo.setAttribute("speedfactor", Float.toString(tf.getSpeedFactor().floatValue()));
        traininfo.setAttribute("maxspeed", Float.toString(tf.getMaxSpeed().floatValue()));
        traininfo.setAttribute("ramprate", tf.getRampRate());
        traininfo.setAttribute("resistancewheels", tf.getResistanceWheels() ? "yes" : "no");
        traininfo.setAttribute("runinreverse", tf.getRunInReverse() ? "yes" : "no");
        traininfo.setAttribute("sounddecoder", tf.getSoundDecoder() ? "yes" : "no");
        traininfo.setAttribute("maxtrainlength", Float.toString(tf.getMaxTrainLength()));
        traininfo.setAttribute("usespeedprofile", tf.getUseSpeedProfile() ? "yes" : "no");
        traininfo.setAttribute("stopbyspeedprofile", tf.getStopBySpeedProfile() ? "yes" : "no");
        traininfo.setAttribute("stopbyspeedprofileadjust", Float.toString(tf.getStopBySpeedProfileAdjust()));
        this.root.addContent((Content)traininfo);
        try {
            File file;
            if (!this.checkFile(String.valueOf(this.fileLocation) + name) && !(file = new File(String.valueOf(this.fileLocation) + name)).createNewFile()) {
                log.error("createNewFile failed");
            }
            this.writeXML(this.findFile(String.valueOf(this.fileLocation) + name), this.doc);
        }
        catch (IOException ioe) {
            log.error("IO Exception {}", (Throwable)ioe);
            throw ioe;
        }
    }

    public String[] getTrainInfoFileNames() {
        String[] xmlList;
        FileUtil.createDirectory(this.fileLocation);
        ArrayList<String> names = new ArrayList<String>();
        log.debug("directory of TrainInfoFiles is {}", (Object)this.fileLocation);
        File fp = new File(this.fileLocation);
        if (fp.exists() && (xmlList = fp.list(new XmlFilenameFilter())) != null) {
            names.addAll(Arrays.asList(xmlList));
        }
        names.sort((s1, s2) -> s1.compareTo((String)s2));
        return names.toArray(new String[names.size()]);
    }

    public void deleteTrainInfoFile(String name) {
        File f = new File(String.valueOf(this.fileLocation) + name);
        if (!f.delete()) {
            log.error("failed to delete TrainInfo file - {}", (Object)name);
        }
    }
}

