/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import jmri.InstanceManager;
import jmri.Scale;
import jmri.ScaleManager;
import jmri.UserPreferencesManager;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.dispatcher.Bundle;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.jmrit.dispatcher.OptionsFile;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.util.JmriJFrame;
import jmri.util.swing.JComboBoxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionsMenu
extends JMenu {
    protected DispatcherFrame dispatcher = null;
    private JCheckBoxMenuItem autoDispatchItem = null;
    private JCheckBoxMenuItem autoTurnoutsItem = null;
    JmriJFrame optionsFrame = null;
    Container optionsPane = null;
    JCheckBox useConnectivityCheckBox = new JCheckBox(Bundle.getMessage("UseConnectivity"));
    JComboBox<String> layoutEditorBox = new JComboBox();
    ArrayList<LayoutEditor> layoutEditorList = new ArrayList();
    JCheckBox autoAllocateCheckBox = new JCheckBox(Bundle.getMessage("AutoAllocateBox"));
    JCheckBox autoTurnoutsCheckBox = new JCheckBox(Bundle.getMessage("AutoTurnoutsBox"));
    JRadioButton trainsFromRoster = new JRadioButton(Bundle.getMessage("TrainsFromRoster"));
    JRadioButton trainsFromTrains = new JRadioButton(Bundle.getMessage("TrainsFromTrains"));
    JRadioButton trainsFromUser = new JRadioButton(Bundle.getMessage("TrainsFromUser"));
    JComboBox<String> signalTypeBox;
    JCheckBox detectionCheckBox = new JCheckBox(Bundle.getMessage("DetectionBox"));
    JCheckBox setSSLDirectionalSensorsCheckBox = new JCheckBox(Bundle.getMessage("SetSSLDirectionSensorsBox"));
    JCheckBox shortNameCheckBox = new JCheckBox(Bundle.getMessage("ShortNameBox"));
    JCheckBox nameInBlockCheckBox = new JCheckBox(Bundle.getMessage("NameInBlockBox"));
    JCheckBox rosterInBlockCheckBox = new JCheckBox(Bundle.getMessage("RosterInBlockBox"));
    JCheckBox extraColorForAllocatedCheckBox = new JCheckBox(Bundle.getMessage("ExtraColorForAllocatedBox"));
    JCheckBox nameInAllocatedBlockCheckBox = new JCheckBox(Bundle.getMessage("NameInAllocatedBlockBox"));
    JCheckBox supportVSDecoderCheckBox = new JCheckBox(Bundle.getMessage("SupportVSDecoder"));
    JComboBox<Scale> layoutScaleBox = new JComboBox();
    JRadioButton scaleFeet = new JRadioButton(Bundle.getMessage("ScaleFeet"));
    JRadioButton scaleMeters = new JRadioButton(Bundle.getMessage("ScaleMeters"));
    JCheckBox openDispatcherWithPanel = new JCheckBox(Bundle.getMessage("OpenDispatcherWithPanelBox"));
    JSpinner minThrottleIntervalSpinner = new JSpinner(new SpinnerNumberModel(100, 20, 1000, 1));
    JSpinner fullRampTimeSpinner = new JSpinner(new SpinnerNumberModel(5000, 1000, 20000, 1));
    JCheckBox trustKnownTurnoutsCheckBox = new JCheckBox(Bundle.getMessage("trustKnownTurnouts"));
    JComboBox<String> stoppingSpeedBox = new JComboBox();
    String[] signalTypes = new String[]{Bundle.getMessage("SignalType1"), Bundle.getMessage("SignalType2"), Bundle.getMessage("SignalType3")};
    private static final Logger log = LoggerFactory.getLogger(OptionsMenu.class);

    public OptionsMenu(DispatcherFrame f) {
        this.dispatcher = f;
        this.setText(Bundle.getMessage("MenuOptions"));
        this.autoDispatchItem = new JCheckBoxMenuItem(Bundle.getMessage("AutoDispatchItem"));
        this.add(this.autoDispatchItem);
        this.autoDispatchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OptionsMenu.this.handleAutoDispatch(event);
            }
        });
        this.autoTurnoutsItem = new JCheckBoxMenuItem(Bundle.getMessage("AutoTurnoutsItem"));
        this.add(this.autoTurnoutsItem);
        this.autoTurnoutsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OptionsMenu.this.handleAutoTurnouts(event);
            }
        });
        JMenuItem optionWindowItem = new JMenuItem(String.valueOf(Bundle.getMessage("OptionWindowItem")) + "...");
        this.add(optionWindowItem);
        optionWindowItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OptionsMenu.this.optionWindowRequested(event);
            }
        });
        JMenuItem saveOptionsItem = new JMenuItem(Bundle.getMessage("SaveOptionsItem"));
        this.add(saveOptionsItem);
        saveOptionsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OptionsMenu.this.saveRequested(event);
            }
        });
        this.initializeMenu();
    }

    public void initializeMenu() {
        this.autoDispatchItem.setSelected(this.dispatcher.getAutoAllocate());
        this.autoTurnoutsItem.setSelected(this.dispatcher.getAutoTurnouts());
    }

    private void handleAutoDispatch(ActionEvent e) {
        boolean set = this.autoDispatchItem.isSelected();
        this.dispatcher.setAutoAllocate(set);
    }

    private void handleAutoTurnouts(ActionEvent e) {
        boolean set = this.autoTurnoutsItem.isSelected();
        this.dispatcher.setAutoTurnouts(set);
    }

    private void optionWindowRequested(ActionEvent e) {
        if (this.optionsFrame == null) {
            this.optionsFrame = new JmriJFrame(Bundle.getMessage("OptionWindowItem"), false, true);
            this.optionsFrame.addHelpMenu("package.jmri.jmrit.dispatcher.Options", true);
            this.optionsPane = this.optionsFrame.getContentPane();
            this.optionsPane.setLayout(new BoxLayout(this.optionsFrame.getContentPane(), 1));
            JPanel p1 = new JPanel();
            p1.setLayout(new FlowLayout());
            p1.add(this.useConnectivityCheckBox);
            this.useConnectivityCheckBox.setToolTipText(Bundle.getMessage("UseConnectivityHint"));
            p1.add(this.layoutEditorBox);
            this.layoutEditorBox.setToolTipText(Bundle.getMessage("LayoutEditorHint"));
            this.signalTypeBox = new JComboBox<String>(this.signalTypes);
            p1.add(this.signalTypeBox);
            this.signalTypeBox.setToolTipText(Bundle.getMessage("SignalTypeHint"));
            this.optionsPane.add(p1);
            JPanel p2 = new JPanel();
            p2.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrainsFrom")));
            p2.setLayout(new FlowLayout());
            ButtonGroup trainsGroup = new ButtonGroup();
            p2.add(this.trainsFromRoster);
            this.trainsFromRoster.setToolTipText(Bundle.getMessage("TrainsFromRosterHint"));
            trainsGroup.add(this.trainsFromRoster);
            ActionListener useRosterEntryListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (OptionsMenu.this.trainsFromRoster.isSelected()) {
                        OptionsMenu.this.rosterInBlockCheckBox.setEnabled(true);
                        if (OptionsMenu.this.nameInBlockCheckBox.isSelected() && e.getSource() == OptionsMenu.this.nameInBlockCheckBox) {
                            OptionsMenu.this.rosterInBlockCheckBox.setSelected(false);
                        } else if (OptionsMenu.this.rosterInBlockCheckBox.isSelected() && e.getSource() == OptionsMenu.this.rosterInBlockCheckBox) {
                            OptionsMenu.this.nameInBlockCheckBox.setSelected(false);
                        }
                    } else {
                        OptionsMenu.this.rosterInBlockCheckBox.setEnabled(false);
                    }
                }
            };
            this.trainsFromRoster.addActionListener(useRosterEntryListener);
            p2.add(new JLabel("     "));
            p2.add(this.trainsFromTrains);
            this.trainsFromTrains.setToolTipText(Bundle.getMessage("TrainsFromTrainsHint"));
            this.trainsFromTrains.addActionListener(useRosterEntryListener);
            trainsGroup.add(this.trainsFromTrains);
            p2.add(new JLabel("     "));
            p2.add(this.trainsFromUser);
            this.trainsFromUser.setToolTipText(Bundle.getMessage("TrainsFromUserHint"));
            this.trainsFromUser.addActionListener(useRosterEntryListener);
            trainsGroup.add(this.trainsFromUser);
            this.optionsPane.add(p2);
            JPanel p3 = new JPanel();
            p3.setLayout(new FlowLayout());
            p3.add(this.detectionCheckBox);
            this.detectionCheckBox.setToolTipText(Bundle.getMessage("DetectionBoxHint"));
            this.optionsPane.add(p3);
            JPanel p3A = new JPanel();
            p3A.setLayout(new FlowLayout());
            p3A.add(this.setSSLDirectionalSensorsCheckBox);
            this.setSSLDirectionalSensorsCheckBox.setToolTipText(Bundle.getMessage("SetSSLDirectionSensorsBoxHint"));
            this.optionsPane.add(p3A);
            JPanel p4 = new JPanel();
            p4.setLayout(new FlowLayout());
            p4.add(this.autoAllocateCheckBox);
            this.autoAllocateCheckBox.setToolTipText(Bundle.getMessage("AutoAllocateBoxHint"));
            this.optionsPane.add(p4);
            JPanel p5 = new JPanel();
            p5.setLayout(new FlowLayout());
            p5.add(this.autoTurnoutsCheckBox);
            this.autoTurnoutsCheckBox.setToolTipText(Bundle.getMessage("AutoTurnoutsBoxHint"));
            this.optionsPane.add(p5);
            JPanel p16 = new JPanel();
            p16.setLayout(new FlowLayout());
            p16.add(this.trustKnownTurnoutsCheckBox);
            this.trustKnownTurnoutsCheckBox.setToolTipText(Bundle.getMessage("trustKnownTurnoutsHint"));
            this.optionsPane.add(p16);
            JPanel p6 = new JPanel();
            p6.setLayout(new FlowLayout());
            p6.add(this.shortNameCheckBox);
            this.shortNameCheckBox.setToolTipText(Bundle.getMessage("ShortNameBoxHint"));
            this.optionsPane.add(p6);
            JPanel p7 = new JPanel();
            p7.setLayout(new FlowLayout());
            p7.add(this.nameInBlockCheckBox);
            this.nameInBlockCheckBox.setToolTipText(Bundle.getMessage("NameInBlockBoxHint"));
            this.nameInBlockCheckBox.addActionListener(useRosterEntryListener);
            this.optionsPane.add(p7);
            JPanel p7b = new JPanel();
            p7b.setLayout(new FlowLayout());
            p7b.add(this.rosterInBlockCheckBox);
            this.rosterInBlockCheckBox.setToolTipText(Bundle.getMessage("RosterInBlockBoxHint"));
            this.rosterInBlockCheckBox.addActionListener(useRosterEntryListener);
            this.optionsPane.add(p7b);
            JPanel p10 = new JPanel();
            p10.setLayout(new FlowLayout());
            p10.add(this.extraColorForAllocatedCheckBox);
            this.extraColorForAllocatedCheckBox.setToolTipText(Bundle.getMessage("ExtraColorForAllocatedBoxHint"));
            this.optionsPane.add(p10);
            JPanel p11 = new JPanel();
            p11.setLayout(new FlowLayout());
            p11.add(this.nameInAllocatedBlockCheckBox);
            this.nameInAllocatedBlockCheckBox.setToolTipText(Bundle.getMessage("NameInAllocatedBlockBoxHint"));
            this.optionsPane.add(p11);
            JPanel p13 = new JPanel();
            p13.setLayout(new FlowLayout());
            p13.add(this.supportVSDecoderCheckBox);
            this.supportVSDecoderCheckBox.setToolTipText(Bundle.getMessage("SupportVSDecoderBoxHint"));
            this.optionsPane.add(p13);
            JPanel p8 = new JPanel();
            this.initializeScaleCombo();
            p8.add(new JLabel(Bundle.getMessage("LabelLayoutScale")));
            p8.add(this.layoutScaleBox);
            this.layoutScaleBox.setToolTipText(Bundle.getMessage("ScaleBoxHint"));
            this.optionsPane.add(p8);
            JPanel p12 = new JPanel();
            p12.setLayout(new FlowLayout());
            p12.add(new JLabel(String.valueOf(Bundle.getMessage("Units")) + "  "));
            ButtonGroup scaleGroup = new ButtonGroup();
            p12.add(this.scaleFeet);
            this.scaleFeet.setToolTipText(Bundle.getMessage("ScaleFeetHint"));
            scaleGroup.add(this.scaleFeet);
            p12.add(new JLabel("  "));
            p12.add(this.scaleMeters);
            this.scaleMeters.setToolTipText(Bundle.getMessage("ScaleMetersHint"));
            scaleGroup.add(this.scaleMeters);
            this.optionsPane.add(p12);
            JPanel p14 = new JPanel();
            this.initializeStoppingSpeedCombo();
            p14.add(new JLabel(Bundle.getMessage("LabelStoppingSpeed")));
            p14.add(this.stoppingSpeedBox);
            this.stoppingSpeedBox.setToolTipText(Bundle.getMessage("StoppingSpeedHint"));
            this.optionsPane.add(p14);
            JPanel p15 = new JPanel();
            p15.setLayout(new FlowLayout());
            p15.add(new JLabel(String.valueOf(Bundle.getMessage("minThrottleInterval")) + ":"));
            this.minThrottleIntervalSpinner.setToolTipText(Bundle.getMessage("minThrottleIntervalHint"));
            p15.add(this.minThrottleIntervalSpinner);
            p15.add(new JLabel(Bundle.getMessage("LabelMilliseconds")));
            this.optionsPane.add(p15);
            JPanel p17 = new JPanel();
            p17.setLayout(new FlowLayout());
            p17.add(new JLabel(String.valueOf(Bundle.getMessage("fullRampTime")) + " :"));
            this.fullRampTimeSpinner.setToolTipText(Bundle.getMessage("fullRampTimeHint", Bundle.getMessage("RAMP_FAST")));
            p17.add(this.fullRampTimeSpinner);
            p17.add(new JLabel(Bundle.getMessage("LabelMilliseconds")));
            this.optionsPane.add(p17);
            JPanel p18 = new JPanel();
            p18.setLayout(new FlowLayout());
            p18.add(this.openDispatcherWithPanel);
            this.openDispatcherWithPanel.setToolTipText(Bundle.getMessage("OpenDispatcherWithPanelBoxHint"));
            this.optionsPane.add(p18);
            this.optionsPane.add(new JSeparator());
            JPanel p9 = new JPanel();
            p9.setLayout(new FlowLayout());
            JButton cancelButton = null;
            cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
            p9.add(cancelButton);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsMenu.this.cancelOptions(e);
                }
            });
            cancelButton.setToolTipText(Bundle.getMessage("CancelButtonHint2"));
            p9.add(new JLabel("     "));
            JButton applyButton = null;
            applyButton = new JButton(Bundle.getMessage("ButtonApply"));
            p9.add(applyButton);
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsMenu.this.applyOptions(e);
                }
            });
            applyButton.setToolTipText(Bundle.getMessage("ApplyButtonHint"));
            this.optionsPane.add(p9);
        }
        if (this.initializeLayoutEditorCombo()) {
            this.useConnectivityCheckBox.setVisible(true);
            this.layoutEditorBox.setVisible(true);
        } else {
            this.useConnectivityCheckBox.setVisible(false);
            this.layoutEditorBox.setVisible(false);
        }
        this.useConnectivityCheckBox.setSelected(this.dispatcher.getUseConnectivity());
        this.signalTypeBox.setSelectedIndex(this.dispatcher.getSignalType());
        switch (this.dispatcher.getTrainsFrom()) {
            case TRAINSFROMROSTER: {
                this.trainsFromRoster.setSelected(true);
                break;
            }
            case TRAINSFROMOPS: {
                this.trainsFromTrains.setSelected(true);
                break;
            }
            default: {
                this.trainsFromUser.setSelected(true);
            }
        }
        this.detectionCheckBox.setSelected(this.dispatcher.getHasOccupancyDetection());
        this.setSSLDirectionalSensorsCheckBox.setSelected(this.dispatcher.getSetSSLDirectionalSensors());
        this.autoAllocateCheckBox.setSelected(this.dispatcher.getAutoAllocate());
        this.autoTurnoutsCheckBox.setSelected(this.dispatcher.getAutoTurnouts());
        this.trustKnownTurnoutsCheckBox.setSelected(this.dispatcher.getTrustKnownTurnouts());
        this.shortNameCheckBox.setSelected(this.dispatcher.getShortActiveTrainNames());
        this.nameInBlockCheckBox.setSelected(this.dispatcher.getShortNameInBlock());
        this.rosterInBlockCheckBox.setSelected(this.dispatcher.getRosterEntryInBlock());
        this.extraColorForAllocatedCheckBox.setSelected(this.dispatcher.getExtraColorForAllocated());
        this.nameInAllocatedBlockCheckBox.setSelected(this.dispatcher.getNameInAllocatedBlock());
        this.supportVSDecoderCheckBox.setSelected(this.dispatcher.getSupportVSDecoder());
        this.scaleMeters.setSelected(this.dispatcher.getUseScaleMeters());
        this.scaleFeet.setSelected(!this.dispatcher.getUseScaleMeters());
        this.minThrottleIntervalSpinner.setValue(this.dispatcher.getMinThrottleInterval());
        this.fullRampTimeSpinner.setValue(this.dispatcher.getFullRampTime());
        if (this.dispatcher.getLayoutEditor() != null) {
            this.openDispatcherWithPanel.setSelected(this.dispatcher.getLayoutEditor().getOpenDispatcherOnLoad());
        }
        this.optionsFrame.pack();
        this.optionsFrame.setVisible(true);
    }

    private void applyOptions(ActionEvent e) {
        if (this.layoutEditorList.size() > 0) {
            int index = this.layoutEditorBox.getSelectedIndex();
            this.dispatcher.setLayoutEditor(this.layoutEditorList.get(index));
            this.dispatcher.setUseConnectivity(this.useConnectivityCheckBox.isSelected());
        }
        this.dispatcher.setSetSSLDirectionalSensors(this.setSSLDirectionalSensorsCheckBox.isSelected());
        if (this.trainsFromRoster.isSelected()) {
            this.dispatcher.setTrainsFrom(DispatcherFrame.TrainsFrom.TRAINSFROMROSTER);
        } else if (this.trainsFromTrains.isSelected()) {
            this.dispatcher.setTrainsFrom(DispatcherFrame.TrainsFrom.TRAINSFROMOPS);
        } else {
            this.dispatcher.setTrainsFrom(DispatcherFrame.TrainsFrom.TRAINSFROMUSER);
        }
        this.dispatcher.setHasOccupancyDetection(this.detectionCheckBox.isSelected());
        this.dispatcher.setAutoAllocate(this.autoAllocateCheckBox.isSelected());
        this.autoDispatchItem.setSelected(this.autoAllocateCheckBox.isSelected());
        this.dispatcher.setAutoTurnouts(this.autoTurnoutsCheckBox.isSelected());
        this.autoTurnoutsItem.setSelected(this.autoTurnoutsCheckBox.isSelected());
        this.dispatcher.setTrustKnownTurnouts(this.trustKnownTurnoutsCheckBox.isSelected());
        this.dispatcher.setSignalType(this.signalTypeBox.getSelectedIndex());
        if (this.autoTurnoutsCheckBox.isSelected() && (this.layoutEditorList.size() == 0 || !this.useConnectivityCheckBox.isSelected())) {
            JOptionPane.showMessageDialog(this.optionsFrame, Bundle.getMessage("AutoTurnoutsWarn"), Bundle.getMessage("WarningTitle"), 2);
        }
        this.dispatcher.setShortActiveTrainNames(this.shortNameCheckBox.isSelected());
        this.dispatcher.setShortNameInBlock(this.nameInBlockCheckBox.isSelected());
        this.dispatcher.setExtraColorForAllocated(this.extraColorForAllocatedCheckBox.isSelected());
        this.dispatcher.setNameInAllocatedBlock(this.nameInAllocatedBlockCheckBox.isSelected());
        this.dispatcher.setRosterEntryInBlock(this.rosterInBlockCheckBox.isSelected());
        this.dispatcher.setSupportVSDecoder(this.supportVSDecoderCheckBox.isSelected());
        this.dispatcher.setScale((Scale)this.layoutScaleBox.getSelectedItem());
        this.dispatcher.setUseScaleMeters(this.scaleMeters.isSelected());
        this.dispatcher.setMinThrottleInterval((Integer)this.minThrottleIntervalSpinner.getValue());
        this.dispatcher.setFullRampTime((Integer)this.fullRampTimeSpinner.getValue());
        this.dispatcher.getLayoutEditor().setOpenDispatcherOnLoad(this.openDispatcherWithPanel.isSelected());
        this.dispatcher.setStoppingSpeedName((String)this.stoppingSpeedBox.getSelectedItem());
        this.optionsFrame.setVisible(false);
        this.optionsFrame.dispose();
        this.optionsFrame = null;
        InstanceManager.getDefault(UserPreferencesManager.class).showInfoMessage(Bundle.getMessage("ReminderTitle"), Bundle.getMessage("ReminderSaveOptions"), OptionsMenu.class.getName(), "remindSaveDispatcherOptions");
        this.initializeMenu();
    }

    private void cancelOptions(ActionEvent e) {
        this.optionsFrame.setVisible(false);
        this.optionsFrame.dispose();
        this.optionsFrame = null;
    }

    private void saveRequested(ActionEvent e) {
        try {
            InstanceManager.getDefault(OptionsFile.class).writeDispatcherOptions(this.dispatcher);
        }
        catch (IOException ioe) {
            log.error("Exception writing Dispatcher options: {}", (Throwable)ioe);
        }
    }

    private boolean initializeLayoutEditorCombo() {
        this.layoutEditorList = new ArrayList<LayoutEditor>(InstanceManager.getDefault(EditorManager.class).getAll(LayoutEditor.class));
        if (this.layoutEditorList.isEmpty()) {
            return false;
        }
        this.layoutEditorBox.removeAllItems();
        int i = 0;
        while (i < this.layoutEditorList.size()) {
            this.layoutEditorBox.addItem(this.layoutEditorList.get(i).getTitle());
            ++i;
        }
        if (this.layoutEditorList.size() > 1) {
            LayoutEditor le = this.dispatcher.getLayoutEditor();
            int j = 0;
            while (j < this.layoutEditorList.size()) {
                if (le == this.layoutEditorList.get(j)) {
                    this.layoutEditorBox.setSelectedIndex(j);
                }
                ++j;
            }
        } else {
            this.layoutEditorBox.setSelectedIndex(0);
        }
        return true;
    }

    private void initializeScaleCombo() {
        this.layoutScaleBox.removeAllItems();
        for (Scale scale : ScaleManager.getScales()) {
            if (scale.getScaleName().equals("CUSTOM")) continue;
            this.layoutScaleBox.addItem(scale);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this.layoutScaleBox);
        this.layoutScaleBox.setSelectedItem(this.dispatcher.getScale());
    }

    private void initializeStoppingSpeedCombo() {
        this.stoppingSpeedBox.removeAllItems();
        Enumeration<String> speedNamesList = InstanceManager.getDefault(SignalSpeedMap.class).getSpeedIterator();
        while (speedNamesList.hasMoreElements()) {
            this.stoppingSpeedBox.addItem(speedNamesList.nextElement());
        }
        this.stoppingSpeedBox.setSelectedItem(this.dispatcher.getStoppingSpeedName());
    }
}

