/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import java.util.ArrayList;
import java.util.List;
import jmri.Block;
import jmri.EntryPoint;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Section;
import jmri.Transit;
import jmri.Turnout;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.jmrit.display.layoutEditor.ConnectivityUtil;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutTrackExpectedState;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoTurnouts {
    private static final NamedBean.DisplayOptions USERSYS = NamedBean.DisplayOptions.USERNAME_SYSTEMNAME;
    private final String closedText = InstanceManager.turnoutManagerInstance().getClosedText();
    private final String thrownText = InstanceManager.turnoutManagerInstance().getThrownText();
    protected DispatcherFrame _dispatcher = null;
    boolean userInformed = false;
    private static final Logger log = LoggerFactory.getLogger(AutoTurnouts.class);

    public AutoTurnouts(DispatcherFrame d) {
        this._dispatcher = d;
    }

    protected List<LayoutTrackExpectedState<LayoutTurnout>> checkTurnoutsInSection(Section s, int seqNum, Section nextSection, ActiveTrain at, LayoutEditor le, Section prevSection) {
        return this.turnoutUtil(s, seqNum, nextSection, at, le, false, false, prevSection);
    }

    protected List<LayoutTrackExpectedState<LayoutTurnout>> setTurnoutsInSection(Section s, int seqNum, Section nextSection, ActiveTrain at, LayoutEditor le, boolean trustKnownTurnouts, Section prevSection) {
        return this.turnoutUtil(s, seqNum, nextSection, at, le, trustKnownTurnouts, true, prevSection);
    }

    protected Turnout checkStateAgainstList(List<LayoutTrackExpectedState<LayoutTurnout>> turnoutList) {
        if (turnoutList != null) {
            for (LayoutTrackExpectedState<LayoutTurnout> tes : turnoutList) {
                Turnout to = ((LayoutTurnout)tes.getObject()).getTurnout();
                int setting = tes.getExpectedState();
                if (tes.getObject() instanceof LayoutSlip) {
                    setting = ((LayoutSlip)tes.getObject()).getTurnoutState(tes.getExpectedState());
                }
                if (to.getKnownState() != setting) {
                    return to;
                }
                if (!(tes.getObject() instanceof LayoutSlip)) continue;
                setting = ((LayoutSlip)tes.getObject()).getTurnoutBState(tes.getExpectedState());
                to = ((LayoutSlip)tes.getObject()).getTurnoutB();
                if (to.getKnownState() == setting) continue;
                return to;
            }
        }
        return null;
    }

    private List<LayoutTrackExpectedState<LayoutTurnout>> turnoutUtil(Section s, int seqNum, Section nextSection, ActiveTrain at, LayoutEditor le, boolean trustKnownTurnouts, boolean set, Section prevSection) {
        int curBlockSeqNum;
        Block curBlock;
        ArrayList<LayoutTrackExpectedState<LayoutTurnout>> turnoutListForAllocatedSection = new ArrayList<LayoutTrackExpectedState<LayoutTurnout>>();
        Transit tran = at.getTransit();
        if (s == null || seqNum > tran.getMaxSequence() || !tran.containsSection(s) || le == null) {
            log.error("Invalid argument when checking or setting turnouts in Section.");
            return null;
        }
        int direction = at.getAllocationDirectionFromSectionAndSeq(s, seqNum);
        if (direction == 0) {
            log.error("Invalid Section/sequence arguments when checking or setting turnouts");
            return null;
        }
        if (this._dispatcher.getSignalType() == 0 && s.getForwardEntryPointList().size() <= 1 && s.getReverseEntryPointList().size() <= 1) {
            log.debug("No entry points lists");
            return turnoutListForAllocatedSection;
        }
        ConnectivityUtil ct = le.getConnectivityUtil();
        EntryPoint entryPt = null;
        if (prevSection != null) {
            entryPt = s.getEntryPointFromSection(prevSection, direction);
        } else if (!s.containsBlock(at.getStartBlock())) {
            entryPt = s.getEntryPointFromBlock(at.getStartBlock(), direction);
        }
        EntryPoint exitPt = null;
        if (nextSection != null) {
            exitPt = s.getExitPointToSection(nextSection, direction);
        }
        Block prevBlock = null;
        if (entryPt != null) {
            curBlock = entryPt.getBlock();
            prevBlock = entryPt.getFromBlock();
            curBlockSeqNum = s.getBlockSequenceNumber(curBlock);
        } else if (!at.isAllocationReversed() && s.containsBlock(at.getStartBlock())) {
            curBlock = at.getStartBlock();
            curBlockSeqNum = s.getBlockSequenceNumber(curBlock);
            if (direction == 4) {
                prevBlock = s.getBlockBySequenceNumber(curBlockSeqNum - 1);
            } else if (direction == 8) {
                prevBlock = s.getBlockBySequenceNumber(curBlockSeqNum + 1);
            }
        } else if (at.isAllocationReversed() && s.containsBlock(at.getEndBlock())) {
            curBlock = at.getEndBlock();
            curBlockSeqNum = s.getBlockSequenceNumber(curBlock);
            if (direction == 8) {
                prevBlock = s.getBlockBySequenceNumber(curBlockSeqNum + 1);
            } else if (direction == 4) {
                prevBlock = s.getBlockBySequenceNumber(curBlockSeqNum - 1);
            }
        } else {
            try {
                log.error("[{}]direction[{}] Section[{}]Error in turnout check/set request - initial Block[{}] and Section[{}] mismatch", new Object[]{at.getActiveTrainName(), at.isAllocationReversed(), s.getDisplayName(USERSYS), at.getStartBlock().getUserName(), at.getEndBlock().getDisplayName(USERSYS)});
            }
            catch (Exception ex) {
                log.warn(ex.getLocalizedMessage());
            }
            return turnoutListForAllocatedSection;
        }
        Block nextBlock = null;
        int nextBlockSeqNum = -1;
        if (exitPt != null && curBlock == exitPt.getBlock()) {
            nextBlock = exitPt.getFromBlock();
        } else {
            if (direction == 4) {
                nextBlock = s.getBlockBySequenceNumber(curBlockSeqNum + 1);
                nextBlockSeqNum = curBlockSeqNum + 1;
            } else if (direction == 8) {
                nextBlock = s.getBlockBySequenceNumber(curBlockSeqNum - 1);
                nextBlockSeqNum = curBlockSeqNum - 1;
            }
            if (nextBlock == null && (!at.isAllocationReversed() && curBlock != at.getEndBlock() || at.isAllocationReversed() && curBlock != at.getStartBlock())) {
                log.error("[{}]Error in block sequence numbers when setting/checking turnouts.", (Object)curBlock.getDisplayName(USERSYS));
                return null;
            }
        }
        List<Object> turnoutList = new ArrayList();
        boolean turnoutsOK = true;
        while (curBlock != null) {
            if (prevBlock != null) {
                turnoutList = ct.getTurnoutList(curBlock, prevBlock, nextBlock);
            }
            int i = 0;
            while (i < turnoutList.size()) {
                Turnout to = ((LayoutTurnout)((LayoutTrackExpectedState)turnoutList.get(i)).getObject()).getTurnout();
                if (to == null) {
                    log.error("Found null Turnout reference at {}: {}", (Object)i, ((LayoutTrackExpectedState)turnoutList.get(i)).getObject());
                } else {
                    turnoutListForAllocatedSection.add((LayoutTrackExpectedState)turnoutList.get(i));
                    int setting = ((LayoutTrackExpectedState)turnoutList.get(i)).getExpectedState();
                    if (((LayoutTrackExpectedState)turnoutList.get(i)).getObject() instanceof LayoutSlip) {
                        setting = ((LayoutSlip)((LayoutTrackExpectedState)turnoutList.get(i)).getObject()).getTurnoutState(((LayoutTrackExpectedState)turnoutList.get(i)).getExpectedState());
                    }
                    if (!trustKnownTurnouts) {
                        log.debug("{}: setting turnout {} to {}", new Object[]{at.getTrainName(), to.getDisplayName(USERSYS), setting == 2 ? this.closedText : this.thrownText});
                        to.setCommandedState(setting);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else if (to.getKnownState() != setting) {
                        if (set) {
                            if (s.getState() == 2 && curBlock.getState() != 2) {
                                log.debug("{}: turnout {} commanded to {}", new Object[]{at.getTrainName(), to.getDisplayName(USERSYS), setting == 2 ? this.closedText : this.thrownText});
                                to.setCommandedState(setting);
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {}
                            } else {
                                turnoutsOK = false;
                            }
                        } else {
                            turnoutsOK = false;
                        }
                    } else {
                        log.debug("{}: turnout {} already {}, skipping", new Object[]{at.getTrainName(), to.getDisplayName(USERSYS), setting == 2 ? this.closedText : this.thrownText});
                    }
                    if (((LayoutTrackExpectedState)turnoutList.get(i)).getObject() instanceof LayoutSlip) {
                        setting = ((LayoutSlip)((LayoutTrackExpectedState)turnoutList.get(i)).getObject()).getTurnoutBState(((LayoutTrackExpectedState)turnoutList.get(i)).getExpectedState());
                        to = ((LayoutSlip)((LayoutTrackExpectedState)turnoutList.get(i)).getObject()).getTurnoutB();
                        if (!trustKnownTurnouts) {
                            to.setCommandedState(setting);
                        } else if (to.getKnownState() != setting) {
                            if (set) {
                                if (s.getState() == 2 && curBlock.getState() != 2) {
                                    to.setCommandedState(setting);
                                } else {
                                    turnoutsOK = false;
                                }
                            } else {
                                turnoutsOK = false;
                            }
                        }
                    }
                }
                ++i;
            }
            if (turnoutsOK) {
                if (nextBlockSeqNum >= 0) {
                    prevBlock = curBlock;
                    curBlock = nextBlock;
                    if (exitPt != null && curBlock == exitPt.getBlock()) {
                        nextBlock = exitPt.getFromBlock();
                        nextBlockSeqNum = -1;
                        continue;
                    }
                    nextBlockSeqNum = direction == 4 ? ++nextBlockSeqNum : --nextBlockSeqNum;
                    nextBlock = s.getBlockBySequenceNumber(nextBlockSeqNum);
                    if (nextBlock != null) continue;
                    nextBlockSeqNum = -1;
                    continue;
                }
                curBlock = null;
                continue;
            }
            curBlock = null;
        }
        if (turnoutsOK) {
            return turnoutListForAllocatedSection;
        }
        return null;
    }
}

