/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.Throttle;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.AutoActiveTrain;
import jmri.jmrit.dispatcher.Bundle;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoTrainsFrame
extends JmriJFrame {
    private final DispatcherFrame _dispatcher;
    private final ArrayList<AutoActiveTrain> _autoTrainsList = new ArrayList();
    private final ArrayList<PropertyChangeListener> _listeners = new ArrayList();
    private final ArrayList<Throttle> _throttles = new ArrayList();
    private final ArrayList<PropertyChangeListener> _throttleListeners = new ArrayList();
    protected JmriJFrame autoTrainsFrame = null;
    private Container contentPane = null;
    private final ArrayList<JPanel> _JPanels = new ArrayList();
    private final ArrayList<JLabel> _throttleStatus = new ArrayList();
    private final ArrayList<JLabel> _trainLabels = new ArrayList();
    private final ArrayList<JButton> _stopButtons = new ArrayList();
    private final ArrayList<JButton> _manualButtons = new ArrayList();
    private final ArrayList<JButton> _resumeAutoRunningButtons = new ArrayList();
    private final ArrayList<JRadioButton> _forwardButtons = new ArrayList();
    private final ArrayList<JRadioButton> _reverseButtons = new ArrayList();
    private final ArrayList<JSlider> _speedSliders = new ArrayList();
    private final ArrayList<JSeparator> _separators = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(AutoTrainsFrame.class);

    public AutoTrainsFrame(DispatcherFrame disp) {
        super(false, true);
        this._dispatcher = disp;
        this.initializeAutoTrainsWindow();
    }

    public ArrayList<AutoActiveTrain> getAutoTrainsList() {
        return this._autoTrainsList;
    }

    public void addAutoActiveTrain(AutoActiveTrain aat) {
        if (aat != null) {
            this._autoTrainsList.add(aat);
            PropertyChangeListener throttleListener = this::handleThrottleChange;
            this._throttleListeners.add(throttleListener);
            this._throttles.add(null);
            this.setupThrottle(aat);
            ActiveTrain at = aat.getActiveTrain();
            PropertyChangeListener listener = this::handleActiveTrainChange;
            at.addPropertyChangeListener(listener);
            this._listeners.add(listener);
            this.displayAutoTrains();
        }
    }

    public void removeAutoActiveTrain(AutoActiveTrain aat) {
        int i = 0;
        while (i < this._autoTrainsList.size()) {
            if (this._autoTrainsList.get(i) == aat) {
                this.removeThrottleListener(aat);
                this._autoTrainsList.remove(i);
                ActiveTrain at = aat.getActiveTrain();
                at.removePropertyChangeListener(this._listeners.get(i));
                this._throttles.remove(i);
                this._listeners.remove(i);
                this._throttleListeners.remove(i);
                this.displayAutoTrains();
                return;
            }
            ++i;
        }
    }

    private void handleActiveTrainChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("mode")) {
            this.handleChangeOfMode(e);
        } else if (e.getPropertyName().equals("status")) {
            this.handleChangeOfStatus(e);
            this.handleChangeOfStatus(e);
        }
        this.displayAutoTrains();
    }

    private void handleChangeOfStatus(PropertyChangeEvent e) {
        if ((Integer)e.getOldValue() == 8) {
            this.addThrottleListener(((ActiveTrain)e.getSource()).getAutoActiveTrain());
        }
    }

    private synchronized void handleChangeOfMode(PropertyChangeEvent e) {
        for (AutoActiveTrain aat : this._autoTrainsList) {
            if (aat.getActiveTrain() != e.getSource()) continue;
            int newValue = (Integer)e.getNewValue();
            int oldValue = (Integer)e.getOldValue();
            if (newValue == 8) {
                this.removeThrottleListener(aat);
                continue;
            }
            if (oldValue != 8) continue;
            this.setupThrottle(aat);
        }
    }

    private void setupThrottle(AutoActiveTrain aat) {
        if (aat.getThrottle() != null) {
            int index = this._autoTrainsList.indexOf(aat);
            if (this._throttles.get(index) == null) {
                this._throttles.add(index, aat.getThrottle());
                this.addThrottleListener(aat);
            }
        } else {
            log.debug("{}: No Throttle (yet)", (Object)aat.getActiveTrain().getTrainName());
        }
    }

    private void handleThrottleChange(PropertyChangeEvent e) {
        JLabel status;
        if (!e.getPropertyName().equals("SpeedSetting") && !e.getPropertyName().equals("IsForward")) {
            return;
        }
        DccThrottle thr = (DccThrottle)e.getSource();
        int index = this._throttles.indexOf(thr);
        if (index == -1) {
            Throttle waThrottle1 = (Throttle)e.getSource();
            int DDCAddress = waThrottle1.getLocoAddress().getNumber();
            log.trace("handleThrottleChange - using locoaddress [{}]", (Object)DDCAddress);
            for (Throttle waThrottle : this._throttles) {
                if (waThrottle == null || DDCAddress != waThrottle.getLocoAddress().getNumber() || (index = this._throttles.indexOf(waThrottle)) != -1) continue;
                log.warn("handleThrottleChange - cannot find throttle DCCAddress");
                return;
            }
            if (index == -1) {
                log.warn("handleThrottleChange - cannot find throttle index");
                return;
            }
        }
        if (!(status = this._throttleStatus.get(index)).isVisible()) {
            return;
        }
        DccLocoAddress addy = (DccLocoAddress)this._throttles.get(index).getLocoAddress();
        this.updateStatusLabel(status, InstanceManager.throttleManagerInstance().getThrottleInfo(addy, "SpeedSetting"), InstanceManager.throttleManagerInstance().getThrottleInfo(addy, "IsForward"));
    }

    private void updateStatusLabel(JLabel status, Object speed, Object forward) {
        StringBuilder sb = new StringBuilder();
        int spd = Math.round(((Float)speed).floatValue() * 100.0f);
        sb.append("" + spd);
        sb.append("% ");
        if (((Boolean)forward).booleanValue()) {
            sb.append("(fwd)");
        } else {
            sb.append("(rev)");
        }
        status.setText(sb.toString());
        this.autoTrainsFrame.pack();
    }

    private void addThrottleListener(AutoActiveTrain aat) {
        int index = this._autoTrainsList.indexOf(aat);
        if (index == -1) {
            return;
        }
        if (this._throttles.get(index) != null) {
            DccLocoAddress addy = (DccLocoAddress)this._throttles.get(index).getLocoAddress();
            InstanceManager.throttleManagerInstance().attachListener(addy, this._throttleListeners.get(index));
            JLabel status = this._throttleStatus.get(index);
            this.updateStatusLabel(status, InstanceManager.throttleManagerInstance().getThrottleInfo(addy, "SpeedSetting"), InstanceManager.throttleManagerInstance().getThrottleInfo(addy, "IsForward"));
        }
    }

    private void removeThrottleListener(AutoActiveTrain aat) {
        int index = this._autoTrainsList.indexOf(aat);
        if (index == -1) {
            return;
        }
        if (this._throttles.get(index) != null) {
            InstanceManager.throttleManagerInstance().removeListener(this._throttles.get(index).getLocoAddress(), this._throttleListeners.get(index));
        }
    }

    private void initializeAutoTrainsWindow() {
        this.autoTrainsFrame = this;
        this.autoTrainsFrame.setTitle(Bundle.getMessage("TitleAutoTrains"));
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        this.autoTrainsFrame.addHelpMenu("package.jmri.jmrit.dispatcher.AutoTrains", true);
        this.contentPane = this.autoTrainsFrame.getContentPane();
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        int i = 0;
        while (i < 6) {
            this.newTrainLine();
            if (i == 0) {
                this._separators.get(i).setVisible(false);
            }
            ++i;
        }
        this.contentPane.add(new JSeparator());
        this.contentPane.add(new JSeparator());
        JPanel pB = new JPanel();
        pB.setLayout(new FlowLayout());
        JButton stopAllButton = new JButton(Bundle.getMessage("StopAll"));
        pB.add(stopAllButton);
        stopAllButton.addActionListener(this::stopAllPressed);
        stopAllButton.setToolTipText(Bundle.getMessage("StopAllButtonHint"));
        this.contentPane.add(pB);
        this.autoTrainsFrame.pack();
        this.placeWindow();
        this.displayAutoTrains();
        this.autoTrainsFrame.setVisible(true);
    }

    private void newSeparator() {
        JSeparator sep = new JSeparator();
        this._separators.add(sep);
        this.contentPane.add(sep);
    }

    private void newTrainLine() {
        int i = this._JPanels.size();
        String s = "" + i;
        this.newSeparator();
        JPanel px = new JPanel();
        px.setLayout(new FlowLayout());
        this._JPanels.add(px);
        JLabel tLabel = new JLabel("      ");
        px.add(tLabel);
        px.add(tLabel);
        this._trainLabels.add(tLabel);
        JButton tStop = new JButton(Bundle.getMessage("ResumeButton"));
        px.add(tStop);
        this._stopButtons.add(tStop);
        tStop.addActionListener(e -> this.stopResume(s));
        JButton tManual = new JButton(Bundle.getMessage("ToManualButton"));
        px.add(tManual);
        this._manualButtons.add(tManual);
        tManual.addActionListener(e -> this.manualAuto(s));
        JButton tResumeAuto = new JButton(Bundle.getMessage("ResumeAutoButton"));
        px.add(tResumeAuto);
        this._resumeAutoRunningButtons.add(tResumeAuto);
        tResumeAuto.addActionListener(e -> this.resumeAutoOperation(s));
        tResumeAuto.setVisible(false);
        tResumeAuto.setToolTipText(Bundle.getMessage("ResumeAutoButtonHint"));
        ButtonGroup directionGroup = new ButtonGroup();
        JRadioButton fBut = new JRadioButton(Bundle.getMessage("ForwardRadio"));
        px.add(fBut);
        this._forwardButtons.add(fBut);
        fBut.addActionListener(e -> this.directionButton(s));
        directionGroup.add(fBut);
        JRadioButton rBut = new JRadioButton(Bundle.getMessage("ReverseRadio"));
        px.add(rBut);
        this._reverseButtons.add(rBut);
        rBut.addActionListener(e -> this.directionButton(s));
        directionGroup.add(rBut);
        JSlider sSlider = new JSlider(0, 100, 0);
        px.add(sSlider);
        this._speedSliders.add(sSlider);
        sSlider.addChangeListener(e -> {
            int val = ((JSlider)e.getSource()).getValue();
            this.sliderChanged(s, val);
        });
        JLabel _throttle = new JLabel();
        _throttle.setPreferredSize(new Dimension(100, 20));
        _throttle.setText("Speed Unknown");
        this._throttleStatus.add(_throttle);
        px.add(_throttle);
        this.contentPane.add(px);
    }

    private void placeWindow() {
        Point dispPt = new Point(0, 0);
        Dimension dispDim = new Dimension(0, 0);
        if (this._dispatcher.isShowing()) {
            dispPt = this._dispatcher.getLocationOnScreen();
            dispDim = this._dispatcher.getSize();
        }
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int screenHeight = screenDim.height - 120;
        int screenWidth = screenDim.width - 20;
        Dimension dim = this.getSize();
        int width = dim.width;
        int height = dim.height;
        int upperLeftX = dispPt.x + dispDim.width;
        int upperLeftY = 0;
        if (upperLeftX + width > screenWidth) {
            upperLeftX = 0;
            upperLeftY = dispPt.y + dispDim.height;
            if (upperLeftY + height > screenHeight) {
                upperLeftY = 0;
            }
        }
        this.setLocation(upperLeftX, upperLeftY);
    }

    public void stopResume(String s) {
        int index = this.getTrainIndex(s);
        if (index >= 0) {
            AutoActiveTrain aat = this._autoTrainsList.get(index);
            if (aat.getAutoEngineer() != null) {
                ActiveTrain at = aat.getActiveTrain();
                if (at.getStatus() == 32) {
                    aat.setEngineDirection();
                    aat.getAutoEngineer().setHalt(false);
                    aat.restoreSavedSpeedAndDirection();
                    at.setStatus(aat.getSavedStatus());
                    if (at.getStatus() == 1 || at.getStatus() == 4) {
                        aat.setSpeedBySignal();
                    }
                } else if (at.getStatus() == 64) {
                    at.allocateAFresh();
                    at.restart();
                } else {
                    aat.getAutoEngineer().setHalt(true);
                    aat.saveSpeedAndDirection();
                    aat.setSavedStatus(at.getStatus());
                    at.setStatus(32);
                    if (at.getMode() == 4) {
                        this._speedSliders.get(index).setValue(0);
                    }
                }
            } else {
                log.error("unexpected null autoEngineer");
            }
        }
        this.displayAutoTrains();
    }

    public void manualAuto(String s) {
        int index = this.getTrainIndex(s);
        if (index >= 0) {
            AutoActiveTrain aat = this._autoTrainsList.get(index);
            ActiveTrain at = aat.getActiveTrain();
            if (at.getMode() == 2) {
                at.setMode(4);
                if (aat.getAutoEngineer() != null) {
                    aat.saveSpeedAndDirection();
                    aat.getAutoEngineer().setHalt(true);
                    aat.setTargetSpeed(0.0f);
                    aat.waitUntilStopped();
                    aat.getAutoEngineer().setHalt(false);
                }
            } else if (at.getMode() == 4) {
                at.setMode(2);
                aat.restoreSavedSpeedAndDirection();
                if ((at.getStatus() == 1 || at.getStatus() == 4) && aat.getCurrentSignal() != null) {
                    aat.setSpeedBySignal();
                }
            }
        }
        this.displayAutoTrains();
    }

    public void resumeAutoOperation(String s) {
        int index = this.getTrainIndex(s);
        if (index >= 0) {
            AutoActiveTrain aat = this._autoTrainsList.get(index);
            aat.resumeAutomaticRunning();
        }
        this.displayAutoTrains();
    }

    public void directionButton(String s) {
        int index = this.getTrainIndex(s);
        if (index >= 0) {
            AutoActiveTrain aat = this._autoTrainsList.get(index);
            ActiveTrain at = aat.getActiveTrain();
            if (at.getMode() == 4) {
                aat.setForward(this._forwardButtons.get(index).isSelected());
            } else {
                log.warn("unexpected direction button change on line {}", (Object)s);
            }
        }
    }

    public void sliderChanged(String s, int value) {
        int index = this.getTrainIndex(s);
        if (index >= 0) {
            AutoActiveTrain aat = this._autoTrainsList.get(index);
            ActiveTrain at = aat.getActiveTrain();
            if (at.getMode() == 4) {
                float speedValue = value;
                aat.getAutoEngineer().setSpeedImmediate(speedValue *= 0.01f);
            } else {
                log.warn("unexpected slider change on line {}", (Object)s);
            }
        }
    }

    private int getTrainIndex(String s) {
        int index = -1;
        try {
            index = Integer.parseInt(s);
        }
        catch (Exception exception) {
            log.warn("exception when parsing index from AutoTrains window - {}", (Object)s);
        }
        if (index >= 0 && index < this._autoTrainsList.size()) {
            return index;
        }
        log.error("bad train index in auto trains table {}", (Object)index);
        return -1;
    }

    public void stopAllPressed(ActionEvent e) {
        for (AutoActiveTrain aat : this._autoTrainsList) {
            ActiveTrain at = aat.getActiveTrain();
            if (at.getStatus() == 32 || aat.getAutoEngineer() == null) continue;
            aat.getAutoEngineer().setHalt(true);
            aat.saveSpeedAndDirection();
            aat.setSavedStatus(at.getStatus());
            at.setStatus(32);
        }
        this.displayAutoTrains();
    }

    protected void displayAutoTrains() {
        JSeparator sep;
        while (this._autoTrainsList.size() > this._JPanels.size()) {
            this.newTrainLine();
        }
        int i = 0;
        while (i < this._autoTrainsList.size()) {
            AutoActiveTrain aat = this._autoTrainsList.get(i);
            if (aat != null) {
                if (i > 0) {
                    sep = this._separators.get(i);
                    sep.setVisible(true);
                }
                JPanel panel = this._JPanels.get(i);
                panel.setVisible(true);
                ActiveTrain at = aat.getActiveTrain();
                JLabel tName = this._trainLabels.get(i);
                if (this._throttles.get(i) != null) {
                    this.updateStatusLabel(this._throttleStatus.get(i), Float.valueOf(this._throttles.get(i).getSpeedSetting()), this._throttles.get(i).getIsForward());
                } else {
                    this.updateStatusLabel(this._throttleStatus.get(i), Float.valueOf(0.0f), true);
                }
                tName.setText(at.getTrainName());
                JButton stopButton = this._stopButtons.get(i);
                if (at.getStatus() == 32) {
                    stopButton.setText(Bundle.getMessage("ResumeButton"));
                    stopButton.setToolTipText(Bundle.getMessage("ResumeButtonHint"));
                    this._resumeAutoRunningButtons.get(i).setVisible(false);
                } else if (at.getStatus() == 64) {
                    stopButton.setText(Bundle.getMessage("RestartButton"));
                    stopButton.setToolTipText(Bundle.getMessage("RestartButtonHint"));
                    this._resumeAutoRunningButtons.get(i).setVisible(false);
                } else if (at.getStatus() == 8) {
                    stopButton.setVisible(false);
                } else {
                    stopButton.setText(Bundle.getMessage("StopButton"));
                    stopButton.setToolTipText(Bundle.getMessage("StopButtonHint"));
                    stopButton.setVisible(true);
                }
                JButton manualButton = this._manualButtons.get(i);
                if (at.getMode() == 2) {
                    manualButton.setText(Bundle.getMessage("ToManualButton"));
                    manualButton.setToolTipText(Bundle.getMessage("ToManualButtonHint"));
                    manualButton.setVisible(true);
                    this._resumeAutoRunningButtons.get(i).setVisible(false);
                    this._forwardButtons.get(i).setVisible(false);
                    this._reverseButtons.get(i).setVisible(false);
                    this._speedSliders.get(i).setVisible(false);
                    this._throttleStatus.get(i).setVisible(true);
                } else if (at.getMode() == 8) {
                    manualButton.setVisible(false);
                    this._resumeAutoRunningButtons.get(i).setVisible(true);
                    this._forwardButtons.get(i).setVisible(false);
                    this._reverseButtons.get(i).setVisible(false);
                    this._speedSliders.get(i).setVisible(false);
                    this._throttleStatus.get(i).setVisible(false);
                } else {
                    manualButton.setText(Bundle.getMessage("ToAutoButton"));
                    manualButton.setToolTipText(Bundle.getMessage("ToAutoButtonHint"));
                    this._forwardButtons.get(i).setVisible(true);
                    this._reverseButtons.get(i).setVisible(true);
                    this._speedSliders.get(i).setVisible(true);
                    this._throttleStatus.get(i).setVisible(false);
                    this._forwardButtons.get(i).setSelected(aat.getForward());
                    this._reverseButtons.get(i).setSelected(!aat.getForward());
                    int speedValue = (int)(aat.getTargetSpeed() * 100.0f);
                    this._speedSliders.get(i).setValue(speedValue);
                }
            }
            ++i;
        }
        int j = this._autoTrainsList.size();
        while (j < this._JPanels.size()) {
            JPanel panel = this._JPanels.get(j);
            panel.setVisible(false);
            sep = this._separators.get(j);
            sep.setVisible(false);
            ++j;
        }
        this.autoTrainsFrame.pack();
        this.autoTrainsFrame.setAutoRequestFocus(false);
        this.autoTrainsFrame.setVisible(true);
    }
}

