/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Sensor;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.TransitSection;
import jmri.TransitSectionAction;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.AllocatedSection;
import jmri.jmrit.dispatcher.AutoActiveTrain;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoTrainAction {
    private AutoActiveTrain _autoActiveTrain = null;
    private ActiveTrain _activeTrain = null;
    private ArrayList<TransitSection> _activeTransitSectionList = new ArrayList();
    private ArrayList<TransitSectionAction> _activeActionList = new ArrayList();
    private Sensor _doneSensor = null;
    private PropertyChangeListener _doneSensorListener = null;
    private static final Logger log = LoggerFactory.getLogger(AutoTrainAction.class);

    public AutoTrainAction(AutoActiveTrain aat) {
        this._autoActiveTrain = aat;
        this._activeTrain = aat.getActiveTrain();
    }

    protected synchronized void addTransitSection(TransitSection ts) {
        this._activeTransitSectionList.add(ts);
        ArrayList<TransitSectionAction> tsaList = ts.getTransitSectionActionList();
        if (tsaList.size() > 0) {
            int i = 0;
            while (i < tsaList.size()) {
                TransitSectionAction tsa = tsaList.get(i);
                boolean found = false;
                int j = 0;
                while (j < this._activeActionList.size()) {
                    if (this._activeActionList.get(j) == tsa) {
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    this._activeActionList.add(tsa);
                    tsa.initialize();
                }
                switch (tsa.getWhenCode()) {
                    case 1: {
                        this.checkDelay(tsa);
                        break;
                    }
                    case 2: {
                        tsa.setWaitingForSectionExit(true);
                        tsa.setTargetTransitSection(ts);
                        break;
                    }
                    case 3: 
                    case 4: {
                        tsa.setWaitingForBlock(true);
                        break;
                    }
                    case 5: 
                    case 6: {
                        MonitorTrain monTrain = new MonitorTrain(tsa);
                        Thread tMonTrain = ThreadingUtil.newThread(monTrain, "Monitor Train Transit Action " + this._activeTrain.getDccAddress());
                        tsa.setWaitingThread(tMonTrain);
                        tMonTrain.start();
                        break;
                    }
                    case 7: 
                    case 8: {
                        if (!this.waitOnSensor(tsa)) {
                            this.executeAction(tsa);
                            break;
                        }
                        tsa.setWaitingForSensor(true);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private boolean waitOnSensor(TransitSectionAction tsa) {
        if (tsa.getWaitingForSensor()) {
            return true;
        }
        Sensor s = InstanceManager.sensorManagerInstance().getSensor(tsa.getStringWhen());
        if (s == null) {
            log.error("Sensor with name - {} - was not found.", (Object)tsa.getStringWhen());
            return false;
        }
        int now = s.getKnownState();
        if (now == 2 && tsa.getWhenCode() == 7 || now == 4 && tsa.getWhenCode() == 8) {
            return false;
        }
        tsa.setTriggerSensor(s);
        tsa.setWaitingForSensor(true);
        final String sensorName = tsa.getStringWhen();
        PropertyChangeListener sensorListener = null;
        sensorListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("KnownState")) {
                    AutoTrainAction.this.handleSensorChange(sensorName);
                }
            }
        };
        s.addPropertyChangeListener(sensorListener);
        tsa.setSensorListener(sensorListener);
        return true;
    }

    public void handleSensorChange(String sName) {
        int i = 0;
        while (i < this._activeActionList.size()) {
            TransitSectionAction tsa;
            if (this._activeActionList.get(i).getWaitingForSensor() && (tsa = this._activeActionList.get(i)).getStringWhen().equals(sName)) {
                tsa.setWaitingForSensor(false);
                if (tsa.getSensorListener() != null) {
                    tsa.getTriggerSensor().removePropertyChangeListener(tsa.getSensorListener());
                    tsa.setSensorListener(null);
                }
                this.executeAction(tsa);
                return;
            }
            ++i;
        }
    }

    protected synchronized void handleBlockStateChange(AllocatedSection as, Block b) {
        int i = 0;
        while (i < this._activeActionList.size()) {
            if (this._activeActionList.get(i).getWaitingForBlock()) {
                TransitSectionAction tsa = this._activeActionList.get(i);
                Block target = InstanceManager.getDefault(BlockManager.class).getBlock(tsa.getStringWhen());
                if (b == target && (b.getState() == 2 && tsa.getWhenCode() == 3 || b.getState() == 4 && tsa.getWhenCode() == 4)) {
                    this.checkDelay(tsa);
                }
            }
            ++i;
        }
    }

    protected synchronized void removeTransitSection(TransitSection ts) {
        int i = this._activeTransitSectionList.size() - 1;
        while (i >= 0) {
            if (this._activeTransitSectionList.get(i) == ts) {
                this._activeTransitSectionList.remove(i);
            }
            --i;
        }
        i = 0;
        while (i < this._activeActionList.size()) {
            if (this._activeActionList.get(i).getWaitingForSectionExit() && this._activeActionList.get(i).getTargetTransitSection() == ts) {
                this.checkDelay(this._activeActionList.get(i));
            }
            ++i;
        }
    }

    private synchronized void completedAction(TransitSectionAction tsa) {
        if (tsa.getWaitingForSensor()) {
            tsa.disposeSensorListener();
        }
        tsa.initialize();
        if (!this._activeTrain.getResetWhenDone()) {
            int i = this._activeActionList.size() - 1;
            while (i >= 0) {
                if (this._activeActionList.get(i) == tsa) {
                    this._activeActionList.remove(i);
                    return;
                }
                --i;
            }
        }
    }

    protected synchronized void clearRemainingActions() {
        int i = this._activeActionList.size() - 1;
        while (i >= 0) {
            TransitSectionAction tsa = this._activeActionList.get(i);
            Thread t = tsa.getWaitingThread();
            if (t != null) {
                t.interrupt();
            }
            if (tsa.getWaitingForSensor()) {
                tsa.disposeSensorListener();
            }
            tsa.initialize();
            this._activeActionList.remove(i);
            --i;
        }
    }

    private synchronized void checkDelay(TransitSectionAction tsa) {
        int delay = tsa.getDataWhen();
        if (delay <= 0) {
            this.executeAction(tsa);
        } else {
            TSActionDelay r = new TSActionDelay(tsa, delay);
            Thread t = ThreadingUtil.newThread(r, "Check Delay on Action");
            tsa.setWaitingThread(t);
            t.start();
        }
    }

    private synchronized void listenToDoneSensor(TransitSectionAction tsa) {
        Sensor s = InstanceManager.sensorManagerInstance().getSensor(tsa.getStringWhat());
        if (s == null) {
            log.error("Done Sensor with name - {} - was not found.", (Object)tsa.getStringWhat());
            return;
        }
        this._doneSensor = s;
        this._doneSensorListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                int state;
                if (e.getPropertyName().equals("KnownState") && (state = AutoTrainAction.this._doneSensor.getKnownState()) == 2 && AutoTrainAction.this._activeTrain.getStatus() == 8) {
                    AutoTrainAction.this._activeTrain.getAutoActiveTrain().resumeAutomaticRunning();
                }
            }
        };
        s.addPropertyChangeListener(this._doneSensorListener);
    }

    protected synchronized void cancelDoneSensor() {
        if (this._doneSensor != null) {
            if (this._doneSensorListener != null) {
                this._doneSensor.removePropertyChangeListener(this._doneSensorListener);
            }
            this._doneSensorListener = null;
            this._doneSensor = null;
        }
    }

    @SuppressFBWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"}, justification="used only by thread that can be stopped, no conflict with other threads expected")
    public synchronized void executeAction(TransitSectionAction tsa) {
        if (tsa == null) {
            log.error("executeAction called with null TransitSectionAction");
            return;
        }
        Sensor s = null;
        float temp = 0.0f;
        switch (tsa.getWhatCode()) {
            case 1: {
                if (this._autoActiveTrain.getCurrentAllocatedSection().getNextSection() == null) break;
                Thread tPause = this._autoActiveTrain.pauseTrain(tsa.getDataWhat1());
                tsa.setWaitingThread(tPause);
                break;
            }
            case 2: {
                temp = tsa.getDataWhat1();
                this._autoActiveTrain.setMaxSpeed(temp * 0.01f);
                this.completedAction(tsa);
                break;
            }
            case 3: {
                temp = tsa.getDataWhat1();
                float spd = temp * 0.01f;
                if (spd > this._autoActiveTrain.getMaxSpeed()) {
                    spd = this._autoActiveTrain.getMaxSpeed();
                }
                this._autoActiveTrain.getAutoEngineer().setSpeedImmediate(spd * this._autoActiveTrain.getSpeedFactor());
                this.completedAction(tsa);
                break;
            }
            case 4: {
                temp = tsa.getDataWhat1();
                float spdx = temp * 0.01f;
                if (spdx > this._autoActiveTrain.getMaxSpeed()) {
                    spdx = this._autoActiveTrain.getMaxSpeed();
                }
                this._autoActiveTrain.setTargetSpeed(spdx * this._autoActiveTrain.getSpeedFactor());
                this.completedAction(tsa);
                break;
            }
            case 5: {
                this._autoActiveTrain.initiateWorking();
                if (tsa.getStringWhat() != null && !tsa.getStringWhat().equals("")) {
                    this.listenToDoneSensor(tsa);
                }
                this.completedAction(tsa);
                break;
            }
            case 6: {
                if (this._autoActiveTrain.getAutoEngineer() != null) {
                    log.debug("{}: setting light (F0) to {}", (Object)this._activeTrain.getTrainName(), (Object)tsa.getStringWhat());
                    if (tsa.getStringWhat().equals("On")) {
                        this._autoActiveTrain.getAutoEngineer().setFunction(0, true);
                    } else if (tsa.getStringWhat().equals("Off")) {
                        this._autoActiveTrain.getAutoEngineer().setFunction(0, false);
                    } else {
                        log.error("Incorrect Light ON/OFF setting *{}*", (Object)tsa.getStringWhat());
                    }
                }
                this.completedAction(tsa);
                break;
            }
            case 7: {
                if (this._autoActiveTrain.getSoundDecoder() && this._autoActiveTrain.getAutoEngineer() != null) {
                    log.debug("{}: starting bell (F1)", (Object)this._activeTrain.getTrainName());
                    this._autoActiveTrain.getAutoEngineer().setFunction(1, true);
                }
                this.completedAction(tsa);
                break;
            }
            case 8: {
                if (this._autoActiveTrain.getSoundDecoder() && this._autoActiveTrain.getAutoEngineer() != null) {
                    log.debug("{}: stopping bell (F1)", (Object)this._activeTrain.getTrainName());
                    this._autoActiveTrain.getAutoEngineer().setFunction(1, false);
                }
                this.completedAction(tsa);
                break;
            }
            case 9: 
            case 10: {
                if (this._autoActiveTrain.getSoundDecoder()) {
                    log.debug("{}: sounding horn as specified in action", (Object)this._activeTrain.getTrainName());
                    HornExecution rHorn = new HornExecution(tsa);
                    Thread tHorn = ThreadingUtil.newThread(rHorn);
                    tsa.setWaitingThread(tHorn);
                    tHorn.start();
                    break;
                }
                this.completedAction(tsa);
                break;
            }
            case 11: {
                if (this._autoActiveTrain.getAutoEngineer() != null) {
                    log.debug("{}: setting function {} to {}", new Object[]{this._activeTrain.getTrainName(), tsa.getDataWhat1(), tsa.getStringWhat()});
                    int fun = tsa.getDataWhat1();
                    if (tsa.getStringWhat().equals("On")) {
                        this._autoActiveTrain.getAutoEngineer().setFunction(fun, true);
                    } else if (tsa.getStringWhat().equals("Off")) {
                        this._autoActiveTrain.getAutoEngineer().setFunction(fun, false);
                    }
                }
                this.completedAction(tsa);
                break;
            }
            case 12: {
                s = InstanceManager.sensorManagerInstance().getSensor(tsa.getStringWhat());
                if (s != null) {
                    if (s.getKnownState() == 2) {
                        try {
                            s.setState(4);
                        }
                        catch (JmriException reason) {
                            log.error("Exception when toggling Sensor {} Inactive - {}", (Object)tsa.getStringWhat(), (Object)reason);
                        }
                    }
                    try {
                        s.setState(2);
                    }
                    catch (JmriException reason) {
                        log.error("Exception when setting Sensor {} Active - {}", (Object)tsa.getStringWhat(), (Object)reason);
                    }
                    break;
                }
                if (tsa.getStringWhat() != null && !tsa.getStringWhat().equals("")) {
                    log.error("Could not find Sensor {}", (Object)tsa.getStringWhat());
                    break;
                }
                log.error("Sensor not specified for Action");
                break;
            }
            case 13: {
                s = InstanceManager.sensorManagerInstance().getSensor(tsa.getStringWhat());
                if (s != null) {
                    if (s.getKnownState() == 2) {
                        try {
                            s.setState(2);
                        }
                        catch (JmriException reason) {
                            log.error("Exception when toggling Sensor {} Active - {}", (Object)tsa.getStringWhat(), (Object)reason);
                        }
                    }
                    try {
                        s.setState(4);
                    }
                    catch (JmriException reason) {
                        log.error("Exception when setting Sensor {} Inactive - {}", (Object)tsa.getStringWhat(), (Object)reason);
                    }
                    break;
                }
                if (tsa.getStringWhat() != null && !tsa.getStringWhat().equals("")) {
                    log.error("Could not find Sensor {}", (Object)tsa.getStringWhat());
                    break;
                }
                log.error("Sensor not specified for Action");
                break;
            }
            case 14: {
                SignalMast sm = null;
                SignalHead sh = null;
                String sName = tsa.getStringWhat();
                sm = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(sName);
                if (sm == null) {
                    sh = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(sName);
                    if (sh == null) {
                        log.error("{}: Could not find SignalMast or SignalHead named '{}'", (Object)this._activeTrain.getTrainName(), (Object)sName);
                        break;
                    }
                    log.debug("{}: setting signalHead '{}' to HELD", (Object)this._activeTrain.getTrainName(), (Object)sName);
                    sh.setHeld(true);
                    break;
                }
                log.debug("{}: setting signalMast '{}' to HELD", (Object)this._activeTrain.getTrainName(), (Object)sName);
                sm.setHeld(true);
                break;
            }
            case 15: {
                SignalMast sm = null;
                SignalHead sh = null;
                String sName = tsa.getStringWhat();
                sm = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(sName);
                if (sm == null) {
                    sh = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(sName);
                    if (sh == null) {
                        log.error("{}: Could not find SignalMast or SignalHead named '{}'", (Object)this._activeTrain.getTrainName(), (Object)sName);
                        break;
                    }
                    log.debug("{}: setting signalHead '{}' to NOT HELD", (Object)this._activeTrain.getTrainName(), (Object)sName);
                    sh.setHeld(false);
                    break;
                }
                log.debug("{}: setting signalMast '{}' to NOT HELD", (Object)this._activeTrain.getTrainName(), (Object)sName);
                sm.setHeld(false);
                break;
            }
            default: {
                log.error("illegal What code - {} - in call to executeAction", (Object)tsa.getWhatCode());
            }
        }
    }

    class HornExecution
    implements Runnable {
        private TransitSectionAction _tsa = null;

        public HornExecution(TransitSectionAction tsa) {
            this._tsa = tsa;
        }

        @Override
        public void run() {
            AutoTrainAction.this._autoActiveTrain.incrementHornExecution();
            if (this._tsa.getWhatCode() == 9) {
                if (AutoTrainAction.this._autoActiveTrain.getAutoEngineer() != null) {
                    try {
                        AutoTrainAction.this._autoActiveTrain.getAutoEngineer().setFunction(2, true);
                        Thread.sleep(this._tsa.getDataWhat1());
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (AutoTrainAction.this._autoActiveTrain.getAutoEngineer() != null) {
                    AutoTrainAction.this._autoActiveTrain.getAutoEngineer().setFunction(2, false);
                }
            } else if (this._tsa.getWhatCode() == 10) {
                String pattern = this._tsa.getStringWhat();
                int index = 0;
                int sleepTime = this._tsa.getDataWhat1() * 12 / 10;
                boolean keepGoing = true;
                while (keepGoing && index < pattern.length()) {
                    if (AutoTrainAction.this._autoActiveTrain.getAutoEngineer() != null) {
                        AutoTrainAction.this._autoActiveTrain.getAutoEngineer().setFunction(2, true);
                        try {
                            if (pattern.charAt(index) == 's') {
                                Thread.sleep(this._tsa.getDataWhat1());
                            } else if (pattern.charAt(index) == 'l') {
                                Thread.sleep(this._tsa.getDataWhat2());
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            keepGoing = false;
                        }
                    } else {
                        keepGoing = false;
                    }
                    if (AutoTrainAction.this._autoActiveTrain.getAutoEngineer() != null) {
                        AutoTrainAction.this._autoActiveTrain.getAutoEngineer().setFunction(2, false);
                    } else {
                        keepGoing = false;
                    }
                    if (!keepGoing || ++index >= pattern.length()) continue;
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException interruptedException) {
                        keepGoing = false;
                    }
                }
            }
            AutoTrainAction.this._autoActiveTrain.decrementHornExecution();
            AutoTrainAction.this.completedAction(this._tsa);
        }
    }

    class MonitorTrain
    implements Runnable {
        private int _delay = 50;
        private TransitSectionAction _tsa = null;

        public MonitorTrain(TransitSectionAction tsa) {
            this._tsa = tsa;
        }

        @Override
        public void run() {
            block12: {
                boolean waitingOnTrain;
                block14: {
                    block13: {
                        if (this._tsa == null) break block12;
                        waitingOnTrain = true;
                        if (this._tsa.getWhenCode() != 5) break block13;
                        try {
                            while (waitingOnTrain) {
                                if (AutoTrainAction.this._autoActiveTrain.getAutoEngineer() != null && AutoTrainAction.this._autoActiveTrain.getAutoEngineer().isStopped()) {
                                    waitingOnTrain = false;
                                    continue;
                                }
                                Thread.sleep(this._delay);
                            }
                            AutoTrainAction.this.executeAction(this._tsa);
                        }
                        catch (InterruptedException interruptedException) {}
                        break block12;
                    }
                    if (this._tsa.getWhenCode() != 6) break block12;
                    if (AutoTrainAction.this._autoActiveTrain.getAutoEngineer() == null || AutoTrainAction.this._autoActiveTrain.getAutoEngineer().isStopped()) break block14;
                    boolean waitingForStop = true;
                    try {
                        while (waitingForStop) {
                            if (AutoTrainAction.this._autoActiveTrain.getAutoEngineer() != null && AutoTrainAction.this._autoActiveTrain.getAutoEngineer().isStopped()) {
                                waitingForStop = false;
                                continue;
                            }
                            Thread.sleep(this._delay);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                try {
                    while (waitingOnTrain) {
                        if (AutoTrainAction.this._autoActiveTrain.getAutoEngineer() != null && !AutoTrainAction.this._autoActiveTrain.getAutoEngineer().isStopped()) {
                            waitingOnTrain = false;
                            continue;
                        }
                        Thread.sleep(this._delay);
                    }
                    AutoTrainAction.this.executeAction(this._tsa);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class MonitorTrainSpeed
    implements Runnable {
        private int _delay = 51;
        private TransitSectionAction _tsa = null;

        public MonitorTrainSpeed(TransitSectionAction tsa) {
            this._tsa = tsa;
        }

        @Override
        public void run() {
            while (AutoTrainAction.this._autoActiveTrain.getAutoEngineer() != null && !AutoTrainAction.this._autoActiveTrain.getAutoEngineer().isAtSpeed()) {
                try {
                    Thread.sleep(this._delay);
                }
                catch (InterruptedException interruptedException) {
                    log.error("unexpected interruption of wait for speed");
                }
            }
            AutoTrainAction.this._autoActiveTrain.setCurrentRampRate(AutoTrainAction.this._autoActiveTrain.getRampRate());
            if (this._tsa != null) {
                AutoTrainAction.this.completedAction(this._tsa);
            }
        }
    }

    class TSActionDelay
    implements Runnable {
        private TransitSectionAction _tsa = null;
        private int _delay = 0;

        public TSActionDelay(TransitSectionAction tsa, int delay) {
            this._tsa = tsa;
            this._delay = delay;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this._delay);
                AutoTrainAction.this.executeAction(this._tsa);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

