/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.annotation.CheckForNull;
import javax.swing.JOptionPane;
import jmri.Block;
import jmri.BlockManager;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.EntryPoint;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.NamedBean;
import jmri.Section;
import jmri.Sensor;
import jmri.SignalHead;
import jmri.SignalMast;
import jmri.SignalMastLogic;
import jmri.SignalMastLogicManager;
import jmri.ThrottleListener;
import jmri.Timebase;
import jmri.TransitSection;
import jmri.Turnout;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.AllocatedSection;
import jmri.jmrit.dispatcher.AutoTrainAction;
import jmri.jmrit.dispatcher.Bundle;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.roster.RosterEntry;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoActiveTrain
implements ThrottleListener {
    public static final int STOP_SPEED = 1;
    public static final int RESTRICTED_SPEED = 2;
    public static final int SLOW_SPEED = 3;
    public static final int MEDIUM_SPEED = 4;
    public static final int LIMITED_SPEED = 5;
    public static final int NORMAL_SPEED = 6;
    public static final int MAXIMUM_SPEED = 7;
    private final Float[] _speedRatio = new Float[]{Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(0.25f), Float.valueOf(0.35f), Float.valueOf(0.5f), Float.valueOf(0.65f), Float.valueOf(0.8f), Float.valueOf(1.15f)};
    public static final int RAMP_NONE = 0;
    public static final int RAMP_FAST = 1;
    public static final int RAMP_MEDIUM = 2;
    public static final int RAMP_MED_SLOW = 3;
    public static final int RAMP_SLOW = 4;
    public static final int NO_TASK = 0;
    public static final int END_REVERSAL = 1;
    public static final int BEGINNING_RESET = 2;
    private static final NamedBean.DisplayOptions USERSYS = NamedBean.DisplayOptions.USERNAME_SYSTEMNAME;
    private ActiveTrain _activeTrain = null;
    private AutoTrainAction _autoTrainAction = null;
    private DccThrottle _throttle = null;
    private AutoEngineer _autoEngineer = null;
    private int _address = -1;
    private boolean _forward = true;
    private float _targetSpeed = 0.0f;
    private int _savedStatus = 1;
    private int _currentRampRate = 0;
    private boolean _pausingActive = false;
    private int _rampRate = 0;
    private float _speedFactor = 1.0f;
    private float _maxSpeed = 0.6f;
    private boolean _resistanceWheels = true;
    private boolean _runInReverse = false;
    private boolean _soundDecoder = false;
    private volatile float _maxTrainLength = 200.0f;
    private float _stopBySpeedProfileAdjust = 1.0f;
    private boolean _stopBySpeedProfile = false;
    private boolean _useSpeedProfile = true;
    RosterEntry re = null;
    boolean useSpeedProfile = false;
    private LayoutBlockManager _lbManager = null;
    private AllocatedSection _lastAllocatedSection = null;
    private boolean _initialized = false;
    private Section _nextSection = null;
    private volatile AllocatedSection _currentAllocatedSection = null;
    private volatile AllocatedSection _previousAllocatedSection = null;
    private SignalHead _controllingSignal = null;
    private SignalMast _controllingSignalMast = null;
    private PropertyChangeListener _conSignalListener = null;
    private PropertyChangeListener _conSignalMastListener = null;
    private Block _conSignalProtectedBlock = null;
    private volatile Block _currentBlock = null;
    private Block _nextBlock = null;
    private volatile Block _previousBlock = null;
    private boolean _stoppingBySensor = false;
    private Sensor _stopSensor = null;
    private PropertyChangeListener _stopSensorListener = null;
    private PropertyChangeListener _turnoutStateListener = null;
    private boolean _stoppingByBlockOccupancy = false;
    private boolean _stoppingUsingSpeedProfile = false;
    private volatile Block _stoppingBlock = null;
    private boolean _resumingAutomatic = false;
    private boolean _needSetSpeed = false;
    private boolean waitingOnAllocation = false;
    private float _savedSpeed = 0.0f;
    private boolean _savedForward = true;
    private int _activeHornThreads = 0;
    float prevSpeed = -1.0f;
    private static final Logger log = LoggerFactory.getLogger(AutoActiveTrain.class);

    public AutoActiveTrain(ActiveTrain at) {
        this._activeTrain = at;
        at.setAutoActiveTrain(this);
        this._autoTrainAction = new AutoTrainAction(this);
        this._lbManager = InstanceManager.getDefault(LayoutBlockManager.class);
        at.addPropertyChangeListener("sectionallocated", this::handleAnotherSectionAllocatedChange);
    }

    public ActiveTrain getActiveTrain() {
        return this._activeTrain;
    }

    public AutoEngineer getAutoEngineer() {
        return this._autoEngineer;
    }

    public AutoTrainAction getAutoTrainAction() {
        return this._autoTrainAction;
    }

    public boolean getForward() {
        return this._forward;
    }

    public void setForward(boolean set) {
        this._forward = set;
    }

    public synchronized float getTargetSpeed() {
        return this._targetSpeed;
    }

    public synchronized void setTargetSpeed(float speed) {
        this._targetSpeed = speed;
        if ((double)speed > 0.002) {
            this.cancelStopInCurrentSection();
        }
    }

    public int getSavedStatus() {
        return this._savedStatus;
    }

    public void setSavedStatus(int status) {
        this._savedStatus = status;
    }

    public synchronized void setCurrentRampRate(int rate) {
        this._currentRampRate = rate;
    }

    public int getRampRate() {
        return this._rampRate;
    }

    public void setRampRate(int rate) {
        this._rampRate = rate;
        this._currentRampRate = rate;
    }

    public float getSpeedFactor() {
        return this._speedFactor;
    }

    public void setSpeedFactor(float factor) {
        this._speedFactor = factor;
    }

    public float getMaxSpeed() {
        return this._maxSpeed;
    }

    public void setMaxSpeed(float speed) {
        this._maxSpeed = speed;
    }

    public boolean getResistanceWheels() {
        return this._resistanceWheels;
    }

    public void setResistanceWheels(boolean set) {
        this._resistanceWheels = set;
    }

    public boolean getRunInReverse() {
        return this._runInReverse;
    }

    public void setRunInReverse(boolean set) {
        this._runInReverse = set;
        this._forward = !this._runInReverse;
    }

    public boolean getSoundDecoder() {
        return this._soundDecoder;
    }

    public void setSoundDecoder(boolean set) {
        this._soundDecoder = set;
    }

    public float getMaxTrainLength() {
        return this._maxTrainLength;
    }

    public void setMaxTrainLength(float length) {
        this._maxTrainLength = length;
    }

    public void setUseSpeedProfile(boolean tf) {
        this._useSpeedProfile = tf;
    }

    public void setStopBySpeedProfile(boolean tf) {
        this._stopBySpeedProfile = tf;
    }

    public void setStopBySpeedProfileAdjust(float adjust) {
        this._stopBySpeedProfileAdjust = adjust;
    }

    public String getCurrentSignal() {
        if (InstanceManager.getDefault(DispatcherFrame.class).getSignalType() == 0) {
            return this._controllingSignal == null ? "" : this._controllingSignal.getDisplayName();
        }
        return this._controllingSignalMast == null ? "" : this._controllingSignalMast.getDisplayName();
    }

    public String getCurrentSignalUserName() {
        if (InstanceManager.getDefault(DispatcherFrame.class).getSignalType() == 0) {
            return this._controllingSignal == null || this._controllingSignal.getUserName() == null ? "" : this._controllingSignal.getUserName();
        }
        return this._controllingSignalMast == null || this._controllingSignalMast.getUserName() == null ? "" : this._controllingSignalMast.getUserName();
    }

    public boolean initialize() {
        boolean ok;
        this._pausingActive = false;
        this._stoppingBySensor = false;
        this._stoppingByBlockOccupancy = false;
        this._stoppingUsingSpeedProfile = false;
        try {
            this._address = Integer.parseInt(this._activeTrain.getDccAddress());
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("invalid dcc address '{}' for {}", (Object)this._activeTrain.getDccAddress(), (Object)this._activeTrain.getTrainName());
            return false;
        }
        if (this._address < 1 || this._address > 9999) {
            log.warn("invalid dcc address '{}' for {}", (Object)this._activeTrain.getDccAddress(), (Object)this._activeTrain.getTrainName());
            return false;
        }
        this.useSpeedProfile = false;
        DccLocoAddress addressForRequest = new DccLocoAddress(this._address, !InstanceManager.throttleManagerInstance().canBeShortAddress(this._address));
        if (this._activeTrain.getTrainSource() == 1) {
            if (this._activeTrain.getRosterEntry() != null) {
                this.re = this._activeTrain.getRosterEntry();
                ok = InstanceManager.throttleManagerInstance().requestThrottle(this.re, (ThrottleListener)this, false);
                if (this._useSpeedProfile && this.re.getSpeedProfile() != null && this.re.getSpeedProfile().getProfileSize() > 0) {
                    this.useSpeedProfile = true;
                }
                log.debug("{}: requested roster entry '{}', address={}, use speed profile={}", new Object[]{this._activeTrain.getTrainName(), this.re.getId(), this._address, this.useSpeedProfile});
            } else {
                ok = InstanceManager.throttleManagerInstance().requestThrottle(addressForRequest, (ThrottleListener)this, false);
                log.debug("{}: requested throttle address={}, roster entry not found", (Object)this._activeTrain.getTrainName(), (Object)this._address);
            }
        } else {
            ok = InstanceManager.throttleManagerInstance().requestThrottle(addressForRequest, (ThrottleListener)this, false);
            log.debug("{}: requested throttle address={}", (Object)this._activeTrain.getTrainName(), (Object)this._address);
        }
        if (!ok) {
            log.warn("Throttle for locomotive address {} could not be setup.", (Object)this._address);
            this._activeTrain.setMode(8);
            return false;
        }
        return true;
    }

    @Override
    public void notifyThrottleFound(DccThrottle t) {
        this._throttle = t;
        if (this._throttle == null) {
            JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("Error28"), this._activeTrain.getTrainName()), Bundle.getMessage("MessageTitle"), 1);
            log.warn("null throttle returned for train '{}' during automatic initialization.", (Object)this._activeTrain.getTrainName());
            this._activeTrain.setMode(8);
            return;
        }
        log.debug("{}: New AutoEngineer, address={}, length={}, factor={}, useSpeedProfile={}", new Object[]{this._activeTrain.getTrainName(), this._throttle.getLocoAddress(), Float.valueOf(this.getMaxTrainLength()), Float.valueOf(this._speedFactor), this._useSpeedProfile});
        if (this._autoEngineer != null) {
            log.error("Second Trottle for same loco[{}] - ignoring", (Object)this._address);
        } else {
            this._autoEngineer = new AutoEngineer();
            ThreadingUtil.newThread(this._autoEngineer, "Auto Engineer " + this._address).start();
            this._activeTrain.setMode(2);
            if (this._resumingAutomatic) {
                this._resumingAutomatic = false;
                this._activeTrain.setStatus(1);
                this.setupNewCurrentSignal(null, true);
                if (!this.isCurrentSignal()) {
                    this.restoreSavedSpeedAndDirection();
                }
                this.setEngineDirection();
                this.setSpeedBySignal();
            } else if (InstanceManager.getDefault(DispatcherFrame.class).getAutoAllocate() && this._currentAllocatedSection != null) {
                this.setSpeedBySignal();
            }
        }
    }

    protected DccThrottle getThrottle() {
        return this._throttle;
    }

    @Override
    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
        log.error("Throttle request failed for {} because {}", (Object)address, (Object)reason);
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
    }

    protected Section getLastAllocatedSection() {
        Section as = this._activeTrain.getLastAllocatedSection();
        return as;
    }

    protected void saveSpeedAndDirection() {
        this._savedSpeed = this._targetSpeed;
        this._savedForward = this._forward;
    }

    protected void restoreSavedSpeedAndDirection() {
        this._targetSpeed = this._savedSpeed;
        this._forward = this._savedForward;
    }

    protected void decrementHornExecution() {
        --this._activeHornThreads;
    }

    protected void incrementHornExecution() {
        ++this._activeHornThreads;
    }

    protected void handleSectionStateChange(AllocatedSection as) {
        if (!this._activeTrain.isInAllocatedList(as)) {
            this.addAllocatedSection(as);
        }
    }

    private void handleAnotherSectionAllocatedChange(PropertyChangeEvent evt) {
        if (this.waitingOnAllocation || InstanceManager.getDefault(DispatcherFrame.class).getSignalType() == 2) {
            this.waitingOnAllocation = false;
            this.setSpeedBySignal();
        }
    }

    protected void handleSectionOccupancyChange(AllocatedSection as) {
        TransitSection ts;
        if (!this._activeTrain.isInAllocatedList(as)) {
            log.debug("Unexpected occupancy change notification - Section {}", (Object)as.getSection().getDisplayName(USERSYS));
            return;
        }
        if (as.getSection().getOccupancy() == 2) {
            if (as.getSection() == this._nextSection) {
                this.setNewCurrentSection(as);
            }
        } else if (as.getSection().getOccupancy() == 4 && (ts = as.getTransitSection()) != null) {
            this._autoTrainAction.removeTransitSection(ts);
        }
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="OK to not sync here, no conflict expected")
    protected void handleBlockStateChange(AllocatedSection as, Block b) {
        if (b.getState() == 2) {
            log.debug("{}: handleBlockStateChange to OCCUPIED section {}, block {}, length {}", new Object[]{this._activeTrain.getTrainName(), as.getSection().getDisplayName(USERSYS), b.getDisplayName(USERSYS), this.getBlockLength(b)});
            if (b == this._nextBlock || this._nextBlock == null) {
                this._currentBlock = b;
                if (!this._activeTrain.isTransitReversed() && as.getSequence() == this._activeTrain.getEndBlockSectionSequenceNumber()) {
                    if (this._activeTrain.getReverseAtEnd()) {
                        this.removeCurrentSignal();
                        this.stopInCurrentSection(1);
                    } else if (this._activeTrain.getResetWhenDone() && this._activeTrain.getDelayedRestart() == 0) {
                        this._activeTrain.setRestart();
                        this._activeTrain.setTransitReversed(false);
                        this._activeTrain.resetAllAllocatedSections();
                        this._previousBlock = null;
                        this._nextBlock = this.getNextBlock(this._currentBlock, this._currentAllocatedSection);
                        this.setEngineDirection();
                        if (this._nextSection != null && !this._activeTrain.isInAllocatedList(this._nextSection)) {
                            InstanceManager.getDefault(DispatcherFrame.class).queueScanOfAllocationRequests();
                        }
                        this.setupNewCurrentSignal(null, true);
                        this.setSpeedBySignal();
                    } else if (this._activeTrain.getResetWhenDone()) {
                        this.removeCurrentSignal();
                        this.stopInCurrentSection(2);
                    } else {
                        log.debug("{}: Trip end, stop in Current Section, Block= {}", (Object)this._activeTrain.getTrainName(), (Object)b.getDisplayName(USERSYS));
                        this.removeCurrentSignal();
                        this.stopInCurrentSection(0);
                    }
                } else if (this._activeTrain.isTransitReversed() && as.getSequence() == this._activeTrain.getStartBlockSectionSequenceNumber()) {
                    if (this._activeTrain.getResetWhenDone() && this._activeTrain.isTransitReversed()) {
                        this.removeCurrentSignal();
                        this.stopInCurrentSection(2);
                    } else {
                        log.debug("{}: Trip end, stop in Current Section, Block= {}", (Object)this._activeTrain.getTrainName(), (Object)b.getDisplayName(USERSYS));
                        this.removeCurrentSignal();
                        this.stopInCurrentSection(0);
                    }
                } else {
                    this._nextBlock = this.getNextBlock(b, as);
                    if (this._nextBlock != null) {
                        this._previousBlock = this._currentBlock;
                        this._nextBlock = this.getNextBlock(b, as);
                        this.setupNewCurrentSignal(as, false);
                    } else {
                        log.warn("{}: No next Block from Block= {} Section= {}", new Object[]{this._activeTrain.getTrainName(), b.getDisplayName(USERSYS), as.getSection().getDisplayName(USERSYS)});
                        this.removeCurrentSignal();
                        this.stopInCurrentSection(0);
                    }
                }
            } else if (b != this._currentBlock) {
                log.trace("{}: block going occupied {} is not _nextBlock or _currentBlock - ignored.", (Object)this._activeTrain.getTrainName(), (Object)b.getDisplayName(USERSYS));
                return;
            }
        } else if (b.getState() == 4) {
            log.debug("{}: handleBlockStateChange to UNOCCUPIED - Section {}, Block {}, speed {}", new Object[]{this._activeTrain.getTrainName(), as.getSection().getDisplayName(USERSYS), b.getDisplayName(USERSYS), Float.valueOf(this._targetSpeed)});
            if (this._stoppingByBlockOccupancy && b == this._stoppingBlock) {
                log.trace("{}: setStopNow by block occupancy from Block unoccupied, Block= {}", (Object)this._activeTrain.getTrainName(), (Object)b.getDisplayName(USERSYS));
                this._stoppingByBlockOccupancy = false;
                this._stoppingBlock = null;
                if (this._needSetSpeed) {
                    this._needSetSpeed = false;
                    this.setSpeedBySignal();
                } else {
                    this.setStopNow();
                }
            }
        }
        this._autoTrainAction.handleBlockStateChange(as, b);
    }

    protected void setEngineDirection() {
        boolean oldFwd = this._forward;
        this._forward = this._runInReverse ? this._activeTrain.isTransitReversed() : !this._activeTrain.isTransitReversed();
        log.debug("flipping direction was [{}] now [{}]", (Object)this._forward, (Object)oldFwd);
    }

    protected AllocatedSection getCurrentAllocatedSection() {
        return this._currentAllocatedSection;
    }

    protected void allocateAFresh() {
        this._initialized = false;
    }

    private void addAllocatedSection(AllocatedSection as) {
        if (!this._initialized) {
            this._initialized = true;
            this._nextSection = as.getSection();
            this._currentBlock = this._activeTrain.getStartBlock();
            if (as.getSection().containsBlock(this._currentBlock)) {
                this.setNewCurrentSection(as);
                this._nextBlock = this.getNextBlock(this._currentBlock, as);
            } else if (as.getSection().connectsToBlock(this._currentBlock)) {
                EntryPoint ep = as.getSection().getEntryPointFromBlock(this._currentBlock, as.getDirection());
                if (ep != null) {
                    this._nextBlock = ep.getBlock();
                } else {
                    log.error("failure to get entry point to Transit from Block {}", (Object)this._currentBlock.getDisplayName(USERSYS));
                }
            }
            if (this._nextBlock != null) {
                this.setupNewCurrentSignal(as, true);
            }
        }
        if (!this._pausingActive && this._lastAllocatedSection == this._currentAllocatedSection && this.isStopping() && this._activeTrain.getStatus() == 1) {
            this._needSetSpeed = true;
        }
        if (!(InstanceManager.getDefault(DispatcherFrame.class).getAutoAllocate() || this._lastAllocatedSection != null && this._lastAllocatedSection.getNextSection() != as.getSection())) {
            this._lastAllocatedSection = as;
            if (as.getNextSection() != null) {
                Section nSection = as.getNextSection();
                int nextSeq = as.getNextSectionSequence();
                int nextDir = this._activeTrain.getAllocationDirectionFromSectionAndSeq(nSection, nextSeq);
                InstanceManager.getDefault(DispatcherFrame.class).requestAllocation(this._activeTrain, nSection, nextDir, nextSeq, true, null);
            }
        }
    }

    private boolean isStopping() {
        return this._stoppingBySensor || this._stoppingByBlockOccupancy || this._stoppingUsingSpeedProfile;
    }

    private void removeCurrentSignal() {
        if (this._conSignalListener != null) {
            this._controllingSignal.removePropertyChangeListener(this._conSignalListener);
            this._conSignalListener = null;
        }
        this._controllingSignal = null;
        if (this._conSignalMastListener != null) {
            this._controllingSignalMast.removePropertyChangeListener(this._conSignalMastListener);
            this._conSignalMastListener = null;
        }
        this._controllingSignalMast = null;
        this._needSetSpeed = false;
    }

    protected boolean isCurrentSignal() {
        if (InstanceManager.getDefault(DispatcherFrame.class).getSignalType() == 0) {
            return this._controllingSignal != null;
        }
        return this._controllingSignalMast != null;
    }

    protected synchronized void setupNewCurrentSignal(AllocatedSection as, boolean forceSpeedChange) {
        log.trace("setupNewCurrentSignal Called Section[{}] forceSpeedChange[{}]", (Object)(as != null ? as.getSectionName() : "null"), (Object)forceSpeedChange);
        this.removeCurrentSignal();
        if (InstanceManager.getDefault(DispatcherFrame.class).getSignalType() == 0) {
            SignalHead sh = this._lbManager.getFacingSignalHead(this._currentBlock, this._nextBlock);
            if (sh != null) {
                this._controllingSignal = sh;
                this._conSignalProtectedBlock = this._nextBlock;
                this._conSignalListener = e -> {
                    if (e.getPropertyName().equals("Appearance")) {
                        this.setSpeedBySignal();
                    }
                };
                sh.addPropertyChangeListener(this._conSignalListener);
                log.debug("new current signal = {}", (Object)sh.getDisplayName(USERSYS));
                this.setSpeedBySignal();
            } else {
                log.debug("new current signal is null - sometimes OK");
            }
        } else if (InstanceManager.getDefault(DispatcherFrame.class).getSignalType() == 1) {
            SignalMast sm = null;
            Block cB = this._currentBlock;
            Block nB = this._nextBlock;
            if (as == null) {
                as = this._currentAllocatedSection;
            }
            boolean weAreAtSpeedChangingMast = forceSpeedChange;
            if (!forceSpeedChange && nB != null && (sm = this._lbManager.getFacingSignalMast(cB, nB)) != null) {
                weAreAtSpeedChangingMast = true;
            }
            while (sm == null && nB != null) {
                sm = this._lbManager.getFacingSignalMast(cB, nB);
                if (sm != null) continue;
                cB = nB;
                nB = this.getNextBlock(nB, as);
            }
            if (sm != null) {
                this._controllingSignalMast = sm;
                this._conSignalProtectedBlock = nB;
                this._conSignalMastListener = e -> {
                    if (e.getPropertyName().equals("Aspect") || e.getPropertyName().equals("Held")) {
                        this.setSpeedBySignal();
                    }
                };
                sm.addPropertyChangeListener(this._conSignalMastListener);
                log.debug("{}: new current signalmast {}({}) for section {}", new Object[]{this._activeTrain.getTrainName(), sm.getDisplayName(USERSYS), sm.getAspect(), as.getSection().getDisplayName(USERSYS)});
                if (weAreAtSpeedChangingMast) {
                    this.setSpeedBySignal();
                }
            } else {
                log.debug("{}: new current signalmast is null for section {} - sometimes OK", (Object)this._activeTrain.getTrainName(), (Object)(as == null ? "Null" : as.getSection().getDisplayName(USERSYS)));
            }
        } else {
            this.setSpeedBySignal();
        }
    }

    @CheckForNull
    private Block getNextBlock(Block b, AllocatedSection as) {
        EntryPoint ep;
        if (this._currentBlock == this._activeTrain.getStartBlock() && this._activeTrain.getResetWhenDone() && this._activeTrain.isTransitReversed() && as.getSequence() == this._activeTrain.getStartBlockSectionSequenceNumber()) {
            return this._previousBlock;
        }
        if (as.getNextSection() != null && (ep = as.getSection().getExitPointToSection(this._nextSection, as.getDirection())) != null && ep.getBlock() == b) {
            return ep.getFromBlock();
        }
        Block blk = as.getSection().getEntryBlock();
        while (blk != null) {
            if (b == blk) {
                return as.getSection().getNextBlock();
            }
            blk = as.getSection().getNextBlock();
        }
        return null;
    }

    private void setNewCurrentSection(AllocatedSection as) {
        if (as.getSection() == this._nextSection) {
            this._previousAllocatedSection = this._currentAllocatedSection;
            this._currentAllocatedSection = as;
            this._nextSection = as.getNextSection();
            TransitSection ts = as.getTransitSection();
            if (ts != null) {
                this._autoTrainAction.addTransitSection(ts);
            }
            boolean nextSectionExpected = true;
            if (ts != null && ts.isSafe() && this._activeTrain.getAllocateMethod() == 0) {
                nextSectionExpected = false;
            } else if (!this._activeTrain.isAllocationReversed() && this._activeTrain.getEndBlockSection() == this._currentAllocatedSection.getSection()) {
                nextSectionExpected = false;
            } else if (this._activeTrain.isAllocationReversed() && this._activeTrain.getStartBlockSectionSequenceNumber() == this._currentAllocatedSection.getSequence()) {
                nextSectionExpected = false;
            }
            log.debug("{}:Next Section Expected[{}]", (Object)this._activeTrain.getActiveTrainName(), (Object)nextSectionExpected);
            if (ts != null && ts.isSafe() && this._activeTrain.getAllocateMethod() == 0) {
                InstanceManager.getDefault(DispatcherFrame.class).queueScanOfAllocationRequests();
            }
        }
    }

    protected synchronized void setSpeedBySignal() {
        log.trace("Set Speed by Signal");
        if (this._pausingActive || this._activeTrain.getStatus() != 1 && this._activeTrain.getStatus() != 4 || this._controllingSignal == null && InstanceManager.getDefault(DispatcherFrame.class).getSignalType() == 0 || InstanceManager.getDefault(DispatcherFrame.class).getSignalType() == 1 && (this._controllingSignalMast == null || this._activeTrain.getStatus() == 4 && !this._activeTrain.getStarted()) || this._activeTrain.getMode() != 2) {
            log.trace("Skip Set Speed By Signal");
            return;
        }
        if (this.checkAllocationsAhead()) {
            if (InstanceManager.getDefault(DispatcherFrame.class).getSignalType() == 0) {
                this.setSpeedBySignalHead();
            } else if (InstanceManager.getDefault(DispatcherFrame.class).getSignalType() == 1) {
                this.setSpeedBySignalMast();
            } else {
                log.trace("{}:Set Speed by BlocksAllocated", (Object)this._activeTrain.getActiveTrainName());
                this.setSpeedBySectionsAllocated();
            }
        } else {
            this.stopInCurrentSection(0);
            log.debug("{}:Set Stop", (Object)this._activeTrain.getActiveTrainName());
            this.waitingOnAllocation = true;
        }
    }

    private boolean checkAllocationsAhead() {
        if (this._nextSection != null) {
            for (AllocatedSection allocatedSection : this._activeTrain.getAllocatedSectionList()) {
                if (allocatedSection.getSection() != this._nextSection) continue;
                return true;
            }
        }
        return false;
    }

    private void setSpeedBySectionsAllocated() {
        if (this._stoppingByBlockOccupancy && this._stoppingBlock != null && this._stoppingBlock.getState() == 4) {
            return;
        }
        int sectionsAhead = 0;
        AllocatedSection as = null;
        for (AllocatedSection allocatedSection : this._activeTrain.getAllocatedSectionList()) {
            if (allocatedSection.getSection() == this._nextSection) {
                as = allocatedSection;
            }
            if (allocatedSection.getEntered()) continue;
            ++sectionsAhead;
        }
        float newSpeed = 0.0f;
        log.debug("[{}:SectionsAhead[{}]", (Object)this._activeTrain.getActiveTrainName(), (Object)sectionsAhead);
        if (this.checkTurn(as)) {
            switch (sectionsAhead) {
                case 0: {
                    newSpeed = 0.0f;
                    break;
                }
                case 1: {
                    newSpeed = InstanceManager.getDefault(SignalSpeedMap.class).getSpeed("Medium");
                    this._activeTrain.setStatus(1);
                    break;
                }
                default: {
                    newSpeed = InstanceManager.getDefault(SignalSpeedMap.class).getSpeed("Normal");
                    this._activeTrain.setStatus(1);
                }
            }
            if (this._currentAllocatedSection != null) {
                for (Block block : this._currentAllocatedSection.getSection().getBlockList()) {
                    float speed = this.getSpeedFromBlock(block);
                    if (!(speed > 0.0f) || !(speed < newSpeed)) continue;
                    newSpeed = speed;
                }
            }
        }
        if (newSpeed > 0.0f) {
            log.trace("setSpeedBySectionsAllocated isStopping[{}]", (Object)this.isStopping());
            this.cancelStopInCurrentSection();
            this.setTargetSpeed(this.getThrottleSettingFromSpeed(newSpeed));
        } else {
            this.stopInCurrentSection(0);
        }
    }

    private boolean checkTurn(AllocatedSection as) {
        Turnout to;
        if (as != null && as.getAutoTurnoutsResponse() != null && (to = InstanceManager.getDefault(DispatcherFrame.class).getAutoTurnoutsHelper().checkStateAgainstList(as.getAutoTurnoutsResponse())) != null) {
            this._turnoutStateListener = e -> {
                if (e.getPropertyName().equals("KnownState")) {
                    ((Turnout)e.getSource()).removePropertyChangeListener(this._turnoutStateListener);
                    this.setSpeedBySignal();
                }
            };
            to.addPropertyChangeListener(this._turnoutStateListener);
            return false;
        }
        return true;
    }

    private void setSpeedBySignalMast() {
        String displayedAspect = this._controllingSignalMast.getAspect();
        if (log.isTraceEnabled()) {
            log.trace("{}: Controlling mast {} ({})", new Object[]{this._activeTrain.getTrainName(), this._controllingSignalMast.getDisplayName(USERSYS), displayedAspect});
            if (this._conSignalProtectedBlock == null) {
                log.trace("{}: Protected block is null", (Object)this._activeTrain.getTrainName());
            } else {
                log.trace("{}: Protected block: {} state: {} speed: {}", new Object[]{this._activeTrain.getTrainName(), this._conSignalProtectedBlock.getSensor().getDisplayName(USERSYS), this._conSignalProtectedBlock.getSensor().getState() == 2 ? "OCCUPIED" : "NOT OCCUPIED", this._conSignalProtectedBlock.getBlockSpeed()});
            }
        }
        if (this._controllingSignalMast.getAppearanceMap().getSpecificAppearance(2).equals(displayedAspect) || !this._controllingSignalMast.getLit() || this._controllingSignalMast.getHeld()) {
            this.checkForSignalPassedOrStop(this._controllingSignalMast.getDisplayName(USERSYS));
        } else if (this._controllingSignalMast.getAppearanceMap().getSpecificAppearance(1) != null && this._controllingSignalMast.getAppearanceMap().getSpecificAppearance(1).equals(displayedAspect)) {
            this.setTargetSpeedState(2);
            this._activeTrain.setStatus(1);
        } else {
            SignalMast smDestination;
            String aspectSpeedStr = (String)this._controllingSignalMast.getSignalSystem().getProperty(displayedAspect, "speed");
            log.trace("{}: Signal {} speed {} for aspect {}", new Object[]{this._activeTrain.getTrainName(), this._controllingSignalMast.getDisplayName(USERSYS), aspectSpeedStr, displayedAspect});
            float speed = -1.0f;
            if (aspectSpeedStr != null) {
                try {
                    speed = Float.parseFloat(aspectSpeedStr);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        speed = InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(aspectSpeedStr);
                        log.trace("{}: Signal {} speed from map for {} is {}", new Object[]{this._activeTrain.getTrainName(), this._controllingSignalMast.getDisplayName(USERSYS), aspectSpeedStr, Float.valueOf(speed)});
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        log.trace("{}: Speed not found {}", (Object)this._activeTrain.getTrainName(), (Object)aspectSpeedStr);
                    }
                }
            }
            int aspectSpeed = (int)speed;
            float smLogicSpeed = -1.0f;
            String smDestinationName = "unknown";
            SignalMastLogic smLogic = InstanceManager.getDefault(SignalMastLogicManager.class).getSignalMastLogic(this._controllingSignalMast);
            if (smLogic != null && (smDestination = smLogic.getActiveDestination()) != null) {
                smDestinationName = smDestination.getDisplayName(USERSYS);
                smLogicSpeed = (int)smLogic.getMaximumSpeed(smDestination);
            }
            if (smLogicSpeed > -1.0f && smLogicSpeed < speed) {
                speed = smLogicSpeed;
            }
            log.debug("{}: {}({}) {}({}), Dest: {}, path max: {}", new Object[]{this._activeTrain.getTrainName(), this._controllingSignalMast.getDisplayName(USERSYS), displayedAspect, aspectSpeedStr, aspectSpeed, smDestinationName, (int)smLogicSpeed});
            if (speed > -1.0f) {
                if (this.prevSpeed == -1.0f || speed < this.prevSpeed) {
                    log.debug("{}: Signal {} setting speed to {} for next", new Object[]{this._activeTrain.getTrainName(), this._controllingSignalMast.getDisplayName(USERSYS), Float.valueOf(speed)});
                    this.setTargetSpeedValue(speed);
                } else {
                    log.debug("{}: Signal {} setting speed to {} for previous", new Object[]{this._activeTrain.getTrainName(), this._controllingSignalMast.getDisplayName(USERSYS), Float.valueOf(speed)});
                    this.setTargetSpeedValue(this.prevSpeed);
                }
                this.prevSpeed = speed;
                this._activeTrain.setStatus(1);
            } else {
                log.warn("{}: No specific speeds found so will use the default", (Object)this._activeTrain.getTrainName());
                this.setTargetSpeedState(6);
                this._activeTrain.setStatus(1);
            }
        }
    }

    private void setSpeedBySignalHead() {
        if (this._controllingSignal != null && this._controllingSignal.getAppearance() == 256) {
            this.stopInCurrentSection(0);
            return;
        }
        if (this.useSpeedProfile) {
            float signalSpeed;
            float blockSpeed = this.getSpeedFromBlock(this._conSignalProtectedBlock);
            String displayedAspect = this._controllingSignal.getAppearanceName();
            try {
                String signalSpeedName = InstanceManager.getDefault(SignalSpeedMap.class).getAppearanceSpeed(displayedAspect);
                signalSpeed = InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(signalSpeedName);
            }
            catch (Throwable throwable) {
                signalSpeed = -1.0f;
                log.warn("{}: Block {} AppearanceSpeed {} not found in SignalSpeedMap", new Object[]{this._activeTrain.getTrainName(), this._conSignalProtectedBlock.getDisplayName(USERSYS), displayedAspect});
            }
            float useSpeed = blockSpeed < signalSpeed ? blockSpeed : signalSpeed;
            log.trace("BlockSpeed[{}] SignalSpeed[{}]", (Object)Float.valueOf(blockSpeed), (Object)Float.valueOf(signalSpeed));
            if (useSpeed < 0.01f) {
                this.checkForSignalPassedOrStop(this._controllingSignal.getDisplayName(USERSYS));
            } else {
                this.setTargetSpeedByProfile(useSpeed);
            }
        } else {
            switch (this._controllingSignal.getAppearance()) {
                case 0: 
                case 1: 
                case 2: {
                    this.checkForSignalPassedOrStop(this._controllingSignal.getDisplayName(USERSYS));
                    break;
                }
                case 4: 
                case 8: {
                    this.setTargetSpeedState(3);
                    this._activeTrain.setStatus(1);
                    break;
                }
                case 16: 
                case 32: {
                    this.setTargetSpeedState(6);
                    this._activeTrain.setStatus(1);
                    break;
                }
                case 64: 
                case 128: {
                    this.setTargetSpeedState(2);
                    this._activeTrain.setStatus(1);
                    break;
                }
                default: {
                    log.warn("Signal Head[{}] has invalid Appearence - using stop", (Object)this._controllingSignal.getAppearance());
                    this.stopInCurrentSection(0);
                }
            }
        }
    }

    private void checkForSignalPassedOrStop(String displayName) {
        if (this._currentAllocatedSection != null) {
            if ((this._currentAllocatedSection.isInActiveBlockList(this._conSignalProtectedBlock) || this._nextSection != null && this._activeTrain.isInAllocatedList(this._nextSection) && this._nextSection.containsBlock(this._conSignalProtectedBlock)) && this._conSignalProtectedBlock.getSensor().getState() == 2) {
                log.debug("{}: _conSignalProtectedBlock [{}] for signal [{}] is the block just past so ignore.", new Object[]{this._activeTrain.getTrainName(), this._conSignalProtectedBlock.getDisplayName(USERSYS), displayName});
            } else {
                log.debug("{}: stopping for signal [{}] ", (Object)this._activeTrain.getTrainName(), (Object)displayName);
                this.stopInCurrentSection(0);
            }
        }
    }

    protected float getSpeedFromBlock(Block block) {
        String blockSpeedName = block.getBlockSpeed();
        if (blockSpeedName.contains("Global")) {
            blockSpeedName = InstanceManager.getDefault(BlockManager.class).getDefaultSpeed();
        }
        float blockSpeed = -1.0f;
        if (!blockSpeedName.isEmpty()) {
            try {
                blockSpeed = Float.parseFloat(blockSpeedName);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    blockSpeed = InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(blockSpeedName);
                    log.debug("{}: block speed from map for {} is {}", new Object[]{this._activeTrain.getTrainName(), block.getDisplayName(USERSYS), blockSpeedName, Float.valueOf(blockSpeed)});
                }
                catch (Throwable throwable) {
                    log.warn("{}: Block {} Speed {} not found in SignalSpeedMap", new Object[]{this._activeTrain.getTrainName(), block.getDisplayName(USERSYS), Float.valueOf(blockSpeed)});
                }
            }
        }
        return blockSpeed;
    }

    private synchronized void cancelStopInCurrentSection() {
        log.trace("[{}]:Cancel Stopping", (Object)this._activeTrain.getTrainName());
        this.cancelStoppingBySensor();
        this._stoppingByBlockOccupancy = false;
        this._stoppingBlock = null;
        this._stoppingUsingSpeedProfile = false;
        this._stoppingBlock = null;
        this._autoEngineer.slowToStop(false);
    }

    private synchronized void stopInCurrentSection(int task) {
        if (this._currentAllocatedSection == null) {
            log.error("{}: Current allocated section null on entry to stopInCurrentSection", (Object)this._activeTrain.getTrainName());
            this.setStopNow();
            return;
        }
        log.debug("{}: StopInCurrentSection called for {} task[{}] targetspeed[{}]", new Object[]{this._activeTrain.getTrainName(), this._currentAllocatedSection.getSection().getDisplayName(USERSYS), task, Float.valueOf(this._targetSpeed)});
        if (this._targetSpeed == 0.0f || this.isStopping()) {
            log.debug("{}: train is already stopped or stopping.", (Object)this._activeTrain.getTrainName());
            return;
        }
        this._stopSensor = this._currentAllocatedSection.getSection().getState() == 4 ? this._currentAllocatedSection.getSection().getForwardStoppingSensor() : this._currentAllocatedSection.getSection().getReverseStoppingSensor();
        if (this._stopSensor != null) {
            if (this._stopSensor.getKnownState() == 2) {
                this.setStopNow();
            } else {
                this.setDecreasedSpeedBeforeStop();
                this._stopSensorListener = e -> this.handleStopSensorChange(e);
                this._stopSensor.addPropertyChangeListener(this._stopSensorListener);
                this._stoppingBySensor = true;
            }
        } else if (this._useSpeedProfile && this._stopBySpeedProfile) {
            log.debug("{}: Section [{}] Section Length[{}] Max Train Length [{}] StopBySpeedProfile [{}]. setStopNow", new Object[]{this._activeTrain.getTrainName(), this._currentAllocatedSection.getSection().getDisplayName(USERSYS), this._currentAllocatedSection.getLength(), Float.valueOf(this._maxTrainLength), this._stopBySpeedProfile});
            this.setStopNow(true);
        } else if ((float)this._currentAllocatedSection.getLength() < this._maxTrainLength) {
            log.debug("{}: Section [{}] Section Length[{}] Max Train Length [{}]. setStopNow", new Object[]{this._activeTrain.getTrainName(), this._currentAllocatedSection.getSection().getDisplayName(USERSYS), this._currentAllocatedSection.getLength(), Float.valueOf(this._maxTrainLength), this._stopBySpeedProfile});
            this.setStopNow();
        } else if (this._resistanceWheels) {
            log.debug("{}: train will fit in [{}] ({}>={}), stop when prev block clears.", new Object[]{this._activeTrain.getTrainName(), this._currentAllocatedSection.getSection().getDisplayName(USERSYS), this._currentAllocatedSection.getLength(), Float.valueOf(this._maxTrainLength)});
            if (this._currentAllocatedSection.getSection().getNumBlocks() == 1) {
                if (this._previousAllocatedSection != null) {
                    Block tBlock = this._previousAllocatedSection.getSection().getNumBlocks() == 1 ? this._previousAllocatedSection.getSection().getLastBlock() : this._previousAllocatedSection.getSection().getExitBlock();
                    if (tBlock != null && tBlock.getState() == 2) {
                        this._stoppingBlock = tBlock;
                        this.setStopByBlockOccupancy(false);
                    } else {
                        this.setStopNow();
                    }
                } else {
                    this.setStopNow();
                }
            } else {
                Block exitBlock = this._currentAllocatedSection.getExitBlock();
                Block enterBlock = this._currentAllocatedSection.getEnterBlock(this._previousAllocatedSection);
                if (enterBlock == null) {
                    this.setStopNow();
                } else if (exitBlock == enterBlock) {
                    if (this._previousBlock != null && this._previousBlock.getState() == 2 && (float)this.getBlockLength(exitBlock) > this._maxTrainLength) {
                        this._stoppingBlock = this._previousBlock;
                        this.setStopByBlockOccupancy(false);
                    } else {
                        this.setStopNow();
                    }
                } else {
                    Block tstBlock = exitBlock;
                    if (tstBlock == null) {
                        tstBlock = this._currentAllocatedSection.getDirection() == 8 ? this._currentAllocatedSection.getSection().getBlockBySequenceNumber(0) : this._currentAllocatedSection.getSection().getBlockBySequenceNumber(this._currentAllocatedSection.getSection().getNumBlocks() - 1);
                    }
                    int tstLength = this.getBlockLength(tstBlock);
                    int tstBlockSeq = this._currentAllocatedSection.getSection().getBlockSequenceNumber(tstBlock);
                    while ((float)tstLength < this._maxTrainLength && tstBlock != enterBlock) {
                        int newSeqNumber = this._currentAllocatedSection.getDirection() == 8 ? tstBlockSeq + 1 : tstBlockSeq - 1;
                        tstBlock = this._currentAllocatedSection.getSection().getBlockBySequenceNumber(newSeqNumber);
                        tstBlockSeq = newSeqNumber;
                        tstLength += this.getBlockLength(tstBlock);
                    }
                    if (this._maxTrainLength > (float)tstLength) {
                        this.setStopNow();
                    } else if (tstBlock == enterBlock) {
                        Block previousSectionExitBlock = this._previousAllocatedSection.getExitBlock();
                        if (previousSectionExitBlock != null && previousSectionExitBlock.getState() == 2) {
                            this._stoppingBlock = previousSectionExitBlock;
                            this.setStopByBlockOccupancy(true);
                        } else {
                            this.setStopNow();
                        }
                    } else {
                        int xSeqNumber = tstBlockSeq + 1;
                        if (this._currentAllocatedSection.getDirection() == 4) {
                            xSeqNumber = tstBlockSeq - 1;
                        }
                        this._stoppingBlock = this._currentAllocatedSection.getSection().getBlockBySequenceNumber(xSeqNumber);
                        this.setStopByBlockOccupancy(true);
                    }
                }
            }
        } else {
            this.setStopNow();
        }
        WaitForTrainToStop waitForStop = new WaitForTrainToStop(task);
        Thread tWait = ThreadingUtil.newThread(waitForStop, "Wait for stop " + this.getActiveTrain().getActiveTrainName());
        tWait.start();
    }

    protected synchronized void executeStopTasks(int task) {
        this.cancelStopInCurrentSection();
        log.trace("exec[{}]", (Object)task);
        switch (task) {
            case 0: {
                break;
            }
            case 1: {
                this._activeTrain.setRestart();
                this._activeTrain.setTransitReversed(true);
                this._activeTrain.reverseAllAllocatedSections();
                this.setEngineDirection();
                this._previousBlock = null;
                this._nextBlock = this.getNextBlock(this._currentBlock, this._currentAllocatedSection);
                if (this._activeTrain.getDelayedRestart() != 0) break;
                if (this._nextSection != null && !this._activeTrain.isInAllocatedList(this._nextSection)) {
                    InstanceManager.getDefault(DispatcherFrame.class).queueScanOfAllocationRequests();
                    break;
                }
                this.setupNewCurrentSignal(this._currentAllocatedSection, true);
                this.setSpeedBySignal();
                break;
            }
            case 2: {
                this._activeTrain.setRestart();
                if (this._activeTrain.getResetWhenDone()) {
                    if (this._activeTrain.getDelayedRestart() == 0 && !this._activeTrain.getReverseAtEnd()) {
                        log.error("[{}]: train is continueing without pause, should have been handled in handleBlockStateChange.", (Object)this._activeTrain.getTrainName());
                        break;
                    }
                    this._activeTrain.setTransitReversed(false);
                    this._activeTrain.resetAllAllocatedSections();
                    this._previousBlock = null;
                    this._nextBlock = this.getNextBlock(this._currentBlock, this._currentAllocatedSection);
                    this.setEngineDirection();
                    this._activeTrain.setRestart();
                    if (this._nextSection != null && !this._activeTrain.isInAllocatedList(this._nextSection)) {
                        InstanceManager.getDefault(DispatcherFrame.class).queueScanOfAllocationRequests();
                    }
                    this.setupNewCurrentSignal(null, true);
                    this.setSpeedBySignal();
                    break;
                }
                log.warn("[{}]resetWhenDone flag reset, likely user cancelling while processing stop", (Object)this._activeTrain.getActiveTrainName());
                break;
            }
            default: {
                log.debug("[{}]Invalid action [{}] in executeStopTasksRequest to execute BEGINNING_RESET cancelled", (Object)this._activeTrain.getActiveTrainName(), (Object)task);
            }
        }
    }

    private void cancelStoppingBySensor() {
        if (this._stopSensor != null) {
            this._stopSensor.removePropertyChangeListener(this._stopSensorListener);
            this._stoppingBySensor = false;
            this._stopSensorListener = null;
            this._stopSensor = null;
        }
    }

    private synchronized void handleStopSensorChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("KnownState") && (Integer)e.getNewValue() == 2) {
            this._stopSensor.removePropertyChangeListener(this._stopSensorListener);
            this._stoppingBySensor = false;
            this._stopSensorListener = null;
            this._stopSensor = null;
            if (this._needSetSpeed) {
                this._needSetSpeed = false;
                this.setSpeedBySignal();
            } else {
                this.setStopNow();
            }
        }
    }

    private synchronized void setStopNow() {
        this.setStopNow(false);
    }

    private synchronized void setStopNow(boolean useSpeedProfile) {
        this.setTargetSpeedState(1, useSpeedProfile);
        if (this._currentAllocatedSection == null) {
            this._activeTrain.setStatus(4);
        } else if (this._currentAllocatedSection.getNextSection() == null) {
            this.waitUntilStopped();
            this._activeTrain.setStatus(64);
        } else {
            this._activeTrain.setStatus(4);
        }
    }

    private void setStopByBlockOccupancy(boolean ignoreNotOccupied) {
        if (this._stoppingBlock.getState() == 2 || ignoreNotOccupied) {
            this.setDecreasedSpeedBeforeStop();
            this._stoppingByBlockOccupancy = true;
        } else {
            this.setStopNow();
        }
    }

    private void setDecreasedSpeedBeforeStop() {
        float signalSpeed = 25.0f;
        try {
            signalSpeed = InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(InstanceManager.getDefault(DispatcherFrame.class).getStoppingSpeedName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("Missing [{}] from Speed table - defaulting to 25", (Object)InstanceManager.getDefault(DispatcherFrame.class).getStoppingSpeedName());
        }
        this.setToAMaximumThrottle(this.getThrottleSettingFromSpeed(signalSpeed));
    }

    private synchronized void setToAMaximumThrottle(float throttleSetting) {
        if (throttleSetting < this._targetSpeed) {
            this._targetSpeed = throttleSetting;
        }
    }

    private synchronized float getThrottleSettingFromSpeed(float speed) {
        if (this.useSpeedProfile) {
            float throttleSetting = this._activeTrain.getRosterEntry().getSpeedProfile().getThrottleSettingFromSignalMapSpeed(speed, this._forward);
            return this.applyMaxThrottleAndFactor(throttleSetting);
        }
        if (InstanceManager.getDefault(DispatcherFrame.class).getSignalType() == 1) {
            float mls = this._controllingSignalMast != null ? this._controllingSignalMast.getSignalSystem().getMaximumLineSpeed() : InstanceManager.getDefault(DispatcherFrame.class).getMaximumLineSpeed();
            float throttleSetting = speed / mls;
            return this.applyMaxThrottleAndFactor(throttleSetting);
        }
        return this.applyMaxThrottleAndFactor(speed / 100.0f);
    }

    private synchronized float applyMaxThrottleAndFactor(float throttleSetting) {
        if (throttleSetting > 0.0f) {
            if (throttleSetting > this._maxSpeed) {
                return this._maxSpeed * this._speedFactor;
            }
            return throttleSetting * this._speedFactor;
        }
        return throttleSetting;
    }

    private synchronized void setTargetSpeedState(int speedState) {
        this.setTargetSpeedState(speedState, false);
    }

    private synchronized void setTargetSpeedState(int speedState, boolean stopBySpeedProfile) {
        log.trace("{}: setTargetSpeedState:({})", (Object)this._activeTrain.getTrainName(), (Object)speedState);
        this._autoEngineer.slowToStop(false);
        if (speedState > 1) {
            this.cancelStopInCurrentSection();
            this._targetSpeed = this.applyMaxThrottleAndFactor(this._speedRatio[speedState].floatValue());
        } else if (stopBySpeedProfile) {
            this._stoppingUsingSpeedProfile = true;
            this._autoEngineer.slowToStop(true);
            this._targetSpeed = 0.0f;
        } else {
            this._autoEngineer.setHalt(true);
            this._targetSpeed = 0.0f;
        }
    }

    private synchronized void setTargetSpeedByProfile(float speedState) {
        try {
            float throttleSetting = this._activeTrain.getRosterEntry().getSpeedProfile().getThrottleSettingFromSignalMapSpeed(speedState, this._forward);
            log.debug("{}: setTargetSpeedByProfile: SpeedState[{}]", new Object[]{this._activeTrain.getTrainName(), Float.valueOf(throttleSetting), Float.valueOf(speedState)});
            if ((double)throttleSetting > 0.009) {
                this.cancelStopInCurrentSection();
                this._targetSpeed = this.applyMaxThrottleAndFactor(throttleSetting);
            } else if (this.useSpeedProfile && this._stopBySpeedProfile) {
                this._targetSpeed = 0.0f;
                this._stoppingUsingSpeedProfile = true;
                this._autoEngineer.slowToStop(true);
            } else {
                this._autoEngineer.slowToStop(false);
                this._targetSpeed = 0.0f;
                this._autoEngineer.setHalt(true);
            }
        }
        catch (Exception ex) {
            log.error("setTargetSpeedByProfile crashed - Emergency Stop: ", (Throwable)ex);
            this._autoEngineer.slowToStop(false);
            this._targetSpeed = -1.0f;
            this._autoEngineer.setHalt(true);
        }
    }

    private synchronized void setTargetSpeedValue(float speed) {
        log.debug("{}: setTargetSpeedValue: Speed[{}]", (Object)this._activeTrain.getTrainName(), (Object)Float.valueOf(speed));
        if (this.useSpeedProfile) {
            this.setTargetSpeedByProfile(speed);
            return;
        }
        this._autoEngineer.slowToStop(false);
        float mls = this._controllingSignalMast != null ? this._controllingSignalMast.getSignalSystem().getMaximumLineSpeed() : InstanceManager.getDefault(DispatcherFrame.class).getMaximumLineSpeed();
        float decSpeed = speed / mls;
        if (decSpeed > 0.0f) {
            this.cancelStopInCurrentSection();
            this._targetSpeed = this.applyMaxThrottleAndFactor(decSpeed);
        } else {
            this._targetSpeed = 0.0f;
            this._autoEngineer.setHalt(true);
        }
    }

    private int getBlockLength(Block b) {
        if (b == null) {
            return 0;
        }
        float fLength = b.getLengthMm() / (float)InstanceManager.getDefault(DispatcherFrame.class).getScale().getScaleFactor();
        if (InstanceManager.getDefault(DispatcherFrame.class).getUseScaleMeters()) {
            return (int)(fLength * 0.001f);
        }
        return (int)(fLength * 0.00328084f);
    }

    protected void initiateWorking() {
        if (this._activeTrain.getStatus() != 8) {
            this._activeTrain.setMode(8);
            this._activeTrain.setStatus(8);
            this.saveSpeedAndDirection();
            if (this._autoEngineer != null) {
                this._autoEngineer.setHalt(true);
                this.waitUntilStopped();
                this._autoEngineer.abort();
                InstanceManager.throttleManagerInstance().releaseThrottle(this._throttle, this);
                this._autoEngineer = null;
                this._throttle = null;
            }
        }
    }

    protected void waitUntilStopped() {
        boolean doneWaiting = false;
        while (!doneWaiting) {
            doneWaiting = this._autoEngineer != null ? this._autoEngineer.isStopped() : true;
            if (doneWaiting) continue;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void resumeAutomaticRunning() {
        if (this._activeTrain.getStatus() == 8 || this._activeTrain.getStatus() == 16) {
            this._autoTrainAction.cancelDoneSensor();
            if (this.initialize()) {
                this._resumingAutomatic = true;
            } else {
                log.error("Failed to initialize throttle when resuming automatic mode.");
            }
        }
    }

    public Thread pauseTrain(int fastMinutes) {
        if (this._pausingActive) {
            return null;
        }
        PauseTrain pauseTrain = new PauseTrain(fastMinutes);
        Thread tPause = ThreadingUtil.newThread(pauseTrain, "pause train " + this._activeTrain.getTrainName());
        tPause.start();
        return tPause;
    }

    public void terminate() {
        while (this._activeHornThreads > 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this._autoTrainAction.clearRemainingActions();
        if (this._autoEngineer != null) {
            this._autoEngineer.setHalt(true);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
            this.waitUntilStopped();
            this._autoEngineer.abort();
            InstanceManager.throttleManagerInstance().releaseThrottle(this._throttle, this);
        }
    }

    public void dispose() {
        if (this._controllingSignalMast != null && this._conSignalMastListener != null) {
            this._controllingSignalMast.removePropertyChangeListener(this._conSignalMastListener);
        }
        this._controllingSignalMast = null;
        this._conSignalMastListener = null;
    }

    public static int getRampRateFromName(String rampRate) {
        if (rampRate.equals(Bundle.getMessage("RAMP_FAST"))) {
            return 1;
        }
        if (rampRate.equals(Bundle.getMessage("RAMP_MEDIUM"))) {
            return 2;
        }
        if (rampRate.equals(Bundle.getMessage("RAMP_MED_SLOW"))) {
            return 3;
        }
        if (rampRate.equals(Bundle.getMessage("RAMP_SLOW"))) {
            return 4;
        }
        return 0;
    }

    class AutoEngineer
    implements Runnable {
        private volatile boolean _abort = false;
        private volatile boolean _halt = false;
        private boolean _halted = false;
        private boolean _slowToStop = false;
        private float _currentSpeed = 0.0f;
        private float _speedIncrement = 0.0f;
        private boolean _speedProfileStoppingIsRunning = false;

        AutoEngineer() {
        }

        @Override
        public void run() {
            this._abort = false;
            this.setHalt(false);
            this.slowToStop(false);
            DispatcherFrame dispatcher = InstanceManager.getDefault(DispatcherFrame.class);
            this._speedIncrement = 100.0f / ((float)dispatcher.getFullRampTime() / (float)dispatcher.getMinThrottleInterval()) / (float)AutoActiveTrain.this._currentRampRate / 100.0f;
            log.debug("{}: _speedIncrement={}", (Object)AutoActiveTrain.this._activeTrain.getTrainName(), (Object)Float.valueOf(this._speedIncrement));
            log.debug("{}: AutoEngineer.setIsForward({})", (Object)AutoActiveTrain.this._activeTrain.getTrainName(), (Object)AutoActiveTrain.this._forward);
            AutoActiveTrain.this._throttle.setIsForward(AutoActiveTrain.this._forward);
            try {
                Thread.sleep(dispatcher.getMinThrottleInterval() * 2);
            }
            catch (InterruptedException interruptedException) {
                log.warn("Someones shutting us down");
                this._abort = true;
            }
            AutoActiveTrain.this._throttle.setSpeedSetting(this._currentSpeed);
            while (!this._abort) {
                if (this._halt && !this._halted) {
                    if (this._speedProfileStoppingIsRunning) {
                        AutoActiveTrain.this.re.getSpeedProfile().cancelSpeedChange();
                        this._speedProfileStoppingIsRunning = false;
                    }
                    AutoActiveTrain.this._throttle.setSpeedSetting(0.0f);
                    this._currentSpeed = 0.0f;
                    AutoActiveTrain.this._targetSpeed = 0.0f;
                    this._halted = true;
                } else if (this._slowToStop) {
                    if (AutoActiveTrain.this.useSpeedProfile && !this._speedProfileStoppingIsRunning) {
                        AutoActiveTrain.this.re.getSpeedProfile().setExtraInitialDelay(1500.0f);
                        AutoActiveTrain.this.re.getSpeedProfile().changeLocoSpeed(AutoActiveTrain.this._throttle, AutoActiveTrain.this._currentAllocatedSection.getSection(), 0.0f, AutoActiveTrain.this._stopBySpeedProfileAdjust);
                        this._speedProfileStoppingIsRunning = true;
                        AutoActiveTrain.this._targetSpeed = 0.0f;
                    } else if (!this._speedProfileStoppingIsRunning) {
                        AutoActiveTrain.this._throttle.setSpeedSetting(0.0f);
                        this._currentSpeed = 0.0f;
                        AutoActiveTrain.this._targetSpeed = 0.0f;
                        this._halted = true;
                    }
                } else if (!this._halt) {
                    if (this._speedProfileStoppingIsRunning) {
                        AutoActiveTrain.this.re.getSpeedProfile().cancelSpeedChange();
                        this._speedProfileStoppingIsRunning = false;
                    } else {
                        if (AutoActiveTrain.this._throttle.getIsForward() != AutoActiveTrain.this._forward) {
                            log.debug("AutoEngineer.setIsForward({}), was {} for {}", new Object[]{AutoActiveTrain.this._forward, AutoActiveTrain.this._throttle.getIsForward(), AutoActiveTrain.this._throttle.getLocoAddress()});
                            AutoActiveTrain.this._throttle.setIsForward(AutoActiveTrain.this._forward);
                            try {
                                Thread.sleep(dispatcher.getMinThrottleInterval() * 2);
                            }
                            catch (InterruptedException interruptedException) {
                                log.warn("Someones shutting us down");
                                this._abort = true;
                            }
                        }
                        if (Math.abs(this._currentSpeed - AutoActiveTrain.this._targetSpeed) > 4.0E-4f) {
                            if (AutoActiveTrain.this._currentRampRate == 0) {
                                this._currentSpeed = AutoActiveTrain.this._targetSpeed;
                                AutoActiveTrain.this._throttle.setSpeedSetting(this._currentSpeed);
                            } else {
                                if (this._currentSpeed < AutoActiveTrain.this._targetSpeed) {
                                    this._currentSpeed += this._speedIncrement;
                                    if (this._currentSpeed >= AutoActiveTrain.this._targetSpeed) {
                                        this._currentSpeed = AutoActiveTrain.this._targetSpeed;
                                    }
                                } else {
                                    this._currentSpeed -= this._speedIncrement;
                                    if (this._currentSpeed <= AutoActiveTrain.this._targetSpeed) {
                                        this._currentSpeed = AutoActiveTrain.this._targetSpeed;
                                    }
                                }
                                AutoActiveTrain.this._throttle.setSpeedSetting(this._currentSpeed);
                                log.trace("_currentSpeed:{}", (Object)Float.valueOf(this._currentSpeed));
                            }
                        }
                    }
                }
                try {
                    Thread.sleep(dispatcher.getMinThrottleInterval());
                }
                catch (InterruptedException interruptedException) {
                    log.warn("Someones shutting us down");
                    this._abort = true;
                }
            }
        }

        public synchronized void slowToStop(boolean toStop) {
            this._slowToStop = toStop;
            if (!toStop) {
                this.setHalt(toStop);
            }
        }

        public synchronized void setHalt(boolean halt) {
            this._halt = halt;
            if (!this._halt) {
                this._halted = false;
            }
        }

        public synchronized void setSpeedImmediate(float speed) {
            log.trace("{}: setting speed directly to {}%", (Object)AutoActiveTrain.this._activeTrain.getTrainName(), (Object)((int)(speed * 100.0f)));
            AutoActiveTrain.this._targetSpeed = speed;
            this._currentSpeed = speed + this._speedIncrement;
        }

        public synchronized boolean isStopped() {
            this._currentSpeed = AutoActiveTrain.this._throttle.getSpeedSetting();
            return this._currentSpeed <= 4.0E-4f;
        }

        public synchronized boolean isAtSpeed() {
            return (double)Math.abs(this._currentSpeed - AutoActiveTrain.this._targetSpeed) <= 0.01;
        }

        public void abort() {
            this._abort = true;
        }

        protected void setFunction(int cmdNum, boolean isSet) {
            AutoActiveTrain.this._throttle.setFunction(cmdNum, isSet);
        }
    }

    class PauseTrain
    implements Runnable {
        private int _fastMinutes = 0;
        private float _savedTargetSpeed = 0.0f;
        private int _savedRampRate = 0;

        public PauseTrain(int fastMinutes) {
            this._fastMinutes = fastMinutes;
        }

        @Override
        public void run() {
            AutoActiveTrain.this._pausingActive = true;
            this._savedTargetSpeed = AutoActiveTrain.this.getTargetSpeed();
            this._savedRampRate = AutoActiveTrain.this.getRampRate();
            AutoActiveTrain.this.setCurrentRampRate(1);
            AutoActiveTrain.this.stopInCurrentSection(0);
            boolean waitNow = true;
            boolean keepGoing = true;
            while (waitNow) {
                try {
                    Thread.sleep(101L);
                    if (AutoActiveTrain.this._autoEngineer != null) {
                        if (!AutoActiveTrain.this._autoEngineer.isStopped()) continue;
                        waitNow = false;
                        continue;
                    }
                    waitNow = false;
                }
                catch (InterruptedException e2) {
                    log.error("InterruptedException while watiting to stop for pause - {}", (Object)e2);
                    waitNow = false;
                    keepGoing = false;
                }
            }
            AutoActiveTrain.this._activeTrain.setStatus(2);
            if (keepGoing) {
                Timebase _clock = InstanceManager.getDefault(Timebase.class);
                PropertyChangeListener _clockListener = e -> --this._fastMinutes;
                _clock.addMinuteChangeListener(_clockListener);
                waitNow = true;
                while (waitNow) {
                    try {
                        Thread.sleep(501L);
                        if (this._fastMinutes > 0) continue;
                        waitNow = false;
                    }
                    catch (InterruptedException e3) {
                        log.error("InterruptedException while waiting when paused", (Throwable)e3);
                        keepGoing = false;
                    }
                }
                _clock.removeMinuteChangeListener(_clockListener);
            }
            AutoActiveTrain.this._pausingActive = false;
            if (keepGoing) {
                AutoActiveTrain.this.setCurrentRampRate(this._savedRampRate);
                AutoActiveTrain.this.setTargetSpeed(this._savedTargetSpeed);
                AutoActiveTrain.this._activeTrain.setStatus(1);
                AutoActiveTrain.this.setSpeedBySignal();
            }
        }
    }

    class WaitForTrainToStop
    implements Runnable {
        private final int _delay = 91;
        private int _task = 0;

        public WaitForTrainToStop(int task) {
            this._task = task;
        }

        @Override
        public void run() {
            boolean waitingOnTrain = true;
            try {
                while (waitingOnTrain) {
                    if (AutoActiveTrain.this.getAutoEngineer() != null && AutoActiveTrain.this.getAutoEngineer().isStopped()) {
                        waitingOnTrain = false;
                        continue;
                    }
                    Thread.sleep(91L);
                }
                log.trace("executing task[{}]", (Object)this._task);
                AutoActiveTrain.this.executeStopTasks(this._task);
            }
            catch (InterruptedException interruptedException) {
                log.warn("Waiting for train to stop interrupted - stop tasks not executing");
            }
            catch (Exception e) {
                log.error("Waiting for train to stop crashed - stop tasks not executing.", (Throwable)e);
            }
        }
    }
}

