/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import jmri.Block;
import jmri.InstanceManager;
import jmri.Section;
import jmri.SignalMast;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.Bundle;
import jmri.jmrit.dispatcher.DispatcherFrame;

public class AllocationRequest {
    private Section mSection = null;
    private ActiveTrain mActiveTrain = null;
    private int mSectionSeqNum = 0;
    private int mSectionDirection = 1;
    private PropertyChangeListener mSectionListener = null;
    private boolean mWaitingForTrain = false;
    private ArrayList<ActiveTrain> mMeetingTrainList = new ArrayList();
    private PropertyChangeListener mSignalMastListener = null;
    private SignalMast mWaitingForSignalMast = null;
    Block mWaitingOnBlock = null;
    private PropertyChangeListener mWaitingOnBlockListener = null;

    public AllocationRequest(Section s, int num, int dir, ActiveTrain at) {
        this.mSection = s;
        this.mActiveTrain = at;
        this.mSectionSeqNum = num;
        this.mSectionDirection = dir;
        if (this.mSection != null) {
            this.mSectionListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    AllocationRequest.this.handleSectionChange(e);
                }
            };
            this.mSection.addPropertyChangeListener(this.mSectionListener);
        }
    }

    public Section getSection() {
        return this.mSection;
    }

    public String getSectionName() {
        String s = this.mSection.getDisplayName();
        return s;
    }

    protected ActiveTrain getActiveTrain() {
        return this.mActiveTrain;
    }

    protected String getActiveTrainName() {
        return String.valueOf(this.mActiveTrain.getTrainName()) + "/" + this.mActiveTrain.getTransitName();
    }

    protected int getSectionSeqNumber() {
        return this.mSectionSeqNum;
    }

    protected int getSectionDirection() {
        return this.mSectionDirection;
    }

    protected String getSectionDirectionName() {
        if (this.mSectionDirection == 4) {
            return Bundle.getMessage("FORWARD");
        }
        if (this.mSectionDirection == 8) {
            return Bundle.getMessage("REVERSE");
        }
        return Bundle.getMessage("UNKNOWN");
    }

    protected boolean getWaitingForTrain() {
        return this.mWaitingForTrain;
    }

    protected void setWaitingForTrain(boolean set) {
        this.mWaitingForTrain = set;
    }

    protected void addMeetingTrain(ActiveTrain at) {
        this.mMeetingTrainList.add(at);
    }

    protected void removeMeetingTrain(ActiveTrain at) {
        int i = 0;
        while (i < this.mMeetingTrainList.size()) {
            if (at == this.mMeetingTrainList.get(i)) {
                this.mMeetingTrainList.remove(i);
                return;
            }
            ++i;
        }
    }

    protected ArrayList<ActiveTrain> getMeetingTrainList() {
        return this.mMeetingTrainList;
    }

    private void handleSectionChange(PropertyChangeEvent e) {
        InstanceManager.getDefault(DispatcherFrame.class).sectionOccupancyChanged();
        if (e.getPropertyName().equals("occupancy") && (Integer)e.getNewValue() == 4) {
            InstanceManager.getDefault(DispatcherFrame.class).queueScanOfAllocationRequests();
        }
    }

    public void dispose() {
        if (this.mSectionListener != null && this.mSection != null) {
            this.mSection.removePropertyChangeListener(this.mSectionListener);
        }
        if (this.mSignalMastListener != null && this.mWaitingForSignalMast != null) {
            this.mWaitingForSignalMast.removePropertyChangeListener(this.mSignalMastListener);
        }
        if (this.mWaitingOnBlock != null && this.mWaitingOnBlockListener != null) {
            this.mWaitingOnBlock.removePropertyChangeListener(this.mWaitingOnBlockListener);
        }
        this.mWaitingOnBlock = null;
        this.mWaitingOnBlockListener = null;
        this.mSignalMastListener = null;
        this.mWaitingForSignalMast = null;
        this.mSectionListener = null;
        this.mSection = null;
        this.mActiveTrain = null;
    }

    public void setWaitingForSignalMast(SignalMast sm) {
        if (this.mSignalMastListener == null) {
            this.mSignalMastListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("Held") && !((Boolean)e.getNewValue()).booleanValue()) {
                        AllocationRequest.this.mWaitingForSignalMast.removePropertyChangeListener(AllocationRequest.this.mSignalMastListener);
                        InstanceManager.getDefault(DispatcherFrame.class).queueScanOfAllocationRequests();
                    }
                }
            };
        }
        if (this.mWaitingForSignalMast != null) {
            this.mWaitingForSignalMast.removePropertyChangeListener(this.mSignalMastListener);
        }
        this.mWaitingForSignalMast = sm;
        if (this.mWaitingForSignalMast != null) {
            this.mWaitingForSignalMast.addPropertyChangeListener(this.mSignalMastListener);
        }
    }

    protected void setWaitingOnBlock(Block b) {
        if (this.mWaitingOnBlockListener == null) {
            this.mWaitingOnBlockListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("state") && (Integer)e.getNewValue() == 4) {
                        AllocationRequest.this.mWaitingOnBlock.removePropertyChangeListener(AllocationRequest.this.mWaitingOnBlockListener);
                        InstanceManager.getDefault(DispatcherFrame.class).queueScanOfAllocationRequests();
                    }
                }
            };
        }
        if (this.mWaitingOnBlock != null) {
            this.mWaitingOnBlock.removePropertyChangeListener(this.mWaitingOnBlockListener);
        }
        this.mWaitingOnBlock = b;
        if (this.mWaitingOnBlock != null) {
            this.mWaitingOnBlock.addPropertyChangeListener(this.mWaitingOnBlockListener);
        }
    }
}

