/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import java.util.List;
import jmri.Section;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.AllocatedSection;
import jmri.jmrit.dispatcher.AutoAllocate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocationPlan {
    protected static final int NONE = 0;
    protected static final int XING_MEET = 1;
    protected static final int PASSING_MEET = 2;
    protected static final int CONTINUING = 4;
    private AutoAllocate _autoAllocate = null;
    private int _planNum = 0;
    private int _planType = 0;
    private ActiveTrain _atOne = null;
    private ActiveTrain _atTwo = null;
    private Section _tSectionOne = null;
    private Section _tSectionTwo = null;
    private int _tSectionOneSeq = 0;
    private int _tSectionTwoSeq = 0;
    private static final Logger log = LoggerFactory.getLogger(AllocationPlan.class);

    public AllocationPlan(AutoAllocate aa, int planNum) {
        this._autoAllocate = aa;
        if (this._autoAllocate == null) {
            log.error("null AutoAllocate when constructing an AllocationPlan");
        }
        this._planNum = planNum;
    }

    protected int getPlanNum() {
        return this._planNum;
    }

    protected int getPlanType() {
        return this._planType;
    }

    protected void setPlanType(int type) {
        this._planType = type;
    }

    protected ActiveTrain getActiveTrain(int i) {
        if (i == 1) {
            return this._atOne;
        }
        if (i == 2) {
            return this._atTwo;
        }
        return null;
    }

    protected void setActiveTrain(ActiveTrain at, int i) {
        if (i == 1) {
            this._atOne = at;
        } else if (i == 2) {
            this._atTwo = at;
        } else {
            log.error("out of range index argument in call to 'setActiveTrain'");
        }
    }

    protected Section getTargetSection(int i) {
        if (i == 1) {
            return this._tSectionOne;
        }
        if (i == 2) {
            return this._tSectionTwo;
        }
        return null;
    }

    protected void setTargetSection(Section s, int seq, int i) {
        if (i == 1) {
            this._tSectionOne = s;
            this._tSectionOneSeq = seq;
        } else if (i == 2) {
            this._tSectionTwo = s;
            this._tSectionTwoSeq = seq;
        } else {
            log.error("out of range index argument in call to 'setTargetSection'");
        }
    }

    protected int getTargetSectionSequenceNum(int i) {
        if (i == 1) {
            return this._tSectionOneSeq;
        }
        if (i == 2) {
            return this._tSectionTwoSeq;
        }
        return 0;
    }

    protected boolean isComplete() {
        if (this._atOne == null || this._atTwo == null) {
            return false;
        }
        List<AllocatedSection> aSections = this._atOne.getAllocatedSectionList();
        boolean complete = false;
        int i = 0;
        while (i < aSections.size()) {
            if (aSections.get(i).getSection() == this._tSectionOne && aSections.get(i).getSequence() == this._tSectionOneSeq) {
                complete = true;
            }
            ++i;
        }
        if (!complete) {
            return false;
        }
        complete = false;
        aSections = this._atTwo.getAllocatedSectionList();
        int j = 0;
        while (j < aSections.size()) {
            if (aSections.get(j).getSection() == this._tSectionTwo && aSections.get(j).getSequence() == this._tSectionTwoSeq) {
                complete = true;
            }
            ++j;
        }
        return complete;
    }

    public void dispose() {
    }
}

