/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.Block;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Path;
import jmri.Section;
import jmri.Sensor;
import jmri.Timebase;
import jmri.Transit;
import jmri.beans.PropertyChangeProvider;
import jmri.jmrit.beantable.LogixTableAction;
import jmri.jmrit.dispatcher.AllocatedSection;
import jmri.jmrit.dispatcher.AllocationRequest;
import jmri.jmrit.dispatcher.AutoActiveTrain;
import jmri.jmrit.dispatcher.Bundle;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveTrain
implements PropertyChangeProvider {
    private static final NamedBean.DisplayOptions USERSYS = NamedBean.DisplayOptions.USERNAME_SYSTEMNAME;
    public static final int RUNNING = 1;
    public static final int PAUSED = 2;
    public static final int WAITING = 4;
    public static final int WORKING = 8;
    public static final int READY = 16;
    public static final int STOPPED = 32;
    public static final int DONE = 64;
    public static final int NONE = 0;
    public static final int LOCAL_PASSENGER = 1;
    public static final int LOCAL_FREIGHT = 2;
    public static final int THROUGH_PASSENGER = 3;
    public static final int THROUGH_FREIGHT = 4;
    public static final int EXPRESS_PASSENGER = 5;
    public static final int EXPRESS_FREIGHT = 6;
    public static final int MOW = 7;
    public static final int AUTOMATIC = 2;
    public static final int MANUAL = 4;
    public static final int DISPATCHED = 8;
    public static final int ROSTER = 1;
    public static final int OPERATIONS = 2;
    public static final int USER = 4;
    public static final int ALLOCATE_AS_FAR_AS_IT_CAN = -1;
    public static final int ALLOCATE_BY_SAFE_SECTIONS = 0;
    private Transit mTransit = null;
    private String mTrainName = "";
    private int mTrainSource = 1;
    private RosterEntry mRoster = null;
    private int mStatus = 4;
    private int mMode = 8;
    private boolean mTransitReversed = false;
    private boolean mAllocationReversed = false;
    private AutoActiveTrain mAutoActiveTrain = null;
    private final List<AllocatedSection> mAllocatedSections = new ArrayList<AllocatedSection>();
    private Section mLastAllocatedSection = null;
    private int mLastAllocatedSectionSeqNumber = 0;
    private Section mSecondAllocatedSection = null;
    private int mNextAllocationNumber = 1;
    private Section mNextSectionToAllocate = null;
    private int mNextSectionSeqNumber = 0;
    private int mNextSectionDirection = 0;
    private Block mStartBlock = null;
    private int mStartBlockSectionSequenceNumber = 0;
    private Block mEndBlock = null;
    private Section mEndBlockSection = null;
    private int mEndBlockSectionSequenceNumber = 0;
    private int mPriority = 0;
    private boolean mAutoRun = false;
    private String mDccAddress = "";
    private boolean mResetWhenDone = true;
    private boolean mReverseAtEnd = false;
    private int mAllocateMethod = 3;
    public static final int NODELAY = 0;
    public static final int TIMEDDELAY = 1;
    public static final int SENSORDELAY = 2;
    private int mDelayedRestart = 0;
    private int mDelayedStart = 0;
    private int mDepartureTimeHr = 8;
    private int mDepartureTimeMin = 0;
    private int mRestartDelay = 0;
    private NamedBeanHandle<Sensor> mStartSensor = null;
    private boolean resetStartSensor = true;
    private NamedBeanHandle<Sensor> mRestartSensor = null;
    private boolean resetRestartSensor = true;
    private int mTrainType = 2;
    private boolean terminateWhenFinished = false;
    private boolean mStarted = false;
    int restartHr = 0;
    int restartMin = 0;
    private PropertyChangeListener delaySensorListener = null;
    private PropertyChangeListener restartSensorListener = null;
    private PropertyChangeListener restartAllocationSensorListener = null;
    boolean restartPoint = false;
    private boolean holdAllocation = false;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final Logger log = LoggerFactory.getLogger(ActiveTrain.class);

    public ActiveTrain(Transit t, String name, int trainSource) {
        this.mTransit = t;
        this.mTrainName = name;
        this.mTrainSource = trainSource;
    }

    public boolean getStarted() {
        return this.mStarted;
    }

    public void setStarted() {
        this.mStarted = true;
        this.mStatus = 1;
        this.setStatus(4);
        if (this.mAutoActiveTrain != null && InstanceManager.getDefault(DispatcherFrame.class).getSignalType() == 1) {
            this.mAutoActiveTrain.setupNewCurrentSignal(null, false);
        }
    }

    public Transit getTransit() {
        return this.mTransit;
    }

    public String getTransitName() {
        String s = this.mTransit.getDisplayName();
        return s;
    }

    public String getActiveTrainName() {
        return String.valueOf(this.mTrainName) + " / " + this.getTransitName();
    }

    public String getTrainName() {
        return this.mTrainName;
    }

    public int getTrainSource() {
        return this.mTrainSource;
    }

    public void setRosterEntry(RosterEntry re) {
        this.mRoster = re;
    }

    public RosterEntry getRosterEntry() {
        if (this.mRoster == null && this.getTrainSource() == 1) {
            this.mRoster = Roster.getDefault().getEntryForId(this.getTrainName());
        } else if (this.getTrainSource() != 1) {
            this.mRoster = null;
        }
        return this.mRoster;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public void setStatus(int status) {
        if (this.restartPoint) {
            return;
        }
        if (status == 1 || status == 2 || status == 4 || status == 8 || status == 16 || status == 32 || status == 64) {
            if (this.mStatus != status) {
                int old = this.mStatus;
                this.mStatus = status;
                this.firePropertyChange("status", old, this.mStatus);
            }
            if (this.mStatus == 64 && this.terminateWhenFinished) {
                InstanceManager.getDefault(DispatcherFrame.class).terminateActiveTrain(this);
            }
        } else {
            log.error("Invalid ActiveTrain status - {}", (Object)status);
        }
    }

    public String getStatusText() {
        if (this.mStatus == 1) {
            return Bundle.getMessage("RUNNING");
        }
        if (this.mStatus == 2) {
            return Bundle.getMessage("PAUSED");
        }
        if (this.mStatus == 4) {
            if (!this.mStarted) {
                if (this.mDelayedStart == 1) {
                    return String.valueOf(LogixTableAction.formatTime(this.mDepartureTimeHr, this.mDepartureTimeMin)) + " " + Bundle.getMessage("START");
                }
                if (this.mDelayedStart == 2) {
                    return String.valueOf(Bundle.getMessage("BeanNameSensor")) + " " + this.getDelaySensorName();
                }
            }
            return Bundle.getMessage("WAITING");
        }
        if (this.mStatus == 8) {
            return Bundle.getMessage("WORKING");
        }
        if (this.mStatus == 16) {
            if (this.restartPoint && this.getDelayedRestart() == 1) {
                return String.valueOf(LogixTableAction.formatTime(this.restartHr, this.restartMin)) + " " + Bundle.getMessage("START");
            }
            if (this.restartPoint && this.getDelayedRestart() == 2) {
                return String.valueOf(Bundle.getMessage("BeanNameSensor")) + " " + this.getRestartSensorName();
            }
            return Bundle.getMessage("READY");
        }
        if (this.mStatus == 32) {
            return Bundle.getMessage("STOPPED");
        }
        if (this.mStatus == 64) {
            return Bundle.getMessage("DONE");
        }
        return "";
    }

    public boolean isTransitReversed() {
        return this.mTransitReversed;
    }

    public void setTransitReversed(boolean set) {
        this.mTransitReversed = set;
    }

    public boolean isAllocationReversed() {
        return this.mAllocationReversed;
    }

    public void setAllocationReversed(boolean set) {
        this.mAllocationReversed = set;
    }

    public int getDelayedStart() {
        return this.mDelayedStart;
    }

    public void setDelayedStart(int delay) {
        this.mDelayedStart = delay;
    }

    public int getDelayedRestart() {
        return this.mDelayedRestart;
    }

    public void setDelayedRestart(int delay) {
        this.mDelayedRestart = delay;
    }

    public int getDepartureTimeHr() {
        return this.mDepartureTimeHr;
    }

    public void setDepartureTimeHr(int hr) {
        this.mDepartureTimeHr = hr;
    }

    public int getDepartureTimeMin() {
        return this.mDepartureTimeMin;
    }

    public void setDepartureTimeMin(int min) {
        this.mDepartureTimeMin = min;
    }

    public void setRestartDelay(int min) {
        this.mRestartDelay = min;
    }

    public int getRestartDelay() {
        return this.mRestartDelay;
    }

    public int getRestartDepartHr() {
        return this.restartHr;
    }

    public int getRestartDepartMin() {
        return this.restartMin;
    }

    public void setTerminateWhenDone(boolean boo) {
        this.terminateWhenFinished = boo;
    }

    public Sensor getDelaySensor() {
        if (this.mStartSensor == null) {
            return null;
        }
        return this.mStartSensor.getBean();
    }

    public String getDelaySensorName() {
        if (this.mStartSensor == null) {
            return null;
        }
        return this.mStartSensor.getName();
    }

    public void setDelaySensor(Sensor s) {
        if (s == null) {
            this.mStartSensor = null;
            return;
        }
        this.mStartSensor = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(s.getDisplayName(), s);
    }

    public void setResetStartSensor(boolean b) {
        this.resetStartSensor = b;
    }

    public Sensor getRestartSensor() {
        if (this.mRestartSensor == null) {
            return null;
        }
        return this.mRestartSensor.getBean();
    }

    public String getRestartSensorName() {
        if (this.mRestartSensor == null) {
            return null;
        }
        return this.mRestartSensor.getName();
    }

    public void setRestartSensor(Sensor s) {
        if (s == null) {
            this.mRestartSensor = null;
            return;
        }
        this.mRestartSensor = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(s.getDisplayName(), s);
    }

    public void setResetRestartSensor(boolean b) {
        this.resetRestartSensor = b;
    }

    public void initializeDelaySensor() {
        if (this.mStartSensor == null) {
            log.error("Call to initialise delay on start sensor, but none specified");
            return;
        }
        if (this.delaySensorListener == null) {
            final ActiveTrain at = this;
            this.delaySensorListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("KnownState") && (Integer)e.getNewValue() == 2) {
                        ActiveTrain.this.getDelaySensor().removePropertyChangeListener(ActiveTrain.this.delaySensorListener);
                        InstanceManager.getDefault(DispatcherFrame.class).removeDelayedTrain(at);
                        ActiveTrain.this.setStarted();
                        InstanceManager.getDefault(DispatcherFrame.class).queueScanOfAllocationRequests();
                        if (ActiveTrain.this.resetStartSensor) {
                            try {
                                ActiveTrain.this.getDelaySensor().setKnownState(4);
                                log.debug("Start sensor {} set back to inActive", (Object)ActiveTrain.this.getDelaySensor().getDisplayName(USERSYS));
                            }
                            catch (JmriException jmriException) {
                                log.error("Error resetting start sensor {} back to inActive", (Object)ActiveTrain.this.getDelaySensor().getDisplayName(USERSYS));
                            }
                        }
                    }
                }
            };
        }
        this.getDelaySensor().addPropertyChangeListener(this.delaySensorListener);
    }

    public void initializeRestartSensor() {
        if (this.mRestartSensor == null) {
            log.error("Call to initialise delay on restart sensor, but none specified");
            return;
        }
        if (this.restartSensorListener == null) {
            final ActiveTrain at = this;
            this.restartSensorListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("KnownState") && (Integer)e.getNewValue() == 2) {
                        ActiveTrain.this.getRestartSensor().removePropertyChangeListener(ActiveTrain.this.restartSensorListener);
                        ActiveTrain.this.restartSensorListener = null;
                        InstanceManager.getDefault(DispatcherFrame.class).removeDelayedTrain(at);
                        ActiveTrain.this.restart();
                        InstanceManager.getDefault(DispatcherFrame.class).queueScanOfAllocationRequests();
                        if (ActiveTrain.this.resetRestartSensor) {
                            try {
                                ActiveTrain.this.getRestartSensor().setKnownState(4);
                                log.debug("Restart sensor {} set back to inActive", (Object)ActiveTrain.this.getRestartSensor().getDisplayName(USERSYS));
                            }
                            catch (JmriException jmriException) {
                                log.error("Error resetting restart sensor back to inActive");
                            }
                        }
                    }
                }
            };
        }
        this.getRestartSensor().addPropertyChangeListener(this.restartSensorListener);
    }

    public void initializeRestartAllocationSensor(final NamedBeanHandle<Sensor> restartAllocationSensor) {
        if (restartAllocationSensor == null) {
            log.error("Call to initialise delay on restart allocation sensor, but none specified");
            return;
        }
        if (this.restartAllocationSensorListener == null) {
            this.restartAllocationSensorListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("KnownState") && (Integer)e.getNewValue() == 4) {
                        ((Sensor)restartAllocationSensor.getBean()).removePropertyChangeListener(ActiveTrain.this.restartAllocationSensorListener);
                        ActiveTrain.this.restartAllocationSensorListener = null;
                        InstanceManager.getDefault(DispatcherFrame.class).queueScanOfAllocationRequests();
                    }
                }
            };
        }
        restartAllocationSensor.getBean().addPropertyChangeListener(this.restartAllocationSensorListener);
    }

    public void setTrainType(int type) {
        this.mTrainType = type;
    }

    public void setTrainType(String sType) {
        if (sType.equals(Bundle.getMessage("LOCAL_FREIGHT"))) {
            this.setTrainType(2);
        } else if (sType.equals(Bundle.getMessage("LOCAL_PASSENGER"))) {
            this.setTrainType(1);
        } else if (sType.equals(Bundle.getMessage("THROUGH_FREIGHT"))) {
            this.setTrainType(4);
        } else if (sType.equals(Bundle.getMessage("THROUGH_PASSENGER"))) {
            this.setTrainType(3);
        } else if (sType.equals(Bundle.getMessage("EXPRESS_FREIGHT"))) {
            this.setTrainType(6);
        } else if (sType.equals(Bundle.getMessage("EXPRESS_PASSENGER"))) {
            this.setTrainType(5);
        } else if (sType.equals(Bundle.getMessage("MOW"))) {
            this.setTrainType(7);
        }
    }

    public int getTrainType() {
        return this.mTrainType;
    }

    public String getTrainTypeText() {
        if (this.mTrainType == 2) {
            return Bundle.getMessage("LOCAL_FREIGHT");
        }
        if (this.mTrainType == 1) {
            return Bundle.getMessage("LOCAL_PASSENGER");
        }
        if (this.mTrainType == 4) {
            return Bundle.getMessage("THROUGH_FREIGHT");
        }
        if (this.mTrainType == 3) {
            return Bundle.getMessage("THROUGH_PASSENGER");
        }
        if (this.mTrainType == 6) {
            return Bundle.getMessage("EXPRESS_FREIGHT");
        }
        if (this.mTrainType == 5) {
            return Bundle.getMessage("EXPRESS_PASSENGER");
        }
        if (this.mTrainType == 7) {
            return Bundle.getMessage("MOW");
        }
        return "";
    }

    public int getMode() {
        return this.mMode;
    }

    public void setMode(int mode) {
        if (mode == 2 || mode == 4 || mode == 8) {
            int old = this.mMode;
            this.mMode = mode;
            this.firePropertyChange("mode", old, this.mMode);
        } else {
            log.error("Attempt to set ActiveTrain mode to illegal value - {}", (Object)mode);
        }
    }

    public String getModeText() {
        if (this.mMode == 2) {
            return Bundle.getMessage("AUTOMATIC");
        }
        if (this.mMode == 4) {
            return Bundle.getMessage("MANUAL");
        }
        if (this.mMode == 8) {
            return Bundle.getMessage("DISPATCHED");
        }
        return "";
    }

    public void setAutoActiveTrain(AutoActiveTrain aat) {
        this.mAutoActiveTrain = aat;
    }

    public AutoActiveTrain getAutoActiveTrain() {
        return this.mAutoActiveTrain;
    }

    public int getRunningDirectionFromSectionAndSeq(Section s, int seqNo) {
        int dir = this.mTransit.getDirectionFromSectionAndSeq(s, seqNo);
        if (this.mTransitReversed) {
            dir = dir == 4 ? 8 : 4;
        }
        return dir;
    }

    public int getAllocationDirectionFromSectionAndSeq(Section s, int seqNo) {
        int dir = this.mTransit.getDirectionFromSectionAndSeq(s, seqNo);
        if (this.mAllocationReversed) {
            dir = dir == 4 ? 8 : 4;
        }
        return dir;
    }

    public void addAllocatedSection(AllocatedSection as) {
        if (as != null) {
            this.mAllocatedSections.add(as);
            if (as.getSection() == this.mNextSectionToAllocate) {
                this.mLastAllocatedSection = as.getSection();
                this.mLastAllocatedSectionSeqNumber = this.mNextSectionSeqNumber;
                this.mNextSectionToAllocate = as.getNextSection();
                this.mNextSectionSeqNumber = as.getNextSectionSequence();
                this.mNextSectionDirection = this.getAllocationDirectionFromSectionAndSeq(this.mNextSectionToAllocate, this.mNextSectionSeqNumber);
                as.setAllocationNumber(this.mNextAllocationNumber);
                ++this.mNextAllocationNumber;
            } else {
                as.setAllocationNumber(-1);
            }
            if (this.mStatus == 4 && this.mStarted) {
                this.setStatus(1);
            }
            if (as.getSequence() == 2) {
                this.mSecondAllocatedSection = as.getSection();
            }
            if (InstanceManager.getDefault(DispatcherFrame.class).getNameInAllocatedBlock()) {
                if (InstanceManager.getDefault(DispatcherFrame.class).getRosterEntryInBlock() && this.getRosterEntry() != null) {
                    as.getSection().setNameFromActiveBlock(this.getRosterEntry());
                } else {
                    as.getSection().setNameInBlocks(this.mTrainName);
                }
                as.getSection().suppressNameUpdate(true);
            }
            if (InstanceManager.getDefault(DispatcherFrame.class).getExtraColorForAllocated()) {
                as.getSection().setAlternateColorFromActiveBlock(true);
            }
            this.pcs.firePropertyChange("sectionallocated", as, null);
            this.refreshPanel();
        } else {
            log.error("Null Allocated Section reference in addAllocatedSection of ActiveTrain");
        }
    }

    private void refreshPanel() {
        if (InstanceManager.getDefault(DispatcherFrame.class).getLayoutEditor() != null) {
            InstanceManager.getDefault(DispatcherFrame.class).getLayoutEditor().redrawPanel();
        }
    }

    public void removeAllocatedSection(AllocatedSection as) {
        if (as == null) {
            log.error("Null AllocatedSection reference in removeAllocatedSection of ActiveTrain");
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.mAllocatedSections.size()) {
            if (as == this.mAllocatedSections.get(i)) {
                index = i;
            }
            ++i;
        }
        if (index < 0) {
            log.error("Attempt to remove an unallocated Section {}", (Object)as.getSection().getDisplayName(USERSYS));
            return;
        }
        this.mAllocatedSections.remove(index);
        if (InstanceManager.getDefault(DispatcherFrame.class).getNameInAllocatedBlock()) {
            as.getSection().clearNameInUnoccupiedBlocks();
            as.getSection().suppressNameUpdate(false);
        }
        as.getSection().setAlternateColor(false);
        this.refreshPanel();
        if (as.getSection() == this.mLastAllocatedSection) {
            this.mLastAllocatedSection = null;
            if (this.mAllocatedSections.size() > 0) {
                this.mLastAllocatedSection = this.mAllocatedSections.get(this.mAllocatedSections.size() - 1).getSection();
                this.mLastAllocatedSectionSeqNumber = this.mAllocatedSections.size() - 1;
            }
        }
    }

    public void allocateAFresh() {
        this.setStatus(4);
        this.setTransitReversed(false);
        ArrayList<AllocatedSection> sectionsToRelease = new ArrayList<AllocatedSection>();
        for (AllocatedSection as : InstanceManager.getDefault(DispatcherFrame.class).getAllocatedSectionsList()) {
            if (as.getActiveTrain() != this) continue;
            sectionsToRelease.add(as);
        }
        for (AllocatedSection as : sectionsToRelease) {
            InstanceManager.getDefault(DispatcherFrame.class).releaseAllocatedSection(as, true);
            InstanceManager.getDefault(DispatcherFrame.class).queueWaitForEmpty();
            as.getSection().setState(2);
        }
        if (this.mLastAllocatedSection != null) {
            this.mLastAllocatedSection.setState(2);
        }
        this.resetAllAllocatedSections();
        this.clearAllocations();
        InstanceManager.getDefault(DispatcherFrame.class).queueWaitForEmpty();
        if (this.mAutoRun) {
            this.mAutoActiveTrain.allocateAFresh();
        }
        InstanceManager.getDefault(DispatcherFrame.class).allocateNewActiveTrain(this);
    }

    public void clearAllocations() {
        for (AllocatedSection as : this.getAllocatedSectionList()) {
            this.removeAllocatedSection(as);
        }
    }

    public List<AllocatedSection> getAllocatedSectionList() {
        ArrayList<AllocatedSection> list = new ArrayList<AllocatedSection>();
        int i = 0;
        while (i < this.mAllocatedSections.size()) {
            list.add(this.mAllocatedSections.get(i));
            ++i;
        }
        return list;
    }

    public List<Block> getBlockList() {
        ArrayList<Block> list = new ArrayList<Block>();
        int i = 0;
        while (i < this.mAllocatedSections.size()) {
            Section s = this.mAllocatedSections.get(i).getSection();
            List<Block> bl = s.getBlockList();
            if (bl.size() > 1) {
                Block b;
                int j;
                boolean blocksConnected = true;
                if (i == 0) {
                    if (this.mAllocatedSections.size() > 1 && !this.connected(bl.get(bl.size() - 1), this.mAllocatedSections.get(i + 1).getSection().getBlockList().get(0))) {
                        blocksConnected = false;
                    }
                } else if (!this.connected((Block)list.get(list.size() - 1), bl.get(0))) {
                    blocksConnected = false;
                }
                if (blocksConnected) {
                    j = 0;
                    while (j < bl.size()) {
                        b = bl.get(j);
                        list.add(b);
                        log.trace("block {} ({}) added to list for Section {} (fwd)", new Object[]{b.getDisplayName(USERSYS), b.getState() == 2 ? "OCCUPIED" : "UNOCCUPIED", s.getDisplayName(USERSYS)});
                        ++j;
                    }
                } else {
                    j = bl.size() - 1;
                    while (j >= 0) {
                        b = bl.get(j);
                        list.add(b);
                        log.trace("block {} ({}) added to list for Section {} (rev)", new Object[]{b.getDisplayName(USERSYS), b.getState() == 2 ? "OCCUPIED" : "UNOCCUPIED", s.getDisplayName(USERSYS)});
                        --j;
                    }
                }
            } else {
                Block b = bl.get(0);
                list.add(b);
                log.trace("block {} ({}) added to list for Section {} (one)", new Object[]{b.getDisplayName(USERSYS), b.getState() == 2 ? "OCCUPIED" : "UNOCCUPIED", s.getDisplayName(USERSYS)});
            }
            ++i;
        }
        return list;
    }

    private boolean connected(Block b1, Block b2) {
        if (b1 != null && b2 != null) {
            List<Path> paths = b1.getPaths();
            int i = 0;
            while (i < paths.size()) {
                if (paths.get(i).getBlock() == b2) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Section getLastAllocatedSection() {
        return this.mLastAllocatedSection;
    }

    public int getLastAllocatedSectionSeqNumber() {
        return this.mLastAllocatedSectionSeqNumber;
    }

    public String getLastAllocatedSectionName() {
        if (this.mLastAllocatedSection == null) {
            return "<" + Bundle.getMessage("None").toLowerCase() + ">";
        }
        return this.getSectionName(this.mLastAllocatedSection);
    }

    public Section getNextSectionToAllocate() {
        return this.mNextSectionToAllocate;
    }

    public int getNextSectionSeqNumber() {
        return this.mNextSectionSeqNumber;
    }

    public String getNextSectionToAllocateName() {
        if (this.mNextSectionToAllocate == null) {
            return "<" + Bundle.getMessage("None").toLowerCase() + ">";
        }
        return this.getSectionName(this.mNextSectionToAllocate);
    }

    private String getSectionName(Section sc) {
        String s = sc.getDisplayName();
        return s;
    }

    public Block getStartBlock() {
        return this.mStartBlock;
    }

    public void setStartBlock(Block sBlock) {
        this.mStartBlock = sBlock;
    }

    public int getStartBlockSectionSequenceNumber() {
        return this.mStartBlockSectionSequenceNumber;
    }

    public void setStartBlockSectionSequenceNumber(int sBlockSeqNum) {
        this.mStartBlockSectionSequenceNumber = sBlockSeqNum;
    }

    public Block getEndBlock() {
        return this.mEndBlock;
    }

    public void setEndBlock(Block eBlock) {
        this.mEndBlock = eBlock;
    }

    public Section getEndBlockSection() {
        return this.mEndBlockSection;
    }

    public void setEndBlockSection(Section eSection) {
        this.mEndBlockSection = eSection;
    }

    public int getEndBlockSectionSequenceNumber() {
        return this.mEndBlockSectionSequenceNumber;
    }

    public void setEndBlockSectionSequenceNumber(int eBlockSeqNum) {
        this.mEndBlockSectionSequenceNumber = eBlockSeqNum;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public void setPriority(int priority) {
        this.mPriority = priority;
    }

    public boolean getAutoRun() {
        return this.mAutoRun;
    }

    public void setAutoRun(boolean autoRun) {
        this.mAutoRun = autoRun;
    }

    public String getDccAddress() {
        return this.mDccAddress;
    }

    public void setDccAddress(String dccAddress) {
        this.mDccAddress = dccAddress;
    }

    public boolean getResetWhenDone() {
        return this.mResetWhenDone;
    }

    public void setResetWhenDone(boolean s) {
        this.mResetWhenDone = s;
    }

    public boolean getReverseAtEnd() {
        return this.mReverseAtEnd;
    }

    public void setReverseAtEnd(boolean s) {
        this.mReverseAtEnd = s;
    }

    protected Section getSecondAllocatedSection() {
        return this.mSecondAllocatedSection;
    }

    public int getAllocateMethod() {
        return this.mAllocateMethod;
    }

    public void setAllocateMethod(int i) {
        this.mAllocateMethod = i;
    }

    public AllocationRequest initializeFirstAllocation() {
        if (this.mAllocatedSections.size() > 0) {
            log.error("ERROR - Request to initialize first allocation, when allocations already present");
            return null;
        }
        if (this.mStartBlockSectionSequenceNumber > 0 && this.mStartBlock != null) {
            this.mNextSectionToAllocate = this.mTransit.getSectionFromBlockAndSeq(this.mStartBlock, this.mStartBlockSectionSequenceNumber);
            if (this.mNextSectionToAllocate == null) {
                this.mNextSectionToAllocate = this.mTransit.getSectionFromConnectedBlockAndSeq(this.mStartBlock, this.mStartBlockSectionSequenceNumber);
                if (this.mNextSectionToAllocate == null) {
                    log.error("ERROR - Cannot find Section for first allocation of ActiveTrain{}", (Object)this.getActiveTrainName());
                    return null;
                }
            }
        } else {
            log.error("ERROR - Insufficient information to initialize first allocation");
            return null;
        }
        this.mNextSectionSeqNumber = this.mStartBlockSectionSequenceNumber;
        this.mNextSectionDirection = this.getAllocationDirectionFromSectionAndSeq(this.mNextSectionToAllocate, this.mNextSectionSeqNumber);
        if (!InstanceManager.getDefault(DispatcherFrame.class).requestAllocation(this, this.mNextSectionToAllocate, this.mNextSectionDirection, this.mNextSectionSeqNumber, true, null, true)) {
            log.error("Allocation request failed for first allocation of {}", (Object)this.getActiveTrainName());
        }
        if (InstanceManager.getDefault(DispatcherFrame.class).getRosterEntryInBlock() && this.getRosterEntry() != null) {
            this.mStartBlock.setValue(this.getRosterEntry());
        } else if (InstanceManager.getDefault(DispatcherFrame.class).getShortNameInBlock()) {
            this.mStartBlock.setValue(this.mTrainName);
        }
        AllocationRequest ar = InstanceManager.getDefault(DispatcherFrame.class).findAllocationRequestInQueue(this.mNextSectionToAllocate, this.mNextSectionSeqNumber, this.mNextSectionDirection, this);
        return ar;
    }

    protected boolean addEndSection(Section s, int seq) {
        AllocatedSection as = this.mAllocatedSections.get(this.mAllocatedSections.size() - 1);
        if (!as.setNextSection(s, seq)) {
            return false;
        }
        this.setEndBlockSection(s);
        this.setEndBlockSectionSequenceNumber(seq);
        this.setEndBlock(s.getExitBlock());
        this.mNextSectionSeqNumber = seq;
        this.mNextSectionToAllocate = s;
        return true;
    }

    protected void removeLastAllocatedSection() {
        AllocatedSection as = this.mAllocatedSections.get(this.mAllocatedSections.size() - 1);
        this.setEndBlock(as.getExitBlock());
        as.setNextSection(null, 0);
        this.setEndBlockSection(as.getSection());
        this.setEndBlockSectionSequenceNumber(this.getEndBlockSectionSequenceNumber() - 1);
        this.mNextSectionSeqNumber = 0;
        this.mNextSectionToAllocate = null;
    }

    protected AllocatedSection reverseAllAllocatedSections() {
        AllocatedSection aSec = null;
        int i = 0;
        while (i < this.mAllocatedSections.size()) {
            aSec = this.mAllocatedSections.get(i);
            int dir = this.mTransit.getDirectionFromSectionAndSeq(aSec.getSection(), aSec.getSequence());
            if (dir == 4) {
                aSec.getSection().setState(8);
            } else {
                aSec.getSection().setState(4);
            }
            aSec.setStoppingSensors();
            ++i;
        }
        return aSec;
    }

    protected void resetAllAllocatedSections() {
        int i = 0;
        while (i < this.mAllocatedSections.size()) {
            AllocatedSection aSec = this.mAllocatedSections.get(i);
            int dir = this.mTransit.getDirectionFromSectionAndSeq(aSec.getSection(), aSec.getSequence());
            aSec.getSection().setState(dir);
            aSec.setStoppingSensors();
            ++i;
        }
    }

    protected void setRestart() {
        if (this.getDelayedRestart() == 0) {
            return;
        }
        this.setStatus(16);
        this.restartPoint = true;
        if (this.getDelayedRestart() == 1) {
            Date now = InstanceManager.getDefault(Timebase.class).getTime();
            int nowHours = now.getHours();
            int nowMinutes = now.getMinutes();
            int hours = this.getRestartDelay() / 60;
            int minutes = this.getRestartDelay() % 60;
            this.restartHr = nowHours + hours + (nowMinutes + minutes) / 60;
            this.restartMin = (nowMinutes + minutes) % 60;
            if (this.restartHr > 23) {
                this.restartHr -= 24;
            }
        }
        InstanceManager.getDefault(DispatcherFrame.class).addDelayedTrain(this);
    }

    protected boolean isInAllocatedList(AllocatedSection as) {
        int i = 0;
        while (i < this.mAllocatedSections.size()) {
            if (this.mAllocatedSections.get(i) == as) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isInAllocatedList(Section s) {
        int i = 0;
        while (i < this.mAllocatedSections.size()) {
            if (this.mAllocatedSections.get(i).getSection() == s) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void holdAllocation(boolean boo) {
        this.holdAllocation = boo;
    }

    protected boolean holdAllocation() {
        return this.holdAllocation;
    }

    protected boolean reachedRestartPoint() {
        return this.restartPoint;
    }

    protected void restart() {
        log.debug("{}: restarting", (Object)this.getTrainName());
        this.restartPoint = false;
        this.holdAllocation = false;
        this.setStatus(4);
        if (this.mAutoActiveTrain != null) {
            this.mAutoActiveTrain.setupNewCurrentSignal(null, true);
        }
    }

    public void terminate() {
        InstanceManager.getDefault(DispatcherFrame.class).removeDelayedTrain(this);
        if (this.getDelaySensor() != null && this.delaySensorListener != null) {
            this.getDelaySensor().removePropertyChangeListener(this.delaySensorListener);
        }
        if (this.getRestartSensor() != null && this.restartSensorListener != null) {
            this.getRestartSensor().removePropertyChangeListener(this.restartSensorListener);
        }
        this.mTransit.setState(2);
    }

    public void dispose() {
        this.getTransit().removeTemporarySections();
    }

    @OverridingMethodsMustInvokeSuper
    protected void firePropertyChange(String p, Object old, Object n) {
        this.pcs.firePropertyChange(p, old, n);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }
}

