/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.Block;
import jmri.InstanceManager;
import jmri.Sensor;
import jmri.Transit;
import jmri.TransitManager;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.AutoActiveTrain;
import jmri.jmrit.dispatcher.Bundle;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.jmrit.dispatcher.TrainInfo;
import jmri.jmrit.dispatcher.TrainInfoFile;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.RosterEntryComboBox;
import jmri.swing.NamedBeanComboBox;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import jmri.util.swing.JComboBoxUtil;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivateTrainFrame
extends JmriJFrame {
    private DispatcherFrame _dispatcher = null;
    private TrainInfoFile _tiFile = null;
    private DispatcherFrame.TrainsFrom _TrainsFrom;
    private List<ActiveTrain> _ActiveTrainsList = null;
    private final TransitManager _TransitManager = InstanceManager.getDefault(TransitManager.class);
    private String _trainInfoName = "";
    private Transit selectedTransit = null;
    private JmriJFrame initiateFrame = null;
    private Container initiatePane = null;
    private final NamedBeanComboBox<Transit> transitSelectBox = new NamedBeanComboBox<Transit>(this._TransitManager);
    private final JLabel trainBoxLabel = new JLabel("     " + Bundle.getMessage("TrainBoxLabel") + ":");
    private final JComboBox<Object> trainSelectBox = new JComboBox();
    private RosterEntryComboBox rosterComboBox = null;
    private final JLabel trainFieldLabel = new JLabel(String.valueOf(Bundle.getMessage("TrainBoxLabel")) + ":");
    private final JTextField trainNameField = new JTextField(10);
    private final JLabel dccAddressFieldLabel = new JLabel("     " + Bundle.getMessage("DccAddressFieldLabel") + ":");
    private final JSpinner dccAddressSpinner = new JSpinner(new SpinnerNumberModel(3, 1, 9999, 1));
    private final JCheckBox inTransitBox = new JCheckBox(Bundle.getMessage("TrainInTransit"));
    private final JComboBox<String> startingBlockBox = new JComboBox();
    private List<Block> startingBlockBoxList = new ArrayList<Block>();
    private List<Integer> startingBlockSeqList = new ArrayList<Integer>();
    private final JComboBox<String> destinationBlockBox = new JComboBox();
    private List<Block> destinationBlockBoxList = new ArrayList<Block>();
    private List<Integer> destinationBlockSeqList = new ArrayList<Integer>();
    private JButton addNewTrainButton = null;
    private JButton loadButton = null;
    private JButton saveButton = null;
    private JButton deleteButton = null;
    private final JCheckBox autoRunBox = new JCheckBox(Bundle.getMessage("AutoRun"));
    private final JCheckBox loadAtStartupBox = new JCheckBox(Bundle.getMessage("LoadAtStartup"));
    private final JRadioButton radioTrainsFromRoster = new JRadioButton(Bundle.getMessage("TrainsFromRoster"));
    private final JRadioButton radioTrainsFromOps = new JRadioButton(Bundle.getMessage("TrainsFromTrains"));
    private final JRadioButton radioTrainsFromUser = new JRadioButton(Bundle.getMessage("TrainsFromUser"));
    private final ButtonGroup trainsFromButtonGroup = new ButtonGroup();
    private final JRadioButton allocateBySafeRadioButton = new JRadioButton(Bundle.getMessage("ToSafeSections"));
    private final JRadioButton allocateAllTheWayRadioButton = new JRadioButton(Bundle.getMessage("AsFarAsPos"));
    private final JRadioButton allocateNumberOfBlocks = new JRadioButton(String.valueOf(Bundle.getMessage("NumberOfBlocks")) + ":");
    private final ButtonGroup allocateMethodButtonGroup = new ButtonGroup();
    private final JSpinner allocateCustomSpinner = new JSpinner(new SpinnerNumberModel(3, 1, 100, 1));
    private final JCheckBox terminateWhenDoneBox = new JCheckBox(Bundle.getMessage("TerminateWhenDone"));
    private final JSpinner prioritySpinner = new JSpinner(new SpinnerNumberModel(5, 0, 100, 1));
    private final JCheckBox resetWhenDoneBox = new JCheckBox(Bundle.getMessage("ResetWhenDone"));
    private final JCheckBox reverseAtEndBox = new JCheckBox(Bundle.getMessage("ReverseAtEnd"));
    int[] delayedStartInt;
    String[] delayedStartString;
    private final JCheckBox resetStartSensorBox;
    private final JComboBox<String> delayedStartBox;
    private final JLabel delayedReStartLabel;
    private final JLabel delayReStartSensorLabel;
    private final JCheckBox resetRestartSensorBox;
    private final JComboBox<String> delayedReStartBox;
    private final NamedBeanComboBox<Sensor> delaySensor;
    private final NamedBeanComboBox<Sensor> delayReStartSensor;
    private final JSpinner departureHrSpinner;
    private final JSpinner departureMinSpinner;
    private final JLabel departureTimeLabel;
    private final JLabel departureSepLabel;
    private final JSpinner delayMinSpinner;
    private final JLabel delayMinLabel;
    private final JComboBox<String> trainTypeBox;
    boolean transitsFromSpecificBlock;
    private final JPanel pa1;
    private final JLabel speedFactorLabel;
    private final JSpinner speedFactorSpinner;
    private final JLabel maxSpeedLabel;
    private final JSpinner maxSpeedSpinner;
    private final JPanel pa2;
    private final JLabel rampRateLabel;
    private final JComboBox<String> rampRateBox;
    private final JPanel pa2a;
    private final JLabel useSpeedProfileLabel;
    private final JCheckBox useSpeedProfileCheckBox;
    private final JLabel stopBySpeedProfileLabel;
    private final JCheckBox stopBySpeedProfileCheckBox;
    private final JLabel stopBySpeedProfileAdjustLabel;
    private final JSpinner stopBySpeedProfileAdjustSpinner;
    private final JPanel pa3;
    private final JCheckBox soundDecoderBox;
    private final JCheckBox runInReverseBox;
    private final JPanel pa4;
    private final JCheckBox resistanceWheelsBox;
    private final JLabel trainLengthLabel;
    private final JSpinner maxTrainLengthSpinner;
    float _speedFactor;
    float _maxSpeed;
    int _rampRate;
    boolean _resistanceWheels;
    boolean _runInReverse;
    boolean _soundDecoder;
    float _maxTrainLength;
    boolean _stopBySpeedProfile;
    float _stopBySpeedProfileAdjust;
    boolean _useSpeedProfile;
    private static final Logger log = LoggerFactory.getLogger(ActivateTrainFrame.class);

    public ActivateTrainFrame(DispatcherFrame d) {
        super(true, true);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.delayedStartInt = nArray;
        this.delayedStartString = new String[]{Bundle.getMessage("DelayedStartNone"), Bundle.getMessage("DelayedStartTimed"), Bundle.getMessage("DelayedStartSensor")};
        this.resetStartSensorBox = new JCheckBox(Bundle.getMessage("ResetStartSensor"));
        this.delayedStartBox = new JComboBox<String>(this.delayedStartString);
        this.delayedReStartLabel = new JLabel(Bundle.getMessage("DelayRestart"));
        this.delayReStartSensorLabel = new JLabel(Bundle.getMessage("RestartSensor"));
        this.resetRestartSensorBox = new JCheckBox(Bundle.getMessage("ResetRestartSensor"));
        this.delayedReStartBox = new JComboBox<String>(this.delayedStartString);
        this.delaySensor = new NamedBeanComboBox<Sensor>(InstanceManager.sensorManagerInstance());
        this.delayReStartSensor = new NamedBeanComboBox<Sensor>(InstanceManager.sensorManagerInstance());
        this.departureHrSpinner = new JSpinner(new SpinnerNumberModel(8, 0, 23, 1));
        this.departureMinSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        this.departureTimeLabel = new JLabel(Bundle.getMessage("DepartureTime"));
        this.departureSepLabel = new JLabel(":");
        this.delayMinSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 1000, 1));
        this.delayMinLabel = new JLabel(Bundle.getMessage("RestartTimed"));
        this.trainTypeBox = new JComboBox();
        this.transitsFromSpecificBlock = false;
        this.pa1 = new JPanel();
        this.speedFactorLabel = new JLabel(Bundle.getMessage("SpeedFactorLabel"));
        this.speedFactorSpinner = new JSpinner();
        this.maxSpeedLabel = new JLabel(Bundle.getMessage("MaxSpeedLabel"));
        this.maxSpeedSpinner = new JSpinner();
        this.pa2 = new JPanel();
        this.rampRateLabel = new JLabel(Bundle.getMessage("RampRateBoxLabel"));
        this.rampRateBox = new JComboBox();
        this.pa2a = new JPanel();
        this.useSpeedProfileLabel = new JLabel(Bundle.getMessage("UseSpeedProfileLabel"));
        this.useSpeedProfileCheckBox = new JCheckBox();
        this.stopBySpeedProfileLabel = new JLabel(Bundle.getMessage("StopBySpeedProfileLabel"));
        this.stopBySpeedProfileCheckBox = new JCheckBox();
        this.stopBySpeedProfileAdjustLabel = new JLabel(Bundle.getMessage("StopBySpeedProfileAdjustLabel"));
        this.stopBySpeedProfileAdjustSpinner = new JSpinner();
        this.pa3 = new JPanel();
        this.soundDecoderBox = new JCheckBox(Bundle.getMessage("SoundDecoder"));
        this.runInReverseBox = new JCheckBox(Bundle.getMessage("RunInReverse"));
        this.pa4 = new JPanel();
        this.resistanceWheelsBox = new JCheckBox(Bundle.getMessage("ResistanceWheels"));
        this.trainLengthLabel = new JLabel(Bundle.getMessage("MaxTrainLengthLabel"));
        this.maxTrainLengthSpinner = new JSpinner();
        this._speedFactor = 1.0f;
        this._maxSpeed = 0.6f;
        this._rampRate = 0;
        this._resistanceWheels = true;
        this._runInReverse = false;
        this._soundDecoder = false;
        this._maxTrainLength = 200.0f;
        this._stopBySpeedProfile = false;
        this._stopBySpeedProfileAdjust = 1.0f;
        this._useSpeedProfile = true;
        this._dispatcher = d;
        this._tiFile = new TrainInfoFile();
    }

    public void initiateTrain(ActionEvent e, RosterEntry re, Block b) {
        this.initiateTrain(e);
        if (this._TrainsFrom == DispatcherFrame.TrainsFrom.TRAINSFROMROSTER && re != null) {
            this.setRosterComboBox(this.rosterComboBox, re.getId());
        }
        if (b != null && this.selectedTransit != null) {
            ArrayList<Transit> transitList = this._TransitManager.getListUsingBlock(b);
            ArrayList<Transit> transitEntryList = this._TransitManager.getListEntryBlock(b);
            for (Transit t : transitEntryList) {
                if (transitList.contains(t)) continue;
                transitList.add(t);
            }
            this.transitsFromSpecificBlock = true;
            this.initializeFreeTransitsCombo(transitList);
            ArrayList<Object> tmpBlkList = new ArrayList();
            if (this.selectedTransit.getEntryBlocksList().contains(b)) {
                tmpBlkList = this.selectedTransit.getEntryBlocksList();
                this.inTransitBox.setSelected(false);
            } else if (this.selectedTransit.containsBlock(b)) {
                tmpBlkList = this.selectedTransit.getInternalBlocksList();
                this.inTransitBox.setSelected(true);
            }
            ArrayList<Integer> tmpSeqList = this.selectedTransit.getBlockSeqList();
            int i = 0;
            while (i < tmpBlkList.size()) {
                if (tmpBlkList.get(i) == b) {
                    this.setComboBox(this.startingBlockBox, String.valueOf(this.getBlockName(b)) + "-" + tmpSeqList.get(i));
                    break;
                }
                ++i;
            }
        }
    }

    protected void initiateTrain(ActionEvent e) {
        this._TrainsFrom = this._dispatcher.getTrainsFrom();
        this._ActiveTrainsList = this._dispatcher.getActiveTrainsList();
        if (this.initiateFrame == null) {
            this.initiateFrame = this;
            this.initiateFrame.setTitle(Bundle.getMessage("AddTrainTitle"));
            this.initiateFrame.addHelpMenu("package.jmri.jmrit.dispatcher.NewTrain", true);
            this.initiatePane = this.initiateFrame.getContentPane();
            this.initiatePane.setLayout(new BoxLayout(this.initiatePane, 1));
            JPanel p0 = new JPanel();
            p0.setLayout(new FlowLayout());
            this.loadButton = new JButton(Bundle.getMessage("LoadButton"));
            p0.add(this.loadButton);
            this.loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivateTrainFrame.this.loadTrainInfo(e);
                }
            });
            this.loadButton.setToolTipText(Bundle.getMessage("LoadButtonHint"));
            this.saveButton = new JButton(Bundle.getMessage("SaveButton"));
            p0.add(this.saveButton);
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivateTrainFrame.this.saveTrainInfo(e);
                }
            });
            this.saveButton.setToolTipText(Bundle.getMessage("SaveButtonHint"));
            this.deleteButton = new JButton(Bundle.getMessage("DeleteButton"));
            p0.add(this.deleteButton);
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivateTrainFrame.this.deleteTrainInfo(e);
                }
            });
            this.deleteButton.setToolTipText(Bundle.getMessage("DeleteButtonHint"));
            JPanel p0a = new JPanel();
            p0a.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrainsFrom")));
            p0a.setLayout(new FlowLayout());
            this.trainsFromButtonGroup.add(this.radioTrainsFromRoster);
            this.trainsFromButtonGroup.add(this.radioTrainsFromOps);
            this.trainsFromButtonGroup.add(this.radioTrainsFromUser);
            p0a.add(this.radioTrainsFromRoster);
            this.radioTrainsFromRoster.setToolTipText(Bundle.getMessage("TrainsFromRosterHint"));
            p0a.add(this.radioTrainsFromOps);
            this.radioTrainsFromOps.setToolTipText(Bundle.getMessage("TrainsFromTrainsHint"));
            p0a.add(this.radioTrainsFromUser);
            this.radioTrainsFromUser.setToolTipText(Bundle.getMessage("TrainsFromUserHint"));
            this.radioTrainsFromOps.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ActivateTrainFrame.this._TrainsFrom = DispatcherFrame.TrainsFrom.TRAINSFROMOPS;
                        ActivateTrainFrame.this.setTrainsFromOptions(ActivateTrainFrame.this._TrainsFrom);
                    }
                }
            });
            this.radioTrainsFromRoster.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ActivateTrainFrame.this._TrainsFrom = DispatcherFrame.TrainsFrom.TRAINSFROMROSTER;
                        ActivateTrainFrame.this.setTrainsFromOptions(ActivateTrainFrame.this._TrainsFrom);
                    }
                }
            });
            this.radioTrainsFromUser.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ActivateTrainFrame.this._TrainsFrom = DispatcherFrame.TrainsFrom.TRAINSFROMUSER;
                        ActivateTrainFrame.this.setTrainsFromOptions(ActivateTrainFrame.this._TrainsFrom);
                    }
                }
            });
            p0a.add(this.allocateCustomSpinner);
            this.initiatePane.add(p0a);
            JPanel p1 = new JPanel();
            p1.setLayout(new FlowLayout());
            p1.add(new JLabel(String.valueOf(Bundle.getMessage("TransitBoxLabel")) + " :"));
            p1.add(this.transitSelectBox);
            this.transitSelectBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivateTrainFrame.this.handleTransitSelectionChanged(e);
                }
            });
            this.transitSelectBox.setToolTipText(Bundle.getMessage("TransitBoxHint"));
            p1.add(this.trainBoxLabel);
            p1.add(this.trainSelectBox);
            this.trainSelectBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivateTrainFrame.this.handleTrainSelectionChanged();
                }
            });
            this.trainSelectBox.setToolTipText(Bundle.getMessage("TrainBoxHint"));
            this.rosterComboBox = new RosterEntryComboBox();
            this.initializeFreeRosterEntriesCombo();
            this.rosterComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivateTrainFrame.this.handleRosterSelectionChanged(e);
                }
            });
            p1.add(this.rosterComboBox);
            this.initiatePane.add(p1);
            JPanel p1a = new JPanel();
            p1a.setLayout(new FlowLayout());
            p1a.add(this.trainFieldLabel);
            p1a.add(this.trainNameField);
            this.trainNameField.setToolTipText(Bundle.getMessage("TrainFieldHint"));
            p1a.add(this.dccAddressFieldLabel);
            p1a.add(this.dccAddressSpinner);
            this.dccAddressSpinner.setToolTipText(Bundle.getMessage("DccAddressFieldHint"));
            this.initiatePane.add(p1a);
            JPanel p2 = new JPanel();
            p2.setLayout(new FlowLayout());
            p2.add(this.inTransitBox);
            this.inTransitBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivateTrainFrame.this.handleInTransitClick(e);
                }
            });
            this.inTransitBox.setToolTipText(Bundle.getMessage("InTransitBoxHint"));
            this.initiatePane.add(p2);
            JPanel p3 = new JPanel();
            p3.setLayout(new FlowLayout());
            p3.add(new JLabel(String.valueOf(Bundle.getMessage("StartingBlockBoxLabel")) + " :"));
            p3.add(this.startingBlockBox);
            this.startingBlockBox.setToolTipText(Bundle.getMessage("StartingBlockBoxHint"));
            this.startingBlockBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivateTrainFrame.this.handleStartingBlockSelectionChanged(e);
                }
            });
            this.initiatePane.add(p3);
            JPanel p4 = new JPanel();
            p4.setLayout(new FlowLayout());
            p4.add(new JLabel(String.valueOf(Bundle.getMessage("DestinationBlockBoxLabel")) + ":"));
            p4.add(this.destinationBlockBox);
            this.destinationBlockBox.setToolTipText(Bundle.getMessage("DestinationBlockBoxHint"));
            this.initiatePane.add(p4);
            JPanel p4b = new JPanel();
            p4b.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("AllocateMethodLabel")));
            p4b.setLayout(new FlowLayout());
            this.allocateMethodButtonGroup.add(this.allocateAllTheWayRadioButton);
            this.allocateMethodButtonGroup.add(this.allocateBySafeRadioButton);
            this.allocateMethodButtonGroup.add(this.allocateNumberOfBlocks);
            p4b.add(this.allocateAllTheWayRadioButton);
            this.allocateAllTheWayRadioButton.setToolTipText(Bundle.getMessage("AllocateAllTheWayHint"));
            p4b.add(this.allocateBySafeRadioButton);
            this.allocateBySafeRadioButton.setToolTipText(Bundle.getMessage("AllocateSafeHint"));
            p4b.add(this.allocateNumberOfBlocks);
            this.allocateNumberOfBlocks.setToolTipText(Bundle.getMessage("AllocateMethodHint"));
            this.allocateAllTheWayRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivateTrainFrame.this.handleAllocateAllTheWayButtonChanged(e);
                }
            });
            this.allocateBySafeRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivateTrainFrame.this.handleAllocateBySafeButtonChanged(e);
                }
            });
            this.allocateNumberOfBlocks.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivateTrainFrame.this.handleAllocateNumberOfBlocksButtonChanged(e);
                }
            });
            p4b.add(this.allocateCustomSpinner);
            this.allocateCustomSpinner.setToolTipText(Bundle.getMessage("AllocateMethodHint"));
            this.initiatePane.add(p4b);
            JPanel p6 = new JPanel();
            p6.setLayout(new FlowLayout());
            p6.add(this.resetWhenDoneBox);
            this.resetWhenDoneBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivateTrainFrame.this.handleResetWhenDoneClick(e);
                }
            });
            this.resetWhenDoneBox.setToolTipText(Bundle.getMessage("ResetWhenDoneBoxHint"));
            this.initiatePane.add(p6);
            JPanel p6a = new JPanel();
            p6a.setLayout(new FlowLayout());
            ((FlowLayout)p6a.getLayout()).setVgap(1);
            p6a.add(this.delayedReStartLabel);
            p6a.add(this.delayedReStartBox);
            p6a.add(this.resetRestartSensorBox);
            this.resetRestartSensorBox.setToolTipText(Bundle.getMessage("ResetRestartSensorHint"));
            this.resetRestartSensorBox.setSelected(true);
            this.delayedReStartBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivateTrainFrame.this.handleResetWhenDoneClick(e);
                }
            });
            this.delayedReStartBox.setToolTipText(Bundle.getMessage("DelayedReStartHint"));
            this.initiatePane.add(p6a);
            JPanel p6b = new JPanel();
            p6b.setLayout(new FlowLayout());
            ((FlowLayout)p6b.getLayout()).setVgap(1);
            p6b.add(this.delayMinLabel);
            p6b.add(this.delayMinSpinner);
            this.delayMinSpinner.setToolTipText(Bundle.getMessage("RestartTimedHint"));
            p6b.add(this.delayReStartSensorLabel);
            p6b.add(this.delayReStartSensor);
            this.delayReStartSensor.setAllowNull(true);
            this.handleResetWhenDoneClick(null);
            this.initiatePane.add(p6b);
            JPanel p10 = new JPanel();
            p10.setLayout(new FlowLayout());
            p10.add(this.reverseAtEndBox);
            this.reverseAtEndBox.setToolTipText(Bundle.getMessage("ReverseAtEndBoxHint"));
            this.initiatePane.add(p10);
            this.reverseAtEndBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivateTrainFrame.this.handleReverseAtEndBoxClick(e);
                }
            });
            JPanel p10a = new JPanel();
            p10a.setLayout(new FlowLayout());
            p10a.add(this.terminateWhenDoneBox);
            this.initiatePane.add(p10a);
            JPanel p8 = new JPanel();
            p8.setLayout(new FlowLayout());
            p8.add(new JLabel(String.valueOf(Bundle.getMessage("PriorityLabel")) + ":"));
            p8.add(this.prioritySpinner);
            this.prioritySpinner.setToolTipText(Bundle.getMessage("PriorityHint"));
            p8.add(new JLabel("     "));
            p8.add(new JLabel(Bundle.getMessage("TrainTypeBoxLabel")));
            this.initializeTrainTypeBox();
            p8.add(this.trainTypeBox);
            this.trainTypeBox.setSelectedIndex(1);
            this.trainTypeBox.setToolTipText(Bundle.getMessage("TrainTypeBoxHint"));
            this.initiatePane.add(p8);
            JPanel p9 = new JPanel();
            p9.setLayout(new FlowLayout());
            p9.add(new JLabel(Bundle.getMessage("DelayedStart")));
            p9.add(this.delayedStartBox);
            this.delayedStartBox.setToolTipText(Bundle.getMessage("DelayedStartHint"));
            this.delayedStartBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivateTrainFrame.this.handleDelayStartClick(e);
                }
            });
            p9.add(this.departureTimeLabel);
            this.departureHrSpinner.setEditor(new JSpinner.NumberEditor(this.departureHrSpinner, "00"));
            p9.add(this.departureHrSpinner);
            this.departureHrSpinner.setValue(8);
            this.departureHrSpinner.setToolTipText(Bundle.getMessage("DepartureTimeHrHint"));
            p9.add(this.departureSepLabel);
            this.departureMinSpinner.setEditor(new JSpinner.NumberEditor(this.departureMinSpinner, "00"));
            p9.add(this.departureMinSpinner);
            this.departureMinSpinner.setValue(0);
            this.departureMinSpinner.setToolTipText(Bundle.getMessage("DepartureTimeMinHint"));
            p9.add(this.delaySensor);
            this.delaySensor.setAllowNull(true);
            p9.add(this.resetStartSensorBox);
            this.resetStartSensorBox.setToolTipText(Bundle.getMessage("ResetStartSensorHint"));
            this.resetStartSensorBox.setSelected(true);
            this.handleDelayStartClick(null);
            this.initiatePane.add(p9);
            JPanel p11 = new JPanel();
            p11.setLayout(new FlowLayout());
            p11.add(this.loadAtStartupBox);
            this.loadAtStartupBox.setToolTipText(Bundle.getMessage("LoadAtStartupBoxHint"));
            this.loadAtStartupBox.setSelected(false);
            this.initiatePane.add(p11);
            this.initiatePane.add(new JSeparator());
            JPanel p5 = new JPanel();
            p5.setLayout(new FlowLayout());
            p5.add(this.autoRunBox);
            this.autoRunBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivateTrainFrame.this.handleAutoRunClick(e);
                }
            });
            this.autoRunBox.setToolTipText(Bundle.getMessage("AutoRunBoxHint"));
            this.autoRunBox.setSelected(false);
            this.initiatePane.add(p5);
            this.initializeAutoRunItems();
            JPanel p7 = new JPanel();
            p7.setLayout(new FlowLayout());
            JButton cancelButton = null;
            cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
            p7.add(cancelButton);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivateTrainFrame.this.cancelInitiateTrain(e);
                }
            });
            cancelButton.setToolTipText(Bundle.getMessage("CancelButtonHint"));
            this.addNewTrainButton = new JButton(Bundle.getMessage("ButtonCreate"));
            p7.add(this.addNewTrainButton);
            this.addNewTrainButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivateTrainFrame.this.addNewTrain(e);
                }
            });
            this.addNewTrainButton.setToolTipText(Bundle.getMessage("AddNewTrainButtonHint"));
            JPanel mainPane = new JPanel();
            mainPane.setLayout(new BoxLayout(mainPane, 1));
            JScrollPane scrPane = new JScrollPane(this.initiatePane);
            mainPane.add(p0);
            mainPane.add(scrPane);
            mainPane.add(p7);
            this.initiateFrame.setContentPane(mainPane);
            switch (this._TrainsFrom) {
                case TRAINSFROMROSTER: {
                    this.radioTrainsFromRoster.setSelected(true);
                    break;
                }
                case TRAINSFROMOPS: {
                    this.radioTrainsFromOps.setSelected(true);
                    break;
                }
                default: {
                    this.radioTrainsFromUser.setSelected(true);
                }
            }
        }
        this.setAutoRunDefaults();
        this.autoRunBox.setSelected(false);
        this.loadAtStartupBox.setSelected(false);
        this.initializeFreeTransitsCombo(new ArrayList<Transit>());
        this.setTrainsFromOptions(this._TrainsFrom);
        this.initiateFrame.pack();
        this.initiateFrame.setVisible(true);
    }

    private void setTrainsFromOptions(DispatcherFrame.TrainsFrom transFrom) {
        switch (transFrom) {
            case TRAINSFROMROSTER: {
                this.initializeFreeRosterEntriesCombo();
                this.trainBoxLabel.setVisible(true);
                this.rosterComboBox.setVisible(true);
                this.trainSelectBox.setVisible(false);
                this.trainFieldLabel.setVisible(false);
                this.trainNameField.setVisible(false);
                this.dccAddressFieldLabel.setVisible(false);
                this.dccAddressSpinner.setVisible(false);
                break;
            }
            case TRAINSFROMOPS: {
                this.initializeFreeTrainsCombo();
                this.trainBoxLabel.setVisible(true);
                this.trainSelectBox.setVisible(true);
                this.rosterComboBox.setVisible(false);
                this.trainFieldLabel.setVisible(false);
                this.trainNameField.setVisible(false);
                this.dccAddressFieldLabel.setVisible(true);
                this.dccAddressSpinner.setVisible(true);
                this.setSpeedProfileOptions(false);
                break;
            }
            default: {
                this.trainNameField.setText("");
                this.trainBoxLabel.setVisible(false);
                this.trainSelectBox.setVisible(false);
                this.rosterComboBox.setVisible(false);
                this.trainFieldLabel.setVisible(true);
                this.trainNameField.setVisible(true);
                this.dccAddressFieldLabel.setVisible(true);
                this.dccAddressSpinner.setVisible(true);
                this.dccAddressSpinner.setEnabled(true);
                this.setSpeedProfileOptions(false);
            }
        }
    }

    private void initializeTrainTypeBox() {
        this.trainTypeBox.removeAllItems();
        this.trainTypeBox.addItem("<" + Bundle.getMessage("None").toLowerCase() + ">");
        this.trainTypeBox.addItem(Bundle.getMessage("LOCAL_PASSENGER"));
        this.trainTypeBox.addItem(Bundle.getMessage("LOCAL_FREIGHT"));
        this.trainTypeBox.addItem(Bundle.getMessage("THROUGH_PASSENGER"));
        this.trainTypeBox.addItem(Bundle.getMessage("THROUGH_FREIGHT"));
        this.trainTypeBox.addItem(Bundle.getMessage("EXPRESS_PASSENGER"));
        this.trainTypeBox.addItem(Bundle.getMessage("EXPRESS_FREIGHT"));
        this.trainTypeBox.addItem(Bundle.getMessage("MOW"));
    }

    private void handleTransitSelectionChanged(ActionEvent e) {
        int index = this.transitSelectBox.getSelectedIndex();
        if (index < 0) {
            return;
        }
        Transit t = (Transit)this.transitSelectBox.getSelectedItem();
        if (t != null && t != this.selectedTransit) {
            this.selectedTransit = t;
            this.initializeStartingBlockCombo();
            this.initializeDestinationBlockCombo();
            this.initiateFrame.pack();
        }
    }

    private void handleInTransitClick(ActionEvent e) {
        if (!this.inTransitBox.isSelected() && this.selectedTransit.getEntryBlocksList().isEmpty()) {
            JOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("NoEntryBlocks"), Bundle.getMessage("MessageTitle"), 1);
            this.inTransitBox.setSelected(true);
        }
        this.initializeStartingBlockCombo();
        this.initializeDestinationBlockCombo();
        this.initiateFrame.pack();
    }

    private void handleTrainSelectionChanged() {
        int dccAddress;
        if (this._TrainsFrom != DispatcherFrame.TrainsFrom.TRAINSFROMOPS) {
            return;
        }
        int ix = this.trainSelectBox.getSelectedIndex();
        if (ix < 1) {
            this.dccAddressSpinner.setEnabled(false);
            return;
        }
        this.dccAddressSpinner.setEnabled(true);
        try {
            dccAddress = Integer.parseInt(((Train)this.trainSelectBox.getSelectedItem()).getLeadEngineDccAddress());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("Error43"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.dccAddressSpinner.setValue(dccAddress);
    }

    private void handleRosterSelectionChanged(ActionEvent e) {
        if (this._TrainsFrom != DispatcherFrame.TrainsFrom.TRAINSFROMROSTER) {
            return;
        }
        int ix = this.rosterComboBox.getSelectedIndex();
        if (ix > 0) {
            RosterEntry r = (RosterEntry)this.rosterComboBox.getItemAt(ix);
            if (r.getSpeedProfile() == null || r.getSpeedProfile().getProfileSize() < 1) {
                this.setSpeedProfileOptions(false);
            } else {
                this.setSpeedProfileOptions(true);
            }
            if (r.getAttribute("DispatcherTrainType") != null && !r.getAttribute("DispatcherTrainType").equals("")) {
                this.trainTypeBox.setSelectedItem(r.getAttribute("DispatcherTrainType"));
            }
        } else {
            this.setSpeedProfileOptions(false);
        }
    }

    private boolean checkResetWhenDone() {
        if (!this.reverseAtEndBox.isSelected() && this.resetWhenDoneBox.isSelected() && !this.selectedTransit.canBeResetWhenDone()) {
            this.resetWhenDoneBox.setSelected(false);
            JOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("NoResetMessage"), Bundle.getMessage("MessageTitle"), 1);
            return false;
        }
        return true;
    }

    private void handleDelayStartClick(ActionEvent e) {
        this.departureHrSpinner.setVisible(false);
        this.departureMinSpinner.setVisible(false);
        this.departureTimeLabel.setVisible(false);
        this.departureSepLabel.setVisible(false);
        this.delaySensor.setVisible(false);
        this.resetStartSensorBox.setVisible(false);
        if (this.delayedStartBox.getSelectedItem().equals(Bundle.getMessage("DelayedStartTimed"))) {
            this.departureHrSpinner.setVisible(true);
            this.departureMinSpinner.setVisible(true);
            this.departureTimeLabel.setVisible(true);
            this.departureSepLabel.setVisible(true);
        } else if (this.delayedStartBox.getSelectedItem().equals(Bundle.getMessage("DelayedStartSensor"))) {
            this.delaySensor.setVisible(true);
            this.resetStartSensorBox.setVisible(true);
        }
        this.initiateFrame.pack();
    }

    private void handleResetWhenDoneClick(ActionEvent e) {
        this.delayMinSpinner.setVisible(false);
        this.delayMinLabel.setVisible(false);
        this.delayedReStartLabel.setVisible(false);
        this.delayedReStartBox.setVisible(false);
        this.delayReStartSensorLabel.setVisible(false);
        this.delayReStartSensor.setVisible(false);
        this.resetRestartSensorBox.setVisible(false);
        if (this.resetWhenDoneBox.isSelected()) {
            this.delayedReStartLabel.setVisible(true);
            this.delayedReStartBox.setVisible(true);
            if (this.delayedReStartBox.getSelectedItem().equals(Bundle.getMessage("DelayedStartTimed"))) {
                this.delayMinSpinner.setVisible(true);
                this.delayMinLabel.setVisible(true);
            } else if (this.delayedReStartBox.getSelectedItem().equals(Bundle.getMessage("DelayedStartSensor"))) {
                this.delayReStartSensor.setVisible(true);
                this.delayReStartSensorLabel.setVisible(true);
                this.resetRestartSensorBox.setVisible(true);
            }
        }
        this.handleReverseAtEndBoxClick(e);
        this.initiateFrame.pack();
    }

    private void handleReverseAtEndBoxClick(ActionEvent e) {
        if (this.reverseAtEndBox.isSelected() || this.resetWhenDoneBox.isSelected()) {
            this.terminateWhenDoneBox.setSelected(false);
            this.terminateWhenDoneBox.setEnabled(false);
        } else {
            this.terminateWhenDoneBox.setEnabled(true);
        }
    }

    private void handleAutoRunClick(ActionEvent e) {
        if (this.autoRunBox.isSelected()) {
            this.showAutoRunItems();
        } else {
            this.hideAutoRunItems();
        }
        this.initiateFrame.pack();
    }

    private void handleStartingBlockSelectionChanged(ActionEvent e) {
        this.initializeDestinationBlockCombo();
        this.initiateFrame.pack();
    }

    private void handleAllocateAllTheWayButtonChanged(ActionEvent e) {
        this.allocateCustomSpinner.setVisible(false);
    }

    private void handleAllocateBySafeButtonChanged(ActionEvent e) {
        this.allocateCustomSpinner.setVisible(false);
    }

    private void handleAllocateNumberOfBlocksButtonChanged(ActionEvent e) {
        this.allocateCustomSpinner.setVisible(true);
    }

    private void cancelInitiateTrain(ActionEvent e) {
        this._dispatcher.newTrainDone(null);
    }

    private void addNewTrain(ActionEvent e) {
        if (this.selectedTransit == null) {
            JOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("Error15"), Bundle.getMessage("ErrorTitle"), 0);
            this.cancelInitiateTrain(null);
            return;
        }
        String transitName = this.selectedTransit.getDisplayName();
        String trainName = "";
        int index = this.startingBlockBox.getSelectedIndex();
        if (index < 0) {
            return;
        }
        String startBlockName = this.startingBlockBoxList.get(index).getDisplayName();
        int startBlockSeq = this.startingBlockSeqList.get(index);
        index = this.destinationBlockBox.getSelectedIndex();
        if (index < 0) {
            return;
        }
        String endBlockName = this.destinationBlockBoxList.get(index).getDisplayName();
        int endBlockSeq = this.destinationBlockSeqList.get(index);
        boolean autoRun = this.autoRunBox.isSelected();
        if (!this.checkResetWhenDone()) {
            return;
        }
        boolean resetWhenDone = this.resetWhenDoneBox.isSelected();
        boolean reverseAtEnd = this.reverseAtEndBox.isSelected();
        int allocateMethod = 3;
        allocateMethod = this.allocateAllTheWayRadioButton.isSelected() ? -1 : (this.allocateBySafeRadioButton.isSelected() ? 0 : (Integer)this.allocateCustomSpinner.getValue());
        int delayedStart = this.delayModeFromBox(this.delayedStartBox);
        int delayedReStart = this.delayModeFromBox(this.delayedReStartBox);
        int departureTimeHours = 8;
        departureTimeHours = (Integer)this.departureHrSpinner.getValue();
        int departureTimeMinutes = 8;
        departureTimeMinutes = (Integer)this.departureMinSpinner.getValue();
        int delayRestartMinutes = 0;
        delayRestartMinutes = (Integer)this.delayMinSpinner.getValue();
        if (delayRestartMinutes < 0) {
            JOptionPane.showMessageDialog(this.initiateFrame, this.delayMinSpinner.getValue(), Bundle.getMessage("ErrorTitle"), 0);
            log.warn("Range error in Delay Restart Time Minutes field");
            return;
        }
        int tSource = 0;
        String dccAddress = "unknown";
        switch (this._TrainsFrom) {
            case TRAINSFROMROSTER: {
                index = this.rosterComboBox.getSelectedIndex();
                if (index < 1) {
                    JOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("Error41"), Bundle.getMessage("ErrorTitle"), 0);
                    return;
                }
                RosterEntry r = (RosterEntry)this.rosterComboBox.getSelectedItem();
                dccAddress = r.getDccAddress();
                trainName = r.titleString();
                if (!this.isAddressFree(r.getDccLocoAddress().getNumber())) {
                    JOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("Error40", dccAddress), Bundle.getMessage("ErrorTitle"), 0);
                    return;
                }
                tSource = 1;
                if (this.trainTypeBox.getSelectedIndex() == 0 || r.getAttribute("DispatcherTrainType") != null && r.getAttribute("DispatcherTrainType").equals("" + this.trainTypeBox.getSelectedItem())) break;
                r.putAttribute("DispatcherTrainType", "" + this.trainTypeBox.getSelectedItem());
                r.updateFile();
                Roster.getDefault().writeRoster();
                break;
            }
            case TRAINSFROMOPS: {
                tSource = 2;
                index = this.trainSelectBox.getSelectedIndex();
                if (index < 1) {
                    JOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("Error42"), Bundle.getMessage("ErrorTitle"), 0);
                    return;
                }
                trainName = this.trainSelectBox.getSelectedItem().toString();
                dccAddress = this.getDCCAddressFromSpinner();
                if (dccAddress != null) break;
                return;
            }
            default: {
                trainName = this.trainNameField.getText();
                if (trainName == null || trainName.equals("")) {
                    JOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("Error14"), Bundle.getMessage("ErrorTitle"), 0);
                    return;
                }
                if (!this.isTrainFree(trainName)) {
                    JOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("Error24", trainName), Bundle.getMessage("ErrorTitle"), 0);
                    return;
                }
                dccAddress = this.getDCCAddressFromSpinner();
                if (dccAddress == null) {
                    return;
                }
                tSource = 4;
            }
        }
        int priority = 5;
        priority = (Integer)this.prioritySpinner.getValue();
        int trainType = this.trainTypeBox.getSelectedIndex();
        if (this.autoRunBox.isSelected() && !this.readAutoRunItems()) {
            return;
        }
        ActiveTrain at = this._dispatcher.createActiveTrain(transitName, trainName, tSource, startBlockName, startBlockSeq, endBlockName, endBlockSeq, autoRun, dccAddress, priority, resetWhenDone, reverseAtEnd, true, this.initiateFrame, allocateMethod);
        if (at == null) {
            return;
        }
        if (tSource == 1) {
            at.setRosterEntry((RosterEntry)this.rosterComboBox.getSelectedItem());
        }
        at.setAllocateMethod(allocateMethod);
        at.setDelayedStart(delayedStart);
        at.setDelayedRestart(delayedReStart);
        at.setDepartureTimeHr(departureTimeHours);
        at.setDepartureTimeMin(departureTimeMinutes);
        at.setRestartDelay(delayRestartMinutes);
        at.setDelaySensor((Sensor)this.delaySensor.getSelectedItem());
        at.setResetStartSensor(this.resetStartSensorBox.isSelected());
        if (this._dispatcher.isFastClockTimeGE(departureTimeHours, departureTimeMinutes) && delayedStart != 2 || delayedStart == 0) {
            at.setStarted();
        }
        at.setRestartSensor((Sensor)this.delayReStartSensor.getSelectedItem());
        at.setResetRestartSensor(this.resetRestartSensorBox.isSelected());
        at.setTrainType(trainType);
        at.setTerminateWhenDone(this.terminateWhenDoneBox.isSelected());
        if (this.autoRunBox.isSelected()) {
            AutoActiveTrain aat = new AutoActiveTrain(at);
            this.setAutoRunItems(aat);
            if (!aat.initialize()) {
                JOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("Error27", at.getTrainName()), Bundle.getMessage("MessageTitle"), 1);
            }
            this._dispatcher.getAutoTrainsFrame().addAutoActiveTrain(aat);
        }
        this._dispatcher.allocateNewActiveTrain(at);
        this._dispatcher.newTrainDone(at);
    }

    private String getDCCAddressFromSpinner() {
        int address = (Integer)this.dccAddressSpinner.getValue();
        if (!this.isAddressFree(address)) {
            JOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("Error40", address), Bundle.getMessage("ErrorTitle"), 0);
            return null;
        }
        return String.valueOf(address);
    }

    private void initializeFreeTransitsCombo(List<Transit> transitList) {
        HashSet<Transit> excludeTransits = new HashSet<Transit>();
        for (Transit t : this._TransitManager.getNamedBeanSet()) {
            if (t.getState() == 2) continue;
            excludeTransits.add(t);
        }
        this.transitSelectBox.setExcludedItems(excludeTransits);
        JComboBoxUtil.setupComboBoxMaxRows(this.transitSelectBox);
        if (this.transitSelectBox.getItemCount() > 0) {
            this.transitSelectBox.setSelectedIndex(0);
            this.selectedTransit = (Transit)this.transitSelectBox.getItemAt(0);
        } else {
            this.selectedTransit = null;
        }
    }

    private void initializeFreeRosterEntriesCombo() {
        this.rosterComboBox.update();
        int ix = this.rosterComboBox.getItemCount() - 1;
        while (ix > 1) {
            if (!this.isAddressFree(((RosterEntry)this.rosterComboBox.getItemAt(ix)).getDccLocoAddress().getNumber())) {
                this.rosterComboBox.removeItemAt(ix);
            }
            --ix;
        }
    }

    private void initializeFreeTrainsCombo() {
        ActionListener[] als;
        ActionListener[] actionListenerArray = als = this.trainSelectBox.getActionListeners();
        int n = als.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener al = actionListenerArray[n2];
            this.trainSelectBox.removeActionListener(al);
            ++n2;
        }
        this.trainSelectBox.removeAllItems();
        this.trainSelectBox.addItem("Select Train");
        List<Train> trains = InstanceManager.getDefault(TrainManager.class).getTrainsByNameList();
        if (trains.size() > 0) {
            int i = 0;
            while (i < trains.size()) {
                String tName;
                Train t = trains.get(i);
                if (t != null && this.isTrainFree(tName = t.getName())) {
                    this.trainSelectBox.addItem(t);
                }
                ++i;
            }
        }
        ActionListener[] actionListenerArray2 = als;
        int n3 = als.length;
        n = 0;
        while (n < n3) {
            ActionListener al = actionListenerArray2[n];
            this.trainSelectBox.addActionListener(al);
            ++n;
        }
    }

    private void setSpeedProfileOptions(boolean b) {
        this.useSpeedProfileLabel.setEnabled(b);
        this.useSpeedProfileCheckBox.setEnabled(b);
        this.stopBySpeedProfileLabel.setEnabled(b);
        this.stopBySpeedProfileCheckBox.setEnabled(b);
        this.stopBySpeedProfileAdjustLabel.setEnabled(b);
        this.stopBySpeedProfileAdjustSpinner.setEnabled(b);
        if (!b) {
            this.useSpeedProfileCheckBox.setSelected(false);
            this.stopBySpeedProfileCheckBox.setSelected(false);
            this._useSpeedProfile = false;
            this._stopBySpeedProfile = false;
        }
    }

    private boolean isTrainFree(String rName) {
        int j = 0;
        while (j < this._ActiveTrainsList.size()) {
            ActiveTrain at = this._ActiveTrainsList.get(j);
            if (rName.equals(at.getTrainName())) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private boolean isAddressFree(int addr) {
        int j = 0;
        while (j < this._ActiveTrainsList.size()) {
            ActiveTrain at = this._ActiveTrainsList.get(j);
            if (addr == Integer.parseInt(at.getDccAddress())) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private void initializeStartingBlockCombo() {
        this.startingBlockBox.removeAllItems();
        this.startingBlockBoxList.clear();
        if (!this.inTransitBox.isSelected() && this.selectedTransit.getEntryBlocksList().isEmpty()) {
            this.inTransitBox.setSelected(true);
        }
        this.startingBlockBoxList = this.inTransitBox.isSelected() ? this.selectedTransit.getInternalBlocksList() : this.selectedTransit.getEntryBlocksList();
        this.startingBlockSeqList = this.selectedTransit.getBlockSeqList();
        boolean found = false;
        int i = 0;
        while (i < this.startingBlockBoxList.size()) {
            Block b = this.startingBlockBoxList.get(i);
            int seq = this.startingBlockSeqList.get(i);
            this.startingBlockBox.addItem(String.valueOf(this.getBlockName(b)) + "-" + seq);
            if (!found && b.getState() == 2) {
                this.startingBlockBox.setSelectedItem(String.valueOf(this.getBlockName(b)) + "-" + seq);
                found = true;
            }
            ++i;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this.startingBlockBox);
    }

    private void initializeDestinationBlockCombo() {
        this.destinationBlockBox.removeAllItems();
        this.destinationBlockBoxList.clear();
        int index = this.startingBlockBox.getSelectedIndex();
        if (index < 0) {
            return;
        }
        Block startBlock = this.startingBlockBoxList.get(index);
        this.destinationBlockBoxList = this.selectedTransit.getDestinationBlocksList(startBlock, this.inTransitBox.isSelected());
        this.destinationBlockSeqList = this.selectedTransit.getDestBlocksSeqList();
        int i = 0;
        while (i < this.destinationBlockBoxList.size()) {
            Block b = this.destinationBlockBoxList.get(i);
            String bName = this.getBlockName(b);
            if (this.selectedTransit.getBlockCount(b) > 1) {
                int seq = this.destinationBlockSeqList.get(i);
                bName = String.valueOf(bName) + "-" + seq;
            }
            this.destinationBlockBox.addItem(bName);
            ++i;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this.destinationBlockBox);
    }

    private String getBlockName(Block b) {
        if (b != null) {
            return b.getDisplayName();
        }
        return " ";
    }

    protected void showActivateFrame() {
        if (this.initiateFrame != null) {
            this.initializeFreeTransitsCombo(new ArrayList<Transit>());
            this.initiateFrame.setVisible(true);
        } else {
            this._dispatcher.newTrainDone(null);
        }
    }

    public void showActivateFrame(RosterEntry re) {
        this.showActivateFrame();
    }

    private void loadTrainInfo(ActionEvent e) {
        Object[] names = this._tiFile.getTrainInfoFileNames();
        TrainInfo info = null;
        if (names.length > 0) {
            Object selName = JOptionPane.showInputDialog(this.initiateFrame, Bundle.getMessage("LoadTrainChoice"), Bundle.getMessage("LoadTrainTitle"), 3, null, names, names[0]);
            if (selName == null || ((String)selName).equals("")) {
                return;
            }
            this._trainInfoName = (String)selName;
            try {
                info = this._tiFile.readTrainInfo((String)selName);
                if (info != null) {
                    this.trainInfoToDialog(info);
                }
            }
            catch (IOException ioe) {
                log.error("IO Exception when reading train info file {}", (Throwable)ioe);
            }
            catch (JDOMException jde) {
                log.error("JDOM Exception when reading train info file {}", (Throwable)jde);
            }
        }
        this.handleDelayStartClick(null);
        this.handleReverseAtEndBoxClick(null);
    }

    private void saveTrainInfo(ActionEvent e) {
        String fileName;
        TrainInfo info = null;
        try {
            info = this.dialogToTrainInfo();
        }
        catch (IllegalArgumentException ide) {
            JOptionPane.showMessageDialog(this.initiateFrame, ide.getMessage(), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        String eName = "";
        eName = JOptionPane.showInputDialog(this.initiateFrame, String.valueOf(Bundle.getMessage("EnterFileName")) + " :", this._trainInfoName);
        if (eName == null) {
            return;
        }
        if (eName.length() < 1) {
            JOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("Error25"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this._trainInfoName = fileName = this.normalizeXmlFileName(eName);
        String[] names = this._tiFile.getTrainInfoFileNames();
        if (names.length > 0) {
            int selectedValue;
            boolean found = false;
            int i = 0;
            while (i < names.length) {
                if (fileName.equals(names[i])) {
                    found = true;
                }
                ++i;
            }
            if (found && (selectedValue = JOptionPane.showOptionDialog(this.initiateFrame, Bundle.getMessage("Question3", fileName), Bundle.getMessage("WarningTitle"), 0, 3, null, new Object[]{Bundle.getMessage("ButtonReplace"), Bundle.getMessage("ButtonNo")}, Bundle.getMessage("ButtonNo"))) == 1) {
                return;
            }
        }
        try {
            this._tiFile.writeTrainInfo(info, fileName);
        }
        catch (IOException ioe) {
            log.error("IO exception writing Train Info: {}", (Throwable)ioe);
        }
    }

    private void deleteTrainInfo(ActionEvent e) {
        Object[] names = this._tiFile.getTrainInfoFileNames();
        if (names.length > 0) {
            Object selName = JOptionPane.showInputDialog(this.initiateFrame, Bundle.getMessage("DeleteTrainChoice"), Bundle.getMessage("DeleteTrainTitle"), 3, null, names, names[0]);
            if (selName == null || ((String)selName).equals("")) {
                return;
            }
            this._tiFile.deleteTrainInfoFile((String)selName);
        }
    }

    private void trainInfoToDialog(TrainInfo info) {
        try {
            this.transitSelectBox.setSelectedItemByName(info.getTransitName());
        }
        catch (Exception exception) {
            log.warn("Transit {} from file not in Transit menu", (Object)info.getTransitName());
            JOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("TransitWarn", info.getTransitName()), null, 2);
        }
        this._TrainsFrom = info.getTrainsFrom();
        switch (this._TrainsFrom) {
            case TRAINSFROMROSTER: {
                this.radioTrainsFromRoster.setSelected(true);
                if (this.setRosterComboBox(this.rosterComboBox, info.getTrainName())) break;
                log.warn("Roster {} from file not in Roster Combo", (Object)info.getTrainName());
                JOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("TrainWarn", info.getTrainName()), null, 2);
                break;
            }
            case TRAINSFROMOPS: {
                this.radioTrainsFromOps.setSelected(true);
                if (this.setTrainComboBox(this.trainSelectBox, info.getTrainName())) break;
                log.warn("Train {} from file not in Train Combo", (Object)info.getTrainName());
                JOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("TrainWarn", info.getTrainName()), null, 2);
                break;
            }
            default: {
                this.radioTrainsFromUser.setSelected(true);
                this.trainNameField.setText(info.getTrainName());
                this.dccAddressSpinner.setValue(Integer.parseInt(info.getDccAddress()));
            }
        }
        this.inTransitBox.setSelected(info.getTrainInTransit());
        this.initializeStartingBlockCombo();
        this.initializeDestinationBlockCombo();
        this.setComboBox(this.startingBlockBox, info.getStartBlockName());
        this.setComboBox(this.destinationBlockBox, info.getDestinationBlockName());
        this.prioritySpinner.setValue(info.getPriority());
        this.resetWhenDoneBox.setSelected(info.getResetWhenDone());
        this.reverseAtEndBox.setSelected(info.getReverseAtEnd());
        this.setDelayModeBox(info.getDelayedStart(), this.delayedStartBox);
        this.departureHrSpinner.setValue(info.getDepartureTimeHr());
        this.departureMinSpinner.setValue(info.getDepartureTimeMin());
        this.delaySensor.setSelectedItem(info.getDelaySensor());
        this.resetStartSensorBox.setSelected(info.getResetStartSensor());
        this.setDelayModeBox(info.getDelayedRestart(), this.delayedReStartBox);
        this.delayMinSpinner.setValue(info.getRestartDelayMin());
        this.delayReStartSensor.setSelectedItem(info.getRestartSensor());
        this.resetRestartSensorBox.setSelected(info.getResetRestartSensor());
        this.terminateWhenDoneBox.setSelected(info.getTerminateWhenDone());
        this.setComboBox(this.trainTypeBox, info.getTrainType());
        this.autoRunBox.setSelected(info.getAutoRun());
        this.loadAtStartupBox.setSelected(info.getLoadAtStartup());
        this.setAllocateMethodButtons(info.getAllocationMethod());
        this.autoTrainInfoToDialog(info);
    }

    private TrainInfo dialogToTrainInfo() throws IllegalArgumentException {
        TrainInfo info = new TrainInfo();
        int index = this.transitSelectBox.getSelectedIndex();
        if (index < 0) {
            throw new IllegalArgumentException(Bundle.getMessage("Error44"));
        }
        info.setTransitName(((Transit)this.transitSelectBox.getSelectedItem()).getDisplayName());
        info.setTransitId(((Transit)this.transitSelectBox.getSelectedItem()).getDisplayName());
        switch (this._TrainsFrom) {
            case TRAINSFROMROSTER: {
                if (this.rosterComboBox.getSelectedIndex() < 1) {
                    throw new IllegalArgumentException(Bundle.getMessage("Error41"));
                }
                info.setTrainName(((RosterEntry)this.rosterComboBox.getSelectedItem()).getId());
                info.setDccAddress(" ");
                break;
            }
            case TRAINSFROMOPS: {
                if (this.trainSelectBox.getSelectedIndex() < 1) {
                    throw new IllegalArgumentException(Bundle.getMessage("Error42"));
                }
                info.setTrainName(((Train)this.trainSelectBox.getSelectedItem()).getId());
                info.setDccAddress(String.valueOf(this.dccAddressSpinner.getValue()));
                break;
            }
            default: {
                if (this.trainNameField.getText().isEmpty()) {
                    throw new IllegalArgumentException(Bundle.getMessage("Error22"));
                }
                info.setTrainName(this.trainNameField.getText());
                info.setDccAddress(String.valueOf(this.dccAddressSpinner.getValue()));
            }
        }
        info.setTrainInTransit(this.inTransitBox.isSelected());
        info.setStartBlockName((String)this.startingBlockBox.getSelectedItem());
        index = this.startingBlockBox.getSelectedIndex();
        if (index < 0) {
            throw new IllegalArgumentException(Bundle.getMessage("Error13"));
        }
        info.setStartBlockId(this.startingBlockBoxList.get(index).getDisplayName());
        info.setStartBlockSeq(this.startingBlockSeqList.get(index));
        info.setDestinationBlockName((String)this.destinationBlockBox.getSelectedItem());
        index = this.destinationBlockBox.getSelectedIndex();
        if (index < 0) {
            throw new IllegalArgumentException(Bundle.getMessage("Error8"));
        }
        info.setDestinationBlockId(this.destinationBlockBoxList.get(index).getDisplayName());
        info.setDestinationBlockSeq(this.destinationBlockSeqList.get(index));
        info.setTrainsFrom(this._TrainsFrom);
        info.setPriority((Integer)this.prioritySpinner.getValue());
        info.setResetWhenDone(this.resetWhenDoneBox.isSelected());
        info.setReverseAtEnd(this.reverseAtEndBox.isSelected());
        info.setDelayedStart(this.delayModeFromBox(this.delayedStartBox));
        info.setDelaySensorName(this.delaySensor.getSelectedItemDisplayName());
        info.setResetStartSensor(this.resetStartSensorBox.isSelected());
        info.setDepartureTimeHr((Integer)this.departureHrSpinner.getValue());
        info.setDepartureTimeMin((Integer)this.departureMinSpinner.getValue());
        info.setTrainType((String)this.trainTypeBox.getSelectedItem());
        info.setAutoRun(this.autoRunBox.isSelected());
        info.setLoadAtStartup(this.loadAtStartupBox.isSelected());
        info.setAllocateAllTheWay(false);
        if (this.allocateAllTheWayRadioButton.isSelected()) {
            info.setAllocationMethod(-1);
        } else if (this.allocateBySafeRadioButton.isSelected()) {
            info.setAllocationMethod(0);
        } else {
            info.setAllocationMethod((Integer)this.allocateCustomSpinner.getValue());
        }
        info.setDelayedRestart(this.delayModeFromBox(this.delayedReStartBox));
        info.setRestartSensorName(this.delayReStartSensor.getSelectedItemDisplayName());
        info.setResetRestartSensor(this.resetRestartSensorBox.isSelected());
        info.setRestartDelayMin((Integer)this.delayMinSpinner.getValue());
        info.setTerminateWhenDone(this.terminateWhenDoneBox.isSelected());
        this.autoRunItemsToTrainInfo(info);
        return info;
    }

    private boolean setRosterComboBox(RosterEntryComboBox box, String txt) {
        boolean found = false;
        int i = 1;
        while (i < box.getItemCount()) {
            if (txt.equals(((RosterEntry)box.getItemAt(i)).getId())) {
                box.setSelectedIndex(i);
                found = true;
                break;
            }
            ++i;
        }
        if (!found && box.getItemCount() > 0) {
            box.setSelectedIndex(0);
        }
        return found;
    }

    private String normalizeXmlFileName(String name) {
        if (name.length() < 1) {
            return "";
        }
        String newName = name;
        if ((name.endsWith(".xml") || name.endsWith(".XML")) && (newName = name.substring(0, name.length() - 4)).length() < 1) {
            return "";
        }
        newName = newName.replaceAll("[\\W]", "_");
        return String.valueOf(newName) + ".xml";
    }

    private boolean setTrainComboBox(JComboBox<Object> box, String txt) {
        boolean found = false;
        int i = 1;
        while (i < box.getItemCount()) {
            if (txt.equals(box.getItemAt(i).toString())) {
                box.setSelectedIndex(i);
                found = true;
                break;
            }
            ++i;
        }
        if (!found && box.getItemCount() > 0) {
            box.setSelectedIndex(0);
        }
        return found;
    }

    private boolean setComboBox(JComboBox<String> box, String txt) {
        boolean found = false;
        int i = 0;
        while (i < box.getItemCount()) {
            if (txt.equals(box.getItemAt(i))) {
                box.setSelectedIndex(i);
                found = true;
                break;
            }
            ++i;
        }
        if (!found && box.getItemCount() > 0) {
            box.setSelectedIndex(0);
        }
        return found;
    }

    int delayModeFromBox(JComboBox<String> box) {
        String mode = (String)box.getSelectedItem();
        int result = StringUtil.getStateFromName(mode, this.delayedStartInt, this.delayedStartString);
        if (result < 0) {
            log.warn("unexpected mode string in turnoutMode: {}", (Object)mode);
            throw new IllegalArgumentException();
        }
        return result;
    }

    void setDelayModeBox(int mode, JComboBox<String> box) {
        String result = StringUtil.getNameFromState(mode, this.delayedStartInt, this.delayedStartString);
        box.setSelectedItem(result);
    }

    private void setAutoRunDefaults() {
        this._speedFactor = 1.0f;
        this._maxSpeed = 0.6f;
        this._rampRate = 0;
        this._resistanceWheels = true;
        this._runInReverse = false;
        this._soundDecoder = false;
        this._maxTrainLength = 100.0f;
        this._stopBySpeedProfile = false;
        this._stopBySpeedProfileAdjust = 1.0f;
        this._useSpeedProfile = true;
    }

    private void initializeAutoRunItems() {
        this.initializeRampCombo();
        this.pa1.setLayout(new FlowLayout());
        this.pa1.add(this.speedFactorLabel);
        this.speedFactorSpinner.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.1f), Float.valueOf(2.0f), Float.valueOf(0.01f)));
        this.speedFactorSpinner.setEditor(new JSpinner.NumberEditor(this.speedFactorSpinner, "# %"));
        this.pa1.add(this.speedFactorSpinner);
        this.speedFactorSpinner.setToolTipText(Bundle.getMessage("SpeedFactorHint"));
        this.pa1.add(new JLabel("   "));
        this.pa1.add(this.maxSpeedLabel);
        this.maxSpeedSpinner.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.1f), Float.valueOf(2.0f), Float.valueOf(0.01f)));
        this.maxSpeedSpinner.setEditor(new JSpinner.NumberEditor(this.maxSpeedSpinner, "# %"));
        this.pa1.add(this.maxSpeedSpinner);
        this.maxSpeedSpinner.setToolTipText(Bundle.getMessage("MaxSpeedHint"));
        this.initiatePane.add(this.pa1);
        this.pa2.setLayout(new FlowLayout());
        this.pa2.add(this.rampRateLabel);
        this.pa2.add(this.rampRateBox);
        this.rampRateBox.setToolTipText(Bundle.getMessage("RampRateBoxHint"));
        this.pa2.add(this.useSpeedProfileLabel);
        this.pa2.add(this.useSpeedProfileCheckBox);
        this.useSpeedProfileCheckBox.setToolTipText(Bundle.getMessage("UseSpeedProfileHint"));
        this.initiatePane.add(this.pa2);
        this.pa2a.setLayout(new FlowLayout());
        this.pa2a.add(this.stopBySpeedProfileLabel);
        this.pa2a.add(this.stopBySpeedProfileCheckBox);
        this.stopBySpeedProfileCheckBox.setToolTipText(Bundle.getMessage("UseSpeedProfileHint"));
        this.pa2a.add(this.stopBySpeedProfileAdjustLabel);
        this.stopBySpeedProfileAdjustSpinner.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.1f), Float.valueOf(5.0f), Float.valueOf(0.01f)));
        this.stopBySpeedProfileAdjustSpinner.setEditor(new JSpinner.NumberEditor(this.stopBySpeedProfileAdjustSpinner, "# %"));
        this.pa2a.add(this.stopBySpeedProfileAdjustSpinner);
        this.stopBySpeedProfileAdjustSpinner.setToolTipText(Bundle.getMessage("StopBySpeedProfileAdjustHint"));
        this.initiatePane.add(this.pa2a);
        this.pa3.setLayout(new FlowLayout());
        this.pa3.add(this.soundDecoderBox);
        this.soundDecoderBox.setToolTipText(Bundle.getMessage("SoundDecoderBoxHint"));
        this.pa3.add(new JLabel("   "));
        this.pa3.add(this.runInReverseBox);
        this.runInReverseBox.setToolTipText(Bundle.getMessage("RunInReverseBoxHint"));
        this.initiatePane.add(this.pa3);
        this.pa4.setLayout(new FlowLayout());
        this.pa4.add(this.resistanceWheelsBox);
        this.resistanceWheelsBox.setToolTipText(Bundle.getMessage("ResistanceWheelsBoxHint"));
        this.pa4.add(new JLabel("   "));
        this.pa4.add(this.trainLengthLabel);
        this.maxTrainLengthSpinner.setModel(new SpinnerNumberModel(Float.valueOf(18.0f), Float.valueOf(0.0f), Float.valueOf(10000.0f), Float.valueOf(0.5f)));
        this.maxTrainLengthSpinner.setEditor(new JSpinner.NumberEditor(this.maxTrainLengthSpinner, "###0.0"));
        this.pa4.add(this.maxTrainLengthSpinner);
        boolean unitIsMeter = InstanceManager.getDefault(DispatcherFrame.class).getUseScaleMeters();
        this.maxTrainLengthSpinner.setToolTipText(Bundle.getMessage("MaxTrainLengthHint", unitIsMeter ? Bundle.getMessage("ScaleMeters") : Bundle.getMessage("ScaleFeet")));
        this.initiatePane.add(this.pa4);
        this.hideAutoRunItems();
        this.initializeAutoRunValues();
    }

    private void initializeAutoRunValues() {
        this.speedFactorSpinner.setValue(Float.valueOf(this._speedFactor));
        this.maxSpeedSpinner.setValue(Float.valueOf(this._maxSpeed));
        this.rampRateBox.setSelectedIndex(this._rampRate);
        this.resistanceWheelsBox.setSelected(this._resistanceWheels);
        this.soundDecoderBox.setSelected(this._soundDecoder);
        this.runInReverseBox.setSelected(this._runInReverse);
        this.useSpeedProfileCheckBox.setSelected(this._useSpeedProfile);
        this.stopBySpeedProfileAdjustSpinner.setValue(Float.valueOf(this._stopBySpeedProfileAdjust));
        this.stopBySpeedProfileCheckBox.setSelected(this._stopBySpeedProfile);
        this.maxTrainLengthSpinner.setValue(Float.valueOf((float)Math.round(this._maxTrainLength * 2.0f) * 0.5f));
    }

    private void hideAutoRunItems() {
        this.pa1.setVisible(false);
        this.pa2.setVisible(false);
        this.pa2a.setVisible(false);
        this.pa3.setVisible(false);
        this.pa4.setVisible(false);
    }

    private void showAutoRunItems() {
        this.pa1.setVisible(true);
        this.pa2.setVisible(true);
        this.pa2a.setVisible(true);
        this.pa3.setVisible(true);
        this.pa4.setVisible(true);
    }

    private void autoTrainInfoToDialog(TrainInfo info) {
        this.speedFactorSpinner.setValue(info.getSpeedFactor());
        this.maxSpeedSpinner.setValue(info.getMaxSpeed());
        this.setComboBox(this.rampRateBox, info.getRampRate());
        this.resistanceWheelsBox.setSelected(info.getResistanceWheels());
        this.runInReverseBox.setSelected(info.getRunInReverse());
        this.soundDecoderBox.setSelected(info.getSoundDecoder());
        this.maxTrainLengthSpinner.setValue(Float.valueOf(info.getMaxTrainLength()));
        this.useSpeedProfileCheckBox.setSelected(info.getUseSpeedProfile());
        this.stopBySpeedProfileCheckBox.setSelected(info.getStopBySpeedProfile());
        this.stopBySpeedProfileAdjustSpinner.setValue(Float.valueOf(info.getStopBySpeedProfileAdjust()));
        if (this.autoRunBox.isSelected()) {
            this.showAutoRunItems();
        } else {
            this.hideAutoRunItems();
        }
        this.initiateFrame.pack();
    }

    private void autoRunItemsToTrainInfo(TrainInfo info) {
        info.setSpeedFactor(((Float)this.speedFactorSpinner.getValue()).floatValue());
        info.setMaxSpeed(((Float)this.maxSpeedSpinner.getValue()).floatValue());
        info.setRampRate((String)this.rampRateBox.getSelectedItem());
        info.setResistanceWheels(this.resistanceWheelsBox.isSelected());
        info.setRunInReverse(this.runInReverseBox.isSelected());
        info.setSoundDecoder(this.soundDecoderBox.isSelected());
        info.setMaxTrainLength(((Float)this.maxTrainLengthSpinner.getValue()).floatValue());
        if (this.useSpeedProfileCheckBox.isEnabled()) {
            info.setUseSpeedProfile(this.useSpeedProfileCheckBox.isSelected());
            info.setStopBySpeedProfile(this.stopBySpeedProfileCheckBox.isSelected());
            info.setStopBySpeedProfileAdjust(((Float)this.stopBySpeedProfileAdjustSpinner.getValue()).floatValue());
        } else {
            info.setUseSpeedProfile(false);
            info.setStopBySpeedProfile(false);
            info.setStopBySpeedProfileAdjust(1.0f);
        }
    }

    private boolean readAutoRunItems() {
        boolean success = true;
        this._speedFactor = ((Float)this.speedFactorSpinner.getValue()).floatValue();
        this._maxSpeed = ((Float)this.maxSpeedSpinner.getValue()).floatValue();
        this._rampRate = this.rampRateBox.getSelectedIndex();
        this._resistanceWheels = this.resistanceWheelsBox.isSelected();
        this._runInReverse = this.runInReverseBox.isSelected();
        this._soundDecoder = this.soundDecoderBox.isSelected();
        this._maxTrainLength = ((Float)this.maxTrainLengthSpinner.getValue()).floatValue();
        this._useSpeedProfile = this.useSpeedProfileCheckBox.isSelected();
        this._stopBySpeedProfile = this.stopBySpeedProfileCheckBox.isSelected();
        if (this._stopBySpeedProfile) {
            this._stopBySpeedProfileAdjust = ((Float)this.stopBySpeedProfileAdjustSpinner.getValue()).floatValue();
        }
        return success;
    }

    private void setAutoRunItems(AutoActiveTrain aaf) {
        aaf.setSpeedFactor(this._speedFactor);
        aaf.setMaxSpeed(this._maxSpeed);
        aaf.setRampRate(this._rampRate);
        aaf.setResistanceWheels(this._resistanceWheels);
        aaf.setRunInReverse(this._runInReverse);
        aaf.setSoundDecoder(this._soundDecoder);
        aaf.setMaxTrainLength(this._maxTrainLength);
        aaf.setStopBySpeedProfile(this._stopBySpeedProfile);
        aaf.setStopBySpeedProfileAdjust(this._stopBySpeedProfileAdjust);
        aaf.setUseSpeedProfile(this._useSpeedProfile);
    }

    private void initializeRampCombo() {
        this.rampRateBox.removeAllItems();
        this.rampRateBox.addItem(Bundle.getMessage("RAMP_NONE"));
        this.rampRateBox.addItem(Bundle.getMessage("RAMP_FAST"));
        this.rampRateBox.addItem(Bundle.getMessage("RAMP_MEDIUM"));
        this.rampRateBox.addItem(Bundle.getMessage("RAMP_MED_SLOW"));
        this.rampRateBox.addItem(Bundle.getMessage("RAMP_SLOW"));
    }

    private void setAllocateMethodButtons(int value) {
        switch (value) {
            case 0: {
                this.allocateBySafeRadioButton.setSelected(true);
                this.allocateCustomSpinner.setVisible(false);
                break;
            }
            case -1: {
                this.allocateAllTheWayRadioButton.setSelected(true);
                this.allocateCustomSpinner.setVisible(false);
                break;
            }
            default: {
                this.allocateNumberOfBlocks.setSelected(true);
                this.allocateCustomSpinner.setVisible(true);
                this.allocateCustomSpinner.setValue(value);
            }
        }
    }
}

