/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.decoderdefn;

import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.symbolicprog.NameFile;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.util.IteratorIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameCheckAction
extends AbstractAction {
    JFileChooser fci;
    JPanel _who;
    private static final Logger log = LoggerFactory.getLogger(NameCheckAction.class);

    public NameCheckAction(String s, JPanel who) {
        super(s);
        this._who = who;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block11: {
            if (this.fci == null) {
                this.fci = XmlFile.userFileChooser("XML files", "xml");
            }
            this.fci.rescanCurrentDirectory();
            int retVal = this.fci.showOpenDialog(this._who);
            if (retVal == 0) {
                File file = this.fci.getSelectedFile();
                log.debug("located file {} for XML processing", (Object)file);
                try {
                    Element root = this.readFile(file);
                    log.debug("parsing complete");
                    if (root.getChild("decoder") == null) {
                        log.warn("Does not appear to be a decoder file");
                        return;
                    }
                    IteratorIterable iter = root.getChild("decoder").getChild("variables").getDescendants((Filter)new ElementFilter("variable"));
                    NameFile nfile = InstanceManager.getDefault(NameFile.class);
                    StringBuffer warnings = new StringBuffer();
                    while (iter.hasNext()) {
                        Element varElement = (Element)iter.next();
                        Attribute labelAttr = varElement.getAttribute("label");
                        String label = null;
                        if (labelAttr != null) {
                            label = labelAttr.getValue();
                        }
                        Attribute itemAttr = varElement.getAttribute("item");
                        String item = null;
                        if (itemAttr != null) {
                            item = itemAttr.getValue();
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Variable called \"{}\" \"{}", (Object)(label != null ? label : "<none>"), (Object)(item != null ? item : "<none>"));
                        }
                        if (label != null && nfile.checkName(label) || item != null && nfile.checkName(item)) continue;
                        log.warn("Variable not found: label=\"{}\" item=\"{}\"", (Object)(label != null ? label : "<none>"), (Object)(item != null ? label : "<none>"));
                        warnings.append("Variable not found: label=\"").append(label != null ? label : "<none>").append("\" item=\"").append(item != null ? item : "<none>").append("\"\n");
                    }
                    if (warnings.length() != 0) {
                        JOptionPane.showMessageDialog(this._who, warnings);
                        break block11;
                    }
                    JOptionPane.showMessageDialog(this._who, "No mismatched items found");
                }
                catch (HeadlessException | IOException | JDOMException ex) {
                    JOptionPane.showMessageDialog(this._who, "Error parsing decoder file: " + ex);
                }
            } else {
                log.debug("XmlFileCheckAction cancelled in open dialog");
            }
        }
    }

    Element readFile(File file) throws JDOMException, IOException {
        XmlFile xf = new XmlFile(){};
        return xf.rootFromFile(file);
    }
}

