/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.decoderdefn;

import jmri.Programmer;
import jmri.jmrit.AbstractIdentify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IdentifyDecoder
extends AbstractIdentify {
    int mfgID = -1;
    int modelID = -1;
    int productIDhigh = -1;
    int productIDlow = -1;
    int productIDhighest = -1;
    int productIDlowest = -1;
    int productID = -1;
    private static final Logger log = LoggerFactory.getLogger(IdentifyDecoder.class);

    public IdentifyDecoder(Programmer programmer) {
        super(programmer);
    }

    @Override
    public boolean test1() {
        this.statusUpdate("Read MFG ID - CV 8");
        this.readCV("8");
        return false;
    }

    @Override
    public boolean test2(int value) {
        this.mfgID = value;
        this.statusUpdate("Read MFG version - CV 7");
        this.readCV("7");
        return false;
    }

    @Override
    public boolean test3(int value) {
        this.modelID = value;
        if (this.mfgID == 113) {
            this.statusUpdate("Set PI for Read Product ID High Byte");
            this.writeCV("49", 254);
            return false;
        }
        if (this.mfgID == 153) {
            this.statusUpdate("Read decoder ID CV 249");
            this.readCV("249");
            return false;
        }
        if (this.mfgID == 48) {
            this.statusUpdate("Read optional decoder ID CV 159");
            this.setOptionalCv(true);
            this.readCV("159");
            return false;
        }
        if (this.mfgID == 145) {
            this.statusUpdate("Read decoder ID CV 250");
            this.readCV("250");
            return false;
        }
        if (this.mfgID == 141 && (this.modelID == 70 || this.modelID == 71)) {
            this.statusUpdate("Read productID high CV253");
            this.readCV("253");
            return false;
        }
        if (this.mfgID == 98) {
            this.statusUpdate("Read decoder ID high CV 112");
            this.readCV("112");
            return false;
        }
        if (this.mfgID == 151 && this.modelID == 255) {
            this.statusUpdate("Set PI for Read productID");
            this.writeCV("31", 0);
            return false;
        }
        if (this.mfgID == 13) {
            this.statusUpdate("Read decoder product ID #1 CV 47");
            this.readCV("47");
            return false;
        }
        if (this.mfgID == 97) {
            this.statusUpdate("Read optional decoder ID CV 261");
            this.setOptionalCv(true);
            this.readCV("261");
            return false;
        }
        return true;
    }

    @Override
    public boolean test4(int value) {
        if (this.mfgID == 113) {
            this.statusUpdate("Set SI for Read Product ID High Byte");
            this.writeCV("50", 4);
            return false;
        }
        if (this.mfgID == 153) {
            if (value < 175) {
                this.productID = value;
                return true;
            }
            this.statusUpdate("Read decoder product hash #1 CV 253");
            this.readCV("253");
            return false;
        }
        if (this.mfgID == 48) {
            if (this.isOptionalCv()) {
                return true;
            }
            if (value == 143) {
                this.productIDlow = value;
                this.statusUpdate("Read Product ID High Byte");
                this.readCV("158");
                return false;
            }
            this.productID = value;
            return true;
        }
        if (this.mfgID == 145) {
            this.productID = value;
            return true;
        }
        if (this.mfgID == 141 && (this.modelID == 70 || this.modelID == 71)) {
            this.productIDhigh = value;
            this.statusUpdate("Read decoder productID low CV256");
            this.readCV("256");
            return false;
        }
        if (this.mfgID == 98) {
            this.productIDhigh = value;
            this.statusUpdate("Read decoder ID low CV 113");
            this.readCV("113");
            return false;
        }
        if (this.mfgID == 151) {
            this.statusUpdate("Set SI for Read productID");
            this.writeCV("32", 255);
            return false;
        }
        if (this.mfgID == 13) {
            this.productIDhighest = value;
            this.statusUpdate("Read decoder product ID #2 CV 48");
            this.readCV("48");
            return false;
        }
        if (this.mfgID == 97) {
            if (this.isOptionalCv()) {
                return true;
            }
            this.productID = value;
            return true;
        }
        log.error("unexpected step 4 reached with value: {}", (Object)value);
        return true;
    }

    @Override
    public boolean test5(int value) {
        if (this.mfgID == 113) {
            this.statusUpdate("Read Product ID High Byte");
            this.readCV("56");
            return false;
        }
        if (this.mfgID == 48) {
            this.productIDhigh = value;
            this.productID = this.productIDhigh << 8 | this.productIDlow;
            return true;
        }
        if (this.mfgID == 141 && (this.modelID == 70 || this.modelID == 71)) {
            this.productIDlow = value;
            this.productID = this.productIDhigh << 8 | this.productIDlow;
            return true;
        }
        if (this.mfgID == 98) {
            this.productIDlow = value;
            this.productID = this.productIDhigh << 8 | this.productIDlow;
            return true;
        }
        if (this.mfgID == 151) {
            this.statusUpdate("Read productID Byte 1");
            this.readCV("261");
            return false;
        }
        if (this.mfgID == 13) {
            this.productIDhigh = value;
            this.statusUpdate("Read decoder product ID #3 CV 49");
            this.readCV("49");
            return false;
        }
        if (this.mfgID == 153) {
            this.productIDlowest = value;
            this.statusUpdate("Read decoder product hash #2 CV 254");
            this.readCV("254");
            return false;
        }
        log.error("unexpected step 5 reached with value: {}", (Object)value);
        return true;
    }

    @Override
    public boolean test6(int value) {
        if (this.mfgID == 113) {
            this.productIDhigh = value;
            this.statusUpdate("Set SI for Read Product ID Low Byte");
            this.writeCV("50", 5);
            return false;
        }
        if (this.mfgID == 151) {
            this.productID = value;
            this.statusUpdate("Read productID Byte 2");
            this.readCV("262");
            return false;
        }
        if (this.mfgID == 13) {
            this.productIDlow = value;
            this.statusUpdate("Read decoder product ID #4 CV 50");
            this.readCV("50");
            return false;
        }
        if (this.mfgID == 153) {
            this.productIDlow = value;
            this.statusUpdate("Read decoder product hash #3 CV 255");
            this.readCV("255");
            return false;
        }
        log.error("unexpected step 6 reached with value: {}", (Object)value);
        return true;
    }

    @Override
    public boolean test7(int value) {
        if (this.mfgID == 113) {
            this.statusUpdate("Read Product ID Low Byte");
            this.readCV("56");
            return false;
        }
        if (this.mfgID == 151) {
            this.productID += value * 256;
            this.statusUpdate("Read productID Byte 3");
            this.readCV("263");
            return false;
        }
        if (this.mfgID == 13) {
            this.productIDlowest = value;
            this.productID = ((this.productIDhighest << 8 | this.productIDhigh) << 8 | this.productIDlow) << 8 | this.productIDlowest;
            return true;
        }
        if (this.mfgID == 153) {
            this.productIDhigh = value;
            this.statusUpdate("Read decoder product hash #4 CV 256");
            this.readCV("256");
            return false;
        }
        log.error("unexpected step 7 reached with value: {}", (Object)value);
        return true;
    }

    @Override
    public boolean test8(int value) {
        if (this.mfgID == 113) {
            this.productIDlow = value;
            this.productID = this.productIDhigh * 256 + this.productIDlow;
            return true;
        }
        if (this.mfgID == 151) {
            this.productID += value * 256 * 256;
            this.statusUpdate("Read productID Byte 4");
            this.readCV("264");
            return false;
        }
        if (this.mfgID == 153) {
            this.productIDhighest = value;
            this.productID = this.productIDhighest * 256 * 256 * 256 + this.productIDhigh * 256 * 256 + this.productIDlow * 256 + this.productIDlowest;
            return true;
        }
        log.error("unexpected step 8 reached with value: {}", (Object)value);
        return true;
    }

    @Override
    public boolean test9(int value) {
        if (this.mfgID == 151) {
            this.productID += value * 256 * 256 * 256;
            return true;
        }
        log.error("unexpected step 9 reached with value: {}", (Object)value);
        return true;
    }

    @Override
    protected void statusUpdate(String s) {
        this.message(s);
        if (s.equals("Done")) {
            this.done(this.mfgID, this.modelID, this.productID);
            log.info("Decoder returns mfgID:{};modelID:{};productID:{}", new Object[]{this.mfgID, this.modelID, this.productID});
        } else if (log.isDebugEnabled()) {
            log.debug("received status: {}", (Object)s);
        }
    }

    protected abstract void done(int var1, int var2, int var3);

    protected abstract void message(String var1);
}

