/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.decoderdefn;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import jmri.InstanceManager;
import jmri.implementation.AbstractInstanceInitializer;
import jmri.jmrit.XmlFile;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.util.FileUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderIndexFile
extends XmlFile {
    public static final String MANUFACTURER = "manufacturer";
    public static final String MFG_ID = "mfgID";
    public static final String DECODER_INDEX = "decoderIndex";
    public static final String VERSION = "version";
    public static final String LOW_VERSION_ID = "lowVersionID";
    public static final String HIGH_VERSION_ID = "highVersionID";
    protected List<DecoderFile> decoderList = new ArrayList<DecoderFile>();
    int fileVersion = -1;
    protected HashMap<String, String> _mfgIdFromNameHash = new HashMap();
    protected HashMap<String, String> _mfgNameFromIdHash = new HashMap();
    protected ArrayList<String> mMfgNameList = new ArrayList();
    String nmraListDate = null;
    String updated = null;
    String lastAdd = null;
    protected static final String DECODER_INDEX_FILE_NAME = "decoderIndex.xml";
    private static final Logger log = LoggerFactory.getLogger(DecoderIndexFile.class);

    public int numDecoders() {
        return this.decoderList.size();
    }

    public List<String> getMfgNameList() {
        return this.mMfgNameList;
    }

    public String mfgIdFromName(String name) {
        return this._mfgIdFromNameHash.get(name);
    }

    public String mfgNameFromID(String idNum) {
        return this._mfgNameFromIdHash.get(idNum);
    }

    @Nonnull
    public List<DecoderFile> matchingDecoderList(String mfg, String family, String decoderMfgID, String decoderVersionID, String decoderProductID, String model) {
        return this.matchingDecoderList(mfg, family, decoderMfgID, decoderVersionID, decoderProductID, model, null, null, null);
    }

    @Nonnull
    public List<DecoderFile> matchingDecoderList(String mfg, String family, String decoderMfgID, String decoderVersionID, String decoderProductID, String model, String developerID, String manufacturerID, String productID) {
        ArrayList<DecoderFile> l = new ArrayList<DecoderFile>();
        int i = 0;
        while (i < this.numDecoders()) {
            if (this.checkEntry(i, mfg, family, decoderMfgID, decoderVersionID, decoderProductID, model, developerID, manufacturerID, productID)) {
                l.add(this.decoderList.get(i));
            }
            ++i;
        }
        return l;
    }

    public JComboBox<String> matchingComboBox(String mfg, String family, String decoderMfgID, String decoderVersionID, String decoderProductID, String model) {
        List<DecoderFile> l = this.matchingDecoderList(mfg, family, decoderMfgID, decoderVersionID, decoderProductID, model);
        return DecoderIndexFile.jComboBoxFromList(l);
    }

    public static JComboBox<String> jComboBoxFromList(List<DecoderFile> l) {
        return new JComboBox<String>(DecoderIndexFile.jComboBoxModelFromList(l));
    }

    public static ComboBoxModel<String> jComboBoxModelFromList(List<DecoderFile> l) {
        DefaultComboBoxModel<String> b = new DefaultComboBoxModel<String>();
        int i = 0;
        while (i < l.size()) {
            DecoderFile r = l.get(i);
            b.addElement(r.titleString());
            ++i;
        }
        return b;
    }

    public DecoderFile fileFromTitle(String title) {
        int i = this.numDecoders() - 1;
        while (i >= 0) {
            DecoderFile r = this.decoderList.get(i);
            if (r.titleString().equals(title)) {
                return r;
            }
            --i;
        }
        return null;
    }

    public boolean checkEntry(int i, String mfgName, String family, String mfgID, String decoderVersionID, String decoderProductID, String model, String developerID, String manufacturerID, String productID) {
        int versionID;
        DecoderFile r = this.decoderList.get(i);
        if (mfgName != null && !mfgName.equals(r.getMfg())) {
            return false;
        }
        if (family != null && !family.equals(r.getFamily())) {
            return false;
        }
        if (mfgID != null && !mfgID.equals(r.getMfgID())) {
            return false;
        }
        if (model != null && !model.equals(r.getModel())) {
            return false;
        }
        if (decoderVersionID != null && !r.isVersion(versionID = Integer.parseInt(decoderVersionID))) {
            return false;
        }
        if (decoderProductID != null && !this.checkInCommaDelimString(decoderProductID, r.getProductID())) {
            return false;
        }
        if (developerID != null) {
            if (!developerID.equals(r.getDeveloperID())) {
                if (r.getModelElement().getAttribute("developerID") == null) {
                    return false;
                }
                if (!("," + r.getModelElement().getAttribute("developerID").getValue() + ",").contains("," + developerID + ",")) {
                    return false;
                }
            }
            log.debug("developerID match");
        }
        if (manufacturerID != null) {
            Attribute a;
            log.debug("checking manufactureriD {}, mfgID {}, modelElement[manufacturerID] {}", new Object[]{manufacturerID, r._mfgID, r.getModelElement().getAttribute("manufacturerID")});
            if (!(r._mfgID != null && manufacturerID.compareTo(r._mfgID) == 0 || manufacturerID.equals(r.getManufacturerID()) || (a = r.getModelElement().getAttribute("manufacturerID")) != null && a.getValue() != null && manufacturerID.compareTo(a.getValue()) == 0)) {
                return false;
            }
            log.debug("manufacturerID match");
        }
        if (productID != null) {
            if (!productID.equals(r.getProductID())) {
                if (r.getModelElement().getAttribute("productID") == null) {
                    return false;
                }
                if (!("," + r.getModelElement().getAttribute("productID").getValue() + ",").contains("," + productID + ",")) {
                    return false;
                }
            }
            log.debug("productID match");
        }
        return true;
    }

    public static synchronized void resetInstance() {
        InstanceManager.getDefault().clear(DecoderIndexFile.class);
    }

    static boolean updateIndexIfNeeded() throws JDOMException, IOException {
        switch (FileUtil.findFiles(DecoderIndexFile.defaultDecoderIndexFilename(), ".").size()) {
            case 0: {
                log.debug("creating decoder index");
                DecoderIndexFile.forceCreationOfNewIndex();
                return true;
            }
            case 1: {
                return false;
            }
        }
        String masterVersion = null;
        DecoderIndexFile masterXmlFile = new DecoderIndexFile();
        URL masterFile = FileUtil.findURL("xml/" + DecoderIndexFile.defaultDecoderIndexFilename(), FileUtil.Location.INSTALLED);
        if (masterFile == null) {
            return false;
        }
        log.debug("checking for master file at {}", (Object)masterFile);
        Element masterRoot = masterXmlFile.rootFromURL(masterFile);
        if (masterRoot.getChild(DECODER_INDEX) != null) {
            if (masterRoot.getChild(DECODER_INDEX).getAttribute(VERSION) != null) {
                masterVersion = masterRoot.getChild(DECODER_INDEX).getAttribute(VERSION).getValue();
            }
        } else {
            return false;
        }
        log.debug("master version found, is {}", masterVersion);
        String userVersion = null;
        DecoderIndexFile userXmlFile = new DecoderIndexFile();
        log.debug("checking for user file at {}", (Object)DecoderIndexFile.defaultDecoderIndexFilename());
        Element userRoot = userXmlFile.rootFromName(DecoderIndexFile.defaultDecoderIndexFilename());
        if (userRoot.getChild(DECODER_INDEX) != null) {
            if (userRoot.getChild(DECODER_INDEX).getAttribute(VERSION) != null) {
                userVersion = userRoot.getChild(DECODER_INDEX).getAttribute(VERSION).getValue();
            }
            log.debug("user version found, is {}", userVersion);
        }
        if (masterVersion != null && masterVersion.equals(userVersion)) {
            return false;
        }
        log.debug("forcing update of decoder index due to {} and {}", (Object)masterVersion, userVersion);
        DecoderIndexFile.forceCreationOfNewIndex();
        return true;
    }

    public static void forceCreationOfNewIndex() {
        DecoderIndexFile.forceCreationOfNewIndex(false);
    }

    public static void forceCreationOfNewIndex(boolean increment) {
        String[] fileList;
        int n;
        int n2;
        String[] stringArray;
        log.info("update decoder index");
        File oldfile = new File(String.valueOf(FileUtil.getUserFilesPath()) + DECODER_INDEX_FILE_NAME);
        if (oldfile.exists()) {
            log.debug("remove existing user decoderIndex.xml file");
            if (!oldfile.delete()) {
                log.error("Failed to delete old index file");
            }
            DecoderIndexFile.resetInstance();
        }
        ArrayList<String> al = new ArrayList<String>();
        FileUtil.createDirectory(String.valueOf(FileUtil.getUserFilesPath()) + DecoderFile.fileLocation);
        File fp = new File(String.valueOf(FileUtil.getUserFilesPath()) + DecoderFile.fileLocation);
        if (fp.exists()) {
            String[] list = fp.list();
            if (list != null) {
                stringArray = list;
                n2 = list.length;
                n = 0;
                while (n < n2) {
                    String sp = stringArray[n];
                    if (sp.endsWith(".xml") || sp.endsWith(".XML")) {
                        al.add(sp);
                    }
                    ++n;
                }
            }
        } else {
            log.debug("{}decoders was missing, though tried to create it", (Object)FileUtil.getUserFilesPath());
        }
        if ((fileList = new File(String.valueOf(XmlFile.xmlDir()) + DecoderFile.fileLocation).list()) != null) {
            stringArray = fileList;
            n2 = fileList.length;
            n = 0;
            while (n < n2) {
                String sx = stringArray[n];
                if ((sx.endsWith(".xml") || sx.endsWith(".XML")) && !al.contains(sx)) {
                    al.add(sx);
                }
                ++n;
            }
        } else {
            log.error("Could not access decoder definition directory {}{}", (Object)XmlFile.xmlDir(), (Object)DecoderFile.fileLocation);
        }
        Object[] sbox = al.toArray(new String[al.size()]);
        Arrays.sort(sbox);
        DecoderIndexFile index = new DecoderIndexFile();
        index.fileVersion = increment ? InstanceManager.getDefault(DecoderIndexFile.class).fileVersion + 2 : InstanceManager.getDefault(DecoderIndexFile.class).fileVersion;
        try {
            index.writeFile(DECODER_INDEX_FILE_NAME, InstanceManager.getDefault(DecoderIndexFile.class), (String[])sbox);
        }
        catch (IOException ex) {
            log.error("Error writing new decoder index file: {}", (Object)ex.getMessage());
        }
    }

    void readFile(String name) throws JDOMException, IOException {
        Element root;
        if (log.isDebugEnabled()) {
            log.debug("readFile {}", (Object)name);
        }
        if ((root = this.rootFromName(name)).getChild(DECODER_INDEX) != null) {
            if (root.getChild(DECODER_INDEX).getAttribute(VERSION) != null) {
                this.fileVersion = Integer.parseInt(root.getChild(DECODER_INDEX).getAttribute(VERSION).getValue());
            }
            log.debug("found fileVersion of {}", (Object)this.fileVersion);
            this.readMfgSection();
            this.readFamilySection(root.getChild(DECODER_INDEX));
        } else {
            log.error("Unrecognized decoderIndex file contents in file: {}", (Object)name);
        }
    }

    void readMfgSection() throws JDOMException, IOException {
        Element mfgList = this.rootFromName("nmra_mfg_list.xml");
        if (mfgList != null) {
            Attribute a = mfgList.getAttribute("nmraListDate");
            if (a != null) {
                this.nmraListDate = a.getValue();
            }
            if ((a = mfgList.getAttribute("updated")) != null) {
                this.updated = a.getValue();
            }
            if ((a = mfgList.getAttribute("lastadd")) != null) {
                this.lastAdd = a.getValue();
            }
            List l = mfgList.getChildren(MANUFACTURER);
            if (log.isDebugEnabled()) {
                log.debug("readMfgSection sees {} children", (Object)l.size());
            }
            int i = 0;
            while (i < l.size()) {
                Element el = (Element)l.get(i);
                String mfg = el.getAttribute("mfg").getValue();
                this.mMfgNameList.add(mfg);
                Attribute attr = el.getAttribute(MFG_ID);
                if (attr != null) {
                    this._mfgIdFromNameHash.put(mfg, attr.getValue());
                    this._mfgNameFromIdHash.put(attr.getValue(), mfg);
                }
                ++i;
            }
        } else {
            log.debug("no mfgList found");
        }
    }

    void readFamilySection(Element decoderIndex) {
        Element familyList = decoderIndex.getChild("familyList");
        if (familyList != null) {
            List l = familyList.getChildren("family");
            log.trace("readFamilySection sees {} children", (Object)l.size());
            int i = 0;
            while (i < l.size()) {
                Element el = (Element)l.get(i);
                this.readFamily(el);
                ++i;
            }
        } else {
            log.debug("no familyList found in decoderIndexFile");
        }
    }

    void readFamily(Element family) {
        Element modelElement;
        String filename = family.getAttribute("file").getValue();
        Attribute attr = family.getAttribute(LOW_VERSION_ID);
        String parentLowVersID = attr != null ? attr.getValue() : null;
        attr = family.getAttribute(HIGH_VERSION_ID);
        String parentHighVersID = attr != null ? attr.getValue() : null;
        attr = family.getAttribute("replacementFamily");
        String ParentReplacementFamilyName = attr != null ? attr.getValue() : null;
        attr = family.getAttribute("name");
        String familyName = attr != null ? attr.getValue() : null;
        attr = family.getAttribute("mfg");
        String mfg = attr != null ? attr.getValue() : null;
        attr = family.getAttribute("developerID");
        String developerID = attr != null ? attr.getValue() : null;
        attr = family.getAttribute("manufacturerID");
        String manufacturerID = attr != null ? attr.getValue() : null;
        attr = family.getAttribute("productID");
        String productID = attr != null ? attr.getValue() : null;
        String mfgID = null;
        if (mfg != null) {
            mfgID = this.mfgIdFromName(mfg);
        } else {
            log.error("Did not find required mfg attribute, may not find proper manufacturer");
        }
        List l = family.getChildren("model");
        log.trace("readFamily sees {} children", (Object)l.size());
        if (l.isEmpty()) {
            log.error("Did not find at least one model in the {} family", (Object)familyName);
            modelElement = null;
        } else {
            modelElement = (Element)l.get(0);
        }
        DecoderFile vFamilyDecoderFile = new DecoderFile(mfg, mfgID, familyName, parentLowVersID, parentHighVersID, familyName, filename, developerID != null ? developerID : "-1", manufacturerID != null ? manufacturerID : "-1", productID != null ? productID : "-1", -1, -1, modelElement, ParentReplacementFamilyName, ParentReplacementFamilyName);
        this.decoderList.add(vFamilyDecoderFile);
        int i = 0;
        while (i < l.size()) {
            Element decoder = (Element)l.get(i);
            attr = decoder.getAttribute(LOW_VERSION_ID);
            String loVersID = attr != null ? attr.getValue() : parentLowVersID;
            attr = decoder.getAttribute(HIGH_VERSION_ID);
            String hiVersID = attr != null ? attr.getValue() : parentHighVersID;
            attr = decoder.getAttribute("replacementModel");
            String replacementModelName = attr != null ? attr.getValue() : null;
            attr = decoder.getAttribute("replacementFamily");
            String replacementFamilyName = attr != null ? attr.getValue() : ParentReplacementFamilyName;
            attr = decoder.getAttribute("numFns");
            int numFns = attr != null ? Integer.parseInt(attr.getValue()) : -1;
            attr = decoder.getAttribute("numOuts");
            int numOuts = attr != null ? Integer.parseInt(attr.getValue()) : -1;
            attr = decoder.getAttribute("developerID");
            String devId = attr != null ? attr.getValue() : "-1";
            attr = decoder.getAttribute("manufacturerID");
            String manufId = attr != null ? attr.getValue() : "-1";
            attr = decoder.getAttribute("productID");
            String prodId = attr != null ? attr.getValue() : "-1";
            attr = decoder.getAttribute("model");
            DecoderFile df = new DecoderFile(mfg, mfgID, attr != null ? attr.getValue() : null, loVersID, hiVersID, familyName, filename, devId, manufId, prodId, numFns, numOuts, decoder, replacementModelName, replacementFamilyName);
            this.decoderList.add(df);
            List vcodes = decoder.getChildren("versionCV");
            int j = 0;
            while (j < vcodes.size()) {
                Element vcv = (Element)vcodes.get(j);
                attr = vcv.getAttribute(LOW_VERSION_ID);
                String vLoVersID = attr != null ? attr.getValue() : loVersID;
                attr = vcv.getAttribute(HIGH_VERSION_ID);
                String vHiVersID = attr != null ? attr.getValue() : hiVersID;
                df.setVersionRange(vLoVersID, vHiVersID);
                ++j;
            }
            ++i;
        }
    }

    public boolean checkInCommaDelimString(String findString, String inString) {
        String bracketedFindString = "," + findString + ",";
        String bracketedInString = "," + inString + ",";
        return bracketedInString.contains(bracketedFindString);
    }

    public void writeFile(String name, DecoderIndexFile oldIndex, String[] files) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("writeFile {}", (Object)name);
        }
        File file = new File(String.valueOf(FileUtil.getUserFilesPath()) + name);
        Element root = new Element("decoderIndex-config");
        root.setAttribute("noNamespaceSchemaLocation", "http://jmri.org/xml/schema/decoder-4-15-2.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        Document doc = DecoderIndexFile.newDocument(root);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "text/xsl");
        m.put("href", "/xml/XSLT/DecoderID.xsl");
        ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
        doc.addContent(0, (Content)p);
        Element index = new Element(DECODER_INDEX);
        root.addContent((Content)index);
        index.setAttribute(VERSION, Integer.toString(this.fileVersion));
        log.debug("version written to file as {}", (Object)this.fileVersion);
        Element mfgList = new Element("mfgList");
        if (oldIndex.nmraListDate != null) {
            mfgList.setAttribute("nmraListDate", oldIndex.nmraListDate);
        }
        if (oldIndex.updated != null) {
            mfgList.setAttribute("updated", oldIndex.updated);
        }
        if (oldIndex.lastAdd != null) {
            mfgList.setAttribute("lastadd", oldIndex.lastAdd);
        }
        Element mfg = new Element(MANUFACTURER);
        mfg.setAttribute("mfg", "NMRA");
        mfg.setAttribute(MFG_ID, "999");
        mfgList.addContent((Content)mfg);
        ArrayList<String> keys = new ArrayList<String>(oldIndex._mfgIdFromNameHash.keySet());
        Collections.sort(keys);
        for (Object e : keys) {
            String mfgName = (String)e;
            if (mfgName.equals("NMRA")) continue;
            mfg = new Element(MANUFACTURER);
            mfg.setAttribute("mfg", mfgName);
            mfg.setAttribute(MFG_ID, oldIndex._mfgIdFromNameHash.get(mfgName));
            mfgList.addContent((Content)mfg);
        }
        Element element = new Element("familyList");
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            DecoderFile d = new DecoderFile();
            try {
                Element droot = d.rootFromName(String.valueOf(DecoderFile.fileLocation) + fileName);
                Element family = droot.getChild("decoder").getChild("family").clone();
                family.setAttribute("file", fileName);
                element.addContent((Content)family);
            }
            catch (JDOMException exj) {
                log.error("could not parse {}: {}", (Object)fileName, (Object)exj.getMessage());
            }
            catch (FileNotFoundException exj) {
                log.error("could not read {}: {}", (Object)fileName, (Object)exj.getMessage());
            }
            catch (IOException exj) {
                log.error("other exception while dealing with {}: {}", (Object)fileName, (Object)exj.getMessage());
            }
            catch (Exception exq) {
                log.error("exception reading {}", (Object)fileName, (Object)exq);
                throw exq;
            }
            ++n2;
        }
        index.addContent((Content)mfgList);
        index.addContent((Content)element);
        this.writeXML(file, doc);
        DecoderIndexFile.resetInstance();
    }

    protected static String defaultDecoderIndexFilename() {
        return DECODER_INDEX_FILE_NAME;
    }

    public static class Initializer
    extends AbstractInstanceInitializer {
        @Override
        public <T> Object getDefault(Class<T> type) {
            if (type.equals(DecoderIndexFile.class)) {
                DecoderIndexFile instance = new DecoderIndexFile();
                log.debug("DecoderIndexFile creating instance");
                try {
                    instance.readFile(DecoderIndexFile.defaultDecoderIndexFilename());
                }
                catch (IOException | JDOMException e) {
                    log.error("Exception during decoder index reading: ", e);
                }
                try {
                    if (DecoderIndexFile.updateIndexIfNeeded()) {
                        try {
                            instance = new DecoderIndexFile();
                            instance.readFile(DecoderIndexFile.defaultDecoderIndexFilename());
                        }
                        catch (IOException | JDOMException e) {
                            log.error("Exception during decoder index reload: ", e);
                        }
                    }
                }
                catch (IOException | JDOMException e) {
                    log.error("Exception during decoder index update: ", e);
                }
                log.debug("DecoderIndexFile returns instance {}", (Object)instance);
                return instance;
            }
            return super.getDefault(type);
        }

        @Override
        public Set<Class<?>> getInitalizes() {
            Set<Class<?>> set = super.getInitalizes();
            set.add(DecoderIndexFile.class);
            return set;
        }
    }
}

