/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc.topology;

import java.util.ArrayList;
import java.util.Arrays;
import jmri.Block;
import jmri.InstanceManager;
import jmri.Path;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SignalMast;
import jmri.SignalMastLogic;
import jmri.SignalMastLogicManager;
import jmri.jmrit.ctc.ctcserialdata.CTCSerialData;
import jmri.jmrit.ctc.topology.TopologyInfo;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;

public class Topology {
    private final CTCSerialData _mCTCSerialData;
    private final String _mNormal;
    private final String _mReverse;
    private final SignalMastLogicManager _mSignalMastLogicManager = InstanceManager.getDefault(SignalMastLogicManager.class);
    private final LayoutBlockManager _mLayoutBlockManager = InstanceManager.getDefault(LayoutBlockManager.class);
    private ArrayList<Block> _mStartingBlocks = new ArrayList();

    public Topology() {
        this._mCTCSerialData = null;
        this._mNormal = null;
        this._mReverse = null;
    }

    public Topology(CTCSerialData CTCSerialData2, ArrayList<String> OSSectionOccupiedExternalSensors, String normal, String reverse) {
        this._mCTCSerialData = CTCSerialData2;
        this._mNormal = normal;
        this._mReverse = reverse;
        for (String OSSectionOccupiedExternalSensor : OSSectionOccupiedExternalSensors) {
            LayoutBlock startingLayoutBlock;
            Sensor startingOSSectionSensor = InstanceManager.getDefault(SensorManager.class).getSensor(OSSectionOccupiedExternalSensor);
            if (startingOSSectionSensor == null || (startingLayoutBlock = this._mLayoutBlockManager.getBlockWithSensorAssigned(startingOSSectionSensor)) == null) continue;
            this._mStartingBlocks.add(startingLayoutBlock.getBlock());
        }
    }

    public boolean isTopologyAvailable() {
        return !this._mStartingBlocks.isEmpty();
    }

    public ArrayList<TopologyInfo> getTrafficLockingRules(boolean leftTraffic) {
        ArrayList<TopologyInfo> returnValue = new ArrayList<TopologyInfo>();
        for (Block startingBlock : this._mStartingBlocks) {
            for (Path path : startingBlock.getPaths()) {
                SignalMastLogic facingSignalMastLogic;
                SignalMast facingSignalMast;
                Block neighborBlock = path.getBlock();
                if (!this.inSameDirectionGenerally(this.getDirectionArrayListFrom(leftTraffic ? 64 : 128), path.getToBlockDirection()) || (facingSignalMast = this._mLayoutBlockManager.getFacingSignalMast(neighborBlock, startingBlock)) == null || (facingSignalMastLogic = this._mSignalMastLogicManager.getSignalMastLogic(facingSignalMast)) == null) continue;
                this.processDestinations(returnValue, facingSignalMastLogic);
            }
        }
        return returnValue;
    }

    private void processDestinations(ArrayList<TopologyInfo> topologyInfos, SignalMastLogic facingSignalMastLogic) {
        for (SignalMast destinationSignalMast : facingSignalMastLogic.getDestinationList()) {
            TopologyInfo topologyInfo = new TopologyInfo(this._mCTCSerialData, destinationSignalMast.getUserName(), this._mNormal, this._mReverse);
            this.createRules(topologyInfo, facingSignalMastLogic, destinationSignalMast);
            SignalMast tempSignalMast = destinationSignalMast;
            while (this.isIntermediateSignalMast(tempSignalMast)) {
                SignalMastLogic tempSignalMastLogic = this._mSignalMastLogicManager.getSignalMastLogic(tempSignalMast);
                if (tempSignalMastLogic == null) break;
                SignalMast onlyTerminatingSignalMast = tempSignalMastLogic.getDestinationList().get(0);
                this.createRules(topologyInfo, tempSignalMastLogic, onlyTerminatingSignalMast);
                tempSignalMast = onlyTerminatingSignalMast;
            }
            if (!topologyInfo.nonEmpty()) continue;
            topologyInfos.add(topologyInfo);
        }
    }

    private void createRules(TopologyInfo topologyInfo, SignalMastLogic signalMastLogic, SignalMast signalMast) {
        topologyInfo.addBlocks(signalMastLogic.getBlocks(signalMast));
        topologyInfo.addBlocks(signalMastLogic.getAutoBlocks(signalMast));
        topologyInfo.addTurnouts(signalMastLogic, signalMast);
    }

    private boolean isIntermediateSignalMast(SignalMast signalMast) {
        SignalMastLogic signalMastLogic;
        if (signalMast != null && (signalMastLogic = this._mSignalMastLogicManager.getSignalMastLogic(signalMast)) != null) {
            return signalMastLogic.getDestinationList().size() == 1 && signalMastLogic.getAutoTurnouts(signalMastLogic.getDestinationList().get(0)).isEmpty() && signalMastLogic.getTurnouts(signalMastLogic.getDestinationList().get(0)).isEmpty();
        }
        return false;
    }

    private ArrayList<Integer> getDirectionArrayListFrom(int direction) {
        switch (direction) {
            case 16: {
                return new ArrayList<Integer>(Arrays.asList(144, 16, 80));
            }
            case 80: {
                return new ArrayList<Integer>(Arrays.asList(16, 80, 64));
            }
            case 64: {
                return new ArrayList<Integer>(Arrays.asList(80, 64, 96));
            }
            case 96: {
                return new ArrayList<Integer>(Arrays.asList(64, 96, 32));
            }
            case 32: {
                return new ArrayList<Integer>(Arrays.asList(96, 32, 160));
            }
            case 160: {
                return new ArrayList<Integer>(Arrays.asList(32, 160, 128));
            }
            case 128: {
                return new ArrayList<Integer>(Arrays.asList(160, 128, 144));
            }
            case 144: {
                return new ArrayList<Integer>(Arrays.asList(128, 144, 16));
            }
        }
        return new ArrayList<Integer>();
    }

    private boolean inSameDirectionGenerally(ArrayList<Integer> possibleDirections, int direction) {
        if (possibleDirections.isEmpty()) {
            return false;
        }
        return possibleDirections.contains(direction);
    }
}

