/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc.editor.code;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.NumberFormatter;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.SensorManager;
import jmri.SignalHeadManager;
import jmri.SignalMastManager;
import jmri.TurnoutManager;
import jmri.jmrit.ctc.CtcManager;
import jmri.jmrit.ctc.NBHSensor;
import jmri.jmrit.ctc.NBHSignal;
import jmri.jmrit.ctc.NBHTurnout;
import jmri.jmrit.ctc.ctcserialdata.CTCSerialData;
import jmri.jmrit.ctc.ctcserialdata.CodeButtonHandlerData;
import jmri.jmrit.ctc.ctcserialdata.ProjectsCommonSubs;
import jmri.jmrit.ctc.editor.code.Bundle;
import jmri.util.AlphanumComparator;
import jmri.util.HelpUtil;
import jmri.util.swing.JComboBoxUtil;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonSubs {
    private static final Logger log = LoggerFactory.getLogger(CommonSubs.class);

    public static void setMillisecondsEdit(JFormattedTextField formattedTextField) {
        NumberFormatter numberFormatter = (NumberFormatter)formattedTextField.getFormatter();
        numberFormatter.setMinimum(Integer.valueOf(0));
        numberFormatter.setMaximum(Integer.valueOf(120000));
        numberFormatter.setAllowsInvalid(false);
    }

    public static int getIntFromJTextFieldNoThrow(JTextField textField) {
        return ProjectsCommonSubs.getIntFromStringNoThrow(textField.getText(), 0);
    }

    public static boolean allowClose(Component parentComponent, boolean dataChanged) {
        if (dataChanged) {
            return JOptionPane.showConfirmDialog(parentComponent, Bundle.getMessage("CommonSubsDataModified"), Bundle.getMessage("WarningTitle"), 0) == 0;
        }
        return true;
    }

    public static void addHelpMenu(JFrame frame, String ref, boolean direct) {
        JMenuBar bar = frame.getJMenuBar();
        if (bar == null) {
            bar = new JMenuBar();
        }
        HelpUtil.helpMenu(bar, ref, direct);
        frame.setJMenuBar(bar);
    }

    public static String getCSVStringFromDefaultTableModel(DefaultTableModel defaultTableModel) {
        ArrayList<String> entries = new ArrayList<String>();
        int sourceIndex2 = 0;
        while (sourceIndex2 < defaultTableModel.getRowCount()) {
            String entry;
            Object object = defaultTableModel.getValueAt(sourceIndex2, 0);
            if (object != null && !(entry = object.toString().trim()).isEmpty()) {
                entries.add(entry);
            }
            ++sourceIndex2;
        }
        try {
            Throwable sourceIndex2 = null;
            Object var3_6 = null;
            try (CSVPrinter printer = new CSVPrinter((Appendable)new StringBuilder(), CSVFormat.DEFAULT.withQuote(null).withRecordSeparator(null));){
                printer.printRecord(entries);
                return printer.getOut().toString();
            }
            catch (Throwable throwable) {
                if (sourceIndex2 == null) {
                    sourceIndex2 = throwable;
                } else if (sourceIndex2 != throwable) {
                    sourceIndex2.addSuppressed(throwable);
                }
                throw sourceIndex2;
            }
        }
        catch (IOException ex) {
            log.error("Unable to create CSV", (Throwable)ex);
            return "";
        }
    }

    public static ArrayList<String> getStringArrayFromDefaultTableModel(DefaultTableModel defaultTableModel) {
        ArrayList<String> entries = new ArrayList<String>();
        int sourceIndex = 0;
        while (sourceIndex < defaultTableModel.getRowCount()) {
            String entry;
            Object object = defaultTableModel.getValueAt(sourceIndex, 0);
            if (object != null && !(entry = object.toString().trim()).isEmpty()) {
                entries.add(entry);
            }
            ++sourceIndex;
        }
        return entries;
    }

    public static int compactDefaultTableModel(DefaultTableModel defaultTableModel) {
        int destIndex = 0;
        int lastSourceIndexNonEmpty = -1;
        int count = 0;
        int sourceIndex = 0;
        while (sourceIndex < defaultTableModel.getRowCount()) {
            Object object = defaultTableModel.getValueAt(sourceIndex, 0);
            if (object != null) {
                String entry = object.toString().trim();
                if (!(entry = entry.trim()).isEmpty()) {
                    lastSourceIndexNonEmpty = sourceIndex;
                    defaultTableModel.setValueAt(entry, destIndex++, 0);
                    ++count;
                }
            }
            ++sourceIndex;
        }
        if (-1 != lastSourceIndexNonEmpty) {
            while (destIndex <= lastSourceIndexNonEmpty) {
                defaultTableModel.setValueAt("", destIndex++, 0);
            }
        }
        return count;
    }

    public static ArrayList<String> getArrayListOfSelectableSwitchDirectionIndicators(ArrayList<CodeButtonHandlerData> codeButtonHandlerDataList) {
        ArrayList<String> returnValue = new ArrayList<String>();
        for (CodeButtonHandlerData codeButtonHandlerData : codeButtonHandlerDataList) {
            if (!codeButtonHandlerData._mSWDI_NormalInternalSensor.getHandleName().isEmpty()) {
                returnValue.add(codeButtonHandlerData._mSWDI_NormalInternalSensor.getHandleName());
            }
            if (codeButtonHandlerData._mSWDI_ReversedInternalSensor.getHandleName().isEmpty()) continue;
            returnValue.add(codeButtonHandlerData._mSWDI_ReversedInternalSensor.getHandleName());
        }
        return returnValue;
    }

    public static ArrayList<Integer> getArrayListOfSelectableOSSectionUniqueIDs(ArrayList<CodeButtonHandlerData> codeButtonHandlerDataList) {
        ArrayList<Integer> returnValue = new ArrayList<Integer>();
        for (CodeButtonHandlerData codeButtonHandlerData : codeButtonHandlerDataList) {
            returnValue.add(codeButtonHandlerData._mUniqueID);
        }
        return returnValue;
    }

    public static void populateJComboBoxWithColumnDescriptionsAndSelectViaUniqueID(JComboBox<String> jComboBox, CTCSerialData ctcSerialData, int uniqueID) {
        CommonSubs.populateJComboBoxWithColumnDescriptions(jComboBox, ctcSerialData);
        CommonSubs.setSelectedIndexOfJComboBoxViaUniqueID(jComboBox, ctcSerialData, uniqueID);
    }

    public static void populateJComboBoxWithColumnDescriptions(JComboBox<String> jComboBox, CTCSerialData ctcSerialData) {
        ArrayList<String> userDescriptions = new ArrayList<String>();
        userDescriptions.add("");
        ArrayList<Integer> arrayListOfSelectableOSSectionUniqueIDs = CommonSubs.getArrayListOfSelectableOSSectionUniqueIDs(ctcSerialData.getCodeButtonHandlerDataArrayList());
        for (Integer uniqueID : arrayListOfSelectableOSSectionUniqueIDs) {
            userDescriptions.add(ctcSerialData.getMyShortStringNoCommaViaUniqueID(uniqueID));
        }
        jComboBox.setModel(new DefaultComboBoxModel(new Vector(userDescriptions)));
    }

    public static boolean populateJComboBoxWithColumnDescriptionsExceptOurs(JComboBox<String> jComboBox, CTCSerialData ctcSerialData, int ourUniqueID, ArrayList<Integer> uniqueIDS) {
        ArrayList<String> userDescriptions = new ArrayList<String>();
        uniqueIDS.clear();
        ArrayList<Integer> arrayListOfSelectableOSSectionUniqueIDs = CommonSubs.getArrayListOfSelectableOSSectionUniqueIDs(ctcSerialData.getCodeButtonHandlerDataArrayList());
        for (Integer uniqueID : arrayListOfSelectableOSSectionUniqueIDs) {
            if (ourUniqueID == uniqueID) continue;
            userDescriptions.add(ctcSerialData.getMyShortStringNoCommaViaUniqueID(uniqueID));
            uniqueIDS.add(uniqueID);
        }
        jComboBox.setModel(new DefaultComboBoxModel(new Vector(userDescriptions)));
        return !userDescriptions.isEmpty();
    }

    public static void populateJComboBoxWithBeans(JComboBox<String> jComboBox, String beanType, String currentSelection, boolean firstRowBlank) {
        jComboBox.removeAllItems();
        jComboBox.setEditable(false);
        ArrayList<String> list = new ArrayList<String>();
        switch (beanType) {
            case "Sensor": {
                InstanceManager.getDefault(SensorManager.class).getNamedBeanSet().forEach(s -> list.add(s.getDisplayName()));
                break;
            }
            case "Turnout": {
                InstanceManager.getDefault(TurnoutManager.class).getNamedBeanSet().forEach(t -> list.add(t.getDisplayName()));
                break;
            }
            case "SignalHead": {
                InstanceManager.getDefault(SignalHeadManager.class).getNamedBeanSet().forEach(h -> list.add(h.getDisplayName()));
                break;
            }
            case "SignalMast": {
                InstanceManager.getDefault(SignalMastManager.class).getNamedBeanSet().forEach(m -> list.add(m.getDisplayName()));
                break;
            }
            case "Block": {
                InstanceManager.getDefault(BlockManager.class).getNamedBeanSet().forEach(b -> list.add(b.getDisplayName()));
                break;
            }
            default: {
                log.error(Bundle.getMessage("CommonSubsBeanType"), (Object)beanType);
            }
        }
        list.sort(new AlphanumComparator());
        list.forEach(item -> jComboBox.addItem((String)item));
        JComboBoxUtil.setupComboBoxMaxRows(jComboBox);
        jComboBox.setSelectedItem(currentSelection);
        if (firstRowBlank) {
            jComboBox.insertItemAt("", 0);
            if (currentSelection == null || currentSelection.isEmpty()) {
                jComboBox.setSelectedIndex(0);
            }
        }
    }

    public static void setSelectedIndexOfJComboBoxViaUniqueID(JComboBox<String> jComboBox, CTCSerialData ctcSerialData, int uniqueID) {
        int index = ctcSerialData.getIndexOfUniqueID(uniqueID) + 1;
        jComboBox.setSelectedIndex(index);
    }

    public static void numberButtonGroup(ButtonGroup buttonGroup) {
        int entry = 0;
        Enumeration<AbstractButton> buttons = buttonGroup.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            button.setActionCommand(Integer.toString(entry++));
        }
    }

    public static void setButtonSelected(ButtonGroup buttonGroup, int selected) {
        ArrayList<AbstractButton> buttons = Collections.list(buttonGroup.getElements());
        if (buttons.isEmpty()) {
            return;
        }
        if (selected < 0 || selected >= buttons.size()) {
            selected = 0;
        }
        AbstractButton buttonSelected = buttons.get(selected);
        buttonSelected.setSelected(true);
        ActionEvent actionEvent = new ActionEvent(buttonSelected, 1001, buttonSelected.getActionCommand());
        ActionListener[] actionListenerArray = buttonSelected.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener actionListener = actionListenerArray[n2];
            actionListener.actionPerformed(actionEvent);
            ++n2;
        }
    }

    public static boolean missingFieldsErrorDialogDisplayed(Component parentComponent, ArrayList<String> errors, boolean isCancel) {
        if (errors.isEmpty()) {
            return false;
        }
        StringBuilder stringBuffer = new StringBuilder(errors.size() > 1 ? Bundle.getMessage("CommonSubsFieldsPlural") : Bundle.getMessage("CommonSubsFieldSingular"));
        errors.forEach(error -> {
            StringBuilder stringBuilder2 = stringBuffer.append((String)error).append("\n");
        });
        if (!isCancel) {
            stringBuffer.append(Bundle.getMessage("CommonSubsPleaseFix1"));
        } else {
            stringBuffer.append(Bundle.getMessage("CommonSubsPleaseFix2"));
        }
        JOptionPane.showMessageDialog(parentComponent, stringBuffer.toString(), Bundle.getMessage("ErrorTitle"), 0);
        return true;
    }

    public static void checkJTextFieldNotEmpty(JTextField field, JLabel promptName, ArrayList<String> errors) {
        if (!CommonSubs.isJTextFieldNotEmpty(field)) {
            errors.add(promptName.getText());
        }
    }

    public static boolean isJTextFieldNotEmpty(JTextField field) {
        return !field.getText().trim().isEmpty();
    }

    public static void checkJComboBoxNotEmpty(JComboBox<String> combo, JLabel promptName, ArrayList<String> errors) {
        if (!CommonSubs.isJComboBoxNotEmpty(combo)) {
            errors.add(promptName.getText());
        }
    }

    public static boolean isJComboBoxNotEmpty(JComboBox<String> combo) {
        return !((String)combo.getSelectedItem()).trim().isEmpty();
    }

    public static NBHSensor getNBHSensor(String newName, boolean isInternal) {
        NBHSensor sensor = null;
        if (!ProjectsCommonSubs.isNullOrEmptyString(newName) && (sensor = InstanceManager.getDefault(CtcManager.class).getNBHSensor(newName)) == null) {
            sensor = isInternal ? new NBHSensor("CommonSubs", "new sensor = ", newName, newName) : new NBHSensor("CommonSubs", "new sensor = ", newName, newName, false);
        }
        return sensor;
    }

    public static NBHTurnout getNBHTurnout(String newName, boolean feedbackDifferent) {
        NBHTurnout turnout = null;
        if (!ProjectsCommonSubs.isNullOrEmptyString(newName) && (turnout = InstanceManager.getDefault(CtcManager.class).getNBHTurnout(newName)) == null) {
            turnout = new NBHTurnout("CommonSubs", "new turnout = ", newName, newName, feedbackDifferent);
        }
        if (turnout == null) {
            turnout = new NBHTurnout("CommonSubs", "Empty turnout", "");
        }
        return turnout;
    }

    public static NBHSignal getNBHSignal(String newName) {
        NBHSignal signal = null;
        if (!ProjectsCommonSubs.isNullOrEmptyString(newName) && (signal = InstanceManager.getDefault(CtcManager.class).getNBHSignal(newName)) == null) {
            signal = new NBHSignal(newName);
        }
        return signal;
    }

    public static void addSensorToSensorList(ArrayList<NBHSensor> list, String sensorName) {
        NBHSensor sensor = CommonSubs.getNBHSensor(sensorName, false);
        if (sensor != null && sensor.valid()) {
            list.add(sensor);
        }
    }
}

