/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc.editor.code;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwtWindowProperties {
    private final Window _mMasterWindow;
    private final String CTC_PACKAGE;
    Point pt = null;
    Dimension dim = null;
    private static final Logger log = LoggerFactory.getLogger(AwtWindowProperties.class);

    public AwtWindowProperties(Window window, String filename, String windowName) {
        this._mMasterWindow = window;
        this.CTC_PACKAGE = this.getClass().getPackage().getName();
        this.setWindowState(window, windowName);
    }

    public final void setWindowState(Window window, String windowName) {
        Rectangle currentWindowRectangle = window.getBounds();
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> {
            this.pt = prefMgr.getWindowLocation(String.valueOf(this.CTC_PACKAGE) + windowName);
            this.dim = prefMgr.getWindowSize(String.valueOf(this.CTC_PACKAGE) + windowName);
        });
        log.debug("{} :: {} :: {}", new Object[]{windowName, this.pt, this.dim});
        if (this.pt == null) {
            this.pt = new Point(this._mMasterWindow.getX(), this._mMasterWindow.getY());
        }
        if (this.dim == null) {
            int windowWidth = (int)currentWindowRectangle.getWidth();
            int windowHeight = (int)currentWindowRectangle.getHeight();
            this.dim = new Dimension(windowWidth, windowHeight);
        }
        window.setBounds(new Rectangle(this.pt, this.dim));
    }

    public void saveWindowState(Window window, String windowName) {
        Rectangle rectangle = window.getBounds();
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> {
            prefMgr.setWindowLocation(String.valueOf(this.CTC_PACKAGE) + windowName, new Point((int)rectangle.getX(), (int)rectangle.getY()));
            prefMgr.setWindowSize(String.valueOf(this.CTC_PACKAGE) + windowName, new Dimension((int)rectangle.getWidth(), (int)rectangle.getHeight()));
        });
    }

    public void saveWindowStateAndClose(Window window, String windowName) {
        this.saveWindowState(window, windowName);
    }
}

