/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc.ctcserialdata;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.jmrit.ctc.CtcManager;
import jmri.jmrit.ctc.NBHSignal;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectsCommonSubs {
    public static final char SSV_SEPARATOR = ';';
    private static final Logger log = LoggerFactory.getLogger(ProjectsCommonSubs.class);

    public static ArrayList<String> getArrayListFromCSV(String csvString) {
        return ProjectsCommonSubs.helper1(csvString, CSVFormat.DEFAULT.getDelimiter());
    }

    public static ArrayList<String> getArrayListFromSSV(String ssvString) {
        return ProjectsCommonSubs.helper1(ssvString, ';');
    }

    private static ArrayList<String> helper1(String ssvString, char separator) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (CSVParser parser = new CSVParser((Reader)new StringReader(ssvString), CSVFormat.DEFAULT.withQuote(null).withDelimiter(separator).withRecordSeparator(null));){
                parser.getRecords().forEach(record -> record.forEach(item -> {
                    boolean bl = list.add((String)item);
                }));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            log.error("Unable to parse {}", (Object)ssvString, (Object)ex);
        }
        return list;
    }

    public static ArrayList<String> getArrayListOfSignalNames(ArrayList<NBHSignal> array) {
        ArrayList<String> stringList = new ArrayList<String>();
        array.forEach(row -> {
            NamedBeanHandle handle = (NamedBeanHandle)row.getBeanHandle();
            stringList.add(handle.getName());
        });
        return stringList;
    }

    public static ArrayList<NBHSignal> getArrayListOfSignals(ArrayList<String> signalNames) {
        CtcManager cm = InstanceManager.getDefault(CtcManager.class);
        ArrayList<NBHSignal> newList = new ArrayList<NBHSignal>();
        signalNames.forEach(name -> {
            NBHSignal newSignal = cm.getNBHSignal((String)name);
            if (newSignal == null) {
                newSignal = new NBHSignal((String)name);
            }
            if (newSignal.valid()) {
                newList.add(newSignal);
            }
        });
        return newList;
    }

    public static ArrayList<String> getFixedArrayListSizeFromCSV(String csvString, int returnArrayListSize) {
        ArrayList<String> returnArray = ProjectsCommonSubs.getArrayListFromCSV(csvString);
        while (returnArray.size() < returnArrayListSize) {
            returnArray.add("");
        }
        return returnArray;
    }

    public static int getIntFromStringNoThrow(String aString, int defaultValueIfProblem) {
        int returnValue = defaultValueIfProblem;
        try {
            returnValue = Integer.parseInt(aString);
        }
        catch (NumberFormatException numberFormatException) {}
        return returnValue;
    }

    public static boolean isNullOrEmptyString(String aString) {
        return aString == null || aString.trim().length() == 0;
    }

    public static int getButtonSelectedInt(ButtonGroup buttonGroup) {
        try {
            return Integer.parseInt(ProjectsCommonSubs.getButtonSelectedString(buttonGroup));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static String getButtonSelectedString(ButtonGroup buttonGroup) {
        return buttonGroup.getSelection().getActionCommand();
    }
}

