/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc.configurexml;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.ctc.CTCFiles;
import jmri.jmrit.ctc.CtcManager;
import jmri.jmrit.ctc.NBHSensor;
import jmri.jmrit.ctc.NBHSignal;
import jmri.jmrit.ctc.NBHTurnout;
import jmri.jmrit.ctc.configurexml.ImportCodeButtonHandlerData;
import jmri.jmrit.ctc.configurexml.ImportOtherData;
import jmri.jmrit.ctc.ctcserialdata.CallOnData;
import jmri.jmrit.ctc.ctcserialdata.CallOnEntry;
import jmri.jmrit.ctc.ctcserialdata.CodeButtonHandlerData;
import jmri.jmrit.ctc.ctcserialdata.OtherData;
import jmri.jmrit.ctc.ctcserialdata.ProjectsCommonSubs;
import jmri.jmrit.ctc.ctcserialdata.TrafficLockingData;
import jmri.jmrit.ctc.ctcserialdata.TrafficLockingEntry;
import jmri.jmrit.ctc.editor.code.CodeButtonHandlerDataRoutines;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportExternalData {
    static final CtcManager cm = InstanceManager.getDefault(CtcManager.class);
    static ImportOtherData _mImportOtherData;
    static ArrayList<ImportCodeButtonHandlerData> _mImportCodeButtonHandlerDataArrayList;
    private static final String CTC_FILE_NAME = "CTCSystem.xml";
    private static final String PROG_PROPS = "ProgramProperties.xml";
    private static final String TEMPORARY_EXTENSION = ".xmlTMP";
    private static final String SAVED_PREFIX = "V1_Save_";
    private static final Logger log;

    static {
        _mImportCodeButtonHandlerDataArrayList = new ArrayList();
        log = LoggerFactory.getLogger(ImportExternalData.class);
    }

    public static void loadExternalData() {
        String backName = "V1_Save_CTCSystem.xml";
        if (!CTCFiles.fileExists(backName) && !CTCFiles.copyFile(CTC_FILE_NAME, backName, false)) {
            log.warn("Unable to make version 1 copy: source = {}, backup = {}", (Object)CTC_FILE_NAME, (Object)backName);
            return;
        }
        backName = "V1_Save_ProgramProperties.xml";
        if (!CTCFiles.fileExists(backName) && !CTCFiles.copyFile(PROG_PROPS, backName, false)) {
            log.warn("Unable to make version 1 copy: source = {}, backup = {}", (Object)PROG_PROPS, (Object)backName);
            return;
        }
        cm.getProgramProperties().importExternalProgramProperties();
        if (ImportExternalData.loadCTCSystemContent()) {
            ImportExternalData.doDataLoading();
        }
        if (!CTCFiles.deleteFile(CTC_FILE_NAME)) {
            log.error("Delete failed for old CTCSystem.xml");
        }
        if (!CTCFiles.deleteFile(PROG_PROPS)) {
            log.error("Delete failed for old ProgramProperties.xml");
        }
    }

    public static boolean loadCTCSystemContent() {
        String fullName = CTCFiles.getFullName(CTC_FILE_NAME);
        ImportCodeButtonHandlerData.preprocessingUpgradeSelf(fullName);
        try {
            ImportExternalData.convertClassNameReferences(CTC_FILE_NAME);
        }
        catch (Exception ex) {
            log.error("Exception occurred converting the class names in CTCSystem.xml: ex = {}", (Object)ex.getMessage());
            return false;
        }
        try {
            Throwable ex = null;
            Iterator<ImportCodeButtonHandlerData> iterator = null;
            try (XMLDecoder xmlDecoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(fullName)));){
                _mImportOtherData = (ImportOtherData)xmlDecoder.readObject();
                _mImportCodeButtonHandlerDataArrayList = (ArrayList)xmlDecoder.readObject();
            }
            catch (Throwable throwable) {
                if (ex == null) {
                    ex = throwable;
                } else if (ex != throwable) {
                    ex.addSuppressed(throwable);
                }
                throw ex;
            }
        }
        catch (IOException e) {
            log.debug("Unable to read {}", (Object)CTC_FILE_NAME, (Object)e);
        }
        if (_mImportOtherData == null) {
            log.error("---------  Import failed");
            return false;
        }
        _mImportOtherData.upgradeSelf();
        for (ImportCodeButtonHandlerData codeButtonHandlerData : _mImportCodeButtonHandlerDataArrayList) {
            codeButtonHandlerData.upgradeSelf();
        }
        return true;
    }

    @SuppressFBWarnings(value={"OS_OPEN_STREAM_EXCEPTION_PATH"}, justification="Low risk due to rare usage")
    private static void convertClassNameReferences(String fileName) throws Exception {
        String temporaryFilename = String.valueOf(fileName) + TEMPORARY_EXTENSION;
        int errors = 0;
        if (!CTCFiles.deleteFile(temporaryFilename)) {
            ++errors;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(CTCFiles.getFullName(fileName)));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(CTCFiles.getFullName(temporaryFilename)));
        String aLine = null;
        while ((aLine = bufferedReader.readLine()) != null) {
            aLine = aLine.replaceFirst("jmri.jmrit.ctc.ctcserialdata.", "jmri.jmrit.ctc.configurexml.Import");
            ImportExternalData.writeLine(bufferedWriter, aLine);
        }
        bufferedReader.close();
        bufferedWriter.close();
        if (!CTCFiles.deleteFile(fileName)) {
            ++errors;
        }
        if (!CTCFiles.renameFile(temporaryFilename, fileName, false)) {
            ++errors;
        }
        log.debug("convertClassNameReferences: errors = {}", (Object)errors);
    }

    private static void writeLine(BufferedWriter bufferedWriter, String aLine) throws IOException {
        bufferedWriter.write(aLine);
        bufferedWriter.newLine();
    }

    static void doDataLoading() {
        ImportExternalData.loadOtherData();
        _mImportCodeButtonHandlerDataArrayList.forEach(imp -> ImportExternalData.loadCodeButtonHandlerData(imp));
        ImportExternalData.convertCallOnSensorNamesToNBHSensors();
    }

    static void loadCodeButtonHandlerData(ImportCodeButtonHandlerData oldCBHD) {
        log.debug("------------- Create CBHD ------------");
        int _mUniqueID = oldCBHD._mUniqueID;
        int _mSwitchNumber = oldCBHD._mSwitchNumber;
        int _mSignalEtcNumber = oldCBHD._mSignalEtcNumber;
        int _mGUIColumnNumber = oldCBHD._mGUIColumnNumber;
        CodeButtonHandlerData cbhd = CodeButtonHandlerDataRoutines.createNewCodeButtonHandlerData(_mUniqueID, _mSwitchNumber, _mSignalEtcNumber, _mGUIColumnNumber, cm.getProgramProperties());
        cm.getCTCSerialData().addCodeButtonHandlerData(cbhd);
        log.debug("------------- Code ------------");
        cbhd._mCodeButtonInternalSensor = ImportExternalData.loadSensor(oldCBHD._mCodeButtonInternalSensor, true);
        cbhd._mOSSectionOccupiedExternalSensor = ImportExternalData.loadSensor(oldCBHD._mOSSectionOccupiedExternalSensor, false);
        cbhd._mOSSectionOccupiedExternalSensor2 = ImportExternalData.loadSensor(oldCBHD._mOSSectionOccupiedExternalSensor2, false);
        cbhd._mOSSectionSwitchSlavedToUniqueID = oldCBHD._mOSSectionSwitchSlavedToUniqueID;
        cbhd._mGUIGeneratedAtLeastOnceAlready = oldCBHD._mGUIGeneratedAtLeastOnceAlready;
        cbhd._mCodeButtonDelayTime = oldCBHD._mCodeButtonDelayTime;
        log.debug("------------- SIDI ------------");
        cbhd._mSIDI_Enabled = oldCBHD._mSIDI_Enabled;
        cbhd._mSIDI_LeftInternalSensor = ImportExternalData.loadSensor(oldCBHD._mSIDI_LeftInternalSensor, true);
        cbhd._mSIDI_NormalInternalSensor = ImportExternalData.loadSensor(oldCBHD._mSIDI_NormalInternalSensor, true);
        cbhd._mSIDI_RightInternalSensor = ImportExternalData.loadSensor(oldCBHD._mSIDI_RightInternalSensor, true);
        cbhd._mSIDI_CodingTimeInMilliseconds = oldCBHD._mSIDI_CodingTimeInMilliseconds;
        cbhd._mSIDI_TimeLockingTimeInMilliseconds = oldCBHD._mSIDI_TimeLockingTimeInMilliseconds;
        cbhd._mSIDI_LeftRightTrafficSignals = ImportExternalData.getSignalList(oldCBHD._mSIDI_LeftRightTrafficSignalsCSVList);
        cbhd._mSIDI_RightLeftTrafficSignals = ImportExternalData.getSignalList(oldCBHD._mSIDI_RightLeftTrafficSignalsCSVList);
        String trafficDirection = "BOTH";
        if (oldCBHD._mSIDI_LeftInternalSensor.isEmpty() && !oldCBHD._mSIDI_RightInternalSensor.isEmpty()) {
            trafficDirection = "RIGHT";
        } else if (!oldCBHD._mSIDI_LeftInternalSensor.isEmpty() && oldCBHD._mSIDI_RightInternalSensor.isEmpty()) {
            trafficDirection = "LEFT";
        }
        cbhd._mSIDI_TrafficDirection = CodeButtonHandlerData.TRAFFIC_DIRECTION.valueOf(trafficDirection);
        log.debug("------------- SIDL ------------");
        cbhd._mSIDL_Enabled = oldCBHD._mSIDL_Enabled;
        cbhd._mSIDL_LeftInternalSensor = ImportExternalData.loadSensor(oldCBHD._mSIDL_LeftInternalSensor, true);
        cbhd._mSIDL_NormalInternalSensor = ImportExternalData.loadSensor(oldCBHD._mSIDL_NormalInternalSensor, true);
        cbhd._mSIDL_RightInternalSensor = ImportExternalData.loadSensor(oldCBHD._mSIDL_RightInternalSensor, true);
        log.debug("------------- SWDI ------------");
        cbhd._mSWDI_Enabled = oldCBHD._mSWDI_Enabled;
        cbhd._mSWDI_NormalInternalSensor = ImportExternalData.loadSensor(oldCBHD._mSWDI_NormalInternalSensor, true);
        cbhd._mSWDI_ReversedInternalSensor = ImportExternalData.loadSensor(oldCBHD._mSWDI_ReversedInternalSensor, true);
        cbhd._mSWDI_FeedbackDifferent = oldCBHD._mSWDI_FeedbackDifferent;
        cbhd._mSWDI_ExternalTurnout = ImportExternalData.loadTurnout(oldCBHD._mSWDI_ExternalTurnout, oldCBHD._mSWDI_FeedbackDifferent);
        cbhd._mSWDI_CodingTimeInMilliseconds = oldCBHD._mSWDI_CodingTimeInMilliseconds;
        cbhd._mSWDI_GUITurnoutType = CodeButtonHandlerData.TURNOUT_TYPE.valueOf(oldCBHD._mSWDI_GUITurnoutType.toString());
        cbhd._mSWDI_GUITurnoutLeftHand = oldCBHD._mSWDI_GUITurnoutLeftHand;
        cbhd._mSWDI_GUICrossoverLeftHand = oldCBHD._mSWDI_GUICrossoverLeftHand;
        log.debug("------------- SWDL ------------");
        cbhd._mSWDL_Enabled = oldCBHD._mSWDL_Enabled;
        cbhd._mSWDL_InternalSensor = ImportExternalData.loadSensor(oldCBHD._mSWDL_InternalSensor, true);
        log.debug("-------------  CO  ------------");
        cbhd._mCO_Enabled = oldCBHD._mCO_Enabled;
        cbhd._mCO_CallOnToggleInternalSensor = ImportExternalData.loadSensor(oldCBHD._mCO_CallOnToggleInternalSensor, true);
        cbhd._mCO_GroupingsList = ImportExternalData.getCallOnList(oldCBHD._mCO_GroupingsListString);
        log.debug("------------- TRL  ------------");
        cbhd._mTRL_Enabled = oldCBHD._mTRL_Enabled;
        cbhd._mTRL_LeftTrafficLockingRules = ImportExternalData.getTrafficLocking(oldCBHD._mTRL_LeftTrafficLockingRulesSSVList);
        cbhd._mTRL_RightTrafficLockingRules = ImportExternalData.getTrafficLocking(oldCBHD._mTRL_RightTrafficLockingRulesSSVList);
        log.debug("------------- TUL  ------------");
        cbhd._mTUL_Enabled = oldCBHD._mTUL_Enabled;
        cbhd._mTUL_DispatcherInternalSensorLockToggle = ImportExternalData.loadSensor(oldCBHD._mTUL_DispatcherInternalSensorLockToggle, true);
        cbhd._mTUL_ExternalTurnoutFeedbackDifferent = oldCBHD._mTUL_ExternalTurnoutFeedbackDifferent;
        cbhd._mTUL_ExternalTurnout = ImportExternalData.loadTurnout(oldCBHD._mTUL_ExternalTurnout, oldCBHD._mTUL_ExternalTurnoutFeedbackDifferent);
        cbhd._mTUL_DispatcherInternalSensorUnlockedIndicator = ImportExternalData.loadSensor(oldCBHD._mTUL_DispatcherInternalSensorUnlockedIndicator, true);
        cbhd._mTUL_NoDispatcherControlOfSwitch = oldCBHD._mTUL_NoDispatcherControlOfSwitch;
        cbhd._mTUL_ndcos_WhenLockedSwitchStateIsClosed = oldCBHD._mTUL_ndcos_WhenLockedSwitchStateIsClosed;
        cbhd._mTUL_GUI_IconsEnabled = cbhd._mTUL_DispatcherInternalSensorLockToggle.valid();
        cbhd._mTUL_LockImplementation = CodeButtonHandlerData.LOCK_IMPLEMENTATION.valueOf(oldCBHD._mTUL_LockImplementation.toString());
        cbhd._mTUL_AdditionalExternalTurnout1 = ImportExternalData.loadTurnout(oldCBHD._mTUL_AdditionalExternalTurnout1, oldCBHD._mTUL_AdditionalExternalTurnout1FeedbackDifferent);
        cbhd._mTUL_AdditionalExternalTurnout2 = ImportExternalData.loadTurnout(oldCBHD._mTUL_AdditionalExternalTurnout2, oldCBHD._mTUL_AdditionalExternalTurnout2FeedbackDifferent);
        cbhd._mTUL_AdditionalExternalTurnout3 = ImportExternalData.loadTurnout(oldCBHD._mTUL_AdditionalExternalTurnout3, oldCBHD._mTUL_AdditionalExternalTurnout3FeedbackDifferent);
        cbhd._mTUL_AdditionalExternalTurnout1FeedbackDifferent = oldCBHD._mTUL_AdditionalExternalTurnout1FeedbackDifferent;
        cbhd._mTUL_AdditionalExternalTurnout2FeedbackDifferent = oldCBHD._mTUL_AdditionalExternalTurnout2FeedbackDifferent;
        cbhd._mTUL_AdditionalExternalTurnout3FeedbackDifferent = oldCBHD._mTUL_AdditionalExternalTurnout3FeedbackDifferent;
        log.debug("-------------  IL  ------------");
        cbhd._mIL_Enabled = oldCBHD._mIL_Enabled;
        cbhd._mIL_Signals = ImportExternalData.getSignalList(oldCBHD._mIL_ListOfCSVSignalNames);
    }

    static void loadOtherData() {
        OtherData od = cm.getOtherData();
        od._mFleetingToggleInternalSensor = ImportExternalData.loadSensor(ImportExternalData._mImportOtherData._mFleetingToggleInternalSensor, true);
        od._mDefaultFleetingEnabled = ImportExternalData._mImportOtherData._mDefaultFleetingEnabled;
        od._mTUL_EnabledAtStartup = ImportExternalData._mImportOtherData._mTUL_EnabledAtStartup;
        od._mSignalSystemType = OtherData.SIGNAL_SYSTEM_TYPE.valueOf(ImportExternalData._mImportOtherData._mSignalSystemType.toString());
        od._mTUL_SecondsToLockTurnouts = ImportExternalData._mImportOtherData._mTUL_SecondsToLockTurnouts;
        od._mNextUniqueNumber = ImportExternalData._mImportOtherData._mNextUniqueNumber;
        od._mCTCDebugSystemReloadInternalSensor = ImportExternalData.loadSensor(ImportExternalData._mImportOtherData._mCTCDebugSystemReloadInternalSensor, true);
        od._mCTCDebug_TrafficLockingRuleTriggeredDisplayInternalSensor = ImportExternalData.loadSensor(ImportExternalData._mImportOtherData._mCTCDebug_TrafficLockingRuleTriggeredDisplayInternalSensor, true);
        od._mGUIDesign_NumberOfEmptyColumnsAtEnd = ImportExternalData._mImportOtherData._mGUIDesign_NumberOfEmptyColumnsAtEnd;
        od._mGUIDesign_CTCPanelType = OtherData.CTC_PANEL_TYPE.valueOf(ImportExternalData._mImportOtherData._mGUIDesign_CTCPanelType.toString());
        od._mGUIDesign_BuilderPlate = ImportExternalData._mImportOtherData._mGUIDesign_BuilderPlate;
        od._mGUIDesign_SignalsOnPanel = OtherData.SIGNALS_ON_PANEL.valueOf(ImportExternalData._mImportOtherData._mGUIDesign_SignalsOnPanel.toString());
        od._mGUIDesign_FleetingToggleSwitch = ImportExternalData._mImportOtherData._mGUIDesign_FleetingToggleSwitch;
        od._mGUIDesign_AnalogClockEtc = ImportExternalData._mImportOtherData._mGUIDesign_AnalogClockEtc;
        od._mGUIDesign_ReloadCTCSystemButton = ImportExternalData._mImportOtherData._mGUIDesign_ReloadCTCSystemButton;
        od._mGUIDesign_CTCDebugOnToggle = ImportExternalData._mImportOtherData._mGUIDesign_CTCDebugOnToggle;
        od._mGUIDesign_CreateTrackPieces = ImportExternalData._mImportOtherData._mGUIDesign_CreateTrackPieces;
        od._mGUIDesign_VerticalSize = OtherData.VERTICAL_SIZE.valueOf(ImportExternalData._mImportOtherData._mGUIDesign_VerticalSize.toString());
        od._mGUIDesign_OSSectionUnknownInconsistentRedBlink = ImportExternalData._mImportOtherData._mGUIDesign_OSSectionUnknownInconsistentRedBlink;
        od._mGUIDesign_TurnoutsOnPanel = ImportExternalData._mImportOtherData._mGUIDesign_TurnoutsOnPanel;
    }

    static int loadInt(String value) {
        int newInt = 0;
        if (value != null) {
            try {
                newInt = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                log.warn("loadInt format exception: value = {}", (Object)value);
            }
        }
        return newInt;
    }

    static NBHSensor loadSensor(String value, boolean isInternal) {
        NBHSensor sensor = null;
        if (value != null && !value.isEmpty()) {
            String sensorName = value;
            sensor = cm.getNBHSensor(sensorName);
            if (sensor == null) {
                sensor = isInternal ? new NBHSensor("CtcManagerXml", "create internal = ", sensorName, sensorName) : new NBHSensor("CtcManagerXml", "create standard = ", sensorName, sensorName, false);
            }
        } else {
            sensor = new NBHSensor("CtcManagerXml", "", "Empty NBHSensor", "", true);
        }
        return sensor;
    }

    static NBHSignal loadSignal(String signalName) {
        NBHSignal signal = null;
        if (signalName != null && !signalName.isEmpty()) {
            signal = cm.getNBHSignal(signalName);
            if (signal == null) {
                signal = new NBHSignal(signalName);
            }
        } else {
            signal = new NBHSignal("");
        }
        return signal;
    }

    static NBHTurnout loadTurnout(String value, boolean feedback) {
        NBHTurnout turnout = null;
        if (value != null && !value.isEmpty()) {
            String turnoutName = value;
            turnout = cm.getNBHTurnout(turnoutName);
            if (turnout == null) {
                turnout = new NBHTurnout("CtcManagerXml", "", value, value, feedback);
            }
        } else {
            turnout = new NBHTurnout("CtcManagerXml", "Empty NBHTurnout", "");
        }
        return turnout;
    }

    static NamedBeanHandle<Block> loadBlock(String value) {
        Block block;
        NamedBeanHandle<Block> blockHandle = null;
        if (value != null && !value.isEmpty() && (blockHandle = cm.getBlock(value)) == null && (block = InstanceManager.getDefault(BlockManager.class).getBlock(value)) != null) {
            blockHandle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(value, block);
            cm.putBlock(value, blockHandle);
        }
        return blockHandle;
    }

    static ArrayList<NBHSignal> getSignalList(String value) {
        ArrayList<NBHSignal> signalList = new ArrayList<NBHSignal>();
        if (value != null) {
            for (String signalName : ProjectsCommonSubs.getArrayListFromCSV(value)) {
                NBHSignal signal = ImportExternalData.loadSignal(signalName);
                signalList.add(signal);
            }
        }
        return signalList;
    }

    static ArrayList<CallOnData> getCallOnList(String value) {
        ArrayList<CallOnData> callOnList = new ArrayList<CallOnData>();
        for (String csvString : ProjectsCommonSubs.getArrayListFromSSV(value)) {
            CallOnData cod = new CallOnData();
            CallOnEntry entry = new CallOnEntry(csvString);
            cod._mExternalSignal = ImportExternalData.loadSignal(entry._mExternalSignal);
            cod._mSignalFacingDirection = entry._mSignalFacingDirection;
            cod._mSignalAspectToDisplay = entry._mSignalAspectToDisplay;
            cod._mCalledOnExternalSensor = ImportExternalData.loadSensor(entry._mCalledOnExternalSensor, false);
            cod._mExternalBlock = ImportExternalData.loadBlock(entry._mExternalBlock);
            cod._mSwitchIndicators = new ArrayList();
            cod._mSwitchIndicatorNames = ImportExternalData.getCallOnSensorNames(entry);
            callOnList.add(cod);
        }
        return callOnList;
    }

    static ArrayList<String> getCallOnSensorNames(CallOnEntry entry) {
        ArrayList<String> sensorList = new ArrayList<String>();
        if (!entry._mSwitchIndicator1.isEmpty()) {
            sensorList.add(entry._mSwitchIndicator1);
        }
        if (!entry._mSwitchIndicator2.isEmpty()) {
            sensorList.add(entry._mSwitchIndicator2);
        }
        if (!entry._mSwitchIndicator3.isEmpty()) {
            sensorList.add(entry._mSwitchIndicator3);
        }
        if (!entry._mSwitchIndicator4.isEmpty()) {
            sensorList.add(entry._mSwitchIndicator4);
        }
        if (!entry._mSwitchIndicator5.isEmpty()) {
            sensorList.add(entry._mSwitchIndicator5);
        }
        if (!entry._mSwitchIndicator6.isEmpty()) {
            sensorList.add(entry._mSwitchIndicator6);
        }
        return sensorList;
    }

    static void convertCallOnSensorNamesToNBHSensors() {
        for (CodeButtonHandlerData cbhd : cm.getCTCSerialData().getCodeButtonHandlerDataArrayList()) {
            for (CallOnData cod : cbhd._mCO_GroupingsList) {
                for (String sensorName : cod._mSwitchIndicatorNames) {
                    NBHSensor sensor = cm.getNBHSensor(sensorName);
                    if (sensor == null) continue;
                    cod._mSwitchIndicators.add(sensor);
                }
            }
        }
    }

    static ArrayList<TrafficLockingData> getTrafficLocking(String value) {
        ArrayList<TrafficLockingData> trlData = new ArrayList<TrafficLockingData>();
        for (String csvString : ProjectsCommonSubs.getArrayListFromSSV(value)) {
            TrafficLockingData trl = new TrafficLockingData();
            TrafficLockingEntry entry = new TrafficLockingEntry(csvString);
            trl._mUserRuleNumber = entry._mUserRuleNumber;
            trl._mRuleEnabled = entry._mRuleEnabled;
            trl._mDestinationSignalOrComment = entry._mDestinationSignalOrComment;
            trl._mSwitchAlignments = ImportExternalData.getTRLSwitchList(entry);
            trl._mOccupancyExternalSensors = ImportExternalData.getTRLSensorList(entry, true);
            trl._mOptionalExternalSensors = ImportExternalData.getTRLSensorList(entry, false);
            trlData.add(trl);
        }
        return trlData;
    }

    static ArrayList<TrafficLockingData.TRLSwitch> getTRLSwitchList(TrafficLockingEntry entry) {
        ArrayList<TrafficLockingData.TRLSwitch> trlSwitches = new ArrayList<TrafficLockingData.TRLSwitch>();
        if (!entry._mUserText1.isEmpty()) {
            trlSwitches.add(ImportExternalData.createTRLSwitch(entry._mUserText1, entry._mSwitchAlignment1, entry._mUniqueID1));
        }
        if (!entry._mUserText2.isEmpty()) {
            trlSwitches.add(ImportExternalData.createTRLSwitch(entry._mUserText2, entry._mSwitchAlignment2, entry._mUniqueID2));
        }
        if (!entry._mUserText3.isEmpty()) {
            trlSwitches.add(ImportExternalData.createTRLSwitch(entry._mUserText3, entry._mSwitchAlignment3, entry._mUniqueID3));
        }
        if (!entry._mUserText4.isEmpty()) {
            trlSwitches.add(ImportExternalData.createTRLSwitch(entry._mUserText4, entry._mSwitchAlignment4, entry._mUniqueID4));
        }
        if (!entry._mUserText5.isEmpty()) {
            trlSwitches.add(ImportExternalData.createTRLSwitch(entry._mUserText5, entry._mSwitchAlignment5, entry._mUniqueID5));
        }
        return trlSwitches;
    }

    static TrafficLockingData.TRLSwitch createTRLSwitch(String text, String alignment, String id) {
        return new TrafficLockingData.TRLSwitch(text, alignment, ImportExternalData.loadInt(id));
    }

    static ArrayList<NBHSensor> getTRLSensorList(TrafficLockingEntry entry, boolean occupancy) {
        ArrayList<NBHSensor> sensorList = new ArrayList<NBHSensor>();
        if (occupancy) {
            if (!entry._mOccupancyExternalSensor1.isEmpty()) {
                sensorList.add(ImportExternalData.loadSensor(entry._mOccupancyExternalSensor1, false));
            }
            if (!entry._mOccupancyExternalSensor2.isEmpty()) {
                sensorList.add(ImportExternalData.loadSensor(entry._mOccupancyExternalSensor2, false));
            }
            if (!entry._mOccupancyExternalSensor3.isEmpty()) {
                sensorList.add(ImportExternalData.loadSensor(entry._mOccupancyExternalSensor3, false));
            }
            if (!entry._mOccupancyExternalSensor4.isEmpty()) {
                sensorList.add(ImportExternalData.loadSensor(entry._mOccupancyExternalSensor4, false));
            }
            if (!entry._mOccupancyExternalSensor5.isEmpty()) {
                sensorList.add(ImportExternalData.loadSensor(entry._mOccupancyExternalSensor5, false));
            }
            if (!entry._mOccupancyExternalSensor6.isEmpty()) {
                sensorList.add(ImportExternalData.loadSensor(entry._mOccupancyExternalSensor6, false));
            }
            if (!entry._mOccupancyExternalSensor7.isEmpty()) {
                sensorList.add(ImportExternalData.loadSensor(entry._mOccupancyExternalSensor7, false));
            }
            if (!entry._mOccupancyExternalSensor8.isEmpty()) {
                sensorList.add(ImportExternalData.loadSensor(entry._mOccupancyExternalSensor8, false));
            }
            if (!entry._mOccupancyExternalSensor9.isEmpty()) {
                sensorList.add(ImportExternalData.loadSensor(entry._mOccupancyExternalSensor9, false));
            }
        } else {
            if (!entry._mOptionalExternalSensor1.isEmpty()) {
                sensorList.add(ImportExternalData.loadSensor(entry._mOptionalExternalSensor1, false));
            }
            if (!entry._mOptionalExternalSensor2.isEmpty()) {
                sensorList.add(ImportExternalData.loadSensor(entry._mOptionalExternalSensor2, false));
            }
        }
        return sensorList;
    }
}

