/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import jmri.jmrit.ctc.Bundle;
import jmri.jmrit.ctc.CTCException;
import jmri.jmrit.ctc.NBHSensor;
import jmri.jmrit.ctc.NBHTurnout;
import jmri.jmrit.ctc.ctcserialdata.CodeButtonHandlerData;

public class TurnoutLock {
    private final NBHSensor _mDispatcherSensorLockToggle;
    private int _mCommandedState = 2;
    private ArrayList<NBHTurnout> _mTurnoutsMonitored = new ArrayList();
    private PropertyChangeListener _mTurnoutsMonitoredPropertyChangeListener = null;
    private boolean _mLocked = false;
    private NBHSensor _mDispatcherSensorUnlockedIndicator;
    private boolean _mNoDispatcherControlOfSwitch = false;
    private int _m_ndcos_WhenLockedSwitchState = 0;

    public TurnoutLock(String userIdentifier, NBHSensor dispatcherSensorLockToggle, NBHTurnout actualTurnout, boolean actualTurnoutFeedbackDifferent, NBHSensor dispatcherSensorUnlockedIndicator, boolean noDispatcherControlOfSwitch, int ndcos_WhenLockedSwitchState, CodeButtonHandlerData.LOCK_IMPLEMENTATION _mLockImplementation, boolean turnoutLocksEnabledAtStartup, NBHTurnout additionalTurnout1, boolean additionalTurnout1FeebackReversed, NBHTurnout additionalTurnout2, boolean additionalTurnout2FeebackReversed, NBHTurnout additionalTurnout3, boolean additionalTurnout3FeebackReversed) {
        this._mDispatcherSensorLockToggle = dispatcherSensorLockToggle;
        this.addTurnoutMonitored(userIdentifier, "actualTurnout", actualTurnout, actualTurnoutFeedbackDifferent, true);
        this._mDispatcherSensorUnlockedIndicator = dispatcherSensorUnlockedIndicator;
        this._mDispatcherSensorLockToggle.setKnownState(turnoutLocksEnabledAtStartup ? 4 : 2);
        this._mNoDispatcherControlOfSwitch = noDispatcherControlOfSwitch;
        this._m_ndcos_WhenLockedSwitchState = ndcos_WhenLockedSwitchState;
        this.addTurnoutMonitored(userIdentifier, "additionalTurnout1", additionalTurnout1, additionalTurnout1FeebackReversed, false);
        this.addTurnoutMonitored(userIdentifier, "additionalTurnout2", additionalTurnout2, additionalTurnout2FeebackReversed, false);
        this.addTurnoutMonitored(userIdentifier, "additionalTurnout3", additionalTurnout3, additionalTurnout3FeebackReversed, false);
        this.updateDispatcherSensorIndicator(turnoutLocksEnabledAtStartup);
        this._mTurnoutsMonitoredPropertyChangeListener = e -> this.handleTurnoutChange(e);
        for (NBHTurnout tempTurnout : this._mTurnoutsMonitored) {
            if (tempTurnout.getKnownState() == 1) {
                tempTurnout.setCommandedState(this._mCommandedState);
            }
            tempTurnout.addPropertyChangeListener(this._mTurnoutsMonitoredPropertyChangeListener);
        }
    }

    public void removeAllListeners() {
        for (NBHTurnout tempTurnout : this._mTurnoutsMonitored) {
            tempTurnout.removePropertyChangeListener(this._mTurnoutsMonitoredPropertyChangeListener);
        }
    }

    public NBHSensor getDispatcherSensorLockToggle() {
        return this._mDispatcherSensorLockToggle;
    }

    private void addTurnoutMonitored(String userIdentifier, String parameter, NBHTurnout actualTurnout, boolean FeedbackDifferent, boolean required) {
        boolean actualTurnoutPresent = actualTurnout.valid();
        if (required && !actualTurnoutPresent) {
            new CTCException("TurnoutLock", userIdentifier, parameter, Bundle.getMessage("RequiredTurnoutMissing")).logError();
            return;
        }
        if (actualTurnoutPresent && actualTurnout.valid()) {
            this._mTurnoutsMonitored.add(actualTurnout);
        }
    }

    private void handleTurnoutChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("KnownState") && this._mLocked) {
            NBHTurnout turnout = null;
            int index = 0;
            while (index < this._mTurnoutsMonitored.size()) {
                if (e.getSource() == this._mTurnoutsMonitored.get(index).getBean()) {
                    turnout = this._mTurnoutsMonitored.get(index);
                    break;
                }
                ++index;
            }
            if (turnout != null && this._mCommandedState != turnout.getKnownState()) {
                this.turnoutSetCommandedState(turnout, this._mCommandedState);
            }
        }
    }

    public void externalLockTurnout() {
        this._mDispatcherSensorLockToggle.setKnownState(4);
        this.updateDispatcherSensorIndicator(true);
    }

    public void externalUnlockTurnout() {
        this._mDispatcherSensorLockToggle.setKnownState(2);
        this.updateDispatcherSensorIndicator(false);
    }

    public void codeButtonPressed() {
        boolean newLockedState = this.getNewLockedState();
        if (newLockedState == this._mLocked) {
            return;
        }
        if (this._mNoDispatcherControlOfSwitch && newLockedState) {
            for (NBHTurnout turnout : this._mTurnoutsMonitored) {
                this.turnoutSetCommandedState(turnout, this._m_ndcos_WhenLockedSwitchState);
            }
        }
        this.updateDispatcherSensorIndicator(newLockedState);
    }

    public void dispatcherCommandedState(int commandedState) {
        this._mCommandedState = commandedState == 0 ? 2 : 4;
    }

    public boolean turnoutPresentlyLocked() {
        return this._mLocked;
    }

    public boolean getNewLockedState() {
        return this._mDispatcherSensorLockToggle.getKnownState() == 4;
    }

    public boolean tryingToChangeLockStatus() {
        return this.getNewLockedState() ^ this._mLocked;
    }

    private void turnoutSetCommandedState(NBHTurnout turnout, int state) {
        this._mCommandedState = state;
        turnout.setCommandedState(state);
    }

    private void updateDispatcherSensorIndicator(boolean newLockedState) {
        this._mLocked = newLockedState;
        this._mDispatcherSensorUnlockedIndicator.setKnownState(this._mLocked ? 4 : 2);
    }
}

