/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.Timer;
import jmri.jmrit.ctc.NBHSensor;
import jmri.jmrit.ctc.NBHTurnout;

public class SwitchDirectionIndicators {
    private NBHSensor _mNormalIndicatorSensor;
    private NBHSensor _mReversedIndicatorSensor;
    private NBHTurnout _mActualTurnout;
    private PropertyChangeListener _mActualTurnoutPropertyChangeListener = null;
    private boolean _mActualTurnoutHasFeedback;
    private boolean _mWaitingForFeedbackOrTimer = false;
    private int _mLastActualTurnoutState = -1;
    private Timer _mSimulatedTurnoutFeedbackTimer = null;
    private ActionListener _mSimulatedTurnoutFeedbackTimerActionListener = null;
    private int _mLastIndicatorState = 3;

    public SwitchDirectionIndicators(String userIdentifier, NBHSensor normalIndicatorSensor, NBHSensor reveresedIndicatorSensor, NBHTurnout actualTurnout, int codingTimeInMilliseconds, boolean feedbackDifferent) {
        this._mNormalIndicatorSensor = normalIndicatorSensor;
        this._mReversedIndicatorSensor = reveresedIndicatorSensor;
        this._mActualTurnout = actualTurnout;
        boolean bl = this._mActualTurnoutHasFeedback = this._mActualTurnout.getFeedbackMode() != 1 && this._mActualTurnout.getFeedbackMode() != 8;
        if (this._mActualTurnoutHasFeedback) {
            this._mActualTurnoutPropertyChangeListener = e -> {
                if (e.getPropertyName().equals("KnownState")) {
                    this.setSwitchIndicationSensorsToPresentState();
                }
            };
            this._mActualTurnout.addPropertyChangeListener(this._mActualTurnoutPropertyChangeListener);
            this.setSwitchIndicationSensorsToPresentState();
        } else {
            this._mSimulatedTurnoutFeedbackTimerActionListener = ActionEvent2 -> this.setSwitchIndicationSensorsToPresentState();
            this._mSimulatedTurnoutFeedbackTimer = new Timer(codingTimeInMilliseconds, this._mSimulatedTurnoutFeedbackTimerActionListener);
            this._mSimulatedTurnoutFeedbackTimer.setRepeats(false);
            this.setSwitchIndicationSensorsToPresentState();
            if (this._mLastActualTurnoutState == -1) {
                this.setSwitchIndicatorSensors(0);
            }
        }
    }

    public void removeAllListeners() {
        this._mActualTurnout.removePropertyChangeListener(this._mActualTurnoutPropertyChangeListener);
        if (this._mSimulatedTurnoutFeedbackTimer != null) {
            this._mSimulatedTurnoutFeedbackTimer.stop();
            this._mSimulatedTurnoutFeedbackTimer.removeActionListener(this._mSimulatedTurnoutFeedbackTimerActionListener);
        }
    }

    public void codeButtonPressed(int requestedState) {
        if (this._mWaitingForFeedbackOrTimer) {
            return;
        }
        if (requestedState != this._mLastActualTurnoutState) {
            this._mWaitingForFeedbackOrTimer = true;
            this.setSwitchIndicatorSensors(3);
            if (requestedState == 0) {
                this._mActualTurnout.setCommandedState(2);
            } else if (requestedState == 1) {
                this._mActualTurnout.setCommandedState(4);
            }
            if (!this._mActualTurnoutHasFeedback) {
                this._mSimulatedTurnoutFeedbackTimer.start();
            }
        }
    }

    private int getPresentState() {
        int actualTurnoutKnownState = this._mActualTurnout.getKnownState();
        this._mLastActualTurnoutState = actualTurnoutKnownState == 2 ? 0 : (actualTurnoutKnownState == 4 ? 1 : -1);
        return this._mLastActualTurnoutState;
    }

    public int getLastIndicatorState() {
        return this._mLastIndicatorState;
    }

    public boolean inCorrespondence() {
        if (this._mLastActualTurnoutState == -1) {
            return true;
        }
        return this._mLastIndicatorState != 3;
    }

    public NBHSensor getProperIndicatorSensor(boolean isNormal) {
        return isNormal ? this._mNormalIndicatorSensor : this._mReversedIndicatorSensor;
    }

    private void setSwitchIndicatorSensors(int requestedState) {
        switch (requestedState) {
            case 0: {
                this._mNormalIndicatorSensor.setKnownState(2);
                this._mReversedIndicatorSensor.setKnownState(4);
                this._mLastIndicatorState = 0;
                break;
            }
            case 1: {
                this._mNormalIndicatorSensor.setKnownState(4);
                this._mReversedIndicatorSensor.setKnownState(2);
                this._mLastIndicatorState = 1;
                break;
            }
            default: {
                this._mNormalIndicatorSensor.setKnownState(4);
                this._mReversedIndicatorSensor.setKnownState(4);
                this._mLastIndicatorState = 3;
            }
        }
    }

    private void setSwitchIndicationSensorsToPresentState() {
        if (this._mSimulatedTurnoutFeedbackTimer != null) {
            this._mSimulatedTurnoutFeedbackTimer.stop();
        }
        this._mWaitingForFeedbackOrTimer = false;
        this.setSwitchIndicatorSensors(this.getPresentState());
    }
}

