/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.Timer;
import jmri.implementation.AbstractSignalHead;
import jmri.implementation.AbstractSignalMast;
import jmri.jmrit.ctc.Bundle;
import jmri.jmrit.ctc.CTCException;
import jmri.jmrit.ctc.CodeButtonHandler;
import jmri.jmrit.ctc.Fleeting;
import jmri.jmrit.ctc.NBHSensor;
import jmri.jmrit.ctc.NBHSignal;
import jmri.jmrit.ctc.RequestedDirectionObserved;
import jmri.jmrit.ctc.SignalDirectionIndicatorsInterface;
import jmri.jmrit.ctc.ctcserialdata.CodeButtonHandlerData;

public final class SignalDirectionIndicators
implements SignalDirectionIndicatorsInterface {
    static final HashSet<NBHSignal> _mSignalsUsed = new HashSet();
    private NBHSensor _mLeftSensor;
    private NBHSensor _mNormalSensor;
    private NBHSensor _mRightSensor;
    private int _mPresentSignalDirectionLever = 1;
    private final ArrayList<NBHSignal> _mSignalListLeftRight = new ArrayList();
    private final ArrayList<NBHSignal> _mSignalListRightLeft = new ArrayList();
    private Fleeting _mFleetingObject;
    private final RequestedDirectionObserved _mRequestedDirectionObserver = new RequestedDirectionObserved();
    private final Timer _mTimeLockingTimer;
    private final ActionListener _mTimeLockingTimerActionListener;
    private final Timer _mCodingTimeTimer;
    private final ActionListener _mCodingTimeTimerActionListener;
    private int _mPresentDirection;
    private CodeButtonHandler _mCodeButtonHandler = null;
    private LinkedList<SignalHeadPropertyChangeListenerMaintainer> _mSignalHeadPropertyChangeListenerLinkedList = new LinkedList();

    public static void resetSignalsUsed() {
        _mSignalsUsed.clear();
    }

    @Override
    public void setCodeButtonHandler(CodeButtonHandler codeButtonHandler) {
        this._mCodeButtonHandler = codeButtonHandler;
    }

    public SignalDirectionIndicators(String userIdentifier, NBHSensor leftSensor, NBHSensor normalSensor, NBHSensor rightSensor, int codingTimeInMilliseconds, int timeLockingTimeInMilliseconds, CodeButtonHandlerData.TRAFFIC_DIRECTION trafficDirection, ArrayList<NBHSignal> signalListLeftRight, ArrayList<NBHSignal> signalListRightLeft, Fleeting fleetingObject) {
        if (codingTimeInMilliseconds < 100) {
            codingTimeInMilliseconds = 100;
        }
        this._mTimeLockingTimerActionListener = ActionEvent2 -> this.timeLockingDone();
        this._mTimeLockingTimer = new Timer(codingTimeInMilliseconds + timeLockingTimeInMilliseconds, this._mTimeLockingTimerActionListener);
        this._mTimeLockingTimer.setRepeats(false);
        this._mCodingTimeTimerActionListener = ActionEvent2 -> this.codingTimeDone();
        this._mCodingTimeTimer = new Timer(codingTimeInMilliseconds, this._mCodingTimeTimerActionListener);
        this._mCodingTimeTimer.setRepeats(false);
        try {
            boolean entriesInRightLeftTrafficSignalsList;
            this._mLeftSensor = leftSensor;
            this._mNormalSensor = normalSensor;
            this._mRightSensor = rightSensor;
            boolean leftTrafficDirection = trafficDirection != CodeButtonHandlerData.TRAFFIC_DIRECTION.RIGHT;
            boolean rightTrafficDirection = trafficDirection != CodeButtonHandlerData.TRAFFIC_DIRECTION.LEFT;
            boolean entriesInLeftRightTrafficSignalsList = !signalListLeftRight.isEmpty();
            boolean bl = entriesInRightLeftTrafficSignalsList = !signalListRightLeft.isEmpty();
            if (leftTrafficDirection && !entriesInRightLeftTrafficSignalsList) {
                throw new CTCException("SignalDirectionIndicators", userIdentifier, Bundle.getMessage("SignalDirectionIndicatorsInvalidCombination"), Bundle.getMessage("SignalDirectionIndicatorsError2"));
            }
            if (rightTrafficDirection && !entriesInLeftRightTrafficSignalsList) {
                throw new CTCException("SignalDirectionIndicators", userIdentifier, Bundle.getMessage("SignalDirectionIndicatorsInvalidCombination"), Bundle.getMessage("SignalDirectionIndicatorsError3"));
            }
            if (!leftTrafficDirection && entriesInRightLeftTrafficSignalsList) {
                throw new CTCException("SignalDirectionIndicators", userIdentifier, Bundle.getMessage("SignalDirectionIndicatorsInvalidCombination"), Bundle.getMessage("SignalDirectionIndicatorsError4"));
            }
            if (!rightTrafficDirection && entriesInLeftRightTrafficSignalsList) {
                throw new CTCException("SignalDirectionIndicators", userIdentifier, Bundle.getMessage("SignalDirectionIndicatorsInvalidCombination"), Bundle.getMessage("SignalDirectionIndicatorsError5"));
            }
            for (NBHSignal signal : signalListLeftRight) {
                new SignalHeadPropertyChangeListenerMaintainer(signal);
                this._mSignalListLeftRight.add(signal);
                this.addSignal(userIdentifier, signal);
            }
            for (NBHSignal signal : signalListRightLeft) {
                new SignalHeadPropertyChangeListenerMaintainer(signal);
                this._mSignalListRightLeft.add(signal);
                this.addSignal(userIdentifier, signal);
            }
            this._mFleetingObject = fleetingObject;
            this.setSignalDirectionIndicatorsToDirection(1);
            this.forceAllSignalsToHeld();
        }
        catch (CTCException e) {
            e.logError();
            return;
        }
    }

    @Override
    public void removeAllListeners() {
        this._mCodingTimeTimer.stop();
        this._mCodingTimeTimer.removeActionListener(this._mCodingTimeTimerActionListener);
        this._mTimeLockingTimer.stop();
        this._mTimeLockingTimer.removeActionListener(this._mTimeLockingTimerActionListener);
        this._mSignalHeadPropertyChangeListenerLinkedList.forEach(signalHeadPropertyChangeListenerMaintainer -> signalHeadPropertyChangeListenerMaintainer.removePropertyChangeListener());
    }

    @Override
    public boolean isNonfunctionalObject() {
        return false;
    }

    @Override
    public void setPresentSignalDirectionLever(int presentSignalDirectionLever) {
        this._mPresentSignalDirectionLever = presentSignalDirectionLever;
    }

    @Override
    public boolean isRunningTime() {
        return this._mTimeLockingTimer.isRunning();
    }

    @Override
    public void osSectionBecameOccupied() {
        this._mCodingTimeTimer.stop();
        this._mTimeLockingTimer.stop();
        this.possiblyUpdateSignalIndicationSensors();
    }

    @Override
    public void codeButtonPressed(int requestedDirection, boolean requestedChangeInSignalDirection) {
        this._mCodingTimeTimer.stop();
        this._mRequestedDirectionObserver.setRequestedDirection(requestedDirection);
        if (requestedDirection == 1 && this._mPresentDirection != 1) {
            this._mTimeLockingTimer.start();
            requestedChangeInSignalDirection = true;
        }
        if (!this.isRunningTime()) {
            this.startCodingTime();
        }
        if (requestedChangeInSignalDirection) {
            this.setSignalDirectionIndicatorsToOUTOFCORRESPONDENCE();
        }
        this.setSignalsHeldTo(requestedDirection);
    }

    @Override
    public void startCodingTime() {
        this._mCodingTimeTimer.start();
    }

    @Override
    public boolean signalsNormal() {
        return this._mPresentDirection == 1;
    }

    @Override
    public boolean signalsNormalOrOutOfCorrespondence() {
        return this._mPresentDirection == 1 || this._mPresentDirection == 3;
    }

    @Override
    public int getPresentDirection() {
        return this._mPresentDirection;
    }

    @Override
    public boolean inCorrespondence() {
        return this._mPresentDirection != 3;
    }

    @Override
    public void forceAllSignalsToHeld() {
        this.setSignalsHeldTo(1);
    }

    @Override
    public int getSignalsInTheFieldDirection() {
        boolean LRCanGo = false;
        boolean RLCanGo = false;
        for (NBHSignal signal : this._mSignalListLeftRight) {
            if (signal.isDanger()) continue;
            LRCanGo = true;
            break;
        }
        for (NBHSignal signal : this._mSignalListRightLeft) {
            if (signal.isDanger()) continue;
            RLCanGo = true;
            break;
        }
        if (LRCanGo && RLCanGo) {
            CTCException.logError(Bundle.getMessage("SignalDirectionIndicatorsError6"));
            this.setSignalDirectionIndicatorsToOUTOFCORRESPONDENCE();
            return 3;
        }
        if (LRCanGo) {
            return 2;
        }
        if (RLCanGo) {
            return 0;
        }
        return 1;
    }

    @Override
    public void setSignalDirectionIndicatorsToOUTOFCORRESPONDENCE() {
        this.setSignalDirectionIndicatorsToDirection(3);
    }

    @Override
    public void setRequestedDirection(int direction) {
        this._mRequestedDirectionObserver.setRequestedDirection(direction);
    }

    private void addSignal(String userIdentifier, NBHSignal signal) throws CTCException {
        if (!_mSignalsUsed.add(signal)) {
            throw new CTCException("SignalDirectionIndicators", userIdentifier, signal.getHandleName(), Bundle.getMessage("SignalDirectionIndicatorsDuplicateHomeSignal"));
        }
    }

    private void setSignalsHeldTo(int direction) {
        switch (direction) {
            case 0: {
                this.setLRSignalsHeldTo(true);
                this.setRLSignalsHeldTo(false);
                break;
            }
            case 2: {
                this.setLRSignalsHeldTo(false);
                this.setRLSignalsHeldTo(true);
                break;
            }
            default: {
                this.setLRSignalsHeldTo(true);
                this.setRLSignalsHeldTo(true);
            }
        }
        this._mRequestedDirectionObserver.setRequestedDirection(direction);
    }

    private void setRLSignalsHeldTo(boolean held) {
        this._mSignalListRightLeft.forEach(signal -> signal.setHeld(held));
    }

    private void setLRSignalsHeldTo(boolean held) {
        this._mSignalListLeftRight.forEach(signal -> signal.setHeld(held));
    }

    private void setSignalDirectionIndicatorsToFieldSignalsState() {
        this.setSignalDirectionIndicatorsToDirection(this.getSignalsInTheFieldDirection());
    }

    private void setSignalDirectionIndicatorsToDirection(int direction) {
        switch (direction) {
            case 2: {
                this._mLeftSensor.setKnownState(4);
                this._mNormalSensor.setKnownState(4);
                this._mRightSensor.setKnownState(2);
                break;
            }
            case 0: {
                this._mLeftSensor.setKnownState(2);
                this._mNormalSensor.setKnownState(4);
                this._mRightSensor.setKnownState(4);
                break;
            }
            case 1: {
                this._mLeftSensor.setKnownState(4);
                this._mNormalSensor.setKnownState(2);
                this._mRightSensor.setKnownState(4);
                break;
            }
            default: {
                this._mLeftSensor.setKnownState(4);
                this._mNormalSensor.setKnownState(4);
                this._mRightSensor.setKnownState(4);
            }
        }
        this._mPresentDirection = direction;
    }

    private void timeLockingDone() {
        this.setSignalDirectionIndicatorsToFieldSignalsState();
        this.cancelLockedRoute();
    }

    private void codingTimeDone() {
        if (!this.isRunningTime()) {
            if (this.allSignalsRedSetThemAllHeld(this._mRequestedDirectionObserver.getRequestedDirection())) {
                this.cancelLockedRoute();
            }
            this.setSignalDirectionIndicatorsToFieldSignalsState();
        }
    }

    private void cancelLockedRoute() {
        if (this._mCodeButtonHandler != null) {
            this._mCodeButtonHandler.cancelLockedRoute();
        }
    }

    private boolean allSignalsRedSetThemAllHeld(int requestedDirection) {
        if (requestedDirection == 0) {
            boolean allRed = true;
            for (NBHSignal signal : this._mSignalListRightLeft) {
                if (signal.isDanger()) continue;
                allRed = false;
                break;
            }
            if (allRed) {
                this._mSignalListRightLeft.forEach(signalHead -> signalHead.setHeld(true));
            }
            return allRed;
        }
        if (requestedDirection == 2) {
            boolean allRed = true;
            for (NBHSignal signal : this._mSignalListLeftRight) {
                if (signal.isDanger()) continue;
                allRed = false;
                break;
            }
            if (allRed) {
                this._mSignalListLeftRight.forEach(signalHead -> signalHead.setHeld(true));
            }
            return allRed;
        }
        return true;
    }

    private void handleSignalChange(PropertyChangeEvent e) {
        if (this._mFleetingObject != null && !this._mFleetingObject.isFleetingEnabled() && this.changedToUniversalRed(e)) {
            boolean forceAllSignalsToHeld = false;
            if (this._mPresentSignalDirectionLever == 2) {
                for (NBHSignal signal : this._mSignalListLeftRight) {
                    if (e.getSource() != signal.getBean()) continue;
                    forceAllSignalsToHeld = true;
                    break;
                }
            } else if (this._mPresentSignalDirectionLever == 0) {
                for (NBHSignal signal : this._mSignalListRightLeft) {
                    if (e.getSource() != signal.getBean()) continue;
                    forceAllSignalsToHeld = true;
                    break;
                }
            }
            if (forceAllSignalsToHeld) {
                this.forceAllSignalsToHeld();
            }
        }
        this.possiblyUpdateSignalIndicationSensors();
    }

    private boolean changedToUniversalRed(PropertyChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof AbstractSignalHead) {
            if (e.getPropertyName().equals("Appearance")) {
                return 1 == (Integer)e.getNewValue();
            }
        } else if (source instanceof AbstractSignalMast && e.getPropertyName().equals("Aspect")) {
            AbstractSignalMast source2 = (AbstractSignalMast)source;
            return source2.getAspect().equals(source2.getAppearanceMap().getSpecificAppearance(2));
        }
        return false;
    }

    private void possiblyUpdateSignalIndicationSensors() {
        if (!this._mCodingTimeTimer.isRunning() && !this.isRunningTime()) {
            this.setSignalDirectionIndicatorsToFieldSignalsState();
        }
    }

    private class SignalHeadPropertyChangeListenerMaintainer {
        private final NBHSignal _mSignal;
        private final PropertyChangeListener _mPropertyChangeListener = e -> SignalDirectionIndicators.access$0(SignalDirectionIndicators.this, e);

        public SignalHeadPropertyChangeListenerMaintainer(NBHSignal signal) {
            this._mSignal = signal;
            this._mSignal.addPropertyChangeListener(this._mPropertyChangeListener);
            SignalDirectionIndicators.this._mSignalHeadPropertyChangeListenerLinkedList.add(this);
        }

        public void removePropertyChangeListener() {
            this._mSignal.removePropertyChangeListener(this._mPropertyChangeListener);
        }
    }
}

