/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import java.beans.PropertyChangeListener;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.SignalAppearanceMap;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.jmrit.ctc.CtcManager;
import jmri.jmrit.ctc.ctcserialdata.OtherData;
import jmri.jmrit.ctc.ctcserialdata.ProjectsCommonSubs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NBHSignal {
    public static final Object DEFAULT_OBJECT_RV = null;
    public static final boolean DEFAULT_BOOLEAN_RV = false;
    public static final int DEFAULT_INT_RV = 0;
    public static final String DEFAULT_STRING_RV = "UNKNOWN";
    private final NamedBeanHandle<SignalMast> _mNamedBeanHandleSignalMast;
    private final NamedBeanHandle<SignalHead> _mNamedBeanHandleSignalHead;
    private final boolean isSignalMast = this.setSignalType();
    private final String _mDangerAppearance;
    private static final Logger log = LoggerFactory.getLogger(NBHSignal.class);

    public NBHSignal(String signal) {
        if (!ProjectsCommonSubs.isNullOrEmptyString(signal)) {
            if (this.isSignalMast) {
                SignalMast signalMast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(signal);
                if (signalMast != null) {
                    this._mNamedBeanHandleSignalMast = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signal, signalMast);
                    String temp = this.getAppearanceMap().getSpecificAppearance(2);
                    if (temp == null) {
                        temp = "Stop";
                    }
                    this._mDangerAppearance = temp;
                    this._mNamedBeanHandleSignalHead = null;
                    if (this.valid()) {
                        InstanceManager.getDefault(CtcManager.class).putNBHSignal(signal, this);
                    }
                    return;
                }
            } else {
                SignalHead signalHead = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signal);
                if (signalHead != null) {
                    this._mNamedBeanHandleSignalHead = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signal, signalHead);
                    this._mDangerAppearance = "Stop";
                    this._mNamedBeanHandleSignalMast = null;
                    if (this.valid()) {
                        InstanceManager.getDefault(CtcManager.class).putNBHSignal(signal, this);
                    }
                    return;
                }
            }
        }
        this._mDangerAppearance = "Stop";
        this._mNamedBeanHandleSignalMast = null;
        this._mNamedBeanHandleSignalHead = null;
    }

    private boolean setSignalType() {
        OtherData otherData = InstanceManager.getDefault(CtcManager.class).getOtherData();
        return otherData._mSignalSystemType == OtherData.SIGNAL_SYSTEM_TYPE.SIGNALMAST;
    }

    public boolean valid() {
        return this._mNamedBeanHandleSignalMast != null || this._mNamedBeanHandleSignalHead != null;
    }

    public Object getBean() {
        if (!this.valid()) {
            return null;
        }
        return this.isSignalMast ? this._mNamedBeanHandleSignalMast.getBean() : this._mNamedBeanHandleSignalHead.getBean();
    }

    public Object getBeanHandle() {
        if (!this.valid()) {
            return null;
        }
        return this.isSignalMast ? this._mNamedBeanHandleSignalMast : this._mNamedBeanHandleSignalHead;
    }

    public String getHandleName() {
        if (!this.valid()) {
            return null;
        }
        return this.isSignalMast ? this._mNamedBeanHandleSignalMast.getName() : this._mNamedBeanHandleSignalHead.getName();
    }

    public String getDisplayName() {
        if (this.isSignalMast) {
            if (this._mNamedBeanHandleSignalMast == null) {
                return DEFAULT_STRING_RV;
            }
            return this._mNamedBeanHandleSignalMast.getBean().getDisplayName();
        }
        if (this._mNamedBeanHandleSignalHead == null) {
            return DEFAULT_STRING_RV;
        }
        return this._mNamedBeanHandleSignalHead.getBean().getDisplayName();
    }

    public boolean isDanger() {
        if (this.getHeld()) {
            return true;
        }
        return this.isSignalMast ? this.getAspect().equals(this._mDangerAppearance) : 1 == this.getAppearance();
    }

    public void setCTCHeld(boolean held) {
        this.setHeld(held);
    }

    public boolean getHeld() {
        if (this.isSignalMast) {
            if (this._mNamedBeanHandleSignalMast == null) {
                return false;
            }
            return this._mNamedBeanHandleSignalMast.getBean().getHeld();
        }
        if (this._mNamedBeanHandleSignalHead == null) {
            return false;
        }
        return this._mNamedBeanHandleSignalHead.getBean().getHeld();
    }

    public void setHeld(boolean newHeld) {
        if (this.isSignalMast) {
            if (this._mNamedBeanHandleSignalMast == null) {
                return;
            }
            this._mNamedBeanHandleSignalMast.getBean().setHeld(newHeld);
            if (newHeld) {
                this._mNamedBeanHandleSignalMast.getBean().setPermissiveSmlDisabled(true);
            }
        } else {
            if (this._mNamedBeanHandleSignalHead == null) {
                return;
            }
            this._mNamedBeanHandleSignalHead.getBean().setHeld(newHeld);
        }
    }

    public void allowPermissiveSML() {
        this._mNamedBeanHandleSignalMast.getBean().setPermissiveSmlDisabled(false);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.isSignalMast) {
            if (this._mNamedBeanHandleSignalMast == null) {
                return;
            }
            this._mNamedBeanHandleSignalMast.getBean().addPropertyChangeListener(l);
        } else {
            if (this._mNamedBeanHandleSignalHead == null) {
                return;
            }
            this._mNamedBeanHandleSignalHead.getBean().addPropertyChangeListener(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.isSignalMast) {
            if (this._mNamedBeanHandleSignalMast == null) {
                return;
            }
            this._mNamedBeanHandleSignalMast.getBean().removePropertyChangeListener(l);
        } else {
            if (this._mNamedBeanHandleSignalHead == null) {
                return;
            }
            this._mNamedBeanHandleSignalHead.getBean().removePropertyChangeListener(l);
        }
    }

    public String getAspect() {
        if (!this.isSignalMast) {
            log.info("NBHSignal: getAspect called by signal head", (Throwable)new Exception("traceback"));
        }
        if (this._mNamedBeanHandleSignalMast == null) {
            return DEFAULT_STRING_RV;
        }
        String returnAspect = this._mNamedBeanHandleSignalMast.getBean().getAspect();
        if (returnAspect == null) {
            return this._mDangerAppearance;
        }
        return returnAspect;
    }

    public SignalAppearanceMap getAppearanceMap() {
        if (!this.isSignalMast) {
            log.info("NBHSignal: getAppearanceMap called by signal head", (Throwable)new Exception("traceback"));
        }
        if (this._mNamedBeanHandleSignalMast == null) {
            return null;
        }
        return this._mNamedBeanHandleSignalMast.getBean().getAppearanceMap();
    }

    public int getAppearance() {
        if (this.isSignalMast) {
            log.info("NBHSignal: getAppearance called by signal mast", (Throwable)new Exception("traceback"));
        }
        if (this._mNamedBeanHandleSignalHead == null) {
            return 0;
        }
        return this._mNamedBeanHandleSignalHead.getBean().getAppearance();
    }

    public void setAppearance(int newAppearance) {
        if (this.isSignalMast) {
            log.info("NBHSignal: setAppearance called by signal mast", (Throwable)new Exception("traceback"));
        }
        if (this._mNamedBeanHandleSignalHead == null) {
            return;
        }
        this._mNamedBeanHandleSignalHead.getBean().setAppearance(newAppearance);
    }

    public int[] getValidStates() {
        if (this.isSignalMast) {
            log.info("NBHSignal: getValidStates called by signal mast", (Throwable)new Exception("traceback"));
        }
        if (this._mNamedBeanHandleSignalHead == null) {
            return new int[0];
        }
        return this._mNamedBeanHandleSignalHead.getBean().getValidStates();
    }

    public String[] getValidStateKeys() {
        if (this.isSignalMast) {
            log.info("NBHSignal: getValidStateKeys called by signal mast", (Throwable)new Exception("traceback"));
        }
        if (this._mNamedBeanHandleSignalHead == null) {
            return new String[0];
        }
        return this._mNamedBeanHandleSignalHead.getBean().getValidStateKeys();
    }

    public String[] getValidStateNames() {
        if (this.isSignalMast) {
            log.info("NBHSignal: getValidStateNames called by signal mast", (Throwable)new Exception("traceback"));
        }
        if (this._mNamedBeanHandleSignalHead == null) {
            return new String[0];
        }
        return this._mNamedBeanHandleSignalHead.getBean().getValidStateNames();
    }
}

