/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmrit.ctc.Bundle;
import jmri.jmrit.ctc.CTCException;
import jmri.jmrit.ctc.CtcManager;
import jmri.jmrit.ctc.ctcserialdata.ProjectsCommonSubs;

public class NBHSensor {
    public static final int DEFAULT_SENSOR_STATE_RV = 4;
    private NamedBeanHandle<Sensor> _mNamedBeanHandleSensor;
    private final String _mUserIdentifier;
    private final String _mParameter;
    private final boolean _mOptional;
    private final ArrayList<PropertyChangeListener> _mArrayListOfPropertyChangeListeners = new ArrayList();

    public Sensor getBean() {
        if (this.valid()) {
            return this._mNamedBeanHandleSensor.getBean();
        }
        return null;
    }

    public NamedBeanHandle getBeanHandle() {
        if (this.valid()) {
            return this._mNamedBeanHandleSensor;
        }
        return null;
    }

    public boolean matchSensor(Sensor sensor) {
        if (this.valid()) {
            return this._mNamedBeanHandleSensor.getBean() == sensor;
        }
        return false;
    }

    public NBHSensor(String module, String userIdentifier, String parameter, String sensor, boolean optional) {
        this._mUserIdentifier = userIdentifier;
        this._mParameter = parameter;
        this._mOptional = optional;
        Sensor tempSensor = this._mOptional ? NBHSensor.getSafeOptionalJMRISensor(module, userIdentifier, this._mParameter, sensor) : NBHSensor.getSafeExistingJMRISensor(module, userIdentifier, this._mParameter, sensor);
        this._mNamedBeanHandleSensor = tempSensor != null ? InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(sensor, tempSensor) : null;
        this.registerSensor(sensor);
    }

    public NBHSensor(String module, String userIdentifier, String parameter, String sensorName) {
        this._mUserIdentifier = userIdentifier;
        this._mParameter = parameter;
        this._mOptional = false;
        Sensor tempSensor = NBHSensor.getSafeInternalSensor(module, userIdentifier, parameter, sensorName);
        this._mNamedBeanHandleSensor = tempSensor != null ? InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(sensorName, tempSensor) : null;
        this.registerSensor(sensorName);
    }

    void registerSensor(String sensorName) {
        if (this.valid()) {
            InstanceManager.getDefault(CtcManager.class).putNBHSensor(sensorName, this);
        }
    }

    public NBHSensor(NamedBeanHandle<Sensor> namedBeanHandleSensor) {
        this._mParameter = this._mUserIdentifier = Bundle.getMessage("Unknown");
        this._mOptional = true;
        this._mNamedBeanHandleSensor = namedBeanHandleSensor;
    }

    public boolean valid() {
        return this._mNamedBeanHandleSensor != null;
    }

    private static Sensor getSafeExistingJMRISensor(String module, String userIdentifier, String parameter, String sensor) {
        try {
            return NBHSensor.getExistingJMRISensor(module, userIdentifier, parameter, sensor);
        }
        catch (CTCException e) {
            e.logError();
            return null;
        }
    }

    private static Sensor getSafeOptionalJMRISensor(String module, String userIdentifier, String parameter, String sensor) {
        try {
            return NBHSensor.getOptionalJMRISensor(module, userIdentifier, parameter, sensor);
        }
        catch (CTCException e) {
            e.logError();
            return null;
        }
    }

    private static Sensor getSafeInternalSensor(String module, String userIdentifier, String parameter, String sensor) {
        try {
            return NBHSensor.getInternalSensor(module, userIdentifier, parameter, sensor);
        }
        catch (CTCException e) {
            e.logError();
            return null;
        }
    }

    private static Sensor getExistingJMRISensor(String module, String userIdentifier, String parameter, String sensor) throws CTCException {
        if (!ProjectsCommonSubs.isNullOrEmptyString(sensor)) {
            Sensor returnValue = InstanceManager.getDefault(SensorManager.class).getSensor(sensor);
            if (returnValue == null) {
                throw new CTCException(module, userIdentifier, parameter, String.valueOf(Bundle.getMessage("NBHSensorDoesNotExist")) + " " + sensor);
            }
            return returnValue;
        }
        throw new CTCException(module, userIdentifier, parameter, Bundle.getMessage("NBHSensorRequiredSensorMissing"));
    }

    private static Sensor getOptionalJMRISensor(String module, String userIdentifier, String parameter, String sensor) throws CTCException {
        if (!ProjectsCommonSubs.isNullOrEmptyString(sensor)) {
            Sensor returnValue = InstanceManager.getDefault(SensorManager.class).getSensor(sensor);
            if (returnValue == null) {
                throw new CTCException(module, userIdentifier, parameter, String.valueOf(Bundle.getMessage("NBHSensorDoesNotExist")) + " " + sensor);
            }
            return returnValue;
        }
        return null;
    }

    private static Sensor getInternalSensor(String module, String userIdentifier, String parameter, String sensor) throws CTCException {
        if (!ProjectsCommonSubs.isNullOrEmptyString(sensor)) {
            return InstanceManager.getDefault(SensorManager.class).provide(sensor);
        }
        return null;
    }

    public int getKnownState() {
        if (this._mNamedBeanHandleSensor == null) {
            return 4;
        }
        return this._mNamedBeanHandleSensor.getBean().getKnownState();
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"}, justification="Let it not do anything if it fails.")
    public void setKnownState(int newState) {
        if (this._mNamedBeanHandleSensor == null) {
            return;
        }
        try {
            this._mNamedBeanHandleSensor.getBean().setKnownState(newState);
        }
        catch (JmriException jmriException) {}
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._mNamedBeanHandleSensor == null) {
            return;
        }
        this._mNamedBeanHandleSensor.getBean().addPropertyChangeListener(propertyChangeListener);
        this._mArrayListOfPropertyChangeListeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._mNamedBeanHandleSensor == null) {
            return;
        }
        this._mNamedBeanHandleSensor.getBean().removePropertyChangeListener(propertyChangeListener);
        this._mArrayListOfPropertyChangeListeners.remove(propertyChangeListener);
    }

    public String getHandleName() {
        return this.valid() ? this._mNamedBeanHandleSensor.getName() : "";
    }

    public int testingGetCountOfPropertyChangeListenersRegistered() {
        return this._mArrayListOfPropertyChangeListeners.size();
    }
}

