/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import java.util.ArrayList;
import java.util.HashSet;
import jmri.Sensor;
import jmri.jmrit.ctc.LockedRoute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockedRoutesManager {
    private static final Logger log = LoggerFactory.getLogger(LockedRoutesManager.class);
    private final ArrayList<LockedRoute> _mArrayListOfLockedRoutes = new ArrayList();
    private LockedRoute existingLockedRouteThatHasCommonSensors;

    public void clearAllLockedRoutes() {
        this._mArrayListOfLockedRoutes.clear();
    }

    public boolean checkRoute(HashSet<Sensor> sensors, String osSectionDescription, String ruleDescription) {
        return this.privateCheckRoute(sensors, osSectionDescription, ruleDescription, false, false) != null;
    }

    public LockedRoute checkRouteAndAllocateIfAvailable(HashSet<Sensor> sensors, String osSectionDescription, String ruleDescription, boolean rightTraffic) {
        LockedRoute newLockedRoute = this.privateCheckRoute(sensors, osSectionDescription, ruleDescription, true, rightTraffic);
        if (newLockedRoute == null) {
            return null;
        }
        if (this.existingLockedRouteThatHasCommonSensors == null) {
            newLockedRoute.allocateRoute();
            this._mArrayListOfLockedRoutes.add(newLockedRoute);
            return newLockedRoute;
        }
        this.existingLockedRouteThatHasCommonSensors.mergeRoutes(newLockedRoute);
        return this.existingLockedRouteThatHasCommonSensors;
    }

    private LockedRoute privateCheckRoute(HashSet<Sensor> sensors, String osSectionDescription, String ruleDescription, boolean checkTraffic, boolean rightTraffic) {
        this.existingLockedRouteThatHasCommonSensors = null;
        LockedRoute newLockedRoute = new LockedRoute(this, sensors, osSectionDescription, ruleDescription, rightTraffic);
        for (LockedRoute existingLockedRoute : this._mArrayListOfLockedRoutes) {
            LockedRoute.AnyInCommonReturn anyInCommonReturn = newLockedRoute.anyInCommon(existingLockedRoute, checkTraffic, rightTraffic);
            if (anyInCommonReturn == LockedRoute.AnyInCommonReturn.YES) {
                return null;
            }
            if (anyInCommonReturn != LockedRoute.AnyInCommonReturn.FLEETING) continue;
            this.existingLockedRouteThatHasCommonSensors = existingLockedRoute;
            break;
        }
        return newLockedRoute;
    }

    public void cancelLockedRoute(LockedRoute lockedRoute) {
        if (lockedRoute != null) {
            lockedRoute.removeAllListeners();
        }
        this._mArrayListOfLockedRoutes.remove(lockedRoute);
    }

    public void removeAllListeners() {
        this._mArrayListOfLockedRoutes.forEach(existingLockedRoute -> existingLockedRoute.removeAllListeners());
    }

    void dumpAllRoutes() {
        log.info("Locked Routes:");
        for (LockedRoute lockedRoute : this._mArrayListOfLockedRoutes) {
            log.info(lockedRoute.dumpRoute());
        }
        log.info("--------------");
    }
}

