/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import java.util.ArrayList;
import jmri.InstanceManager;
import jmri.SignalMast;
import jmri.SignalMastLogic;
import jmri.SignalMastLogicManager;
import jmri.Turnout;
import jmri.jmrit.ctc.NBHSignal;
import jmri.jmrit.ctc.NBHTurnout;
import jmri.jmrit.ctc.ctcserialdata.OtherData;

public class IndicationLockingSignals {
    private final ArrayList<NBHSignal> _mListOfSignals;
    private final Turnout turnout;
    private final OtherData.SIGNAL_SYSTEM_TYPE signalType;

    public IndicationLockingSignals(String userIdentifier, ArrayList<NBHSignal> signals, NBHTurnout nbhTurnout, OtherData.SIGNAL_SYSTEM_TYPE signalSystemType) {
        this.turnout = nbhTurnout.getBean();
        this.signalType = signalSystemType;
        this._mListOfSignals = signals;
    }

    public void removeAllListeners() {
    }

    public boolean routeClearedAcross() {
        if (this.signalType == OtherData.SIGNAL_SYSTEM_TYPE.SIGNALHEAD) {
            return this.checkSignalHeads();
        }
        if (this.signalType == OtherData.SIGNAL_SYSTEM_TYPE.SIGNALMAST) {
            return this.checkSignalMasts();
        }
        return false;
    }

    public boolean checkSignalHeads() {
        for (NBHSignal signal : this._mListOfSignals) {
            if (signal.isDanger()) continue;
            return true;
        }
        return false;
    }

    public boolean checkSignalMasts() {
        for (NBHSignal signal : this._mListOfSignals) {
            if (!this.checkMast((SignalMast)signal.getBean(), this.turnout)) continue;
            return true;
        }
        return false;
    }

    public boolean checkMast(SignalMast mast, Turnout turnout) {
        if (mast.getHeld()) {
            return false;
        }
        SignalMastLogic sml = InstanceManager.getDefault(SignalMastLogicManager.class).getSignalMastLogic(mast);
        if (sml == null) {
            return false;
        }
        SignalMast activeDest = sml.getActiveDestination();
        if (activeDest == null) {
            return false;
        }
        for (Turnout autoTurnout : sml.getAutoTurnouts(activeDest)) {
            if (autoTurnout != turnout) continue;
            return true;
        }
        for (Turnout manualTurnout : sml.getTurnouts(activeDest)) {
            if (manualTurnout != turnout) continue;
            return true;
        }
        return false;
    }
}

