/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jmri.Block;
import jmri.BlockManager;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanUsageReport;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.ctc.Bundle;
import jmri.jmrit.ctc.NBHSensor;
import jmri.jmrit.ctc.NBHSignal;
import jmri.jmrit.ctc.NBHTurnout;
import jmri.jmrit.ctc.ctcserialdata.CTCSerialData;
import jmri.jmrit.ctc.ctcserialdata.CodeButtonHandlerData;
import jmri.jmrit.ctc.ctcserialdata.OtherData;
import jmri.jmrit.ctc.ctcserialdata.TrafficLockingData;
import jmri.jmrit.ctc.editor.code.ProgramProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CtcManager
implements InstanceManagerAutoDefault,
VetoableChangeListener {
    ProgramProperties programProperties = null;
    CTCSerialData ctcSerialData = null;
    HashMap<String, NBHSensor> nbhSensors = new HashMap();
    HashMap<String, NBHSignal> nbhSignals = new HashMap();
    HashMap<String, NBHTurnout> nbhTurnouts = new HashMap();
    HashMap<String, NamedBeanHandle<Block>> blocks = new HashMap();
    NBHSensor foundSensor;
    NBHSignal foundSignal;
    NBHTurnout foundTurnout;
    Block foundBlock;
    List<NamedBeanUsageReport> usageReport;
    private static final Logger log = LoggerFactory.getLogger(CtcManager.class);

    public CtcManager() {
        InstanceManager.setDefault(CtcManager.class, this);
        InstanceManager.getOptionalDefault(ConfigureManager.class).ifPresent(cm -> cm.registerConfig(this, this.getXMLOrder()));
        InstanceManager.getDefault(SensorManager.class).addVetoableChangeListener(this);
        InstanceManager.getDefault(SignalHeadManager.class).addVetoableChangeListener(this);
        InstanceManager.getDefault(SignalMastManager.class).addVetoableChangeListener(this);
        InstanceManager.getDefault(TurnoutManager.class).addVetoableChangeListener(this);
        InstanceManager.getDefault(BlockManager.class).addVetoableChangeListener(this);
        log.debug("CtcManager started");
    }

    public ProgramProperties getProgramProperties() {
        if (this.programProperties == null) {
            this.programProperties = new ProgramProperties();
        }
        return this.programProperties;
    }

    public ProgramProperties newProgramProperties() {
        this.programProperties = new ProgramProperties();
        return this.programProperties;
    }

    public CTCSerialData getCTCSerialData() {
        if (this.ctcSerialData == null) {
            this.ctcSerialData = new CTCSerialData();
        }
        return this.ctcSerialData;
    }

    public CTCSerialData newCTCSerialData() {
        this.ctcSerialData = new CTCSerialData();
        this.nbhSensors.clear();
        this.nbhSignals.clear();
        this.nbhTurnouts.clear();
        this.blocks.clear();
        return this.ctcSerialData;
    }

    public OtherData getOtherData() {
        if (this.ctcSerialData == null) {
            this.ctcSerialData = this.getCTCSerialData();
        }
        return this.ctcSerialData.getOtherData();
    }

    public NBHSensor getNBHSensor(String name) {
        return this.nbhSensors.get(name);
    }

    public void putNBHSensor(String name, NBHSensor nbh) {
        NBHSensor oldSensor = this.nbhSensors.put(name, nbh);
        log.debug("sensor put = {} -- {}", (Object)name, (Object)nbh);
        if (oldSensor != null) {
            log.debug("---- duplicate sensor: {} -- {}", (Object)name, (Object)nbh);
        }
    }

    public NBHSignal getNBHSignal(String name) {
        return this.nbhSignals.get(name);
    }

    public void putNBHSignal(String name, NBHSignal nbh) {
        NBHSignal oldSignal = this.nbhSignals.put(name, nbh);
        log.debug("signal put = {} -- {}", (Object)name, (Object)nbh);
        if (oldSignal != null) {
            log.debug("---- duplicate signal: {} -- {}", (Object)name, (Object)nbh);
        }
    }

    public NBHTurnout getNBHTurnout(String name) {
        return this.nbhTurnouts.get(name);
    }

    public void putNBHTurnout(String name, NBHTurnout nbh) {
        NBHTurnout oldTurnout = this.nbhTurnouts.put(name, nbh);
        log.debug("turnout put = {} -- {}", (Object)name, (Object)nbh);
        if (oldTurnout != null) {
            log.debug("---- duplicate turnout: {} -- {}", (Object)name, (Object)nbh);
        }
    }

    public NamedBeanHandle<Block> getBlock(String name) {
        return this.blocks.get(name);
    }

    public void putBlock(String name, NamedBeanHandle<Block> block) {
        NamedBeanHandle<Block> oldBlock = this.blocks.put(name, block);
        log.debug("block put = {} -- {}", (Object)name, block);
        if (oldBlock != null) {
            log.debug("---- duplicate block: {} -- {}", (Object)name, block);
        }
    }

    public int getXMLOrder() {
        return 410;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        NamedBean nb = (NamedBean)evt.getOldValue();
        if ("CanDelete".equals(evt.getPropertyName()) && this.findNBHforBean(nb)) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
            throw new PropertyVetoException(this.getVetoDetails(nb), e);
        }
    }

    String getVetoDetails(NamedBean nb) {
        StringBuilder sb = new StringBuilder();
        sb.append(Bundle.getMessage("CtcManagerDeleteVetoed", nb.getBeanType()));
        for (NamedBeanUsageReport report : this.getUsageReport(nb)) {
            sb.append(Bundle.getMessage("VetoDetailLine", report.usageData));
        }
        return sb.toString();
    }

    boolean findNBHforBean(NamedBean nb) {
        if (nb == null) {
            return false;
        }
        boolean found = false;
        this.foundSensor = null;
        this.foundSignal = null;
        this.foundTurnout = null;
        this.foundBlock = null;
        if (nb instanceof Sensor) {
            for (NBHSensor nBHSensor : this.nbhSensors.values()) {
                if (!nb.equals(nBHSensor.getBean())) continue;
                this.foundSensor = nBHSensor;
                found = true;
                break;
            }
        }
        if (nb instanceof SignalHead || nb instanceof SignalMast) {
            for (NBHSignal nBHSignal : this.nbhSignals.values()) {
                if (!nb.equals(nBHSignal.getBean())) continue;
                this.foundSignal = nBHSignal;
                found = true;
                break;
            }
        }
        if (nb instanceof Turnout) {
            for (NBHTurnout nBHTurnout : this.nbhTurnouts.values()) {
                if (!nb.equals(nBHTurnout.getBean())) continue;
                this.foundTurnout = nBHTurnout;
                found = true;
                break;
            }
        }
        if (nb instanceof Block) {
            for (NamedBeanHandle namedBeanHandle : this.blocks.values()) {
                if (!nb.equals(namedBeanHandle.getBean())) continue;
                this.foundBlock = (Block)namedBeanHandle.getBean();
                found = true;
                break;
            }
        }
        return found;
    }

    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        this.usageReport = new ArrayList<NamedBeanUsageReport>();
        if (this.findNBHforBean(bean)) {
            if (this.getOtherData()._mFleetingToggleInternalSensor.equals(this.foundSensor) || this.getOtherData()._mCTCDebugSystemReloadInternalSensor.equals(this.foundSensor) || this.getOtherData()._mCTCDebug_TrafficLockingRuleTriggeredDisplayInternalSensor.equals(this.foundSensor)) {
                this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedOther", Bundle.getMessage("WhereUsedOther")));
            }
            this.getCTCSerialData().getCodeButtonHandlerDataArrayList().forEach(cbhd -> this.getCodeButtonHandleDataUsage((CodeButtonHandlerData)cbhd));
        }
        return this.usageReport;
    }

    void getCodeButtonHandleDataUsage(CodeButtonHandlerData cbhd) {
        String osName = cbhd.myShortStringNoComma();
        if (cbhd._mCodeButtonInternalSensor.equals(this.foundSensor) || cbhd._mOSSectionOccupiedExternalSensor.equals(this.foundSensor) || cbhd._mOSSectionOccupiedExternalSensor2.equals(this.foundSensor)) {
            this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedSensor", osName, "CB")));
        }
        if (cbhd._mSIDI_LeftInternalSensor.equals(this.foundSensor) || cbhd._mSIDI_NormalInternalSensor.equals(this.foundSensor) || cbhd._mSIDI_RightInternalSensor.equals(this.foundSensor)) {
            this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedSensor", osName, "SIDI")));
        }
        cbhd._mSIDI_LeftRightTrafficSignals.forEach(signal -> {
            if (signal.equals(this.foundSignal)) {
                this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedSignal", osName, "SIDI")));
            }
        });
        cbhd._mSIDI_RightLeftTrafficSignals.forEach(signal -> {
            if (signal.equals(this.foundSignal)) {
                this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedSignal", osName, "SIDI")));
            }
        });
        if (cbhd._mSIDL_LeftInternalSensor.equals(this.foundSensor) || cbhd._mSIDL_NormalInternalSensor.equals(this.foundSensor) || cbhd._mSIDL_RightInternalSensor.equals(this.foundSensor)) {
            this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedSensor", osName, "SIDL")));
        }
        if (cbhd._mSWDI_NormalInternalSensor.equals(this.foundSensor) || cbhd._mSWDI_ReversedInternalSensor.equals(this.foundSensor)) {
            this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedSensor", osName, "SWDI")));
        }
        if (cbhd._mSWDI_ExternalTurnout.equals(this.foundTurnout)) {
            this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedTurnout", osName, "SWDI")));
        }
        if (cbhd._mSWDL_InternalSensor.equals(this.foundSensor)) {
            this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedSensor", osName, "SWDL")));
        }
        this.callOnDataUsage(cbhd, osName);
        this.traffficLockingDataUsage(cbhd, osName);
        if (cbhd._mTUL_DispatcherInternalSensorLockToggle.equals(this.foundSensor) || cbhd._mTUL_DispatcherInternalSensorUnlockedIndicator.equals(this.foundSensor)) {
            this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedSensor", osName, "TUL")));
        }
        if (cbhd._mTUL_ExternalTurnout.equals(this.foundTurnout) || cbhd._mTUL_AdditionalExternalTurnout1.equals(this.foundTurnout) || cbhd._mTUL_AdditionalExternalTurnout2.equals(this.foundTurnout) || cbhd._mTUL_AdditionalExternalTurnout3.equals(this.foundTurnout)) {
            this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedTurnout", osName, "TUL")));
        }
        cbhd._mIL_Signals.forEach(signal -> {
            if (signal.equals(this.foundSignal)) {
                this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedSignal", osName, "IL")));
            }
        });
    }

    void callOnDataUsage(CodeButtonHandlerData cbhd, String osName) {
        if (cbhd._mCO_CallOnToggleInternalSensor.equals(this.foundSensor)) {
            this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedSensor", osName, "CO")));
        }
        cbhd._mCO_GroupingsList.forEach(row -> {
            if (row._mCalledOnExternalSensor.equals(this.foundSensor)) {
                this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedSensor", osName, "CO")));
            }
            if (row._mExternalSignal.equals(this.foundSignal)) {
                this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedSignal", osName, "CO")));
            }
            if (row._mExternalBlock != null && row._mExternalBlock.getBean().equals(this.foundBlock)) {
                this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedBlock", osName, "CO")));
            }
            row._mSwitchIndicators.forEach(sw -> {
                if (sw.equals(this.foundSensor)) {
                    this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedSensor", osName, "CO")));
                }
            });
        });
    }

    void traffficLockingDataUsage(CodeButtonHandlerData cbhd, String osName) {
        cbhd._mTRL_LeftTrafficLockingRules.forEach(rule -> this.traffficLockingRuleDataUsage((TrafficLockingData)rule, osName));
        cbhd._mTRL_RightTrafficLockingRules.forEach(rule -> this.traffficLockingRuleDataUsage((TrafficLockingData)rule, osName));
    }

    void traffficLockingRuleDataUsage(TrafficLockingData rule, String osName) {
        if (this.foundSignal != null && rule._mDestinationSignalOrComment.equals(this.foundSignal.getHandleName())) {
            this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedSignal", osName, "TRL")));
        }
        for (NBHSensor sensor : rule._mOccupancyExternalSensors) {
            if (!sensor.equals(this.foundSensor)) continue;
            this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedSensor", osName, "TRL")));
            break;
        }
        for (NBHSensor sensor : rule._mOptionalExternalSensors) {
            if (!sensor.equals(this.foundSensor)) continue;
            this.usageReport.add(new NamedBeanUsageReport("CtcWhereUsedCBHD", Bundle.getMessage("WhereUsedSensor", osName, "TRL")));
            break;
        }
    }
}

