/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.Timer;
import jmri.jmrit.ctc.NBHSensor;
import jmri.jmrit.ctc.SignalDirectionLever;
import jmri.jmrit.ctc.SwitchDirectionLever;
import jmri.jmrit.ctc.TurnoutLock;

public class CodeButtonSimulator {
    private final NBHSensor _mCodeButtonSensor;
    private final NBHSensor _mSwitchLeverSensor;
    private final NBHSensor _mLeftSensor;
    private final NBHSensor _mNormalSensor;
    private final NBHSensor _mRightSensor;
    private final NBHSensor _mDispatcherSensorLockToggle;
    private final PropertyChangeListener _mAnySensorPropertyChangeListener;
    private final Timer _mPauseTimer;
    private final ActionListener _mPauseActionListener;

    public CodeButtonSimulator() {
        this._mCodeButtonSensor = null;
        this._mSwitchLeverSensor = null;
        this._mLeftSensor = null;
        this._mNormalSensor = null;
        this._mRightSensor = null;
        this._mDispatcherSensorLockToggle = null;
        this._mAnySensorPropertyChangeListener = null;
        this._mPauseTimer = null;
        this._mPauseActionListener = null;
    }

    public CodeButtonSimulator(int pauseTimeInMilliseconds, NBHSensor codeButtonSensor, SwitchDirectionLever switchDirectionLever, SignalDirectionLever signalDirectionLever, TurnoutLock turnoutLock) {
        this._mCodeButtonSensor = codeButtonSensor;
        this._mSwitchLeverSensor = switchDirectionLever != null ? switchDirectionLever.getSwitchLeverSensor() : new NBHSensor("", "", "", "", true);
        if (signalDirectionLever != null) {
            SignalDirectionLever.LNR_NBHSensors Sensors = signalDirectionLever.getLevers();
            this._mLeftSensor = Sensors._mLeftSensor;
            this._mNormalSensor = Sensors._mNormalSensor;
            this._mRightSensor = Sensors._mRightSensor;
        } else {
            this._mLeftSensor = new NBHSensor("", "", "", "", true);
            this._mNormalSensor = new NBHSensor("", "", "", "", true);
            this._mRightSensor = new NBHSensor("", "", "", "", true);
        }
        this._mDispatcherSensorLockToggle = turnoutLock != null ? turnoutLock.getDispatcherSensorLockToggle() : new NBHSensor("", "", "", "", true);
        this._mAnySensorPropertyChangeListener = PropertyChangeEvent2 -> this.anySensorPropertyChangeEvent();
        this._mSwitchLeverSensor.addPropertyChangeListener(this._mAnySensorPropertyChangeListener);
        this._mLeftSensor.addPropertyChangeListener(this._mAnySensorPropertyChangeListener);
        this._mNormalSensor.addPropertyChangeListener(this._mAnySensorPropertyChangeListener);
        this._mRightSensor.addPropertyChangeListener(this._mAnySensorPropertyChangeListener);
        this._mDispatcherSensorLockToggle.addPropertyChangeListener(this._mAnySensorPropertyChangeListener);
        this._mPauseActionListener = ActionEvent2 -> this.pauseActionListener();
        this._mPauseTimer = new Timer(pauseTimeInMilliseconds, this._mPauseActionListener);
        this._mPauseTimer.setRepeats(false);
    }

    public void removeAllListeners() {
        this._mSwitchLeverSensor.removePropertyChangeListener(this._mAnySensorPropertyChangeListener);
        this._mLeftSensor.removePropertyChangeListener(this._mAnySensorPropertyChangeListener);
        this._mNormalSensor.removePropertyChangeListener(this._mAnySensorPropertyChangeListener);
        this._mRightSensor.removePropertyChangeListener(this._mAnySensorPropertyChangeListener);
        this._mDispatcherSensorLockToggle.removePropertyChangeListener(this._mAnySensorPropertyChangeListener);
        this._mPauseTimer.stop();
        this._mPauseTimer.removeActionListener(this._mPauseActionListener);
    }

    private void pauseActionListener() {
        this._mPauseTimer.stop();
        this._mCodeButtonSensor.setKnownState(2);
        this._mCodeButtonSensor.setKnownState(4);
    }

    private void anySensorPropertyChangeEvent() {
        if (this._mPauseTimer.isRunning()) {
            return;
        }
        this._mPauseTimer.start();
    }
}

