/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import jmri.InstanceManager;
import jmri.jmrit.ctc.Bundle;
import jmri.jmrit.ctc.CTCExceptionBuffer;
import jmri.jmrit.ctc.CallOn;
import jmri.jmrit.ctc.CodeButtonHandler;
import jmri.jmrit.ctc.CtcManager;
import jmri.jmrit.ctc.Fleeting;
import jmri.jmrit.ctc.IndicationLockingSignals;
import jmri.jmrit.ctc.LockedRoutesManager;
import jmri.jmrit.ctc.NBHSensor;
import jmri.jmrit.ctc.SignalDirectionIndicators;
import jmri.jmrit.ctc.SignalDirectionIndicatorsInterface;
import jmri.jmrit.ctc.SignalDirectionIndicatorsNull;
import jmri.jmrit.ctc.SignalDirectionLever;
import jmri.jmrit.ctc.SwitchDirectionIndicators;
import jmri.jmrit.ctc.SwitchDirectionLever;
import jmri.jmrit.ctc.TrafficLocking;
import jmri.jmrit.ctc.TurnoutLock;
import jmri.jmrit.ctc.ctcserialdata.CTCSerialData;
import jmri.jmrit.ctc.ctcserialdata.CodeButtonHandlerData;
import jmri.jmrit.ctc.ctcserialdata.OtherData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CTCMain {
    private static final Logger log = LoggerFactory.getLogger(CTCMain.class);
    private final CTCSerialData _mCTCSerialData;
    private final ArrayList<CodeButtonHandler> _mCodeButtonHandlersArrayList = new ArrayList();
    private NBHSensor _mCTCDebugSystemReloadInternalSensor = null;
    private final PropertyChangeListener _mCTCDebugSystemReloadInternalSensorPropertyChangeListener = e -> this.handleCTCDebugSystemReload(e);
    private NBHSensor _mCTCDebug_TrafficLockingRuleTriggeredDisplayInternalSensor = null;
    private final PropertyChangeListener _mCTCDebug_TrafficLockingRuleTriggeredDisplayInternalSensorPropertyChangeListener = e -> this.handleLogging(e);
    private final HashMap<Integer, SignalDirectionIndicatorsInterface> _mSIDIHashMap = new HashMap();
    private final HashMap<Integer, SwitchDirectionIndicators> _mSWDIHashMap = new HashMap();
    private final HashMap<Integer, CodeButtonHandler> _mCBHashMap = new HashMap();
    private final LockedRoutesManager _mLockedRoutesManager = new LockedRoutesManager();
    private Timer _mLockTurnoutsTimer = null;
    private final CTCExceptionBuffer _mCTCExceptionBuffer = new CTCExceptionBuffer();
    public boolean _mCTCDebug_TrafficLockingRuleTriggeredDisplayLoggingEnabled = false;
    private final ActionListener lockTurnoutsTimerTicked = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            CTCMain.this._mLockTurnoutsTimer.stop();
            CTCMain.this._mLockTurnoutsTimer.removeActionListener(CTCMain.this.lockTurnoutsTimerTicked);
            CTCMain.this._mLockTurnoutsTimer = null;
            CTCMain.this.externalLockTurnout();
        }
    };

    public void externalLockTurnout() {
        for (CodeButtonHandler codeButtonHandler : this._mCodeButtonHandlersArrayList) {
            codeButtonHandler.externalLockTurnout();
        }
    }

    public CTCMain() {
        CtcManager mgr = InstanceManager.getDefault(CtcManager.class);
        this._mCTCSerialData = mgr.getCTCSerialData();
        InstanceManager.store(this._mCTCExceptionBuffer, CTCExceptionBuffer.class);
    }

    private void handleCTCDebugSystemReload(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("KnownState") && (Integer)e.getNewValue() == 2) {
            log.info(Bundle.getMessage("CTCMainShuttingDown"));
            this.shutdown();
            this.startup();
        }
    }

    private void handleLogging(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("KnownState")) {
            boolean bl = this._mCTCDebug_TrafficLockingRuleTriggeredDisplayLoggingEnabled = (Integer)e.getNewValue() == 2;
            if (this._mCTCDebug_TrafficLockingRuleTriggeredDisplayLoggingEnabled) {
                this._mLockedRoutesManager.dumpAllRoutes();
            }
        }
    }

    private void shutdown() {
        for (CodeButtonHandler codeButtonHandler : this._mCodeButtonHandlersArrayList) {
            codeButtonHandler.removeAllListeners();
        }
        this._mLockedRoutesManager.removeAllListeners();
        this._mCTCDebugSystemReloadInternalSensor.removePropertyChangeListener(this._mCTCDebugSystemReloadInternalSensorPropertyChangeListener);
        this._mCTCDebug_TrafficLockingRuleTriggeredDisplayInternalSensor.removePropertyChangeListener(this._mCTCDebug_TrafficLockingRuleTriggeredDisplayInternalSensorPropertyChangeListener);
    }

    void startup() {
        this._mLockedRoutesManager.clearAllLockedRoutes();
        SignalDirectionIndicators.resetSignalsUsed();
        OtherData otherData = this._mCTCSerialData.getOtherData();
        Fleeting fleeting = new Fleeting(otherData._mFleetingToggleInternalSensor, otherData._mDefaultFleetingEnabled);
        ArrayList<CodeButtonHandlerData> codeButtonHandlerDataList = this._mCTCSerialData.getCodeButtonHandlerDataArrayList();
        LinkedList trafficLockingFileReadComplete = new LinkedList();
        codeButtonHandlerDataList.forEach(codeButtonHandlerData -> {
            TrafficLocking trafficLocking;
            CallOn callOn;
            SwitchDirectionIndicators switchDirectionIndicators;
            boolean slavedSwitch = codeButtonHandlerData._mOSSectionSwitchSlavedToUniqueID != -1;
            String userIdentifier = String.valueOf(codeButtonHandlerData.myShortStringNoComma()) + ": ";
            boolean turnoutLockingOnlyEnabled = !codeButtonHandlerData._mSIDI_Enabled && !codeButtonHandlerData._mSIDL_Enabled && !codeButtonHandlerData._mSWDI_Enabled && !codeButtonHandlerData._mSWDL_Enabled && !codeButtonHandlerData._mCO_Enabled && !codeButtonHandlerData._mTRL_Enabled && codeButtonHandlerData._mTUL_Enabled && !codeButtonHandlerData._mIL_Enabled;
            SignalDirectionIndicatorsInterface signalDirectionIndicators = codeButtonHandlerData._mSIDI_Enabled && !slavedSwitch ? new SignalDirectionIndicators(userIdentifier, codeButtonHandlerData._mSIDI_LeftInternalSensor, codeButtonHandlerData._mSIDI_NormalInternalSensor, codeButtonHandlerData._mSIDI_RightInternalSensor, codeButtonHandlerData._mSIDI_CodingTimeInMilliseconds, codeButtonHandlerData._mSIDI_TimeLockingTimeInMilliseconds, codeButtonHandlerData._mSIDI_TrafficDirection, codeButtonHandlerData._mSIDI_LeftRightTrafficSignals, codeButtonHandlerData._mSIDI_RightLeftTrafficSignals, fleeting) : new SignalDirectionIndicatorsNull();
            this._mSIDIHashMap.put(codeButtonHandlerData._mUniqueID, signalDirectionIndicators);
            SignalDirectionLever signalDirectionLever = codeButtonHandlerData._mSIDL_Enabled && !slavedSwitch ? new SignalDirectionLever(userIdentifier, codeButtonHandlerData._mSIDL_LeftInternalSensor, codeButtonHandlerData._mSIDL_NormalInternalSensor, codeButtonHandlerData._mSIDL_RightInternalSensor) : null;
            SwitchDirectionIndicators switchDirectionIndicators2 = switchDirectionIndicators = codeButtonHandlerData._mSWDI_Enabled ? new SwitchDirectionIndicators(userIdentifier, codeButtonHandlerData._mSWDI_NormalInternalSensor, codeButtonHandlerData._mSWDI_ReversedInternalSensor, codeButtonHandlerData._mSWDI_ExternalTurnout, codeButtonHandlerData._mSWDI_CodingTimeInMilliseconds, codeButtonHandlerData._mSWDI_FeedbackDifferent) : null;
            if (switchDirectionIndicators != null) {
                this._mSWDIHashMap.put(codeButtonHandlerData._mUniqueID, switchDirectionIndicators);
            }
            SwitchDirectionLever switchDirectionLever = codeButtonHandlerData._mSWDL_Enabled ? new SwitchDirectionLever(userIdentifier, codeButtonHandlerData._mSWDL_InternalSensor) : null;
            CallOn callOn2 = callOn = codeButtonHandlerData._mCO_Enabled && !slavedSwitch ? new CallOn(this._mLockedRoutesManager, userIdentifier, codeButtonHandlerData._mCO_CallOnToggleInternalSensor, codeButtonHandlerData._mCO_GroupingsList, otherData._mSignalSystemType) : null;
            TurnoutLock turnoutLock = codeButtonHandlerData._mTUL_Enabled ? new TurnoutLock(userIdentifier, codeButtonHandlerData._mTUL_DispatcherInternalSensorLockToggle, codeButtonHandlerData._mTUL_ExternalTurnout, codeButtonHandlerData._mTUL_ExternalTurnoutFeedbackDifferent, codeButtonHandlerData._mTUL_DispatcherInternalSensorUnlockedIndicator, codeButtonHandlerData._mTUL_NoDispatcherControlOfSwitch, codeButtonHandlerData._mTUL_ndcos_WhenLockedSwitchStateIsClosed ? 2 : 4, codeButtonHandlerData._mTUL_LockImplementation, otherData._mTUL_EnabledAtStartup, codeButtonHandlerData._mTUL_AdditionalExternalTurnout1, codeButtonHandlerData._mTUL_AdditionalExternalTurnout1FeedbackDifferent, codeButtonHandlerData._mTUL_AdditionalExternalTurnout2, codeButtonHandlerData._mTUL_AdditionalExternalTurnout2FeedbackDifferent, codeButtonHandlerData._mTUL_AdditionalExternalTurnout3, codeButtonHandlerData._mTUL_AdditionalExternalTurnout3FeedbackDifferent) : null;
            IndicationLockingSignals indicationLockingSignals = null;
            if (slavedSwitch) {
                CodeButtonHandlerData slavedSwitchCodeButtonHandlerData = this._mCTCSerialData.getCodeButtonHandlerDataViaUniqueID(codeButtonHandlerData._mOSSectionSwitchSlavedToUniqueID);
                if (slavedSwitchCodeButtonHandlerData != null) {
                    indicationLockingSignals = new IndicationLockingSignals(userIdentifier, slavedSwitchCodeButtonHandlerData._mIL_Signals, codeButtonHandlerData._mSWDI_ExternalTurnout, otherData._mSignalSystemType);
                }
            } else if (codeButtonHandlerData._mIL_Enabled) {
                indicationLockingSignals = new IndicationLockingSignals(userIdentifier, codeButtonHandlerData._mIL_Signals, codeButtonHandlerData._mSWDI_ExternalTurnout, otherData._mSignalSystemType);
            }
            TrafficLocking trafficLocking2 = trafficLocking = codeButtonHandlerData._mTRL_Enabled && !slavedSwitch ? new TrafficLocking(userIdentifier, codeButtonHandlerData._mTRL_LeftTrafficLockingRules, codeButtonHandlerData._mTRL_RightTrafficLockingRules, this._mLockedRoutesManager) : null;
            if (trafficLocking != null) {
                trafficLockingFileReadComplete.add(trafficLocking);
            }
            CodeButtonHandler codeButtonHandler = new CodeButtonHandler(turnoutLockingOnlyEnabled, this._mLockedRoutesManager, userIdentifier, codeButtonHandlerData._mUniqueID, codeButtonHandlerData._mCodeButtonInternalSensor, codeButtonHandlerData._mCodeButtonDelayTime, codeButtonHandlerData._mOSSectionOccupiedExternalSensor, codeButtonHandlerData._mOSSectionOccupiedExternalSensor2, signalDirectionIndicators, signalDirectionLever, switchDirectionIndicators, switchDirectionLever, fleeting, callOn, trafficLocking, turnoutLock, indicationLockingSignals);
            this._mCodeButtonHandlersArrayList.add(codeButtonHandler);
            this._mCBHashMap.put(codeButtonHandlerData._mUniqueID, codeButtonHandler);
        });
        this._mCTCDebugSystemReloadInternalSensor = otherData._mCTCDebugSystemReloadInternalSensor;
        this._mCTCDebugSystemReloadInternalSensor.setKnownState(4);
        this._mCTCDebugSystemReloadInternalSensor.addPropertyChangeListener(this._mCTCDebugSystemReloadInternalSensorPropertyChangeListener);
        this._mCTCDebug_TrafficLockingRuleTriggeredDisplayInternalSensor = otherData._mCTCDebug_TrafficLockingRuleTriggeredDisplayInternalSensor;
        this._mCTCDebug_TrafficLockingRuleTriggeredDisplayInternalSensor.setKnownState(4);
        this._mCTCDebug_TrafficLockingRuleTriggeredDisplayInternalSensor.addPropertyChangeListener(this._mCTCDebug_TrafficLockingRuleTriggeredDisplayInternalSensorPropertyChangeListener);
        for (TrafficLocking trafficLocking : trafficLockingFileReadComplete) {
            trafficLocking.fileReadComplete(this._mCBHashMap, this._mSWDIHashMap);
        }
        if (otherData._mTUL_SecondsToLockTurnouts > 0) {
            this._mLockTurnoutsTimer = new Timer(otherData._mTUL_SecondsToLockTurnouts * 1000, this.lockTurnoutsTimerTicked);
            this._mLockTurnoutsTimer.setRepeats(false);
            this._mLockTurnoutsTimer.start();
        }
        if (!this._mCTCExceptionBuffer.isEmpty()) {
            int messageType;
            CTCExceptionBuffer.ExceptionBufferRecordSeverity exceptionBufferRecordSeverity2 = this._mCTCExceptionBuffer.getHighestExceptionBufferRecordSeverity();
            switch (exceptionBufferRecordSeverity2) {
                case ERROR: {
                    messageType = 0;
                    break;
                }
                case WARN: {
                    messageType = 2;
                    break;
                }
                default: {
                    messageType = 1;
                }
            }
            JOptionPane.showMessageDialog(null, this._mCTCExceptionBuffer.getAllMessages(), Bundle.getMessage("CTCMainRuntimeStartupIssues"), messageType);
        }
        log.info("CTC {} {}", (Object)"v2.0", (Object)Bundle.getMessage("CTCMainStarted"));
    }
}

