/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CTCFiles {
    private static final Logger log = LoggerFactory.getLogger(CTCFiles.class);

    public static File getFile(String fileName) {
        File chkdir = new File(CTCFiles.getFileLocation());
        if (!chkdir.exists() && !chkdir.mkdir()) {
            log.error("Create preference:ctc failed");
            return null;
        }
        return new File(CTCFiles.getFullName(fileName));
    }

    public static String getFileLocation() {
        return new File(FileUtil.getUserFilesPath(), "ctc").getAbsolutePath();
    }

    public static String getFullName(String fileName) {
        return new File(CTCFiles.getFileLocation(), fileName).getAbsolutePath();
    }

    public static boolean fileExists(String fileName) {
        File file = CTCFiles.getFile(fileName);
        return file == null ? false : file.exists();
    }

    public static boolean copyFile(String sourceFileName, String destFileName, boolean replace) {
        File sourceFile = CTCFiles.getFile(sourceFileName);
        File destFile = CTCFiles.getFile(destFileName);
        if (destFile.exists() && !replace) {
            log.error("Copy file {} failed: new file {} already exists", (Object)sourceFileName, (Object)destFileName);
            return false;
        }
        try {
            return Files.copy(sourceFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING) != null;
        }
        catch (IOException ex) {
            log.error("Copy file {} to {} failed, exception: ", new Object[]{sourceFileName, destFileName, ex});
            return false;
        }
    }

    public static boolean renameFile(String oldFileName, String newFileName, boolean replace) {
        File oldFile = CTCFiles.getFile(oldFileName);
        File newFile = CTCFiles.getFile(newFileName);
        if (newFile.exists() && !replace) {
            log.error("Rename file {} failed: new file {} already exists", (Object)oldFileName, (Object)newFileName);
            return false;
        }
        try {
            return Files.move(oldFile.toPath(), oldFile.toPath().resolveSibling(newFileName), StandardCopyOption.REPLACE_EXISTING) != null;
        }
        catch (IOException ex) {
            log.error("Rename file {} to {} failed, exception: ", new Object[]{oldFileName, newFileName, ex});
            return false;
        }
    }

    public static boolean deleteFile(String fileName) {
        File file = CTCFiles.getFile(fileName);
        if (!file.exists()) {
            return true;
        }
        try {
            Files.delete(file.toPath());
        }
        catch (IOException ex) {
            log.error("Delete file {} failed, exception: ", (Object)fileName, (Object)ex);
            return false;
        }
        return true;
    }

    public static String addExtensionIfMissing(String path, String missingExtension) {
        String filenameOnly = CTCFiles.getFilenameOnly(path);
        if (filenameOnly.indexOf(46) >= 0) {
            return path;
        }
        return String.valueOf(path) + missingExtension;
    }

    public static String changeExtensionTo(String path, String newExtension) {
        return CTCFiles.addExtensionIfMissing(CTCFiles.removeFileExtension(path), newExtension);
    }

    public static String removeFileExtension(String filename) {
        int lastIndexOf = filename.lastIndexOf(46);
        return lastIndexOf >= 1 ? filename.substring(0, lastIndexOf) : filename;
    }

    public static String getFilenameOnly(String path) {
        Path fileName;
        Path file = Paths.get(path, new String[0]);
        if (file != null && (fileName = file.getFileName()) != null) {
            return ((Object)fileName).toString();
        }
        return "";
    }
}

