/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import java.util.ArrayList;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.ctc.Bundle;

public class CTCExceptionBuffer
implements InstanceManagerAutoDefault {
    ArrayList<ExceptionBufferRecord> _mArrayListOfExceptionBufferRecords = new ArrayList();

    public void logString(ExceptionBufferRecordSeverity exceptionBufferRecordSeverity, String string) {
        this._mArrayListOfExceptionBufferRecords.add(new ExceptionBufferRecord(exceptionBufferRecordSeverity, string));
    }

    public boolean isEmpty() {
        return this._mArrayListOfExceptionBufferRecords.isEmpty();
    }

    public void clear() {
        this._mArrayListOfExceptionBufferRecords.clear();
    }

    public ExceptionBufferRecordSeverity getHighestExceptionBufferRecordSeverity() {
        ExceptionBufferRecordSeverity highestExceptionBufferRecordSeverityEncountered = ExceptionBufferRecordSeverity.INFO;
        for (ExceptionBufferRecord exceptionBufferRecord : this._mArrayListOfExceptionBufferRecords) {
            if (exceptionBufferRecord._mExceptionBufferRecordSeverity.getSeverity() <= highestExceptionBufferRecordSeverityEncountered.getSeverity()) continue;
            highestExceptionBufferRecordSeverityEncountered = exceptionBufferRecord._mExceptionBufferRecordSeverity;
        }
        return highestExceptionBufferRecordSeverityEncountered;
    }

    public String getAllMessages() {
        StringBuilder returnStringBuilder = new StringBuilder("<html>");
        for (ExceptionBufferRecord exceptionBufferRecord : this._mArrayListOfExceptionBufferRecords) {
            returnStringBuilder.append(String.valueOf(exceptionBufferRecord._mMessage) + "<br>");
        }
        returnStringBuilder.append("</html>");
        return returnStringBuilder.toString();
    }

    private static class ExceptionBufferRecord {
        public final ExceptionBufferRecordSeverity _mExceptionBufferRecordSeverity;
        public final String _mMessage;

        public ExceptionBufferRecord(ExceptionBufferRecordSeverity exceptionBufferRecordSeverity, String message) {
            this._mExceptionBufferRecordSeverity = exceptionBufferRecordSeverity;
            switch (exceptionBufferRecordSeverity) {
                case ERROR: {
                    this._mMessage = String.valueOf(Bundle.getMessage("CTCExceptionBufferERROR")) + message;
                    break;
                }
                case WARN: {
                    this._mMessage = String.valueOf(Bundle.getMessage("CTCExceptionBufferWARN")) + message;
                    break;
                }
                default: {
                    this._mMessage = String.valueOf(Bundle.getMessage("CTCExceptionBufferINFO")) + message;
                }
            }
        }
    }

    public static enum ExceptionBufferRecordSeverity {
        INFO(0),
        WARN(1),
        ERROR(2);

        private final int _mSeverity;

        private ExceptionBufferRecordSeverity(int severity) {
            this._mSeverity = severity;
        }

        public int getSeverity() {
            return this._mSeverity;
        }
    }
}

