/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import jmri.InstanceManager;
import jmri.jmrit.ctc.CTCExceptionBuffer;
import org.slf4j.LoggerFactory;

public class CTCException
extends Exception {
    private final String _mModule;
    private final String _mUserIdentifier;
    private final String _mParameter;
    private final String _mReason;

    public CTCException(String module, String userIdentifier, String parameter, String reason) {
        this._mModule = module;
        this._mUserIdentifier = userIdentifier;
        this._mParameter = parameter;
        this._mReason = reason;
    }

    public String getExceptionString() {
        return String.valueOf(this._mModule) + ", " + this._mUserIdentifier + this._mParameter + ", " + this._mReason;
    }

    public void logError() {
        String exceptionString = this.getExceptionString();
        LoggerFactory.getLogger(CTCException.class).error(exceptionString);
        InstanceManager.getDefault(CTCExceptionBuffer.class).logString(CTCExceptionBuffer.ExceptionBufferRecordSeverity.ERROR, exceptionString);
    }

    public void logWarning() {
        String exceptionString = this.getExceptionString();
        LoggerFactory.getLogger(CTCException.class).warn(exceptionString);
        InstanceManager.getDefault(CTCExceptionBuffer.class).logString(CTCExceptionBuffer.ExceptionBufferRecordSeverity.WARN, exceptionString);
    }

    public static void logError(String string) {
        LoggerFactory.getLogger(CTCException.class).error(string);
        InstanceManager.getDefault(CTCExceptionBuffer.class).logString(CTCExceptionBuffer.ExceptionBufferRecordSeverity.ERROR, string);
    }

    public static void logWarning(String string) {
        LoggerFactory.getLogger(CTCException.class).warn(string);
        InstanceManager.getDefault(CTCExceptionBuffer.class).logString(CTCExceptionBuffer.ExceptionBufferRecordSeverity.WARN, string);
    }

    public static void logInfo(String string) {
        LoggerFactory.getLogger(CTCException.class).info(string);
        InstanceManager.getDefault(CTCExceptionBuffer.class).logString(CTCExceptionBuffer.ExceptionBufferRecordSeverity.INFO, string);
    }
}

