/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.consisttool;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jmri.Consist;
import jmri.ConsistListListener;
import jmri.ConsistListener;
import jmri.ConsistManager;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.jmrit.DccLocoAddressSelector;
import jmri.jmrit.consisttool.Bundle;
import jmri.jmrit.consisttool.ConsistDataModel;
import jmri.jmrit.consisttool.ConsistFile;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.GlobalRosterEntryComboBox;
import jmri.jmrit.roster.swing.RosterEntryComboBox;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.util.JmriJFrame;
import jmri.util.LocoAddressComparator;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistToolFrame
extends JmriJFrame
implements ConsistListener,
ConsistListListener {
    JLabel textAdrLabel = new JLabel();
    DccLocoAddressSelector adrSelector = new DccLocoAddressSelector();
    JComboBox<Object> consistAdrBox = new JComboBox();
    JRadioButton isAdvancedConsist = new JRadioButton(Bundle.getMessage("AdvancedConsistButtonText"));
    JRadioButton isCSConsist = new JRadioButton(Bundle.getMessage("CommandStationConsistButtonText"));
    JButton deleteButton = new JButton();
    JButton throttleButton = new JButton();
    JButton reverseButton = new JButton();
    JButton restoreButton = new JButton();
    JLabel textLocoLabel = new JLabel();
    DccLocoAddressSelector locoSelector = new DccLocoAddressSelector();
    RosterEntryComboBox locoRosterBox;
    JButton addLocoButton = new JButton();
    JButton resetLocoButton = new JButton();
    JCheckBox locoDirectionNormal = new JCheckBox(Bundle.getMessage("DirectionNormalText"));
    ConsistDataModel consistModel = new ConsistDataModel();
    JTable consistTable = new JTable(this.consistModel);
    ConsistManager consistManager = null;
    JLabel _status = new JLabel(Bundle.getMessage("DefaultStatusText"));
    private int _Consist_Type = 0;
    private ConsistFile consistFile = null;
    private boolean _readConsistFile = true;
    private static final Logger log = LoggerFactory.getLogger(ConsistToolFrame.class);

    public ConsistToolFrame() {
        this.init();
    }

    private void init() {
        this.consistManager = InstanceManager.getDefault(ConsistManager.class);
        this.consistFile = new ConsistFile();
        try {
            this.consistFile.readFile();
        }
        catch (IOException | JDOMException e2) {
            log.warn("error reading consist file: {}", (Object)e2.getMessage());
        }
        this.consistManager.addConsistListListener(this);
        this.consistManager.requestUpdateFromLayout();
        this.textAdrLabel.setText(Bundle.getMessage("AddressLabelText"));
        this.textAdrLabel.setVisible(true);
        this.adrSelector.setVisible(true);
        this.adrSelector.setToolTipText(Bundle.getMessage("AddressSelectorToolTip"));
        this.textAdrLabel.setLabelFor(this.adrSelector);
        this.initializeConsistBox();
        this.consistAdrBox.addActionListener(e -> this.consistSelected());
        this.consistAdrBox.setToolTipText(Bundle.getMessage("ConsistAddressBoxToolTip"));
        this.isAdvancedConsist.setSelected(true);
        this.isAdvancedConsist.setVisible(true);
        this.isAdvancedConsist.setEnabled(false);
        this.isAdvancedConsist.addActionListener(e -> {
            this.isAdvancedConsist.setSelected(true);
            this.isCSConsist.setSelected(false);
            this._Consist_Type = 0;
            this.adrSelector.setEnabled(true);
        });
        this.isCSConsist.setSelected(false);
        this.isCSConsist.setVisible(true);
        this.isCSConsist.setEnabled(false);
        this.isCSConsist.addActionListener(e -> {
            this.isAdvancedConsist.setSelected(false);
            this.isCSConsist.setSelected(true);
            this._Consist_Type = 1;
            this.adrSelector.setEnabled(this.consistManager.csConsistNeedsSeperateAddress());
        });
        if (this.consistManager.isCommandStationConsistPossible()) {
            this.isAdvancedConsist.setEnabled(true);
            this.isCSConsist.setEnabled(true);
        }
        this.deleteButton.setText(Bundle.getMessage("ButtonDelete"));
        this.deleteButton.setVisible(true);
        this.deleteButton.setToolTipText(Bundle.getMessage("DeleteButtonToolTip"));
        this.deleteButton.addActionListener(this::deleteButtonActionPerformed);
        this.throttleButton.setText(Bundle.getMessage("ThrottleButtonText"));
        this.throttleButton.setVisible(true);
        this.throttleButton.setToolTipText(Bundle.getMessage("ThrottleButtonToolTip"));
        this.throttleButton.addActionListener(this::throttleButtonActionPerformed);
        this.reverseButton.setText(Bundle.getMessage("ReverseButtonText"));
        this.reverseButton.setVisible(true);
        this.reverseButton.setToolTipText(Bundle.getMessage("ReverseButtonToolTip"));
        this.reverseButton.addActionListener(this::reverseButtonActionPerformed);
        this.restoreButton.setText(Bundle.getMessage("RestoreButtonText"));
        this.restoreButton.setVisible(true);
        this.restoreButton.setToolTipText(Bundle.getMessage("RestoreButtonToolTip"));
        this.restoreButton.addActionListener(this::restoreButtonActionPerformed);
        this.textLocoLabel.setText(Bundle.getMessage("LocoLabelText"));
        this.textLocoLabel.setVisible(true);
        this.locoSelector.setToolTipText(Bundle.getMessage("LocoSelectorToolTip"));
        this.locoSelector.setVisible(true);
        this.textLocoLabel.setLabelFor(this.locoSelector);
        this.locoSelector.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                ConsistToolFrame.this.locoRosterBox.setSelectedIndex(0);
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.locoRosterBox = new GlobalRosterEntryComboBox();
        this.locoRosterBox.setNonSelectedItem("");
        this.locoRosterBox.setSelectedIndex(0);
        this.locoRosterBox.addPropertyChangeListener("selectedRosterEntries", pce -> this.locoSelected());
        this.locoRosterBox.setVisible(true);
        this.locoDirectionNormal.setToolTipText(Bundle.getMessage("DirectionNormalToolTip"));
        this.locoDirectionNormal.setSelected(true);
        this.locoDirectionNormal.setVisible(true);
        this.locoDirectionNormal.setEnabled(false);
        this.addLocoButton.setText(Bundle.getMessage("ButtonAddText"));
        this.addLocoButton.setVisible(true);
        this.addLocoButton.setToolTipText(Bundle.getMessage("AddButtonToolTip"));
        this.addLocoButton.addActionListener(this::addLocoButtonActionPerformed);
        this.resetLocoButton.setText(Bundle.getMessage("ButtonReset"));
        this.resetLocoButton.setVisible(true);
        this.resetLocoButton.setToolTipText(Bundle.getMessage("ResetButtonToolTip"));
        this.resetLocoButton.addActionListener(this::resetLocoButtonActionPerformed);
        this.setTitle(Bundle.getMessage("ConsistToolTitle"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        menuBar.add(fileMenu);
        fileMenu.add(new AbstractAction(Bundle.getMessage("ScanConsists")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsistToolFrame.this.scanRoster();
                ConsistToolFrame.this.initializeConsistBox();
                ConsistToolFrame.this.consistModel.fireTableDataChanged();
                ConsistToolFrame.this.resetLocoButtonActionPerformed(e);
            }
        });
        JPanel addressPanel = new JPanel();
        addressPanel.setLayout(new FlowLayout());
        addressPanel.add(this.textAdrLabel);
        addressPanel.add(this.adrSelector.getCombinedJPanel());
        addressPanel.add(this.consistAdrBox);
        addressPanel.add(this.isAdvancedConsist);
        addressPanel.add(this.isCSConsist);
        this.getContentPane().add(addressPanel);
        JPanel locoPanel = new JPanel();
        locoPanel.setLayout(new FlowLayout());
        locoPanel.add(this.textLocoLabel);
        locoPanel.add(this.locoSelector.getCombinedJPanel());
        locoPanel.add(this.locoRosterBox);
        locoPanel.add(this.locoDirectionNormal);
        locoPanel.add(this.addLocoButton);
        locoPanel.add(this.resetLocoButton);
        this.getContentPane().add(locoPanel);
        JScrollPane consistPane = new JScrollPane(this.consistTable);
        consistPane.setVerticalScrollBarPolicy(20);
        this.consistModel.initTable(this.consistTable);
        this.getContentPane().add(consistPane);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new FlowLayout());
        controlPanel.add(this.deleteButton);
        controlPanel.add(this.throttleButton);
        controlPanel.add(this.reverseButton);
        controlPanel.add(this.restoreButton);
        this.getContentPane().add(controlPanel);
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new FlowLayout());
        statusPanel.add(this._status);
        this.getContentPane().add(statusPanel);
        this.addHelpMenu("package.jmri.jmrit.consisttool.ConsistToolFrame", true);
        this.pack();
    }

    private void initializeConsistBox() {
        ArrayList<LocoAddress> existingConsists = this.consistManager.getConsistList();
        if (!existingConsists.isEmpty()) {
            Collections.sort(existingConsists, new LocoAddressComparator());
            this.consistAdrBox.removeAllItems();
            existingConsists.forEach(consist -> this.consistAdrBox.addItem(consist));
            this.consistAdrBox.setEnabled(true);
            this.consistAdrBox.insertItemAt("", 0);
            this.consistAdrBox.setSelectedItem(this.adrSelector.getAddress());
            if (this.adrSelector.getAddress() != null) {
                if (this.consistModel.getConsist() != null) {
                    this.consistModel.getConsist().removeConsistListener(this);
                    this.setDefaultStatus();
                }
                this.consistModel.setConsist(this.adrSelector.getAddress());
                this.consistModel.getConsist().addConsistListener(this);
                this.adrSelector.setEnabled(false);
            } else {
                if (this.consistModel.getConsist() != null) {
                    this.consistModel.getConsist().removeConsistListener(this);
                    this.setDefaultStatus();
                }
                this.consistModel.setConsist((Consist)null);
                this.adrSelector.setEnabled(true);
            }
        } else {
            this.consistAdrBox.setEnabled(false);
            this.consistAdrBox.removeAllItems();
            this.consistAdrBox.insertItemAt("", 0);
            this.consistAdrBox.setSelectedIndex(0);
            if (this.consistModel.getConsist() != null) {
                this.consistModel.getConsist().removeConsistListener(this);
                this.setDefaultStatus();
            }
            this.consistModel.setConsist((Consist)null);
            this.adrSelector.setEnabled(true);
        }
    }

    public void deleteButtonActionPerformed(ActionEvent e) {
        if (this.adrSelector.getAddress() == null) {
            this.reportNoConsistSeletected();
            return;
        }
        DccLocoAddress address = this.adrSelector.getAddress();
        this.consistManager.getConsist(address);
        if (JOptionPane.showConfirmDialog(this, Bundle.getMessage("DeleteWarningDialog", address), Bundle.getMessage("QuestionTitle"), 0, 3) == 1) {
            return;
        }
        try {
            this.consistManager.delConsist(address);
        }
        catch (Exception ex) {
            log.error("Error delting consist {}", (Object)address, (Object)ex);
        }
        this.adrSelector.reset();
        this.adrSelector.setEnabled(true);
        this.initializeConsistBox();
        try {
            this.consistFile.writeFile(this.consistManager.getConsistList());
        }
        catch (IOException ex) {
            log.warn("error writing consist file: {}", (Object)ex.getMessage());
        }
        this.resetLocoButtonActionPerformed(e);
        this.canAdd();
    }

    public void throttleButtonActionPerformed(ActionEvent e) {
        if (this.adrSelector.getAddress() == null) {
            this.reportNoConsistSeletected();
            return;
        }
        this.addLocoButtonActionPerformed(e);
        ThrottleFrame tf = InstanceManager.getDefault(ThrottleFrameManager.class).createThrottleFrame();
        DccLocoAddress address = this.adrSelector.getAddress();
        Consist tempConsist = this.consistManager.getConsist(address);
        ArrayList<DccLocoAddress> addressList = tempConsist.getConsistList();
        DccLocoAddress locoaddress = addressList.get(0);
        if (address != locoaddress) {
            log.debug("Consist Address {}, Lead Locomoitve  {}", (Object)address, (Object)locoaddress);
            tf.getAddressPanel().setCurrentAddress(locoaddress);
        }
        tf.getAddressPanel().setConsistAddress(address);
        tf.toFront();
    }

    public void reverseButtonActionPerformed(ActionEvent e) {
        if (this.adrSelector.getAddress() == null) {
            this.reportNoConsistSeletected();
            return;
        }
        this.addLocoButtonActionPerformed(e);
        DccLocoAddress address = this.adrSelector.getAddress();
        Consist tempConsist = this.consistManager.getConsist(address);
        tempConsist.reverse();
    }

    public void restoreButtonActionPerformed(ActionEvent e) {
        if (this.adrSelector.getAddress() == null) {
            this.reportNoConsistSeletected();
            return;
        }
        this.addLocoButtonActionPerformed(e);
        DccLocoAddress address = this.adrSelector.getAddress();
        Consist tempConsist = this.consistManager.getConsist(address);
        tempConsist.restore();
    }

    public void consistSelected() {
        log.debug("Consist Selected");
        if (this.consistAdrBox.getSelectedIndex() == -1 && this.adrSelector.getAddress() != null) {
            log.debug("No Consist Selected");
            this.adrSelector.setEnabled(false);
            this.recallConsist();
        } else if (this.consistAdrBox.getSelectedIndex() == -1 || this.consistAdrBox.getSelectedItem().equals("")) {
            log.debug("Null Consist Selected");
            this.adrSelector.reset();
            this.adrSelector.setEnabled(true);
            this.recallConsist();
        } else if ((DccLocoAddress)this.consistAdrBox.getSelectedItem() != this.adrSelector.getAddress()) {
            log.debug("Consist {} Selected", this.consistAdrBox.getSelectedItem());
            this.adrSelector.setEnabled(false);
            this.adrSelector.setAddress((DccLocoAddress)this.consistAdrBox.getSelectedItem());
            this.recallConsist();
        }
    }

    private void recallConsist() {
        if (this.adrSelector.getAddress() == null) {
            this.locoSelector.reset();
            this.locoRosterBox.setSelectedIndex(0);
            if (this.consistModel.getConsist() != null) {
                this.consistModel.getConsist().removeConsistListener(this);
                this.setDefaultStatus();
            }
            this.consistModel.setConsist((Consist)null);
            this.canAdd();
            return;
        }
        DccLocoAddress address = this.adrSelector.getAddress();
        if (this.consistModel.getConsist() != null) {
            this.consistModel.getConsist().removeConsistListener(this);
            this._status.setText(Bundle.getMessage("DefaultStatusText"));
            this.setDefaultStatus();
        }
        Consist selectedConsist = this.consistManager.getConsist(address);
        this.consistModel.setConsist(selectedConsist);
        selectedConsist.addConsistListener(this);
        this.locoSelector.reset();
        this.locoRosterBox.setSelectedIndex(0);
        this.locoDirectionNormal.setSelected(true);
        this.locoDirectionNormal.setEnabled(this.consistModel.getRowCount() != 0);
        log.debug("Recall Consist {}", (Object)address);
        if (selectedConsist.getConsistType() == 0) {
            log.debug("Consist type is Advanced Consist ");
            this.isAdvancedConsist.setSelected(true);
            this.isCSConsist.setSelected(false);
            this._Consist_Type = 0;
        } else {
            log.debug("Consist type is Command Station Consist ");
            this.isAdvancedConsist.setSelected(false);
            this.isCSConsist.setSelected(true);
            this._Consist_Type = 1;
        }
        this.canAdd();
    }

    public void resetLocoButtonActionPerformed(ActionEvent e) {
        this.locoSelector.reset();
        this.locoRosterBox.setSelectedIndex(0);
        this.locoDirectionNormal.setSelected(true);
        this.locoDirectionNormal.setEnabled(this.consistModel.getRowCount() != 0);
    }

    public void canAdd() {
        if (this.adrSelector.getAddress() != null) {
            DccLocoAddress address = this.adrSelector.getAddress();
            if (this.consistModel.getRowCount() == this.consistManager.getConsist(address).sizeLimit()) {
                this.locoSelector.setEnabled(false);
                this.locoRosterBox.setEnabled(false);
                this.addLocoButton.setEnabled(false);
                this.resetLocoButton.setEnabled(false);
                this.locoDirectionNormal.setEnabled(false);
            } else {
                this.enableGuiControls();
            }
        } else {
            this.enableGuiControls();
        }
    }

    private void enableGuiControls() {
        this.locoSelector.setEnabled(true);
        this.locoRosterBox.setEnabled(true);
        this.addLocoButton.setEnabled(true);
        this.resetLocoButton.setEnabled(true);
        this.locoDirectionNormal.setEnabled(false);
        this.locoDirectionNormal.setEnabled(this.consistModel.getRowCount() != 0);
    }

    public void addLocoButtonActionPerformed(ActionEvent e) {
        DccLocoAddress address;
        if (this.locoSelector.getAddress() == null) {
            return;
        }
        if (this._Consist_Type == 0 && this.adrSelector.getAddress() == null) {
            this.reportNoConsistSeletected();
            return;
        }
        if (this._Consist_Type == 0 && this.adrSelector.getAddress().isLongAddress()) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("RequiresShortConsistError"));
            return;
        }
        if (this._Consist_Type == 1 && this.adrSelector.getAddress() == null) {
            if (this.consistManager.csConsistNeedsSeperateAddress()) {
                this.reportNoConsistSeletected();
                return;
            }
            this.adrSelector.setAddress(this.locoSelector.getAddress());
        }
        if (this._Consist_Type != this.consistManager.getConsist(address = this.adrSelector.getAddress()).getConsistType()) {
            if (log.isDebugEnabled()) {
                if (this._Consist_Type == 0) {
                    log.debug("Setting Consist Type to Advanced Consist");
                } else if (this._Consist_Type == 1) {
                    log.debug("Setting Consist Type to Command Station Assisted Consist");
                }
            }
            this.consistManager.getConsist(address).setConsistType(this._Consist_Type);
        }
        DccLocoAddress locoaddress = this.locoSelector.getAddress();
        if (!this.consistManager.getConsist(address).isAddressAllowed(locoaddress)) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("AddressNotAllowedError"));
        } else {
            if (this.consistManager.getConsist(address).contains(locoaddress)) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("AddressAlreadyInConsistError"));
            } else {
                Consist tempConsist = this.consistManager.getConsist(address);
                tempConsist.add(locoaddress, this.locoDirectionNormal.isSelected());
                if (this.locoRosterBox.getSelectedRosterEntries().length == 1) {
                    tempConsist.setRosterId(locoaddress, this.locoRosterBox.getSelectedRosterEntries()[0].titleString());
                }
            }
            if (this.consistAdrBox.getSelectedItem() != this.adrSelector.getAddress()) {
                this.initializeConsistBox();
            }
            this.consistModel.fireTableDataChanged();
            this.resetLocoButtonActionPerformed(e);
        }
    }

    public void locoSelected() {
        if (this.locoRosterBox.getSelectedRosterEntries().length == 1) {
            this.locoSelector.setAddress(this.locoRosterBox.getSelectedRosterEntries()[0].getDccLocoAddress());
        }
    }

    @Override
    public void consistReply(LocoAddress locoaddress, int status) {
        log.debug("Consist Reply received for Locomotive {} with status {}", (Object)locoaddress, (Object)status);
        this._status.setText(this.consistManager.decodeErrorCode(status));
        this.canAdd();
        this.consistModel.fireTableDataChanged();
        try {
            this.consistFile.writeFile(this.consistManager.getConsistList());
        }
        catch (IOException e) {
            log.warn("error writing consist file: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.consistManager.removeConsistListListener(this);
    }

    @Override
    public void notifyConsistListChanged() {
        if (this._readConsistFile) {
            try {
                this.consistFile.readFile();
            }
            catch (IOException | JDOMException e) {
                log.warn("error reading consist file: {}", (Object)e.getMessage());
            }
            this._readConsistFile = false;
        }
        this.initializeConsistBox();
    }

    private void scanRoster() {
        List<RosterEntry> roster = Roster.getDefault().getAllEntries();
        for (RosterEntry entry : roster) {
            DccLocoAddress address = entry.getDccLocoAddress();
            CvTableModel cvTable = new CvTableModel(this._status, null);
            entry.readFile();
            entry.loadCvModel(null, cvTable);
            CvValue cv19Value = cvTable.getCvByNumber("19");
            if (cv19Value == null || (cv19Value.getValue() & 0x7F) == 0) continue;
            boolean direction = (cv19Value.getValue() & 0x80) == 0;
            DccLocoAddress consistAddress = new DccLocoAddress(cv19Value.getValue() & 0x7F, false);
            Consist consist = this.consistManager.getConsist(consistAddress);
            if (consist.getConsistType() != 0) {
                consist.setConsistType(0);
            }
            if (consist.contains(address)) continue;
            consist.add(address, direction);
            consist.setRosterId(address, entry.titleString());
        }
    }

    private void reportNoConsistSeletected() {
        JOptionPane.showMessageDialog(this, Bundle.getMessage("NoConsistSelectedError"));
    }

    public void setDefaultStatus() {
        this._status.setText(Bundle.getMessage("DefaultStatusText"));
    }
}

