/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.consisttool;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import jmri.profile.Profile;
import jmri.profile.ProfileUtils;
import jmri.util.prefs.AbstractPreferencesManager;
import jmri.util.prefs.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistPreferencesManager
extends AbstractPreferencesManager {
    private static final Logger log = LoggerFactory.getLogger(ConsistPreferencesManager.class);
    public static final String UPDATE_CV19 = "updateCV19";
    private boolean updateCV19 = false;

    @Override
    public void initialize(Profile profile) throws InitializationException {
        if (!this.isInitialized(profile)) {
            Preferences preferences = ProfileUtils.getPreferences(profile, this.getClass(), true);
            this.setUpdateCV19(preferences.getBoolean(UPDATE_CV19, this.isUpdateCV19()));
            this.setInitialized(profile, true);
        }
    }

    @Override
    public void savePreferences(Profile profile) {
        Preferences preferences = ProfileUtils.getPreferences(profile, this.getClass(), true);
        preferences.putBoolean(UPDATE_CV19, this.updateCV19);
        try {
            preferences.sync();
        }
        catch (BackingStoreException ex) {
            log.error("Unable to save preferences.", (Throwable)ex);
        }
    }

    public boolean isUpdateCV19() {
        return this.updateCV19;
    }

    public void setUpdateCV19(boolean update) {
        boolean oldUpdateCV19 = this.updateCV19;
        this.updateCV19 = update;
        this.firePropertyChange(UPDATE_CV19, oldUpdateCV19, this.updateCV19);
    }
}

