/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.consisttool;

import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jmri.Consist;
import jmri.ConsistManager;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.jmrit.consisttool.Bundle;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistDataModel
extends AbstractTableModel {
    private static final int ADDRCOLUMN = 0;
    private static final int ROSTERCOLUMN = 1;
    private static final int DIRECTIONCOLUMN = 2;
    private static final int DELCOLUMN = 3;
    private static final int NUMCOLUMN = 4;
    private Consist _consist = null;
    private ConsistManager consistMan = InstanceManager.getDefault(ConsistManager.class);
    private static final Logger log = LoggerFactory.getLogger(ConsistDataModel.class);

    ConsistDataModel() {
    }

    void initTable(JTable ConsistTable) {
        TableColumnModel tcm = ConsistTable.getColumnModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        tcm.getColumn(3).setCellRenderer(buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(3).setCellEditor(buttonEditor);
    }

    public void setConsist(Consist consist) {
        log.debug("Setting Consist");
        this._consist = consist;
        this.fireTableDataChanged();
    }

    public void setConsist(DccLocoAddress Address2) {
        log.debug("Setting Consist using address: {}", (Object)Address2);
        this._consist = this.consistMan.getConsist(Address2);
        this.fireTableDataChanged();
    }

    public Consist getConsist() {
        return this._consist;
    }

    @Override
    public int getRowCount() {
        try {
            return this._consist.getConsistList().size();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("AddressColumnLabel");
            }
            case 1: {
                return Bundle.getMessage("RosterColumnLabel");
            }
            case 2: {
                return Bundle.getMessage("DirectionColumnLabel");
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 1: {
                return String.class;
            }
            case 3: {
                return JButton.class;
            }
            case 2: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        log.debug("isCellEditable called for row: {} column: {}", (Object)row, (Object)col);
        if (col == 3) {
            return true;
        }
        return row != 0 && col == 2;
    }

    @Override
    public Object getValueAt(int row, int col) {
        log.debug("getValueAt called for row: {} column: {}", (Object)row, (Object)col);
        if (this._consist == null) {
            log.debug("Consist not defined");
            return null;
        }
        if (row >= this._consist.getConsistList().size()) {
            log.debug("row is greater than consist list size");
            return null;
        }
        switch (col) {
            case 0: {
                return this._consist.getConsistList().get(row).toString();
            }
            case 1: {
                return this._consist.getRosterId(this._consist.getConsistList().get(row));
            }
            case 2: {
                return this._consist.getLocoDirection(this._consist.getConsistList().get(row));
            }
            case 3: {
                return Bundle.getMessage("ButtonDelete");
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        log.debug("setValueAt called for row: {} column: {}", (Object)row, (Object)col);
        if (this._consist == null) {
            return;
        }
        switch (col) {
            case 2: {
                this._consist.add(this._consist.getConsistList().get(row), (Boolean)value);
                this.fireTableDataChanged();
                break;
            }
            case 3: {
                log.debug("Delete Called for row {}", (Object)row);
                this.fireTableRowsDeleted(row, row);
                this._consist.remove(this._consist.getConsistList().get(row));
                this.fireTableDataChanged();
                break;
            }
            default: {
                log.error("Unknown Consist Operation");
            }
        }
    }
}

