/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.conditional;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jmri.Conditional;
import jmri.ConditionalAction;
import jmri.ConditionalVariable;
import jmri.InstanceManager;
import jmri.Light;
import jmri.Logix;
import jmri.NamedBean;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.UserPreferencesManager;
import jmri.VariableLight;
import jmri.implementation.DefaultConditional;
import jmri.implementation.DefaultConditionalAction;
import jmri.jmrit.beantable.LRouteTableAction;
import jmri.jmrit.conditional.Bundle;
import jmri.jmrit.conditional.ConditionalEditBase;
import jmri.jmrit.logix.OBlock;
import jmri.swing.NamedBeanComboBox;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.NoArchiveFileFilter;
import jmri.util.swing.JComboBoxUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalTreeEdit
extends ConditionalEditBase {
    JPanel _curDetailPanel = new JPanel();
    JTextField _editLogixUserName = new JTextField(20);
    NamedBeanComboBox<?> _comboNameBox = null;
    JPanel _detailGrid = new JPanel();
    JPanel _detailFooter = new JPanel();
    JPanel _gridPanel;
    JTextField _editConditionalUserName;
    JTextField _editAntecedent;
    JComboBox<Conditional.AntecedentOperator> _editOperatorMode;
    boolean _editActive = false;
    JButton _cancelAction;
    JButton _updateAction;
    String _pickCommand = null;
    Conditional.ItemType _pickItem = Conditional.ItemType.NONE;
    JTree _cdlTree;
    DefaultTreeModel _cdlModel;
    DefaultMutableTreeNode _cdlRoot;
    TreeSelectionListener _cdlListener;
    TreePath _curTreePath = null;
    ConditionalTreeNode _cdlNode = null;
    ConditionalTreeNode _varHead = null;
    ConditionalTreeNode _varNode = null;
    ConditionalTreeNode _actHead = null;
    ConditionalTreeNode _actNode = null;
    ConditionalTreeNode _leafNode = null;
    ConditionalTreeNode _curNode = null;
    String _curNodeName = null;
    String _curNodeType = null;
    String _curNodeText = null;
    int _curNodeRow = -1;
    JPanel _leftButtonBar;
    JPanel _labelPanel;
    JPanel _addButtonPanel;
    JPanel _toggleButtonPanel;
    JPanel _checkButtonPanel;
    JPanel _moveButtonPanel;
    JPanel _deleteButtonPanel;
    JPanel _helpButtonPanel;
    JLabel _conditionalLabel = new JLabel(Bundle.getMessage("LabelConditionalActions"));
    JLabel _antecedentLabel = new JLabel(Bundle.getMessage("LabelAntecedentActions"));
    JLabel _logicTypeLabel = new JLabel(Bundle.getMessage("LabelLogicTypeActions"));
    JLabel _triggerModeLabel = new JLabel(Bundle.getMessage("LabelTriggerModeActions"));
    JLabel _variablesLabel = new JLabel(Bundle.getMessage("LabelVariablesActions"));
    JLabel _variableLabel = new JLabel(Bundle.getMessage("LabelVariableActions"));
    JLabel _actionsLabel = new JLabel(Bundle.getMessage("LabelActionsActions"));
    JLabel _actionLabel = new JLabel(Bundle.getMessage("LabelActionActions"));
    Conditional _curConditional;
    List<ConditionalVariable> _variableList;
    List<ConditionalAction> _actionList;
    ConditionalVariable _curVariable;
    ConditionalAction _curAction;
    Conditional.ItemType _curVariableItem = Conditional.ItemType.NONE;
    Conditional.ItemType _curActionItem = Conditional.ItemType.NONE;
    String _curConditionalName = "";
    String _antecedent;
    Conditional.AntecedentOperator _logicType;
    boolean _triggerMode;
    boolean _newActionItem = false;
    boolean _newVariableItem = false;
    TreeSet<String> _oldTargetNames = new TreeSet();
    JComboBox<String> _selectLogixBox = new JComboBox();
    JComboBox<String> _selectConditionalBox = new JComboBox();
    TreeMap<String, String> _selectLogixMap = new TreeMap();
    ArrayList<String> _selectConditionalList = new ArrayList();
    JComboBox<Conditional.ItemType> _variableItemBox;
    JComboBox<Conditional.Type> _variableStateBox;
    JComboBox<String> _variableOperBox;
    JCheckBox _variableNegated;
    JCheckBox _variableTriggerActions;
    JTextField _variableNameField;
    JLabel _variableNameLabel = new JLabel(Bundle.getMessage("LabelItemName"));
    JComboBox<String> _variableCompareOpBox;
    JComboBox<String> _variableSignalBox;
    JComboBox<Conditional.Type> _variableCompareTypeBox;
    JLabel _variableMemoryValueLabel = new JLabel("");
    JTextField _variableData1Field;
    JTextField _variableData2Field;
    JComboBox<Conditional.ItemType> _actionItemBox;
    JComboBox<Conditional.Action> _actionTypeBox;
    JLabel _actionTypeLabel = new JLabel("Type");
    JTextField _actionNameField;
    JLabel _actionNameLabel = new JLabel("Name");
    JComboBox<String> _actionBox;
    JLabel _actionBoxLabel = new JLabel("Box");
    JTextField _longActionString;
    JLabel _longActionLabel = new JLabel("Long");
    JTextField _shortActionString;
    JLabel _shortActionLabel = new JLabel("Short");
    JComboBox<String> _actionOptionBox;
    JButton _actionSetButton;
    transient FocusListener detailFocusEvent = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            if (!ConditionalTreeEdit.this._editActive) {
                ConditionalTreeEdit.this.setEditMode(true);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    };
    transient ActionListener variableSignalHeadNameListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            log.debug("variableSignalHeadNameListener fires; _variableNameField : {}", (Object)ConditionalTreeEdit.this._variableNameField.getText().trim());
            ConditionalTreeEdit.this.loadJComboBoxWithHeadAppearances(ConditionalTreeEdit.this._variableSignalBox, ConditionalTreeEdit.this._variableNameField.getText().trim());
        }
    };
    transient ActionListener variableSignalMastNameListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            log.debug("variableSignalMastNameListener fires; _variableNameField : {}", (Object)ConditionalTreeEdit.this._variableNameField.getText().trim());
            ConditionalTreeEdit.this.loadJComboBoxWithMastAspects(ConditionalTreeEdit.this._variableSignalBox, ConditionalTreeEdit.this._variableNameField.getText().trim());
        }
    };
    transient ActionListener variableSignalTestStateListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            log.debug("variableSignalTestStateListener fires; _variableItemBox.getSelectedIndex()= \"{}\" _variableStateBox.getSelectedIndex()= \"{}\"", (Object)ConditionalTreeEdit.this._variableItemBox.getSelectedIndex(), (Object)ConditionalTreeEdit.this._variableStateBox.getSelectedIndex());
            Conditional.ItemType itemType = ConditionalTreeEdit.this._variableItemBox.getItemAt(ConditionalTreeEdit.this._variableItemBox.getSelectedIndex());
            if (ConditionalTreeEdit.this._variableStateBox.getSelectedIndex() == 1) {
                if (itemType == Conditional.ItemType.SIGNALHEAD) {
                    ConditionalTreeEdit.this.loadJComboBoxWithHeadAppearances(ConditionalTreeEdit.this._variableSignalBox, ConditionalTreeEdit.this._variableNameField.getText().trim());
                    ConditionalTreeEdit.this._detailGrid.setVisible(false);
                    ConditionalTreeEdit.this.makeDetailGrid("SignalAspectVariable");
                } else if (itemType == Conditional.ItemType.SIGNALMAST) {
                    ConditionalTreeEdit.this.loadJComboBoxWithMastAspects(ConditionalTreeEdit.this._variableSignalBox, ConditionalTreeEdit.this._variableNameField.getText().trim());
                    ConditionalTreeEdit.this._detailGrid.setVisible(false);
                    ConditionalTreeEdit.this.makeDetailGrid("SignalAspectVariable");
                } else {
                    ConditionalTreeEdit.this._detailGrid.setVisible(false);
                    ConditionalTreeEdit.this.makeDetailGrid("StandardVariable");
                }
            } else {
                ConditionalTreeEdit.this._detailGrid.setVisible(false);
                ConditionalTreeEdit.this.makeDetailGrid("StandardVariable");
            }
        }
    };
    transient ActionListener selectLogixBoxListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String lgxName;
            String lgxItem = (String)ConditionalTreeEdit.this._selectLogixBox.getSelectedItem();
            if (lgxItem != null && (lgxName = ConditionalTreeEdit.this._selectLogixMap.get(lgxItem)) != null) {
                ConditionalTreeEdit.this.loadSelectConditionalBox(lgxName);
            }
        }
    };
    transient ActionListener selectConditionalBoxListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int cdlIndex = ConditionalTreeEdit.this._selectConditionalBox.getSelectedIndex();
            if (cdlIndex > 0 && cdlIndex < ConditionalTreeEdit.this._selectConditionalList.size()) {
                String cdlName = ConditionalTreeEdit.this._selectConditionalList.get(cdlIndex);
                ConditionalTreeEdit.this._variableNameField.setText(cdlName);
            }
        }
    };
    transient ActionListener compareTypeBoxListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int selection = ConditionalTreeEdit.this._variableCompareTypeBox.getSelectedIndex();
            ConditionalTreeEdit.this.compareTypeChanged(Conditional.Type.getMemoryItems().get(selection));
        }
    };
    JFileChooser sndFileChooser = null;
    JFileChooser scriptFileChooser = null;
    JFileChooser defaultFileChooser = null;
    ActionTypeListener _actionTypeListener = new ActionTypeListener();
    transient ActionListener actionSignalHeadNameListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            log.debug("actionSignalHeadNameListener fires; _actionNameField : {}", (Object)ConditionalTreeEdit.this._actionNameField.getText().trim());
            ConditionalTreeEdit.this.loadJComboBoxWithHeadAppearances(ConditionalTreeEdit.this._actionBox, ConditionalTreeEdit.this._actionNameField.getText().trim());
        }
    };
    transient ActionListener actionSignalMastNameListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            log.debug("actionSignalMastNameListener fires; _actionNameField : {}", (Object)ConditionalTreeEdit.this._actionNameField.getText().trim());
            ConditionalTreeEdit.this.loadJComboBoxWithMastAspects(ConditionalTreeEdit.this._actionBox, ConditionalTreeEdit.this._actionNameField.getText().trim());
        }
    };
    private static final Logger log = LoggerFactory.getLogger(ConditionalTreeEdit.class);

    public ConditionalTreeEdit(String sName) {
        super(sName);
        this.buildConditionalComponents();
        this.buildActionComponents();
        this.buildVariableComponents();
        this.makeEditLogixWindow();
        this.setFocusListeners();
        this.setEditMode(false);
    }

    public ConditionalTreeEdit() {
    }

    void makeEditLogixWindow() {
        this._editLogixFrame = new JmriJFrame(Bundle.getMessage("TitleEditLogix"));
        this._editLogixFrame.addHelpMenu("package.jmri.jmrit.conditional.ConditionalTreeEditor", true);
        Container contentPane = this._editLogixFrame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel header = new JPanel();
        JPanel logixNames = new JPanel();
        logixNames.setLayout(new BoxLayout(logixNames, 0));
        JLabel systemNameLabel = new JLabel(String.valueOf(Bundle.getMessage("ColumnSystemName")) + ":");
        logixNames.add(systemNameLabel);
        logixNames.add(Box.createHorizontalStrut(5));
        JLabel fixedSystemName = new JLabel(this._curLogix.getSystemName());
        logixNames.add(fixedSystemName);
        logixNames.add(Box.createHorizontalStrut(20));
        JLabel userNameLabel = new JLabel(String.valueOf(Bundle.getMessage("ColumnUserName")) + ":");
        logixNames.add(userNameLabel);
        logixNames.add(Box.createHorizontalStrut(5));
        this._editLogixUserName.setText(this._curLogix.getUserName());
        logixNames.add(this._editLogixUserName);
        this._editLogixUserName.setToolTipText(Bundle.getMessage("LogixUserNameHint2"));
        this._editLogixUserName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String uName = ConditionalTreeEdit.this._editLogixUserName.getText().trim();
                if (!uName.equals(ConditionalTreeEdit.this._curLogix.getUserName())) {
                    Logix p;
                    if (uName.length() > 0 && (p = ConditionalTreeEdit.this._logixManager.getByUserName(uName)) != null) {
                        log.error("Failure to update Logix with Duplicate User Name: {}", (Object)uName);
                        JOptionPane.showMessageDialog(ConditionalTreeEdit.this._editLogixFrame, Bundle.getMessage("Error6"), Bundle.getMessage("ErrorTitle"), 0);
                        return;
                    }
                    ConditionalTreeEdit.this.logixData.clear();
                    ConditionalTreeEdit.this.logixData.put("chgUname", uName);
                    ConditionalTreeEdit.this.fireLogixEvent();
                    ConditionalTreeEdit.this._showReminder = true;
                }
            }
        });
        header.add(logixNames);
        contentPane.add((Component)header, "North");
        JTree treeContent = this.buildConditionalTree();
        JScrollPane treeScroll = new JScrollPane(treeContent);
        JPanel detailPane = new JPanel();
        detailPane.setBorder(BorderFactory.createMatteBorder(0, 2, 0, 0, Color.DARK_GRAY));
        detailPane.setLayout(new BoxLayout(detailPane, 1));
        this.makeDetailGrid("EmptyGrid");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this._cancelAction = new JButton(Bundle.getMessage("ButtonCancel"));
        this._cancelAction.setToolTipText(Bundle.getMessage("HintCancelButton"));
        panel.add(this._cancelAction);
        this._cancelAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalTreeEdit.this.cancelPressed();
            }
        });
        panel.add(Box.createHorizontalStrut(10));
        this._updateAction = new JButton(Bundle.getMessage("ButtonUpdate"));
        this._updateAction.setToolTipText(Bundle.getMessage("UpdateButtonHint"));
        panel.add(this._updateAction);
        this._updateAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalTreeEdit.this.updatePressed();
            }
        });
        this._detailFooter.add(panel);
        JPanel detailEdit = new JPanel(new BorderLayout());
        detailEdit.add((Component)this._detailGrid, "North");
        detailEdit.add((Component)this._detailFooter, "South");
        detailPane.add(detailEdit);
        this._editLogixUserName.setEnabled(true);
        JSplitPane bodyPane = new JSplitPane(1, treeScroll, detailPane);
        bodyPane.setDividerSize(10);
        bodyPane.setResizeWeight(0.35);
        bodyPane.setOneTouchExpandable(true);
        contentPane.add(bodyPane);
        JPanel footer = new JPanel(new BorderLayout());
        this._labelPanel = new JPanel();
        this._labelPanel.add(this._conditionalLabel);
        this._leftButtonBar = new JPanel();
        this._leftButtonBar.add(this._labelPanel);
        JButton addButton = new JButton(Bundle.getMessage("ButtonAddText"));
        addButton.setToolTipText(Bundle.getMessage("HintAddButton"));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalTreeEdit.this.addPressed();
            }
        });
        this._addButtonPanel = new JPanel();
        this._addButtonPanel.add(addButton);
        this._leftButtonBar.add(this._addButtonPanel);
        JButton helpButton = new JButton(Bundle.getMessage("ButtonHelp"));
        helpButton.setToolTipText(Bundle.getMessage("HintHelpButton"));
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalTreeEdit.this.helpPressed();
            }
        });
        this._helpButtonPanel = new JPanel();
        this._helpButtonPanel.add(helpButton);
        this._helpButtonPanel.setVisible(false);
        this._leftButtonBar.add(this._helpButtonPanel);
        JButton toggleButton = new JButton(Bundle.getMessage("ButtonToggle"));
        toggleButton.setToolTipText(Bundle.getMessage("HintToggleButton"));
        toggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalTreeEdit.this.togglePressed();
            }
        });
        this._toggleButtonPanel = new JPanel();
        this._toggleButtonPanel.add(toggleButton);
        this._toggleButtonPanel.setVisible(false);
        this._leftButtonBar.add(this._toggleButtonPanel);
        JButton checkButton = new JButton(Bundle.getMessage("ButtonCheck"));
        checkButton.setToolTipText(Bundle.getMessage("HintCheckButton"));
        checkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalTreeEdit.this.checkPressed();
            }
        });
        this._checkButtonPanel = new JPanel();
        this._checkButtonPanel.add(checkButton);
        this._checkButtonPanel.setVisible(true);
        this._leftButtonBar.add(this._checkButtonPanel);
        JButton deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
        deleteButton.setToolTipText(Bundle.getMessage("HintDeleteButton"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalTreeEdit.this.deletePressed();
            }
        });
        this._deleteButtonPanel = new JPanel();
        this._deleteButtonPanel.add(deleteButton);
        this._deleteButtonPanel.setVisible(false);
        this._leftButtonBar.add(this._deleteButtonPanel);
        footer.add((Component)this._leftButtonBar, "West");
        JPanel rightButtonBar = new JPanel();
        JLabel moveLabel = new JLabel(Bundle.getMessage("LabelMove"));
        final JButton upButton = new JButton(Bundle.getMessage("ButtonUp"));
        upButton.setToolTipText(Bundle.getMessage("HintUpButton"));
        final JButton downButton = new JButton(Bundle.getMessage("ButtonDown"));
        downButton.setToolTipText(Bundle.getMessage("HintDownButton"));
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                downButton.setEnabled(false);
                upButton.setEnabled(false);
                ConditionalTreeEdit.this.upPressed();
            }
        });
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                upButton.setEnabled(false);
                downButton.setEnabled(false);
                ConditionalTreeEdit.this.downPressed();
            }
        });
        this._moveButtonPanel = new JPanel();
        this._moveButtonPanel.add(moveLabel);
        this._moveButtonPanel.add(upButton);
        this._moveButtonPanel.add(new JLabel("|"));
        this._moveButtonPanel.add(downButton);
        this._moveButtonPanel.setVisible(false);
        this._leftButtonBar.add(this._moveButtonPanel);
        JButton doneButton = new JButton(Bundle.getMessage("ButtonDone"));
        doneButton.setToolTipText(Bundle.getMessage("HintDoneButton"));
        doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalTreeEdit.this.donePressed();
            }
        });
        JPanel doneButtonPanel = new JPanel();
        doneButtonPanel.add(doneButton);
        rightButtonBar.add(doneButtonPanel);
        footer.add((Component)rightButtonBar, "East");
        contentPane.add((Component)footer, "South");
        this._editLogixFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConditionalTreeEdit.this.donePressed();
            }
        });
        this._editLogixFrame.setDefaultCloseOperation(0);
        this._editLogixFrame.pack();
        this._editLogixFrame.setVisible(true);
    }

    void buildConditionalComponents() {
        this._editConditionalUserName = new JTextField(20);
        this._editAntecedent = new JTextField(20);
        this._editOperatorMode = new JComboBox();
        Conditional.AntecedentOperator[] antecedentOperatorArray = Conditional.AntecedentOperator.values();
        int n = antecedentOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Conditional.AntecedentOperator operator = antecedentOperatorArray[n2];
            this._editOperatorMode.addItem(operator);
            ++n2;
        }
    }

    void makeDetailGrid(String gridType) {
        this._detailGrid.setVisible(false);
        this._detailGrid.removeAll();
        this._detailFooter.setVisible(true);
        this._gridPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        switch (gridType) {
            case "EmptyGrid": {
                this.makeEmptyGrid(c);
                this._detailFooter.setVisible(false);
                break;
            }
            case "Conditional": {
                this.makeConditionalGrid(c);
                break;
            }
            case "Antecedent": {
                this.makeAntecedentGrid(c);
                break;
            }
            case "LogicType": {
                this.makeLogicTypeGrid(c);
                break;
            }
            case "EmptyVariable": {
                this.makeEmptyVariableGrid(c);
                break;
            }
            case "StandardVariable": {
                this.makeStandardVariableGrid(c);
                break;
            }
            case "SignalAspectVariable": {
                this.makeSignalAspectVariableGrid(c);
                break;
            }
            case "ConditionalVariable": {
                this.makeConditionalVariableGrid(c);
                break;
            }
            case "MemoryVariable": {
                this.makeMemoryVariableGrid(c);
                break;
            }
            case "FastClockVariable": {
                this.makeFastClockVariableGrid(c);
                break;
            }
            case "EmptyAction": {
                this.makeEmptyActionGrid(c);
                break;
            }
            case "NameTypeAction": {
                this.makeNameTypeActionGrid(c, false);
                break;
            }
            case "NameTypeActionFinal": {
                this.makeNameTypeActionGrid(c, true);
                break;
            }
            case "TypeAction": {
                this.makeTypeActionGrid(c, false);
                break;
            }
            case "TypeActionFinal": {
                this.makeTypeActionGrid(c, true);
                break;
            }
            case "TypeShortAction": {
                this.makeTypeShortActionGrid(c);
                break;
            }
            case "StandardAction": {
                this.makeStandardActionGrid(c, true);
                break;
            }
            case "ShortFieldAction": {
                this.makeShortFieldActionGrid(c, true);
                break;
            }
            case "ShortFieldNoBoxAction": {
                this.makeShortFieldActionGrid(c, false);
                break;
            }
            case "FileAction": {
                this.makeFileActionGrid(c);
                break;
            }
            default: {
                log.warn("Invalid grid type: '{}'", (Object)gridType);
                this.makeEmptyGrid(c);
            }
        }
        this._detailGrid.add(this._gridPanel);
        this._detailGrid.setVisible(true);
    }

    void makeEmptyGrid(GridBagConstraints c) {
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 10;
        JLabel row0Label = new JLabel("This page is intentionally blank");
        this._gridPanel.add((Component)row0Label, c);
    }

    void makeConditionalGrid(GridBagConstraints c) {
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row0Label = new JLabel(Bundle.getMessage("ConditionalUserName"));
        row0Label.setToolTipText(Bundle.getMessage("ConditionalUserNameHint"));
        this._gridPanel.add((Component)row0Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add((Component)this._editConditionalUserName, c);
    }

    void makeAntecedentGrid(GridBagConstraints c) {
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row0Label = new JLabel(Bundle.getMessage("LabelAntecedentHeader"));
        row0Label.setToolTipText(Bundle.getMessage("LabelAntecedentHint"));
        this._gridPanel.add((Component)row0Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add((Component)this._editAntecedent, c);
    }

    void makeLogicTypeGrid(GridBagConstraints c) {
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row0Label = new JLabel(Bundle.getMessage("LabelLogicType"));
        row0Label.setToolTipText(Bundle.getMessage("TypeLogicHint"));
        this._gridPanel.add((Component)row0Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add(this._editOperatorMode, c);
    }

    void addPressed() {
        if (this._curNode == null) {
            this._curNodeType = "Conditional";
        }
        switch (this._curNodeType) {
            case "Conditional": {
                int num = this._curLogix.getNumConditionals() + 1;
                this._curConditional = null;
                String cName = null;
                while (this._curConditional == null) {
                    cName = String.valueOf(this._curLogix.getSystemName()) + "C" + Integer.toString(num);
                    this._curConditional = this._conditionalManager.createNewConditional(cName, "");
                    if (++num == 1000) break;
                }
                if (this._curConditional == null) {
                    log.error("Failure to create Conditional with System Name: {}", cName);
                    return;
                }
                this._curLogix.addConditional(cName, -1);
                this._actionList = new ArrayList<ConditionalAction>();
                this._variableList = new ArrayList<ConditionalVariable>();
                this._curConditional.setAction(this._actionList);
                this._curConditional.setStateVariables(this._variableList);
                this._showReminder = true;
                Conditional curConditional = this._curLogix.getConditional(cName);
                this._curNode = new ConditionalTreeNode(this.buildNodeText("Conditional", curConditional, 0), "Conditional", cName, this._curLogix.getNumConditionals() - 1);
                this._cdlRoot.add(this._curNode);
                this._leafNode = new ConditionalTreeNode(this.buildNodeText("Antecedent", curConditional, 0), "Antecedent", cName, 0);
                this._curNode.add(this._leafNode);
                this._varHead = new ConditionalTreeNode(this.buildNodeText("Variables", curConditional, 0), "Variables", cName, 0);
                this._curNode.add(this._varHead);
                this._leafNode = new ConditionalTreeNode(this.buildNodeText("LogicType", curConditional, 0), "LogicType", cName, 0);
                this._curNode.add(this._leafNode);
                this._triggerMode = curConditional.getTriggerOnChange();
                this._leafNode = new ConditionalTreeNode(this.buildNodeText("TriggerMode", curConditional, 0), "TriggerMode", cName, 0);
                this._curNode.add(this._leafNode);
                this._actHead = new ConditionalTreeNode(this.buildNodeText("Actions", curConditional, 0), "Actions", cName, 0);
                this._curNode.add(this._actHead);
                this._cdlModel.nodeStructureChanged(this._cdlRoot);
                this._cdlTree.setSelectionPath(new TreePath(this._curNode.getPath()));
                break;
            }
            case "Variables": {
                this.newVariable();
                break;
            }
            case "Variable": {
                this.newVariable();
                break;
            }
            case "Actions": {
                this.newAction();
                break;
            }
            case "Action": {
                this.newAction();
                break;
            }
            default: {
                log.error("Add called for unsupported node type: '{}'", (Object)this._curNodeType);
            }
        }
    }

    void newVariable() {
        if (LRouteTableAction.getLogixInitializer().equals(this._curLogix.getSystemName())) {
            JOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Error49"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.cancelPressed();
        this._showReminder = true;
        this._curVariableItem = Conditional.ItemType.NONE;
        ConditionalVariable variable = new ConditionalVariable();
        this._variableList.add(variable);
        this._newVariableItem = true;
        this.setMoveButtons();
        int size = this._variableList.size();
        this._curVariable = this._variableList.get(size - 1);
        if (size > 1) {
            if (this._logicType == Conditional.AntecedentOperator.ALL_OR) {
                this._curVariable.setOpern(Conditional.Operator.OR);
            } else {
                this._curVariable.setOpern(Conditional.Operator.AND);
            }
        }
        this.appendToAntecedent();
        this._varHead = this._curNodeType.equals("Variables") ? this._curNode : (ConditionalTreeNode)this._curNode.getParent();
        this._leafNode = new ConditionalTreeNode(this.buildNodeText("Variable", this._curVariable, --size), "Variable", this._curNodeName, size);
        this._varHead.add(this._leafNode);
        this._cdlModel.nodeStructureChanged(this._curNode);
        this._varHead.setRow(size + 1);
        this._cdlModel.nodeStructureChanged(this._varHead);
        ConditionalTreeNode tempNode = (ConditionalTreeNode)this._varHead.getLastChild();
        TreePath newPath = new TreePath(tempNode.getPath());
        this._cdlTree.setSelectionPath(newPath);
        this._cdlTree.expandPath(newPath);
    }

    void newAction() {
        this.cancelPressed();
        this._showReminder = true;
        this._curActionItem = Conditional.ItemType.NONE;
        DefaultConditionalAction action = new DefaultConditionalAction();
        this._actionList.add(action);
        this._newActionItem = true;
        this.setMoveButtons();
        int size = this._actionList.size();
        this._curAction = this._actionList.get(size - 1);
        this._actHead = this._curNodeType.equals("Actions") ? this._curNode : (ConditionalTreeNode)this._curNode.getParent();
        this._leafNode = new ConditionalTreeNode(this.buildNodeText("Action", this._curAction, --size), "Action", this._curNodeName, size);
        this._actHead.add(this._leafNode);
        this._cdlModel.nodeStructureChanged(this._curNode);
        this._actHead.setRow(size + 1);
        this._cdlModel.nodeStructureChanged(this._actHead);
        ConditionalTreeNode tempNode = (ConditionalTreeNode)this._actHead.getLastChild();
        TreePath newPath = new TreePath(tempNode.getPath());
        this._cdlTree.setSelectionPath(newPath);
        this._cdlTree.expandPath(newPath);
    }

    void editPressed() {
        switch (this._curNodeType) {
            case "Conditional": {
                this._editConditionalUserName.setText(this._curConditional.getUserName());
                this.makeDetailGrid("Conditional");
                break;
            }
            case "Antecedent": {
                Conditional.AntecedentOperator chkLogicType = this._curConditional.getLogicType();
                if (chkLogicType != Conditional.AntecedentOperator.MIXED) {
                    this.makeDetailGrid("EmptyGrid");
                    return;
                }
                this._labelPanel.add(this._antecedentLabel);
                this._helpButtonPanel.setVisible(true);
                this._editAntecedent.setText(ConditionalTreeEdit.translateAntecedent(this._curConditional.getAntecedentExpression(), false));
                this.makeDetailGrid("Antecedent");
                break;
            }
            case "LogicType": {
                Conditional.AntecedentOperator curLogicType = this._curConditional.getLogicType();
                this._editOperatorMode.setSelectedItem((Object)curLogicType);
                this.makeDetailGrid("LogicType");
                break;
            }
            case "Variable": {
                this._labelPanel.add(this._variableLabel);
                this._curVariable = this._variableList.get(this._curNodeRow);
                this._curVariableItem = this._curVariable.getType().getItemType();
                this.initializeStateVariables();
                if (this._logicType != Conditional.AntecedentOperator.MIXED) {
                    this.setMoveButtons();
                }
                this._oldTargetNames.clear();
                this.loadReferenceNames(this._variableList, this._oldTargetNames);
                break;
            }
            case "Action": {
                this._labelPanel.add(this._actionLabel);
                this._curAction = this._actionList.get(this._curNodeRow);
                this._actionOptionBox.removeAllItems();
                int i = 1;
                while (i <= 3) {
                    this._actionOptionBox.addItem(DefaultConditionalAction.getOptionString(i, this._triggerMode));
                    ++i;
                }
                this._curActionItem = this._curAction.getType().getItemType();
                this.initializeActionVariables();
                this.setMoveButtons();
                break;
            }
            default: {
                log.error("Edit called for unsupported node type: '{}'", (Object)this._curNodeType);
            }
        }
    }

    void updatePressed() {
        switch (this._curNodeType) {
            case "Conditional": {
                this.userNameChanged(this._editConditionalUserName.getText().trim());
                break;
            }
            case "Antecedent": {
                this.antecedentChanged(this._editAntecedent.getText().trim());
                break;
            }
            case "LogicType": {
                this.logicTypeChanged(this._editOperatorMode.getItemAt(this._editOperatorMode.getSelectedIndex()));
                break;
            }
            case "Variable": {
                this.updateVariable();
                break;
            }
            case "Action": {
                this.updateAction();
                break;
            }
            default: {
                log.warn("Invalid update button press");
            }
        }
        this.setEditMode(false);
        this._cdlTree.setSelectionPath(this._curTreePath);
        this._cdlTree.grabFocus();
    }

    void userNameChanged(String newName) {
        if (!newName.equals(this._curConditional.getUserName())) {
            if (!this.checkConditionalUserName(newName, this._curLogix)) {
                return;
            }
            this._curConditional.setUserName(newName);
            this._curNode.setText(this.buildNodeText("Conditional", this._curConditional, 0));
            this._cdlModel.nodeChanged(this._curNode);
            ArrayList<String> refList = this._conditionalManager.getWhereUsed(this._curNodeName);
            if (refList != null) {
                for (String ref : refList) {
                    Conditional cRef = this._conditionalManager.getBySystemName(ref);
                    if (cRef == null) {
                        log.error("Conditional :{}: not found while updating username", (Object)ref);
                        continue;
                    }
                    List<ConditionalVariable> varList = cRef.getCopyOfStateVariables();
                    int idx = 0;
                    for (ConditionalVariable var : varList) {
                        if (var.getName().equals(this._curNodeName)) {
                            if (newName.length() > 0) {
                                var.setGuiName(newName);
                            } else {
                                var.setGuiName(this._curNodeName);
                            }
                            String varLogixName = this._conditionalManager.getParentLogix(ref).getSystemName();
                            String curLogixSName = this._curLogix.getSystemName();
                            if (varLogixName.equals(curLogixSName)) {
                                int cdlCount = this._cdlRoot.getChildCount();
                                int j = 0;
                                while (j < cdlCount) {
                                    ConditionalTreeNode cdlNode = (ConditionalTreeNode)this._cdlRoot.getChildAt(j);
                                    if (cdlNode.getName().equals(ref)) {
                                        ConditionalTreeNode variables = (ConditionalTreeNode)cdlNode.getChildAt(1);
                                        ConditionalTreeNode variable = (ConditionalTreeNode)variables.getChildAt(idx);
                                        variable.setText(this.buildNodeText("Variable", var, idx));
                                        this._cdlModel.nodeChanged(variable);
                                    }
                                    ++j;
                                }
                            }
                        }
                        ++idx;
                    }
                    cRef.setStateVariables(varList);
                    this._variableList = this._curConditional.getCopyOfStateVariables();
                }
            }
        }
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="Except for the root node, all nodes are ConditionalTreeNode")
    void logicTypeChanged(Conditional.AntecedentOperator newType) {
        if (this._logicType == newType) {
            return;
        }
        this.makeAntecedent();
        if (newType != Conditional.AntecedentOperator.MIXED) {
            Conditional.Operator oper = Conditional.Operator.OR;
            if (newType == Conditional.AntecedentOperator.ALL_AND) {
                oper = Conditional.Operator.AND;
            }
            ConditionalTreeNode varHead = (ConditionalTreeNode)this._curNode.getPreviousSibling();
            int i = 1;
            while (i < this._variableList.size()) {
                ConditionalVariable curVar = this._variableList.get(i);
                curVar.setOpern(oper);
                ConditionalTreeNode varNode = (ConditionalTreeNode)varHead.getChildAt(i);
                varNode.setText(this.buildNodeText("Variable", curVar, i));
                this._cdlModel.nodeChanged(varNode);
                ++i;
            }
        }
        this._curConditional.setLogicType(newType, this._antecedent);
        this._logicType = newType;
        this._curNode.setText(this.buildNodeText("LogicType", this._curConditional, 0));
        this._cdlModel.nodeChanged(this._curNode);
        this._curConditional.setStateVariables(this._variableList);
        ConditionalTreeNode parentNode = (ConditionalTreeNode)this._curNode.getParent();
        ConditionalTreeNode antNode = (ConditionalTreeNode)parentNode.getFirstChild();
        if (antNode.getType().equals("Antecedent")) {
            antNode.setText(this.buildNodeText("Antecedent", this._curConditional, 0));
            this._cdlModel.nodeChanged(antNode);
        } else {
            log.warn("Unable to find the antecedent node");
        }
    }

    void antecedentChanged(String antecedentText) {
        if (this.validateAntecedent(antecedentText)) {
            this._antecedent = ConditionalTreeEdit.translateAntecedent(antecedentText, true);
            this._curConditional.setLogicType(this._logicType, this._antecedent);
            this._curNode.setText(this.buildNodeText("Antecedent", this._curConditional, 0));
            this._cdlModel.nodeChanged(this._curNode);
        }
    }

    void makeAntecedent() {
        this._antecedent = this.makeAntecedent(this._variableList);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="Except for the root node, all nodes are ConditionalTreeNode")
    void appendToAntecedent() {
        this._antecedent = this.appendToAntecedent(this._logicType, this._variableList.size(), this._antecedent);
        this._curConditional.setLogicType(this._logicType, this._antecedent);
        ConditionalTreeNode antNode = this._curNodeType.equals("Variables") ? (ConditionalTreeNode)this._curNode.getPreviousSibling() : (ConditionalTreeNode)((ConditionalTreeNode)this._curNode.getParent()).getPreviousSibling();
        if (antNode.getType().equals("Antecedent")) {
            antNode.setText(this.buildNodeText("Antecedent", this._curConditional, 0));
            this._cdlModel.nodeChanged(antNode);
        } else {
            log.warn("Unable to find the antecedent node");
        }
    }

    boolean validateAntecedent(String antecedentText) {
        return this.validateAntecedent(this._logicType, antecedentText, this._variableList, this._curConditional);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="Except for the root node, all nodes are ConditionalTreeNode")
    void togglePressed() {
        this._curLogix.deActivateLogix();
        this._curConditional.setTriggerOnChange(!this._curConditional.getTriggerOnChange());
        this._triggerMode = this._curConditional.getTriggerOnChange();
        this._curLogix.activateLogix();
        this._curNode.setText(this.buildNodeText("TriggerMode", this._curConditional, 0));
        this._cdlModel.nodeChanged(this._curNode);
        this._actionList = this._curConditional.getCopyOfActions();
        ConditionalTreeNode actionsNode = (ConditionalTreeNode)this._curNode.getNextSibling();
        int i = 0;
        while (i < this._actionList.size()) {
            ConditionalAction action = this._actionList.get(i);
            ConditionalTreeNode actNode = (ConditionalTreeNode)actionsNode.getChildAt(i);
            actNode.setText(action.description(this._triggerMode));
            this._cdlModel.nodeChanged(actNode);
            ++i;
        }
    }

    void checkPressed() {
        if (this._curNodeType == null || this._curNodeType.equals("Conditional")) {
            int i = 0;
            while (i < this._cdlRoot.getChildCount()) {
                ConditionalTreeNode cdlNode = (ConditionalTreeNode)this._cdlRoot.getChildAt(i);
                Conditional cdl = this._conditionalManager.getBySystemName(cdlNode.getName());
                cdlNode.setText(this.buildNodeText("Conditional", cdl, i));
                this._cdlModel.nodeChanged(cdlNode);
                ++i;
            }
            return;
        }
        if (this._curNodeType.equals("Variables")) {
            int i = 0;
            while (i < this._variableList.size()) {
                ConditionalVariable variable = this._variableList.get(i);
                ConditionalTreeNode varNode = (ConditionalTreeNode)this._curNode.getChildAt(i);
                varNode.setText(this.buildNodeText("Variable", variable, i));
                this._cdlModel.nodeChanged(varNode);
                ++i;
            }
        }
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="Except for the root node, all nodes are ConditionalTreeNode")
    void deletePressed() {
        TreeSet<String> oldTargetNames = new TreeSet<String>();
        TreeSet<String> newTargetNames = new TreeSet<String>();
        this.setEditMode(false);
        switch (this._curNodeType) {
            case "Conditional": {
                this.loadReferenceNames(this._variableList, oldTargetNames);
                this._curLogix.deActivateLogix();
                Object[] msgs = this._curLogix.deleteConditional(this._curNodeName);
                this._curLogix.activateLogix();
                if (msgs != null) {
                    JOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Error11", msgs), Bundle.getMessage("ErrorTitle"), 0);
                    return;
                }
                this.updateWhereUsed(oldTargetNames, newTargetNames, this._curNodeName);
                this._showReminder = true;
                this._cdlRoot.remove(this._curNodeRow);
                this._cdlModel.nodeStructureChanged(this._cdlRoot);
                int childCount = this._cdlRoot.getChildCount();
                int i = 0;
                while (i < childCount) {
                    this._curNode = (ConditionalTreeNode)this._cdlRoot.getChildAt(i);
                    this._curNode.setRow(i);
                    this._cdlModel.nodeChanged(this._curNode);
                    ++i;
                }
                if (this._curLogix.getNumConditionals() < 1 && !this._suppressReminder) {
                    JOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Warn1"), Bundle.getMessage("WarningTitle"), 2);
                }
                this.setMoveButtons();
                break;
            }
            case "Variable": {
                this.loadReferenceNames(this._variableList, oldTargetNames);
                if (this._variableList.size() < 2 && !this._suppressReminder) {
                    JOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Warn3"), Bundle.getMessage("WarningTitle"), 2);
                }
                if (this._curNodeRow == 0 && this._variableList.size() > 1) {
                    this._variableList.get(1).setOpern(Conditional.Operator.NONE);
                }
                this._variableList.remove(this._curNodeRow);
                this.updateVariableList();
                this.loadReferenceNames(this._variableList, newTargetNames);
                this.updateWhereUsed(oldTargetNames, newTargetNames, this._curNodeName);
                this._showReminder = true;
                TreePath parentPath = this._curTreePath.getParentPath();
                ConditionalTreeNode parentNode = (ConditionalTreeNode)this._curNode.getParent();
                parentNode.setRow(this._variableList.size());
                this._cdlModel.nodeChanged(parentNode);
                this._curNode = (ConditionalTreeNode)parentNode.getPreviousSibling();
                this.antecedentChanged("");
                parentNode.removeAllChildren();
                int v = 0;
                while (v < this._variableList.size()) {
                    ConditionalVariable variable = this._variableList.get(v);
                    this._leafNode = new ConditionalTreeNode(this.buildNodeText("Variable", variable, v), "Variable", this._curNodeName, v);
                    parentNode.add(this._leafNode);
                    ++v;
                }
                this._curNode = null;
                this._newVariableItem = false;
                this.cleanUpVariable();
                this._cdlModel.nodeStructureChanged(parentNode);
                this._cdlTree.setSelectionPath(parentPath);
                break;
            }
            case "Action": {
                this.removeActionTimers();
                this._actionList.remove(this._curNodeRow);
                this.updateActionList();
                this._showReminder = true;
                TreePath parentPath = this._curTreePath.getParentPath();
                ConditionalTreeNode parentNode = (ConditionalTreeNode)this._curNode.getParent();
                parentNode.setRow(this._actionList.size());
                this._cdlModel.nodeChanged(parentNode);
                parentNode.removeAllChildren();
                int a = 0;
                while (a < this._actionList.size()) {
                    ConditionalAction action = this._actionList.get(a);
                    this._leafNode = new ConditionalTreeNode(this.buildNodeText("Action", action, a), "Action", this._curNodeName, a);
                    parentNode.add(this._leafNode);
                    ++a;
                }
                this._curNode = null;
                this._newActionItem = false;
                this.cleanUpAction();
                this._cdlModel.nodeStructureChanged(parentNode);
                this._cdlTree.setSelectionPath(parentPath);
                break;
            }
            default: {
                log.error("Delete called for unsupported node type: '{}'", (Object)this._curNodeType);
            }
        }
    }

    void upPressed() {
        this._showReminder = true;
        switch (this._curNodeType) {
            case "Conditional": {
                this._curLogix.deActivateLogix();
                this._curLogix.swapConditional(this._curNodeRow - 1, this._curNodeRow);
                this._curLogix.activateLogix();
                this.moveTreeNode("Up");
                break;
            }
            case "Variable": {
                ConditionalVariable tempVar = this._variableList.get(this._curNodeRow);
                int newVarRow = this._curNodeRow - 1;
                this._variableList.set(this._curNodeRow, this._variableList.get(newVarRow));
                this._variableList.set(newVarRow, tempVar);
                if (newVarRow == 0) {
                    this._variableList.get(newVarRow).setOpern(Conditional.Operator.NONE);
                    Conditional.Operator newOper = this._logicType == Conditional.AntecedentOperator.ALL_AND ? Conditional.Operator.AND : Conditional.Operator.OR;
                    this._variableList.get(this._curNodeRow).setOpern(newOper);
                }
                this.updateVariableList();
                this.moveTreeNode("Up");
                break;
            }
            case "Action": {
                ConditionalAction tempAct = this._actionList.get(this._curNodeRow);
                int newActRow = this._curNodeRow - 1;
                this._actionList.set(this._curNodeRow, this._actionList.get(newActRow));
                this._actionList.set(newActRow, tempAct);
                this.removeActionTimers();
                this.updateActionList();
                this.moveTreeNode("Up");
                break;
            }
            default: {
                log.warn("Move Up called for unsupported node type: '{}'", (Object)this._curNodeType);
            }
        }
    }

    void downPressed() {
        this._showReminder = true;
        switch (this._curNodeType) {
            case "Conditional": {
                this._curLogix.deActivateLogix();
                this._curLogix.swapConditional(this._curNodeRow, this._curNodeRow + 1);
                this._curLogix.activateLogix();
                this.moveTreeNode("Down");
                break;
            }
            case "Variable": {
                ConditionalVariable tempVar = this._variableList.get(this._curNodeRow);
                int newVarRow = this._curNodeRow + 1;
                this._variableList.set(this._curNodeRow, this._variableList.get(newVarRow));
                this._variableList.set(newVarRow, tempVar);
                if (this._curNodeRow == 0) {
                    this._variableList.get(this._curNodeRow).setOpern(Conditional.Operator.NONE);
                    Conditional.Operator newOper = this._logicType == Conditional.AntecedentOperator.ALL_AND ? Conditional.Operator.AND : Conditional.Operator.OR;
                    this._variableList.get(newVarRow).setOpern(newOper);
                }
                this.updateVariableList();
                this.moveTreeNode("Down");
                break;
            }
            case "Action": {
                ConditionalAction tempAct = this._actionList.get(this._curNodeRow);
                int newActRow = this._curNodeRow + 1;
                this._actionList.set(this._curNodeRow, this._actionList.get(newActRow));
                this._actionList.set(newActRow, tempAct);
                this.removeActionTimers();
                this.updateActionList();
                this.moveTreeNode("Down");
                break;
            }
            default: {
                log.warn("Move Down called for unsupported node type: '{}'", (Object)this._curNodeType);
            }
        }
    }

    void removeActionTimers() {
        DefaultConditional cdl = (DefaultConditional)this._curConditional;
        for (ConditionalAction act : cdl.getActionList()) {
            if (act.getTimer() == null) continue;
            act.stopTimer();
            act.setTimer(null);
            act.setListener(null);
        }
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="Except for the root node, all nodes are ConditionalTreeNode")
    void moveTreeNode(String direction) {
        ConditionalTreeNode siblingNode;
        int oldRow = this._curNodeRow--;
        if (!direction.equals("Up")) {
            ++this._curNodeRow;
        }
        this._curNode.setRow(this._curNodeRow);
        if (this._curNodeType.equals("Variable")) {
            this._curNode.setText(this.buildNodeText("Variable", this._variableList.get(this._curNodeRow), this._curNodeRow));
        }
        this._cdlModel.nodeChanged(this._curNode);
        if (direction.equals("Up")) {
            siblingNode = (ConditionalTreeNode)this._curNode.getPreviousSibling();
            siblingNode.setRow(siblingNode.getRow() + 1);
        } else {
            siblingNode = (ConditionalTreeNode)this._curNode.getNextSibling();
            siblingNode.setRow(siblingNode.getRow() - 1);
        }
        if (this._curNodeType.equals("Variable")) {
            siblingNode.setText(this.buildNodeText("Variable", this._variableList.get(oldRow), oldRow));
        }
        this._cdlModel.nodeChanged(siblingNode);
        if (this._curNodeType.equals("Conditional")) {
            this._cdlRoot.insert(this._curNode, this._curNodeRow);
            this._cdlModel.nodeStructureChanged(this._cdlRoot);
        } else {
            ConditionalTreeNode parentNode = (ConditionalTreeNode)this._curNode.getParent();
            parentNode.insert(this._curNode, this._curNodeRow);
            this._cdlModel.nodeStructureChanged(parentNode);
        }
        this._cdlTree.setSelectionPath(new TreePath(this._curNode.getPath()));
        this.setMoveButtons();
    }

    void setMoveButtons() {
        int rows;
        if (this._curNode == null) {
            return;
        }
        Component[] compList = this._moveButtonPanel.getComponents();
        JButton up = (JButton)compList[1];
        JButton down = (JButton)compList[3];
        up.setEnabled(true);
        down.setEnabled(true);
        if (this._curNodeType.equals("Conditional")) {
            rows = this._curLogix.getNumConditionals();
        } else {
            ConditionalTreeNode parent = (ConditionalTreeNode)this._curNode.getParent();
            rows = parent.getRow();
        }
        if (this._curNodeRow < 1) {
            up.setEnabled(false);
        }
        if (this._curNodeRow >= rows - 1) {
            down.setEnabled(false);
        }
        if (this._newVariableItem && this._curNodeType.equals("Variable") || this._newActionItem && this._curNodeType.equals("Action") || this._editActive || this._cdlTree.getSelectionCount() == 0) {
            up.setEnabled(false);
            down.setEnabled(false);
        }
        this._moveButtonPanel.setVisible(true);
    }

    void helpPressed() {
        JOptionPane.showMessageDialog(null, new String[]{Bundle.getMessage("ConditionalHelpText1"), Bundle.getMessage("ConditionalHelpText2"), Bundle.getMessage("ConditionalHelpText3"), Bundle.getMessage("ConditionalHelpText4"), Bundle.getMessage("ConditionalHelpText5"), Bundle.getMessage("ConditionalHelpText6"), Bundle.getMessage("ConditionalHelpText7")}, Bundle.getMessage("MenuHelp"), 1);
    }

    void cancelPressed() {
        switch (this._curNodeType) {
            case "Variable": {
                this.cancelEditVariable();
                break;
            }
            case "Action": {
                this.cancelEditAction();
                break;
            }
        }
        this.makeDetailGrid("EmptyGrid");
        this.setEditMode(false);
        this._cdlTree.setSelectionPath(this._curTreePath);
        this._cdlTree.grabFocus();
    }

    void donePressed() {
        block11: {
            if (this._curNodeType == null) break block11;
            switch (this._curNodeType) {
                case "Variable": {
                    this.cancelEditVariable();
                    break;
                }
                case "Action": {
                    this.cancelEditAction();
                    break;
                }
            }
        }
        this.closeSinglePanelPickList();
        if (this._pickTables != null) {
            this._pickTables.dispose();
            this._pickTables = null;
        }
        this._editLogixFrame.setVisible(false);
        this._editLogixFrame.dispose();
        this._editLogixFrame = null;
        this.logixData.clear();
        this.logixData.put("Finish", this._curLogix.getSystemName());
        this.fireLogixEvent();
    }

    JTree buildConditionalTree() {
        this._cdlRoot = new DefaultMutableTreeNode("Root Node");
        this._cdlModel = new DefaultTreeModel(this._cdlRoot);
        this._cdlTree = new JTree(this._cdlModel);
        this.createConditionalContent();
        this._cdlTree.expandPath(new TreePath(this._cdlRoot));
        this._cdlTree.setRootVisible(false);
        this._cdlTree.setShowsRootHandles(true);
        this._cdlTree.setScrollsOnExpand(true);
        this._cdlTree.setExpandsSelectedPaths(true);
        this._cdlTree.getSelectionModel().setSelectionMode(1);
        this._cdlListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object chkLast;
                if (ConditionalTreeEdit.this._editActive) {
                    if (e.getNewLeadSelectionPath() != ConditionalTreeEdit.this._curTreePath) {
                        ConditionalTreeEdit.this._cdlTree.setSelectionPath(e.getOldLeadSelectionPath());
                        ConditionalTreeEdit.this.showNodeEditMessage();
                    }
                    return;
                }
                ConditionalTreeEdit.this._curTreePath = ConditionalTreeEdit.this._cdlTree.getSelectionPath();
                if (ConditionalTreeEdit.this._curTreePath != null && (chkLast = ConditionalTreeEdit.this._curTreePath.getLastPathComponent()) instanceof ConditionalTreeNode) {
                    ConditionalTreeEdit.this.treeRowSelected((ConditionalTreeNode)chkLast);
                }
            }
        };
        this._cdlTree.addTreeSelectionListener(this._cdlListener);
        this._cdlTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                ConditionalTreeNode checkNode = (ConditionalTreeNode)e.getPath().getLastPathComponent();
                if (checkNode.getType().equals("Variables")) {
                    checkNode.setText(ConditionalTreeEdit.this.buildNodeText("Variables", ConditionalTreeEdit.this._curConditional, 1));
                    ConditionalTreeEdit.this._cdlModel.nodeChanged(checkNode);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
                ConditionalTreeNode checkNode = (ConditionalTreeNode)e.getPath().getLastPathComponent();
                if (checkNode.getType().equals("Variables")) {
                    checkNode.setText(ConditionalTreeEdit.this.buildNodeText("Variables", ConditionalTreeEdit.this._curConditional, 0));
                    ConditionalTreeEdit.this._cdlModel.nodeChanged(checkNode);
                }
                if (ConditionalTreeEdit.this._cdlTree.getSelectionCount() == 0) {
                    ConditionalTreeEdit.this.makeDetailGrid("EmptyGrid");
                }
            }
        });
        return this._cdlTree;
    }

    void createConditionalContent() {
        int numConditionals = this._curLogix.getNumConditionals();
        int i = 0;
        while (i < numConditionals) {
            String csName = this._curLogix.getConditionalByNumberOrder(i);
            Conditional curConditional = this._curLogix.getConditional(csName);
            this._cdlNode = new ConditionalTreeNode(this.buildNodeText("Conditional", curConditional, 0), "Conditional", csName, i);
            this._cdlRoot.add(this._cdlNode);
            this._leafNode = new ConditionalTreeNode(this.buildNodeText("Antecedent", curConditional, 0), "Antecedent", csName, 0);
            this._cdlNode.add(this._leafNode);
            this._variableList = curConditional.getCopyOfStateVariables();
            int varCount = this._variableList.size();
            this._varHead = new ConditionalTreeNode(this.buildNodeText("Variables", this._curConditional, 0), "Variables", csName, varCount);
            this._cdlNode.add(this._varHead);
            int v = 0;
            while (v < this._variableList.size()) {
                ConditionalVariable variable = this._variableList.get(v);
                this._leafNode = new ConditionalTreeNode(this.buildNodeText("Variable", variable, v), "Variable", csName, v);
                this._varHead.add(this._leafNode);
                ++v;
            }
            this._leafNode = new ConditionalTreeNode(this.buildNodeText("LogicType", curConditional, 0), "LogicType", csName, 0);
            this._cdlNode.add(this._leafNode);
            boolean triggerMode = curConditional.getTriggerOnChange();
            this._leafNode = new ConditionalTreeNode(this.buildNodeText("TriggerMode", curConditional, 0), "TriggerMode", csName, 0);
            this._cdlNode.add(this._leafNode);
            this._actionList = curConditional.getCopyOfActions();
            int actCount = this._actionList.size();
            this._actHead = new ConditionalTreeNode("Actions", "Actions", csName, actCount);
            this._cdlNode.add(this._actHead);
            int a = 0;
            while (a < this._actionList.size()) {
                ConditionalAction action = this._actionList.get(a);
                this._leafNode = new ConditionalTreeNode(action.description(triggerMode), "Action", csName, a);
                this._actHead.add(this._leafNode);
                ++a;
            }
            ++i;
        }
    }

    void treeRowSelected(ConditionalTreeNode selectedNode) {
        this._curNode = selectedNode;
        this._curNodeName = selectedNode.getName();
        this._curNodeType = selectedNode.getType();
        this._curNodeText = selectedNode.getText();
        this._curNodeRow = selectedNode.getRow();
        if (!this._curConditionalName.equals(this._curNodeName)) {
            this._curConditional = this._conditionalManager.getConditional(this._curNodeName);
            this._antecedent = this._curConditional.getAntecedentExpression();
            this._logicType = this._curConditional.getLogicType();
            this._triggerMode = this._curConditional.getTriggerOnChange();
            this._variableList = this._curConditional.getCopyOfStateVariables();
            this._actionList = this._curConditional.getCopyOfActions();
            this._curConditionalName = this._curNodeName;
        }
        this._addButtonPanel.setVisible(false);
        this._checkButtonPanel.setVisible(false);
        this._toggleButtonPanel.setVisible(false);
        this._moveButtonPanel.setVisible(false);
        this._deleteButtonPanel.setVisible(false);
        this._helpButtonPanel.setVisible(false);
        this._labelPanel.removeAll();
        switch (this._curNodeType) {
            case "Conditional": {
                this._labelPanel.add(this._conditionalLabel);
                this._addButtonPanel.setVisible(true);
                this._checkButtonPanel.setVisible(true);
                this._deleteButtonPanel.setVisible(true);
                this.setMoveButtons();
                this.editPressed();
                break;
            }
            case "Antecedent": {
                this.editPressed();
                break;
            }
            case "LogicType": {
                this.editPressed();
                break;
            }
            case "TriggerMode": {
                this._labelPanel.add(this._triggerModeLabel);
                this._toggleButtonPanel.setVisible(true);
                this.makeDetailGrid("EmptyGrid");
                break;
            }
            case "Variables": {
                this._labelPanel.add(this._variablesLabel);
                this._addButtonPanel.setVisible(true);
                this._checkButtonPanel.setVisible(true);
                this.makeDetailGrid("EmptyGrid");
                break;
            }
            case "Variable": {
                this._labelPanel.add(this._variableLabel);
                this._addButtonPanel.setVisible(true);
                this._deleteButtonPanel.setVisible(true);
                if (this._logicType != Conditional.AntecedentOperator.MIXED) {
                    this.setMoveButtons();
                }
                this.editPressed();
                break;
            }
            case "Actions": {
                this._labelPanel.add(this._actionsLabel);
                this._addButtonPanel.setVisible(true);
                this.makeDetailGrid("EmptyGrid");
                break;
            }
            case "Action": {
                this._labelPanel.add(this._actionLabel);
                this._addButtonPanel.setVisible(true);
                this._deleteButtonPanel.setVisible(true);
                this.setMoveButtons();
                this.editPressed();
                break;
            }
            default: {
                log.warn("Should not be here");
            }
        }
    }

    String buildNodeText(String nodeType, Object component, int idx) {
        switch (nodeType) {
            case "Conditional": {
                Conditional cdl = (Conditional)component;
                String cdlStatus = cdl.getState() == 4 ? Bundle.getMessage("True") : Bundle.getMessage("False");
                String cdlNames = String.valueOf(cdl.getSystemName()) + " -- " + cdl.getUserName();
                String cdlFill = StringUtils.repeat((String)"&nbsp;", (int)5);
                String cdlLine = "<html>" + cdlNames + cdlFill + "<strong>[ " + cdlStatus + " ]</strong></html>";
                return cdlLine;
            }
            case "Antecedent": {
                Conditional cdl = (Conditional)component;
                String antecedent = ConditionalTreeEdit.translateAntecedent(cdl.getAntecedentExpression(), false);
                if (cdl.getLogicType() != Conditional.AntecedentOperator.MIXED) {
                    antecedent = "- - - - - - - - -";
                }
                return String.valueOf(Bundle.getMessage("LogixAntecedent")) + " " + antecedent;
            }
            case "LogicType": {
                String logicName;
                Conditional cdl = (Conditional)component;
                Conditional.AntecedentOperator logicType = cdl.getLogicType();
                switch (logicType) {
                    case ALL_AND: {
                        logicName = Bundle.getMessage("LogicAND");
                        break;
                    }
                    case ALL_OR: {
                        logicName = Bundle.getMessage("LogicOR");
                        break;
                    }
                    case MIXED: {
                        logicName = Bundle.getMessage("LogicMixed");
                        break;
                    }
                    default: {
                        logicName = "None";
                    }
                }
                return String.valueOf(Bundle.getMessage("LabelLogicTypeActions")) + "  " + logicName;
            }
            case "TriggerMode": {
                Conditional cdl = (Conditional)component;
                boolean triggerMode = cdl.getTriggerOnChange();
                String triggerText = triggerMode ? Bundle.getMessage("triggerOnChange") : Bundle.getMessage("triggerOnAny");
                return String.valueOf(Bundle.getMessage("LabelTriggerModeActions")) + "  " + triggerText;
            }
            case "Variables": {
                if (idx == 0) {
                    return Bundle.getMessage("NodeVariablesCollapsed");
                }
                return String.format("%s   [[ %s || %s || %s ]]", Bundle.getMessage("NodeVariablesExpanded"), Bundle.getMessage("ColumnLabelDescription"), Bundle.getMessage("ColumnLabelTriggersCalculation"), Bundle.getMessage("ColumnState"));
            }
            case "Variable": {
                ConditionalVariable var = (ConditionalVariable)component;
                String rowNum = "R" + (idx + 1) + (idx > 9 ? " " : "  ");
                String rowOper = String.valueOf(var.getOpernString()) + " ";
                String rowNot = "";
                if (var.isNegated()) {
                    rowNot = String.valueOf(Bundle.getMessage("LogicNOT")) + " ";
                }
                String boldFormat = "  || <strong>%s</strong>";
                String rowTrigger = String.format(boldFormat, var.doTriggerActions() ? Bundle.getMessage("ButtonYes") : Bundle.getMessage("ButtonNo"));
                String rowStatus = String.format(boldFormat, var.evaluate() ? Bundle.getMessage("True") : Bundle.getMessage("False"));
                String varLine = "<html>" + rowNum + rowOper + rowNot + var.toString() + rowTrigger + rowStatus + "</html>";
                return varLine;
            }
            case "Actions": {
                return Bundle.getMessage("NodeActions");
            }
            case "Action": {
                ConditionalAction act = (ConditionalAction)component;
                return act.description(this._triggerMode);
            }
        }
        return "None";
    }

    void showNodeEditMessage() {
        if (InstanceManager.getNullableDefault(UserPreferencesManager.class) != null) {
            InstanceManager.getDefault(UserPreferencesManager.class).showInfoMessage(Bundle.getMessage("NodeEditTitle"), Bundle.getMessage("NodeEditText"), this.getClassName(), "SkipNodeEditMessage");
        }
    }

    void setFocusListeners() {
        this._editConditionalUserName.addFocusListener(this.detailFocusEvent);
        this._editAntecedent.addFocusListener(this.detailFocusEvent);
        this._editOperatorMode.addFocusListener(this.detailFocusEvent);
        this._variableItemBox.addFocusListener(this.detailFocusEvent);
        this._variableOperBox.addFocusListener(this.detailFocusEvent);
        this._variableNegated.addFocusListener(this.detailFocusEvent);
        this._variableTriggerActions.addFocusListener(this.detailFocusEvent);
        this._variableNameField.addFocusListener(this.detailFocusEvent);
        this._variableStateBox.addFocusListener(this.detailFocusEvent);
        this._variableSignalBox.addFocusListener(this.detailFocusEvent);
        this._selectLogixBox.addFocusListener(this.detailFocusEvent);
        this._selectConditionalBox.addFocusListener(this.detailFocusEvent);
        this._variableCompareOpBox.addFocusListener(this.detailFocusEvent);
        this._variableCompareTypeBox.addFocusListener(this.detailFocusEvent);
        this._variableData1Field.addFocusListener(this.detailFocusEvent);
        this._variableData2Field.addFocusListener(this.detailFocusEvent);
        this._actionItemBox.addFocusListener(this.detailFocusEvent);
        this._actionNameField.addFocusListener(this.detailFocusEvent);
        this._actionTypeBox.addFocusListener(this.detailFocusEvent);
        this._actionBox.addFocusListener(this.detailFocusEvent);
        this._shortActionString.addFocusListener(this.detailFocusEvent);
        this._longActionString.addFocusListener(this.detailFocusEvent);
        this._actionSetButton.addFocusListener(this.detailFocusEvent);
        this._actionOptionBox.addFocusListener(this.detailFocusEvent);
    }

    void setEditMode(boolean active) {
        Component addButton;
        this._editActive = active;
        this._cancelAction.setEnabled(active);
        this._updateAction.setEnabled(active);
        Component delButton = this._deleteButtonPanel.getComponent(0);
        if (delButton instanceof JButton) {
            delButton.setEnabled(!active);
        }
        if ((addButton = this._addButtonPanel.getComponent(0)) instanceof JButton) {
            addButton.setEnabled(!active);
        }
        if (this._curNodeType != null && (this._curNodeType.equals("Conditional") || this._curNodeType.equals("Variable") || this._curNodeType.equals("Action"))) {
            this.setMoveButtons();
        }
        if (active) {
            this.setPickWindow("Activate", Conditional.ItemType.NONE);
        } else {
            this.setPickWindow("Deactivate", Conditional.ItemType.NONE);
        }
    }

    void setPickWindow(String cmd, Conditional.ItemType item) {
        if (this._selectionMode == ConditionalEditBase.SelectionMode.USECOMBO) {
            return;
        }
        if (cmd.equals("Variable") || cmd.equals("Action")) {
            this._pickCommand = cmd;
            this._pickItem = item;
            if (this._editActive) {
                if (this._selectionMode == ConditionalEditBase.SelectionMode.USEMULTI) {
                    this.doPickList();
                } else {
                    this.doPickSingle();
                }
            }
        }
        if (cmd.equals("Activate") && (this._curNodeType.equals("Variable") || this._curNodeType.equals("Action"))) {
            if (this._selectionMode == ConditionalEditBase.SelectionMode.USEMULTI) {
                this.doPickList();
            } else {
                this.doPickSingle();
            }
        }
        if (cmd.equals("Deactivate")) {
            this.hidePickListTable();
            this.closeSinglePanelPickList();
        }
    }

    void doPickList() {
        if (this._pickItem == Conditional.ItemType.NONE) {
            return;
        }
        if (this._pickTables == null) {
            this.openPickListTable();
        }
        if (this._pickCommand.equals("Variable")) {
            this.setPickListTab(this._pickItem, false);
        } else if (this._pickCommand.equals("Action")) {
            this.setPickListTab(this._pickItem, true);
        }
    }

    void doPickSingle() {
        if (this._pickCommand.equals("Variable")) {
            this.createSinglePanelPickList(this._pickItem, new ConditionalEditBase.PickSingleListener(this._variableNameField, this._pickItem), false);
        } else if (this._pickCommand.equals("Action")) {
            this.createSinglePanelPickList(this._pickItem, new ConditionalEditBase.PickSingleListener(this._actionNameField, this._pickItem), true);
        }
    }

    void buildVariableComponents() {
        this._variableItemBox = new JComboBox();
        for (Conditional.ItemType itemType : Conditional.ItemType.getStateVarList()) {
            this._variableItemBox.addItem(itemType);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._variableItemBox);
        this._variableItemBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Conditional.ItemType newVariableItem = ConditionalTreeEdit.this._variableItemBox.getItemAt(ConditionalTreeEdit.this._variableItemBox.getSelectedIndex());
                if (log.isDebugEnabled()) {
                    log.debug("_variableItemBox Listener: new = {}, curr = {}, row = {}", new Object[]{newVariableItem, ConditionalTreeEdit.this._curVariableItem, ConditionalTreeEdit.this._curNodeRow});
                }
                if (newVariableItem != ConditionalTreeEdit.this._curVariableItem) {
                    if (ConditionalTreeEdit.this._curNodeRow >= 0) {
                        ConditionalTreeEdit.this._curVariable = new ConditionalVariable();
                        ConditionalTreeEdit.this._variableList.set(ConditionalTreeEdit.this._curNodeRow, ConditionalTreeEdit.this._curVariable);
                    }
                    ConditionalTreeEdit.this._curVariableItem = newVariableItem;
                }
                ConditionalTreeEdit.this.variableTypeChanged(newVariableItem);
            }
        });
        this._variableOperBox = new JComboBox();
        this._variableOperBox.addItem(Bundle.getMessage("LogicAND"));
        this._variableOperBox.addItem(Bundle.getMessage("LogicOR"));
        this._variableNegated = new JCheckBox();
        this._variableTriggerActions = new JCheckBox();
        this._variableNameField = new JTextField(20);
        this._selectLogixBox.addItem("XXXXXXXXXXXXXXXXXXXXX");
        this._selectConditionalBox.addItem("XXXXXXXXXXXXXXXXXXXXX");
        this._selectLogixBox.addActionListener(this.selectLogixBoxListener);
        this._selectConditionalBox.addActionListener(this.selectConditionalBoxListener);
        this._variableStateBox = new JComboBox();
        this._variableStateBox.addItem(Conditional.Type.XXXXXXX);
        this._variableSignalBox = new JComboBox();
        this._variableSignalBox.addItem("XXXXXXXXX");
        this._variableCompareOpBox = new JComboBox();
        int i = 1;
        while (i <= 5) {
            this._variableCompareOpBox.addItem(ConditionalVariable.getCompareOperationString(i));
            ++i;
        }
        this._variableCompareTypeBox = new JComboBox();
        for (Conditional.Type type : Conditional.Type.getMemoryItems()) {
            this._variableCompareTypeBox.addItem(type);
        }
        this._variableCompareTypeBox.addActionListener(this.compareTypeBoxListener);
        this._variableData1Field = new JTextField(10);
        this._variableData2Field = new JTextField(10);
    }

    void makeEmptyVariableGrid(GridBagConstraints c) {
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row0Label = new JLabel(Bundle.getMessage("LabelVariableType"));
        row0Label.setToolTipText(Bundle.getMessage("VariableTypeHint"));
        this._gridPanel.add((Component)row0Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add(this._variableItemBox, c);
    }

    void makeOptionsVariableGrid(GridBagConstraints c) {
        this.makeEmptyVariableGrid(c);
        c.gridy = 1;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row1Label = new JLabel(Bundle.getMessage("ColumnLabelOperator"));
        row1Label.setToolTipText(Bundle.getMessage("VariableOperHint"));
        this._gridPanel.add((Component)row1Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add(this._variableOperBox, c);
        c.gridy = 2;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row2Label = new JLabel(Bundle.getMessage("ColumnLabelNot"));
        row2Label.setToolTipText(Bundle.getMessage("VariableNotHint"));
        this._gridPanel.add((Component)row2Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add((Component)this._variableNegated, c);
        c.gridy = 3;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row3Label = new JLabel(Bundle.getMessage("ColumnLabelTriggersCalculation"));
        row3Label.setToolTipText(Bundle.getMessage("VariableTriggerHint"));
        this._gridPanel.add((Component)row3Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add((Component)this._variableTriggerActions, c);
    }

    void makeStandardVariableGrid(GridBagConstraints c) {
        this.makeOptionsVariableGrid(c);
        c.gridy = 4;
        c.gridx = 0;
        c.anchor = 13;
        this._gridPanel.add((Component)this._variableNameLabel, c);
        c.gridx = 1;
        c.anchor = 17;
        if (this._selectionMode == ConditionalEditBase.SelectionMode.USECOMBO) {
            this._gridPanel.add(this._comboNameBox, c);
        } else {
            this._gridPanel.add((Component)this._variableNameField, c);
        }
        c.gridy = 5;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row5Label = new JLabel(Bundle.getMessage("LabelVariableState"));
        row5Label.setToolTipText(Bundle.getMessage("VariableStateHint"));
        this._gridPanel.add((Component)row5Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add(this._variableStateBox, c);
    }

    void makeSignalAspectVariableGrid(GridBagConstraints c) {
        this.makeStandardVariableGrid(c);
        c.gridy = 6;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row5Label = new JLabel(Bundle.getMessage("LabelVariableAspect"));
        row5Label.setToolTipText(Bundle.getMessage("VariableAspectHint"));
        this._gridPanel.add((Component)row5Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add(this._variableSignalBox, c);
    }

    void makeConditionalVariableGrid(GridBagConstraints c) {
        this.makeOptionsVariableGrid(c);
        c.gridy = 4;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row4Label = new JLabel(Bundle.getMessage("SelectLogix"));
        row4Label.setToolTipText(Bundle.getMessage("VariableLogixHint"));
        this._gridPanel.add((Component)row4Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add(this._selectLogixBox, c);
        c.gridy = 5;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row5Label = new JLabel(Bundle.getMessage("SelectConditional"));
        row5Label.setToolTipText(Bundle.getMessage("VariableConditionalHint"));
        this._gridPanel.add((Component)row5Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add(this._selectConditionalBox, c);
        c.gridy = 6;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row6Label = new JLabel(Bundle.getMessage("LabelVariableState"));
        row6Label.setToolTipText(Bundle.getMessage("VariableStateHint"));
        this._gridPanel.add((Component)row6Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add(this._variableStateBox, c);
    }

    void makeMemoryVariableGrid(GridBagConstraints c) {
        this.makeOptionsVariableGrid(c);
        c.gridy = 4;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row4Label = new JLabel(Bundle.getMessage("LabelItemName"));
        row4Label.setToolTipText(Bundle.getMessage("NameHintMemory"));
        this._gridPanel.add((Component)row4Label, c);
        c.gridx = 1;
        c.anchor = 17;
        if (this._selectionMode == ConditionalEditBase.SelectionMode.USECOMBO) {
            this._gridPanel.add(this._comboNameBox, c);
        } else {
            this._gridPanel.add((Component)this._variableNameField, c);
        }
        c.gridy = 5;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row5Label = new JLabel(Bundle.getMessage("LabelCompareOp"));
        row5Label.setToolTipText(Bundle.getMessage("CompareHintMemory"));
        this._gridPanel.add((Component)row5Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add(this._variableCompareOpBox, c);
        c.gridy = 6;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row6Label = new JLabel(Bundle.getMessage("LabelCompareType"));
        row6Label.setToolTipText(Bundle.getMessage("CompareTypeHint"));
        this._gridPanel.add((Component)row6Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add(this._variableCompareTypeBox, c);
        c.gridy = 7;
        c.gridx = 0;
        c.anchor = 13;
        this._gridPanel.add((Component)this._variableMemoryValueLabel, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add((Component)this._variableData1Field, c);
    }

    void makeFastClockVariableGrid(GridBagConstraints c) {
        this.makeOptionsVariableGrid(c);
        c.gridy = 4;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row4Label = new JLabel(Bundle.getMessage("LabelStartTime"));
        row4Label.setToolTipText(Bundle.getMessage("DataHintTime"));
        this._gridPanel.add((Component)row4Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add((Component)this._variableData1Field, c);
        c.gridy = 5;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row5Label = new JLabel(Bundle.getMessage("LabelEndTime"));
        row5Label.setToolTipText(Bundle.getMessage("DataHintTime"));
        this._gridPanel.add((Component)row5Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add((Component)this._variableData2Field, c);
    }

    void initializeStateVariables() {
        Conditional.Type testType = this._curVariable.getType();
        if (log.isDebugEnabled()) {
            log.debug("initializeStateVariables: testType= {}", (Object)testType);
        }
        Conditional.ItemType itemType = testType.getItemType();
        log.debug("initializeStateVariables: itemType= {}, testType= {}", (Object)itemType, (Object)testType);
        if (itemType == this._variableItemBox.getSelectedItem()) {
            this.variableTypeChanged(itemType);
        }
        this._variableItemBox.setSelectedItem((Object)itemType);
        this._variableOperBox.setSelectedItem(this._curVariable.getOpernString());
        this._variableNegated.setSelected(this._curVariable.isNegated());
        this._variableTriggerActions.setSelected(this._curVariable.doTriggerActions());
        switch (itemType) {
            case NONE: {
                this._variableNameField.setText("");
                break;
            }
            case SENSOR: 
            case TURNOUT: 
            case LIGHT: 
            case CONDITIONAL: 
            case WARRANT: {
                this._variableStateBox.setSelectedItem((Object)testType);
                this._variableNameField.setText(this._curVariable.getName());
                break;
            }
            case SIGNALHEAD: {
                this._variableStateBox.setSelectedItem((Object)testType);
                this._variableNameField.setText(this._curVariable.getName());
                if (!Conditional.Type.isSignalHeadApperance(testType)) break;
                this._variableStateBox.setSelectedItem((Object)Conditional.Type.SIGNAL_HEAD_APPEARANCE_EQUALS);
                this._variableSignalBox.setSelectedItem((Object)this._curVariable.getType());
                break;
            }
            case SIGNALMAST: {
                this._variableStateBox.setSelectedItem((Object)testType);
                this._variableNameField.setText(this._curVariable.getName());
                if (testType != Conditional.Type.SIGNAL_MAST_ASPECT_EQUALS) break;
                this._variableSignalBox.setSelectedItem(this._curVariable.getDataString());
                break;
            }
            case MEMORY: {
                this._variableCompareTypeBox.setSelectedIndex(Conditional.Type.getIndexInList(Conditional.Type.getMemoryItems(), testType));
                this._variableNameField.setText(this._curVariable.getName());
                int num1 = this._curVariable.getNum1() - 1;
                if (num1 == -1) {
                    num1 = 2;
                }
                this._variableCompareOpBox.setSelectedIndex(num1);
                this._variableData1Field.setText(this._curVariable.getDataString());
                break;
            }
            case CLOCK: {
                int time = this._curVariable.getNum1();
                this._variableData1Field.setText(ConditionalTreeEdit.formatTime(time / 60, time - time / 60 * 60));
                time = this._curVariable.getNum2();
                this._variableData2Field.setText(ConditionalTreeEdit.formatTime(time / 60, time - time / 60 * 60));
                this._variableNameField.setText("");
                break;
            }
            case OBLOCK: {
                this._variableNameField.setText(this._curVariable.getName());
                for (Conditional.Type type : Conditional.Type.getOBlockItems()) {
                    this._variableStateBox.addItem(type);
                    if (!type.toString().equals(OBlock.getLocalStatusName(this._curVariable.getDataString()))) continue;
                    this._variableStateBox.setSelectedItem((Object)type);
                }
                break;
            }
            case ENTRYEXIT: {
                this._variableNameField.setText(this._curVariable.getBean().getUserName());
                this._variableStateBox.setSelectedItem((Object)testType);
                break;
            }
        }
        this._detailGrid.setVisible(true);
    }

    private void variableTypeChanged(Conditional.ItemType itemType) {
        Conditional.Type testType = this._curVariable.getType();
        log.debug("variableTypeChanged: itemType= {}, testType= {}", (Object)itemType, (Object)testType);
        this._variableStateBox.removeAllItems();
        this._variableNameField.removeActionListener(this.variableSignalHeadNameListener);
        this._variableNameField.removeActionListener(this.variableSignalMastNameListener);
        this._variableStateBox.removeActionListener(this.variableSignalTestStateListener);
        this._detailGrid.setVisible(false);
        if (this._comboNameBox != null) {
            ActionListener[] actionListenerArray = this._comboNameBox.getActionListeners();
            int n = actionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionListener item = actionListenerArray[n2];
                this._comboNameBox.removeActionListener(item);
                ++n2;
            }
            this._comboNameBox.removeFocusListener(this.detailFocusEvent);
        }
        this.setPickWindow("Variable", itemType);
        this._variableOperBox.setSelectedItem(this._curVariable.getOpernString());
        this._variableNegated.setSelected(this._curVariable.isNegated());
        this._variableTriggerActions.setSelected(this._curVariable.doTriggerActions());
        switch (itemType) {
            case NONE: {
                this.makeDetailGrid("EmptyVariable");
                break;
            }
            case SENSOR: {
                this._variableNameLabel.setToolTipText(Bundle.getMessage("NameHintSensor"));
                for (Conditional.Type type : Conditional.Type.getSensorItems()) {
                    this._variableStateBox.addItem(type);
                }
                this.setVariableNameBox(itemType);
                this.makeDetailGrid("StandardVariable");
                break;
            }
            case TURNOUT: {
                this._variableNameLabel.setToolTipText(Bundle.getMessage("NameHintTurnout"));
                for (Conditional.Type type : Conditional.Type.getTurnoutItems()) {
                    this._variableStateBox.addItem(type);
                }
                this.setVariableNameBox(itemType);
                this.makeDetailGrid("StandardVariable");
                break;
            }
            case LIGHT: {
                this._variableNameLabel.setToolTipText(Bundle.getMessage("NameHintLight"));
                for (Conditional.Type type : Conditional.Type.getLightItems()) {
                    this._variableStateBox.addItem(type);
                }
                this.setVariableNameBox(itemType);
                this.makeDetailGrid("StandardVariable");
                break;
            }
            case SIGNALHEAD: {
                this._variableNameLabel.setToolTipText(Bundle.getMessage("NameHintSignal"));
                this.loadJComboBoxWithHeadAppearances(this._variableSignalBox, this._variableNameField.getText().trim());
                for (Conditional.Type type : Conditional.Type.getSignalHeadStateMachineItems()) {
                    this._variableStateBox.addItem(type);
                }
                this.setVariableNameBox(itemType);
                if (testType == Conditional.Type.SIGNAL_HEAD_APPEARANCE_EQUALS) {
                    this.makeDetailGrid("SignalAspectVariable");
                } else {
                    this.makeDetailGrid("StandardVariable");
                }
                this._variableNameField.addActionListener(this.variableSignalHeadNameListener);
                this._variableStateBox.addActionListener(this.variableSignalTestStateListener);
                break;
            }
            case SIGNALMAST: {
                this._variableNameLabel.setToolTipText(Bundle.getMessage("NameHintSignalMast"));
                this._variableNameField.addActionListener(this.variableSignalMastNameListener);
                this._variableStateBox.addActionListener(this.variableSignalTestStateListener);
                this.loadJComboBoxWithMastAspects(this._variableSignalBox, this._variableNameField.getText().trim());
                for (Conditional.Type type : Conditional.Type.getSignalMastItems()) {
                    this._variableStateBox.addItem(type);
                }
                this.setVariableNameBox(itemType);
                if (testType == Conditional.Type.SIGNAL_MAST_ASPECT_EQUALS) {
                    this.makeDetailGrid("SignalAspectVariable");
                    break;
                }
                this.makeDetailGrid("StandardVariable");
                break;
            }
            case MEMORY: {
                this._variableNameLabel.setToolTipText(Bundle.getMessage("NameHintMemory"));
                this.setVariableNameBox(itemType);
                this.makeDetailGrid("MemoryVariable");
                this.compareTypeChanged(testType);
                break;
            }
            case CONDITIONAL: {
                for (Conditional.Type type : Conditional.Type.getConditionalItems()) {
                    this._variableStateBox.addItem(type);
                }
                this.loadSelectLogixBox();
                this.makeDetailGrid("ConditionalVariable");
                this._selectLogixBox.addActionListener(this.selectLogixBoxListener);
                this._selectConditionalBox.addActionListener(this.selectConditionalBoxListener);
                break;
            }
            case WARRANT: {
                this._variableNameLabel.setToolTipText(Bundle.getMessage("NameHintWarrant"));
                for (Conditional.Type type : Conditional.Type.getWarrantItems()) {
                    this._variableStateBox.addItem(type);
                }
                this.setVariableNameBox(itemType);
                this.makeDetailGrid("StandardVariable");
                break;
            }
            case CLOCK: {
                this.makeDetailGrid("FastClockVariable");
                break;
            }
            case OBLOCK: {
                this._variableNameLabel.setToolTipText(Bundle.getMessage("NameHintOBlock"));
                this._variableStateBox.removeAllItems();
                for (Conditional.Type type : Conditional.Type.getOBlockItems()) {
                    this._variableStateBox.addItem(type);
                }
                this.setVariableNameBox(itemType);
                this.makeDetailGrid("StandardVariable");
                break;
            }
            case ENTRYEXIT: {
                this._variableNameLabel.setToolTipText(Bundle.getMessage("NameHintEntryExit"));
                this._variableNameField.setText(this._curVariable.getName());
                for (Conditional.Type type : Conditional.Type.getEntryExitItems()) {
                    this._variableStateBox.addItem(type);
                }
                this.setVariableNameBox(itemType);
                this.makeDetailGrid("StandardVariable");
                break;
            }
        }
    }

    void setVariableNameBox(Conditional.ItemType itemType) {
        if (this._selectionMode != ConditionalEditBase.SelectionMode.USECOMBO) {
            return;
        }
        this._comboNameBox = this.createNameBox(itemType);
        if (this._comboNameBox == null) {
            return;
        }
        this._comboNameBox.setSelectedItemByName(this._curVariable.getName());
        this._comboNameBox.addActionListener(new ConditionalEditBase.NameBoxListener(this._variableNameField));
        this._comboNameBox.addFocusListener(this.detailFocusEvent);
    }

    void cancelEditVariable() {
        if (this._newVariableItem) {
            this._newVariableItem = false;
            this.deletePressed();
        }
        this.cleanUpVariable();
    }

    void updateVariable() {
        if (!this.validateVariable()) {
            return;
        }
        this._newVariableItem = false;
        this._curConditional.setStateVariables(this._variableList);
        TreeSet<String> newTargetNames = new TreeSet<String>();
        this.loadReferenceNames(this._variableList, newTargetNames);
        this.updateWhereUsed(this._oldTargetNames, newTargetNames, this._curNodeName);
        this._curNode.setText(this.buildNodeText("Variable", this._curVariable, this._curNodeRow));
        this._cdlModel.nodeChanged(this._curNode);
        this.cleanUpVariable();
    }

    void cleanUpVariable() {
        if (this._logicType != Conditional.AntecedentOperator.MIXED) {
            this.setMoveButtons();
        }
    }

    void loadSelectLogixBox() {
        String lgxName;
        String cdlName = this._curVariable.getName();
        if (cdlName.length() == 0 || this._curVariable.getType() != Conditional.Type.CONDITIONAL_TRUE && this._curVariable.getType() != Conditional.Type.CONDITIONAL_FALSE) {
            lgxName = this._curLogix.getSystemName();
        } else {
            Logix x = this._conditionalManager.getParentLogix(cdlName);
            if (x == null) {
                log.error("Unable to find the Logix for {}, using the current Logix", (Object)cdlName);
                lgxName = this._curLogix.getSystemName();
            } else {
                lgxName = x.getSystemName();
            }
        }
        this._selectLogixBox.removeAllItems();
        this._selectLogixMap.clear();
        String itemKey = "";
        for (Logix lgx : this._logixManager.getNamedBeanSet()) {
            String sName = lgx.getSystemName();
            if (sName.equals("SYS")) continue;
            String uName = lgx.getUserName();
            String itemName = "";
            itemName = uName == null || uName.length() < 1 ? sName : String.valueOf(uName) + " ( " + sName + " )";
            this._selectLogixMap.put(itemName, sName);
            if (!lgxName.equals(sName)) continue;
            itemKey = itemName;
        }
        for (String item : this._selectLogixMap.keySet()) {
            this._selectLogixBox.addItem(item);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._selectLogixBox);
        this._selectLogixBox.setSelectedItem(itemKey);
        this.loadSelectConditionalBox(lgxName);
    }

    void loadSelectConditionalBox(String logixName) {
        String cdlName = this._curVariable.getName();
        this._selectConditionalBox.removeAllItems();
        this._selectConditionalList.clear();
        String itemKey = Bundle.getMessage("SelectFirstRow");
        this._selectConditionalBox.addItem(itemKey);
        this._selectConditionalList.add("-None-");
        Logix x = this._logixManager.getBySystemName(logixName);
        if (x == null) {
            log.error("Logix '{}' not found while building the conditional list", (Object)logixName);
            return;
        }
        if (x.getNumConditionals() == 0) {
            return;
        }
        for (String cName : this._conditionalManager.getSystemNameListForLogix(x)) {
            Conditional c = this._conditionalManager.getConditional(cName);
            if (this._curConditional.getSystemName().equals(c.getSystemName())) continue;
            String uName = c.getUserName();
            String itemName = "";
            itemName = uName == null || uName.length() < 1 ? cName : String.valueOf(uName) + " ( " + cName + " )";
            this._selectConditionalBox.addItem(itemName);
            this._selectConditionalList.add(cName);
            if (!cdlName.equals(cName)) continue;
            itemKey = itemName;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._selectConditionalBox);
        this._selectConditionalBox.setSelectedItem(itemKey);
    }

    private void compareTypeChanged(Conditional.Type testType) {
        if (testType == Conditional.Type.MEMORY_COMPARE || testType == Conditional.Type.MEMORY_COMPARE_INSENSITIVE) {
            this._variableMemoryValueLabel.setText(Bundle.getMessage("LabelMemoryValue"));
            this._variableMemoryValueLabel.setToolTipText(Bundle.getMessage("DataHintMemory"));
        } else {
            this._variableMemoryValueLabel.setText(Bundle.getMessage("LabelLiteralValue"));
            this._variableMemoryValueLabel.setToolTipText(Bundle.getMessage("DataHintValue"));
        }
    }

    void loadJComboBoxWithHeadAppearances(JComboBox<String> box, String signalHeadName) {
        box.removeAllItems();
        log.debug("loadJComboBoxWithSignalHeadAppearances called with name: {}", (Object)signalHeadName);
        SignalHead h = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHeadName);
        if (h == null) {
            box.addItem(Bundle.getMessage("PromptLoadHeadName"));
        } else {
            String[] v = h.getValidStateNames();
            int i = 0;
            while (i < v.length) {
                box.addItem(v[i]);
                ++i;
            }
            box.setSelectedItem(h.getAppearanceName());
        }
    }

    void loadJComboBoxWithMastAspects(JComboBox<String> box, String mastName) {
        box.removeAllItems();
        SignalMast m = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(mastName);
        if (m == null) {
            box.addItem(Bundle.getMessage("PromptLoadMastName"));
        } else {
            Vector<String> v = m.getValidAspects();
            int i = 0;
            while (i < v.size()) {
                box.addItem(v.get(i));
                ++i;
            }
            box.setSelectedItem(m.getAspect());
        }
    }

    boolean validateVariable() {
        String name = this._variableNameField.getText().trim();
        this._variableNameField.setText(name);
        this._curVariable.setDataString("");
        this._curVariable.setNum1(0);
        this._curVariable.setNum2(0);
        this.updateVariableOperator();
        this.updateVariableNegation();
        this._curVariable.setTriggerActions(this._variableTriggerActions.isSelected());
        Conditional.ItemType itemType = this._variableItemBox.getItemAt(this._variableItemBox.getSelectedIndex());
        if (!this.checkIsAction(name, itemType)) {
            return false;
        }
        Conditional.Type testType = Conditional.Type.NONE;
        switch (itemType) {
            case SENSOR: 
            case TURNOUT: 
            case LIGHT: 
            case SIGNALHEAD: 
            case SIGNALMAST: 
            case CONDITIONAL: 
            case WARRANT: 
            case ENTRYEXIT: {
                testType = this._variableStateBox.getItemAt(this._variableStateBox.getSelectedIndex());
                break;
            }
            case MEMORY: {
                testType = this._variableCompareTypeBox.getItemAt(this._variableCompareTypeBox.getSelectedIndex());
                break;
            }
            case CLOCK: {
                testType = Conditional.Type.FAST_CLOCK_RANGE;
                break;
            }
            case OBLOCK: {
                testType = Conditional.Type.BLOCK_STATUS_EQUALS;
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("ErrorVariableType"), Bundle.getMessage("ErrorTitle"), 0);
                return false;
            }
        }
        this._curVariable.setType(testType);
        log.debug("validateVariable: itemType= {}, testType= {}", (Object)itemType, (Object)testType);
        switch (itemType) {
            case SENSOR: {
                name = this.validateSensorReference(name);
                if (name != null) break;
                return false;
            }
            case TURNOUT: {
                name = this.validateTurnoutReference(name);
                if (name != null) break;
                return false;
            }
            case CONDITIONAL: {
                name = this.validateConditionalReference(name);
                if (name == null) {
                    return false;
                }
                this._curVariable.setName(name);
                Conditional c = this._conditionalManager.getBySystemName(name);
                if (c == null) {
                    return false;
                }
                String uName = c.getUserName();
                if (uName == null || uName.isEmpty()) {
                    this._curVariable.setGuiName(c.getSystemName());
                    break;
                }
                this._curVariable.setGuiName(uName);
                break;
            }
            case LIGHT: {
                name = this.validateLightReference(name);
                if (name != null) break;
                return false;
            }
            case MEMORY: {
                name = this.validateMemoryReference(name);
                if (name == null) {
                    return false;
                }
                String name2 = this._variableData1Field.getText();
                if ((testType == Conditional.Type.MEMORY_COMPARE || testType == Conditional.Type.MEMORY_COMPARE_INSENSITIVE) && (name2 = this.validateMemoryReference(name2)) == null) {
                    return false;
                }
                this._curVariable.setDataString(name2);
                this._curVariable.setNum1(this._variableCompareOpBox.getSelectedIndex() + 1);
                break;
            }
            case CLOCK: {
                int beginTime = this.parseTime(this._variableData1Field.getText());
                if (beginTime < 0) {
                    return false;
                }
                int endTime = this.parseTime(this._variableData2Field.getText());
                if (endTime < 0) {
                    return false;
                }
                this._curVariable.setNum1(beginTime);
                this._curVariable.setNum2(endTime);
                name = "Clock";
                break;
            }
            case SIGNALHEAD: {
                name = this.validateSignalHeadReference(name);
                if (name == null) {
                    return false;
                }
                if (testType != Conditional.Type.SIGNAL_HEAD_APPEARANCE_EQUALS) break;
                String appStr = (String)this._variableSignalBox.getSelectedItem();
                if (appStr != null) {
                    Conditional.Type type = ConditionalVariable.stringToVariableTest(appStr);
                    if (type == Conditional.Type.ERROR) {
                        JOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("ErrorAppearance"), Bundle.getMessage("ErrorTitle"), 0);
                        return false;
                    }
                    this._curVariable.setType(type);
                    this._curVariable.setDataString(appStr);
                    log.debug("SignalHead \"{}\"of type '{}' _variableSignalBox.getSelectedItem()= {}", new Object[]{name, testType, this._variableSignalBox.getSelectedItem()});
                    break;
                }
                log.warn("null selection in _variableSignalBox");
                break;
            }
            case SIGNALMAST: {
                name = this.validateSignalMastReference(name);
                if (name == null) {
                    return false;
                }
                if (testType != Conditional.Type.SIGNAL_MAST_ASPECT_EQUALS) break;
                if (this._variableSignalBox.getSelectedIndex() < 0) {
                    JOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("ErrorAspect"), Bundle.getMessage("ErrorTitle"), 0);
                    return false;
                }
                this._curVariable.setDataString((String)this._variableSignalBox.getSelectedItem());
                break;
            }
            case WARRANT: {
                name = this.validateWarrantReference(name);
                if (name != null) break;
                return false;
            }
            case OBLOCK: {
                name = this.validateOBlockReference(name);
                if (name == null) {
                    return false;
                }
                String stri18n = (String)this._variableStateBox.getSelectedItem();
                if (stri18n == null) break;
                this._curVariable.setDataString(OBlock.getSystemStatusName(stri18n));
                log.debug("OBlock \"{}\"of type '{}' _variableSignalBox.getSelectedItem()= {}", new Object[]{name, testType, this._variableSignalBox.getSelectedItem()});
                break;
            }
            case ENTRYEXIT: {
                name = this.validateEntryExitReference(name);
                if (name != null) break;
                return false;
            }
            default: {
                JOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("ErrorVariableType"), Bundle.getMessage("ErrorTitle"), 0);
                return false;
            }
        }
        this._curVariable.setName(name);
        boolean result = this._curVariable.evaluate();
        log.debug("State Variable \"{}\" of type '{}' state= {} type= {}", new Object[]{name, testType.getTestTypeString(), result, this._curVariable.getType()});
        if (this._curVariable.getType() == Conditional.Type.NONE) {
            JOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("ErrorVariableState"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        return true;
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="Except for the root node, all nodes are ConditionalTreeNode")
    void updateVariableOperator() {
        Conditional.Operator oldOper = this._curVariable.getOpern();
        if (this._curNodeRow > 0) {
            if (this._variableOperBox.getSelectedIndex() == 0) {
                this._curVariable.setOpern(Conditional.Operator.AND);
            } else {
                this._curVariable.setOpern(Conditional.Operator.OR);
            }
        } else {
            this._curVariable.setOpern(Conditional.Operator.NONE);
        }
        if (this._curVariable.getOpern() != oldOper) {
            this.makeAntecedent();
            this._curConditional.setLogicType(this._logicType, this._antecedent);
            ConditionalTreeNode antLeaf = (ConditionalTreeNode)((ConditionalTreeNode)this._curNode.getParent()).getPreviousSibling();
            antLeaf.setText(this.buildNodeText("Antecedent", this._curConditional, 0));
            this._cdlModel.nodeChanged(antLeaf);
        }
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="Except for the root node, all nodes are ConditionalTreeNode")
    void updateVariableNegation() {
        boolean state = this._curVariable.isNegated();
        if (this._variableNegated.isSelected()) {
            this._curVariable.setNegation(true);
        } else {
            this._curVariable.setNegation(false);
        }
        if (this._curVariable.isNegated() != state) {
            this.makeAntecedent();
            this._curConditional.setLogicType(this._logicType, this._antecedent);
            ConditionalTreeNode antLeaf = (ConditionalTreeNode)((ConditionalTreeNode)this._curNode.getParent()).getPreviousSibling();
            antLeaf.setText(this.buildNodeText("Antecedent", this._curConditional, 0));
            this._cdlModel.nodeChanged(antLeaf);
        }
    }

    void updateVariableList() {
        this._curLogix.deActivateLogix();
        this._curConditional.setStateVariables(this._variableList);
        this._variableList = this._curConditional.getCopyOfStateVariables();
        this._curLogix.activateLogix();
    }

    void buildActionComponents() {
        this._actionItemBox = new JComboBox();
        Conditional.ItemType[] itemTypeArray = Conditional.ItemType.values();
        int n = itemTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Conditional.ItemType itemType = itemTypeArray[n2];
            this._actionItemBox.addItem(itemType);
            ++n2;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._actionItemBox);
        this._actionItemBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Conditional.ItemType newActionItem = ConditionalTreeEdit.this._actionItemBox.getItemAt(ConditionalTreeEdit.this._actionItemBox.getSelectedIndex());
                if (log.isDebugEnabled()) {
                    log.debug("_actionItemBox Listener: new = {}, curr = {}, row = {}", new Object[]{newActionItem, ConditionalTreeEdit.this._curActionItem, ConditionalTreeEdit.this._curNodeRow});
                }
                if (newActionItem != ConditionalTreeEdit.this._curActionItem) {
                    if (ConditionalTreeEdit.this._curNodeRow >= 0) {
                        ConditionalTreeEdit.this._curAction = new DefaultConditionalAction();
                        ConditionalTreeEdit.this._actionList.set(ConditionalTreeEdit.this._curNodeRow, ConditionalTreeEdit.this._curAction);
                    }
                    ConditionalTreeEdit.this._curActionItem = newActionItem;
                }
                ConditionalTreeEdit.this.actionItemChanged(newActionItem);
            }
        });
        this._actionNameField = new JTextField(20);
        this._actionTypeBox = new JComboBox();
        this._actionTypeBox.addItem(Conditional.Action.NONE);
        this._actionBox = new JComboBox();
        this._actionBox.addItem("");
        this._shortActionString = new JTextField(15);
        this._actionOptionBox = new JComboBox();
        this._actionSetButton = new JButton("...");
        this._actionSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalTreeEdit.this.validateAction();
                ConditionalTreeEdit.this.setFileLocation(e);
            }
        });
        this._longActionString = new JTextField(30);
    }

    void makeEmptyActionGrid(GridBagConstraints c) {
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row0Label = new JLabel(Bundle.getMessage("LabelActionItem"));
        row0Label.setToolTipText(Bundle.getMessage("ActionItemHint"));
        this._gridPanel.add((Component)row0Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add(this._actionItemBox, c);
    }

    void makeNameTypeActionGrid(GridBagConstraints c, boolean finalRow) {
        this.makeEmptyActionGrid(c);
        Conditional.Action actionType = this._curAction.getType();
        Conditional.ItemType itemType = actionType.getItemType();
        c.gridy = 1;
        c.gridx = 0;
        c.anchor = 13;
        this._gridPanel.add((Component)this._actionNameLabel, c);
        c.gridx = 1;
        c.anchor = 17;
        if (this._selectionMode == ConditionalEditBase.SelectionMode.USECOMBO && itemType != Conditional.ItemType.AUDIO) {
            this._gridPanel.add(this._comboNameBox, c);
        } else {
            this._gridPanel.add((Component)this._actionNameField, c);
        }
        c.gridy = 2;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row5Label = new JLabel(Bundle.getMessage("LabelActionType"));
        row5Label.setToolTipText(Bundle.getMessage("ActionTypeHint"));
        this._gridPanel.add((Component)row5Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add(this._actionTypeBox, c);
        if (itemType == Conditional.ItemType.NONE) {
            return;
        }
        if (finalRow) {
            this.makeChangeTriggerActionGrid(c);
        }
    }

    void makeTypeActionGrid(GridBagConstraints c, boolean finalRow) {
        this.makeEmptyActionGrid(c);
        Conditional.Action actionType = this._curAction.getType();
        Conditional.ItemType itemType = actionType.getItemType();
        c.gridy = 1;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row5Label = new JLabel(Bundle.getMessage("LabelActionType"));
        row5Label.setToolTipText(Bundle.getMessage("ActionTypeHint"));
        this._gridPanel.add((Component)row5Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add(this._actionTypeBox, c);
        if (itemType == Conditional.ItemType.NONE) {
            return;
        }
        if (finalRow) {
            this.makeChangeTriggerActionGrid(c);
        }
    }

    void makeStandardActionGrid(GridBagConstraints c, boolean finalRow) {
        this.makeNameTypeActionGrid(c, false);
        c.gridy = 3;
        c.gridx = 0;
        c.anchor = 13;
        this._gridPanel.add((Component)this._actionBoxLabel, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add(this._actionBox, c);
        if (finalRow) {
            this.makeChangeTriggerActionGrid(c);
        }
    }

    void makeShortFieldActionGrid(GridBagConstraints c, boolean includeBox) {
        if (includeBox) {
            this.makeStandardActionGrid(c, false);
        } else {
            this.makeNameTypeActionGrid(c, false);
        }
        c.gridy = 4;
        c.gridx = 0;
        c.anchor = 13;
        this._gridPanel.add((Component)this._shortActionLabel, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add((Component)this._shortActionString, c);
        this.makeChangeTriggerActionGrid(c);
    }

    void makeTypeShortActionGrid(GridBagConstraints c) {
        this.makeTypeActionGrid(c, false);
        c.gridy = 2;
        c.gridx = 0;
        c.anchor = 13;
        this._gridPanel.add((Component)this._shortActionLabel, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add((Component)this._shortActionString, c);
        this.makeChangeTriggerActionGrid(c);
    }

    void makeFileActionGrid(GridBagConstraints c) {
        this.makeTypeActionGrid(c, false);
        c.gridy = 2;
        c.gridx = 0;
        c.anchor = 13;
        this._gridPanel.add((Component)this._shortActionLabel, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add((Component)this._actionSetButton, c);
        c.gridwidth = 2;
        c.gridy = 3;
        c.gridx = 0;
        c.anchor = 10;
        this._gridPanel.add((Component)this._longActionString, c);
        c.gridwidth = 1;
        this.makeChangeTriggerActionGrid(c);
    }

    void makeChangeTriggerActionGrid(GridBagConstraints c) {
        c.gridy = 9;
        c.gridx = 0;
        c.anchor = 13;
        JLabel row0Label = new JLabel(Bundle.getMessage("LabelActionOption"));
        row0Label.setToolTipText(Bundle.getMessage("ActionOptionHint"));
        this._gridPanel.add((Component)row0Label, c);
        c.gridx = 1;
        c.anchor = 17;
        this._gridPanel.add(this._actionOptionBox, c);
    }

    void initializeActionVariables() {
        Conditional.Action actionType = this._curAction.getType();
        Conditional.ItemType itemType = actionType.getItemType();
        log.debug("initializeActionVariables: itemType= {}, actionType= {}", (Object)itemType, (Object)actionType);
        this._actionItemBox.setSelectedItem((Object)itemType);
        this._actionNameField.setText(this._curAction.getDeviceName());
        block0 : switch (itemType) {
            case NONE: {
                this._actionNameField.setText("");
                break;
            }
            case SENSOR: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                if (actionType == Conditional.Action.RESET_DELAYED_SENSOR || actionType == Conditional.Action.DELAYED_SENSOR) {
                    this._shortActionString.setText(this._curAction.getActionString());
                }
                if (actionType != Conditional.Action.SET_SENSOR && actionType != Conditional.Action.DELAYED_SENSOR && actionType != Conditional.Action.RESET_DELAYED_SENSOR) break;
                if (this._curAction.getActionData() == 2) {
                    this._actionBox.setSelectedIndex(0);
                    break;
                }
                if (this._curAction.getActionData() == 4) {
                    this._actionBox.setSelectedIndex(1);
                    break;
                }
                if (this._curAction.getActionData() != 8) break;
                this._actionBox.setSelectedIndex(2);
                break;
            }
            case TURNOUT: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                if (actionType == Conditional.Action.RESET_DELAYED_TURNOUT || actionType == Conditional.Action.DELAYED_TURNOUT) {
                    this._shortActionString.setText(this._curAction.getActionString());
                }
                if (actionType == Conditional.Action.SET_TURNOUT || actionType == Conditional.Action.RESET_DELAYED_TURNOUT || actionType == Conditional.Action.DELAYED_TURNOUT) {
                    if (this._curAction.getActionData() == 2) {
                        this._actionBox.setSelectedIndex(0);
                        break;
                    }
                    if (this._curAction.getActionData() == 4) {
                        this._actionBox.setSelectedIndex(1);
                        break;
                    }
                    if (this._curAction.getActionData() != 8) break;
                    this._actionBox.setSelectedIndex(2);
                    break;
                }
                if (actionType != Conditional.Action.LOCK_TURNOUT) break;
                if (this._curAction.getActionData() == 0) {
                    this._actionBox.setSelectedIndex(0);
                    break;
                }
                if (this._curAction.getActionData() == 1) {
                    this._actionBox.setSelectedIndex(1);
                    break;
                }
                if (this._curAction.getActionData() != 8) break;
                this._actionBox.setSelectedIndex(2);
                break;
            }
            case LIGHT: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                if (actionType == Conditional.Action.SET_LIGHT) {
                    if (this._curAction.getActionData() == 2) {
                        this._actionBox.setSelectedIndex(0);
                        break;
                    }
                    if (this._curAction.getActionData() == 4) {
                        this._actionBox.setSelectedIndex(1);
                        break;
                    }
                    if (this._curAction.getActionData() != 8) break;
                    this._actionBox.setSelectedIndex(2);
                    break;
                }
                if (actionType != Conditional.Action.SET_LIGHT_INTENSITY && actionType != Conditional.Action.SET_LIGHT_TRANSITION_TIME) break;
                this._shortActionString.setText(this._curAction.getActionString());
                break;
            }
            case SIGNALHEAD: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                if (actionType != Conditional.Action.SET_SIGNAL_APPEARANCE) break;
                this.loadJComboBoxWithHeadAppearances(this._actionBox, this._actionNameField.getText().trim());
                break;
            }
            case CLOCK: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                if (actionType != Conditional.Action.SET_FAST_CLOCK_TIME) break;
                int time = this._curAction.getActionData();
                this._longActionString.setText(ConditionalTreeEdit.formatTime(time / 60, time - time / 60 * 60));
                this._actionNameField.setText("");
                break;
            }
            case MEMORY: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                this._shortActionString.setText(this._curAction.getActionString());
                break;
            }
            case WARRANT: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                if (actionType == Conditional.Action.CONTROL_TRAIN) {
                    if (this._curAction.getActionData() == 1) {
                        this._actionBox.setSelectedIndex(0);
                        break;
                    }
                    if (this._curAction.getActionData() == 2) {
                        this._actionBox.setSelectedIndex(1);
                        break;
                    }
                    if (this._curAction.getActionData() != 3) break;
                    this._actionBox.setSelectedIndex(2);
                    break;
                }
                if (actionType != Conditional.Action.SET_TRAIN_ID && actionType != Conditional.Action.SET_TRAIN_NAME && actionType != Conditional.Action.THROTTLE_FACTOR) break;
                this._shortActionString.setText(this._curAction.getActionString());
                break;
            }
            case OBLOCK: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                if (actionType != Conditional.Action.SET_BLOCK_VALUE) break;
                this._shortActionString.setText(this._curAction.getActionString());
                break;
            }
            case ENTRYEXIT: {
                this._actionNameField.setText(this._curAction.getBean().getUserName());
                this._actionTypeBox.setSelectedItem((Object)actionType);
                break;
            }
            case AUDIO: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                if (actionType == Conditional.Action.PLAY_SOUND) {
                    this._longActionString.setText(this._curAction.getActionString());
                    break;
                }
                if (actionType != Conditional.Action.CONTROL_AUDIO) break;
                switch (this._curAction.getActionData()) {
                    case 64: {
                        this._actionBox.setSelectedIndex(0);
                        break block0;
                    }
                    case 65: {
                        this._actionBox.setSelectedIndex(1);
                        break block0;
                    }
                    case 66: {
                        this._actionBox.setSelectedIndex(2);
                        break block0;
                    }
                    case 67: {
                        this._actionBox.setSelectedIndex(3);
                        break block0;
                    }
                    case 68: {
                        this._actionBox.setSelectedIndex(4);
                        break block0;
                    }
                    case 69: {
                        this._actionBox.setSelectedIndex(5);
                        break block0;
                    }
                    case 70: {
                        this._actionBox.setSelectedIndex(6);
                        break block0;
                    }
                    case 71: {
                        this._actionBox.setSelectedIndex(7);
                        break block0;
                    }
                    case 72: {
                        this._actionBox.setSelectedIndex(8);
                        break block0;
                    }
                    case 73: {
                        this._actionBox.setSelectedIndex(9);
                        break block0;
                    }
                }
                log.warn("Unexpected _curAction.getActionData() of {}", (Object)this._curAction.getActionData());
                break;
            }
            case SCRIPT: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                if (actionType == Conditional.Action.RUN_SCRIPT) {
                    this._longActionString.setText(this._curAction.getActionString());
                    break;
                }
                if (actionType != Conditional.Action.JYTHON_COMMAND) break;
                this._shortActionString.setText(this._curAction.getActionString());
                break;
            }
            case SIGNALMAST: 
            case LOGIX: 
            case OTHER: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                break;
            }
            default: {
                log.error("Unhandled type: {}", (Object)itemType);
            }
        }
        this._actionOptionBox.setSelectedIndex(this._curAction.getOption() - 1);
    }

    void actionItemChanged(Conditional.ItemType type) {
        Conditional.Action actionType = this._curAction.getType();
        log.debug("actionItemChanged: itemType= {}, actionType= {}", (Object)type, (Object)actionType);
        this._detailGrid.setVisible(false);
        this._actionTypeBox.removeActionListener(this._actionTypeListener);
        this._shortActionString.setText("");
        this._longActionString.setText("");
        this._actionTypeBox.removeAllItems();
        this._actionTypeBox.addItem(Conditional.Action.NONE);
        this._actionBox.removeAllItems();
        Conditional.ItemType itemType = actionType.getItemType();
        if (type != Conditional.ItemType.NONE) {
            itemType = type;
        }
        if (itemType != actionType.getItemType()) {
            actionType = Conditional.Action.NONE;
        }
        this._actionNameField.removeActionListener(this.actionSignalHeadNameListener);
        this._actionNameField.removeActionListener(this.actionSignalMastNameListener);
        if (this._comboNameBox != null) {
            ActionListener[] actionListenerArray = this._comboNameBox.getActionListeners();
            int n = actionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionListener item = actionListenerArray[n2];
                this._comboNameBox.removeActionListener(item);
                ++n2;
            }
            this._comboNameBox.removeFocusListener(this.detailFocusEvent);
        }
        this.setPickWindow("Action", itemType);
        switch (itemType) {
            case NONE: {
                this.makeDetailGrid("EmptyAction");
                break;
            }
            case TURNOUT: {
                this._actionNameLabel.setToolTipText(Bundle.getMessage("NameHintTurnout"));
                String turnoutGrid = "NameTypeAction";
                boolean delayTurnout = false;
                for (Conditional.Action action : Conditional.Action.getTurnoutItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.RESET_DELAYED_TURNOUT || actionType == Conditional.Action.DELAYED_TURNOUT) {
                    delayTurnout = true;
                    this._shortActionLabel.setText(Bundle.getMessage("LabelDelayTime"));
                    this._shortActionLabel.setToolTipText(Bundle.getMessage("DataHintDelayedTurnout"));
                }
                if (actionType == Conditional.Action.SET_TURNOUT || actionType == Conditional.Action.RESET_DELAYED_TURNOUT || actionType == Conditional.Action.DELAYED_TURNOUT) {
                    turnoutGrid = delayTurnout ? "ShortFieldAction" : "StandardAction";
                    this._actionBoxLabel.setText(Bundle.getMessage("LabelActionTurnout"));
                    this._actionBoxLabel.setToolTipText(Bundle.getMessage("TurnoutSetHint"));
                    this._actionBox.addItem(Bundle.getMessage("TurnoutStateClosed"));
                    this._actionBox.addItem(Bundle.getMessage("TurnoutStateThrown"));
                    this._actionBox.addItem(Bundle.getMessage("Toggle"));
                } else if (actionType == Conditional.Action.LOCK_TURNOUT) {
                    turnoutGrid = delayTurnout ? "ShortFieldAction" : "StandardAction";
                    this._actionBoxLabel.setText(Bundle.getMessage("LabelActionLock"));
                    this._actionBoxLabel.setToolTipText(Bundle.getMessage("LockSetHint"));
                    this._actionBox.addItem(Bundle.getMessage("TurnoutUnlock"));
                    this._actionBox.addItem(Bundle.getMessage("TurnoutLock"));
                    this._actionBox.addItem(Bundle.getMessage("Toggle"));
                } else if (actionType == Conditional.Action.CANCEL_TURNOUT_TIMERS || actionType == Conditional.Action.NONE) {
                    turnoutGrid = "NameTypeActionFinal";
                }
                this.setActionNameBox(itemType);
                this.makeDetailGrid(turnoutGrid);
                break;
            }
            case SENSOR: {
                this._actionNameLabel.setToolTipText(Bundle.getMessage("NameHintSensor"));
                String sensorGrid = "NameTypeAction";
                boolean delaySensor = false;
                for (Conditional.Action action : Conditional.Action.getSensorItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.RESET_DELAYED_SENSOR || actionType == Conditional.Action.DELAYED_SENSOR) {
                    delaySensor = true;
                    this._shortActionLabel.setText(Bundle.getMessage("LabelDelayTime"));
                    this._shortActionLabel.setToolTipText(Bundle.getMessage("DataHintDelayedSensor"));
                }
                if (actionType == Conditional.Action.SET_SENSOR || actionType == Conditional.Action.RESET_DELAYED_SENSOR || actionType == Conditional.Action.DELAYED_SENSOR) {
                    sensorGrid = delaySensor ? "ShortFieldAction" : "StandardAction";
                    this._actionBoxLabel.setText(Bundle.getMessage("LabelActionSensor"));
                    this._actionBoxLabel.setToolTipText(Bundle.getMessage("SensorSetHint"));
                    this._actionBox.addItem(Bundle.getMessage("SensorStateActive"));
                    this._actionBox.addItem(Bundle.getMessage("SensorStateInactive"));
                    this._actionBox.addItem(Bundle.getMessage("Toggle"));
                } else if (actionType == Conditional.Action.CANCEL_SENSOR_TIMERS || actionType == Conditional.Action.NONE) {
                    sensorGrid = "NameTypeActionFinal";
                }
                this.setActionNameBox(itemType);
                this.makeDetailGrid(sensorGrid);
                break;
            }
            case SIGNALHEAD: {
                this._actionNameLabel.setToolTipText(Bundle.getMessage("NameHintSignal"));
                String signalHeadGrid = "NameTypeAction";
                this._actionNameField.addActionListener(this.actionSignalHeadNameListener);
                for (Conditional.Action action : Conditional.Action.getSignalHeadItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.SET_SIGNAL_APPEARANCE) {
                    signalHeadGrid = "StandardAction";
                    this._actionBoxLabel.setText(Bundle.getMessage("LabelActionSignal"));
                    this._actionBoxLabel.setToolTipText(Bundle.getMessage("SignalSetHint"));
                    this.loadJComboBoxWithHeadAppearances(this._actionBox, this._actionNameField.getText().trim());
                    this._actionBox.setSelectedItem(this._curAction.getActionDataString());
                } else if (actionType != Conditional.Action.NONE) {
                    signalHeadGrid = "NameTypeActionFinal";
                }
                this.setActionNameBox(itemType);
                this.makeDetailGrid(signalHeadGrid);
                break;
            }
            case SIGNALMAST: {
                this._actionNameLabel.setToolTipText(Bundle.getMessage("NameHintSignalMast"));
                String signalMastGrid = "NameTypeAction";
                this._actionNameField.addActionListener(this.actionSignalMastNameListener);
                for (Conditional.Action action : Conditional.Action.getSignalMastItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.SET_SIGNALMAST_ASPECT) {
                    signalMastGrid = "StandardAction";
                    this._actionBoxLabel.setText(Bundle.getMessage("LabelSignalAspect"));
                    this._actionBoxLabel.setToolTipText(Bundle.getMessage("SignalMastSetHint"));
                    this.loadJComboBoxWithMastAspects(this._actionBox, this._actionNameField.getText().trim());
                    this._actionBox.setSelectedItem(this._curAction.getActionDataString());
                } else if (actionType != Conditional.Action.NONE) {
                    signalMastGrid = "NameTypeActionFinal";
                }
                this.setActionNameBox(itemType);
                this.makeDetailGrid(signalMastGrid);
                break;
            }
            case LIGHT: {
                this._actionNameLabel.setToolTipText(Bundle.getMessage("NameHintLight"));
                String lightGrid = "NameTypeAction";
                for (Conditional.Action action : Conditional.Action.getLightItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.SET_LIGHT_INTENSITY) {
                    lightGrid = "ShortFieldNoBoxAction";
                    this._shortActionLabel.setText(Bundle.getMessage("LabelLightIntensity"));
                    this._shortActionLabel.setToolTipText(Bundle.getMessage("DataHintLightIntensity"));
                } else if (actionType == Conditional.Action.SET_LIGHT_TRANSITION_TIME) {
                    lightGrid = "ShortFieldNoBoxAction";
                    this._shortActionLabel.setText(Bundle.getMessage("LabelTransitionTime"));
                    this._shortActionLabel.setToolTipText(Bundle.getMessage("DataHintLightTransitionTime"));
                } else if (actionType == Conditional.Action.SET_LIGHT) {
                    lightGrid = "StandardAction";
                    this._actionBoxLabel.setText(Bundle.getMessage("LabelActionLight"));
                    this._actionBoxLabel.setToolTipText(Bundle.getMessage("LightSetHint"));
                    this._actionBox.addItem(Bundle.getMessage("LightOn"));
                    this._actionBox.addItem(Bundle.getMessage("LightOff"));
                    this._actionBox.addItem(Bundle.getMessage("Toggle"));
                }
                this.setActionNameBox(itemType);
                this.makeDetailGrid(lightGrid);
                break;
            }
            case MEMORY: {
                this._actionNameLabel.setToolTipText(Bundle.getMessage("NameHintMemory"));
                String memoryGrid = "NameTypeAction";
                for (Conditional.Action action : Conditional.Action.getMemoryItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.COPY_MEMORY) {
                    memoryGrid = "ShortFieldNoBoxAction";
                    this._shortActionLabel.setText(Bundle.getMessage("LabelMemoryLocation"));
                    this._shortActionLabel.setToolTipText(Bundle.getMessage("DataHintToMemory"));
                } else if (actionType == Conditional.Action.SET_MEMORY) {
                    memoryGrid = "ShortFieldNoBoxAction";
                    this._shortActionLabel.setText(Bundle.getMessage("LabelValue"));
                    this._shortActionLabel.setToolTipText(Bundle.getMessage("DataHintMemory"));
                }
                this.setActionNameBox(itemType);
                this.makeDetailGrid(memoryGrid);
                break;
            }
            case CLOCK: {
                String clockGrid = "TypeAction";
                for (Conditional.Action action : Conditional.Action.getClockItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.SET_FAST_CLOCK_TIME) {
                    clockGrid = "TypeShortAction";
                    this._shortActionLabel.setText(Bundle.getMessage("LabelSetTime"));
                    this._shortActionLabel.setToolTipText(Bundle.getMessage("DataHintTime"));
                } else if (actionType == Conditional.Action.START_FAST_CLOCK || actionType == Conditional.Action.STOP_FAST_CLOCK) {
                    clockGrid = "TypeActionFinal";
                }
                this.makeDetailGrid(clockGrid);
                break;
            }
            case LOGIX: {
                this._actionNameLabel.setToolTipText(Bundle.getMessage("NameHintLogix"));
                String logixGrid = "NameTypeAction";
                for (Conditional.Action action : Conditional.Action.getLogixItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.ENABLE_LOGIX || actionType == Conditional.Action.DISABLE_LOGIX) {
                    logixGrid = "NameTypeActionFinal";
                }
                this.setActionNameBox(itemType);
                this.makeDetailGrid(logixGrid);
                break;
            }
            case WARRANT: {
                this._actionNameLabel.setToolTipText(Bundle.getMessage("NameHintWarrant"));
                String warrantGrid = "NameTypeAction";
                for (Conditional.Action action : Conditional.Action.getWarrantItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.CONTROL_TRAIN) {
                    warrantGrid = "StandardAction";
                    this._actionBoxLabel.setText(Bundle.getMessage("LabelControlTrain"));
                    this._actionBoxLabel.setToolTipText(Bundle.getMessage("DataHintTrainControl"));
                    this._actionBox.addItem(Bundle.getMessage("WarrantHalt"));
                    this._actionBox.addItem(Bundle.getMessage("WarrantResume"));
                    this._actionBox.addItem(Bundle.getMessage("WarrantAbort"));
                } else if (actionType == Conditional.Action.SET_TRAIN_ID || actionType == Conditional.Action.SET_TRAIN_NAME || actionType == Conditional.Action.THROTTLE_FACTOR) {
                    warrantGrid = "ShortFieldNoBoxAction";
                    if (actionType == Conditional.Action.SET_TRAIN_ID) {
                        this._shortActionLabel.setText(Bundle.getMessage("LabelTrainId"));
                        this._shortActionLabel.setToolTipText(Bundle.getMessage("DataHintTrainId"));
                    } else if (actionType == Conditional.Action.SET_TRAIN_NAME) {
                        this._shortActionLabel.setText(Bundle.getMessage("LabelTrainName"));
                        this._shortActionLabel.setToolTipText(Bundle.getMessage("DataHintTrainName"));
                    } else {
                        this._shortActionLabel.setText(Bundle.getMessage("LabelThrottleFactor"));
                        this._shortActionLabel.setToolTipText(Bundle.getMessage("DataHintThrottleFactor"));
                    }
                }
                this.setActionNameBox(itemType);
                this.makeDetailGrid(warrantGrid);
                break;
            }
            case OBLOCK: {
                this._actionNameLabel.setToolTipText(Bundle.getMessage("NameHintOBlock"));
                String oblockGrid = "NameTypeAction";
                for (Conditional.Action action : Conditional.Action.getOBlockItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.SET_BLOCK_VALUE) {
                    oblockGrid = "ShortFieldNoBoxAction";
                    this._shortActionLabel.setText(Bundle.getMessage("LabelBlockValue"));
                    this._shortActionLabel.setToolTipText(Bundle.getMessage("DataHintBlockValue"));
                } else if (actionType == Conditional.Action.DEALLOCATE_BLOCK || actionType == Conditional.Action.SET_BLOCK_ERROR || actionType == Conditional.Action.CLEAR_BLOCK_ERROR || actionType == Conditional.Action.SET_BLOCK_OUT_OF_SERVICE || actionType == Conditional.Action.SET_BLOCK_IN_SERVICE) {
                    oblockGrid = "NameTypeActionFinal";
                }
                this.setActionNameBox(itemType);
                this.makeDetailGrid(oblockGrid);
                break;
            }
            case ENTRYEXIT: {
                for (Conditional.Action action : Conditional.Action.getEntryExitItems()) {
                    this._actionTypeBox.addItem(action);
                }
                this.setActionNameBox(itemType);
                this.makeDetailGrid("NameTypeActionFinal");
                break;
            }
            case AUDIO: {
                this._actionNameLabel.setToolTipText(Bundle.getMessage("NameHintOBlock"));
                String audioGrid = "TypeAction";
                for (Conditional.Action action : Conditional.Action.getAudioItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.PLAY_SOUND) {
                    audioGrid = "FileAction";
                    this._shortActionLabel.setText(Bundle.getMessage("LabelSelectFile"));
                    this._actionSetButton.setToolTipText(Bundle.getMessage("SetHintSound"));
                } else if (actionType == Conditional.Action.CONTROL_AUDIO) {
                    audioGrid = "StandardAction";
                    this._actionNameLabel.setToolTipText(Bundle.getMessage("NameHintAudio"));
                    this._actionBoxLabel.setText(Bundle.getMessage("LabelActionAudio"));
                    this._actionBoxLabel.setToolTipText(Bundle.getMessage("SetHintAudio"));
                    this._actionBox.addItem(Bundle.getMessage("AudioSourcePlay"));
                    this._actionBox.addItem(Bundle.getMessage("AudioSourceStop"));
                    this._actionBox.addItem(Bundle.getMessage("AudioSourcePlayToggle"));
                    this._actionBox.addItem(Bundle.getMessage("AudioSourcePause"));
                    this._actionBox.addItem(Bundle.getMessage("AudioSourceResume"));
                    this._actionBox.addItem(Bundle.getMessage("AudioSourcePauseToggle"));
                    this._actionBox.addItem(Bundle.getMessage("AudioSourceRewind"));
                    this._actionBox.addItem(Bundle.getMessage("AudioSourceFadeIn"));
                    this._actionBox.addItem(Bundle.getMessage("AudioSourceFadeOut"));
                    this._actionBox.addItem(Bundle.getMessage("AudioResetPosition"));
                }
                this.makeDetailGrid(audioGrid);
                break;
            }
            case SCRIPT: {
                String scriptGrid = "TypeAction";
                for (Conditional.Action action : Conditional.Action.getScriptItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.RUN_SCRIPT) {
                    scriptGrid = "FileAction";
                    this._shortActionLabel.setText(Bundle.getMessage("LabelSelectFile"));
                    this._actionSetButton.setToolTipText(Bundle.getMessage("SetHintScript"));
                } else if (actionType == Conditional.Action.JYTHON_COMMAND) {
                    scriptGrid = "TypeShortAction";
                    this._shortActionLabel.setText(Bundle.getMessage("LabelScriptCommand"));
                    this._shortActionLabel.setToolTipText(Bundle.getMessage("SetHintJythonCmd"));
                }
                this.makeDetailGrid(scriptGrid);
                break;
            }
            case OTHER: {
                String otherGrid = "TypeAction";
                for (Conditional.Action action : Conditional.Action.getOtherItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.TRIGGER_ROUTE) {
                    otherGrid = "NameTypeActionFinal";
                    this._actionNameLabel.setToolTipText(Bundle.getMessage("NameHintRoute"));
                }
                this.setActionNameBox(itemType);
                this.makeDetailGrid(otherGrid);
                break;
            }
        }
        this._actionTypeListener.setItemType(itemType);
        this._actionTypeBox.addActionListener(this._actionTypeListener);
    }

    void setActionNameBox(Conditional.ItemType itemType) {
        if (this._selectionMode != ConditionalEditBase.SelectionMode.USECOMBO) {
            return;
        }
        this._comboNameBox = this.createNameBox(itemType);
        if (this._comboNameBox == null) {
            return;
        }
        this._comboNameBox.setSelectedItemByName(this._curAction.getDeviceName());
        this._comboNameBox.addActionListener(new ConditionalEditBase.NameBoxListener(this._actionNameField));
        this._comboNameBox.addFocusListener(this.detailFocusEvent);
    }

    void cancelEditAction() {
        if (this._newActionItem) {
            this._newActionItem = false;
            this.deletePressed();
        }
        this.cleanUpAction();
    }

    void updateAction() {
        if (!this.validateAction()) {
            return;
        }
        this._newActionItem = false;
        this.updateActionList();
        this._curNode.setText(this._curAction.description(this._triggerMode));
        this._cdlModel.nodeChanged(this._curNode);
        this.cleanUpAction();
    }

    void cleanUpAction() {
        this.setMoveButtons();
    }

    void setFileLocation(ActionEvent e) {
        JFileChooser currentChooser;
        ConditionalAction action = this._actionList.get(this._curNodeRow);
        Conditional.Action actionType = action.getType();
        if (actionType == Conditional.Action.PLAY_SOUND) {
            if (this.sndFileChooser == null) {
                this.sndFileChooser = new JFileChooser(String.valueOf(System.getProperty("user.dir")) + File.separator + "resources" + File.separator + "sounds");
                this.sndFileChooser.setFileFilter(new FileNameExtensionFilter("wav sound files", "wav"));
            }
            currentChooser = this.sndFileChooser;
        } else if (actionType == Conditional.Action.RUN_SCRIPT) {
            if (this.scriptFileChooser == null) {
                this.scriptFileChooser = new JFileChooser(FileUtil.getScriptsPath());
                this.scriptFileChooser.setFileFilter(new FileNameExtensionFilter("Python script file", "py"));
            }
            currentChooser = this.scriptFileChooser;
        } else {
            log.warn("Unexpected actionType[{}] = {}", (Object)actionType.name(), (Object)actionType);
            if (this.defaultFileChooser == null) {
                this.defaultFileChooser = new JFileChooser(FileUtil.getUserFilesPath());
                this.defaultFileChooser.setFileFilter(new NoArchiveFileFilter());
            }
            currentChooser = this.defaultFileChooser;
        }
        currentChooser.rescanCurrentDirectory();
        int retVal = currentChooser.showOpenDialog(null);
        if (retVal == 0) {
            try {
                this._longActionString.setText(FileUtil.getPortableFilename(currentChooser.getSelectedFile().getCanonicalPath()));
            }
            catch (IOException ex) {
                if (log.isDebugEnabled()) {
                    log.error("exception setting file location: ", (Throwable)ex);
                }
                this._longActionString.setText("");
            }
        }
    }

    boolean validateAction() {
        Conditional.ItemType itemType = this._actionItemBox.getItemAt(this._actionItemBox.getSelectedIndex());
        Conditional.Action actionType = Conditional.Action.NONE;
        Conditional.Action selection = this._actionTypeBox.getItemAt(this._actionTypeBox.getSelectedIndex());
        if (selection == Conditional.Action.NONE) {
            JOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("makeSelection"), Bundle.getMessage("WarningTitle"), 2);
            return false;
        }
        String name = this._actionNameField.getText().trim();
        String actionString = this._shortActionString.getText().trim();
        this._curAction.setActionString("");
        this._curAction.setActionData(-1);
        boolean referenceByMemory = false;
        if (name.length() > 0 && name.charAt(0) == '@') {
            String memName = name.substring(1);
            if (!this.confirmIndirectMemory(memName)) {
                return false;
            }
            if ((memName = this.validateMemoryReference(memName)) == null) {
                return false;
            }
            referenceByMemory = true;
        }
        if (!this.checkIsVariable(name, itemType)) {
            return false;
        }
        block0 : switch (itemType) {
            case SENSOR: {
                if (!referenceByMemory && (name = this.validateSensorReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                if (actionType == Conditional.Action.RESET_DELAYED_SENSOR || actionType == Conditional.Action.DELAYED_SENSOR) {
                    if (!this.validateTimeReference(actionType, actionString)) {
                        return false;
                    }
                    this._curAction.setActionString(actionString);
                }
                if (actionType == Conditional.Action.SET_SENSOR || actionType == Conditional.Action.RESET_DELAYED_SENSOR || actionType == Conditional.Action.DELAYED_SENSOR) {
                    if (this._actionBox.getSelectedIndex() == 0) {
                        this._curAction.setActionData(2);
                    } else if (this._actionBox.getSelectedIndex() == 1) {
                        this._curAction.setActionData(4);
                    } else {
                        this._curAction.setActionData(8);
                    }
                }
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                break;
            }
            case TURNOUT: {
                if (!referenceByMemory && (name = this.validateTurnoutReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                if (actionType == Conditional.Action.RESET_DELAYED_TURNOUT || actionType == Conditional.Action.DELAYED_TURNOUT) {
                    if (!this.validateTimeReference(actionType, actionString)) {
                        return false;
                    }
                    this._curAction.setActionString(actionString);
                }
                if (actionType == Conditional.Action.SET_TURNOUT || actionType == Conditional.Action.RESET_DELAYED_TURNOUT || actionType == Conditional.Action.DELAYED_TURNOUT) {
                    if (this._actionBox.getSelectedIndex() == 0) {
                        this._curAction.setActionData(2);
                    } else if (this._actionBox.getSelectedIndex() == 1) {
                        this._curAction.setActionData(4);
                    } else {
                        this._curAction.setActionData(8);
                    }
                } else if (actionType == Conditional.Action.LOCK_TURNOUT) {
                    if (this._actionBox.getSelectedIndex() == 0) {
                        this._curAction.setActionData(0);
                    } else if (this._actionBox.getSelectedIndex() == 1) {
                        this._curAction.setActionData(1);
                    } else {
                        this._curAction.setActionData(8);
                    }
                }
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                break;
            }
            case LIGHT: {
                Light lgtx;
                if (!referenceByMemory && (name = this.validateLightReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                if (actionType == Conditional.Action.SET_LIGHT_INTENSITY) {
                    lgtx = this.getLight(name);
                    if (lgtx == null) {
                        return false;
                    }
                    if (!(lgtx instanceof VariableLight)) {
                        JOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Error45", name), Bundle.getMessage("ErrorTitle"), 0);
                        return false;
                    }
                    if (!this.validateIntensityReference(actionType, actionString)) {
                        return false;
                    }
                    this._curAction.setActionString(actionString);
                } else if (actionType == Conditional.Action.SET_LIGHT_TRANSITION_TIME) {
                    lgtx = this.getLight(name);
                    if (lgtx == null) {
                        return false;
                    }
                    if (!(lgtx instanceof VariableLight) || !((VariableLight)lgtx).isTransitionAvailable()) {
                        JOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Error40", name), Bundle.getMessage("ErrorTitle"), 0);
                        return false;
                    }
                    if (!this.validateTimeReference(actionType, actionString)) {
                        return false;
                    }
                    this._curAction.setActionString(actionString);
                } else if (actionType == Conditional.Action.SET_LIGHT) {
                    if (this._actionBox.getSelectedIndex() == 0) {
                        this._curAction.setActionData(2);
                    } else if (this._actionBox.getSelectedIndex() == 1) {
                        this._curAction.setActionData(4);
                    } else {
                        this._curAction.setActionData(8);
                    }
                }
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                break;
            }
            case SIGNALHEAD: {
                if (!referenceByMemory && (name = this.validateSignalHeadReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                if (actionType == Conditional.Action.SET_SIGNAL_APPEARANCE) {
                    String appStr = (String)this._actionBox.getSelectedItem();
                    this._curAction.setActionData(DefaultConditionalAction.stringToActionData(appStr));
                    this._curAction.setActionString(appStr);
                }
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                break;
            }
            case SIGNALMAST: {
                if (!referenceByMemory && (name = this.validateSignalMastReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                if (actionType == Conditional.Action.SET_SIGNALMAST_ASPECT) {
                    this._curAction.setActionString((String)this._actionBox.getSelectedItem());
                }
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                break;
            }
            case MEMORY: {
                if (referenceByMemory) {
                    JOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Warn6"), Bundle.getMessage("WarningTitle"), 2);
                    return false;
                }
                if ((name = this.validateMemoryReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                if (actionType == Conditional.Action.COPY_MEMORY && (actionString = this.validateMemoryReference(actionString)) == null) {
                    return false;
                }
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                this._curAction.setActionString(actionString);
                break;
            }
            case LOGIX: {
                if (!referenceByMemory && (name = this.validateLogixReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                break;
            }
            case WARRANT: {
                if (!referenceByMemory && (name = this.validateWarrantReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                if (actionType == Conditional.Action.CONTROL_TRAIN) {
                    if (this._actionBox.getSelectedIndex() == 0) {
                        this._curAction.setActionData(1);
                        break;
                    }
                    if (this._actionBox.getSelectedIndex() == 1) {
                        this._curAction.setActionData(2);
                        break;
                    }
                    this._curAction.setActionData(3);
                    break;
                }
                if (actionType != Conditional.Action.SET_TRAIN_ID && actionType != Conditional.Action.SET_TRAIN_NAME && actionType != Conditional.Action.THROTTLE_FACTOR) break;
                this._curAction.setActionString(actionString);
                break;
            }
            case OBLOCK: {
                if (!referenceByMemory && (name = this.validateOBlockReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                if (actionType != Conditional.Action.SET_BLOCK_VALUE) break;
                this._curAction.setActionString(actionString);
                break;
            }
            case ENTRYEXIT: {
                if (!referenceByMemory && (name = this.validateEntryExitReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                break;
            }
            case CLOCK: {
                actionType = selection;
                if (actionType != Conditional.Action.SET_FAST_CLOCK_TIME) break;
                int time = this.parseTime(this._shortActionString.getText().trim());
                if (time < 0) {
                    return false;
                }
                this._curAction.setActionData(time);
                break;
            }
            case AUDIO: {
                actionType = selection;
                if (actionType == Conditional.Action.PLAY_SOUND) {
                    this._curAction.setActionString(this._longActionString.getText().trim());
                    break;
                }
                if (actionType != Conditional.Action.CONTROL_AUDIO) break;
                if (!referenceByMemory && (name = this.validateAudioReference(name)) == null) {
                    return false;
                }
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                switch (this._actionBox.getSelectedIndex()) {
                    case 0: {
                        this._curAction.setActionData(64);
                        break block0;
                    }
                    case 1: {
                        this._curAction.setActionData(65);
                        break block0;
                    }
                    case 2: {
                        this._curAction.setActionData(66);
                        break block0;
                    }
                    case 3: {
                        this._curAction.setActionData(67);
                        break block0;
                    }
                    case 4: {
                        this._curAction.setActionData(68);
                        break block0;
                    }
                    case 5: {
                        this._curAction.setActionData(69);
                        break block0;
                    }
                    case 6: {
                        this._curAction.setActionData(70);
                        break block0;
                    }
                    case 7: {
                        this._curAction.setActionData(71);
                        break block0;
                    }
                    case 8: {
                        this._curAction.setActionData(72);
                        break block0;
                    }
                    case 9: {
                        this._curAction.setActionData(73);
                        break block0;
                    }
                }
                log.warn("Unexpected _actionBox.getSelectedIndex() of {}", (Object)this._actionBox.getSelectedIndex());
                break;
            }
            case SCRIPT: {
                actionType = selection;
                if (actionType == Conditional.Action.RUN_SCRIPT) {
                    this._curAction.setActionString(this._longActionString.getText().trim());
                    break;
                }
                if (actionType != Conditional.Action.JYTHON_COMMAND) break;
                this._curAction.setActionString(this._shortActionString.getText().trim());
                break;
            }
            case OTHER: {
                actionType = selection;
                if (actionType != Conditional.Action.TRIGGER_ROUTE) break;
                if (!referenceByMemory && (name = this.validateRouteReference(name)) == null) {
                    return false;
                }
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                break;
            }
        }
        this._curAction.setType(actionType);
        if (actionType != Conditional.Action.NONE) {
            this._curAction.setOption(this._actionOptionBox.getSelectedIndex() + 1);
        } else {
            this._curAction.setOption(0);
        }
        return true;
    }

    void updateActionList() {
        this._curLogix.deActivateLogix();
        this._curConditional.setAction(this._actionList);
        this._actionList = this._curConditional.getCopyOfActions();
        this._curLogix.activateLogix();
    }

    boolean checkIsAction(String name, Conditional.ItemType itemType) {
        String actionName = null;
        for (ConditionalAction action : this._actionList) {
            Conditional.ItemType actionType = action.getType().getItemType();
            if (itemType == actionType) {
                if (name.equals(action.getDeviceName())) {
                    actionName = action.getDeviceName();
                } else {
                    NamedBean bean = action.getBean();
                    if (bean != null && (name.equals(bean.getSystemName()) || name.equals(bean.getUserName()))) {
                        actionName = action.getDeviceName();
                    }
                }
            }
            if (actionName == null) continue;
            return this.confirmActionAsVariable(actionName, name);
        }
        return true;
    }

    boolean checkIsVariable(String name, Conditional.ItemType itemType) {
        String varName = null;
        for (ConditionalVariable var : this._variableList) {
            Conditional.ItemType varType = var.getType().getItemType();
            if (itemType == varType) {
                if (name.equals(var.getName())) {
                    varName = var.getName();
                } else {
                    NamedBean bean = var.getBean();
                    if (bean != null && (name.equals(bean.getSystemName()) || name.equals(bean.getUserName()))) {
                        varName = var.getName();
                    }
                }
            }
            if (varName == null) continue;
            return this.confirmActionAsVariable(name, varName);
        }
        return true;
    }

    @Override
    protected String getClassName() {
        return ConditionalTreeEdit.class.getName();
    }

    class ActionTypeListener
    implements ActionListener {
        Conditional.ItemType _itemType;

        ActionTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Conditional.ItemType select1 = ConditionalTreeEdit.this._actionItemBox.getItemAt(ConditionalTreeEdit.this._actionItemBox.getSelectedIndex());
            Conditional.Action select2 = ConditionalTreeEdit.this._actionTypeBox.getItemAt(ConditionalTreeEdit.this._actionTypeBox.getSelectedIndex());
            if (log.isDebugEnabled()) {
                log.debug("ActionTypeListener: itemType = {}, local itemType = {}, actionType = {}", new Object[]{select1, this._itemType, select2});
            }
            if (select1 != this._itemType) {
                log.error("ActionTypeListener actionItem selection ({}) != expected actionItem ({})", (Object)select1, (Object)this._itemType);
            }
            if (ConditionalTreeEdit.this._curAction != null && select1 != Conditional.ItemType.NONE && this._itemType == select1) {
                String text;
                ConditionalTreeEdit.this._curAction.setType(select2);
                if (select1 == this._itemType && (text = ConditionalTreeEdit.this._actionNameField.getText()) != null && text.length() > 0) {
                    ConditionalTreeEdit.this._curAction.setDeviceName(text);
                }
                ConditionalTreeEdit.this.actionItemChanged(this._itemType);
                ConditionalTreeEdit.this.initializeActionVariables();
            }
        }

        public void setItemType(Conditional.ItemType type) {
            this._itemType = type;
        }
    }

    static class ConditionalTreeNode
    extends DefaultMutableTreeNode {
        private String cdlText;
        private String cdlType;
        private String cdlName;
        private int cdlRow;

        public ConditionalTreeNode(String nameText, String type, String sysName, int row) {
            this.cdlText = nameText;
            this.cdlType = type;
            this.cdlName = sysName;
            this.cdlRow = row;
        }

        public String getType() {
            return this.cdlType;
        }

        public String getName() {
            return this.cdlName;
        }

        public void setName(String newName) {
            this.cdlName = newName;
        }

        public int getRow() {
            return this.cdlRow;
        }

        public void setRow(int newRow) {
            this.cdlRow = newRow;
        }

        public String getText() {
            return this.cdlText;
        }

        public void setText(String newText) {
            this.cdlText = newText;
        }

        @Override
        public String toString() {
            return this.cdlText;
        }
    }
}

