/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.conditional;

import java.util.TreeSet;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.Conditional;
import jmri.Logix;
import jmri.jmrit.conditional.Bundle;
import jmri.jmrit.conditional.ConditionalEditBase;
import jmri.jmrit.conditional.ConditionalFrame;
import jmri.jmrit.conditional.ConditionalListEdit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConditionalList
extends ConditionalEditBase {
    Conditional _curConditional = null;
    ConditionalFrame _conditionalFrame = null;
    boolean _newConditional = false;
    TreeSet<String> _oldTargetNames = new TreeSet();
    private static final Logger log = LoggerFactory.getLogger(ConditionalList.class);

    public ConditionalList(String sName) {
        super(sName);
    }

    public ConditionalList() {
    }

    Conditional makeNewConditional(Logix logix) {
        log.debug("makeNewConditional(Logix)");
        int num = logix.getNumConditionals() + 1;
        Conditional conditional = null;
        String cName = null;
        while (conditional == null) {
            cName = String.valueOf(logix.getSystemName()) + "C" + Integer.toString(num);
            conditional = this._conditionalManager.createNewConditional(cName, "");
            if (++num == 1000) break;
        }
        this._newConditional = conditional != null;
        return conditional;
    }

    abstract JPanel makeBottomPanel();

    abstract void updateConditionalTableModel();

    abstract boolean updateConditional(String var1, Conditional.AntecedentOperator var2, boolean var3, String var4);

    boolean updateConditional(String uName, Logix logix, Conditional.AntecedentOperator logicType, boolean trigger, String antecedent) {
        log.debug("updateConditional");
        if (!uName.equals(this._curConditional.getUserName())) {
            if (!this.checkConditionalUserName(uName, logix)) {
                return false;
            }
            this._curConditional.setUserName(uName);
        }
        if (this._conditionalFrame._variableList.size() <= 0 && !this._suppressReminder) {
            JOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Warn5", this._curConditional.getUserName(), this._curConditional.getSystemName()), Bundle.getMessage("WarningTitle"), 2);
        }
        this._curConditional.setStateVariables(this._conditionalFrame._variableList);
        this._curConditional.setAction(this._conditionalFrame._actionList);
        this._curConditional.setTriggerOnChange(trigger);
        this._curConditional.setLogicType(logicType, antecedent);
        if (this._newConditional) {
            logix.addConditional(this._curConditional.getSystemName(), -1);
            this._showReminder = true;
            this._newConditional = false;
            this.updateConditionalTableModel();
        }
        TreeSet<String> newTargetNames = new TreeSet<String>();
        this.loadReferenceNames(this._conditionalFrame._variableList, newTargetNames);
        this.updateWhereUsed(this._oldTargetNames, newTargetNames, this._curConditional.getSystemName());
        this.closeConditionalFrame();
        return true;
    }

    ConditionalEditBase.PickSingleListener getPickSingleListener(JTextField textField, Conditional.ItemType itemType) {
        return new ConditionalEditBase.PickSingleListener(textField, itemType);
    }

    abstract void closeConditionalFrame();

    void closeConditionalFrame(Logix logix) {
        log.debug("closeConditionalFrame(Logix)");
        try {
            logix.activateLogix();
        }
        catch (NumberFormatException nfe) {
            log.debug("NumberFormatException on activation of Logix ", (Throwable)nfe);
            JOptionPane.showMessageDialog(this._editLogixFrame, String.valueOf(Bundle.getMessage("Error4")) + nfe.toString() + Bundle.getMessage("Error7"), Bundle.getMessage("ErrorTitle"), 0);
        }
        if (this._pickTables != null) {
            this._pickTables.dispose();
            this._pickTables = null;
        }
        if (this._conditionalFrame != null) {
            this._conditionalFrame.dispose();
            this._conditionalFrame = null;
        }
        if (this._editLogixFrame != null) {
            this._editLogixFrame.setVisible(true);
        }
    }

    @Override
    protected String getClassName() {
        return ConditionalListEdit.class.getName();
    }
}

