/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.conditional;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.Conditional;
import jmri.ConditionalAction;
import jmri.ConditionalVariable;
import jmri.InstanceManager;
import jmri.LogixManager;
import jmri.NamedBean;
import jmri.jmrit.conditional.Bundle;
import jmri.jmrit.conditional.ConditionalList;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalFrame
extends JmriJFrame {
    protected ConditionalList _parent;
    boolean _dataChanged = false;
    List<ConditionalVariable> _variableList;
    List<ConditionalAction> _actionList;
    Conditional.AntecedentOperator _logicType = Conditional.AntecedentOperator.ALL_AND;
    String _antecedent;
    boolean _trigger;
    boolean _referenceByMemory;
    JTextField _conditionalUserName;
    static final int STRUT = 10;
    private static final Logger log = LoggerFactory.getLogger(ConditionalFrame.class);

    ConditionalFrame(String title, Conditional conditional, ConditionalList parent) {
        super(title, false, false);
        this._parent = parent;
        this._variableList = conditional.getCopyOfStateVariables();
        this._actionList = conditional.getCopyOfActions();
        this._logicType = conditional.getLogicType();
        this._antecedent = conditional.getAntecedentExpression();
    }

    JPanel makeTopPanel(Conditional conditional) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel panel1 = new JPanel();
        panel1.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("ColumnSystemName"))));
        JTextField systemName = new JTextField(30);
        systemName.setText(conditional.getSystemName());
        systemName.setEditable(false);
        panel1.add(systemName);
        panel.add(panel1);
        JPanel panel2 = new JPanel();
        panel2.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("ColumnUserName"))));
        this._conditionalUserName = new JTextField(30);
        panel2.add(this._conditionalUserName);
        this._conditionalUserName.setText(conditional.getUserName());
        this._conditionalUserName.setToolTipText(Bundle.getMessage("ConditionalUserNameHint"));
        panel.add(panel2);
        return panel;
    }

    JPanel makeEditPanel(JComponent comp, String label, String hint) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel p = new JPanel();
        p.add(new JLabel(Bundle.getMessage(label)));
        panel.add(p);
        if (hint != null) {
            panel.setToolTipText(Bundle.getMessage(hint));
        }
        comp.setMaximumSize(comp.getPreferredSize());
        panel.add(comp);
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    boolean updateConditionalPressed(ActionEvent e) {
        log.debug("updateConditionalPressed");
        String pref = InstanceManager.getDefault(LogixManager.class).getSystemPrefix();
        this._variableList.removeIf(cvar -> cvar.getType() == Conditional.Type.NONE && !cvar.getName().equals(String.valueOf(pref) + "X:RTXINITIALIZER"));
        this._actionList.removeIf(cact -> cact.getType() == Conditional.Action.NONE);
        if (this._parent.updateConditional(this._conditionalUserName.getText(), this._logicType, this._trigger, this._antecedent)) {
            if (this._dataChanged) {
                this._parent._showReminder = true;
            }
            return true;
        }
        return false;
    }

    void cancelConditionalPressed() {
        log.debug("cancelConditionalPressed");
        this._dataChanged = false;
        this._parent.closeConditionalFrame();
    }

    boolean checkReferenceByMemory(String name) {
        this._referenceByMemory = false;
        if (name.length() > 0 && name.charAt(0) == '@') {
            String memName = name.substring(1);
            if (!this._parent.confirmIndirectMemory(memName)) {
                return false;
            }
            if ((memName = this._parent.validateMemoryReference(memName)) == null) {
                return false;
            }
            this._referenceByMemory = true;
        }
        return true;
    }

    boolean checkIsAction(String name, Conditional.ItemType itemType) {
        String actionName = null;
        for (ConditionalAction action : this._actionList) {
            Conditional.ItemType actionType = action.getType().getItemType();
            if (itemType == actionType) {
                if (name.equals(action.getDeviceName())) {
                    actionName = action.getDeviceName();
                } else {
                    NamedBean bean = action.getBean();
                    if (bean != null && (name.equals(bean.getSystemName()) || name.equals(bean.getUserName()))) {
                        actionName = action.getDeviceName();
                    }
                }
            }
            if (actionName == null) continue;
            return this._parent.confirmActionAsVariable(actionName, name);
        }
        return true;
    }

    boolean checkIsVariable(String name, Conditional.ItemType itemType) {
        String varName = null;
        for (ConditionalVariable var : this._variableList) {
            Conditional.ItemType varType = var.getType().getItemType();
            if (itemType == varType) {
                if (name.equals(var.getName())) {
                    varName = var.getName();
                } else {
                    NamedBean bean = var.getBean();
                    if (bean != null && (name.equals(bean.getSystemName()) || name.equals(bean.getUserName()))) {
                        varName = var.getName();
                    }
                }
            }
            if (varName == null) continue;
            return this._parent.confirmActionAsVariable(name, varName);
        }
        return true;
    }
}

