/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.conditional;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.Conditional;
import jmri.ConditionalAction;
import jmri.ConditionalVariable;
import jmri.InstanceManager;
import jmri.Light;
import jmri.Logix;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.VariableLight;
import jmri.implementation.DefaultConditionalAction;
import jmri.jmrit.beantable.LRouteTableAction;
import jmri.jmrit.conditional.Bundle;
import jmri.jmrit.conditional.ConditionalEditBase;
import jmri.jmrit.conditional.ConditionalFrame;
import jmri.jmrit.conditional.ConditionalList;
import jmri.jmrit.logix.OBlock;
import jmri.swing.NamedBeanComboBox;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.NoArchiveFileFilter;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalEditFrame
extends ConditionalFrame {
    JRadioButton _triggerOnChangeButton;
    boolean _inActReorder = false;
    boolean _inVarReorder = false;
    int _nextInOrder = 0;
    JPanel _selectLogixPanel = null;
    JPanel _selectConditionalPanel = null;
    ActionTableModel _actionTableModel = null;
    VariableTableModel _variableTableModel = null;
    JComboBox<Conditional.AntecedentOperator> _operatorBox;
    JComboBox<String> _andOperatorBox;
    JComboBox<String> _notOperatorBox;
    JTextField _antecedentField;
    JPanel _antecedentPanel;
    boolean _newItem = false;
    JmriJFrame _editVariableFrame = null;
    JComboBox<Conditional.ItemType> _variableItemBox;
    JComboBox<Conditional.Type> _variableStateBox;
    JTextField _variableNameField;
    JComboBox<String> _variableCompareOpBox;
    JComboBox<String> _variableSignalBox;
    JComboBox<Conditional.Type> _variableCompareTypeBox;
    JTextField _variableData1Field;
    JTextField _variableData2Field;
    JButton _reorderVarButton;
    JPanel _variableNamePanel;
    JPanel _variableStatePanel;
    JPanel _variableComparePanel;
    JPanel _variableSignalPanel;
    JPanel _variableData1Panel;
    JPanel _variableData2Panel;
    JPanel _variableComboNamePanel;
    JmriJFrame _editActionFrame = null;
    JComboBox<Conditional.ItemType> _actionItemBox;
    JComboBox<Conditional.Action> _actionTypeBox;
    JComboBox<String> _actionBox;
    JTextField _actionNameField;
    JTextField _longActionString;
    JTextField _shortActionString;
    JComboBox<String> _actionOptionBox;
    JPanel _actionPanel;
    JPanel _actionTypePanel;
    JPanel _actionNamePanel;
    JPanel _shortTextPanel;
    JPanel _optionPanel;
    JPanel _actionComboNamePanel;
    JPanel _setPanel;
    JPanel _textPanel;
    NamedBeanComboBox<?> _comboNameBox = null;
    ConditionalVariable _curVariable;
    int _curVariableRowNumber;
    Conditional.ItemType _curVariableItem = Conditional.ItemType.NONE;
    ConditionalAction _curAction;
    int _curActionRowNumber;
    Conditional.ItemType _curActionItem = Conditional.ItemType.NONE;
    static final int STRUT = 10;
    JComboBox<String> _selectLogixBox = new JComboBox();
    JComboBox<String> _selectConditionalBox = new JComboBox();
    TreeMap<String, String> _selectLogixMap = new TreeMap();
    ArrayList<String> _selectConditionalList = new ArrayList();
    transient ActionListener variableSignalTestStateListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            log.debug("variableSignalTestStateListener fires; _variableItemBox.getSelectedIndex()= \"{}\" _variableStateBox.getSelectedIndex()= \"{}\"", (Object)ConditionalEditFrame.this._variableItemBox.getSelectedIndex(), (Object)ConditionalEditFrame.this._variableStateBox.getSelectedIndex());
            Conditional.ItemType itemType = ConditionalEditFrame.this._variableItemBox.getItemAt(ConditionalEditFrame.this._variableItemBox.getSelectedIndex());
            if (ConditionalEditFrame.this._variableStateBox.getSelectedIndex() == 1) {
                if (itemType == Conditional.ItemType.SIGNALHEAD) {
                    ConditionalEditFrame.this.loadJComboBoxWithHeadAppearances(ConditionalEditFrame.this._variableSignalBox, ConditionalEditFrame.this._variableNameField.getText().trim());
                    ConditionalEditFrame.this._variableSignalPanel.setVisible(true);
                } else if (itemType == Conditional.ItemType.SIGNALMAST) {
                    ConditionalEditFrame.this.loadJComboBoxWithMastAspects(ConditionalEditFrame.this._variableSignalBox, ConditionalEditFrame.this._variableNameField.getText().trim());
                    ConditionalEditFrame.this._variableSignalPanel.setVisible(true);
                } else {
                    ConditionalEditFrame.this._variableSignalPanel.setVisible(false);
                }
            } else {
                ConditionalEditFrame.this._variableSignalPanel.setVisible(false);
            }
            ConditionalEditFrame.this._variableSignalBox.setMaximumSize(ConditionalEditFrame.this._variableSignalBox.getPreferredSize());
            if (ConditionalEditFrame.this._editVariableFrame != null) {
                ConditionalEditFrame.this._editVariableFrame.pack();
            }
            ConditionalEditFrame.this._dataChanged = true;
        }
    };
    transient ActionListener variableSignalHeadNameListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            log.debug("variableSignalHeadNameListener fires; _variableNameField: {}", (Object)ConditionalEditFrame.this._variableNameField.getText().trim());
            ConditionalEditFrame.this.loadJComboBoxWithHeadAppearances(ConditionalEditFrame.this._variableSignalBox, ConditionalEditFrame.this._variableNameField.getText().trim());
            ConditionalEditFrame.this._dataChanged = true;
        }
    };
    transient ActionListener variableSignalMastNameListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            log.debug("variableSignalMastNameListener fires; _variableNameField: {}", (Object)ConditionalEditFrame.this._variableNameField.getText().trim());
            ConditionalEditFrame.this.loadJComboBoxWithMastAspects(ConditionalEditFrame.this._variableSignalBox, ConditionalEditFrame.this._variableNameField.getText().trim());
            ConditionalEditFrame.this._dataChanged = true;
        }
    };
    transient ActionListener selectLogixBoxListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String lgxName;
            String lgxItem = (String)ConditionalEditFrame.this._selectLogixBox.getSelectedItem();
            if (lgxItem != null && (lgxName = ConditionalEditFrame.this._selectLogixMap.get(lgxItem)) != null) {
                ConditionalEditFrame.this.loadSelectConditionalBox(lgxName, ConditionalEditFrame.this._curVariable);
            }
            ConditionalEditFrame.this._dataChanged = true;
        }
    };
    transient ActionListener selectConditionalBoxListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int cdlIndex = ConditionalEditFrame.this._selectConditionalBox.getSelectedIndex();
            if (cdlIndex > 0 && cdlIndex < ConditionalEditFrame.this._selectConditionalList.size()) {
                String cdlName = ConditionalEditFrame.this._selectConditionalList.get(cdlIndex);
                ConditionalEditFrame.this._variableNameField.setText(cdlName);
            }
            ConditionalEditFrame.this._dataChanged = true;
        }
    };
    JFileChooser sndFileChooser = null;
    JFileChooser scriptFileChooser = null;
    JFileChooser defaultFileChooser = null;
    ActionTypeListener _actionTypeListener = new ActionTypeListener();
    transient ActionListener actionSignalHeadNameListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            log.debug("actionSignalHeadNameListener fires; _actionNameField: {}", (Object)ConditionalEditFrame.this._actionNameField.getText().trim());
            ConditionalEditFrame.this.loadJComboBoxWithHeadAppearances(ConditionalEditFrame.this._actionBox, ConditionalEditFrame.this._actionNameField.getText().trim());
            ConditionalEditFrame.this._dataChanged = true;
        }
    };
    transient ActionListener actionSignalMastNameListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            log.debug("actionSignalMastNameListener fires; _actionNameField: {}", (Object)ConditionalEditFrame.this._actionNameField.getText().trim());
            ConditionalEditFrame.this.loadJComboBoxWithMastAspects(ConditionalEditFrame.this._actionBox, ConditionalEditFrame.this._actionNameField.getText().trim());
            ConditionalEditFrame.this._dataChanged = true;
        }
    };
    private static final Logger log = LoggerFactory.getLogger(ConditionalEditFrame.class);

    ConditionalEditFrame(String title, Conditional conditional, ConditionalList parent) {
        super(title, conditional, parent);
        this.makeConditionalFrame(conditional);
    }

    void makeConditionalFrame(Conditional conditional) {
        this.addHelpMenu("package.jmri.jmrit.conditional.ConditionalListEditor", true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(this.makeTopPanel(conditional));
        JPanel logicPanel = new JPanel();
        logicPanel.setLayout(new BoxLayout(logicPanel, 1));
        this._antecedentField = new JTextField(65);
        this._antecedentField.setText(ConditionalEditBase.translateAntecedent(this._antecedent, false));
        this._antecedentField.setFont(new Font("SansSerif", 1, 14));
        this._antecedentPanel = this.makeEditPanel(this._antecedentField, "LabelAntecedent", "LabelAntecedentHint");
        JButton helpButton = new JButton(Bundle.getMessage("MenuHelp"));
        this._antecedentPanel.add(helpButton);
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalEditFrame.this.helpPressed(e);
            }
        });
        this._antecedentPanel.add(helpButton);
        this._antecedentPanel.setVisible(this._logicType == Conditional.AntecedentOperator.MIXED);
        logicPanel.add(this._antecedentPanel);
        JPanel varTitle = new JPanel();
        varTitle.setLayout(new FlowLayout());
        varTitle.add(new JLabel(Bundle.getMessage("StateVariableTableTitle")));
        logicPanel.add(varTitle);
        this._notOperatorBox = new JComboBox();
        this._notOperatorBox.addItem(" ");
        this._notOperatorBox.addItem(Bundle.getMessage("LogicNOT"));
        this._andOperatorBox = new JComboBox();
        this._andOperatorBox.addItem(Bundle.getMessage("LogicAND"));
        this._andOperatorBox.addItem(Bundle.getMessage("LogicOR"));
        this._variableTableModel = new VariableTableModel();
        JTable variableTable = new JTable(this._variableTableModel);
        variableTable.setRowHeight(this._notOperatorBox.getPreferredSize().height);
        variableTable.setRowSelectionAllowed(false);
        int rowHeight = variableTable.getRowHeight();
        TableColumnModel variableColumnModel = variableTable.getColumnModel();
        TableColumn rowColumn = variableColumnModel.getColumn(0);
        rowColumn.setResizable(false);
        rowColumn.setMaxWidth(new JTextField((int)3).getPreferredSize().width);
        TableColumn andColumn = variableColumnModel.getColumn(1);
        andColumn.setResizable(false);
        andColumn.setCellEditor(new DefaultCellEditor(this._andOperatorBox));
        andColumn.setMaxWidth(this._andOperatorBox.getPreferredSize().width - 5);
        TableColumn notColumn = variableColumnModel.getColumn(2);
        notColumn.setCellEditor(new DefaultCellEditor(this._notOperatorBox));
        notColumn.setMaxWidth(this._notOperatorBox.getPreferredSize().width - 5);
        notColumn.setResizable(false);
        TableColumn descColumn = variableColumnModel.getColumn(3);
        descColumn.setMinWidth(200);
        descColumn.setResizable(true);
        TableColumn stateColumn = variableColumnModel.getColumn(4);
        stateColumn.setResizable(true);
        stateColumn.setMinWidth(50);
        stateColumn.setMaxWidth(80);
        TableColumn triggerColumn = variableColumnModel.getColumn(5);
        triggerColumn.setResizable(true);
        triggerColumn.setMinWidth(30);
        triggerColumn.setMaxWidth(80);
        TableColumn editColumn = variableColumnModel.getColumn(6);
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        variableTable.setDefaultRenderer(JButton.class, buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        variableTable.setDefaultEditor(JButton.class, buttonEditor);
        JButton testButton = new JButton("XXXXXX");
        variableTable.setRowHeight(testButton.getPreferredSize().height);
        editColumn.setMinWidth(testButton.getPreferredSize().width);
        editColumn.setMaxWidth(testButton.getPreferredSize().width);
        editColumn.setResizable(false);
        TableColumn deleteColumn = variableColumnModel.getColumn(7);
        deleteColumn.setMinWidth(testButton.getPreferredSize().width);
        deleteColumn.setMaxWidth(testButton.getPreferredSize().width);
        deleteColumn.setResizable(false);
        JScrollPane variableTableScrollPane = new JScrollPane(variableTable);
        Dimension dim = variableTable.getPreferredSize();
        dim.height = 7 * rowHeight;
        variableTableScrollPane.getViewport().setPreferredSize(dim);
        logicPanel.add(variableTableScrollPane);
        JPanel panel42 = new JPanel();
        panel42.setLayout(new FlowLayout());
        JButton addVariableButton = new JButton(Bundle.getMessage("AddVariableButton"));
        panel42.add(addVariableButton);
        addVariableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalEditFrame.this.addVariablePressed(e);
            }
        });
        addVariableButton.setToolTipText(Bundle.getMessage("AddVariableButtonHint"));
        JButton checkVariableButton = new JButton(Bundle.getMessage("CheckVariableButton"));
        panel42.add(checkVariableButton);
        checkVariableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalEditFrame.this.checkVariablePressed(e);
            }
        });
        checkVariableButton.setToolTipText(Bundle.getMessage("CheckVariableButtonHint"));
        this._reorderVarButton = new JButton(Bundle.getMessage("ReorderButton"));
        panel42.add(this._reorderVarButton);
        this._reorderVarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalEditFrame.this.reorderVariablePressed(e);
            }
        });
        this._reorderVarButton.setToolTipText(Bundle.getMessage("ReorderButtonHint"));
        this._reorderVarButton.setEnabled(this._logicType != Conditional.AntecedentOperator.MIXED);
        logicPanel.add(panel42);
        this._operatorBox = new JComboBox();
        Conditional.AntecedentOperator[] antecedentOperatorArray = Conditional.AntecedentOperator.values();
        int n = antecedentOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Conditional.AntecedentOperator operator = antecedentOperatorArray[n2];
            this._operatorBox.addItem(operator);
            ++n2;
        }
        JPanel typePanel = this.makeEditPanel(this._operatorBox, "LabelLogicType", "TypeLogicHint");
        this._operatorBox.setSelectedItem((Object)this._logicType);
        this._operatorBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalEditFrame.this.logicTypeChanged(e);
                ConditionalEditFrame.this._dataChanged = true;
            }
        });
        logicPanel.add(typePanel);
        logicPanel.add(Box.createHorizontalStrut(10));
        Border logicPanelBorder = BorderFactory.createEtchedBorder();
        TitledBorder logicPanelTitled = BorderFactory.createTitledBorder(logicPanelBorder, String.valueOf(Bundle.getMessage("TitleLogicalExpression")) + " ");
        logicPanel.setBorder(logicPanelTitled);
        contentPane.add(logicPanel);
        JPanel triggerPanel = new JPanel();
        triggerPanel.setLayout(new BoxLayout(triggerPanel, 1));
        ButtonGroup tGroup = new ButtonGroup();
        this._triggerOnChangeButton = new JRadioButton(Bundle.getMessage("triggerOnChange"));
        this._triggerOnChangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalEditFrame.this._actionTableModel.fireTableDataChanged();
                ConditionalEditFrame.this._dataChanged = true;
            }
        });
        tGroup.add(this._triggerOnChangeButton);
        triggerPanel.add(this._triggerOnChangeButton);
        JRadioButton triggerOnAny = new JRadioButton(Bundle.getMessage("triggerOnAny"));
        triggerOnAny.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalEditFrame.this._actionTableModel.fireTableDataChanged();
                ConditionalEditFrame.this._dataChanged = true;
            }
        });
        tGroup.add(triggerOnAny);
        triggerPanel.add(triggerOnAny);
        triggerOnAny.setSelected(true);
        JPanel trigPanel = new JPanel();
        trigPanel.add(triggerPanel);
        contentPane.add(trigPanel);
        this._triggerOnChangeButton.setSelected(conditional.getTriggerOnChange());
        JPanel conseqentPanel = new JPanel();
        conseqentPanel.setLayout(new BoxLayout(conseqentPanel, 1));
        JPanel actTitle = new JPanel();
        actTitle.setLayout(new FlowLayout());
        actTitle.add(new JLabel(Bundle.getMessage("ActionTableTitle")));
        conseqentPanel.add(actTitle);
        this._actionTableModel = new ActionTableModel();
        JTable actionTable = new JTable(this._actionTableModel);
        actionTable.setRowSelectionAllowed(false);
        actionTable.setRowHeight(testButton.getPreferredSize().height);
        JPanel actionPanel = new JPanel();
        actionPanel.setLayout(new BoxLayout(actionPanel, 1));
        JPanel actionTitle = new JPanel();
        actionTitle.setLayout(new FlowLayout());
        conseqentPanel.add(actionPanel);
        TableColumnModel actionColumnModel = actionTable.getColumnModel();
        TableColumn descriptionColumn = actionColumnModel.getColumn(0);
        descriptionColumn.setResizable(true);
        descriptionColumn.setMinWidth(300);
        TableColumn actionEditColumn = actionColumnModel.getColumn(1);
        actionTable.setDefaultRenderer(JButton.class, buttonRenderer);
        ButtonEditor editButEditor = new ButtonEditor(new JButton());
        actionTable.setDefaultEditor(JButton.class, editButEditor);
        actionEditColumn.setMinWidth(testButton.getPreferredSize().width);
        actionEditColumn.setMaxWidth(testButton.getPreferredSize().width);
        actionEditColumn.setResizable(false);
        TableColumn actionDeleteColumn = actionColumnModel.getColumn(2);
        actionDeleteColumn.setMinWidth(testButton.getPreferredSize().width);
        actionDeleteColumn.setMaxWidth(testButton.getPreferredSize().width);
        actionDeleteColumn.setResizable(false);
        JScrollPane actionTableScrollPane = new JScrollPane(actionTable);
        dim = actionTableScrollPane.getPreferredSize();
        dim.height = 7 * rowHeight;
        actionTableScrollPane.getViewport().setPreferredSize(dim);
        conseqentPanel.add(actionTableScrollPane);
        JPanel panel43 = new JPanel();
        panel43.setLayout(new FlowLayout());
        JButton addActionButton = new JButton(Bundle.getMessage("addActionButton"));
        panel43.add(addActionButton);
        addActionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalEditFrame.this.addActionPressed(e);
            }
        });
        addActionButton.setToolTipText(Bundle.getMessage("addActionButtonHint"));
        conseqentPanel.add(panel43);
        JButton reorderButton = new JButton(Bundle.getMessage("ReorderButton"));
        panel43.add(reorderButton);
        reorderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalEditFrame.this.reorderActionPressed(e);
            }
        });
        reorderButton.setToolTipText(Bundle.getMessage("ReorderButtonHint"));
        conseqentPanel.add(panel43);
        Border conseqentPanelBorder = BorderFactory.createEtchedBorder();
        TitledBorder conseqentPanelTitled = BorderFactory.createTitledBorder(conseqentPanelBorder, Bundle.getMessage("TitleAction"));
        conseqentPanel.setBorder(conseqentPanelTitled);
        contentPane.add(conseqentPanel);
        contentPane.add(this._parent.makeBottomPanel());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConditionalEditFrame.this.cancelConditionalPressed();
            }
        });
        this._variableTableModel.fireTableDataChanged();
        this._actionTableModel.fireTableDataChanged();
        this.checkVariablePressed(null);
    }

    void addVariablePressed(ActionEvent e) {
        if (this.alreadyEditingActionOrVariable()) {
            return;
        }
        this._curVariableItem = Conditional.ItemType.NONE;
        ConditionalVariable variable = new ConditionalVariable();
        this._variableList.add(variable);
        this._newItem = true;
        int size = this._variableList.size();
        if (size > 1) {
            if (this._logicType == Conditional.AntecedentOperator.ALL_OR) {
                variable.setOpern(Conditional.Operator.OR);
            } else {
                variable.setOpern(Conditional.Operator.AND);
            }
        }
        this._variableTableModel.fireTableRowsInserted(--size, size);
        this.makeEditVariableWindow(size);
        this.appendToAntecedent();
    }

    void checkVariablePressed(ActionEvent e) {
        int i = 0;
        while (i < this._variableList.size()) {
            ((ConditionalVariable)this._variableList.get(i)).evaluate();
            ++i;
        }
        this._variableTableModel.fireTableDataChanged();
    }

    void reorderVariablePressed(ActionEvent e) {
        if (this.alreadyEditingActionOrVariable()) {
            return;
        }
        if (this._variableList.size() <= 1) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("Error51"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this._nextInOrder = 0;
        this._inVarReorder = true;
        this._variableTableModel.fireTableDataChanged();
        this._dataChanged = true;
    }

    void swapVariables(int row) {
        ConditionalVariable temp = (ConditionalVariable)this._variableList.get(row);
        int i = row;
        while (i > this._nextInOrder) {
            this._variableList.set(i, (ConditionalVariable)this._variableList.get(i - 1));
            --i;
        }
        Conditional.Operator oper = this._nextInOrder == 0 ? Conditional.Operator.NONE : (this._logicType == Conditional.AntecedentOperator.ALL_AND ? Conditional.Operator.AND : Conditional.Operator.OR);
        temp.setOpern(oper);
        this._variableList.set(this._nextInOrder, temp);
        ++this._nextInOrder;
        if (this._nextInOrder >= this._variableList.size()) {
            this._inVarReorder = false;
        }
        this._variableTableModel.fireTableDataChanged();
    }

    void variableNegationChanged(int row, String oper) {
        ConditionalVariable variable = (ConditionalVariable)this._variableList.get(row);
        boolean state = variable.isNegated();
        if (oper == null) {
            variable.setNegation(false);
        } else {
            variable.setNegation(oper.equals(Bundle.getMessage("LogicNOT")));
        }
        if (variable.isNegated() != state) {
            this.makeAntecedent();
        }
    }

    void variableOperatorChanged(int row, String oper) {
        ConditionalVariable variable = (ConditionalVariable)this._variableList.get(row);
        Conditional.Operator oldOper = variable.getOpern();
        if (row > 0) {
            if (oper.equals(Bundle.getMessage("LogicOR"))) {
                variable.setOpern(Conditional.Operator.OR);
            } else {
                variable.setOpern(Conditional.Operator.AND);
            }
        } else {
            variable.setOpern(Conditional.Operator.NONE);
        }
        if (variable.getOpern() != oldOper) {
            this.makeAntecedent();
        }
    }

    void addActionPressed(ActionEvent e) {
        if (this.alreadyEditingActionOrVariable()) {
            return;
        }
        this._curActionItem = Conditional.ItemType.NONE;
        this._actionList.add(new DefaultConditionalAction());
        this._newItem = true;
        this._actionTableModel.fireTableRowsInserted(this._actionList.size(), this._actionList.size());
        this.makeEditActionWindow(this._actionList.size() - 1);
    }

    void reorderActionPressed(ActionEvent e) {
        if (this.alreadyEditingActionOrVariable()) {
            return;
        }
        if (this._actionList.size() <= 1) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("Error46"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this._nextInOrder = 0;
        this._inActReorder = true;
        this._actionTableModel.fireTableDataChanged();
        this._dataChanged = true;
    }

    void swapActions(int row) {
        ConditionalAction temp = (ConditionalAction)this._actionList.get(row);
        int i = row;
        while (i > this._nextInOrder) {
            this._actionList.set(i, (ConditionalAction)this._actionList.get(i - 1));
            --i;
        }
        this._actionList.set(this._nextInOrder, temp);
        ++this._nextInOrder;
        if (this._nextInOrder >= this._actionList.size()) {
            this._inActReorder = false;
        }
        this._actionTableModel.fireTableDataChanged();
    }

    @Override
    boolean updateConditionalPressed(ActionEvent e) {
        if (this.alreadyEditingActionOrVariable()) {
            return false;
        }
        log.debug("updateConditionalPressed");
        if (!this.validateAntecedent()) {
            return false;
        }
        this._antecedent = ConditionalEditBase.translateAntecedent(this._antecedentField.getText(), true);
        this._trigger = this._triggerOnChangeButton.isSelected();
        return super.updateConditionalPressed(e);
    }

    @Override
    void cancelConditionalPressed() {
        log.debug("cancelConditionalPressed");
        if (this._editActionFrame != null) {
            this.cleanUpAction();
        }
        if (this._editVariableFrame != null) {
            this.cleanUpVariable();
        }
        super.cancelConditionalPressed();
    }

    boolean logicTypeChanged(ActionEvent e) {
        Conditional.AntecedentOperator type = this._operatorBox.getItemAt(this._operatorBox.getSelectedIndex());
        if (type == this._logicType) {
            return false;
        }
        this.makeAntecedent();
        if (type == Conditional.AntecedentOperator.MIXED) {
            this._antecedentPanel.setVisible(true);
            this._reorderVarButton.setEnabled(false);
        } else {
            Conditional.Operator oper = type == Conditional.AntecedentOperator.ALL_AND ? Conditional.Operator.AND : Conditional.Operator.OR;
            int i = 1;
            while (i < this._variableList.size()) {
                ((ConditionalVariable)this._variableList.get(i)).setOpern(oper);
                ++i;
            }
            this._antecedentPanel.setVisible(false);
            this._reorderVarButton.setEnabled(true);
        }
        this._logicType = type;
        this._dataChanged = true;
        this._variableTableModel.fireTableDataChanged();
        this.repaint();
        return true;
    }

    void helpPressed(ActionEvent e) {
        JOptionPane.showMessageDialog(this, new String[]{Bundle.getMessage("ConditionalHelpText1"), Bundle.getMessage("ConditionalHelpText2"), Bundle.getMessage("ConditionalHelpText3"), Bundle.getMessage("ConditionalHelpText4"), Bundle.getMessage("ConditionalHelpText5"), Bundle.getMessage("ConditionalHelpText6"), Bundle.getMessage("ConditionalHelpText7")}, Bundle.getMessage("MenuHelp"), 1);
    }

    void makeAntecedent() {
        this._antecedent = this._parent.makeAntecedent(this._variableList);
        this._antecedentField.setText(ConditionalEditBase.translateAntecedent(this._antecedent, false));
    }

    void appendToAntecedent() {
        this._antecedent = this._parent.appendToAntecedent(this._logicType, this._variableList.size(), this._antecedent);
        this._antecedentField.setText(ConditionalEditBase.translateAntecedent(this._antecedent, false));
    }

    boolean validateAntecedent() {
        return this._parent.validateAntecedent(this._logicType, this._antecedentField.getText(), this._variableList, this._parent._curConditional);
    }

    boolean alreadyEditingActionOrVariable() {
        if (this._editActionFrame != null) {
            if (!this._dataChanged) {
                this.cleanUpAction();
                return false;
            }
            JOptionPane.showMessageDialog(this._editActionFrame, Bundle.getMessage("Error48"), Bundle.getMessage("ErrorTitle"), 0);
            this._editActionFrame.setVisible(true);
            this._editActionFrame.toFront();
            return true;
        }
        if (this._editVariableFrame != null) {
            if (!this._dataChanged) {
                this.cleanUpVariable();
                return false;
            }
            JOptionPane.showMessageDialog(this._editVariableFrame, Bundle.getMessage("Error47"), Bundle.getMessage("ErrorTitle"), 0);
            this._editVariableFrame.setVisible(true);
            this._editVariableFrame.toFront();
            return true;
        }
        if (this._parent._selectionMode == ConditionalEditBase.SelectionMode.USEMULTI) {
            this._parent.openPickListTable();
        }
        return false;
    }

    void loadJComboBoxWithHeadAppearances(JComboBox<String> box, String signalHeadName) {
        box.removeAllItems();
        log.debug("loadJComboBoxWithSignalHeadAppearances called with name: {}", (Object)signalHeadName);
        SignalHead h = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHeadName);
        if (h == null) {
            box.addItem(Bundle.getMessage("PromptLoadHeadName"));
        } else {
            String[] v = h.getValidStateNames();
            int i = 0;
            while (i < v.length) {
                box.addItem(v[i]);
                ++i;
            }
            box.setSelectedItem(h.getAppearanceName());
        }
    }

    void loadJComboBoxWithMastAspects(JComboBox<String> box, String mastName) {
        box.removeAllItems();
        log.debug("loadJComboBoxWithMastAspects called with name: {}", (Object)mastName);
        SignalMast m = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(mastName);
        if (m == null) {
            box.addItem(Bundle.getMessage("PromptLoadMastName"));
        } else {
            Vector<String> v = m.getValidAspects();
            int i = 0;
            while (i < v.size()) {
                box.addItem(v.get(i));
                ++i;
            }
            box.setSelectedItem(m.getAspect());
        }
    }

    JPanel makeTopPanel(JFrame frame, String title, int width, int height) {
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 0));
        contentPane.add(Box.createRigidArea(new Dimension(0, height)));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        Border panelBorder = BorderFactory.createEtchedBorder();
        TitledBorder panelTitled = BorderFactory.createTitledBorder(panelBorder, Bundle.getMessage(title));
        topPanel.setBorder(panelTitled);
        topPanel.add(Box.createRigidArea(new Dimension(width, 0)));
        topPanel.add(Box.createVerticalGlue());
        return topPanel;
    }

    JPanel makeButtonPanel(ActionListener updateListener, ActionListener cancelListener, ActionListener deleteListener) {
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 0));
        JButton cancelAction = new JButton(Bundle.getMessage("ButtonCancel"));
        panel3.add(cancelAction);
        panel3.add(Box.createHorizontalStrut(10));
        cancelAction.addActionListener(cancelListener);
        cancelAction.setToolTipText(Bundle.getMessage("CancelButtonHint"));
        JButton updateAction = new JButton(Bundle.getMessage("ButtonUpdate"));
        panel3.add(updateAction);
        panel3.add(Box.createHorizontalStrut(10));
        updateAction.addActionListener(updateListener);
        updateAction.setToolTipText(Bundle.getMessage("UpdateButtonHint"));
        JButton deleteAction = new JButton(Bundle.getMessage("ButtonDelete"));
        panel3.add(deleteAction);
        deleteAction.addActionListener(deleteListener);
        deleteAction.setToolTipText(Bundle.getMessage("DeleteButtonHint"));
        return panel3;
    }

    void makeEditVariableWindow(int row) {
        if (this.alreadyEditingActionOrVariable()) {
            return;
        }
        log.debug("makeEditVariableWindow: row = {}", (Object)row);
        this._curVariableRowNumber = row;
        this._curVariable = (ConditionalVariable)this._variableList.get(row);
        this._editVariableFrame = new JmriJFrame(Bundle.getMessage("TitleEditVariable"), true, true);
        this._editVariableFrame.addHelpMenu("package.jmri.jmrit.conditional.StateVariableActionList", true);
        JPanel topPanel = this.makeTopPanel(this._editVariableFrame, "TitleAntecedentPhrase", 500, 160);
        Box panel1 = Box.createHorizontalBox();
        panel1.add(Box.createHorizontalGlue());
        panel1.add(Box.createHorizontalStrut(10));
        this._variableItemBox = new JComboBox();
        for (Conditional.ItemType itemType : Conditional.ItemType.getStateVarList()) {
            this._variableItemBox.addItem(itemType);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._variableItemBox);
        panel1.add(this.makeEditPanel(this._variableItemBox, "LabelVariableType", "VariableTypeHint"));
        panel1.add(Box.createHorizontalStrut(10));
        this._variableNameField = new JTextField(30);
        this._variableNamePanel = this.makeEditPanel(this._variableNameField, "LabelItemName", null);
        this._variableNamePanel.setMaximumSize(new Dimension(50, this._variableNamePanel.getPreferredSize().height));
        this._variableNamePanel.setVisible(false);
        panel1.add(this._variableNamePanel);
        panel1.add(Box.createHorizontalStrut(10));
        if (this._parent._selectionMode == ConditionalEditBase.SelectionMode.USECOMBO) {
            this._comboNameBox = this._parent.createNameBox(Conditional.ItemType.SENSOR);
            this._variableComboNamePanel = this.makeEditPanel(this._comboNameBox, "LabelItemName", null);
            this._variableComboNamePanel.setVisible(false);
            panel1.add(this._variableComboNamePanel);
            panel1.add(Box.createHorizontalStrut(10));
        }
        this._selectLogixBox.addItem("XXXXXXXXXXXXXXXXXXXXX");
        this._selectConditionalBox.addItem("XXXXXXXXXXXXXXXXXXXXX");
        this._selectLogixPanel = this.makeEditPanel(this._selectLogixBox, "SelectLogix", null);
        this._selectConditionalPanel = this.makeEditPanel(this._selectConditionalBox, "SelectConditional", null);
        this._selectLogixPanel.setVisible(false);
        this._selectConditionalPanel.setVisible(false);
        panel1.add(this._selectLogixPanel);
        panel1.add(this._selectConditionalPanel);
        panel1.add(Box.createHorizontalStrut(10));
        this._variableStateBox = new JComboBox();
        this._variableStateBox.addItem(Conditional.Type.XXXXXXX);
        this._variableStatePanel = this.makeEditPanel(this._variableStateBox, "LabelVariableState", "VariableStateHint");
        this._variableStatePanel.setVisible(false);
        panel1.add(this._variableStatePanel);
        panel1.add(Box.createHorizontalStrut(10));
        this._variableSignalBox = new JComboBox();
        this._variableSignalBox.addItem("XXXXXXXXX");
        this._variableSignalPanel = this.makeEditPanel(this._variableSignalBox, "LabelVariableAspect", "VariableAspectHint");
        this._variableSignalPanel.setVisible(false);
        panel1.add(this._variableSignalPanel);
        panel1.add(Box.createHorizontalStrut(10));
        this._variableComparePanel = new JPanel();
        this._variableComparePanel.setLayout(new BoxLayout(this._variableComparePanel, 0));
        this._variableCompareOpBox = new JComboBox();
        int i = 1;
        while (i <= 5) {
            this._variableCompareOpBox.addItem(ConditionalVariable.getCompareOperationString(i));
            ++i;
        }
        this._variableComparePanel.add(this.makeEditPanel(this._variableCompareOpBox, "LabelCompareOp", "CompareHintMemory"));
        this._variableComparePanel.add(Box.createHorizontalStrut(10));
        this._variableCompareTypeBox = new JComboBox();
        for (Conditional.Type t : Conditional.Type.getMemoryItems()) {
            this._variableCompareTypeBox.addItem(t);
        }
        this._variableComparePanel.add(this.makeEditPanel(this._variableCompareTypeBox, "LabelCompareType", "CompareTypeHint"));
        this._variableComparePanel.setVisible(false);
        this._variableCompareTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalEditFrame.this.compareTypeChanged(ConditionalEditFrame.this._variableCompareTypeBox.getSelectedIndex());
                ConditionalEditFrame.this._editVariableFrame.pack();
                ConditionalEditFrame.this._dataChanged = true;
            }
        });
        panel1.add(this._variableComparePanel);
        panel1.add(Box.createHorizontalStrut(10));
        this._variableData1Field = new JTextField(30);
        this._variableData1Panel = this.makeEditPanel(this._variableData1Field, "LabelStartTime", "DataHintTime");
        this._variableData1Panel.setMaximumSize(new Dimension(45, this._variableData1Panel.getPreferredSize().height));
        this._variableData1Panel.setVisible(false);
        panel1.add(this._variableData1Panel);
        panel1.add(Box.createHorizontalStrut(10));
        this._variableData2Field = new JTextField(30);
        this._variableData2Panel = this.makeEditPanel(this._variableData2Field, "LabelEndTime", "DataHintTime");
        this._variableData2Panel.setMaximumSize(new Dimension(45, this._variableData2Panel.getPreferredSize().height));
        this._variableData2Panel.setVisible(false);
        panel1.add(this._variableData2Panel);
        panel1.add(Box.createHorizontalStrut(10));
        panel1.add(Box.createHorizontalGlue());
        topPanel.add(panel1);
        ActionListener updateListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalEditFrame.this.updateVariablePressed();
            }
        };
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalEditFrame.this.cancelEditVariablePressed();
            }
        };
        ActionListener deleteListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalEditFrame.this.deleteVariablePressed();
            }
        };
        JPanel panel = this.makeButtonPanel(updateListener, cancelListener, deleteListener);
        topPanel.add(panel);
        topPanel.add(Box.createVerticalGlue());
        Container contentPane = this._editVariableFrame.getContentPane();
        contentPane.add(topPanel);
        this._variableItemBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Conditional.ItemType newVariableItem = ConditionalEditFrame.this._variableItemBox.getItemAt(ConditionalEditFrame.this._variableItemBox.getSelectedIndex());
                if (log.isDebugEnabled()) {
                    log.debug("_variableItemBox Listener: new = {}, curr = {}, row = {}", new Object[]{newVariableItem, ConditionalEditFrame.this._curVariableItem, ConditionalEditFrame.this._curVariableRowNumber});
                }
                if (newVariableItem != ConditionalEditFrame.this._curVariableItem) {
                    if (ConditionalEditFrame.this._curVariableRowNumber >= 0) {
                        ConditionalEditFrame.this._curVariable = new ConditionalVariable();
                        if (ConditionalEditFrame.this._curVariableRowNumber > 0) {
                            if (ConditionalEditFrame.this._logicType == Conditional.AntecedentOperator.ALL_OR) {
                                ConditionalEditFrame.this._curVariable.setOpern(Conditional.Operator.OR);
                            } else {
                                ConditionalEditFrame.this._curVariable.setOpern(Conditional.Operator.AND);
                            }
                        }
                        ConditionalEditFrame.this._variableList.set(ConditionalEditFrame.this._curVariableRowNumber, ConditionalEditFrame.this._curVariable);
                    }
                    ConditionalEditFrame.this._curVariableItem = newVariableItem;
                }
                ConditionalEditFrame.this._dataChanged = true;
                ConditionalEditFrame.this.variableItemChanged(newVariableItem);
                ConditionalEditFrame.this._editVariableFrame.pack();
            }
        });
        this._editVariableFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConditionalEditFrame.this.cancelEditVariablePressed();
            }
        });
        this._curVariableItem = this._curVariable.getType().getItemType();
        this.initializeStateVariables();
        this._dataChanged = false;
        this._editVariableFrame.pack();
        this._editVariableFrame.setVisible(true);
    }

    void initializeStateVariables() {
        Conditional.Type testType = this._curVariable.getType();
        Conditional.ItemType itemType = testType.getItemType();
        if (log.isDebugEnabled()) {
            log.debug("initializeStateVariables: itemType = {}, testType = {}", (Object)itemType, (Object)testType);
        }
        if (testType == Conditional.Type.NONE) {
            return;
        }
        this._variableItemBox.setSelectedItem((Object)itemType);
        switch (itemType) {
            case SENSOR: 
            case TURNOUT: 
            case LIGHT: 
            case CONDITIONAL: 
            case WARRANT: {
                this._variableStateBox.setSelectedItem((Object)testType);
                this._variableNameField.setText(this._curVariable.getName());
                break;
            }
            case SIGNALHEAD: {
                this._variableStateBox.setSelectedItem((Object)testType);
                this._variableNameField.setText(this._curVariable.getName());
                if (!Conditional.Type.isSignalHeadApperance(testType)) break;
                this._variableStateBox.setSelectedItem((Object)Conditional.Type.SIGNAL_HEAD_APPEARANCE_EQUALS);
                this.loadJComboBoxWithHeadAppearances(this._variableSignalBox, this._curVariable.getName());
                this._variableSignalBox.setSelectedItem((Object)this._curVariable.getType());
                this._variableSignalPanel.setVisible(true);
                break;
            }
            case SIGNALMAST: {
                this._variableStateBox.setSelectedItem((Object)testType);
                this._variableNameField.setText(this._curVariable.getName());
                if (testType != Conditional.Type.SIGNAL_MAST_ASPECT_EQUALS) break;
                this.loadJComboBoxWithMastAspects(this._variableSignalBox, this._curVariable.getName());
                this._variableSignalBox.setSelectedItem(this._curVariable.getDataString());
                this._variableSignalPanel.setVisible(true);
                break;
            }
            case MEMORY: {
                this._variableCompareTypeBox.setSelectedIndex(Conditional.Type.getIndexInList(Conditional.Type.getMemoryItems(), testType));
                this._variableNameField.setText(this._curVariable.getName());
                int num1 = this._curVariable.getNum1() - 1;
                if (num1 == -1) {
                    num1 = 2;
                }
                this._variableCompareOpBox.setSelectedIndex(num1);
                this._variableData1Field.setText(this._curVariable.getDataString());
                break;
            }
            case CLOCK: {
                int time = this._curVariable.getNum1();
                this._variableData1Field.setText(ConditionalEditBase.formatTime(time / 60, time - time / 60 * 60));
                time = this._curVariable.getNum2();
                this._variableData2Field.setText(ConditionalEditBase.formatTime(time / 60, time - time / 60 * 60));
                this._variableNameField.setText("");
                break;
            }
            case OBLOCK: {
                this._variableNameField.setText(this._curVariable.getName());
                for (Conditional.Type type : Conditional.Type.getOBlockItems()) {
                    this._variableStateBox.addItem(type);
                    if (!type.toString().equals(OBlock.getLocalStatusName(this._curVariable.getDataString()))) continue;
                    this._variableStateBox.setSelectedItem((Object)type);
                }
                this._variableStateBox.setVisible(true);
                break;
            }
            case ENTRYEXIT: {
                this._variableNameField.setText(this._curVariable.getBean().getUserName());
                this._variableStateBox.setSelectedItem((Object)testType);
                this._variableStateBox.setVisible(true);
                break;
            }
        }
        this._editVariableFrame.pack();
        this._editVariableFrame.transferFocusBackward();
    }

    private void variableItemChanged(Conditional.ItemType itemType) {
        Conditional.Type testType = this._curVariable.getType();
        if (log.isDebugEnabled()) {
            log.debug("variableItemChanged: itemType = {}, testType = {}", (Object)itemType, (Object)testType);
        }
        this._variableNamePanel.setVisible(false);
        this._variableStatePanel.setVisible(false);
        this._variableComparePanel.setVisible(false);
        this._variableSignalPanel.setVisible(false);
        this._variableData1Panel.setVisible(false);
        this._variableData2Panel.setVisible(false);
        this._selectLogixPanel.setVisible(false);
        this._selectConditionalPanel.setVisible(false);
        this._variableStateBox.removeAllItems();
        this._variableNameField.removeActionListener(this.variableSignalHeadNameListener);
        this._variableNameField.removeActionListener(this.variableSignalMastNameListener);
        this._variableStateBox.removeActionListener(this.variableSignalTestStateListener);
        this._selectLogixBox.removeActionListener(this.selectLogixBoxListener);
        this._selectConditionalBox.removeActionListener(this.selectConditionalBoxListener);
        if (this._parent._selectionMode == ConditionalEditBase.SelectionMode.USECOMBO) {
            this._variableComboNamePanel.setVisible(false);
        } else if (this._parent._selectionMode == ConditionalEditBase.SelectionMode.USESINGLE) {
            this._parent.createSinglePanelPickList(itemType, this._parent.getPickSingleListener(this._variableNameField, itemType), false);
        } else {
            this._parent.setPickListTab(itemType, false);
        }
        switch (itemType) {
            case NONE: {
                return;
            }
            case SENSOR: {
                this._variableNamePanel.setToolTipText(Bundle.getMessage("NameHintSensor"));
                for (Conditional.Type type : Conditional.Type.getSensorItems()) {
                    this._variableStateBox.addItem(type);
                }
                this._variableStatePanel.setVisible(true);
                this._variableNamePanel.setVisible(true);
                this.setVariableNameBox(itemType);
                break;
            }
            case TURNOUT: {
                this._variableNamePanel.setToolTipText(Bundle.getMessage("NameHintTurnout"));
                for (Conditional.Type type : Conditional.Type.getTurnoutItems()) {
                    this._variableStateBox.addItem(type);
                }
                this._variableNamePanel.setVisible(true);
                this._variableStatePanel.setVisible(true);
                this.setVariableNameBox(itemType);
                break;
            }
            case LIGHT: {
                this._variableNamePanel.setToolTipText(Bundle.getMessage("NameHintLight"));
                for (Conditional.Type type : Conditional.Type.getLightItems()) {
                    this._variableStateBox.addItem(type);
                }
                this._variableStatePanel.setVisible(true);
                this._variableNamePanel.setVisible(true);
                this.setVariableNameBox(itemType);
                break;
            }
            case SIGNALHEAD: {
                this._variableStateBox.addActionListener(this.variableSignalTestStateListener);
                this.loadJComboBoxWithHeadAppearances(this._variableSignalBox, this._variableNameField.getText().trim());
                for (Conditional.Type type : Conditional.Type.getSignalHeadStateMachineItems()) {
                    this._variableStateBox.addItem(type);
                }
                this._variableNamePanel.setToolTipText(Bundle.getMessage("NameHintSignal"));
                this._variableNamePanel.setVisible(true);
                this._variableStatePanel.setVisible(true);
                if (testType == Conditional.Type.SIGNAL_HEAD_APPEARANCE_EQUALS) {
                    this._variableSignalPanel.setVisible(true);
                } else {
                    this._variableSignalPanel.setVisible(false);
                }
                this.setVariableNameBox(itemType);
                this._variableNameField.addActionListener(this.variableSignalHeadNameListener);
                break;
            }
            case SIGNALMAST: {
                this._variableStateBox.addActionListener(this.variableSignalTestStateListener);
                this.loadJComboBoxWithMastAspects(this._variableSignalBox, this._variableNameField.getText().trim());
                for (Conditional.Type type : Conditional.Type.getSignalMastItems()) {
                    this._variableStateBox.addItem(type);
                }
                this._variableNamePanel.setToolTipText(Bundle.getMessage("NameHintSignalMast"));
                this._variableNamePanel.setVisible(true);
                this._variableStatePanel.setVisible(true);
                if (testType == Conditional.Type.SIGNAL_MAST_ASPECT_EQUALS) {
                    this._variableSignalPanel.setVisible(true);
                } else {
                    this._variableSignalPanel.setVisible(false);
                }
                this.setVariableNameBox(itemType);
                this._variableNameField.addActionListener(this.variableSignalMastNameListener);
                break;
            }
            case MEMORY: {
                JPanel p = (JPanel)this._variableData1Panel.getComponent(0);
                JLabel l = (JLabel)p.getComponent(0);
                if (testType == Conditional.Type.MEMORY_COMPARE || testType == Conditional.Type.MEMORY_COMPARE_INSENSITIVE) {
                    l.setText(Bundle.getMessage("LabelMemoryValue"));
                    this._variableData1Panel.setToolTipText(Bundle.getMessage("DataHintMemory"));
                } else {
                    l.setText(Bundle.getMessage("LabelLiteralValue"));
                    this._variableData1Panel.setToolTipText(Bundle.getMessage("DataHintValue"));
                }
                this._variableNamePanel.setToolTipText(Bundle.getMessage("NameHintMemory"));
                this._variableNamePanel.setVisible(true);
                this._variableData1Panel.setToolTipText(Bundle.getMessage("DataHintMemory"));
                this._variableData1Panel.setVisible(true);
                this._variableComparePanel.setVisible(true);
                this.setVariableNameBox(itemType);
                break;
            }
            case CONDITIONAL: {
                this._variableNamePanel.setToolTipText(Bundle.getMessage("NameHintConditional"));
                for (Conditional.Type type : Conditional.Type.getConditionalItems()) {
                    this._variableStateBox.addItem(type);
                }
                this.loadSelectLogixBox(this._curVariable);
                this._selectLogixPanel.setPreferredSize(this._selectLogixBox.getPreferredSize());
                this._selectConditionalPanel.setPreferredSize(this._selectConditionalBox.getPreferredSize());
                this._selectLogixPanel.setVisible(true);
                this._selectConditionalPanel.setVisible(true);
                this._variableStatePanel.setVisible(true);
                this._selectLogixBox.addActionListener(this.selectLogixBoxListener);
                this._selectConditionalBox.addActionListener(this.selectConditionalBoxListener);
                break;
            }
            case WARRANT: {
                this._variableNamePanel.setToolTipText(Bundle.getMessage("NameHintWarrant"));
                for (Conditional.Type type : Conditional.Type.getWarrantItems()) {
                    this._variableStateBox.addItem(type);
                }
                this._variableNamePanel.setVisible(true);
                this._variableStatePanel.setVisible(true);
                this.setVariableNameBox(itemType);
                break;
            }
            case CLOCK: {
                JPanel p = (JPanel)this._variableData1Panel.getComponent(0);
                JLabel l = (JLabel)p.getComponent(0);
                l.setText(Bundle.getMessage("LabelStartTime"));
                this._variableData1Panel.setToolTipText(Bundle.getMessage("DataHintTime"));
                this._variableData1Panel.setVisible(true);
                this._variableData2Panel.setVisible(true);
                break;
            }
            case OBLOCK: {
                this._variableNamePanel.setToolTipText(Bundle.getMessage("NameHintOBlock"));
                this._variableNamePanel.setVisible(true);
                this._variableStateBox.removeAllItems();
                for (Conditional.Type type : Conditional.Type.getOBlockItems()) {
                    this._variableStateBox.addItem(type);
                }
                this._variableStatePanel.setVisible(true);
                this.setVariableNameBox(itemType);
                break;
            }
            case ENTRYEXIT: {
                this._variableNamePanel.setToolTipText(Bundle.getMessage("NameHintEntryExit"));
                this._variableNameField.setText(this._curVariable.getName());
                for (Conditional.Type type : Conditional.Type.getEntryExitItems()) {
                    this._variableStateBox.addItem(type);
                }
                this._variableStatePanel.setVisible(true);
                this._variableNamePanel.setVisible(true);
                this.setVariableNameBox(itemType);
                break;
            }
        }
        this._variableStateBox.setMaximumSize(this._variableStateBox.getPreferredSize());
    }

    void setVariableNameBox(Conditional.ItemType itemType) {
        if (this._parent._selectionMode != ConditionalEditBase.SelectionMode.USECOMBO) {
            return;
        }
        this._comboNameBox = this._parent.createNameBox(itemType);
        if (this._comboNameBox == null) {
            return;
        }
        this._comboNameBox.setSelectedItemByName(this._curVariable.getName());
        this._comboNameBox.addActionListener(new ConditionalEditBase.NameBoxListener(this._variableNameField));
        this._variableComboNamePanel.remove(1);
        this._variableComboNamePanel.add(this._comboNameBox, null, 1);
        this._variableNamePanel.setVisible(false);
        this._variableComboNamePanel.setVisible(true);
    }

    void updateVariablePressed() {
        if (!this.validateVariable()) {
            this._editVariableFrame.toFront();
            return;
        }
        this._variableTableModel.fireTableRowsUpdated(this._curVariableRowNumber, this._curVariableRowNumber);
        this.cleanUpVariable();
    }

    void cancelEditVariablePressed() {
        if (this._newItem) {
            this.deleteVariablePressed(this._curVariableRowNumber);
        } else {
            this.cleanUpVariable();
        }
    }

    void cleanUpVariable() {
        this._newItem = false;
        if (this._editVariableFrame != null) {
            this._editVariableFrame.setVisible(false);
            this._editVariableFrame.dispose();
            this._editVariableFrame = null;
            this._parent.closeSinglePanelPickList();
        }
        this._curVariableRowNumber = -1;
    }

    void deleteVariablePressed() {
        this.deleteVariablePressed(this._curVariableRowNumber);
    }

    void deleteVariablePressed(int row) {
        if (row != this._curVariableRowNumber && this.alreadyEditingActionOrVariable()) {
            return;
        }
        if (this._variableList.size() < 1 && !this._parent._suppressReminder) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("Warn3"), Bundle.getMessage("WarningTitle"), 2);
        }
        this._variableList.remove(row);
        this._variableTableModel.fireTableRowsDeleted(row, row);
        this._dataChanged = true;
        this.makeAntecedent();
        this.cleanUpVariable();
    }

    private void compareTypeChanged(int selection) {
        JPanel p = (JPanel)this._variableData1Panel.getComponent(0);
        JLabel l = (JLabel)p.getComponent(0);
        Conditional.Type testType = Conditional.Type.getMemoryItems().get(selection);
        if (testType == Conditional.Type.MEMORY_COMPARE || testType == Conditional.Type.MEMORY_COMPARE_INSENSITIVE) {
            l.setText(Bundle.getMessage("LabelMemoryValue"));
            this._variableData1Panel.setToolTipText(Bundle.getMessage("DataHintMemory"));
        } else {
            l.setText(Bundle.getMessage("LabelLiteralValue"));
            this._variableData1Panel.setToolTipText(Bundle.getMessage("DataHintValue"));
        }
    }

    boolean validateVariable() {
        String name = this._variableNameField.getText().trim();
        this._variableNameField.setText(name);
        this._curVariable.setDataString("");
        this._curVariable.setNum1(0);
        this._curVariable.setNum2(0);
        Conditional.ItemType itemType = this._variableItemBox.getItemAt(this._variableItemBox.getSelectedIndex());
        Conditional.Type testType = Conditional.Type.NONE;
        if (!this.checkIsAction(name, itemType)) {
            return false;
        }
        this._dataChanged = true;
        switch (itemType) {
            case SENSOR: 
            case TURNOUT: 
            case LIGHT: 
            case SIGNALHEAD: 
            case SIGNALMAST: 
            case CONDITIONAL: 
            case WARRANT: 
            case ENTRYEXIT: {
                testType = this._variableStateBox.getItemAt(this._variableStateBox.getSelectedIndex());
                break;
            }
            case MEMORY: {
                testType = this._variableCompareTypeBox.getItemAt(this._variableCompareTypeBox.getSelectedIndex());
                break;
            }
            case CLOCK: {
                testType = Conditional.Type.FAST_CLOCK_RANGE;
                break;
            }
            case OBLOCK: {
                testType = Conditional.Type.BLOCK_STATUS_EQUALS;
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorVariableType"), Bundle.getMessage("ErrorTitle"), 0);
                return false;
            }
        }
        this._curVariable.setType(testType);
        log.debug("validateVariable: itemType= {}, testType= {}", (Object)itemType, (Object)testType);
        switch (itemType) {
            case SENSOR: {
                name = this._parent.validateSensorReference(name);
                if (name != null) break;
                return false;
            }
            case TURNOUT: {
                name = this._parent.validateTurnoutReference(name);
                if (name != null) break;
                return false;
            }
            case CONDITIONAL: {
                name = this._parent.validateConditionalReference(name);
                if (name == null) {
                    return false;
                }
                this._curVariable.setName(name);
                Conditional c = this._parent._conditionalManager.getBySystemName(name);
                if (c == null) {
                    return false;
                }
                String uName = c.getUserName();
                if (uName == null || uName.isEmpty()) {
                    this._curVariable.setGuiName(c.getSystemName());
                    break;
                }
                this._curVariable.setGuiName(uName);
                break;
            }
            case LIGHT: {
                name = this._parent.validateLightReference(name);
                if (name != null) break;
                return false;
            }
            case MEMORY: {
                name = this._parent.validateMemoryReference(name);
                if (name == null) {
                    return false;
                }
                String name2 = this._variableData1Field.getText();
                if ((testType == Conditional.Type.MEMORY_COMPARE || testType == Conditional.Type.MEMORY_COMPARE_INSENSITIVE) && (name2 = this._parent.validateMemoryReference(name2)) == null) {
                    return false;
                }
                this._curVariable.setDataString(name2);
                this._curVariable.setNum1(this._variableCompareOpBox.getSelectedIndex() + 1);
                break;
            }
            case CLOCK: {
                int beginTime = this._parent.parseTime(this._variableData1Field.getText());
                if (beginTime < 0) {
                    return false;
                }
                int endTime = this._parent.parseTime(this._variableData2Field.getText());
                if (endTime < 0) {
                    return false;
                }
                this._curVariable.setNum1(beginTime);
                this._curVariable.setNum2(endTime);
                name = "Clock";
                break;
            }
            case SIGNALHEAD: {
                name = this._parent.validateSignalHeadReference(name);
                if (name == null) {
                    return false;
                }
                if (testType != Conditional.Type.SIGNAL_HEAD_APPEARANCE_EQUALS) break;
                String appStr = (String)this._variableSignalBox.getSelectedItem();
                Conditional.Type type = ConditionalVariable.stringToVariableTest(appStr);
                if (type == Conditional.Type.ERROR) {
                    JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorAppearance"), Bundle.getMessage("ErrorTitle"), 0);
                    return false;
                }
                this._curVariable.setType(type);
                this._curVariable.setDataString(appStr);
                log.debug("SignalHead \"{}\" of type '{}' _variableSignalBox.getSelectedItem()= {}", new Object[]{name, testType, this._variableSignalBox.getSelectedItem()});
                break;
            }
            case SIGNALMAST: {
                name = this._parent.validateSignalMastReference(name);
                if (name == null) {
                    return false;
                }
                if (testType != Conditional.Type.SIGNAL_MAST_ASPECT_EQUALS) break;
                if (this._variableSignalBox.getSelectedIndex() < 0) {
                    JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorAspect"), Bundle.getMessage("ErrorTitle"), 0);
                    return false;
                }
                this._curVariable.setDataString((String)this._variableSignalBox.getSelectedItem());
                break;
            }
            case WARRANT: {
                name = this._parent.validateWarrantReference(name);
                if (name != null) break;
                return false;
            }
            case OBLOCK: {
                name = this._parent.validateOBlockReference(name);
                if (name == null) {
                    return false;
                }
                String str = this._variableStateBox.getSelectedItem().toString();
                this._curVariable.setDataString(OBlock.getSystemStatusName(str));
                log.debug("OBlock \"{}\" of type '{}' _variableStateBox.getSelectedItem()= {}", new Object[]{name, testType, this._variableStateBox.getSelectedItem()});
                break;
            }
            case ENTRYEXIT: {
                name = this._parent.validateEntryExitReference(name);
                if (name != null) break;
                return false;
            }
            default: {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorVariableType"), Bundle.getMessage("ErrorTitle"), 0);
                return false;
            }
        }
        this._curVariable.setName(name);
        boolean result = this._curVariable.evaluate();
        log.debug("State Variable \"{}\" of type '{}' state= {} type= {}", new Object[]{name, testType.getTestTypeString(), result, this._curVariable.getType()});
        if (this._curVariable.getType() == Conditional.Type.NONE) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorVariableState"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        return true;
    }

    void makeEditActionWindow(int row) {
        if (this.alreadyEditingActionOrVariable()) {
            return;
        }
        log.debug("makeEditActionWindow: row = {}", (Object)row);
        this._curActionRowNumber = row;
        this._curAction = (ConditionalAction)this._actionList.get(row);
        this._editActionFrame = new JmriJFrame(Bundle.getMessage("TitleEditAction"), true, true);
        this._editActionFrame.addHelpMenu("package.jmri.jmrit.conditional.StateVariableActionList", true);
        JPanel topPanel = this.makeTopPanel(this._editActionFrame, "TitleConsequentPhrase", 600, 160);
        Box panel1 = Box.createHorizontalBox();
        panel1.add(Box.createHorizontalGlue());
        this._actionItemBox = new JComboBox();
        Conditional.ItemType[] itemTypeArray = Conditional.ItemType.values();
        int n = itemTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Conditional.ItemType itemType = itemTypeArray[n2];
            this._actionItemBox.addItem(itemType);
            ++n2;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._actionItemBox);
        panel1.add(this.makeEditPanel(this._actionItemBox, "LabelActionItem", "ActionItemHint"));
        panel1.add(Box.createHorizontalStrut(10));
        this._actionNameField = new JTextField(30);
        this._actionNamePanel = this.makeEditPanel(this._actionNameField, "LabelItemName", null);
        this._actionNamePanel.setMaximumSize(new Dimension(50, this._actionNamePanel.getPreferredSize().height));
        this._actionNamePanel.setVisible(false);
        panel1.add(this._actionNamePanel);
        panel1.add(Box.createHorizontalStrut(10));
        if (this._parent._selectionMode == ConditionalEditBase.SelectionMode.USECOMBO) {
            this._comboNameBox = this._parent.createNameBox(Conditional.ItemType.SENSOR);
            this._actionComboNamePanel = this.makeEditPanel(this._comboNameBox, "LabelItemName", null);
            this._actionComboNamePanel.setVisible(false);
            panel1.add(this._actionComboNamePanel);
            panel1.add(Box.createHorizontalStrut(10));
        }
        this._actionTypeBox = new JComboBox();
        this._actionTypeBox.addItem(Conditional.Action.NONE);
        this._actionTypePanel = this.makeEditPanel(this._actionTypeBox, "LabelActionType", "ActionTypeHint");
        this._actionTypePanel.setVisible(false);
        panel1.add(this._actionTypePanel);
        panel1.add(Box.createHorizontalStrut(10));
        this._actionBox = new JComboBox();
        this._actionBox.addItem("");
        this._actionPanel = this.makeEditPanel(this._actionBox, "LabelActionType", "ActionTypeHint");
        this._actionPanel.setVisible(false);
        panel1.add(this._actionPanel);
        panel1.add(Box.createHorizontalStrut(10));
        this._shortActionString = new JTextField(15);
        this._shortTextPanel = this.makeEditPanel(this._shortActionString, "LabelActionText", null);
        this._shortTextPanel.setMaximumSize(new Dimension(25, this._shortTextPanel.getPreferredSize().height));
        this._shortTextPanel.add(Box.createVerticalGlue());
        this._shortTextPanel.setVisible(false);
        panel1.add(this._shortTextPanel);
        panel1.add(Box.createHorizontalStrut(10));
        this._actionOptionBox = new JComboBox();
        int i = 1;
        while (i <= 3) {
            this._actionOptionBox.addItem(DefaultConditionalAction.getOptionString(i, this._triggerOnChangeButton.isSelected()));
            ++i;
        }
        this._optionPanel = this.makeEditPanel(this._actionOptionBox, "LabelActionOption", "ActionOptionHint");
        this._optionPanel.setVisible(false);
        panel1.add(this._optionPanel);
        panel1.add(Box.createHorizontalStrut(10));
        panel1.add(Box.createHorizontalGlue());
        topPanel.add(panel1);
        topPanel.add(Box.createVerticalStrut(5));
        topPanel.add(Box.createVerticalGlue());
        Box panel2 = Box.createHorizontalBox();
        panel2.add(Box.createHorizontalGlue());
        this._setPanel = new JPanel();
        this._setPanel.setLayout(new BoxLayout(this._setPanel, 1));
        JPanel p = new JPanel();
        p.add(new JLabel(Bundle.getMessage("LabelActionFile")));
        this._setPanel.add(p);
        JButton _actionSetButton = new JButton("...");
        _actionSetButton.setMaximumSize(_actionSetButton.getPreferredSize());
        _actionSetButton.setToolTipText(Bundle.getMessage("FileButtonHint"));
        _actionSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalEditFrame.this.validateAction();
                ConditionalEditFrame.this.setFileLocation(e);
            }
        });
        this._setPanel.add(_actionSetButton);
        this._setPanel.add(Box.createVerticalGlue());
        this._setPanel.setVisible(false);
        panel2.add(this._setPanel);
        panel2.add(Box.createHorizontalStrut(5));
        this._longActionString = new JTextField(50);
        this._textPanel = this.makeEditPanel(this._longActionString, "LabelActionText", null);
        this._textPanel.setMaximumSize(new Dimension(80, this._textPanel.getPreferredSize().height));
        this._textPanel.add(Box.createVerticalGlue());
        this._textPanel.setVisible(false);
        panel2.add(this._textPanel);
        panel2.add(Box.createHorizontalGlue());
        topPanel.add(panel2);
        topPanel.add(Box.createVerticalStrut(5));
        topPanel.add(Box.createVerticalGlue());
        ActionListener updateListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalEditFrame.this.updateActionPressed();
            }
        };
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalEditFrame.this.cancelEditActionPressed();
            }
        };
        ActionListener deleteListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalEditFrame.this.deleteActionPressed();
            }
        };
        JPanel panel = this.makeButtonPanel(updateListener, cancelListener, deleteListener);
        topPanel.add(panel);
        topPanel.add(Box.createVerticalGlue());
        Container contentPane = this._editActionFrame.getContentPane();
        contentPane.add(topPanel);
        this._actionItemBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Conditional.ItemType newActionItem = ConditionalEditFrame.this._actionItemBox.getItemAt(ConditionalEditFrame.this._actionItemBox.getSelectedIndex());
                log.debug("_actionItemBox Listener: new = {}, curr = {}, row = {}", new Object[]{newActionItem, ConditionalEditFrame.this._curActionItem, ConditionalEditFrame.this._curActionRowNumber});
                if (newActionItem != ConditionalEditFrame.this._curActionItem) {
                    if (ConditionalEditFrame.this._curActionRowNumber >= 0) {
                        ConditionalEditFrame.this._curAction = new DefaultConditionalAction();
                        ConditionalEditFrame.this._actionList.set(ConditionalEditFrame.this._curActionRowNumber, ConditionalEditFrame.this._curAction);
                    }
                    ConditionalEditFrame.this._curActionItem = newActionItem;
                }
                ConditionalEditFrame.this._dataChanged = true;
                ConditionalEditFrame.this.actionItemChanged(newActionItem);
                ConditionalEditFrame.this._editActionFrame.pack();
            }
        });
        this._editActionFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConditionalEditFrame.this.cancelEditActionPressed();
            }
        });
        this._curActionItem = this._curAction.getType().getItemType();
        this.initializeActionVariables();
        this._dataChanged = false;
        this._editActionFrame.setVisible(true);
        this._editActionFrame.pack();
    }

    void loadSelectLogixBox(ConditionalVariable curVariable) {
        String lgxName;
        String cdlName = curVariable.getName();
        if (cdlName.length() == 0 || curVariable.getType() != Conditional.Type.CONDITIONAL_TRUE && curVariable.getType() != Conditional.Type.CONDITIONAL_FALSE) {
            lgxName = this._parent._curLogix.getSystemName();
        } else {
            Logix x = this._parent._conditionalManager.getParentLogix(cdlName);
            if (x == null) {
                log.error("Unable to find the Logix for {}, using the current Logix", (Object)cdlName);
                lgxName = this._parent._curLogix.getSystemName();
            } else {
                lgxName = x.getSystemName();
            }
        }
        this._selectLogixBox.removeAllItems();
        this._selectLogixMap.clear();
        String itemKey = "";
        for (Logix lgx : this._parent._logixManager.getNamedBeanSet()) {
            String sName = lgx.getSystemName();
            if (sName.equals("SYS")) continue;
            String uName = lgx.getUserName();
            String itemName = "";
            itemName = uName == null || uName.length() < 1 ? sName : String.valueOf(uName) + " ( " + sName + " )";
            this._selectLogixMap.put(itemName, sName);
            if (!lgxName.equals(sName)) continue;
            itemKey = itemName;
        }
        for (String item : this._selectLogixMap.keySet()) {
            this._selectLogixBox.addItem(item);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._selectLogixBox);
        this._selectLogixBox.setSelectedItem(itemKey);
        this.loadSelectConditionalBox(lgxName, curVariable);
    }

    void loadSelectConditionalBox(String logixName, ConditionalVariable curVariable) {
        String cdlName = curVariable.getName();
        this._selectConditionalBox.removeAllItems();
        this._selectConditionalList.clear();
        String itemKey = Bundle.getMessage("SelectFirstRow");
        this._selectConditionalBox.addItem(itemKey);
        this._selectConditionalList.add("-None-");
        Logix x = this._parent._logixManager.getBySystemName(logixName);
        if (x == null) {
            log.error("Logix '{}' not found while building the conditional list", (Object)logixName);
            return;
        }
        if (x.getNumConditionals() == 0) {
            return;
        }
        for (String cName : this._parent._conditionalManager.getSystemNameListForLogix(x)) {
            Conditional c = this._parent._conditionalManager.getConditional(cName);
            if (this._parent._curConditional.getSystemName().equals(c.getSystemName())) continue;
            String uName = c.getUserName();
            String itemName = "";
            itemName = uName == null || uName.length() < 1 ? cName : String.valueOf(uName) + " ( " + cName + " )";
            this._selectConditionalBox.addItem(itemName);
            this._selectConditionalList.add(cName);
            if (!cdlName.equals(cName)) continue;
            itemKey = itemName;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._selectConditionalBox);
        this._selectConditionalBox.setSelectedItem(itemKey);
    }

    void initializeActionVariables() {
        Conditional.Action actionType = this._curAction.getType();
        Conditional.ItemType itemType = actionType.getItemType();
        if (log.isDebugEnabled()) {
            log.debug("initializeActionVariables: itemType = {}, actionType = {}", (Object)itemType, (Object)actionType);
        }
        if (actionType == Conditional.Action.NONE) {
            return;
        }
        this._actionItemBox.setSelectedItem((Object)itemType);
        this._actionNameField.setText(this._curAction.getDeviceName());
        block0 : switch (itemType) {
            case SENSOR: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                if (actionType == Conditional.Action.RESET_DELAYED_SENSOR || actionType == Conditional.Action.DELAYED_SENSOR) {
                    this._shortActionString.setText(this._curAction.getActionString());
                }
                if (actionType != Conditional.Action.SET_SENSOR && actionType != Conditional.Action.DELAYED_SENSOR && actionType != Conditional.Action.RESET_DELAYED_SENSOR) break;
                if (this._curAction.getActionData() == 2) {
                    this._actionBox.setSelectedIndex(0);
                    break;
                }
                if (this._curAction.getActionData() == 4) {
                    this._actionBox.setSelectedIndex(1);
                    break;
                }
                if (this._curAction.getActionData() != 8) break;
                this._actionBox.setSelectedIndex(2);
                break;
            }
            case TURNOUT: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                if (actionType == Conditional.Action.RESET_DELAYED_TURNOUT || actionType == Conditional.Action.DELAYED_TURNOUT) {
                    this._shortActionString.setText(this._curAction.getActionString());
                }
                if (actionType == Conditional.Action.SET_TURNOUT || actionType == Conditional.Action.RESET_DELAYED_TURNOUT || actionType == Conditional.Action.DELAYED_TURNOUT) {
                    if (this._curAction.getActionData() == 2) {
                        this._actionBox.setSelectedIndex(0);
                        break;
                    }
                    if (this._curAction.getActionData() == 4) {
                        this._actionBox.setSelectedIndex(1);
                        break;
                    }
                    if (this._curAction.getActionData() != 8) break;
                    this._actionBox.setSelectedIndex(2);
                    break;
                }
                if (actionType != Conditional.Action.LOCK_TURNOUT) break;
                if (this._curAction.getActionData() == 0) {
                    this._actionBox.setSelectedIndex(0);
                    break;
                }
                if (this._curAction.getActionData() == 1) {
                    this._actionBox.setSelectedIndex(1);
                    break;
                }
                if (this._curAction.getActionData() != 8) break;
                this._actionBox.setSelectedIndex(2);
                break;
            }
            case LIGHT: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                if (actionType == Conditional.Action.SET_LIGHT) {
                    if (this._curAction.getActionData() == 2) {
                        this._actionBox.setSelectedIndex(0);
                        break;
                    }
                    if (this._curAction.getActionData() == 4) {
                        this._actionBox.setSelectedIndex(1);
                        break;
                    }
                    if (this._curAction.getActionData() != 8) break;
                    this._actionBox.setSelectedIndex(2);
                    break;
                }
                if (actionType != Conditional.Action.SET_LIGHT_INTENSITY && actionType != Conditional.Action.SET_LIGHT_TRANSITION_TIME) break;
                this._shortActionString.setText(this._curAction.getActionString());
                break;
            }
            case CLOCK: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                if (actionType != Conditional.Action.SET_FAST_CLOCK_TIME) break;
                int time = this._curAction.getActionData();
                this._longActionString.setText(ConditionalEditBase.formatTime(time / 60, time - time / 60 * 60));
                this._actionNameField.setText("");
                break;
            }
            case MEMORY: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                this._shortActionString.setText(this._curAction.getActionString());
                break;
            }
            case WARRANT: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                if (actionType == Conditional.Action.CONTROL_TRAIN) {
                    if (this._curAction.getActionData() == 1) {
                        this._actionBox.setSelectedIndex(0);
                        break;
                    }
                    if (this._curAction.getActionData() == 2) {
                        this._actionBox.setSelectedIndex(1);
                        break;
                    }
                    if (this._curAction.getActionData() != 3) break;
                    this._actionBox.setSelectedIndex(2);
                    break;
                }
                if (actionType != Conditional.Action.SET_TRAIN_ID && actionType != Conditional.Action.SET_TRAIN_NAME && actionType != Conditional.Action.THROTTLE_FACTOR) break;
                this._shortActionString.setText(this._curAction.getActionString());
                break;
            }
            case OBLOCK: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                if (actionType != Conditional.Action.SET_BLOCK_VALUE) break;
                this._shortActionString.setText(this._curAction.getActionString());
                break;
            }
            case ENTRYEXIT: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                this._actionNameField.setText(this._curAction.getBean().getUserName());
                break;
            }
            case AUDIO: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                if (actionType == Conditional.Action.PLAY_SOUND) {
                    this._longActionString.setText(this._curAction.getActionString());
                    break;
                }
                if (actionType != Conditional.Action.CONTROL_AUDIO) break;
                switch (this._curAction.getActionData()) {
                    case 64: {
                        this._actionBox.setSelectedIndex(0);
                        break block0;
                    }
                    case 65: {
                        this._actionBox.setSelectedIndex(1);
                        break block0;
                    }
                    case 66: {
                        this._actionBox.setSelectedIndex(2);
                        break block0;
                    }
                    case 67: {
                        this._actionBox.setSelectedIndex(3);
                        break block0;
                    }
                    case 68: {
                        this._actionBox.setSelectedIndex(4);
                        break block0;
                    }
                    case 69: {
                        this._actionBox.setSelectedIndex(5);
                        break block0;
                    }
                    case 70: {
                        this._actionBox.setSelectedIndex(6);
                        break block0;
                    }
                    case 71: {
                        this._actionBox.setSelectedIndex(7);
                        break block0;
                    }
                    case 72: {
                        this._actionBox.setSelectedIndex(8);
                        break block0;
                    }
                    case 73: {
                        this._actionBox.setSelectedIndex(9);
                        break block0;
                    }
                }
                log.warn("Unexpected _curAction.getActionData() of {}", (Object)this._curAction.getActionData());
                break;
            }
            case SCRIPT: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                if (actionType == Conditional.Action.RUN_SCRIPT) {
                    this._longActionString.setText(this._curAction.getActionString());
                    break;
                }
                if (actionType != Conditional.Action.JYTHON_COMMAND) break;
                this._shortActionString.setText(this._curAction.getActionString());
                break;
            }
            case SIGNALHEAD: 
            case SIGNALMAST: 
            case LOGIX: 
            case OTHER: {
                this._actionTypeBox.setSelectedItem((Object)actionType);
                break;
            }
            default: {
                log.error("Unhandled type: {}", (Object)itemType);
            }
        }
        this._actionOptionBox.setSelectedIndex(this._curAction.getOption() - 1);
        this._editActionFrame.pack();
        this._editActionFrame.transferFocusBackward();
    }

    void actionItemChanged(Conditional.ItemType type) {
        Conditional.Action actionType = this._curAction.getType();
        if (log.isDebugEnabled()) {
            log.debug("actionItemChanged: itemType = {}, actionType = {}", (Object)type, (Object)actionType);
        }
        this._actionTypeBox.removeActionListener(this._actionTypeListener);
        this._actionTypePanel.setVisible(false);
        this._setPanel.setVisible(false);
        this._shortTextPanel.setVisible(false);
        this._shortActionString.setText("");
        this._textPanel.setVisible(false);
        this._longActionString.setText("");
        this._actionNamePanel.setVisible(false);
        this._actionPanel.setVisible(false);
        this._optionPanel.setVisible(false);
        Conditional.ItemType itemType = actionType.getItemType();
        if (type == Conditional.ItemType.NONE && itemType == Conditional.ItemType.NONE) {
            return;
        }
        this._actionTypePanel.setVisible(true);
        this._actionTypeBox.removeAllItems();
        this._actionBox.removeAllItems();
        if (type != Conditional.ItemType.NONE) {
            itemType = type;
        }
        if (itemType != actionType.getItemType()) {
            actionType = Conditional.Action.NONE;
        }
        if (actionType != Conditional.Action.NONE) {
            this._optionPanel.setVisible(true);
        }
        this._actionTypeBox.addItem(Conditional.Action.NONE);
        this._actionNameField.removeActionListener(this.actionSignalHeadNameListener);
        this._actionNameField.removeActionListener(this.actionSignalMastNameListener);
        if (this._parent._selectionMode == ConditionalEditBase.SelectionMode.USECOMBO) {
            this._actionComboNamePanel.setVisible(false);
        } else if (this._parent._selectionMode == ConditionalEditBase.SelectionMode.USESINGLE) {
            this._parent.createSinglePanelPickList(itemType, this._parent.getPickSingleListener(this._actionNameField, itemType), true);
        } else {
            this._parent.setPickListTab(itemType, true);
        }
        switch (itemType) {
            case TURNOUT: {
                for (Conditional.Action action : Conditional.Action.getTurnoutItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.RESET_DELAYED_TURNOUT || actionType == Conditional.Action.DELAYED_TURNOUT) {
                    JPanel p = (JPanel)this._shortTextPanel.getComponent(0);
                    JLabel l = (JLabel)p.getComponent(0);
                    l.setText(Bundle.getMessage("LabelDelayTime"));
                    this._shortTextPanel.setToolTipText(Bundle.getMessage("DataHintDelayedTurnout"));
                    this._shortTextPanel.setVisible(true);
                }
                JPanel panel = (JPanel)this._actionPanel.getComponent(0);
                JLabel label = (JLabel)panel.getComponent(0);
                if (actionType == Conditional.Action.SET_TURNOUT || actionType == Conditional.Action.RESET_DELAYED_TURNOUT || actionType == Conditional.Action.DELAYED_TURNOUT) {
                    label.setText(Bundle.getMessage("LabelActionTurnout"));
                    this._actionBox.addItem(Bundle.getMessage("TurnoutStateClosed"));
                    this._actionBox.addItem(Bundle.getMessage("TurnoutStateThrown"));
                    this._actionBox.addItem(Bundle.getMessage("Toggle"));
                    this._actionPanel.setToolTipText(Bundle.getMessage("TurnoutSetHint"));
                    this._actionPanel.setVisible(true);
                } else if (actionType == Conditional.Action.LOCK_TURNOUT) {
                    label.setText(Bundle.getMessage("LabelActionLock"));
                    this._actionBox.addItem(Bundle.getMessage("TurnoutUnlock"));
                    this._actionBox.addItem(Bundle.getMessage("TurnoutLock"));
                    this._actionBox.addItem(Bundle.getMessage("Toggle"));
                    this._actionPanel.setToolTipText(Bundle.getMessage("LockSetHint"));
                    this._actionPanel.setVisible(true);
                }
                this._actionNamePanel.setToolTipText(Bundle.getMessage("NameHintTurnout"));
                this._actionNamePanel.setVisible(true);
                this.setActionNameBox(itemType);
                break;
            }
            case SENSOR: {
                JLabel l;
                JPanel p;
                for (Conditional.Action action : Conditional.Action.getSensorItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.RESET_DELAYED_SENSOR || actionType == Conditional.Action.DELAYED_SENSOR) {
                    p = (JPanel)this._shortTextPanel.getComponent(0);
                    l = (JLabel)p.getComponent(0);
                    l.setText(Bundle.getMessage("LabelDelayTime"));
                    this._shortTextPanel.setToolTipText(Bundle.getMessage("DataHintDelayedTurnout"));
                    this._shortTextPanel.setVisible(true);
                }
                if (actionType == Conditional.Action.SET_SENSOR || actionType == Conditional.Action.RESET_DELAYED_SENSOR || actionType == Conditional.Action.DELAYED_SENSOR) {
                    p = (JPanel)this._actionPanel.getComponent(0);
                    l = (JLabel)p.getComponent(0);
                    l.setText(Bundle.getMessage("LabelActionSensor"));
                    this._actionBox.addItem(Bundle.getMessage("SensorStateActive"));
                    this._actionBox.addItem(Bundle.getMessage("SensorStateInactive"));
                    this._actionBox.addItem(Bundle.getMessage("Toggle"));
                    this._actionPanel.setToolTipText(Bundle.getMessage("SensorSetHint"));
                    this._actionPanel.setVisible(true);
                }
                this._actionNamePanel.setToolTipText(Bundle.getMessage("NameHintSensor"));
                this._actionNamePanel.setVisible(true);
                this.setActionNameBox(itemType);
                break;
            }
            case SIGNALHEAD: {
                for (Conditional.Action action : Conditional.Action.getSignalHeadItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.SET_SIGNAL_APPEARANCE) {
                    JPanel p = (JPanel)this._actionPanel.getComponent(0);
                    JLabel l = (JLabel)p.getComponent(0);
                    l.setText(Bundle.getMessage("LabelActionSignal"));
                    this.loadJComboBoxWithHeadAppearances(this._actionBox, this._actionNameField.getText().trim());
                    this._actionBox.setSelectedItem(this._curAction.getActionDataString());
                    this._actionPanel.setToolTipText(Bundle.getMessage("SignalSetHint"));
                    this._actionPanel.setVisible(true);
                }
                this._actionNamePanel.setToolTipText(Bundle.getMessage("NameHintSignal"));
                this._actionNamePanel.setVisible(true);
                this.setActionNameBox(itemType);
                this._actionNameField.addActionListener(this.actionSignalHeadNameListener);
                break;
            }
            case SIGNALMAST: {
                for (Conditional.Action action : Conditional.Action.getSignalMastItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.SET_SIGNALMAST_ASPECT) {
                    JPanel p = (JPanel)this._actionPanel.getComponent(0);
                    JLabel l = (JLabel)p.getComponent(0);
                    l.setText(Bundle.getMessage("LabelSignalAspect"));
                    this.loadJComboBoxWithMastAspects(this._actionBox, this._actionNameField.getText().trim());
                    this._actionBox.setSelectedItem(this._curAction.getActionString());
                    this._actionPanel.setToolTipText(Bundle.getMessage("SignalMastSetHint"));
                    this._actionPanel.setVisible(true);
                }
                this._actionNamePanel.setToolTipText(Bundle.getMessage("NameHintSignalMast"));
                this._actionNamePanel.setVisible(true);
                this.setActionNameBox(itemType);
                this._actionNameField.addActionListener(this.actionSignalMastNameListener);
                break;
            }
            case LIGHT: {
                Object l;
                JPanel p;
                for (Conditional.Action action : Conditional.Action.getLightItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.SET_LIGHT_INTENSITY) {
                    p = (JPanel)this._shortTextPanel.getComponent(0);
                    l = (JLabel)p.getComponent(0);
                    ((JLabel)l).setText(Bundle.getMessage("LabelLightIntensity"));
                    this._shortTextPanel.setToolTipText(Bundle.getMessage("DataHintLightIntensity"));
                    this._shortTextPanel.setVisible(true);
                } else if (actionType == Conditional.Action.SET_LIGHT_TRANSITION_TIME) {
                    p = (JPanel)this._shortTextPanel.getComponent(0);
                    l = (JLabel)p.getComponent(0);
                    ((JLabel)l).setText(Bundle.getMessage("LabelTransitionTime"));
                    this._shortTextPanel.setToolTipText(Bundle.getMessage("DataHintLightTransitionTime"));
                    this._shortTextPanel.setVisible(true);
                } else if (actionType == Conditional.Action.SET_LIGHT) {
                    p = (JPanel)this._actionPanel.getComponent(0);
                    l = (JLabel)p.getComponent(0);
                    ((JLabel)l).setText(Bundle.getMessage("LabelActionLight"));
                    this._actionBox.addItem(Bundle.getMessage("LightOn"));
                    this._actionBox.addItem(Bundle.getMessage("LightOff"));
                    this._actionBox.addItem(Bundle.getMessage("Toggle"));
                    this._actionPanel.setToolTipText(Bundle.getMessage("LightSetHint"));
                    this._actionPanel.setVisible(true);
                }
                this._actionNamePanel.setToolTipText(Bundle.getMessage("NameHintLight"));
                this._actionNamePanel.setVisible(true);
                this.setActionNameBox(itemType);
                break;
            }
            case MEMORY: {
                for (Conditional.Action action : Conditional.Action.getMemoryItems()) {
                    this._actionTypeBox.addItem(action);
                }
                JPanel p = (JPanel)this._shortTextPanel.getComponent(0);
                JLabel l = (JLabel)p.getComponent(0);
                if (actionType == Conditional.Action.COPY_MEMORY) {
                    this._shortTextPanel.setToolTipText(Bundle.getMessage("DataHintToMemory"));
                    l.setText(Bundle.getMessage("LabelMemoryLocation"));
                } else {
                    this._shortTextPanel.setToolTipText(Bundle.getMessage("DataHintMemory"));
                    l.setText(Bundle.getMessage("LabelValue"));
                }
                this._shortTextPanel.setVisible(true);
                this._actionNamePanel.setToolTipText(Bundle.getMessage("NameHintMemory"));
                this._actionNamePanel.setVisible(true);
                this.setActionNameBox(itemType);
                break;
            }
            case CLOCK: {
                for (Conditional.Action action : Conditional.Action.getClockItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType != Conditional.Action.SET_FAST_CLOCK_TIME) break;
                JPanel p = (JPanel)this._textPanel.getComponent(0);
                JLabel l = (JLabel)p.getComponent(0);
                l.setText(Bundle.getMessage("LabelSetTime"));
                this._textPanel.setToolTipText(Bundle.getMessage("DataHintTime"));
                this._textPanel.setVisible(true);
                break;
            }
            case LOGIX: {
                for (Conditional.Action action : Conditional.Action.getLogixItems()) {
                    this._actionTypeBox.addItem(action);
                }
                this._actionNamePanel.setToolTipText(Bundle.getMessage("NameHintLogix"));
                this._actionNamePanel.setVisible(true);
                this.setActionNameBox(itemType);
                break;
            }
            case WARRANT: {
                for (Conditional.Action action : Conditional.Action.getWarrantItems()) {
                    this._actionTypeBox.addItem(action);
                }
                this._actionNamePanel.setToolTipText(Bundle.getMessage("NameHintWarrant"));
                this._actionNamePanel.setVisible(true);
                if (actionType == Conditional.Action.CONTROL_TRAIN) {
                    JPanel p = (JPanel)this._actionPanel.getComponent(0);
                    JLabel l = (JLabel)p.getComponent(0);
                    this._actionBox.addItem(Bundle.getMessage("WarrantHalt"));
                    this._actionBox.addItem(Bundle.getMessage("WarrantResume"));
                    this._actionBox.addItem(Bundle.getMessage("WarrantAbort"));
                    l.setText(Bundle.getMessage("LabelControlTrain"));
                    this._actionPanel.setVisible(true);
                } else if (actionType == Conditional.Action.SET_TRAIN_ID || actionType == Conditional.Action.SET_TRAIN_NAME || actionType == Conditional.Action.THROTTLE_FACTOR) {
                    JPanel p = (JPanel)this._shortTextPanel.getComponent(0);
                    JLabel l = (JLabel)p.getComponent(0);
                    if (actionType == Conditional.Action.SET_TRAIN_ID) {
                        this._shortTextPanel.setToolTipText(Bundle.getMessage("DataHintTrainId"));
                        l.setText(Bundle.getMessage("LabelTrainId"));
                    } else if (actionType == Conditional.Action.SET_TRAIN_NAME) {
                        this._shortTextPanel.setToolTipText(Bundle.getMessage("DataHintTrainName"));
                        l.setText(Bundle.getMessage("LabelTrainName"));
                    } else {
                        this._shortTextPanel.setToolTipText(Bundle.getMessage("DataHintThrottleFactor"));
                        l.setText(Bundle.getMessage("LabelThrottleFactor"));
                    }
                    this._shortTextPanel.setVisible(true);
                }
                this.setActionNameBox(itemType);
                break;
            }
            case OBLOCK: {
                for (Conditional.Action action : Conditional.Action.getOBlockItems()) {
                    this._actionTypeBox.addItem(action);
                }
                this._actionNamePanel.setToolTipText(Bundle.getMessage("NameHintOBlock"));
                this._actionNamePanel.setVisible(true);
                if (actionType == Conditional.Action.SET_BLOCK_VALUE) {
                    JPanel p = (JPanel)this._shortTextPanel.getComponent(0);
                    JLabel l = (JLabel)p.getComponent(0);
                    this._shortTextPanel.setToolTipText(Bundle.getMessage("DataHintBlockValue"));
                    l.setText(Bundle.getMessage("LabelBlockValue"));
                    this._shortTextPanel.setVisible(true);
                }
                this.setActionNameBox(itemType);
                break;
            }
            case ENTRYEXIT: {
                for (Conditional.Action action : Conditional.Action.getEntryExitItems()) {
                    this._actionTypeBox.addItem(action);
                }
                this._actionNamePanel.setToolTipText(Bundle.getMessage("NameHintEntryExit"));
                this._actionNamePanel.setVisible(true);
                this.setActionNameBox(itemType);
                break;
            }
            case AUDIO: {
                for (Conditional.Action action : Conditional.Action.getAudioItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.PLAY_SOUND) {
                    JPanel p = (JPanel)this._textPanel.getComponent(0);
                    JLabel l = (JLabel)p.getComponent(0);
                    l.setText(Bundle.getMessage("LabelSetFile"));
                    this._textPanel.setToolTipText(Bundle.getMessage("SetHintSound"));
                    this._textPanel.setVisible(true);
                    this._setPanel.setVisible(true);
                    break;
                }
                if (actionType != Conditional.Action.CONTROL_AUDIO) break;
                JPanel p = (JPanel)this._actionPanel.getComponent(0);
                JLabel l = (JLabel)p.getComponent(0);
                l.setText(Bundle.getMessage("LabelActionAudio"));
                this._actionBox.addItem(Bundle.getMessage("AudioSourcePlay"));
                this._actionBox.addItem(Bundle.getMessage("AudioSourceStop"));
                this._actionBox.addItem(Bundle.getMessage("AudioSourcePlayToggle"));
                this._actionBox.addItem(Bundle.getMessage("AudioSourcePause"));
                this._actionBox.addItem(Bundle.getMessage("AudioSourceResume"));
                this._actionBox.addItem(Bundle.getMessage("AudioSourcePauseToggle"));
                this._actionBox.addItem(Bundle.getMessage("AudioSourceRewind"));
                this._actionBox.addItem(Bundle.getMessage("AudioSourceFadeIn"));
                this._actionBox.addItem(Bundle.getMessage("AudioSourceFadeOut"));
                this._actionBox.addItem(Bundle.getMessage("AudioResetPosition"));
                this._actionPanel.setToolTipText(Bundle.getMessage("SetHintAudio"));
                this._actionPanel.setVisible(true);
                this._actionNamePanel.setToolTipText(Bundle.getMessage("NameHintAudio"));
                this._actionNamePanel.setVisible(true);
                break;
            }
            case SCRIPT: {
                for (Conditional.Action action : Conditional.Action.getScriptItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType == Conditional.Action.RUN_SCRIPT) {
                    JPanel p = (JPanel)this._textPanel.getComponent(0);
                    JLabel l = (JLabel)p.getComponent(0);
                    l.setText(Bundle.getMessage("LabelSetFile"));
                    this._textPanel.setToolTipText(Bundle.getMessage("SetHintScript"));
                    this._textPanel.setVisible(true);
                    this._setPanel.setVisible(true);
                    break;
                }
                if (actionType != Conditional.Action.JYTHON_COMMAND) break;
                JPanel p = (JPanel)this._shortTextPanel.getComponent(0);
                JLabel l = (JLabel)p.getComponent(0);
                l.setText(Bundle.getMessage("LabelScriptCommand"));
                this._shortTextPanel.setToolTipText(Bundle.getMessage("SetHintJythonCmd"));
                this._shortTextPanel.setVisible(true);
                break;
            }
            case OTHER: {
                for (Conditional.Action action : Conditional.Action.getOtherItems()) {
                    this._actionTypeBox.addItem(action);
                }
                if (actionType != Conditional.Action.TRIGGER_ROUTE) break;
                this._actionNamePanel.setToolTipText(Bundle.getMessage("NameHintRoute"));
                this._actionNamePanel.setVisible(true);
                this.setActionNameBox(itemType);
                break;
            }
        }
        this._actionTypeBox.setMaximumSize(this._actionTypeBox.getPreferredSize());
        this._actionBox.setMaximumSize(this._actionBox.getPreferredSize());
        this._actionTypeListener.setItemType(itemType);
        this._actionTypeBox.addActionListener(this._actionTypeListener);
        this._editActionFrame.pack();
    }

    void setActionNameBox(Conditional.ItemType itemType) {
        if (this._parent._selectionMode != ConditionalEditBase.SelectionMode.USECOMBO) {
            return;
        }
        this._comboNameBox = this._parent.createNameBox(itemType);
        if (this._comboNameBox == null) {
            return;
        }
        this._comboNameBox.setSelectedItemByName(this._curAction.getDeviceName());
        this._comboNameBox.addActionListener(new ConditionalEditBase.NameBoxListener(this._actionNameField));
        this._actionComboNamePanel.remove(1);
        this._actionComboNamePanel.add(this._comboNameBox, null, 1);
        this._actionNamePanel.setVisible(false);
        this._actionComboNamePanel.setVisible(true);
    }

    void updateActionPressed() {
        if (!this.validateAction()) {
            this._editActionFrame.toFront();
            return;
        }
        this._actionTableModel.fireTableRowsUpdated(this._curActionRowNumber, this._curActionRowNumber);
        this.cleanUpAction();
    }

    void cancelEditActionPressed() {
        if (this._newItem) {
            this.deleteActionPressed(this._curActionRowNumber);
        } else {
            this.cleanUpAction();
        }
    }

    void cleanUpAction() {
        this._newItem = false;
        if (this._editActionFrame != null) {
            this._actionTypeBox.removeActionListener(this._actionTypeListener);
            this._editActionFrame.setVisible(false);
            this._editActionFrame.dispose();
            this._editActionFrame = null;
            this._parent.closeSinglePanelPickList();
        }
        this._curActionRowNumber = -1;
    }

    void deleteActionPressed() {
        this.deleteActionPressed(this._curActionRowNumber);
    }

    void deleteActionPressed(int row) {
        if (row != this._curActionRowNumber && this.alreadyEditingActionOrVariable()) {
            return;
        }
        this._actionList.remove(row);
        this._actionTableModel.fireTableRowsDeleted(row, row);
        this.cleanUpAction();
        this._dataChanged = true;
    }

    void setFileLocation(ActionEvent e) {
        JFileChooser currentChooser;
        ConditionalAction action = (ConditionalAction)this._actionList.get(this._curActionRowNumber);
        Conditional.Action actionType = action.getType();
        if (actionType == Conditional.Action.PLAY_SOUND) {
            if (this.sndFileChooser == null) {
                this.sndFileChooser = new JFileChooser(String.valueOf(System.getProperty("user.dir")) + File.separator + "resources" + File.separator + "sounds");
                this.sndFileChooser.setFileFilter(new FileNameExtensionFilter("wav sound files", "wav"));
            }
            currentChooser = this.sndFileChooser;
        } else if (actionType == Conditional.Action.RUN_SCRIPT) {
            if (this.scriptFileChooser == null) {
                this.scriptFileChooser = new JFileChooser(FileUtil.getScriptsPath());
                this.scriptFileChooser.setFileFilter(new FileNameExtensionFilter("Python script files", "py"));
            }
            currentChooser = this.scriptFileChooser;
        } else {
            log.warn("Unexpected actionType[{}] = {}", (Object)actionType.name(), (Object)actionType.toString());
            if (this.defaultFileChooser == null) {
                this.defaultFileChooser = new JFileChooser(FileUtil.getUserFilesPath());
                this.defaultFileChooser.setFileFilter(new NoArchiveFileFilter());
            }
            currentChooser = this.defaultFileChooser;
        }
        currentChooser.rescanCurrentDirectory();
        int retVal = currentChooser.showOpenDialog(null);
        if (retVal == 0) {
            try {
                this._longActionString.setText(FileUtil.getPortableFilename(currentChooser.getSelectedFile().getCanonicalPath()));
            }
            catch (IOException ex) {
                if (log.isDebugEnabled()) {
                    log.error("exception setting file location: {}", (Throwable)ex);
                }
                this._longActionString.setText("");
            }
        }
    }

    boolean validateAction() {
        Conditional.ItemType itemType = this._actionItemBox.getItemAt(this._actionItemBox.getSelectedIndex());
        Conditional.Action actionType = Conditional.Action.NONE;
        Conditional.Action selection = this._actionTypeBox.getItemAt(this._actionTypeBox.getSelectedIndex());
        if (selection == Conditional.Action.NONE) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("makeSelection"), Bundle.getMessage("WarningTitle"), 2);
            return false;
        }
        String name = this._actionNameField.getText().trim();
        String actionString = this._shortActionString.getText().trim();
        this._dataChanged = true;
        this._curAction.setActionString("");
        this._curAction.setActionData(-1);
        if (!this.checkReferenceByMemory(name)) {
            return false;
        }
        if (!this.checkIsVariable(name, itemType)) {
            return false;
        }
        block0 : switch (itemType) {
            case SENSOR: {
                if (!this._referenceByMemory && (name = this._parent.validateSensorReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                if (actionType == Conditional.Action.RESET_DELAYED_SENSOR || actionType == Conditional.Action.DELAYED_SENSOR) {
                    if (!this._parent.validateTimeReference(actionType, actionString)) {
                        return false;
                    }
                    this._curAction.setActionString(actionString);
                }
                if (actionType == Conditional.Action.SET_SENSOR || actionType == Conditional.Action.RESET_DELAYED_SENSOR || actionType == Conditional.Action.DELAYED_SENSOR) {
                    if (this._actionBox.getSelectedIndex() == 0) {
                        this._curAction.setActionData(2);
                    } else if (this._actionBox.getSelectedIndex() == 1) {
                        this._curAction.setActionData(4);
                    } else {
                        this._curAction.setActionData(8);
                    }
                }
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                break;
            }
            case TURNOUT: {
                if (!this._referenceByMemory && (name = this._parent.validateTurnoutReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                if (actionType == Conditional.Action.RESET_DELAYED_TURNOUT || actionType == Conditional.Action.DELAYED_TURNOUT) {
                    if (!this._parent.validateTimeReference(actionType, actionString)) {
                        return false;
                    }
                    this._curAction.setActionString(actionString);
                }
                if (actionType == Conditional.Action.SET_TURNOUT || actionType == Conditional.Action.RESET_DELAYED_TURNOUT || actionType == Conditional.Action.DELAYED_TURNOUT) {
                    if (this._actionBox.getSelectedIndex() == 0) {
                        this._curAction.setActionData(2);
                    } else if (this._actionBox.getSelectedIndex() == 1) {
                        this._curAction.setActionData(4);
                    } else {
                        this._curAction.setActionData(8);
                    }
                } else if (actionType == Conditional.Action.LOCK_TURNOUT) {
                    if (this._actionBox.getSelectedIndex() == 0) {
                        this._curAction.setActionData(0);
                    } else if (this._actionBox.getSelectedIndex() == 1) {
                        this._curAction.setActionData(1);
                    } else {
                        this._curAction.setActionData(8);
                    }
                }
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                break;
            }
            case LIGHT: {
                if (!this._referenceByMemory && (name = this._parent.validateLightReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                if (actionType == Conditional.Action.SET_LIGHT_INTENSITY) {
                    Light lgtx = this._parent.getLight(name);
                    if (lgtx == null) {
                        return false;
                    }
                    if (!(lgtx instanceof VariableLight)) {
                        JOptionPane.showMessageDialog(this, Bundle.getMessage("Error45", name), Bundle.getMessage("ErrorTitle"), 0);
                        return false;
                    }
                    if (!this._parent.validateIntensityReference(actionType, actionString)) {
                        return false;
                    }
                    this._curAction.setActionString(actionString);
                } else if (actionType == Conditional.Action.SET_LIGHT_TRANSITION_TIME) {
                    Light lgtx = this._parent.getLight(name);
                    if (lgtx == null) {
                        return false;
                    }
                    if (!(lgtx instanceof VariableLight) || !((VariableLight)lgtx).isTransitionAvailable()) {
                        JOptionPane.showMessageDialog(this, Bundle.getMessage("Error40", name), Bundle.getMessage("ErrorTitle"), 0);
                        return false;
                    }
                    if (!this._parent.validateTimeReference(actionType, actionString)) {
                        return false;
                    }
                    this._curAction.setActionString(actionString);
                } else if (actionType == Conditional.Action.SET_LIGHT) {
                    if (this._actionBox.getSelectedIndex() == 0) {
                        this._curAction.setActionData(2);
                    } else if (this._actionBox.getSelectedIndex() == 1) {
                        this._curAction.setActionData(4);
                    } else {
                        this._curAction.setActionData(8);
                    }
                }
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                break;
            }
            case SIGNALHEAD: {
                if (!this._referenceByMemory && (name = this._parent.validateSignalHeadReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                if (actionType == Conditional.Action.SET_SIGNAL_APPEARANCE) {
                    String appStr = (String)this._actionBox.getSelectedItem();
                    this._curAction.setActionData(DefaultConditionalAction.stringToActionData(appStr));
                    this._curAction.setActionString(appStr);
                }
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                break;
            }
            case SIGNALMAST: {
                if (!this._referenceByMemory && (name = this._parent.validateSignalMastReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                if (actionType == Conditional.Action.SET_SIGNALMAST_ASPECT) {
                    this._curAction.setActionString((String)this._actionBox.getSelectedItem());
                }
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                break;
            }
            case MEMORY: {
                if (this._referenceByMemory) {
                    JOptionPane.showMessageDialog(this._editActionFrame, Bundle.getMessage("Warn6"), Bundle.getMessage("WarningTitle"), 2);
                    return false;
                }
                if ((name = this._parent.validateMemoryReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                if (actionType == Conditional.Action.COPY_MEMORY && (actionString = this._parent.validateMemoryReference(actionString)) == null) {
                    return false;
                }
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                this._curAction.setActionString(actionString);
                break;
            }
            case LOGIX: {
                if (!this._referenceByMemory && (name = this._parent.validateLogixReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                break;
            }
            case WARRANT: {
                if (!this._referenceByMemory && (name = this._parent.validateWarrantReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                if (actionType == Conditional.Action.CONTROL_TRAIN) {
                    if (this._actionBox.getSelectedIndex() == 0) {
                        this._curAction.setActionData(1);
                        break;
                    }
                    if (this._actionBox.getSelectedIndex() == 1) {
                        this._curAction.setActionData(2);
                        break;
                    }
                    this._curAction.setActionData(3);
                    break;
                }
                if (actionType != Conditional.Action.SET_TRAIN_ID && actionType != Conditional.Action.SET_TRAIN_NAME && actionType != Conditional.Action.THROTTLE_FACTOR) break;
                this._curAction.setActionString(actionString);
                break;
            }
            case OBLOCK: {
                if (!this._referenceByMemory && (name = this._parent.validateOBlockReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                if (actionType != Conditional.Action.SET_BLOCK_VALUE) break;
                this._curAction.setActionString(actionString);
                break;
            }
            case ENTRYEXIT: {
                if (!this._referenceByMemory && (name = this._parent.validateEntryExitReference(name)) == null) {
                    return false;
                }
                actionType = selection;
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                break;
            }
            case CLOCK: {
                actionType = selection;
                if (actionType != Conditional.Action.SET_FAST_CLOCK_TIME) break;
                int time = this._parent.parseTime(this._longActionString.getText().trim());
                if (time < 0) {
                    return false;
                }
                this._curAction.setActionData(time);
                break;
            }
            case AUDIO: {
                actionType = selection;
                if (actionType == Conditional.Action.PLAY_SOUND) {
                    this._curAction.setActionString(this._longActionString.getText().trim());
                    break;
                }
                if (actionType != Conditional.Action.CONTROL_AUDIO) break;
                if (!this._referenceByMemory && (name = this._parent.validateAudioReference(name)) == null) {
                    return false;
                }
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                switch (this._actionBox.getSelectedIndex()) {
                    case 0: {
                        this._curAction.setActionData(64);
                        break block0;
                    }
                    case 1: {
                        this._curAction.setActionData(65);
                        break block0;
                    }
                    case 2: {
                        this._curAction.setActionData(66);
                        break block0;
                    }
                    case 3: {
                        this._curAction.setActionData(67);
                        break block0;
                    }
                    case 4: {
                        this._curAction.setActionData(68);
                        break block0;
                    }
                    case 5: {
                        this._curAction.setActionData(69);
                        break block0;
                    }
                    case 6: {
                        this._curAction.setActionData(70);
                        break block0;
                    }
                    case 7: {
                        this._curAction.setActionData(71);
                        break block0;
                    }
                    case 8: {
                        this._curAction.setActionData(72);
                        break block0;
                    }
                    case 9: {
                        this._curAction.setActionData(73);
                        break block0;
                    }
                }
                log.warn("Unexpected _actionBox.getSelectedIndex() of {}", (Object)this._actionBox.getSelectedIndex());
                break;
            }
            case SCRIPT: {
                actionType = selection;
                if (actionType == Conditional.Action.RUN_SCRIPT) {
                    this._curAction.setActionString(this._longActionString.getText().trim());
                    break;
                }
                if (actionType != Conditional.Action.JYTHON_COMMAND) break;
                this._curAction.setActionString(this._shortActionString.getText().trim());
                break;
            }
            case OTHER: {
                actionType = selection;
                if (actionType != Conditional.Action.TRIGGER_ROUTE) break;
                if (!this._referenceByMemory && (name = this._parent.validateRouteReference(name)) == null) {
                    return false;
                }
                this._actionNameField.setText(name);
                this._curAction.setDeviceName(name);
                break;
            }
        }
        this._curAction.setType(actionType);
        if (actionType != Conditional.Action.NONE) {
            this._curAction.setOption(this._actionOptionBox.getSelectedIndex() + 1);
        } else {
            this._curAction.setOption(0);
        }
        this._editActionFrame.pack();
        return true;
    }

    public class ActionTableModel
    extends AbstractTableModel {
        public static final int DESCRIPTION_COLUMN = 0;
        public static final int EDIT_COLUMN = 1;
        public static final int DELETE_COLUMN = 2;

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 1 || c == 2) {
                return JButton.class;
            }
            return super.getColumnClass(c);
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return ConditionalEditFrame.this._actionList.size();
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            if (c == 0) {
                return false;
            }
            return !ConditionalEditFrame.this._inActReorder || c != 1 && r >= ConditionalEditFrame.this._nextInOrder;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return Bundle.getMessage("LabelActionDescription");
            }
            return "";
        }

        public int getPreferredWidth(int col) {
            if (col == 0) {
                return 800;
            }
            return 20;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= ConditionalEditFrame.this._actionList.size()) {
                return null;
            }
            switch (col) {
                case 0: {
                    ConditionalAction action = (ConditionalAction)ConditionalEditFrame.this._actionList.get(row);
                    return action.description(ConditionalEditFrame.this._triggerOnChangeButton.isSelected());
                }
                case 1: {
                    return Bundle.getMessage("ButtonEdit");
                }
                case 2: {
                    if (!ConditionalEditFrame.this._inActReorder) {
                        return Bundle.getMessage("ButtonDelete");
                    }
                    if (ConditionalEditFrame.this._nextInOrder == 0) {
                        return Bundle.getMessage("ButtonFirst");
                    }
                    if (ConditionalEditFrame.this._nextInOrder <= row) {
                        return Bundle.getMessage("ButtonNext");
                    }
                    return Integer.toString(row + 1);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 1) {
                class WindowMaker
                implements Runnable {
                    private int _row;

                    WindowMaker(int r) {
                        this._row = r;
                    }

                    @Override
                    public void run() {
                        ConditionalEditFrame.this.makeEditActionWindow(this._row);
                    }
                }
                WindowMaker t = new WindowMaker(row);
                SwingUtilities.invokeLater(t);
            } else if (col == 2) {
                if (ConditionalEditFrame.this._inActReorder) {
                    ConditionalEditFrame.this.swapActions(row);
                } else {
                    ConditionalEditFrame.this.deleteActionPressed(row);
                }
            }
        }
    }

    class ActionTypeListener
    implements ActionListener {
        Conditional.ItemType _itemType;

        ActionTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Conditional.ItemType select1 = ConditionalEditFrame.this._actionItemBox.getItemAt(ConditionalEditFrame.this._actionItemBox.getSelectedIndex());
            Conditional.Action select2 = ConditionalEditFrame.this._actionTypeBox.getItemAt(ConditionalEditFrame.this._actionTypeBox.getSelectedIndex());
            log.debug("ActionTypeListener: actionItemType= {}, _itemType= {}, action= {}", new Object[]{select1, this._itemType, select2});
            if (select1 != this._itemType) {
                log.debug("ActionTypeListener actionItem selection ({}) != expected actionItem ({})", (Object)select1, (Object)this._itemType);
            }
            if (ConditionalEditFrame.this._curAction != null && select1 != Conditional.ItemType.NONE && this._itemType == select1) {
                String text;
                ConditionalEditFrame.this._curAction.setType(select2);
                if (select1 == this._itemType && (text = ConditionalEditFrame.this._actionNameField.getText()) != null && text.length() > 0) {
                    ConditionalEditFrame.this._curAction.setDeviceName(text);
                }
                ConditionalEditFrame.this.actionItemChanged(this._itemType);
                ConditionalEditFrame.this.initializeActionVariables();
                ConditionalEditFrame.this._dataChanged = true;
            }
        }

        public void setItemType(Conditional.ItemType type) {
            this._itemType = type;
        }
    }

    public class VariableTableModel
    extends AbstractTableModel {
        public static final int ROWNUM_COLUMN = 0;
        public static final int AND_COLUMN = 1;
        public static final int NOT_COLUMN = 2;
        public static final int DESCRIPTION_COLUMN = 3;
        public static final int STATE_COLUMN = 4;
        public static final int TRIGGERS_COLUMN = 5;
        public static final int EDIT_COLUMN = 6;
        public static final int DELETE_COLUMN = 7;

        @Override
        public Class<?> getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return JComboBox.class;
                }
                case 2: {
                    return JComboBox.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return String.class;
                }
                case 5: {
                    return Boolean.class;
                }
                case 6: 
                case 7: {
                    return JButton.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public int getRowCount() {
            return ConditionalEditFrame.this._variableList.size();
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            switch (c) {
                case 0: 
                case 3: 
                case 4: {
                    return false;
                }
                case 1: {
                    return ConditionalEditFrame.this._logicType == Conditional.AntecedentOperator.MIXED;
                }
                case 2: 
                case 5: {
                    return true;
                }
                case 6: {
                    return !ConditionalEditFrame.this._inVarReorder;
                }
                case 7: {
                    return !ConditionalEditFrame.this._inVarReorder || r >= ConditionalEditFrame.this._nextInOrder;
                }
            }
            return false;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("ColumnLabelRow");
                }
                case 1: {
                    return Bundle.getMessage("ColumnLabelOperator");
                }
                case 2: {
                    return Bundle.getMessage("ColumnLabelNot");
                }
                case 3: {
                    return Bundle.getMessage("ColumnLabelDescription");
                }
                case 4: {
                    return Bundle.getMessage("ColumnState");
                }
                case 5: {
                    return Bundle.getMessage("ColumnLabelTriggersCalculation");
                }
                case 6: {
                    return "";
                }
                case 7: {
                    return "";
                }
            }
            return "";
        }

        public int getPreferredWidth(int col) {
            if (col == 3) {
                return 400;
            }
            return 10;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= ConditionalEditFrame.this._variableList.size()) {
                return null;
            }
            ConditionalVariable variable = (ConditionalVariable)ConditionalEditFrame.this._variableList.get(row);
            switch (col) {
                case 0: {
                    return "R" + (row + 1);
                }
                case 1: {
                    if (row == 0) {
                        return "";
                    }
                    return variable.getOpernString();
                }
                case 2: {
                    if (!variable.isNegated()) break;
                    return Bundle.getMessage("LogicNOT");
                }
                case 3: {
                    return variable.toString();
                }
                case 4: {
                    switch (variable.getState()) {
                        case 4: {
                            return Bundle.getMessage("True");
                        }
                        case 2: {
                            return Bundle.getMessage("False");
                        }
                        case 1: {
                            return Bundle.getMessage("BeanStateUnknown");
                        }
                    }
                    log.warn("Unhandled state type: {}", (Object)variable.getState());
                    break;
                }
                case 5: {
                    return variable.doTriggerActions();
                }
                case 6: {
                    return Bundle.getMessage("ButtonEdit");
                }
                case 7: {
                    if (!ConditionalEditFrame.this._inVarReorder) {
                        return Bundle.getMessage("ButtonDelete");
                    }
                    if (ConditionalEditFrame.this._nextInOrder == 0) {
                        return Bundle.getMessage("ButtonFirst");
                    }
                    if (ConditionalEditFrame.this._nextInOrder <= row) {
                        return Bundle.getMessage("ButtonNext");
                    }
                    return Integer.toString(row + 1);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row >= ConditionalEditFrame.this._variableList.size()) {
                return;
            }
            ConditionalVariable variable = (ConditionalVariable)ConditionalEditFrame.this._variableList.get(row);
            switch (col) {
                case 1: {
                    ConditionalEditFrame.this.variableOperatorChanged(row, (String)value);
                    break;
                }
                case 2: {
                    ConditionalEditFrame.this.variableNegationChanged(row, (String)value);
                    break;
                }
                case 4: {
                    String state = (String)value;
                    if (state.equals(Bundle.getMessage("True").toUpperCase().trim())) {
                        variable.setState(Conditional.State.TRUE.getIntValue());
                        break;
                    }
                    if (state.equals(Bundle.getMessage("False").toUpperCase().trim())) {
                        variable.setState(Conditional.State.FALSE.getIntValue());
                        break;
                    }
                    variable.setState(Conditional.State.UNKNOWN.getIntValue());
                    break;
                }
                case 5: {
                    variable.setTriggerActions(!variable.doTriggerActions());
                    break;
                }
                case 6: {
                    if (LRouteTableAction.getLogixInitializer().equals(ConditionalEditFrame.this._parent._curLogix.getSystemName())) {
                        JOptionPane.showMessageDialog(ConditionalEditFrame.this._editVariableFrame, Bundle.getMessage("Error49"), Bundle.getMessage("ErrorTitle"), 0);
                        break;
                    }
                    class WindowMaker
                    implements Runnable {
                        int row;

                        WindowMaker(int r) {
                            this.row = r;
                        }

                        @Override
                        public void run() {
                            ConditionalEditFrame.this.makeEditVariableWindow(this.row);
                        }
                    }
                    WindowMaker t = new WindowMaker(row);
                    SwingUtilities.invokeLater(t);
                    break;
                }
                case 7: {
                    if (ConditionalEditFrame.this._inVarReorder) {
                        ConditionalEditFrame.this.swapVariables(row);
                        break;
                    }
                    ConditionalEditFrame.this.deleteVariablePressed(row);
                    break;
                }
            }
        }
    }
}

